//
//Copyright 2022 Google LLC
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//https://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v4.23.4
// source: protos/configuration/configuration.proto

package configuration

import (
	instanceinfo "github.com/GoogleCloudPlatform/sapagent/protos/instanceinfo"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type RunOn int32

const (
	RunOn_RUN_ON_UNSPECIFIED RunOn = 0
	RunOn_PRIMARY            RunOn = 1
	RunOn_SECONDARY          RunOn = 2
	RunOn_ALL                RunOn = 3
)

// Enum value maps for RunOn.
var (
	RunOn_name = map[int32]string{
		0: "RUN_ON_UNSPECIFIED",
		1: "PRIMARY",
		2: "SECONDARY",
		3: "ALL",
	}
	RunOn_value = map[string]int32{
		"RUN_ON_UNSPECIFIED": 0,
		"PRIMARY":            1,
		"SECONDARY":          2,
		"ALL":                3,
	}
)

func (x RunOn) Enum() *RunOn {
	p := new(RunOn)
	*p = x
	return p
}

func (x RunOn) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RunOn) Descriptor() protoreflect.EnumDescriptor {
	return file_protos_configuration_configuration_proto_enumTypes[0].Descriptor()
}

func (RunOn) Type() protoreflect.EnumType {
	return &file_protos_configuration_configuration_proto_enumTypes[0]
}

func (x RunOn) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RunOn.Descriptor instead.
func (RunOn) EnumDescriptor() ([]byte, []int) {
	return file_protos_configuration_configuration_proto_rawDescGZIP(), []int{0}
}

type MetricType int32

const (
	MetricType_METRIC_UNSPECIFIED MetricType = 0
	MetricType_METRIC_LABEL       MetricType = 1
	MetricType_METRIC_GAUGE       MetricType = 2
	MetricType_METRIC_CUMULATIVE  MetricType = 3
)

// Enum value maps for MetricType.
var (
	MetricType_name = map[int32]string{
		0: "METRIC_UNSPECIFIED",
		1: "METRIC_LABEL",
		2: "METRIC_GAUGE",
		3: "METRIC_CUMULATIVE",
	}
	MetricType_value = map[string]int32{
		"METRIC_UNSPECIFIED": 0,
		"METRIC_LABEL":       1,
		"METRIC_GAUGE":       2,
		"METRIC_CUMULATIVE":  3,
	}
)

func (x MetricType) Enum() *MetricType {
	p := new(MetricType)
	*p = x
	return p
}

func (x MetricType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetricType) Descriptor() protoreflect.EnumDescriptor {
	return file_protos_configuration_configuration_proto_enumTypes[1].Descriptor()
}

func (MetricType) Type() protoreflect.EnumType {
	return &file_protos_configuration_configuration_proto_enumTypes[1]
}

func (x MetricType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetricType.Descriptor instead.
func (MetricType) EnumDescriptor() ([]byte, []int) {
	return file_protos_configuration_configuration_proto_rawDescGZIP(), []int{1}
}

type ValueType int32

const (
	ValueType_VALUE_UNSPECIFIED ValueType = 0
	ValueType_VALUE_BOOL        ValueType = 1
	ValueType_VALUE_INT64       ValueType = 2
	ValueType_VALUE_STRING      ValueType = 3
	ValueType_VALUE_DOUBLE      ValueType = 4
)

// Enum value maps for ValueType.
var (
	ValueType_name = map[int32]string{
		0: "VALUE_UNSPECIFIED",
		1: "VALUE_BOOL",
		2: "VALUE_INT64",
		3: "VALUE_STRING",
		4: "VALUE_DOUBLE",
	}
	ValueType_value = map[string]int32{
		"VALUE_UNSPECIFIED": 0,
		"VALUE_BOOL":        1,
		"VALUE_INT64":       2,
		"VALUE_STRING":      3,
		"VALUE_DOUBLE":      4,
	}
)

func (x ValueType) Enum() *ValueType {
	p := new(ValueType)
	*p = x
	return p
}

func (x ValueType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ValueType) Descriptor() protoreflect.EnumDescriptor {
	return file_protos_configuration_configuration_proto_enumTypes[2].Descriptor()
}

func (ValueType) Type() protoreflect.EnumType {
	return &file_protos_configuration_configuration_proto_enumTypes[2]
}

func (x ValueType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ValueType.Descriptor instead.
func (ValueType) EnumDescriptor() ([]byte, []int) {
	return file_protos_configuration_configuration_proto_rawDescGZIP(), []int{2}
}

type TargetEnvironment int32

const (
	TargetEnvironment_TARGET_ENVIRONMENT_UNSPECIFIED TargetEnvironment = 0
	TargetEnvironment_PRODUCTION                     TargetEnvironment = 1
	TargetEnvironment_STAGING                        TargetEnvironment = 2
	TargetEnvironment_DEVELOPMENT                    TargetEnvironment = 3
	TargetEnvironment_INTEGRATION                    TargetEnvironment = 4
	TargetEnvironment_AUTOPUSH                       TargetEnvironment = 5
)

// Enum value maps for TargetEnvironment.
var (
	TargetEnvironment_name = map[int32]string{
		0: "TARGET_ENVIRONMENT_UNSPECIFIED",
		1: "PRODUCTION",
		2: "STAGING",
		3: "DEVELOPMENT",
		4: "INTEGRATION",
		5: "AUTOPUSH",
	}
	TargetEnvironment_value = map[string]int32{
		"TARGET_ENVIRONMENT_UNSPECIFIED": 0,
		"PRODUCTION":                     1,
		"STAGING":                        2,
		"DEVELOPMENT":                    3,
		"INTEGRATION":                    4,
		"AUTOPUSH":                       5,
	}
)

func (x TargetEnvironment) Enum() *TargetEnvironment {
	p := new(TargetEnvironment)
	*p = x
	return p
}

func (x TargetEnvironment) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TargetEnvironment) Descriptor() protoreflect.EnumDescriptor {
	return file_protos_configuration_configuration_proto_enumTypes[3].Descriptor()
}

func (TargetEnvironment) Type() protoreflect.EnumType {
	return &file_protos_configuration_configuration_proto_enumTypes[3]
}

func (x TargetEnvironment) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TargetEnvironment.Descriptor instead.
func (TargetEnvironment) EnumDescriptor() ([]byte, []int) {
	return file_protos_configuration_configuration_proto_rawDescGZIP(), []int{3}
}

type Configuration_LogLevel int32

const (
	Configuration_UNDEFINED Configuration_LogLevel = 0
	Configuration_DEBUG     Configuration_LogLevel = 1
	Configuration_INFO      Configuration_LogLevel = 2
	Configuration_WARNING   Configuration_LogLevel = 3
	Configuration_ERROR     Configuration_LogLevel = 4
)

// Enum value maps for Configuration_LogLevel.
var (
	Configuration_LogLevel_name = map[int32]string{
		0: "UNDEFINED",
		1: "DEBUG",
		2: "INFO",
		3: "WARNING",
		4: "ERROR",
	}
	Configuration_LogLevel_value = map[string]int32{
		"UNDEFINED": 0,
		"DEBUG":     1,
		"INFO":      2,
		"WARNING":   3,
		"ERROR":     4,
	}
)

func (x Configuration_LogLevel) Enum() *Configuration_LogLevel {
	p := new(Configuration_LogLevel)
	*p = x
	return p
}

func (x Configuration_LogLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Configuration_LogLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_protos_configuration_configuration_proto_enumTypes[4].Descriptor()
}

func (Configuration_LogLevel) Type() protoreflect.EnumType {
	return &file_protos_configuration_configuration_proto_enumTypes[4]
}

func (x Configuration_LogLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Configuration_LogLevel.Descriptor instead.
func (Configuration_LogLevel) EnumDescriptor() ([]byte, []int) {
	return file_protos_configuration_configuration_proto_rawDescGZIP(), []int{0, 0}
}

type Configuration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ProvideSapHostAgentMetrics  *wrapperspb.BoolValue         `protobuf:"bytes,1,opt,name=provide_sap_host_agent_metrics,json=provideSapHostAgentMetrics,proto3" json:"provide_sap_host_agent_metrics,omitempty"`
	BareMetal                   bool                          `protobuf:"varint,2,opt,name=bare_metal,json=bareMetal,proto3" json:"bare_metal,omitempty"`
	ServiceEndpointOverride     string                        `protobuf:"bytes,3,opt,name=service_endpoint_override,json=serviceEndpointOverride,proto3" json:"service_endpoint_override,omitempty"`
	LogLevel                    Configuration_LogLevel        `protobuf:"varint,4,opt,name=log_level,json=logLevel,proto3,enum=sapagent.protos.configuration.Configuration_LogLevel" json:"log_level,omitempty"`
	CollectionConfiguration     *CollectionConfiguration      `protobuf:"bytes,5,opt,name=collection_configuration,json=collectionConfiguration,proto3" json:"collection_configuration,omitempty"`
	CloudProperties             *instanceinfo.CloudProperties `protobuf:"bytes,6,opt,name=cloud_properties,json=cloudProperties,proto3" json:"cloud_properties,omitempty"`
	AgentProperties             *AgentProperties              `protobuf:"bytes,7,opt,name=agent_properties,json=agentProperties,proto3" json:"agent_properties,omitempty"`
	HanaMonitoringConfiguration *HANAMonitoringConfiguration  `protobuf:"bytes,8,opt,name=hana_monitoring_configuration,json=hanaMonitoringConfiguration,proto3" json:"hana_monitoring_configuration,omitempty"`
	LogToCloud                  *wrapperspb.BoolValue         `protobuf:"bytes,9,opt,name=log_to_cloud,json=logToCloud,proto3" json:"log_to_cloud,omitempty"`
	DiscoveryConfiguration      *DiscoveryConfiguration       `protobuf:"bytes,10,opt,name=discovery_configuration,json=discoveryConfiguration,proto3" json:"discovery_configuration,omitempty"`
	SupportConfiguration        *SupportConfiguration         `protobuf:"bytes,11,opt,name=support_configuration,json=supportConfiguration,proto3" json:"support_configuration,omitempty"`
	UapConfiguration            *UAPConfiguration             `protobuf:"bytes,12,opt,name=uap_configuration,json=uapConfiguration,proto3" json:"uap_configuration,omitempty"`
	GcbdrConfiguration          *GCBDRConfiguration           `protobuf:"bytes,13,opt,name=gcbdr_configuration,json=gcbdrConfiguration,proto3" json:"gcbdr_configuration,omitempty"`
	PubSubActions               *PubSubActions                `protobuf:"bytes,14,opt,name=pub_sub_actions,json=pubSubActions,proto3" json:"pub_sub_actions,omitempty"`
}

func (x *Configuration) Reset() {
	*x = Configuration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_configuration_configuration_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Configuration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Configuration) ProtoMessage() {}

func (x *Configuration) ProtoReflect() protoreflect.Message {
	mi := &file_protos_configuration_configuration_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Configuration.ProtoReflect.Descriptor instead.
func (*Configuration) Descriptor() ([]byte, []int) {
	return file_protos_configuration_configuration_proto_rawDescGZIP(), []int{0}
}

func (x *Configuration) GetProvideSapHostAgentMetrics() *wrapperspb.BoolValue {
	if x != nil {
		return x.ProvideSapHostAgentMetrics
	}
	return nil
}

func (x *Configuration) GetBareMetal() bool {
	if x != nil {
		return x.BareMetal
	}
	return false
}

func (x *Configuration) GetServiceEndpointOverride() string {
	if x != nil {
		return x.ServiceEndpointOverride
	}
	return ""
}

func (x *Configuration) GetLogLevel() Configuration_LogLevel {
	if x != nil {
		return x.LogLevel
	}
	return Configuration_UNDEFINED
}

func (x *Configuration) GetCollectionConfiguration() *CollectionConfiguration {
	if x != nil {
		return x.CollectionConfiguration
	}
	return nil
}

func (x *Configuration) GetCloudProperties() *instanceinfo.CloudProperties {
	if x != nil {
		return x.CloudProperties
	}
	return nil
}

func (x *Configuration) GetAgentProperties() *AgentProperties {
	if x != nil {
		return x.AgentProperties
	}
	return nil
}

func (x *Configuration) GetHanaMonitoringConfiguration() *HANAMonitoringConfiguration {
	if x != nil {
		return x.HanaMonitoringConfiguration
	}
	return nil
}

func (x *Configuration) GetLogToCloud() *wrapperspb.BoolValue {
	if x != nil {
		return x.LogToCloud
	}
	return nil
}

func (x *Configuration) GetDiscoveryConfiguration() *DiscoveryConfiguration {
	if x != nil {
		return x.DiscoveryConfiguration
	}
	return nil
}

func (x *Configuration) GetSupportConfiguration() *SupportConfiguration {
	if x != nil {
		return x.SupportConfiguration
	}
	return nil
}

func (x *Configuration) GetUapConfiguration() *UAPConfiguration {
	if x != nil {
		return x.UapConfiguration
	}
	return nil
}

func (x *Configuration) GetGcbdrConfiguration() *GCBDRConfiguration {
	if x != nil {
		return x.GcbdrConfiguration
	}
	return nil
}

func (x *Configuration) GetPubSubActions() *PubSubActions {
	if x != nil {
		return x.PubSubActions
	}
	return nil
}

type CollectionConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CollectWorkloadValidationMetrics   *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=collect_workload_validation_metrics,json=collectWorkloadValidationMetrics,proto3" json:"collect_workload_validation_metrics,omitempty"`
	WorkloadValidationMetricsFrequency int64                 `protobuf:"varint,2,opt,name=workload_validation_metrics_frequency,json=workloadValidationMetricsFrequency,proto3" json:"workload_validation_metrics_frequency,omitempty"`
	CollectProcessMetrics              bool                  `protobuf:"varint,3,opt,name=collect_process_metrics,json=collectProcessMetrics,proto3" json:"collect_process_metrics,omitempty"`
	ProcessMetricsFrequency            int64                 `protobuf:"varint,4,opt,name=process_metrics_frequency,json=processMetricsFrequency,proto3" json:"process_metrics_frequency,omitempty"`
	// Deprecated: Marked as deprecated in protos/configuration/configuration.proto.
	ProcessMetricsSendFrequency        int64                               `protobuf:"varint,5,opt,name=process_metrics_send_frequency,json=processMetricsSendFrequency,proto3" json:"process_metrics_send_frequency,omitempty"`
	WorkloadValidationRemoteCollection *WorkloadValidationRemoteCollection `protobuf:"bytes,6,opt,name=workload_validation_remote_collection,json=workloadValidationRemoteCollection,proto3" json:"workload_validation_remote_collection,omitempty"`
	CollectExperimentalMetrics         bool                                `protobuf:"varint,7,opt,name=collect_experimental_metrics,json=collectExperimentalMetrics,proto3" json:"collect_experimental_metrics,omitempty"`
	HanaMetricsConfig                  *HANAMetricsConfig                  `protobuf:"bytes,8,opt,name=hana_metrics_config,json=hanaMetricsConfig,proto3" json:"hana_metrics_config,omitempty"` // HANA DB user credentials for process metrics.
	// Deprecated: Marked as deprecated in protos/configuration/configuration.proto.
	SapSystemDiscovery                   *wrapperspb.BoolValue `protobuf:"bytes,9,opt,name=sap_system_discovery,json=sapSystemDiscovery,proto3" json:"sap_system_discovery,omitempty"`
	CollectAgentMetrics                  bool                  `protobuf:"varint,10,opt,name=collect_agent_metrics,json=collectAgentMetrics,proto3" json:"collect_agent_metrics,omitempty"`
	AgentMetricsFrequency                int64                 `protobuf:"varint,11,opt,name=agent_metrics_frequency,json=agentMetricsFrequency,proto3" json:"agent_metrics_frequency,omitempty"`
	HeartbeatFrequency                   int64                 `protobuf:"varint,12,opt,name=heartbeat_frequency,json=heartbeatFrequency,proto3" json:"heartbeat_frequency,omitempty"`
	MissedHeartbeatThreshold             int64                 `protobuf:"varint,13,opt,name=missed_heartbeat_threshold,json=missedHeartbeatThreshold,proto3" json:"missed_heartbeat_threshold,omitempty"`
	AgentHealthFrequency                 int64                 `protobuf:"varint,14,opt,name=agent_health_frequency,json=agentHealthFrequency,proto3" json:"agent_health_frequency,omitempty"`
	WorkloadValidationDbMetricsFrequency int64                 `protobuf:"varint,15,opt,name=workload_validation_db_metrics_frequency,json=workloadValidationDbMetricsFrequency,proto3" json:"workload_validation_db_metrics_frequency,omitempty"`
	WorkloadValidationDbMetricsConfig    *HANAMetricsConfig    `protobuf:"bytes,16,opt,name=workload_validation_db_metrics_config,json=workloadValidationDbMetricsConfig,proto3" json:"workload_validation_db_metrics_config,omitempty"` // HANA DB user credentials for WLM DB based metrics.
	DataWarehouseEndpoint                string                `protobuf:"bytes,17,opt,name=data_warehouse_endpoint,json=dataWarehouseEndpoint,proto3" json:"data_warehouse_endpoint,omitempty"`
	SlowProcessMetricsFrequency          int64                 `protobuf:"varint,18,opt,name=slow_process_metrics_frequency,json=slowProcessMetricsFrequency,proto3" json:"slow_process_metrics_frequency,omitempty"`
	ProcessMetricsToSkip                 []string              `protobuf:"bytes,19,rep,name=process_metrics_to_skip,json=processMetricsToSkip,proto3" json:"process_metrics_to_skip,omitempty"` // List of process metrics to skip during metrics collection
	// Ex: ["/sap/nw/abap/sessions", "/sap/nw/abap/rfc"].
	WorkloadValidationCollectionDefinition *WorkloadValidationCollectionDefinition `protobuf:"bytes,20,opt,name=workload_validation_collection_definition,json=workloadValidationCollectionDefinition,proto3" json:"workload_validation_collection_definition,omitempty"`
	// Deprecated: Marked as deprecated in protos/configuration/configuration.proto.
	CollectReliabilityMetrics *wrapperspb.BoolValue `protobuf:"bytes,21,opt,name=collect_reliability_metrics,json=collectReliabilityMetrics,proto3" json:"collect_reliability_metrics,omitempty"`
	// Deprecated: Marked as deprecated in protos/configuration/configuration.proto.
	ReliabilityMetricsFrequency int64 `protobuf:"varint,22,opt,name=reliability_metrics_frequency,json=reliabilityMetricsFrequency,proto3" json:"reliability_metrics_frequency,omitempty"`
	MetricEventsLogDelaySeconds int64 `protobuf:"varint,23,opt,name=metric_events_log_delay_seconds,json=metricEventsLogDelaySeconds,proto3" json:"metric_events_log_delay_seconds,omitempty"`
}

func (x *CollectionConfiguration) Reset() {
	*x = CollectionConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_configuration_configuration_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CollectionConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CollectionConfiguration) ProtoMessage() {}

func (x *CollectionConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_protos_configuration_configuration_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CollectionConfiguration.ProtoReflect.Descriptor instead.
func (*CollectionConfiguration) Descriptor() ([]byte, []int) {
	return file_protos_configuration_configuration_proto_rawDescGZIP(), []int{1}
}

func (x *CollectionConfiguration) GetCollectWorkloadValidationMetrics() *wrapperspb.BoolValue {
	if x != nil {
		return x.CollectWorkloadValidationMetrics
	}
	return nil
}

func (x *CollectionConfiguration) GetWorkloadValidationMetricsFrequency() int64 {
	if x != nil {
		return x.WorkloadValidationMetricsFrequency
	}
	return 0
}

func (x *CollectionConfiguration) GetCollectProcessMetrics() bool {
	if x != nil {
		return x.CollectProcessMetrics
	}
	return false
}

func (x *CollectionConfiguration) GetProcessMetricsFrequency() int64 {
	if x != nil {
		return x.ProcessMetricsFrequency
	}
	return 0
}

// Deprecated: Marked as deprecated in protos/configuration/configuration.proto.
func (x *CollectionConfiguration) GetProcessMetricsSendFrequency() int64 {
	if x != nil {
		return x.ProcessMetricsSendFrequency
	}
	return 0
}

func (x *CollectionConfiguration) GetWorkloadValidationRemoteCollection() *WorkloadValidationRemoteCollection {
	if x != nil {
		return x.WorkloadValidationRemoteCollection
	}
	return nil
}

func (x *CollectionConfiguration) GetCollectExperimentalMetrics() bool {
	if x != nil {
		return x.CollectExperimentalMetrics
	}
	return false
}

func (x *CollectionConfiguration) GetHanaMetricsConfig() *HANAMetricsConfig {
	if x != nil {
		return x.HanaMetricsConfig
	}
	return nil
}

// Deprecated: Marked as deprecated in protos/configuration/configuration.proto.
func (x *CollectionConfiguration) GetSapSystemDiscovery() *wrapperspb.BoolValue {
	if x != nil {
		return x.SapSystemDiscovery
	}
	return nil
}

func (x *CollectionConfiguration) GetCollectAgentMetrics() bool {
	if x != nil {
		return x.CollectAgentMetrics
	}
	return false
}

func (x *CollectionConfiguration) GetAgentMetricsFrequency() int64 {
	if x != nil {
		return x.AgentMetricsFrequency
	}
	return 0
}

func (x *CollectionConfiguration) GetHeartbeatFrequency() int64 {
	if x != nil {
		return x.HeartbeatFrequency
	}
	return 0
}

func (x *CollectionConfiguration) GetMissedHeartbeatThreshold() int64 {
	if x != nil {
		return x.MissedHeartbeatThreshold
	}
	return 0
}

func (x *CollectionConfiguration) GetAgentHealthFrequency() int64 {
	if x != nil {
		return x.AgentHealthFrequency
	}
	return 0
}

func (x *CollectionConfiguration) GetWorkloadValidationDbMetricsFrequency() int64 {
	if x != nil {
		return x.WorkloadValidationDbMetricsFrequency
	}
	return 0
}

func (x *CollectionConfiguration) GetWorkloadValidationDbMetricsConfig() *HANAMetricsConfig {
	if x != nil {
		return x.WorkloadValidationDbMetricsConfig
	}
	return nil
}

func (x *CollectionConfiguration) GetDataWarehouseEndpoint() string {
	if x != nil {
		return x.DataWarehouseEndpoint
	}
	return ""
}

func (x *CollectionConfiguration) GetSlowProcessMetricsFrequency() int64 {
	if x != nil {
		return x.SlowProcessMetricsFrequency
	}
	return 0
}

func (x *CollectionConfiguration) GetProcessMetricsToSkip() []string {
	if x != nil {
		return x.ProcessMetricsToSkip
	}
	return nil
}

func (x *CollectionConfiguration) GetWorkloadValidationCollectionDefinition() *WorkloadValidationCollectionDefinition {
	if x != nil {
		return x.WorkloadValidationCollectionDefinition
	}
	return nil
}

// Deprecated: Marked as deprecated in protos/configuration/configuration.proto.
func (x *CollectionConfiguration) GetCollectReliabilityMetrics() *wrapperspb.BoolValue {
	if x != nil {
		return x.CollectReliabilityMetrics
	}
	return nil
}

// Deprecated: Marked as deprecated in protos/configuration/configuration.proto.
func (x *CollectionConfiguration) GetReliabilityMetricsFrequency() int64 {
	if x != nil {
		return x.ReliabilityMetricsFrequency
	}
	return 0
}

func (x *CollectionConfiguration) GetMetricEventsLogDelaySeconds() int64 {
	if x != nil {
		return x.MetricEventsLogDelaySeconds
	}
	return 0
}

type AgentProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version         string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	Name            string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	LogUsageMetrics bool   `protobuf:"varint,3,opt,name=log_usage_metrics,json=logUsageMetrics,proto3" json:"log_usage_metrics,omitempty"`
}

func (x *AgentProperties) Reset() {
	*x = AgentProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_configuration_configuration_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AgentProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentProperties) ProtoMessage() {}

func (x *AgentProperties) ProtoReflect() protoreflect.Message {
	mi := &file_protos_configuration_configuration_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentProperties.ProtoReflect.Descriptor instead.
func (*AgentProperties) Descriptor() ([]byte, []int) {
	return file_protos_configuration_configuration_proto_rawDescGZIP(), []int{2}
}

func (x *AgentProperties) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *AgentProperties) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AgentProperties) GetLogUsageMetrics() bool {
	if x != nil {
		return x.LogUsageMetrics
	}
	return false
}

type WorkloadValidationRemoteCollection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RemoteCollectionBinary    string                      `protobuf:"bytes,1,opt,name=remote_collection_binary,json=remoteCollectionBinary,proto3" json:"remote_collection_binary,omitempty"`
	ConcurrentCollections     int64                       `protobuf:"varint,2,opt,name=concurrent_collections,json=concurrentCollections,proto3" json:"concurrent_collections,omitempty"`
	RemoteCollectionGcloud    *RemoteCollectionGcloud     `protobuf:"bytes,3,opt,name=remote_collection_gcloud,json=remoteCollectionGcloud,proto3" json:"remote_collection_gcloud,omitempty"`
	RemoteCollectionSsh       *RemoteCollectionSsh        `protobuf:"bytes,4,opt,name=remote_collection_ssh,json=remoteCollectionSsh,proto3" json:"remote_collection_ssh,omitempty"`
	RemoteCollectionInstances []*RemoteCollectionInstance `protobuf:"bytes,5,rep,name=remote_collection_instances,json=remoteCollectionInstances,proto3" json:"remote_collection_instances,omitempty"`
}

func (x *WorkloadValidationRemoteCollection) Reset() {
	*x = WorkloadValidationRemoteCollection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_configuration_configuration_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkloadValidationRemoteCollection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadValidationRemoteCollection) ProtoMessage() {}

func (x *WorkloadValidationRemoteCollection) ProtoReflect() protoreflect.Message {
	mi := &file_protos_configuration_configuration_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadValidationRemoteCollection.ProtoReflect.Descriptor instead.
func (*WorkloadValidationRemoteCollection) Descriptor() ([]byte, []int) {
	return file_protos_configuration_configuration_proto_rawDescGZIP(), []int{3}
}

func (x *WorkloadValidationRemoteCollection) GetRemoteCollectionBinary() string {
	if x != nil {
		return x.RemoteCollectionBinary
	}
	return ""
}

func (x *WorkloadValidationRemoteCollection) GetConcurrentCollections() int64 {
	if x != nil {
		return x.ConcurrentCollections
	}
	return 0
}

func (x *WorkloadValidationRemoteCollection) GetRemoteCollectionGcloud() *RemoteCollectionGcloud {
	if x != nil {
		return x.RemoteCollectionGcloud
	}
	return nil
}

func (x *WorkloadValidationRemoteCollection) GetRemoteCollectionSsh() *RemoteCollectionSsh {
	if x != nil {
		return x.RemoteCollectionSsh
	}
	return nil
}

func (x *WorkloadValidationRemoteCollection) GetRemoteCollectionInstances() []*RemoteCollectionInstance {
	if x != nil {
		return x.RemoteCollectionInstances
	}
	return nil
}

type RemoteCollectionInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ProjectId      string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	Zone           string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	InstanceId     string `protobuf:"bytes,3,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	InstanceName   string `protobuf:"bytes,4,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	SshHostAddress string `protobuf:"bytes,5,opt,name=ssh_host_address,json=sshHostAddress,proto3" json:"ssh_host_address,omitempty"`
}

func (x *RemoteCollectionInstance) Reset() {
	*x = RemoteCollectionInstance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_configuration_configuration_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoteCollectionInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoteCollectionInstance) ProtoMessage() {}

func (x *RemoteCollectionInstance) ProtoReflect() protoreflect.Message {
	mi := &file_protos_configuration_configuration_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoteCollectionInstance.ProtoReflect.Descriptor instead.
func (*RemoteCollectionInstance) Descriptor() ([]byte, []int) {
	return file_protos_configuration_configuration_proto_rawDescGZIP(), []int{4}
}

func (x *RemoteCollectionInstance) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *RemoteCollectionInstance) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *RemoteCollectionInstance) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *RemoteCollectionInstance) GetInstanceName() string {
	if x != nil {
		return x.InstanceName
	}
	return ""
}

func (x *RemoteCollectionInstance) GetSshHostAddress() string {
	if x != nil {
		return x.SshHostAddress
	}
	return ""
}

type RemoteCollectionGcloud struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// user that will be used when issue gcloud ssh commands, if omitted then the
	// owner of the systemd service is used, usually root.
	SshUsername      string `protobuf:"bytes,1,opt,name=ssh_username,json=sshUsername,proto3" json:"ssh_username,omitempty"`
	UseInternalIp    bool   `protobuf:"varint,2,opt,name=use_internal_ip,json=useInternalIp,proto3" json:"use_internal_ip,omitempty"`
	TunnelThroughIap bool   `protobuf:"varint,3,opt,name=tunnel_through_iap,json=tunnelThroughIap,proto3" json:"tunnel_through_iap,omitempty"`
	GcloudArgs       string `protobuf:"bytes,4,opt,name=gcloud_args,json=gcloudArgs,proto3" json:"gcloud_args,omitempty"`
}

func (x *RemoteCollectionGcloud) Reset() {
	*x = RemoteCollectionGcloud{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_configuration_configuration_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoteCollectionGcloud) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoteCollectionGcloud) ProtoMessage() {}

func (x *RemoteCollectionGcloud) ProtoReflect() protoreflect.Message {
	mi := &file_protos_configuration_configuration_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoteCollectionGcloud.ProtoReflect.Descriptor instead.
func (*RemoteCollectionGcloud) Descriptor() ([]byte, []int) {
	return file_protos_configuration_configuration_proto_rawDescGZIP(), []int{5}
}

func (x *RemoteCollectionGcloud) GetSshUsername() string {
	if x != nil {
		return x.SshUsername
	}
	return ""
}

func (x *RemoteCollectionGcloud) GetUseInternalIp() bool {
	if x != nil {
		return x.UseInternalIp
	}
	return false
}

func (x *RemoteCollectionGcloud) GetTunnelThroughIap() bool {
	if x != nil {
		return x.TunnelThroughIap
	}
	return false
}

func (x *RemoteCollectionGcloud) GetGcloudArgs() string {
	if x != nil {
		return x.GcloudArgs
	}
	return ""
}

type RemoteCollectionSsh struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SshUsername       string `protobuf:"bytes,1,opt,name=ssh_username,json=sshUsername,proto3" json:"ssh_username,omitempty"`
	SshPrivateKeyPath string `protobuf:"bytes,2,opt,name=ssh_private_key_path,json=sshPrivateKeyPath,proto3" json:"ssh_private_key_path,omitempty"`
}

func (x *RemoteCollectionSsh) Reset() {
	*x = RemoteCollectionSsh{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_configuration_configuration_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoteCollectionSsh) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoteCollectionSsh) ProtoMessage() {}

func (x *RemoteCollectionSsh) ProtoReflect() protoreflect.Message {
	mi := &file_protos_configuration_configuration_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoteCollectionSsh.ProtoReflect.Descriptor instead.
func (*RemoteCollectionSsh) Descriptor() ([]byte, []int) {
	return file_protos_configuration_configuration_proto_rawDescGZIP(), []int{6}
}

func (x *RemoteCollectionSsh) GetSshUsername() string {
	if x != nil {
		return x.SshUsername
	}
	return ""
}

func (x *RemoteCollectionSsh) GetSshPrivateKeyPath() string {
	if x != nil {
		return x.SshPrivateKeyPath
	}
	return ""
}

type WorkloadValidationCollectionDefinition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConfigTargetEnvironment TargetEnvironment     `protobuf:"varint,1,opt,name=config_target_environment,json=configTargetEnvironment,proto3,enum=sapagent.protos.configuration.TargetEnvironment" json:"config_target_environment,omitempty"`
	FetchLatestConfig       *wrapperspb.BoolValue `protobuf:"bytes,3,opt,name=fetch_latest_config,json=fetchLatestConfig,proto3" json:"fetch_latest_config,omitempty"`
}

func (x *WorkloadValidationCollectionDefinition) Reset() {
	*x = WorkloadValidationCollectionDefinition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_configuration_configuration_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkloadValidationCollectionDefinition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadValidationCollectionDefinition) ProtoMessage() {}

func (x *WorkloadValidationCollectionDefinition) ProtoReflect() protoreflect.Message {
	mi := &file_protos_configuration_configuration_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadValidationCollectionDefinition.ProtoReflect.Descriptor instead.
func (*WorkloadValidationCollectionDefinition) Descriptor() ([]byte, []int) {
	return file_protos_configuration_configuration_proto_rawDescGZIP(), []int{7}
}

func (x *WorkloadValidationCollectionDefinition) GetConfigTargetEnvironment() TargetEnvironment {
	if x != nil {
		return x.ConfigTargetEnvironment
	}
	return TargetEnvironment_TARGET_ENVIRONMENT_UNSPECIFIED
}

func (x *WorkloadValidationCollectionDefinition) GetFetchLatestConfig() *wrapperspb.BoolValue {
	if x != nil {
		return x.FetchLatestConfig
	}
	return nil
}

type HANAMetricsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	HanaDbUser               string `protobuf:"bytes,1,opt,name=hana_db_user,json=hanaDbUser,proto3" json:"hana_db_user,omitempty"`
	HanaDbPassword           string `protobuf:"bytes,2,opt,name=hana_db_password,json=hanaDbPassword,proto3" json:"hana_db_password,omitempty"`
	HanaDbPasswordSecretName string `protobuf:"bytes,3,opt,name=hana_db_password_secret_name,json=hanaDbPasswordSecretName,proto3" json:"hana_db_password_secret_name,omitempty"`
	Hostname                 string `protobuf:"bytes,4,opt,name=hostname,proto3" json:"hostname,omitempty"`
	Port                     string `protobuf:"bytes,5,opt,name=port,proto3" json:"port,omitempty"`
	HdbuserstoreKey          string `protobuf:"bytes,6,opt,name=hdbuserstore_key,json=hdbuserstoreKey,proto3" json:"hdbuserstore_key,omitempty"`
	Sid                      string `protobuf:"bytes,7,opt,name=sid,proto3" json:"sid,omitempty"`
}

func (x *HANAMetricsConfig) Reset() {
	*x = HANAMetricsConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_configuration_configuration_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HANAMetricsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HANAMetricsConfig) ProtoMessage() {}

func (x *HANAMetricsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_protos_configuration_configuration_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HANAMetricsConfig.ProtoReflect.Descriptor instead.
func (*HANAMetricsConfig) Descriptor() ([]byte, []int) {
	return file_protos_configuration_configuration_proto_rawDescGZIP(), []int{8}
}

func (x *HANAMetricsConfig) GetHanaDbUser() string {
	if x != nil {
		return x.HanaDbUser
	}
	return ""
}

func (x *HANAMetricsConfig) GetHanaDbPassword() string {
	if x != nil {
		return x.HanaDbPassword
	}
	return ""
}

func (x *HANAMetricsConfig) GetHanaDbPasswordSecretName() string {
	if x != nil {
		return x.HanaDbPasswordSecretName
	}
	return ""
}

func (x *HANAMetricsConfig) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *HANAMetricsConfig) GetPort() string {
	if x != nil {
		return x.Port
	}
	return ""
}

func (x *HANAMetricsConfig) GetHdbuserstoreKey() string {
	if x != nil {
		return x.HdbuserstoreKey
	}
	return ""
}

func (x *HANAMetricsConfig) GetSid() string {
	if x != nil {
		return x.Sid
	}
	return ""
}

type HANAMonitoringConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SampleIntervalSec     int64           `protobuf:"varint,1,opt,name=sample_interval_sec,json=sampleIntervalSec,proto3" json:"sample_interval_sec,omitempty"`
	QueryTimeoutSec       int64           `protobuf:"varint,2,opt,name=query_timeout_sec,json=queryTimeoutSec,proto3" json:"query_timeout_sec,omitempty"`
	ExecutionThreads      int64           `protobuf:"varint,3,opt,name=execution_threads,json=executionThreads,proto3" json:"execution_threads,omitempty"`
	HanaInstances         []*HANAInstance `protobuf:"bytes,4,rep,name=hana_instances,json=hanaInstances,proto3" json:"hana_instances,omitempty"`
	Queries               []*Query        `protobuf:"bytes,5,rep,name=queries,proto3" json:"queries,omitempty"`
	Enabled               bool            `protobuf:"varint,6,opt,name=enabled,proto3" json:"enabled,omitempty"`
	SendQueryResponseTime bool            `protobuf:"varint,7,opt,name=send_query_response_time,json=sendQueryResponseTime,proto3" json:"send_query_response_time,omitempty"`
	// If provided, a connection will try to be established to the HANA database
	// before running the queries.
	ConnectionTimeout *durationpb.Duration   `protobuf:"bytes,8,opt,name=connection_timeout,json=connectionTimeout,proto3" json:"connection_timeout,omitempty"`
	MaxConnectRetries *wrapperspb.Int32Value `protobuf:"bytes,9,opt,name=max_connect_retries,json=maxConnectRetries,proto3" json:"max_connect_retries,omitempty"`
}

func (x *HANAMonitoringConfiguration) Reset() {
	*x = HANAMonitoringConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_configuration_configuration_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HANAMonitoringConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HANAMonitoringConfiguration) ProtoMessage() {}

func (x *HANAMonitoringConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_protos_configuration_configuration_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HANAMonitoringConfiguration.ProtoReflect.Descriptor instead.
func (*HANAMonitoringConfiguration) Descriptor() ([]byte, []int) {
	return file_protos_configuration_configuration_proto_rawDescGZIP(), []int{9}
}

func (x *HANAMonitoringConfiguration) GetSampleIntervalSec() int64 {
	if x != nil {
		return x.SampleIntervalSec
	}
	return 0
}

func (x *HANAMonitoringConfiguration) GetQueryTimeoutSec() int64 {
	if x != nil {
		return x.QueryTimeoutSec
	}
	return 0
}

func (x *HANAMonitoringConfiguration) GetExecutionThreads() int64 {
	if x != nil {
		return x.ExecutionThreads
	}
	return 0
}

func (x *HANAMonitoringConfiguration) GetHanaInstances() []*HANAInstance {
	if x != nil {
		return x.HanaInstances
	}
	return nil
}

func (x *HANAMonitoringConfiguration) GetQueries() []*Query {
	if x != nil {
		return x.Queries
	}
	return nil
}

func (x *HANAMonitoringConfiguration) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *HANAMonitoringConfiguration) GetSendQueryResponseTime() bool {
	if x != nil {
		return x.SendQueryResponseTime
	}
	return false
}

func (x *HANAMonitoringConfiguration) GetConnectionTimeout() *durationpb.Duration {
	if x != nil {
		return x.ConnectionTimeout
	}
	return nil
}

func (x *HANAMonitoringConfiguration) GetMaxConnectRetries() *wrapperspb.Int32Value {
	if x != nil {
		return x.MaxConnectRetries
	}
	return nil
}

type HANAInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name                  string        `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Sid                   string        `protobuf:"bytes,2,opt,name=sid,proto3" json:"sid,omitempty"`
	Host                  string        `protobuf:"bytes,3,opt,name=host,proto3" json:"host,omitempty"`
	Port                  string        `protobuf:"bytes,4,opt,name=port,proto3" json:"port,omitempty"`
	User                  string        `protobuf:"bytes,5,opt,name=user,proto3" json:"user,omitempty"`
	Password              string        `protobuf:"bytes,6,opt,name=password,proto3" json:"password,omitempty"`
	SecretName            string        `protobuf:"bytes,7,opt,name=secret_name,json=secretName,proto3" json:"secret_name,omitempty"`
	EnableSsl             bool          `protobuf:"varint,8,opt,name=enable_ssl,json=enableSsl,proto3" json:"enable_ssl,omitempty"`
	HostNameInCertificate string        `protobuf:"bytes,9,opt,name=host_name_in_certificate,json=hostNameInCertificate,proto3" json:"host_name_in_certificate,omitempty"`
	TlsRootCaFile         string        `protobuf:"bytes,10,opt,name=tls_root_ca_file,json=tlsRootCaFile,proto3" json:"tls_root_ca_file,omitempty"`
	HdbuserstoreKey       string        `protobuf:"bytes,11,opt,name=hdbuserstore_key,json=hdbuserstoreKey,proto3" json:"hdbuserstore_key,omitempty"`
	QueriesToRun          *QueriesToRun `protobuf:"bytes,12,opt,name=queries_to_run,json=queriesToRun,proto3" json:"queries_to_run,omitempty"`
	IsLocal               bool          `protobuf:"varint,13,opt,name=is_local,json=isLocal,proto3" json:"is_local,omitempty"`
	InstanceNum           string        `protobuf:"bytes,14,opt,name=instance_num,json=instanceNum,proto3" json:"instance_num,omitempty"`
}

func (x *HANAInstance) Reset() {
	*x = HANAInstance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_configuration_configuration_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HANAInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HANAInstance) ProtoMessage() {}

func (x *HANAInstance) ProtoReflect() protoreflect.Message {
	mi := &file_protos_configuration_configuration_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HANAInstance.ProtoReflect.Descriptor instead.
func (*HANAInstance) Descriptor() ([]byte, []int) {
	return file_protos_configuration_configuration_proto_rawDescGZIP(), []int{10}
}

func (x *HANAInstance) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HANAInstance) GetSid() string {
	if x != nil {
		return x.Sid
	}
	return ""
}

func (x *HANAInstance) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *HANAInstance) GetPort() string {
	if x != nil {
		return x.Port
	}
	return ""
}

func (x *HANAInstance) GetUser() string {
	if x != nil {
		return x.User
	}
	return ""
}

func (x *HANAInstance) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

func (x *HANAInstance) GetSecretName() string {
	if x != nil {
		return x.SecretName
	}
	return ""
}

func (x *HANAInstance) GetEnableSsl() bool {
	if x != nil {
		return x.EnableSsl
	}
	return false
}

func (x *HANAInstance) GetHostNameInCertificate() string {
	if x != nil {
		return x.HostNameInCertificate
	}
	return ""
}

func (x *HANAInstance) GetTlsRootCaFile() string {
	if x != nil {
		return x.TlsRootCaFile
	}
	return ""
}

func (x *HANAInstance) GetHdbuserstoreKey() string {
	if x != nil {
		return x.HdbuserstoreKey
	}
	return ""
}

func (x *HANAInstance) GetQueriesToRun() *QueriesToRun {
	if x != nil {
		return x.QueriesToRun
	}
	return nil
}

func (x *HANAInstance) GetIsLocal() bool {
	if x != nil {
		return x.IsLocal
	}
	return false
}

func (x *HANAInstance) GetInstanceNum() string {
	if x != nil {
		return x.InstanceNum
	}
	return ""
}

type QueriesToRun struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RunAll     bool     `protobuf:"varint,1,opt,name=run_all,json=runAll,proto3" json:"run_all,omitempty"`
	QueryNames []string `protobuf:"bytes,2,rep,name=query_names,json=queryNames,proto3" json:"query_names,omitempty"`
}

func (x *QueriesToRun) Reset() {
	*x = QueriesToRun{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_configuration_configuration_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueriesToRun) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueriesToRun) ProtoMessage() {}

func (x *QueriesToRun) ProtoReflect() protoreflect.Message {
	mi := &file_protos_configuration_configuration_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueriesToRun.ProtoReflect.Descriptor instead.
func (*QueriesToRun) Descriptor() ([]byte, []int) {
	return file_protos_configuration_configuration_proto_rawDescGZIP(), []int{11}
}

func (x *QueriesToRun) GetRunAll() bool {
	if x != nil {
		return x.RunAll
	}
	return false
}

func (x *QueriesToRun) GetQueryNames() []string {
	if x != nil {
		return x.QueryNames
	}
	return nil
}

type Query struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Enabled           bool      `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Name              string    `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Sql               string    `protobuf:"bytes,3,opt,name=sql,proto3" json:"sql,omitempty"`
	SampleIntervalSec int64     `protobuf:"varint,4,opt,name=sample_interval_sec,json=sampleIntervalSec,proto3" json:"sample_interval_sec,omitempty"`
	Columns           []*Column `protobuf:"bytes,5,rep,name=columns,proto3" json:"columns,omitempty"`
	RunOn             RunOn     `protobuf:"varint,6,opt,name=run_on,json=runOn,proto3,enum=sapagent.protos.configuration.RunOn" json:"run_on,omitempty"`
}

func (x *Query) Reset() {
	*x = Query{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_configuration_configuration_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Query) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Query) ProtoMessage() {}

func (x *Query) ProtoReflect() protoreflect.Message {
	mi := &file_protos_configuration_configuration_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Query.ProtoReflect.Descriptor instead.
func (*Query) Descriptor() ([]byte, []int) {
	return file_protos_configuration_configuration_proto_rawDescGZIP(), []int{12}
}

func (x *Query) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *Query) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Query) GetSql() string {
	if x != nil {
		return x.Sql
	}
	return ""
}

func (x *Query) GetSampleIntervalSec() int64 {
	if x != nil {
		return x.SampleIntervalSec
	}
	return 0
}

func (x *Query) GetColumns() []*Column {
	if x != nil {
		return x.Columns
	}
	return nil
}

func (x *Query) GetRunOn() RunOn {
	if x != nil {
		return x.RunOn
	}
	return RunOn_RUN_ON_UNSPECIFIED
}

type Column struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name         string     `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	MetricType   MetricType `protobuf:"varint,2,opt,name=metric_type,json=metricType,proto3,enum=sapagent.protos.configuration.MetricType" json:"metric_type,omitempty"`
	ValueType    ValueType  `protobuf:"varint,3,opt,name=value_type,json=valueType,proto3,enum=sapagent.protos.configuration.ValueType" json:"value_type,omitempty"`
	NameOverride string     `protobuf:"bytes,4,opt,name=name_override,json=nameOverride,proto3" json:"name_override,omitempty"`
}

func (x *Column) Reset() {
	*x = Column{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_configuration_configuration_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Column) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Column) ProtoMessage() {}

func (x *Column) ProtoReflect() protoreflect.Message {
	mi := &file_protos_configuration_configuration_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Column.ProtoReflect.Descriptor instead.
func (*Column) Descriptor() ([]byte, []int) {
	return file_protos_configuration_configuration_proto_rawDescGZIP(), []int{13}
}

func (x *Column) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Column) GetMetricType() MetricType {
	if x != nil {
		return x.MetricType
	}
	return MetricType_METRIC_UNSPECIFIED
}

func (x *Column) GetValueType() ValueType {
	if x != nil {
		return x.ValueType
	}
	return ValueType_VALUE_UNSPECIFIED
}

func (x *Column) GetNameOverride() string {
	if x != nil {
		return x.NameOverride
	}
	return ""
}

type DiscoveryConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EnableDiscovery                *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enable_discovery,json=enableDiscovery,proto3" json:"enable_discovery,omitempty"`
	SystemDiscoveryUpdateFrequency *durationpb.Duration  `protobuf:"bytes,2,opt,name=system_discovery_update_frequency,json=systemDiscoveryUpdateFrequency,proto3" json:"system_discovery_update_frequency,omitempty"`
	SapInstancesUpdateFrequency    *durationpb.Duration  `protobuf:"bytes,3,opt,name=sap_instances_update_frequency,json=sapInstancesUpdateFrequency,proto3" json:"sap_instances_update_frequency,omitempty"`
	EnableWorkloadDiscovery        *wrapperspb.BoolValue `protobuf:"bytes,4,opt,name=enable_workload_discovery,json=enableWorkloadDiscovery,proto3" json:"enable_workload_discovery,omitempty"`
}

func (x *DiscoveryConfiguration) Reset() {
	*x = DiscoveryConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_configuration_configuration_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiscoveryConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryConfiguration) ProtoMessage() {}

func (x *DiscoveryConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_protos_configuration_configuration_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryConfiguration.ProtoReflect.Descriptor instead.
func (*DiscoveryConfiguration) Descriptor() ([]byte, []int) {
	return file_protos_configuration_configuration_proto_rawDescGZIP(), []int{14}
}

func (x *DiscoveryConfiguration) GetEnableDiscovery() *wrapperspb.BoolValue {
	if x != nil {
		return x.EnableDiscovery
	}
	return nil
}

func (x *DiscoveryConfiguration) GetSystemDiscoveryUpdateFrequency() *durationpb.Duration {
	if x != nil {
		return x.SystemDiscoveryUpdateFrequency
	}
	return nil
}

func (x *DiscoveryConfiguration) GetSapInstancesUpdateFrequency() *durationpb.Duration {
	if x != nil {
		return x.SapInstancesUpdateFrequency
	}
	return nil
}

func (x *DiscoveryConfiguration) GetEnableWorkloadDiscovery() *wrapperspb.BoolValue {
	if x != nil {
		return x.EnableWorkloadDiscovery
	}
	return nil
}

type SupportConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SendWorkloadValidationMetricsToCloudMonitoring *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=send_workload_validation_metrics_to_cloud_monitoring,json=sendWorkloadValidationMetricsToCloudMonitoring,proto3" json:"send_workload_validation_metrics_to_cloud_monitoring,omitempty"`
}

func (x *SupportConfiguration) Reset() {
	*x = SupportConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_configuration_configuration_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SupportConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupportConfiguration) ProtoMessage() {}

func (x *SupportConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_protos_configuration_configuration_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupportConfiguration.ProtoReflect.Descriptor instead.
func (*SupportConfiguration) Descriptor() ([]byte, []int) {
	return file_protos_configuration_configuration_proto_rawDescGZIP(), []int{15}
}

func (x *SupportConfiguration) GetSendWorkloadValidationMetricsToCloudMonitoring() *wrapperspb.BoolValue {
	if x != nil {
		return x.SendWorkloadValidationMetricsToCloudMonitoring
	}
	return nil
}

type UAPConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Enabled            *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	TestChannelEnabled *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=test_channel_enabled,json=testChannelEnabled,proto3" json:"test_channel_enabled,omitempty"`
}

func (x *UAPConfiguration) Reset() {
	*x = UAPConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_configuration_configuration_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UAPConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UAPConfiguration) ProtoMessage() {}

func (x *UAPConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_protos_configuration_configuration_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UAPConfiguration.ProtoReflect.Descriptor instead.
func (*UAPConfiguration) Descriptor() ([]byte, []int) {
	return file_protos_configuration_configuration_proto_rawDescGZIP(), []int{16}
}

func (x *UAPConfiguration) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *UAPConfiguration) GetTestChannelEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.TestChannelEnabled
	}
	return nil
}

type GCBDRConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CommunicationEnabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=communication_enabled,json=communicationEnabled,proto3" json:"communication_enabled,omitempty"`
	TestChannelEnabled   *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=test_channel_enabled,json=testChannelEnabled,proto3" json:"test_channel_enabled,omitempty"`
	Environment          TargetEnvironment     `protobuf:"varint,3,opt,name=environment,proto3,enum=sapagent.protos.configuration.TargetEnvironment" json:"environment,omitempty"`
}

func (x *GCBDRConfiguration) Reset() {
	*x = GCBDRConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_configuration_configuration_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GCBDRConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GCBDRConfiguration) ProtoMessage() {}

func (x *GCBDRConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_protos_configuration_configuration_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GCBDRConfiguration.ProtoReflect.Descriptor instead.
func (*GCBDRConfiguration) Descriptor() ([]byte, []int) {
	return file_protos_configuration_configuration_proto_rawDescGZIP(), []int{17}
}

func (x *GCBDRConfiguration) GetCommunicationEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.CommunicationEnabled
	}
	return nil
}

func (x *GCBDRConfiguration) GetTestChannelEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.TestChannelEnabled
	}
	return nil
}

func (x *GCBDRConfiguration) GetEnvironment() TargetEnvironment {
	if x != nil {
		return x.Environment
	}
	return TargetEnvironment_TARGET_ENVIRONMENT_UNSPECIFIED
}

type PubSubActions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ActionsSubscriptionId string `protobuf:"bytes,1,opt,name=actions_subscription_id,json=actionsSubscriptionId,proto3" json:"actions_subscription_id,omitempty"`
	TopicId               string `protobuf:"bytes,2,opt,name=topic_id,json=topicId,proto3" json:"topic_id,omitempty"`
}

func (x *PubSubActions) Reset() {
	*x = PubSubActions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_configuration_configuration_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PubSubActions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PubSubActions) ProtoMessage() {}

func (x *PubSubActions) ProtoReflect() protoreflect.Message {
	mi := &file_protos_configuration_configuration_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PubSubActions.ProtoReflect.Descriptor instead.
func (*PubSubActions) Descriptor() ([]byte, []int) {
	return file_protos_configuration_configuration_proto_rawDescGZIP(), []int{18}
}

func (x *PubSubActions) GetActionsSubscriptionId() string {
	if x != nil {
		return x.ActionsSubscriptionId
	}
	return ""
}

func (x *PubSubActions) GetTopicId() string {
	if x != nil {
		return x.TopicId
	}
	return ""
}

var File_protos_configuration_configuration_proto protoreflect.FileDescriptor

var file_protos_configuration_configuration_proto_rawDesc = []byte{
	0x0a, 0x28, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x73, 0x61, 0x70, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70,
	0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x73, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x69, 0x6e, 0x66, 0x6f, 0x2f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xbe, 0x0a, 0x0a, 0x0d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x5e, 0x0a, 0x1e, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x5f, 0x73,
	0x61, 0x70, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f,
	0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1a, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65,
	0x53, 0x61, 0x70, 0x48, 0x6f, 0x73, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x62, 0x61, 0x72, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x62, 0x61, 0x72, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x6c, 0x12, 0x3a, 0x0a, 0x19, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x17, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x45, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x52,
	0x0a, 0x09, 0x6c, 0x6f, 0x67, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x35, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x08, 0x6c, 0x6f, 0x67, 0x4c, 0x65, 0x76,
	0x65, 0x6c, 0x12, 0x71, 0x0a, 0x18, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x17, 0x63, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x10, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x73, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x0f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12,
	0x59, 0x0a, 0x10, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x73, 0x61, 0x70, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x0f, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x7e, 0x0a, 0x1d, 0x68, 0x61,
	0x6e, 0x61, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x48, 0x41, 0x4e, 0x41, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1b, 0x68,
	0x61, 0x6e, 0x61, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x0a, 0x0c, 0x6c, 0x6f,
	0x67, 0x5f, 0x74, 0x6f, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x6c, 0x6f,
	0x67, 0x54, 0x6f, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x12, 0x6e, 0x0a, 0x17, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x73, 0x61, 0x70, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x16, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x68, 0x0a, 0x15, 0x73, 0x75, 0x70, 0x70,
	0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x5c, 0x0a, 0x11, 0x75, 0x61, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x55, 0x41,
	0x50, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10,
	0x75, 0x61, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x62, 0x0a, 0x13, 0x67, 0x63, 0x62, 0x64, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x43,
	0x42, 0x44, 0x52, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x12, 0x67, 0x63, 0x62, 0x64, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x0f, 0x70, 0x75, 0x62, 0x5f, 0x73, 0x75, 0x62, 0x5f,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x75,
	0x62, 0x53, 0x75, 0x62, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0d, 0x70, 0x75, 0x62,
	0x53, 0x75, 0x62, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x46, 0x0a, 0x08, 0x4c, 0x6f,
	0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x0d, 0x0a, 0x09, 0x55, 0x4e, 0x44, 0x45, 0x46, 0x49,
	0x4e, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x45, 0x42, 0x55, 0x47, 0x10, 0x01,
	0x12, 0x08, 0x0a, 0x04, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x57, 0x41,
	0x52, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52,
	0x10, 0x04, 0x22, 0xd4, 0x0e, 0x0a, 0x17, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x69,
	0x0a, 0x23, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f,
	0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x20, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74,
	0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x51, 0x0a, 0x25, 0x77, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x22, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x36, 0x0a, 0x17,
	0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x63,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x12, 0x3a, 0x0a, 0x19, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x17, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79,
	0x12, 0x47, 0x0a, 0x1e, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x5f, 0x73, 0x65, 0x6e, 0x64, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x42, 0x02, 0x18, 0x01, 0x52, 0x1b, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x53, 0x65, 0x6e, 0x64,
	0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x94, 0x01, 0x0a, 0x25, 0x77, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x73, 0x61, 0x70, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x6d, 0x6f,
	0x74, 0x65, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x22, 0x77, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x40, 0x0a, 0x1c, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x5f, 0x65, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1a, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x45,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x12, 0x60, 0x0a, 0x13, 0x68, 0x61, 0x6e, 0x61, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x48, 0x41, 0x4e, 0x41, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x11, 0x68, 0x61, 0x6e, 0x61, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x50, 0x0a, 0x14, 0x73, 0x61, 0x70, 0x5f, 0x73, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x12, 0x73, 0x61, 0x70, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x44, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x12, 0x32, 0x0a, 0x15, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x41, 0x67,
	0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x36, 0x0a, 0x17, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x5f, 0x66, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x79, 0x12, 0x2f, 0x0a, 0x13, 0x68, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x5f,
	0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x12, 0x68, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x6e, 0x63, 0x79, 0x12, 0x3c, 0x0a, 0x1a, 0x6d, 0x69, 0x73, 0x73, 0x65, 0x64, 0x5f, 0x68, 0x65,
	0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c,
	0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x03, 0x52, 0x18, 0x6d, 0x69, 0x73, 0x73, 0x65, 0x64, 0x48,
	0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c,
	0x64, 0x12, 0x34, 0x0a, 0x16, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x0e, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x14, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x46, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x56, 0x0a, 0x28, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64,
	0x62, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x6e, 0x63, 0x79, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x03, 0x52, 0x24, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x62, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12,
	0x82, 0x01, 0x0a, 0x25, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x62, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x48, 0x41, 0x4e, 0x41, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x21, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x62, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x36, 0x0a, 0x17, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x77, 0x61, 0x72,
	0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18,
	0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x64, 0x61, 0x74, 0x61, 0x57, 0x61, 0x72, 0x65, 0x68,
	0x6f, 0x75, 0x73, 0x65, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x43, 0x0a, 0x1e,
	0x73, 0x6c, 0x6f, 0x77, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x12,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x1b, 0x73, 0x6c, 0x6f, 0x77, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x79, 0x12, 0x35, 0x0a, 0x17, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x73, 0x6b, 0x69, 0x70, 0x18, 0x13, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x14, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x54, 0x6f, 0x53, 0x6b, 0x69, 0x70, 0x12, 0xa0, 0x01, 0x0a, 0x29, 0x77, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x66, 0x69,
	0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x73,
	0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x57, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x26, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5e, 0x0a, 0x1b, 0x63,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x6c, 0x69, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x19, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x52, 0x65, 0x6c, 0x69, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x46, 0x0a, 0x1d, 0x72,
	0x65, 0x6c, 0x69, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x16, 0x20, 0x01,
	0x28, 0x03, 0x42, 0x02, 0x18, 0x01, 0x52, 0x1b, 0x72, 0x65, 0x6c, 0x69, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x6e, 0x63, 0x79, 0x12, 0x44, 0x0a, 0x1f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x73, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x73,
	0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x17, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1b, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x4c, 0x6f, 0x67, 0x44, 0x65, 0x6c,
	0x61, 0x79, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x22, 0x6b, 0x0a, 0x0f, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x6c, 0x6f,
	0x67, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x6c, 0x6f, 0x67, 0x55, 0x73, 0x61, 0x67, 0x65, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x22, 0xe7, 0x03, 0x0a, 0x22, 0x57, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x6d,
	0x6f, 0x74, 0x65, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x38, 0x0a,
	0x18, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x16, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x12, 0x35, 0x0a, 0x16, 0x63, 0x6f, 0x6e, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x63, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x6f,
	0x0a, 0x18, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x67, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x47, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x16, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x43,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x12,
	0x66, 0x0a, 0x15, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x73, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x73, 0x68, 0x52, 0x13, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x73, 0x68, 0x12, 0x77, 0x0a, 0x1b, 0x72, 0x65, 0x6d, 0x6f, 0x74,
	0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x73,
	0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x6d,
	0x6f, 0x74, 0x65, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x19, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x43, 0x6f, 0x6c,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x22, 0xbd, 0x01, 0x0a, 0x18, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x43, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04,
	0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65,
	0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49,
	0x64, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x73, 0x73, 0x68, 0x5f, 0x68, 0x6f,
	0x73, 0x74, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x73, 0x73, 0x68, 0x48, 0x6f, 0x73, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x22, 0xb2, 0x01, 0x0a, 0x16, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x43, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x73,
	0x73, 0x68, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x73, 0x73, 0x68, 0x55, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26,
	0x0a, 0x0f, 0x75, 0x73, 0x65, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69,
	0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x75, 0x73, 0x65, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x12, 0x2c, 0x0a, 0x12, 0x74, 0x75, 0x6e, 0x6e, 0x65, 0x6c,
	0x5f, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x5f, 0x69, 0x61, 0x70, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x10, 0x74, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x54, 0x68, 0x72, 0x6f, 0x75, 0x67,
	0x68, 0x49, 0x61, 0x70, 0x12, 0x1f, 0x0a, 0x0b, 0x67, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x61,
	0x72, 0x67, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x67, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x41, 0x72, 0x67, 0x73, 0x22, 0x69, 0x0a, 0x13, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x43,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x73, 0x68, 0x12, 0x21, 0x0a, 0x0c,
	0x73, 0x73, 0x68, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x73, 0x73, 0x68, 0x55, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x2f, 0x0a, 0x14, 0x73, 0x73, 0x68, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6b,
	0x65, 0x79, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x73,
	0x73, 0x68, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x50, 0x61, 0x74, 0x68,
	0x22, 0x85, 0x02, 0x0a, 0x26, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6c, 0x0a, 0x19, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x65, 0x6e, 0x76,
	0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30,
	0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x17, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x45, 0x6e,
	0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x4a, 0x0a, 0x13, 0x66, 0x65, 0x74,
	0x63, 0x68, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x11, 0x66, 0x65, 0x74, 0x63, 0x68, 0x4c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4a, 0x04, 0x08, 0x02, 0x10, 0x03, 0x52, 0x1b, 0x64, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x66, 0x65, 0x74, 0x63, 0x68, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x73,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x8c, 0x02, 0x0a, 0x11, 0x48, 0x41, 0x4e,
	0x41, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x20,
	0x0a, 0x0c, 0x68, 0x61, 0x6e, 0x61, 0x5f, 0x64, 0x62, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x68, 0x61, 0x6e, 0x61, 0x44, 0x62, 0x55, 0x73, 0x65, 0x72,
	0x12, 0x28, 0x0a, 0x10, 0x68, 0x61, 0x6e, 0x61, 0x5f, 0x64, 0x62, 0x5f, 0x70, 0x61, 0x73, 0x73,
	0x77, 0x6f, 0x72, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x68, 0x61, 0x6e, 0x61,
	0x44, 0x62, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x3e, 0x0a, 0x1c, 0x68, 0x61,
	0x6e, 0x61, 0x5f, 0x64, 0x62, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x73,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x18, 0x68, 0x61, 0x6e, 0x61, 0x44, 0x62, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64,
	0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x68, 0x6f,
	0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f,
	0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x68, 0x64,
	0x62, 0x75, 0x73, 0x65, 0x72, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x68, 0x64, 0x62, 0x75, 0x73, 0x65, 0x72, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x73, 0x69, 0x64, 0x22, 0xa4, 0x04, 0x0a, 0x1b, 0x48, 0x41, 0x4e, 0x41,
	0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x13, 0x73, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x76, 0x61, 0x6c, 0x53, 0x65, 0x63, 0x12, 0x2a, 0x0a, 0x11, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74,
	0x53, 0x65, 0x63, 0x12, 0x2b, 0x0a, 0x11, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x68, 0x72, 0x65, 0x61, 0x64, 0x73,
	0x12, 0x52, 0x0a, 0x0e, 0x68, 0x61, 0x6e, 0x61, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x48, 0x41, 0x4e, 0x41, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x0d, 0x68, 0x61, 0x6e, 0x61, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x12, 0x3e, 0x0a, 0x07, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x07, 0x71, 0x75, 0x65,
	0x72, 0x69, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x37,
	0x0a, 0x18, 0x73, 0x65, 0x6e, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x72, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x15, 0x73, 0x65, 0x6e, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75,
	0x74, 0x12, 0x4b, 0x0a, 0x13, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x5f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11, 0x6d, 0x61, 0x78,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x22, 0xea,
	0x03, 0x0a, 0x0c, 0x48, 0x41, 0x4e, 0x41, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x73, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6f, 0x72,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x75, 0x73, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x75, 0x73, 0x65,
	0x72, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x1f, 0x0a,
	0x0b, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x73, 0x6c, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x09, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x73, 0x6c, 0x12, 0x37, 0x0a,
	0x18, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x69, 0x6e, 0x5f, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x15, 0x68, 0x6f, 0x73, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x49, 0x6e, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x27, 0x0a, 0x10, 0x74, 0x6c, 0x73, 0x5f, 0x72, 0x6f,
	0x6f, 0x74, 0x5f, 0x63, 0x61, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x74, 0x6c, 0x73, 0x52, 0x6f, 0x6f, 0x74, 0x43, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x12,
	0x29, 0x0a, 0x10, 0x68, 0x64, 0x62, 0x75, 0x73, 0x65, 0x72, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f,
	0x6b, 0x65, 0x79, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x68, 0x64, 0x62, 0x75, 0x73,
	0x65, 0x72, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x51, 0x0a, 0x0e, 0x71, 0x75,
	0x65, 0x72, 0x69, 0x65, 0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x72, 0x75, 0x6e, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x54, 0x6f, 0x52, 0x75, 0x6e, 0x52,
	0x0c, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x54, 0x6f, 0x52, 0x75, 0x6e, 0x12, 0x19, 0x0a,
	0x08, 0x69, 0x73, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x07, 0x69, 0x73, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x12, 0x21, 0x0a, 0x0c, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x75, 0x6d, 0x22, 0x48, 0x0a, 0x0c, 0x51,
	0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x54, 0x6f, 0x52, 0x75, 0x6e, 0x12, 0x17, 0x0a, 0x07, 0x72,
	0x75, 0x6e, 0x5f, 0x61, 0x6c, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x72, 0x75,
	0x6e, 0x41, 0x6c, 0x6c, 0x12, 0x1f, 0x0a, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0xf5, 0x01, 0x0a, 0x05, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12,
	0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a,
	0x03, 0x73, 0x71, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x73, 0x71, 0x6c, 0x12,
	0x2e, 0x0a, 0x13, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76,
	0x61, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x73, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x53, 0x65, 0x63, 0x12,
	0x3f, 0x0a, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x52, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73,
	0x12, 0x3b, 0x0a, 0x06, 0x72, 0x75, 0x6e, 0x5f, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x24, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x52, 0x75, 0x6e, 0x4f, 0x6e, 0x52, 0x05, 0x72, 0x75, 0x6e, 0x4f, 0x6e, 0x22, 0xd6, 0x01,
	0x0a, 0x06, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4a, 0x0a, 0x0b,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x29, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x12, 0x47, 0x0a, 0x0a, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x73,
	0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69,
	0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6e, 0x61, 0x6d, 0x65, 0x4f, 0x76,
	0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x22, 0xfd, 0x02, 0x0a, 0x16, 0x44, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x45, 0x0a, 0x10, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f,
	0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x44,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x12, 0x64, 0x0a, 0x21, 0x73, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1e,
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x5e,
	0x0a, 0x1e, 0x73, 0x61, 0x70, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x5f,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x1b, 0x73, 0x61, 0x70, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x56,
	0x0a, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x17, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x44, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x22, 0xa1, 0x01, 0x0a, 0x14, 0x53, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x88, 0x01, 0x0a, 0x34, 0x73, 0x65, 0x6e, 0x64, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x6d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x2e, 0x73, 0x65, 0x6e, 0x64,
	0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x54, 0x6f, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x22, 0x96, 0x01, 0x0a, 0x10, 0x55,
	0x41, 0x50, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x34, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x4c, 0x0a, 0x14, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x12, 0x74, 0x65, 0x73, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x45, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x22, 0x87, 0x02, 0x0a, 0x12, 0x47, 0x43, 0x42, 0x44, 0x52, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4f, 0x0a, 0x15, 0x63, 0x6f,
	0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x14, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x4c, 0x0a, 0x14, 0x74,
	0x65, 0x73, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x12, 0x74, 0x65, 0x73, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x52, 0x0a, 0x0b, 0x65, 0x6e, 0x76,
	0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30,
	0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x62, 0x0a,
	0x0d, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x36,
	0x0a, 0x17, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x15, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x49,
	0x64, 0x2a, 0x44, 0x0a, 0x05, 0x52, 0x75, 0x6e, 0x4f, 0x6e, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x55,
	0x4e, 0x5f, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x52, 0x49, 0x4d, 0x41, 0x52, 0x59, 0x10, 0x01, 0x12,
	0x0d, 0x0a, 0x09, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x41, 0x52, 0x59, 0x10, 0x02, 0x12, 0x07,
	0x0a, 0x03, 0x41, 0x4c, 0x4c, 0x10, 0x03, 0x2a, 0x5f, 0x0a, 0x0a, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x54, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x12, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a,
	0x0c, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43, 0x5f, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x10, 0x01, 0x12,
	0x10, 0x0a, 0x0c, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43, 0x5f, 0x47, 0x41, 0x55, 0x47, 0x45, 0x10,
	0x02, 0x12, 0x15, 0x0a, 0x11, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43, 0x5f, 0x43, 0x55, 0x4d, 0x55,
	0x4c, 0x41, 0x54, 0x49, 0x56, 0x45, 0x10, 0x03, 0x2a, 0x67, 0x0a, 0x09, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a,
	0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x42, 0x4f, 0x4f, 0x4c, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b,
	0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x49, 0x4e, 0x54, 0x36, 0x34, 0x10, 0x02, 0x12, 0x10, 0x0a,
	0x0c, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12,
	0x10, 0x0a, 0x0c, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x44, 0x4f, 0x55, 0x42, 0x4c, 0x45, 0x10,
	0x04, 0x2a, 0x84, 0x01, 0x0a, 0x11, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x45, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x1e, 0x54, 0x41, 0x52, 0x47, 0x45,
	0x54, 0x5f, 0x45, 0x4e, 0x56, 0x49, 0x52, 0x4f, 0x4e, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x50,
	0x52, 0x4f, 0x44, 0x55, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x53,
	0x54, 0x41, 0x47, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x45, 0x56, 0x45,
	0x4c, 0x4f, 0x50, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x54,
	0x45, 0x47, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x41, 0x55,
	0x54, 0x4f, 0x50, 0x55, 0x53, 0x48, 0x10, 0x05, 0x42, 0x3e, 0x5a, 0x3c, 0x67, 0x69, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x73, 0x61, 0x70, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_protos_configuration_configuration_proto_rawDescOnce sync.Once
	file_protos_configuration_configuration_proto_rawDescData = file_protos_configuration_configuration_proto_rawDesc
)

func file_protos_configuration_configuration_proto_rawDescGZIP() []byte {
	file_protos_configuration_configuration_proto_rawDescOnce.Do(func() {
		file_protos_configuration_configuration_proto_rawDescData = protoimpl.X.CompressGZIP(file_protos_configuration_configuration_proto_rawDescData)
	})
	return file_protos_configuration_configuration_proto_rawDescData
}

var file_protos_configuration_configuration_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_protos_configuration_configuration_proto_msgTypes = make([]protoimpl.MessageInfo, 19)
var file_protos_configuration_configuration_proto_goTypes = []interface{}{
	(RunOn)(0),                                     // 0: sapagent.protos.configuration.RunOn
	(MetricType)(0),                                // 1: sapagent.protos.configuration.MetricType
	(ValueType)(0),                                 // 2: sapagent.protos.configuration.ValueType
	(TargetEnvironment)(0),                         // 3: sapagent.protos.configuration.TargetEnvironment
	(Configuration_LogLevel)(0),                    // 4: sapagent.protos.configuration.Configuration.LogLevel
	(*Configuration)(nil),                          // 5: sapagent.protos.configuration.Configuration
	(*CollectionConfiguration)(nil),                // 6: sapagent.protos.configuration.CollectionConfiguration
	(*AgentProperties)(nil),                        // 7: sapagent.protos.configuration.AgentProperties
	(*WorkloadValidationRemoteCollection)(nil),     // 8: sapagent.protos.configuration.WorkloadValidationRemoteCollection
	(*RemoteCollectionInstance)(nil),               // 9: sapagent.protos.configuration.RemoteCollectionInstance
	(*RemoteCollectionGcloud)(nil),                 // 10: sapagent.protos.configuration.RemoteCollectionGcloud
	(*RemoteCollectionSsh)(nil),                    // 11: sapagent.protos.configuration.RemoteCollectionSsh
	(*WorkloadValidationCollectionDefinition)(nil), // 12: sapagent.protos.configuration.WorkloadValidationCollectionDefinition
	(*HANAMetricsConfig)(nil),                      // 13: sapagent.protos.configuration.HANAMetricsConfig
	(*HANAMonitoringConfiguration)(nil),            // 14: sapagent.protos.configuration.HANAMonitoringConfiguration
	(*HANAInstance)(nil),                           // 15: sapagent.protos.configuration.HANAInstance
	(*QueriesToRun)(nil),                           // 16: sapagent.protos.configuration.QueriesToRun
	(*Query)(nil),                                  // 17: sapagent.protos.configuration.Query
	(*Column)(nil),                                 // 18: sapagent.protos.configuration.Column
	(*DiscoveryConfiguration)(nil),                 // 19: sapagent.protos.configuration.DiscoveryConfiguration
	(*SupportConfiguration)(nil),                   // 20: sapagent.protos.configuration.SupportConfiguration
	(*UAPConfiguration)(nil),                       // 21: sapagent.protos.configuration.UAPConfiguration
	(*GCBDRConfiguration)(nil),                     // 22: sapagent.protos.configuration.GCBDRConfiguration
	(*PubSubActions)(nil),                          // 23: sapagent.protos.configuration.PubSubActions
	(*wrapperspb.BoolValue)(nil),                   // 24: google.protobuf.BoolValue
	(*instanceinfo.CloudProperties)(nil),           // 25: sapagent.protos.instanceinfo.CloudProperties
	(*durationpb.Duration)(nil),                    // 26: google.protobuf.Duration
	(*wrapperspb.Int32Value)(nil),                  // 27: google.protobuf.Int32Value
}
var file_protos_configuration_configuration_proto_depIdxs = []int32{
	24, // 0: sapagent.protos.configuration.Configuration.provide_sap_host_agent_metrics:type_name -> google.protobuf.BoolValue
	4,  // 1: sapagent.protos.configuration.Configuration.log_level:type_name -> sapagent.protos.configuration.Configuration.LogLevel
	6,  // 2: sapagent.protos.configuration.Configuration.collection_configuration:type_name -> sapagent.protos.configuration.CollectionConfiguration
	25, // 3: sapagent.protos.configuration.Configuration.cloud_properties:type_name -> sapagent.protos.instanceinfo.CloudProperties
	7,  // 4: sapagent.protos.configuration.Configuration.agent_properties:type_name -> sapagent.protos.configuration.AgentProperties
	14, // 5: sapagent.protos.configuration.Configuration.hana_monitoring_configuration:type_name -> sapagent.protos.configuration.HANAMonitoringConfiguration
	24, // 6: sapagent.protos.configuration.Configuration.log_to_cloud:type_name -> google.protobuf.BoolValue
	19, // 7: sapagent.protos.configuration.Configuration.discovery_configuration:type_name -> sapagent.protos.configuration.DiscoveryConfiguration
	20, // 8: sapagent.protos.configuration.Configuration.support_configuration:type_name -> sapagent.protos.configuration.SupportConfiguration
	21, // 9: sapagent.protos.configuration.Configuration.uap_configuration:type_name -> sapagent.protos.configuration.UAPConfiguration
	22, // 10: sapagent.protos.configuration.Configuration.gcbdr_configuration:type_name -> sapagent.protos.configuration.GCBDRConfiguration
	23, // 11: sapagent.protos.configuration.Configuration.pub_sub_actions:type_name -> sapagent.protos.configuration.PubSubActions
	24, // 12: sapagent.protos.configuration.CollectionConfiguration.collect_workload_validation_metrics:type_name -> google.protobuf.BoolValue
	8,  // 13: sapagent.protos.configuration.CollectionConfiguration.workload_validation_remote_collection:type_name -> sapagent.protos.configuration.WorkloadValidationRemoteCollection
	13, // 14: sapagent.protos.configuration.CollectionConfiguration.hana_metrics_config:type_name -> sapagent.protos.configuration.HANAMetricsConfig
	24, // 15: sapagent.protos.configuration.CollectionConfiguration.sap_system_discovery:type_name -> google.protobuf.BoolValue
	13, // 16: sapagent.protos.configuration.CollectionConfiguration.workload_validation_db_metrics_config:type_name -> sapagent.protos.configuration.HANAMetricsConfig
	12, // 17: sapagent.protos.configuration.CollectionConfiguration.workload_validation_collection_definition:type_name -> sapagent.protos.configuration.WorkloadValidationCollectionDefinition
	24, // 18: sapagent.protos.configuration.CollectionConfiguration.collect_reliability_metrics:type_name -> google.protobuf.BoolValue
	10, // 19: sapagent.protos.configuration.WorkloadValidationRemoteCollection.remote_collection_gcloud:type_name -> sapagent.protos.configuration.RemoteCollectionGcloud
	11, // 20: sapagent.protos.configuration.WorkloadValidationRemoteCollection.remote_collection_ssh:type_name -> sapagent.protos.configuration.RemoteCollectionSsh
	9,  // 21: sapagent.protos.configuration.WorkloadValidationRemoteCollection.remote_collection_instances:type_name -> sapagent.protos.configuration.RemoteCollectionInstance
	3,  // 22: sapagent.protos.configuration.WorkloadValidationCollectionDefinition.config_target_environment:type_name -> sapagent.protos.configuration.TargetEnvironment
	24, // 23: sapagent.protos.configuration.WorkloadValidationCollectionDefinition.fetch_latest_config:type_name -> google.protobuf.BoolValue
	15, // 24: sapagent.protos.configuration.HANAMonitoringConfiguration.hana_instances:type_name -> sapagent.protos.configuration.HANAInstance
	17, // 25: sapagent.protos.configuration.HANAMonitoringConfiguration.queries:type_name -> sapagent.protos.configuration.Query
	26, // 26: sapagent.protos.configuration.HANAMonitoringConfiguration.connection_timeout:type_name -> google.protobuf.Duration
	27, // 27: sapagent.protos.configuration.HANAMonitoringConfiguration.max_connect_retries:type_name -> google.protobuf.Int32Value
	16, // 28: sapagent.protos.configuration.HANAInstance.queries_to_run:type_name -> sapagent.protos.configuration.QueriesToRun
	18, // 29: sapagent.protos.configuration.Query.columns:type_name -> sapagent.protos.configuration.Column
	0,  // 30: sapagent.protos.configuration.Query.run_on:type_name -> sapagent.protos.configuration.RunOn
	1,  // 31: sapagent.protos.configuration.Column.metric_type:type_name -> sapagent.protos.configuration.MetricType
	2,  // 32: sapagent.protos.configuration.Column.value_type:type_name -> sapagent.protos.configuration.ValueType
	24, // 33: sapagent.protos.configuration.DiscoveryConfiguration.enable_discovery:type_name -> google.protobuf.BoolValue
	26, // 34: sapagent.protos.configuration.DiscoveryConfiguration.system_discovery_update_frequency:type_name -> google.protobuf.Duration
	26, // 35: sapagent.protos.configuration.DiscoveryConfiguration.sap_instances_update_frequency:type_name -> google.protobuf.Duration
	24, // 36: sapagent.protos.configuration.DiscoveryConfiguration.enable_workload_discovery:type_name -> google.protobuf.BoolValue
	24, // 37: sapagent.protos.configuration.SupportConfiguration.send_workload_validation_metrics_to_cloud_monitoring:type_name -> google.protobuf.BoolValue
	24, // 38: sapagent.protos.configuration.UAPConfiguration.enabled:type_name -> google.protobuf.BoolValue
	24, // 39: sapagent.protos.configuration.UAPConfiguration.test_channel_enabled:type_name -> google.protobuf.BoolValue
	24, // 40: sapagent.protos.configuration.GCBDRConfiguration.communication_enabled:type_name -> google.protobuf.BoolValue
	24, // 41: sapagent.protos.configuration.GCBDRConfiguration.test_channel_enabled:type_name -> google.protobuf.BoolValue
	3,  // 42: sapagent.protos.configuration.GCBDRConfiguration.environment:type_name -> sapagent.protos.configuration.TargetEnvironment
	43, // [43:43] is the sub-list for method output_type
	43, // [43:43] is the sub-list for method input_type
	43, // [43:43] is the sub-list for extension type_name
	43, // [43:43] is the sub-list for extension extendee
	0,  // [0:43] is the sub-list for field type_name
}

func init() { file_protos_configuration_configuration_proto_init() }
func file_protos_configuration_configuration_proto_init() {
	if File_protos_configuration_configuration_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_protos_configuration_configuration_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Configuration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_configuration_configuration_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CollectionConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_configuration_configuration_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AgentProperties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_configuration_configuration_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkloadValidationRemoteCollection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_configuration_configuration_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoteCollectionInstance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_configuration_configuration_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoteCollectionGcloud); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_configuration_configuration_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoteCollectionSsh); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_configuration_configuration_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkloadValidationCollectionDefinition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_configuration_configuration_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HANAMetricsConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_configuration_configuration_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HANAMonitoringConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_configuration_configuration_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HANAInstance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_configuration_configuration_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueriesToRun); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_configuration_configuration_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Query); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_configuration_configuration_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Column); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_configuration_configuration_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiscoveryConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_configuration_configuration_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SupportConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_configuration_configuration_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UAPConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_configuration_configuration_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GCBDRConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_configuration_configuration_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PubSubActions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_protos_configuration_configuration_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   19,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_protos_configuration_configuration_proto_goTypes,
		DependencyIndexes: file_protos_configuration_configuration_proto_depIdxs,
		EnumInfos:         file_protos_configuration_configuration_proto_enumTypes,
		MessageInfos:      file_protos_configuration_configuration_proto_msgTypes,
	}.Build()
	File_protos_configuration_configuration_proto = out.File
	file_protos_configuration_configuration_proto_rawDesc = nil
	file_protos_configuration_configuration_proto_goTypes = nil
	file_protos_configuration_configuration_proto_depIdxs = nil
}
