// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	json "encoding/json"
	"fmt"
	"time"

	v1alpha1 "github.com/openshift/api/config/v1alpha1"
	configv1alpha1 "github.com/openshift/client-go/config/applyconfigurations/config/v1alpha1"
	scheme "github.com/openshift/client-go/config/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ImagePoliciesGetter has a method to return a ImagePolicyInterface.
// A group's client should implement this interface.
type ImagePoliciesGetter interface {
	ImagePolicies(namespace string) ImagePolicyInterface
}

// ImagePolicyInterface has methods to work with ImagePolicy resources.
type ImagePolicyInterface interface {
	Create(ctx context.Context, imagePolicy *v1alpha1.ImagePolicy, opts v1.CreateOptions) (*v1alpha1.ImagePolicy, error)
	Update(ctx context.Context, imagePolicy *v1alpha1.ImagePolicy, opts v1.UpdateOptions) (*v1alpha1.ImagePolicy, error)
	UpdateStatus(ctx context.Context, imagePolicy *v1alpha1.ImagePolicy, opts v1.UpdateOptions) (*v1alpha1.ImagePolicy, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.ImagePolicy, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.ImagePolicyList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ImagePolicy, err error)
	Apply(ctx context.Context, imagePolicy *configv1alpha1.ImagePolicyApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.ImagePolicy, err error)
	ApplyStatus(ctx context.Context, imagePolicy *configv1alpha1.ImagePolicyApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.ImagePolicy, err error)
	ImagePolicyExpansion
}

// imagePolicies implements ImagePolicyInterface
type imagePolicies struct {
	client rest.Interface
	ns     string
}

// newImagePolicies returns a ImagePolicies
func newImagePolicies(c *ConfigV1alpha1Client, namespace string) *imagePolicies {
	return &imagePolicies{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the imagePolicy, and returns the corresponding imagePolicy object, and an error if there is any.
func (c *imagePolicies) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.ImagePolicy, err error) {
	result = &v1alpha1.ImagePolicy{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("imagepolicies").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ImagePolicies that match those selectors.
func (c *imagePolicies) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.ImagePolicyList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.ImagePolicyList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("imagepolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested imagePolicies.
func (c *imagePolicies) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("imagepolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a imagePolicy and creates it.  Returns the server's representation of the imagePolicy, and an error, if there is any.
func (c *imagePolicies) Create(ctx context.Context, imagePolicy *v1alpha1.ImagePolicy, opts v1.CreateOptions) (result *v1alpha1.ImagePolicy, err error) {
	result = &v1alpha1.ImagePolicy{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("imagepolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(imagePolicy).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a imagePolicy and updates it. Returns the server's representation of the imagePolicy, and an error, if there is any.
func (c *imagePolicies) Update(ctx context.Context, imagePolicy *v1alpha1.ImagePolicy, opts v1.UpdateOptions) (result *v1alpha1.ImagePolicy, err error) {
	result = &v1alpha1.ImagePolicy{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("imagepolicies").
		Name(imagePolicy.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(imagePolicy).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *imagePolicies) UpdateStatus(ctx context.Context, imagePolicy *v1alpha1.ImagePolicy, opts v1.UpdateOptions) (result *v1alpha1.ImagePolicy, err error) {
	result = &v1alpha1.ImagePolicy{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("imagepolicies").
		Name(imagePolicy.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(imagePolicy).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the imagePolicy and deletes it. Returns an error if one occurs.
func (c *imagePolicies) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("imagepolicies").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *imagePolicies) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("imagepolicies").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched imagePolicy.
func (c *imagePolicies) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ImagePolicy, err error) {
	result = &v1alpha1.ImagePolicy{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("imagepolicies").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// Apply takes the given apply declarative configuration, applies it and returns the applied imagePolicy.
func (c *imagePolicies) Apply(ctx context.Context, imagePolicy *configv1alpha1.ImagePolicyApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.ImagePolicy, err error) {
	if imagePolicy == nil {
		return nil, fmt.Errorf("imagePolicy provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(imagePolicy)
	if err != nil {
		return nil, err
	}
	name := imagePolicy.Name
	if name == nil {
		return nil, fmt.Errorf("imagePolicy.Name must be provided to Apply")
	}
	result = &v1alpha1.ImagePolicy{}
	err = c.client.Patch(types.ApplyPatchType).
		Namespace(c.ns).
		Resource("imagepolicies").
		Name(*name).
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *imagePolicies) ApplyStatus(ctx context.Context, imagePolicy *configv1alpha1.ImagePolicyApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.ImagePolicy, err error) {
	if imagePolicy == nil {
		return nil, fmt.Errorf("imagePolicy provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(imagePolicy)
	if err != nil {
		return nil, err
	}

	name := imagePolicy.Name
	if name == nil {
		return nil, fmt.Errorf("imagePolicy.Name must be provided to Apply")
	}

	result = &v1alpha1.ImagePolicy{}
	err = c.client.Patch(types.ApplyPatchType).
		Namespace(c.ns).
		Resource("imagepolicies").
		Name(*name).
		SubResource("status").
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
