/**********************************************************************
 * Example veriusertfs table that is used by many Verilog simulators
 * to register PLI applications that use the TF and ACC libraries of
 * the IEEE 1364 PLI.
 *
 * For the book, "The Verilog PLI Handbook", Chapter 2
 * Copyright 1998, Sutherland HDL Inc, Portland, Oregon.
 *
 *********************************************************************/

/* prototypes of the PLI application routines */
extern int PLIbook_hello_calltf();
extern int PLIbook_ShowVal_checktf(), PLIbook_ShowVal_calltf();

/* the veriusertfs table */
s_tfcell veriusertfs[] =
{
    {usertask,                     /* type of PLI routine */
        0,                         /* user_data value */
        0,                         /* checktf routine */
        0,                         /* sizetf routine */
        PLIbook_hello_calltf,      /* calltf routine */
        0,                         /* misctf routine */
        "$hello",                  /* system task/function name */
        1                          /* forward reference = true */
    },

    {usertask,                     /* type of PLI routine */
        0,                         /* user_data value */
        PLIbook_ShowVal_checktf,   /* checktf routine */
        0,                         /* sizetf routine */
        PLIbook_ShowVal_calltf,    /* calltf routine */
        0,                         /* misctf routine */
        "$show_value",             /* system task/function name */
        1                          /* forward reference = true */
    },

    {0} /*** final entry must be 0 ***/
};

