# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, TYPE_CHECKING

from msrest import Deserializer, Serializer

from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.mgmt.core import AsyncARMPipelineClient

from .. import models
from ._configuration import SecurityInsightsConfiguration
from .operations import ActionsOperations, AlertRuleTemplatesOperations, AlertRulesOperations, AutomationRulesOperations, BookmarksOperations, DataConnectorsOperations, IncidentCommentsOperations, IncidentRelationsOperations, IncidentsOperations, Operations, SentinelOnboardingStatesOperations, ThreatIntelligenceIndicatorMetricsOperations, ThreatIntelligenceIndicatorOperations, ThreatIntelligenceIndicatorsOperations, WatchlistItemsOperations, WatchlistsOperations

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential

class SecurityInsights:    # pylint: disable=too-many-instance-attributes
    """API spec for Microsoft.SecurityInsights (Azure Security Insights) resource provider.

    :ivar incidents: IncidentsOperations operations
    :vartype incidents: azure.mgmt.securityinsight.aio.operations.IncidentsOperations
    :ivar incident_comments: IncidentCommentsOperations operations
    :vartype incident_comments:
     azure.mgmt.securityinsight.aio.operations.IncidentCommentsOperations
    :ivar incident_relations: IncidentRelationsOperations operations
    :vartype incident_relations:
     azure.mgmt.securityinsight.aio.operations.IncidentRelationsOperations
    :ivar threat_intelligence_indicator: ThreatIntelligenceIndicatorOperations operations
    :vartype threat_intelligence_indicator:
     azure.mgmt.securityinsight.aio.operations.ThreatIntelligenceIndicatorOperations
    :ivar threat_intelligence_indicators: ThreatIntelligenceIndicatorsOperations operations
    :vartype threat_intelligence_indicators:
     azure.mgmt.securityinsight.aio.operations.ThreatIntelligenceIndicatorsOperations
    :ivar threat_intelligence_indicator_metrics: ThreatIntelligenceIndicatorMetricsOperations
     operations
    :vartype threat_intelligence_indicator_metrics:
     azure.mgmt.securityinsight.aio.operations.ThreatIntelligenceIndicatorMetricsOperations
    :ivar watchlists: WatchlistsOperations operations
    :vartype watchlists: azure.mgmt.securityinsight.aio.operations.WatchlistsOperations
    :ivar watchlist_items: WatchlistItemsOperations operations
    :vartype watchlist_items: azure.mgmt.securityinsight.aio.operations.WatchlistItemsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.securityinsight.aio.operations.Operations
    :ivar sentinel_onboarding_states: SentinelOnboardingStatesOperations operations
    :vartype sentinel_onboarding_states:
     azure.mgmt.securityinsight.aio.operations.SentinelOnboardingStatesOperations
    :ivar alert_rules: AlertRulesOperations operations
    :vartype alert_rules: azure.mgmt.securityinsight.aio.operations.AlertRulesOperations
    :ivar actions: ActionsOperations operations
    :vartype actions: azure.mgmt.securityinsight.aio.operations.ActionsOperations
    :ivar alert_rule_templates: AlertRuleTemplatesOperations operations
    :vartype alert_rule_templates:
     azure.mgmt.securityinsight.aio.operations.AlertRuleTemplatesOperations
    :ivar bookmarks: BookmarksOperations operations
    :vartype bookmarks: azure.mgmt.securityinsight.aio.operations.BookmarksOperations
    :ivar data_connectors: DataConnectorsOperations operations
    :vartype data_connectors: azure.mgmt.securityinsight.aio.operations.DataConnectorsOperations
    :ivar automation_rules: AutomationRulesOperations operations
    :vartype automation_rules: azure.mgmt.securityinsight.aio.operations.AutomationRulesOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The ID of the target subscription.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2021-10-01". Note that overriding this
     default value may result in unsupported behavior.
    :paramtype api_version: str
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = SecurityInsightsConfiguration(credential=credential, subscription_id=subscription_id, **kwargs)
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.incidents = IncidentsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.incident_comments = IncidentCommentsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.incident_relations = IncidentRelationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.threat_intelligence_indicator = ThreatIntelligenceIndicatorOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.threat_intelligence_indicators = ThreatIntelligenceIndicatorsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.threat_intelligence_indicator_metrics = ThreatIntelligenceIndicatorMetricsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.watchlists = WatchlistsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.watchlist_items = WatchlistItemsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.sentinel_onboarding_states = SentinelOnboardingStatesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.alert_rules = AlertRulesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.actions = ActionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.alert_rule_templates = AlertRuleTemplatesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.bookmarks = BookmarksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.data_connectors = DataConnectorsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.automation_rules = AutomationRulesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )


    def _send_request(
        self,
        request: HttpRequest,
        **kwargs: Any
    ) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/python/protocol/quickstart

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "SecurityInsights":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
