# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from six import with_metaclass
from azure.core import CaseInsensitiveEnumMeta


class AccessTier(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Required for storage accounts where kind = BlobStorage. The access tier used for billing.
    """

    HOT = "Hot"
    COOL = "Cool"

class AccountSasParametersSignedPermission(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The signed permissions for the account SAS. Possible values include: Read (r), Write (w),
    Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p).
    """

    R = "r"
    D = "d"
    W = "w"
    L = "l"
    A = "a"
    C = "c"
    U = "u"
    P = "p"

class AccountSasParametersSignedResourceTypes(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The signed resource types that are accessible with the account SAS. Service (s): Access to
    service-level APIs; Container (c): Access to container-level APIs; Object (o): Access to
    object-level APIs for blobs, queue messages, table entities, and files.
    """

    S = "s"
    C = "c"
    O = "o"

class AccountSasParametersSignedServices(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The signed services accessible with the account SAS. Possible values include: Blob (b), Queue
    (q), Table (t), File (f).
    """

    B = "b"
    Q = "q"
    T = "t"
    F = "f"

class AccountStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Gets the status indicating whether the primary location of the storage account is available or
    unavailable.
    """

    AVAILABLE = "available"
    UNAVAILABLE = "unavailable"

class HttpProtocol(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The protocol permitted for a request made with the account SAS.
    """

    HTTPS_HTTP = "https,http"
    HTTPS = "https"

class KeyPermission(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Permissions for the key -- read-only or full permissions.
    """

    READ = "Read"
    FULL = "Full"

class Kind(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Required. Indicates the type of storage account.
    """

    STORAGE = "Storage"
    BLOB_STORAGE = "BlobStorage"

class Permissions(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The signed permissions for the service SAS. Possible values include: Read (r), Write (w),
    Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p).
    """

    R = "r"
    D = "d"
    W = "w"
    L = "l"
    A = "a"
    C = "c"
    U = "u"
    P = "p"

class ProvisioningState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Gets the status of the storage account at the time the operation was called.
    """

    CREATING = "Creating"
    RESOLVING_DNS = "ResolvingDNS"
    SUCCEEDED = "Succeeded"

class Reason(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Gets the reason that a storage account name could not be used. The Reason element is only
    returned if NameAvailable is false.
    """

    ACCOUNT_NAME_INVALID = "AccountNameInvalid"
    ALREADY_EXISTS = "AlreadyExists"

class SignedResource(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The signed services accessible with the service SAS. Possible values include: Blob (b),
    Container (c), File (f), Share (s).
    """

    B = "b"
    C = "c"
    F = "f"
    S = "s"

class SkuName(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Gets or sets the sku name. Required for account creation; optional for update. Note that in
    older versions, sku name was called accountType.
    """

    STANDARD_LRS = "Standard_LRS"
    STANDARD_GRS = "Standard_GRS"
    STANDARD_RAGRS = "Standard_RAGRS"
    STANDARD_ZRS = "Standard_ZRS"
    PREMIUM_LRS = "Premium_LRS"

class SkuTier(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Gets the sku tier. This is based on the SKU name.
    """

    STANDARD = "Standard"
    PREMIUM = "Premium"

class UsageUnit(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Gets the unit of measurement.
    """

    COUNT = "Count"
    BYTES = "Bytes"
    SECONDS = "Seconds"
    PERCENT = "Percent"
    COUNTS_PER_SECOND = "CountsPerSecond"
    BYTES_PER_SECOND = "BytesPerSecond"
