#include <stdio.h>
#include <dlfcn.h>
#include "sbllog.h"
#include "ttsynth.h"
static void *ttsynth_libptr = NULL;

static void *eci_libptr = NULL;

void ttsynth_close_lib ()
{
  if (ttsynth_libptr != NULL)
    dlclose (ttsynth_libptr);

  if (eci_libptr != NULL)
    dlclose (eci_libptr);
}

int ttsynth_load_lib (char *libpath)
{
  const char *err;

  eci_libptr = dlopen (IBMECI, RTLD_NOW | RTLD_GLOBAL);
  sbl_log ("ibmeci: %s \n", dlerror ());
  if (eci_libptr == NULL)
    return 1;

  ttsynth_libptr = dlopen (libpath, RTLD_NOW | RTLD_GLOBAL);
  if (ttsynth_libptr == NULL)
   {
     sbl_log ("%s", dlerror ());
     sbl_log ("Cannot open ttsynth driver library: %s", libpath);
     dlclose (eci_libptr);
     return 1;
   }
/* load symbols */
  ttsynth_close = dlsym (ttsynth_libptr, "ttsynth_close");
  if ((err = dlerror ()))
   {
     sbl_log ("ttsynth_load_sym: %s ", err);
     return 1;
   }

  ttsynth_init = dlsym (ttsynth_libptr, "ttsynth_init");
  if ((err = dlerror ()))
   {
     sbl_log ("ttsynth_load_sym: %s ", err);
     return 1;
   }

  ttsynth_start = dlsym (ttsynth_libptr, "ttsynth_start");
  if ((err = dlerror ()))
   {
     sbl_log ("ttsynth_load_sym: %s ", err);
     return 1;
   }

  ttsynth_say = dlsym (ttsynth_libptr, "ttsynth_say");
  if ((err = dlerror ()))
   {
     sbl_log ("ttsynth_load_sym: %s ", err);
     return 1;
   }

  ttsynth_param = dlsym (ttsynth_libptr, "ttsynth_param");
  if ((err = dlerror ()))
   {
     sbl_log ("ttsynth_load_sym: %s ", err);
     return 1;
   }

  ttsynth_vol = dlsym (ttsynth_libptr, "ttsynth_vol");
  if ((err = dlerror ()))
   {
     sbl_log ("ttsynth_load_sym: %s ", err);
     return 1;
   }

  ttsynth_frq = dlsym (ttsynth_libptr, "ttsynth_frq");
  if ((err = dlerror ()))
   {
     sbl_log ("ttsynth_load_sym: %s ", err);
     return 1;
   }

  ttsynth_spd = dlsym (ttsynth_libptr, "ttsynth_spd");
  if ((err = dlerror ()))
   {
     sbl_log ("ttsynth_load_sym: %s ", err);
     return 1;
   }

  ttsynth_voice = dlsym (ttsynth_libptr, "ttsynth_voice");
  if ((err = dlerror ()))
   {
     sbl_log ("ttsynth_load_sym: %s ", err);
     return 1;
   }

  ttsynth_lang = dlsym (ttsynth_libptr, "ttsynth_lang");
  if ((err = dlerror ()))
   {
     sbl_log ("ttsynth_load_sym: %s ", err);
     return 1;
   }

  ttsynth_spec = dlsym (ttsynth_libptr, "ttsynth_spec");
  if ((err = dlerror ()))
   {
     sbl_log ("ttsynth_load_sym: %s ", err);
     return 1;
   }

  ttsynth_stop = dlsym (ttsynth_libptr, "ttsynth_stop");
  if ((err = dlerror ()))
   {
     sbl_log ("ttsynth_load_sym: %s ", err);
     return 1;
   }

  ttsynth_punctuation = dlsym (ttsynth_libptr, "ttsynth_punctuation");
  if ((err = dlerror ()))
   {
     sbl_log ("ttsynth_load_sym: %s ", err);
     return 1;
   }
  sbl_log ("ttsynth_load_sym OK\n");
  return 0;
}
