/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.ActionServletWrapper;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.action.DynaActionFormClass;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.upload.MultipartRequestHandler;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.apache.struts.util.ErrorMessages;
import org.apache.struts.util.MessageResources;

public class RequestUtils {
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$struts$util$RequestUtils == null ? (class$org$apache$struts$util$RequestUtils = RequestUtils.class$("org.apache.struts.util.RequestUtils")) : class$org$apache$struts$util$RequestUtils));
    private static MessageResources messages = MessageResources.getMessageResources("org.apache.struts.util.LocalStrings");
    private static final String PREFIXES_KEY = "org.apache.struts.util.PREFIXES";
    private static Method encode = null;
    private static Map scopes = new HashMap();
    static /* synthetic */ Class class$org$apache$struts$util$RequestUtils;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$URLEncoder;

    public static URL absoluteURL(HttpServletRequest request, String path) throws MalformedURLException {
        return new URL(RequestUtils.serverURL(request), request.getContextPath() + path);
    }

    public static Class applicationClass(String className) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = (class$org$apache$struts$util$RequestUtils == null ? (class$org$apache$struts$util$RequestUtils = RequestUtils.class$("org.apache.struts.util.RequestUtils")) : class$org$apache$struts$util$RequestUtils).getClassLoader();
        }
        return classLoader.loadClass(className);
    }

    public static Object applicationInstance(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return RequestUtils.applicationClass(className).newInstance();
    }

    public static Map computeParameters(PageContext pageContext, String paramId, String paramName, String paramProperty, String paramScope, String name, String property, String scope, boolean transaction) throws JspException {
        if (paramId == null && name == null && !transaction) {
            return null;
        }
        Map map = null;
        try {
            if (name != null) {
                map = (Map)RequestUtils.lookup(pageContext, name, property, scope);
            }
        }
        catch (ClassCastException e) {
            RequestUtils.saveException(pageContext, e);
            throw new JspException(messages.getMessage("parameters.multi", (Object)name, (Object)property, (Object)scope));
        }
        catch (JspException e) {
            RequestUtils.saveException(pageContext, e);
            throw e;
        }
        HashMap<String, Object> results = null;
        results = map != null ? new HashMap(map) : new HashMap<String, Object>();
        if (paramId != null && paramName != null) {
            Object paramValue = null;
            try {
                paramValue = RequestUtils.lookup(pageContext, paramName, paramProperty, paramScope);
            }
            catch (JspException e) {
                RequestUtils.saveException(pageContext, e);
                throw e;
            }
            if (paramValue != null) {
                String paramString = null;
                paramString = paramValue instanceof String ? (String)paramValue : paramValue.toString();
                Object mapValue = results.get(paramId);
                if (mapValue == null) {
                    results.put(paramId, paramString);
                } else if (mapValue instanceof String) {
                    String[] newValues = new String[]{(String)mapValue, paramString};
                    results.put(paramId, newValues);
                } else {
                    String[] oldValues = (String[])mapValue;
                    String[] newValues = new String[oldValues.length + 1];
                    System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
                    newValues[oldValues.length] = paramString;
                    results.put(paramId, newValues);
                }
            }
        }
        if (transaction) {
            HttpSession session = pageContext.getSession();
            String token = null;
            if (session != null) {
                token = (String)session.getAttribute("org.apache.struts.action.TOKEN");
            }
            if (token != null) {
                results.put("org.apache.struts.taglib.html.TOKEN", token);
            }
        }
        return results;
    }

    public static String computeURL(PageContext pageContext, String forward, String href, String page, Map params, String anchor, boolean redirect) throws MalformedURLException {
        return RequestUtils.computeURL(pageContext, forward, href, page, null, params, anchor, redirect);
    }

    public static String computeURL(PageContext pageContext, String forward, String href, String page, String action, Map params, String anchor, boolean redirect) throws MalformedURLException {
        return RequestUtils.computeURL(pageContext, forward, href, page, action, params, anchor, redirect, true);
    }

    public static String computeURL(PageContext pageContext, String forward, String href, String page, String action, Map params, String anchor, boolean redirect, boolean encodeSeparator) throws MalformedURLException {
        int hash;
        String temp;
        int n = 0;
        if (forward != null) {
            ++n;
        }
        if (href != null) {
            ++n;
        }
        if (page != null) {
            ++n;
        }
        if (action != null) {
            ++n;
        }
        if (n != 1) {
            throw new MalformedURLException(messages.getMessage("computeURL.specifier"));
        }
        ModuleConfig config = (ModuleConfig)pageContext.getRequest().getAttribute("org.apache.struts.action.MODULE");
        if (config == null) {
            config = (ModuleConfig)pageContext.getServletContext().getAttribute("org.apache.struts.action.MODULE");
            pageContext.getRequest().setAttribute("org.apache.struts.action.MODULE", (Object)config);
        }
        StringBuffer url = new StringBuffer();
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        if (forward != null) {
            ForwardConfig fc = config.findForwardConfig(forward);
            if (fc == null) {
                throw new MalformedURLException(messages.getMessage("computeURL.forward", (Object)forward));
            }
            if (fc.getRedirect()) {
                redirect = true;
            }
            if (fc.getPath().startsWith("/")) {
                url.append(request.getContextPath());
                url.append(RequestUtils.forwardURL(request, fc));
            } else {
                url.append(fc.getPath());
            }
        } else if (href != null) {
            url.append(href);
        } else if (action != null) {
            url.append(RequestUtils.getActionMappingURL(action, pageContext));
        } else {
            url.append(request.getContextPath());
            url.append(RequestUtils.pageURL(request, page));
        }
        if (anchor != null) {
            temp = url.toString();
            hash = temp.indexOf(35);
            if (hash >= 0) {
                url.setLength(hash);
            }
            url.append('#');
            url.append(RequestUtils.encodeURL(anchor));
        }
        if (params != null && params.size() > 0) {
            temp = url.toString();
            hash = temp.indexOf(35);
            if (hash >= 0) {
                anchor = temp.substring(hash + 1);
                url.setLength(hash);
                temp = url.toString();
            } else {
                anchor = null;
            }
            String separator = null;
            separator = redirect ? "&" : (encodeSeparator ? "&amp;" : "&");
            boolean question = temp.indexOf(63) >= 0;
            Iterator keys = params.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = params.get(key);
                if (value == null) {
                    if (!question) {
                        url.append('?');
                        question = true;
                    } else {
                        url.append(separator);
                    }
                    url.append(RequestUtils.encodeURL(key));
                    url.append('=');
                    continue;
                }
                if (value instanceof String) {
                    if (!question) {
                        url.append('?');
                        question = true;
                    } else {
                        url.append(separator);
                    }
                    url.append(RequestUtils.encodeURL(key));
                    url.append('=');
                    url.append(RequestUtils.encodeURL((String)value));
                    continue;
                }
                if (value instanceof String[]) {
                    String[] values = (String[])value;
                    int i = 0;
                    while (i < values.length) {
                        if (!question) {
                            url.append('?');
                            question = true;
                        } else {
                            url.append(separator);
                        }
                        url.append(RequestUtils.encodeURL(key));
                        url.append('=');
                        url.append(RequestUtils.encodeURL(values[i]));
                        ++i;
                    }
                    continue;
                }
                if (!question) {
                    url.append('?');
                    question = true;
                } else {
                    url.append(separator);
                }
                url.append(RequestUtils.encodeURL(key));
                url.append('=');
                url.append(RequestUtils.encodeURL(value.toString()));
            }
            if (anchor != null) {
                url.append('#');
                url.append(RequestUtils.encodeURL(anchor));
            }
        }
        if (pageContext.getSession() != null) {
            HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
            if (redirect) {
                return response.encodeRedirectURL(url.toString());
            }
            return response.encodeURL(url.toString());
        }
        return url.toString();
    }

    public static String getActionMappingName(String action) {
        String value = action;
        int question = action.indexOf("?");
        if (question >= 0) {
            value = value.substring(0, question);
        }
        int slash = value.lastIndexOf("/");
        int period = value.lastIndexOf(".");
        if (period >= 0 && period > slash) {
            value = value.substring(0, period);
        }
        if (value.startsWith("/")) {
            return value;
        }
        return "/" + value;
    }

    public static String getActionMappingURL(String action, PageContext pageContext) {
        String servletMapping;
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        StringBuffer value = new StringBuffer(request.getContextPath());
        ModuleConfig config = (ModuleConfig)pageContext.getRequest().getAttribute("org.apache.struts.action.MODULE");
        if (config != null) {
            value.append(config.getPrefix());
        }
        if ((servletMapping = (String)pageContext.getAttribute("org.apache.struts.action.SERVLET_MAPPING", 4)) != null) {
            String queryString = null;
            int question = action.indexOf("?");
            if (question >= 0) {
                queryString = action.substring(question);
            }
            String actionMapping = RequestUtils.getActionMappingName(action);
            if (servletMapping.startsWith("*.")) {
                value.append(actionMapping);
                value.append(servletMapping.substring(1));
            } else if (servletMapping.endsWith("/*")) {
                value.append(servletMapping.substring(0, servletMapping.length() - 2));
                value.append(actionMapping);
            } else if (servletMapping.equals("/")) {
                value.append(actionMapping);
            }
            if (queryString != null) {
                value.append(queryString);
            }
        } else {
            if (!action.startsWith("/")) {
                value.append("/");
            }
            value.append(action);
        }
        return value.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static ActionForm createActionForm(HttpServletRequest request, ActionMapping mapping, ModuleConfig moduleConfig, ActionServlet servlet) {
        attribute = mapping.getAttribute();
        if (attribute == null) {
            return null;
        }
        name = mapping.getName();
        config = moduleConfig.findFormBeanConfig(name);
        if (config == null) {
            return null;
        }
        if (RequestUtils.log.isDebugEnabled()) {
            RequestUtils.log.debug((Object)(" Looking for ActionForm bean instance in scope '" + mapping.getScope() + "' under attribute key '" + attribute + "'"));
        }
        instance = null;
        session = null;
        if ("request".equals(mapping.getScope())) {
            instance = (ActionForm)request.getAttribute(attribute);
        } else {
            session = request.getSession();
            instance = (ActionForm)session.getAttribute(attribute);
        }
        if (instance != null) {
            if (config.getDynamic()) {
                className = ((DynaBean)instance).getDynaClass().getName();
                if (className.equals(config.getName())) {
                    if (RequestUtils.log.isDebugEnabled()) {
                        RequestUtils.log.debug((Object)(" Recycling existing DynaActionForm instance of type '" + className + "'"));
                        RequestUtils.log.trace((Object)(" --> " + instance));
                    }
                    return instance;
                }
            } else {
                try {
                    configClass = RequestUtils.applicationClass(config.getType());
                    if (configClass.isAssignableFrom(instance.getClass())) {
                        if (RequestUtils.log.isDebugEnabled()) {
                            RequestUtils.log.debug((Object)(" Recycling existing ActionForm instance of class '" + instance.getClass().getName() + "'"));
                            RequestUtils.log.trace((Object)(" --> " + instance));
                        }
                        return instance;
                    }
                }
                catch (Throwable t) {
                    RequestUtils.log.error((Object)servlet.getInternal().getMessage("formBean", (Object)config.getType()), t);
                    return null;
                }
            }
        }
        if (config.getDynamic()) {
            try {
                dynaClass = DynaActionFormClass.createDynaActionFormClass(config);
                instance = (ActionForm)dynaClass.newInstance();
                ((DynaActionForm)instance).initialize(mapping);
                if (!RequestUtils.log.isDebugEnabled()) ** GOTO lbl58
                RequestUtils.log.debug((Object)(" Creating new DynaActionForm instance of type '" + config.getType() + "'"));
                RequestUtils.log.trace((Object)(" --> " + instance));
            }
            catch (Throwable t) {
                RequestUtils.log.error((Object)servlet.getInternal().getMessage("formBean", (Object)config.getType()), t);
                return null;
            }
        } else {
            try {
                instance = (ActionForm)RequestUtils.applicationInstance(config.getType());
                if (RequestUtils.log.isDebugEnabled()) {
                    RequestUtils.log.debug((Object)(" Creating new ActionForm instance of type '" + config.getType() + "'"));
                    RequestUtils.log.trace((Object)(" --> " + instance));
                }
            }
            catch (Throwable t) {
                RequestUtils.log.error((Object)servlet.getInternal().getMessage("formBean", (Object)config.getType()), t);
                return null;
            }
        }
lbl58:
        // 3 sources

        instance.setServlet(servlet);
        return instance;
    }

    public static Object lookup(PageContext pageContext, String name, String scopeName) throws JspException {
        if (scopeName == null) {
            return pageContext.findAttribute(name);
        }
        try {
            return pageContext.getAttribute(name, RequestUtils.getScope(scopeName));
        }
        catch (JspException e) {
            RequestUtils.saveException(pageContext, e);
            throw e;
        }
    }

    public static int getScope(String scopeName) throws JspException {
        Integer scope = (Integer)scopes.get(scopeName.toLowerCase());
        if (scope == null) {
            throw new JspException(messages.getMessage("lookup.scope", scope));
        }
        return scope;
    }

    public static Object lookup(PageContext pageContext, String name, String property, String scope) throws JspException {
        Object bean = RequestUtils.lookup(pageContext, name, scope);
        if (bean == null) {
            JspException e = null;
            e = scope == null ? new JspException(messages.getMessage("lookup.bean.any", (Object)name)) : new JspException(messages.getMessage("lookup.bean", (Object)name, (Object)scope));
            RequestUtils.saveException(pageContext, e);
            throw e;
        }
        if (property == null) {
            return bean;
        }
        try {
            return PropertyUtils.getProperty((Object)bean, (String)property);
        }
        catch (IllegalAccessException e) {
            RequestUtils.saveException(pageContext, e);
            throw new JspException(messages.getMessage("lookup.access", (Object)property, (Object)name));
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t == null) {
                t = e;
            }
            RequestUtils.saveException(pageContext, t);
            throw new JspException(messages.getMessage("lookup.target", (Object)property, (Object)name));
        }
        catch (NoSuchMethodException e) {
            RequestUtils.saveException(pageContext, e);
            throw new JspException(messages.getMessage("lookup.method", (Object)property, (Object)name));
        }
    }

    public static Locale retrieveUserLocale(PageContext pageContext, String locale) {
        Locale userLocale = null;
        HttpSession session = pageContext.getSession();
        if (locale == null) {
            locale = "org.apache.struts.action.LOCALE";
        }
        if (session != null) {
            userLocale = (Locale)session.getAttribute(locale);
        }
        if (userLocale == null) {
            userLocale = pageContext.getRequest().getLocale();
        }
        return userLocale;
    }

    public static String message(PageContext pageContext, String bundle, String locale, String key) throws JspException {
        return RequestUtils.message(pageContext, bundle, locale, key, null);
    }

    public static String message(PageContext pageContext, String bundle, String locale, String key, Object[] args) throws JspException {
        MessageResources resources = RequestUtils.retrieveMessageResources(pageContext, bundle, false);
        Locale userLocale = RequestUtils.retrieveUserLocale(pageContext, locale);
        if (args == null) {
            return resources.getMessage(userLocale, key);
        }
        return resources.getMessage(userLocale, key, args);
    }

    private static MessageResources retrieveMessageResources(PageContext pageContext, String bundle, boolean checkPageScope) throws JspException {
        MessageResources resources = null;
        if (bundle == null) {
            bundle = "org.apache.struts.action.MESSAGE";
        }
        if (checkPageScope) {
            resources = (MessageResources)pageContext.getAttribute(bundle, 1);
        }
        if (resources == null) {
            resources = (MessageResources)pageContext.getAttribute(bundle, 2);
        }
        if (resources == null) {
            resources = (MessageResources)pageContext.getAttribute(bundle, 4);
        }
        if (resources == null) {
            JspException e = new JspException(messages.getMessage("message.bundle", (Object)bundle));
            RequestUtils.saveException(pageContext, e);
            throw e;
        }
        return resources;
    }

    public static void populate(Object bean, HttpServletRequest request) throws ServletException {
        RequestUtils.populate(bean, null, null, request);
    }

    public static void populate(Object bean, String prefix, String suffix, HttpServletRequest request) throws ServletException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Enumeration names = null;
        Map multipartParameters = null;
        String contentType = request.getContentType();
        String method = request.getMethod();
        boolean isMultipart = false;
        if (contentType != null && contentType.startsWith("multipart/form-data") && method.equalsIgnoreCase("POST")) {
            if (!(bean instanceof ActionForm)) {
                throw new ServletException("bean that's supposed to be populated from a multipart request is not of type \"org.apache.struts.action.ActionForm\", but type \"" + bean.getClass().getName() + "\"");
            }
            ActionServletWrapper servlet = ((ActionForm)bean).getServletWrapper();
            MultipartRequestHandler multipartHandler = RequestUtils.getMultipartHandler(request);
            ((ActionForm)bean).setMultipartRequestHandler(multipartHandler);
            if (multipartHandler != null) {
                isMultipart = true;
                servlet.setServletFor(multipartHandler);
                multipartHandler.setMapping((ActionMapping)request.getAttribute("org.apache.struts.action.mapping.instance"));
                multipartHandler.handleRequest(request);
                Boolean maxLengthExceeded = (Boolean)request.getAttribute("org.apache.struts.upload.MaxLengthExceeded");
                if (maxLengthExceeded != null && maxLengthExceeded.booleanValue()) {
                    return;
                }
                multipartParameters = RequestUtils.getAllParametersForMultipartRequest(request, multipartHandler);
                names = Collections.enumeration(multipartParameters.keySet());
            }
        }
        if (!isMultipart) {
            names = request.getParameterNames();
        }
        while (names.hasMoreElements()) {
            String name;
            String stripped = name = (String)names.nextElement();
            if (prefix != null) {
                if (!stripped.startsWith(prefix)) continue;
                stripped = stripped.substring(prefix.length());
            }
            if (suffix != null) {
                if (!stripped.endsWith(suffix)) continue;
                stripped = stripped.substring(0, stripped.length() - suffix.length());
            }
            if (isMultipart) {
                properties.put(stripped, multipartParameters.get(name));
                continue;
            }
            properties.put(stripped, request.getParameterValues(name));
        }
        try {
            BeanUtils.populate((Object)bean, properties);
        }
        catch (Exception e) {
            throw new ServletException("BeanUtils.populate", (Throwable)e);
        }
    }

    private static MultipartRequestHandler getMultipartHandler(HttpServletRequest request) throws ServletException {
        ModuleConfig moduleConfig;
        MultipartRequestHandler multipartHandler = null;
        String multipartClass = (String)request.getAttribute("org.apache.struts.action.mapping.multipartclass");
        request.removeAttribute("org.apache.struts.action.mapping.multipartclass");
        if (multipartClass != null) {
            try {
                multipartHandler = (MultipartRequestHandler)RequestUtils.applicationInstance(multipartClass);
            }
            catch (ClassNotFoundException cnfe) {
                log.error((Object)("MultipartRequestHandler class \"" + multipartClass + "\" in mapping class not found, " + "defaulting to global multipart class"));
            }
            catch (InstantiationException ie) {
                log.error((Object)("InstantiaionException when instantiating MultipartRequestHandler \"" + multipartClass + "\", " + "defaulting to global multipart class, exception: " + ie.getMessage()));
            }
            catch (IllegalAccessException iae) {
                log.error((Object)("IllegalAccessException when instantiating MultipartRequestHandler \"" + multipartClass + "\", " + "defaulting to global multipart class, exception: " + iae.getMessage()));
            }
            if (multipartHandler != null) {
                return multipartHandler;
            }
        }
        if ((multipartClass = (moduleConfig = (ModuleConfig)request.getAttribute("org.apache.struts.action.MODULE")).getControllerConfig().getMultipartClass()) != null) {
            try {
                multipartHandler = (MultipartRequestHandler)RequestUtils.applicationInstance(multipartClass);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ServletException("Cannot find multipart class \"" + multipartClass + "\"" + ", exception: " + cnfe.getMessage());
            }
            catch (InstantiationException ie) {
                throw new ServletException("InstantiaionException when instantiating multipart class \"" + multipartClass + "\", exception: " + ie.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new ServletException("IllegalAccessException when instantiating multipart class \"" + multipartClass + "\", exception: " + iae.getMessage());
            }
            if (multipartHandler != null) {
                return multipartHandler;
            }
        }
        return multipartHandler;
    }

    private static Map getAllParametersForMultipartRequest(HttpServletRequest request, MultipartRequestHandler multipartHandler) {
        String key;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Hashtable elements = multipartHandler.getAllElements();
        Enumeration enumeration = elements.keys();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            parameters.put(key, elements.get(key));
        }
        if (request instanceof MultipartRequestWrapper) {
            request = ((MultipartRequestWrapper)request).getRequest();
            enumeration = request.getParameterNames();
            while (enumeration.hasMoreElements()) {
                key = (String)enumeration.nextElement();
                parameters.put(key, request.getParameterValues(key));
            }
        } else {
            log.debug((Object)"Gathering multipart parameters for unwrapped request");
        }
        return parameters;
    }

    public static boolean present(PageContext pageContext, String bundle, String locale, String key) throws JspException {
        MessageResources resources = RequestUtils.retrieveMessageResources(pageContext, bundle, true);
        Locale userLocale = RequestUtils.retrieveUserLocale(pageContext, locale);
        return resources.isPresent(userLocale, key);
    }

    public static String printableURL(URL url) {
        if (url.getHost() != null) {
            return url.toString();
        }
        String file = url.getFile();
        String ref = url.getRef();
        if (ref == null) {
            return file;
        }
        StringBuffer sb = new StringBuffer(file);
        sb.append('#');
        sb.append(ref);
        return sb.toString();
    }

    public static String actionURL(HttpServletRequest request, ActionConfig action, String pattern) {
        StringBuffer sb = new StringBuffer();
        if (pattern.endsWith("/*")) {
            sb.append(pattern.substring(0, pattern.length() - 2));
            sb.append(action.getPath());
        } else if (pattern.startsWith("*.")) {
            ModuleConfig appConfig = (ModuleConfig)request.getAttribute("org.apache.struts.action.MODULE");
            sb.append(appConfig.getPrefix());
            sb.append(action.getPath());
            sb.append(pattern.substring(1));
        } else {
            throw new IllegalArgumentException(pattern);
        }
        return sb.toString();
    }

    public static String forwardURL(HttpServletRequest request, ForwardConfig forward) {
        String path = forward.getPath();
        StringBuffer sb = new StringBuffer();
        if (forward.getContextRelative()) {
            if (!path.startsWith("/")) {
                sb.append("/");
            }
            sb.append(path);
            return sb.toString();
        }
        ModuleConfig moduleConfig = (ModuleConfig)request.getAttribute("org.apache.struts.action.MODULE");
        String forwardPattern = moduleConfig.getControllerConfig().getForwardPattern();
        if (forwardPattern == null) {
            sb.append(moduleConfig.getPrefix());
            if (!path.startsWith("/")) {
                sb.append("/");
            }
            sb.append(path);
        } else {
            boolean dollar = false;
            int i = 0;
            while (i < forwardPattern.length()) {
                char ch = forwardPattern.charAt(i);
                if (dollar) {
                    switch (ch) {
                        case 'M': {
                            sb.append(moduleConfig.getPrefix());
                            break;
                        }
                        case 'P': {
                            if (!path.startsWith("/")) {
                                sb.append("/");
                            }
                            sb.append(path);
                            break;
                        }
                        case '$': {
                            sb.append('$');
                            break;
                        }
                    }
                    dollar = false;
                } else if (ch == '$') {
                    dollar = true;
                } else {
                    sb.append(ch);
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public static String pageURL(HttpServletRequest request, String page) {
        StringBuffer sb = new StringBuffer();
        ModuleConfig moduleConfig = (ModuleConfig)request.getAttribute("org.apache.struts.action.MODULE");
        String pagePattern = moduleConfig.getControllerConfig().getPagePattern();
        if (pagePattern == null) {
            sb.append(moduleConfig.getPrefix());
            sb.append(page);
        } else {
            boolean dollar = false;
            int i = 0;
            while (i < pagePattern.length()) {
                char ch = pagePattern.charAt(i);
                if (dollar) {
                    switch (ch) {
                        case 'M': {
                            sb.append(moduleConfig.getPrefix());
                            break;
                        }
                        case 'P': {
                            sb.append(page);
                            break;
                        }
                        case '$': {
                            sb.append('$');
                            break;
                        }
                    }
                    dollar = false;
                } else if (ch == '$') {
                    dollar = true;
                } else {
                    sb.append(ch);
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public static URL requestURL(HttpServletRequest request) throws MalformedURLException {
        StringBuffer url = new StringBuffer();
        String scheme = request.getScheme();
        int port = request.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(request.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(request.getRequestURI());
        return new URL(url.toString());
    }

    public static URL serverURL(HttpServletRequest request) throws MalformedURLException {
        StringBuffer url = new StringBuffer();
        String scheme = request.getScheme();
        int port = request.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(request.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        return new URL(url.toString());
    }

    public static void saveException(PageContext pageContext, Throwable exception) {
        pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)exception, 2);
    }

    public static void selectApplication(String prefix, HttpServletRequest request, ServletContext context) {
        RequestUtils.selectModule(prefix, request, context);
    }

    public static void selectModule(String prefix, HttpServletRequest request, ServletContext context) {
        ModuleConfig config = (ModuleConfig)context.getAttribute("org.apache.struts.action.MODULE" + prefix);
        if (config != null) {
            request.setAttribute("org.apache.struts.action.MODULE", (Object)config);
        } else {
            request.removeAttribute("org.apache.struts.action.MODULE");
        }
        MessageResources resources = (MessageResources)context.getAttribute("org.apache.struts.action.MESSAGE" + prefix);
        if (resources != null) {
            request.setAttribute("org.apache.struts.action.MESSAGE", (Object)resources);
        } else {
            request.removeAttribute("org.apache.struts.action.MESSAGE");
        }
    }

    public static void selectApplication(HttpServletRequest request, ServletContext context) {
        RequestUtils.selectModule(request, context);
    }

    public static void selectModule(HttpServletRequest request, ServletContext context) {
        String prefix = RequestUtils.getModuleName(request, context);
        RequestUtils.selectModule(prefix, request, context);
    }

    public static String getModuleName(HttpServletRequest request, ServletContext context) {
        String matchPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (matchPath == null) {
            matchPath = request.getServletPath();
        }
        return RequestUtils.getModuleName(matchPath, context);
    }

    public static String getModuleName(String matchPath, ServletContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get module name for path " + matchPath));
        }
        String prefix = "";
        String[] prefixes = RequestUtils.getModulePrefixes(context);
        int lastSlash = 0;
        block0: while (prefix.equals("") && (lastSlash = matchPath.lastIndexOf("/")) > 0) {
            matchPath = matchPath.substring(0, lastSlash);
            int i = 0;
            while (i < prefixes.length) {
                if (matchPath.equals(prefixes[i])) {
                    prefix = prefixes[i];
                    continue block0;
                }
                ++i;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Module name found: " + (prefix.equals("") ? "default" : prefix)));
        }
        return prefix;
    }

    public static ModuleConfig getRequestModuleConfig(HttpServletRequest request) {
        return (ModuleConfig)request.getAttribute("org.apache.struts.action.MODULE");
    }

    public static ModuleConfig getModuleConfig(HttpServletRequest request, ServletContext context) {
        ModuleConfig moduleConfig = (ModuleConfig)request.getAttribute("org.apache.struts.action.MODULE");
        if (moduleConfig == null) {
            moduleConfig = (ModuleConfig)context.getAttribute("org.apache.struts.action.MODULE");
        }
        return moduleConfig;
    }

    public static ModuleConfig getModuleConfig(PageContext pageContext) {
        return RequestUtils.getModuleConfig((HttpServletRequest)pageContext.getRequest(), pageContext.getServletContext());
    }

    public static String[] getApplicationPrefixes(ServletContext context) {
        return RequestUtils.getModulePrefixes(context);
    }

    public static synchronized String[] getModulePrefixes(ServletContext context) {
        String[] prefixes = (String[])context.getAttribute(PREFIXES_KEY);
        if (prefixes != null) {
            return prefixes;
        }
        ArrayList<String> list = new ArrayList<String>();
        Enumeration names = context.getAttributeNames();
        while (names.hasMoreElements()) {
            String prefix;
            String name = (String)names.nextElement();
            if (!name.startsWith("org.apache.struts.action.MODULE") || (prefix = name.substring("org.apache.struts.action.MODULE".length())).length() <= 0) continue;
            list.add(prefix);
        }
        prefixes = list.toArray(new String[list.size()]);
        context.setAttribute(PREFIXES_KEY, (Object)prefixes);
        return prefixes;
    }

    public static ActionMessages getActionMessages(PageContext pageContext, String paramName) throws JspException {
        ActionMessages am;
        block10: {
            am = new ActionMessages();
            Object value = pageContext.findAttribute(paramName);
            try {
                if (value == null) break block10;
                if (value instanceof String) {
                    am.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage((String)value));
                    break block10;
                }
                if (value instanceof String[]) {
                    String[] keys = (String[])value;
                    int i = 0;
                    while (i < keys.length) {
                        am.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(keys[i]));
                        ++i;
                    }
                    break block10;
                }
                if (value instanceof ErrorMessages) {
                    String[] keys = ((ErrorMessages)value).getErrors();
                    if (keys == null) {
                        keys = new String[]{};
                    }
                    int i = 0;
                    while (i < keys.length) {
                        am.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError(keys[i]));
                        ++i;
                    }
                    break block10;
                }
                if (value instanceof ActionMessages) {
                    am = (ActionMessages)value;
                    break block10;
                }
                throw new JspException(messages.getMessage("actionMessages.errors", (Object)value.getClass().getName()));
            }
            catch (JspException e) {
                throw e;
            }
            catch (Exception e) {}
            {
            }
        }
        return am;
    }

    public static ActionErrors getActionErrors(PageContext pageContext, String paramName) throws JspException {
        ActionErrors errors;
        block10: {
            errors = new ActionErrors();
            Object value = pageContext.findAttribute(paramName);
            try {
                if (value == null) break block10;
                if (value instanceof String) {
                    errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError((String)value));
                    break block10;
                }
                if (value instanceof String[]) {
                    String[] keys = (String[])value;
                    int i = 0;
                    while (i < keys.length) {
                        errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError(keys[i]));
                        ++i;
                    }
                    break block10;
                }
                if (value instanceof ErrorMessages) {
                    String[] keys = ((ErrorMessages)value).getErrors();
                    if (keys == null) {
                        keys = new String[]{};
                    }
                    int i = 0;
                    while (i < keys.length) {
                        errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError(keys[i]));
                        ++i;
                    }
                    break block10;
                }
                if (value instanceof ActionErrors) {
                    errors = (ActionErrors)value;
                    break block10;
                }
                throw new JspException(messages.getMessage("actionErrors.errors", (Object)value.getClass().getName()));
            }
            catch (JspException e) {
                throw e;
            }
            catch (Exception e) {
                log.debug((Object)e, (Throwable)e);
            }
        }
        return errors;
    }

    public static String encodeURL(String url) {
        try {
            if (encode != null) {
                return (String)encode.invoke(null, url, "UTF-8");
            }
        }
        catch (IllegalAccessException e) {
            log.debug((Object)"Could not find Java 1.4 encode method.  Using deprecated version.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.debug((Object)"Could not find Java 1.4 encode method. Using deprecated version.", (Throwable)e);
        }
        return URLEncoder.encode(url);
    }

    public static boolean isXhtml(PageContext pageContext) {
        String xhtml = (String)pageContext.getAttribute("org.apache.struts.globals.XHTML", 1);
        return "true".equalsIgnoreCase(xhtml);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Class[] args = new Class[]{class$java$lang$String == null ? (class$java$lang$String = RequestUtils.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = RequestUtils.class$("java.lang.String")) : class$java$lang$String};
            encode = (class$java$net$URLEncoder == null ? (class$java$net$URLEncoder = RequestUtils.class$("java.net.URLEncoder")) : class$java$net$URLEncoder).getMethod("encode", args);
        }
        catch (NoSuchMethodException e) {
            log.debug((Object)"Could not find Java 1.4 encode method.  Using deprecated version.", (Throwable)e);
        }
        scopes.put("page", new Integer(1));
        scopes.put("request", new Integer(2));
        scopes.put("session", new Integer(3));
        scopes.put("application", new Integer(4));
    }
}

