import os
import sys

source_dir = os.path.abspath('.')
if source_dir not in sys.path:
    sys.path.insert(0, source_dir)
extensions = ['sphinx.ext.autodoc', 'sphinx.ext.viewcode']
exclude_patterns = ['_build']


if 'test_linkcode' in tags:
    extensions.remove('sphinx.ext.viewcode')
    extensions.append('sphinx.ext.linkcode')

    def linkcode_resolve(domain, info):
        if domain == 'py':
            fn = info['module'].replace('.', '/')
            return "http://foobar/source/%s.py" % fn
        elif domain == "js":
            return "http://foobar/js/" + info['fullname']
        elif domain in ("c", "cpp"):
            return f"http://foobar/{domain}/{''.join(info['names'])}"
        else:
            raise AssertionError()
