# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------
from msrest import Serializer, Deserializer
from typing import TYPE_CHECKING

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Iterable, Optional

    from azure.core.paging import ItemPaged


class KeyVaultClientOperationsMixin(object):

    def backup_certificate(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.BackupCertificateResult"
        """Backs up the specified certificate.

        Requests that a backup of the specified certificate be downloaded to the client. All versions
        of the certificate will be downloaded. This operation requires the certificates/backup
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupCertificateResult, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.BackupCertificateResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('backup_certificate')
        if api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'backup_certificate'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.backup_certificate(vault_base_url, certificate_name, **kwargs)

    def backup_key(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.BackupKeyResult"
        """Requests that a backup of the specified key be downloaded to the client.

        The Key Backup operation exports a key from Azure Key Vault in a protected form. Note that this
        operation does NOT return key material in a form that can be used outside the Azure Key Vault
        system, the returned key material is either protected to a Azure Key Vault HSM or to Azure Key
        Vault itself. The intent of this operation is to allow a client to GENERATE a key in one Azure
        Key Vault instance, BACKUP the key, and then RESTORE it into another Azure Key Vault instance.
        The BACKUP operation may be used to export, in protected form, any key type from Azure Key
        Vault. Individual versions of a key cannot be backed up. BACKUP / RESTORE can be performed
        within geographical boundaries only; meaning that a BACKUP from one geographical area cannot be
        restored to another geographical area. For example, a backup from the US geographical area
        cannot be restored in an EU geographical area. This operation requires the key/backup
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupKeyResult, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.BackupKeyResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('backup_key')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.1':
            from .v7_1.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.2':
            from .v7_2.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.3':
            from .v7_3.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'backup_key'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.backup_key(vault_base_url, key_name, **kwargs)

    def backup_secret(
        self,
        vault_base_url,  # type: str
        secret_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.BackupSecretResult"
        """Backs up the specified secret.

        Requests that a backup of the specified secret be downloaded to the client. All versions of the
        secret will be downloaded. This operation requires the secrets/backup permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param secret_name: The name of the secret.
        :type secret_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupSecretResult, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.BackupSecretResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('backup_secret')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'backup_secret'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.backup_secret(vault_base_url, secret_name, **kwargs)

    def backup_storage_account(
        self,
        vault_base_url,  # type: str
        storage_account_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.BackupStorageResult"
        """Backs up the specified storage account.

        Requests that a backup of the specified storage account be downloaded to the client. This
        operation requires the storage/backup permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupStorageResult, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.BackupStorageResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('backup_storage_account')
        if api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'backup_storage_account'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.backup_storage_account(vault_base_url, storage_account_name, **kwargs)

    def create_certificate(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        parameters,  # type: "_models.CertificateCreateParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CertificateOperation"
        """Creates a new certificate.

        If this is the first version, the certificate resource is created. This operation requires the
        certificates/create permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :param parameters: The parameters to create a certificate.
        :type parameters: ~azure.keyvault.v2016_10_01.models.CertificateCreateParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateOperation, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateOperation
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('create_certificate')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'create_certificate'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.create_certificate(vault_base_url, certificate_name, parameters, **kwargs)

    def create_key(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        parameters,  # type: "_models.KeyCreateParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.KeyBundle"
        """Creates a new key, stores it, then returns key parameters and attributes to the client.

        The create key operation can be used to create any key type in Azure Key Vault. If the named
        key already exists, Azure Key Vault creates a new version of the key. It requires the
        keys/create permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name for the new key. The system will generate the version name for the
         new key.
        :type key_name: str
        :param parameters: The parameters to create a key.
        :type parameters: ~azure.keyvault.v7_3.models.KeyCreateParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.KeyBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('create_key')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.1':
            from .v7_1.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.2':
            from .v7_2.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.3':
            from .v7_3.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'create_key'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.create_key(vault_base_url, key_name, parameters, **kwargs)

    def decrypt(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        key_version,  # type: str
        parameters,  # type: "_models.KeyOperationsParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.KeyOperationResult"
        """Decrypts a single block of encrypted data.

        The DECRYPT operation decrypts a well-formed block of ciphertext using the target encryption
        key and specified algorithm. This operation is the reverse of the ENCRYPT operation; only a
        single block of data may be decrypted, the size of this block is dependent on the target key
        and the algorithm to be used. The DECRYPT operation applies to asymmetric and symmetric keys
        stored in Azure Key Vault since it uses the private portion of the key. This operation requires
        the keys/decrypt permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :param key_version: The version of the key.
        :type key_version: str
        :param parameters: The parameters for the decryption operation.
        :type parameters: ~azure.keyvault.v7_3.models.KeyOperationsParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.KeyOperationResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('decrypt')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.1':
            from .v7_1.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.2':
            from .v7_2.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.3':
            from .v7_3.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'decrypt'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.decrypt(vault_base_url, key_name, key_version, parameters, **kwargs)

    def delete_certificate(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.DeletedCertificateBundle"
        """Deletes a certificate from a specified key vault.

        Deletes all versions of a certificate object along with its associated policy. Delete
        certificate cannot be used to remove individual versions of a certificate object. This
        operation requires the certificates/delete permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeletedCertificateBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.DeletedCertificateBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('delete_certificate')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'delete_certificate'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.delete_certificate(vault_base_url, certificate_name, **kwargs)

    def delete_certificate_contacts(
        self,
        vault_base_url,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.Contacts"
        """Deletes the certificate contacts for a specified key vault.

        Deletes the certificate contacts for a specified key vault certificate. This operation requires
        the certificates/managecontacts permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Contacts, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.Contacts
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('delete_certificate_contacts')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'delete_certificate_contacts'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.delete_certificate_contacts(vault_base_url, **kwargs)

    def delete_certificate_issuer(
        self,
        vault_base_url,  # type: str
        issuer_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.IssuerBundle"
        """Deletes the specified certificate issuer.

        The DeleteCertificateIssuer operation permanently removes the specified certificate issuer from
        the vault. This operation requires the certificates/manageissuers/deleteissuers permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer.
        :type issuer_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IssuerBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.IssuerBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('delete_certificate_issuer')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'delete_certificate_issuer'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.delete_certificate_issuer(vault_base_url, issuer_name, **kwargs)

    def delete_certificate_operation(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CertificateOperation"
        """Deletes the creation operation for a specific certificate.

        Deletes the creation operation for a specified certificate that is in the process of being
        created. The certificate is no longer created. This operation requires the certificates/update
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateOperation, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateOperation
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('delete_certificate_operation')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'delete_certificate_operation'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.delete_certificate_operation(vault_base_url, certificate_name, **kwargs)

    def delete_key(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.DeletedKeyBundle"
        """Deletes a key of any type from storage in Azure Key Vault.

        The delete key operation cannot be used to remove individual versions of a key. This operation
        removes the cryptographic material associated with the key, which means the key is not usable
        for Sign/Verify, Wrap/Unwrap or Encrypt/Decrypt operations. This operation requires the
        keys/delete permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key to delete.
        :type key_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeletedKeyBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.DeletedKeyBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('delete_key')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.1':
            from .v7_1.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.2':
            from .v7_2.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.3':
            from .v7_3.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'delete_key'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.delete_key(vault_base_url, key_name, **kwargs)

    def delete_sas_definition(
        self,
        vault_base_url,  # type: str
        storage_account_name,  # type: str
        sas_definition_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.SasDefinitionBundle"
        """Deletes a SAS definition from a specified storage account. This operation requires the
        storage/deletesas permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param sas_definition_name: The name of the SAS definition.
        :type sas_definition_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SasDefinitionBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SasDefinitionBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('delete_sas_definition')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'delete_sas_definition'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.delete_sas_definition(vault_base_url, storage_account_name, sas_definition_name, **kwargs)

    def delete_secret(
        self,
        vault_base_url,  # type: str
        secret_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.DeletedSecretBundle"
        """Deletes a secret from a specified key vault.

        The DELETE operation applies to any secret stored in Azure Key Vault. DELETE cannot be applied
        to an individual version of a secret. This operation requires the secrets/delete permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param secret_name: The name of the secret.
        :type secret_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeletedSecretBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.DeletedSecretBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('delete_secret')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'delete_secret'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.delete_secret(vault_base_url, secret_name, **kwargs)

    def delete_storage_account(
        self,
        vault_base_url,  # type: str
        storage_account_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.StorageBundle"
        """Deletes a storage account. This operation requires the storage/delete permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StorageBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.StorageBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('delete_storage_account')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'delete_storage_account'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.delete_storage_account(vault_base_url, storage_account_name, **kwargs)

    def encrypt(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        key_version,  # type: str
        parameters,  # type: "_models.KeyOperationsParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.KeyOperationResult"
        """Encrypts an arbitrary sequence of bytes using an encryption key that is stored in a key vault.

        The ENCRYPT operation encrypts an arbitrary sequence of bytes using an encryption key that is
        stored in Azure Key Vault. Note that the ENCRYPT operation only supports a single block of
        data, the size of which is dependent on the target key and the encryption algorithm to be used.
        The ENCRYPT operation is only strictly necessary for symmetric keys stored in Azure Key Vault
        since protection with an asymmetric key can be performed using public portion of the key. This
        operation is supported for asymmetric keys as a convenience for callers that have a
        key-reference but do not have access to the public key material. This operation requires the
        keys/encrypt permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :param key_version: The version of the key.
        :type key_version: str
        :param parameters: The parameters for the encryption operation.
        :type parameters: ~azure.keyvault.v7_3.models.KeyOperationsParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.KeyOperationResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('encrypt')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.1':
            from .v7_1.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.2':
            from .v7_2.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.3':
            from .v7_3.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'encrypt'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.encrypt(vault_base_url, key_name, key_version, parameters, **kwargs)

    def get_certificate(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        certificate_version,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CertificateBundle"
        """Gets information about a certificate.

        Gets information about a specific certificate. This operation requires the certificates/get
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in the given vault.
        :type certificate_name: str
        :param certificate_version: The version of the certificate.
        :type certificate_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_certificate')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_certificate'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_certificate(vault_base_url, certificate_name, certificate_version, **kwargs)

    def get_certificate_contacts(
        self,
        vault_base_url,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.Contacts"
        """Lists the certificate contacts for a specified key vault.

        The GetCertificateContacts operation returns the set of certificate contact resources in the
        specified key vault. This operation requires the certificates/managecontacts permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Contacts, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.Contacts
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_certificate_contacts')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_certificate_contacts'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_certificate_contacts(vault_base_url, **kwargs)

    def get_certificate_issuer(
        self,
        vault_base_url,  # type: str
        issuer_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.IssuerBundle"
        """Lists the specified certificate issuer.

        The GetCertificateIssuer operation returns the specified certificate issuer resources in the
        specified key vault. This operation requires the certificates/manageissuers/getissuers
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer.
        :type issuer_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IssuerBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.IssuerBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_certificate_issuer')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_certificate_issuer'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_certificate_issuer(vault_base_url, issuer_name, **kwargs)

    def get_certificate_issuers(
        self,
        vault_base_url,  # type: str
        maxresults=None,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.CertificateIssuerListResult"]
        """List certificate issuers for a specified key vault.

        The GetCertificateIssuers operation returns the set of certificate issuer resources in the
        specified key vault. This operation requires the certificates/manageissuers/getissuers
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If not specified the service
         will return up to 25 results. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either CertificateIssuerListResult or the result of
         cls(response)
        :rtype:
         ~azure.core.paging.ItemPaged[~azure.keyvault.v2016_10_01.models.CertificateIssuerListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_certificate_issuers')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_certificate_issuers'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_certificate_issuers(vault_base_url, maxresults, **kwargs)

    def get_certificate_operation(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CertificateOperation"
        """Gets the creation operation of a certificate.

        Gets the creation operation associated with a specified certificate. This operation requires
        the certificates/get permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateOperation, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateOperation
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_certificate_operation')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_certificate_operation'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_certificate_operation(vault_base_url, certificate_name, **kwargs)

    def get_certificate_policy(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CertificatePolicy"
        """Lists the policy for a certificate.

        The GetCertificatePolicy operation returns the specified certificate policy resources in the
        specified key vault. This operation requires the certificates/get permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in a given key vault.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificatePolicy, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificatePolicy
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_certificate_policy')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_certificate_policy'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_certificate_policy(vault_base_url, certificate_name, **kwargs)

    def get_certificate_versions(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        maxresults=None,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.CertificateListResult"]
        """List the versions of a certificate.

        The GetCertificateVersions operation returns the versions of a certificate in the specified key
        vault. This operation requires the certificates/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :param maxresults: Maximum number of results to return in a page. If not specified the service
         will return up to 25 results. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either CertificateListResult or the result of
         cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.keyvault.v2016_10_01.models.CertificateListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_certificate_versions')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_certificate_versions'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_certificate_versions(vault_base_url, certificate_name, maxresults, **kwargs)

    def get_certificates(
        self,
        vault_base_url,  # type: str
        maxresults=None,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.CertificateListResult"]
        """List certificates in a specified key vault.

        The GetCertificates operation returns the set of certificates resources in the specified key
        vault. This operation requires the certificates/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If not specified the service
         will return up to 25 results. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either CertificateListResult or the result of
         cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.keyvault.v2016_10_01.models.CertificateListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_certificates')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_certificates'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_certificates(vault_base_url, maxresults, **kwargs)

    def get_deleted_certificate(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.DeletedCertificateBundle"
        """Retrieves information about the specified deleted certificate.

        The GetDeletedCertificate operation retrieves the deleted certificate information plus its
        attributes, such as retention interval, scheduled permanent deletion and the current deletion
        recovery level. This operation requires the certificates/get permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeletedCertificateBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.DeletedCertificateBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_deleted_certificate')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_deleted_certificate'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_deleted_certificate(vault_base_url, certificate_name, **kwargs)

    def get_deleted_certificates(
        self,
        vault_base_url,  # type: str
        maxresults=None,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.DeletedCertificateListResult"]
        """Lists the deleted certificates in the specified vault currently available for recovery.

        The GetDeletedCertificates operation retrieves the certificates in the current vault which are
        in a deleted state and ready for recovery or purging. This operation includes deletion-specific
        information. This operation requires the certificates/get/list permission. This operation can
        only be enabled on soft-delete enabled vaults.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If not specified the service
         will return up to 25 results. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DeletedCertificateListResult or the result of
         cls(response)
        :rtype:
         ~azure.core.paging.ItemPaged[~azure.keyvault.v2016_10_01.models.DeletedCertificateListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_deleted_certificates')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_deleted_certificates'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_deleted_certificates(vault_base_url, maxresults, **kwargs)

    def get_deleted_key(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.DeletedKeyBundle"
        """Gets the public part of a deleted key.

        The Get Deleted Key operation is applicable for soft-delete enabled vaults. While the operation
        can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled
        vault. This operation requires the keys/get permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeletedKeyBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.DeletedKeyBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_deleted_key')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.1':
            from .v7_1.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.2':
            from .v7_2.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.3':
            from .v7_3.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_deleted_key'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_deleted_key(vault_base_url, key_name, **kwargs)

    def get_deleted_keys(
        self,
        vault_base_url,  # type: str
        maxresults=None,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.DeletedKeyListResult"]
        """Lists the deleted keys in the specified vault.

        Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the
        public part of a deleted key. This operation includes deletion-specific information. The Get
        Deleted Keys operation is applicable for vaults enabled for soft-delete. While the operation
        can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled
        vault. This operation requires the keys/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If not specified the service
         will return up to 25 results. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DeletedKeyListResult or the result of
         cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.keyvault.v7_3.models.DeletedKeyListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_deleted_keys')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.1':
            from .v7_1.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.2':
            from .v7_2.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.3':
            from .v7_3.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_deleted_keys'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_deleted_keys(vault_base_url, maxresults, **kwargs)

    def get_deleted_sas_definition(
        self,
        vault_base_url,  # type: str
        storage_account_name,  # type: str
        sas_definition_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.DeletedSasDefinitionBundle"
        """Gets the specified deleted sas definition.

        The Get Deleted SAS Definition operation returns the specified deleted SAS definition along
        with its attributes. This operation requires the storage/getsas permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param sas_definition_name: The name of the SAS definition.
        :type sas_definition_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeletedSasDefinitionBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.DeletedSasDefinitionBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_deleted_sas_definition')
        if api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_deleted_sas_definition'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_deleted_sas_definition(vault_base_url, storage_account_name, sas_definition_name, **kwargs)

    def get_deleted_sas_definitions(
        self,
        vault_base_url,  # type: str
        storage_account_name,  # type: str
        maxresults=None,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.DeletedSasDefinitionListResult"]
        """Lists deleted SAS definitions for the specified vault and storage account.

        The Get Deleted Sas Definitions operation returns the SAS definitions that have been deleted
        for a vault enabled for soft-delete. This operation requires the storage/listsas permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param maxresults: Maximum number of results to return in a page. If not specified the service
         will return up to 25 results. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DeletedSasDefinitionListResult or the result of
         cls(response)
        :rtype:
         ~azure.core.paging.ItemPaged[~azure.keyvault.v7_0.models.DeletedSasDefinitionListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_deleted_sas_definitions')
        if api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_deleted_sas_definitions'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_deleted_sas_definitions(vault_base_url, storage_account_name, maxresults, **kwargs)

    def get_deleted_secret(
        self,
        vault_base_url,  # type: str
        secret_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.DeletedSecretBundle"
        """Gets the specified deleted secret.

        The Get Deleted Secret operation returns the specified deleted secret along with its
        attributes. This operation requires the secrets/get permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param secret_name: The name of the secret.
        :type secret_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeletedSecretBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.DeletedSecretBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_deleted_secret')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_deleted_secret'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_deleted_secret(vault_base_url, secret_name, **kwargs)

    def get_deleted_secrets(
        self,
        vault_base_url,  # type: str
        maxresults=None,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.DeletedSecretListResult"]
        """Lists deleted secrets for the specified vault.

        The Get Deleted Secrets operation returns the secrets that have been deleted for a vault
        enabled for soft-delete. This operation requires the secrets/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If not specified the service
         will return up to 25 results. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DeletedSecretListResult or the result of
         cls(response)
        :rtype:
         ~azure.core.paging.ItemPaged[~azure.keyvault.v2016_10_01.models.DeletedSecretListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_deleted_secrets')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_deleted_secrets'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_deleted_secrets(vault_base_url, maxresults, **kwargs)

    def get_deleted_storage_account(
        self,
        vault_base_url,  # type: str
        storage_account_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.DeletedStorageBundle"
        """Gets the specified deleted storage account.

        The Get Deleted Storage Account operation returns the specified deleted storage account along
        with its attributes. This operation requires the storage/get permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeletedStorageBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.DeletedStorageBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_deleted_storage_account')
        if api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_deleted_storage_account'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_deleted_storage_account(vault_base_url, storage_account_name, **kwargs)

    def get_deleted_storage_accounts(
        self,
        vault_base_url,  # type: str
        maxresults=None,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.DeletedStorageListResult"]
        """Lists deleted storage accounts for the specified vault.

        The Get Deleted Storage Accounts operation returns the storage accounts that have been deleted
        for a vault enabled for soft-delete. This operation requires the storage/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If not specified the service
         will return up to 25 results. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DeletedStorageListResult or the result of
         cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.keyvault.v7_0.models.DeletedStorageListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_deleted_storage_accounts')
        if api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_deleted_storage_accounts'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_deleted_storage_accounts(vault_base_url, maxresults, **kwargs)

    def get_key(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        key_version,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.KeyBundle"
        """Gets the public part of a stored key.

        The get key operation is applicable to all key types. If the requested key is symmetric, then
        no key material is released in the response. This operation requires the keys/get permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key to get.
        :type key_name: str
        :param key_version: Adding the version parameter retrieves a specific version of a key. This
         URI fragment is optional. If not specified, the latest version of the key is returned.
        :type key_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.KeyBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_key')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.1':
            from .v7_1.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.2':
            from .v7_2.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.3':
            from .v7_3.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_key'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_key(vault_base_url, key_name, key_version, **kwargs)

    def get_key_rotation_policy(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.KeyRotationPolicy"
        """Lists the policy for a key.

        The GetKeyRotationPolicy operation returns the specified key policy resources in the specified
        key vault. This operation requires the keys/get permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key in a given key vault.
        :type key_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyRotationPolicy, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.KeyRotationPolicy
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_key_rotation_policy')
        if api_version == '7.3':
            from .v7_3.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_key_rotation_policy'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_key_rotation_policy(vault_base_url, key_name, **kwargs)

    def get_key_versions(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        maxresults=None,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.KeyListResult"]
        """Retrieves a list of individual key versions with the same key name.

        The full key identifier, attributes, and tags are provided in the response. This operation
        requires the keys/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :param maxresults: Maximum number of results to return in a page. If not specified the service
         will return up to 25 results. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either KeyListResult or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.keyvault.v7_3.models.KeyListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_key_versions')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.1':
            from .v7_1.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.2':
            from .v7_2.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.3':
            from .v7_3.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_key_versions'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_key_versions(vault_base_url, key_name, maxresults, **kwargs)

    def get_keys(
        self,
        vault_base_url,  # type: str
        maxresults=None,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.KeyListResult"]
        """List keys in the specified vault.

        Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the
        public part of a stored key. The LIST operation is applicable to all key types, however only
        the base key identifier, attributes, and tags are provided in the response. Individual versions
        of a key are not listed in the response. This operation requires the keys/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If not specified the service
         will return up to 25 results. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either KeyListResult or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.keyvault.v7_3.models.KeyListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_keys')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.1':
            from .v7_1.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.2':
            from .v7_2.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.3':
            from .v7_3.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_keys'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_keys(vault_base_url, maxresults, **kwargs)

    def get_random_bytes(
        self,
        vault_base_url,  # type: str
        parameters,  # type: "_models.GetRandomBytesRequest"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.RandomBytes"
        """Get the requested number of bytes containing random values.

        Get the requested number of bytes containing random values from a managed HSM.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param parameters: The request object to get random bytes.
        :type parameters: ~azure.keyvault.v7_3.models.GetRandomBytesRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RandomBytes, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.RandomBytes
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_random_bytes')
        if api_version == '7.3':
            from .v7_3.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_random_bytes'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_random_bytes(vault_base_url, parameters, **kwargs)

    def get_sas_definition(
        self,
        vault_base_url,  # type: str
        storage_account_name,  # type: str
        sas_definition_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.SasDefinitionBundle"
        """Gets information about a SAS definition for the specified storage account. This operation
        requires the storage/getsas permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param sas_definition_name: The name of the SAS definition.
        :type sas_definition_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SasDefinitionBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SasDefinitionBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_sas_definition')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_sas_definition'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_sas_definition(vault_base_url, storage_account_name, sas_definition_name, **kwargs)

    def get_sas_definitions(
        self,
        vault_base_url,  # type: str
        storage_account_name,  # type: str
        maxresults=None,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.SasDefinitionListResult"]
        """List storage SAS definitions for the given storage account. This operation requires the
        storage/listsas permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param maxresults: Maximum number of results to return in a page. If not specified the service
         will return up to 25 results. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either SasDefinitionListResult or the result of
         cls(response)
        :rtype:
         ~azure.core.paging.ItemPaged[~azure.keyvault.v2016_10_01.models.SasDefinitionListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_sas_definitions')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_sas_definitions'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_sas_definitions(vault_base_url, storage_account_name, maxresults, **kwargs)

    def get_secret(
        self,
        vault_base_url,  # type: str
        secret_name,  # type: str
        secret_version,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.SecretBundle"
        """Get a specified secret from a given key vault.

        The GET operation is applicable to any secret stored in Azure Key Vault. This operation
        requires the secrets/get permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param secret_name: The name of the secret.
        :type secret_name: str
        :param secret_version: The version of the secret.
        :type secret_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SecretBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SecretBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_secret')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_secret'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_secret(vault_base_url, secret_name, secret_version, **kwargs)

    def get_secret_versions(
        self,
        vault_base_url,  # type: str
        secret_name,  # type: str
        maxresults=None,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.SecretListResult"]
        """List all versions of the specified secret.

        The full secret identifier and attributes are provided in the response. No values are returned
        for the secrets. This operations requires the secrets/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param secret_name: The name of the secret.
        :type secret_name: str
        :param maxresults: Maximum number of results to return in a page. If not specified, the service
         will return up to 25 results. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either SecretListResult or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.keyvault.v2016_10_01.models.SecretListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_secret_versions')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_secret_versions'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_secret_versions(vault_base_url, secret_name, maxresults, **kwargs)

    def get_secrets(
        self,
        vault_base_url,  # type: str
        maxresults=None,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.SecretListResult"]
        """List secrets in a specified key vault.

        The Get Secrets operation is applicable to the entire vault. However, only the base secret
        identifier and its attributes are provided in the response. Individual secret versions are not
        listed in the response. This operation requires the secrets/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If not specified, the service
         will return up to 25 results. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either SecretListResult or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.keyvault.v2016_10_01.models.SecretListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_secrets')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_secrets'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_secrets(vault_base_url, maxresults, **kwargs)

    def get_storage_account(
        self,
        vault_base_url,  # type: str
        storage_account_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.StorageBundle"
        """Gets information about a specified storage account. This operation requires the storage/get
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StorageBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.StorageBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_storage_account')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_storage_account'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_storage_account(vault_base_url, storage_account_name, **kwargs)

    def get_storage_accounts(
        self,
        vault_base_url,  # type: str
        maxresults=None,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.StorageListResult"]
        """List storage accounts managed by the specified key vault. This operation requires the
        storage/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If not specified the service
         will return up to 25 results. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either StorageListResult or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.keyvault.v2016_10_01.models.StorageListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_storage_accounts')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_storage_accounts'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_storage_accounts(vault_base_url, maxresults, **kwargs)

    def import_certificate(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        parameters,  # type: "_models.CertificateImportParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CertificateBundle"
        """Imports a certificate into a specified key vault.

        Imports an existing valid certificate, containing a private key, into Azure Key Vault. The
        certificate to be imported can be in either PFX or PEM format. If the certificate is in PEM
        format the PEM file must contain the key as well as x509 certificates. This operation requires
        the certificates/import permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :param parameters: The parameters to import the certificate.
        :type parameters: ~azure.keyvault.v2016_10_01.models.CertificateImportParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('import_certificate')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'import_certificate'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.import_certificate(vault_base_url, certificate_name, parameters, **kwargs)

    def import_key(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        parameters,  # type: "_models.KeyImportParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.KeyBundle"
        """Imports an externally created key, stores it, and returns key parameters and attributes to the
        client.

        The import key operation may be used to import any key type into an Azure Key Vault. If the
        named key already exists, Azure Key Vault creates a new version of the key. This operation
        requires the keys/import permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: Name for the imported key.
        :type key_name: str
        :param parameters: The parameters to import a key.
        :type parameters: ~azure.keyvault.v7_3.models.KeyImportParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.KeyBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('import_key')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.1':
            from .v7_1.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.2':
            from .v7_2.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.3':
            from .v7_3.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'import_key'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.import_key(vault_base_url, key_name, parameters, **kwargs)

    def merge_certificate(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        parameters,  # type: "_models.CertificateMergeParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CertificateBundle"
        """Merges a certificate or a certificate chain with a key pair existing on the server.

        The MergeCertificate operation performs the merging of a certificate or certificate chain with
        a key pair currently available in the service. This operation requires the certificates/create
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :param parameters: The parameters to merge certificate.
        :type parameters: ~azure.keyvault.v2016_10_01.models.CertificateMergeParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('merge_certificate')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'merge_certificate'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.merge_certificate(vault_base_url, certificate_name, parameters, **kwargs)

    def purge_deleted_certificate(  # pylint: disable=inconsistent-return-statements
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Permanently deletes the specified deleted certificate.

        The PurgeDeletedCertificate operation performs an irreversible deletion of the specified
        certificate, without possibility for recovery. The operation is not available if the recovery
        level does not specify 'Purgeable'. This operation requires the certificate/purge permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('purge_deleted_certificate')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'purge_deleted_certificate'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.purge_deleted_certificate(vault_base_url, certificate_name, **kwargs)

    def purge_deleted_key(  # pylint: disable=inconsistent-return-statements
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Permanently deletes the specified key.

        The Purge Deleted Key operation is applicable for soft-delete enabled vaults. While the
        operation can be invoked on any vault, it will return an error if invoked on a non soft-delete
        enabled vault. This operation requires the keys/purge permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('purge_deleted_key')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.1':
            from .v7_1.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.2':
            from .v7_2.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.3':
            from .v7_3.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'purge_deleted_key'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.purge_deleted_key(vault_base_url, key_name, **kwargs)

    def purge_deleted_secret(  # pylint: disable=inconsistent-return-statements
        self,
        vault_base_url,  # type: str
        secret_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Permanently deletes the specified secret.

        The purge deleted secret operation removes the secret permanently, without the possibility of
        recovery. This operation can only be enabled on a soft-delete enabled vault. This operation
        requires the secrets/purge permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param secret_name: The name of the secret.
        :type secret_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('purge_deleted_secret')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'purge_deleted_secret'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.purge_deleted_secret(vault_base_url, secret_name, **kwargs)

    def purge_deleted_storage_account(  # pylint: disable=inconsistent-return-statements
        self,
        vault_base_url,  # type: str
        storage_account_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Permanently deletes the specified storage account.

        The purge deleted storage account operation removes the secret permanently, without the
        possibility of recovery. This operation can only be performed on a soft-delete enabled vault.
        This operation requires the storage/purge permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('purge_deleted_storage_account')
        if api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'purge_deleted_storage_account'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.purge_deleted_storage_account(vault_base_url, storage_account_name, **kwargs)

    def recover_deleted_certificate(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CertificateBundle"
        """Recovers the deleted certificate back to its current version under /certificates.

        The RecoverDeletedCertificate operation performs the reversal of the Delete operation. The
        operation is applicable in vaults enabled for soft-delete, and must be issued during the
        retention interval (available in the deleted certificate's attributes). This operation requires
        the certificates/recover permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the deleted certificate.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('recover_deleted_certificate')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'recover_deleted_certificate'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.recover_deleted_certificate(vault_base_url, certificate_name, **kwargs)

    def recover_deleted_key(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.KeyBundle"
        """Recovers the deleted key to its latest version.

        The Recover Deleted Key operation is applicable for deleted keys in soft-delete enabled vaults.
        It recovers the deleted key back to its latest version under /keys. An attempt to recover an
        non-deleted key will return an error. Consider this the inverse of the delete operation on
        soft-delete enabled vaults. This operation requires the keys/recover permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the deleted key.
        :type key_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.KeyBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('recover_deleted_key')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.1':
            from .v7_1.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.2':
            from .v7_2.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.3':
            from .v7_3.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'recover_deleted_key'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.recover_deleted_key(vault_base_url, key_name, **kwargs)

    def recover_deleted_sas_definition(
        self,
        vault_base_url,  # type: str
        storage_account_name,  # type: str
        sas_definition_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.SasDefinitionBundle"
        """Recovers the deleted SAS definition.

        Recovers the deleted SAS definition for the specified storage account. This operation can only
        be performed on a soft-delete enabled vault. This operation requires the storage/recover
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param sas_definition_name: The name of the SAS definition.
        :type sas_definition_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SasDefinitionBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.SasDefinitionBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('recover_deleted_sas_definition')
        if api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'recover_deleted_sas_definition'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.recover_deleted_sas_definition(vault_base_url, storage_account_name, sas_definition_name, **kwargs)

    def recover_deleted_secret(
        self,
        vault_base_url,  # type: str
        secret_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.SecretBundle"
        """Recovers the deleted secret to the latest version.

        Recovers the deleted secret in the specified vault. This operation can only be performed on a
        soft-delete enabled vault. This operation requires the secrets/recover permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param secret_name: The name of the deleted secret.
        :type secret_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SecretBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SecretBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('recover_deleted_secret')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'recover_deleted_secret'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.recover_deleted_secret(vault_base_url, secret_name, **kwargs)

    def recover_deleted_storage_account(
        self,
        vault_base_url,  # type: str
        storage_account_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.StorageBundle"
        """Recovers the deleted storage account.

        Recovers the deleted storage account in the specified vault. This operation can only be
        performed on a soft-delete enabled vault. This operation requires the storage/recover
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StorageBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.StorageBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('recover_deleted_storage_account')
        if api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'recover_deleted_storage_account'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.recover_deleted_storage_account(vault_base_url, storage_account_name, **kwargs)

    def regenerate_storage_account_key(
        self,
        vault_base_url,  # type: str
        storage_account_name,  # type: str
        parameters,  # type: "_models.StorageAccountRegenerteKeyParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.StorageBundle"
        """Regenerates the specified key value for the given storage account. This operation requires the
        storage/regeneratekey permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param parameters: The parameters to regenerate storage account key.
        :type parameters: ~azure.keyvault.v2016_10_01.models.StorageAccountRegenerteKeyParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StorageBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.StorageBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('regenerate_storage_account_key')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'regenerate_storage_account_key'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.regenerate_storage_account_key(vault_base_url, storage_account_name, parameters, **kwargs)

    def release(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        key_version,  # type: str
        parameters,  # type: "_models.KeyReleaseParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.KeyReleaseResult"
        """Releases a key.

        The release key operation is applicable to all key types. The target key must be marked
        exportable. This operation requires the keys/release permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key to get.
        :type key_name: str
        :param key_version: Adding the version parameter retrieves a specific version of a key.
        :type key_version: str
        :param parameters: The parameters for the key release operation.
        :type parameters: ~azure.keyvault.v7_3.models.KeyReleaseParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyReleaseResult, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.KeyReleaseResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('release')
        if api_version == '7.3':
            from .v7_3.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'release'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.release(vault_base_url, key_name, key_version, parameters, **kwargs)

    def restore_certificate(
        self,
        vault_base_url,  # type: str
        parameters,  # type: "_models.CertificateRestoreParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CertificateBundle"
        """Restores a backed up certificate to a vault.

        Restores a backed up certificate, and all its versions, to a vault. This operation requires the
        certificates/restore permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param parameters: The parameters to restore the certificate.
        :type parameters: ~azure.keyvault.v7_0.models.CertificateRestoreParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.CertificateBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('restore_certificate')
        if api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'restore_certificate'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.restore_certificate(vault_base_url, parameters, **kwargs)

    def restore_key(
        self,
        vault_base_url,  # type: str
        parameters,  # type: "_models.KeyRestoreParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.KeyBundle"
        """Restores a backed up key to a vault.

        Imports a previously backed up key into Azure Key Vault, restoring the key, its key identifier,
        attributes and access control policies. The RESTORE operation may be used to import a
        previously backed up key. Individual versions of a key cannot be restored. The key is restored
        in its entirety with the same key name as it had when it was backed up. If the key name is not
        available in the target Key Vault, the RESTORE operation will be rejected. While the key name
        is retained during restore, the final key identifier will change if the key is restored to a
        different vault. Restore will restore all versions and preserve version identifiers. The
        RESTORE operation is subject to security constraints: The target Key Vault must be owned by the
        same Microsoft Azure Subscription as the source Key Vault The user must have RESTORE permission
        in the target Key Vault. This operation requires the keys/restore permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param parameters: The parameters to restore the key.
        :type parameters: ~azure.keyvault.v7_3.models.KeyRestoreParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.KeyBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('restore_key')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.1':
            from .v7_1.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.2':
            from .v7_2.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.3':
            from .v7_3.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'restore_key'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.restore_key(vault_base_url, parameters, **kwargs)

    def restore_secret(
        self,
        vault_base_url,  # type: str
        parameters,  # type: "_models.SecretRestoreParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.SecretBundle"
        """Restores a backed up secret to a vault.

        Restores a backed up secret, and all its versions, to a vault. This operation requires the
        secrets/restore permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param parameters: The parameters to restore the secret.
        :type parameters: ~azure.keyvault.v2016_10_01.models.SecretRestoreParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SecretBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SecretBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('restore_secret')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'restore_secret'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.restore_secret(vault_base_url, parameters, **kwargs)

    def restore_storage_account(
        self,
        vault_base_url,  # type: str
        parameters,  # type: "_models.StorageRestoreParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.StorageBundle"
        """Restores a backed up storage account to a vault.

        Restores a backed up storage account to a vault. This operation requires the storage/restore
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param parameters: The parameters to restore the storage account.
        :type parameters: ~azure.keyvault.v7_0.models.StorageRestoreParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StorageBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.StorageBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('restore_storage_account')
        if api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'restore_storage_account'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.restore_storage_account(vault_base_url, parameters, **kwargs)

    def rotate_key(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.KeyBundle"
        """Creates a new key version, stores it, then returns key parameters, attributes and policy to the
        client.

        The operation will rotate the key based on the key policy. It requires the keys/rotate
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of key to be rotated. The system will generate a new version in the
         specified key.
        :type key_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.KeyBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('rotate_key')
        if api_version == '7.3':
            from .v7_3.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'rotate_key'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.rotate_key(vault_base_url, key_name, **kwargs)

    def set_certificate_contacts(
        self,
        vault_base_url,  # type: str
        contacts,  # type: "_models.Contacts"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.Contacts"
        """Sets the certificate contacts for the specified key vault.

        Sets the certificate contacts for the specified key vault. This operation requires the
        certificates/managecontacts permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param contacts: The contacts for the key vault certificate.
        :type contacts: ~azure.keyvault.v2016_10_01.models.Contacts
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Contacts, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.Contacts
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('set_certificate_contacts')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'set_certificate_contacts'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.set_certificate_contacts(vault_base_url, contacts, **kwargs)

    def set_certificate_issuer(
        self,
        vault_base_url,  # type: str
        issuer_name,  # type: str
        parameter,  # type: "_models.CertificateIssuerSetParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.IssuerBundle"
        """Sets the specified certificate issuer.

        The SetCertificateIssuer operation adds or updates the specified certificate issuer. This
        operation requires the certificates/setissuers permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer.
        :type issuer_name: str
        :param parameter: Certificate issuer set parameter.
        :type parameter: ~azure.keyvault.v2016_10_01.models.CertificateIssuerSetParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IssuerBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.IssuerBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('set_certificate_issuer')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'set_certificate_issuer'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.set_certificate_issuer(vault_base_url, issuer_name, parameter, **kwargs)

    def set_sas_definition(
        self,
        vault_base_url,  # type: str
        storage_account_name,  # type: str
        sas_definition_name,  # type: str
        parameters,  # type: "_models.SasDefinitionCreateParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.SasDefinitionBundle"
        """Creates or updates a new SAS definition for the specified storage account. This operation
        requires the storage/setsas permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param sas_definition_name: The name of the SAS definition.
        :type sas_definition_name: str
        :param parameters: The parameters to create a SAS definition.
        :type parameters: ~azure.keyvault.v2016_10_01.models.SasDefinitionCreateParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SasDefinitionBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SasDefinitionBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('set_sas_definition')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'set_sas_definition'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.set_sas_definition(vault_base_url, storage_account_name, sas_definition_name, parameters, **kwargs)

    def set_secret(
        self,
        vault_base_url,  # type: str
        secret_name,  # type: str
        parameters,  # type: "_models.SecretSetParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.SecretBundle"
        """Sets a secret in a specified key vault.

        The SET operation adds a secret to the Azure Key Vault. If the named secret already exists,
        Azure Key Vault creates a new version of that secret. This operation requires the secrets/set
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param secret_name: The name of the secret.
        :type secret_name: str
        :param parameters: The parameters for setting the secret.
        :type parameters: ~azure.keyvault.v2016_10_01.models.SecretSetParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SecretBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SecretBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('set_secret')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'set_secret'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.set_secret(vault_base_url, secret_name, parameters, **kwargs)

    def set_storage_account(
        self,
        vault_base_url,  # type: str
        storage_account_name,  # type: str
        parameters,  # type: "_models.StorageAccountCreateParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.StorageBundle"
        """Creates or updates a new storage account. This operation requires the storage/set permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param parameters: The parameters to create a storage account.
        :type parameters: ~azure.keyvault.v2016_10_01.models.StorageAccountCreateParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StorageBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.StorageBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('set_storage_account')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'set_storage_account'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.set_storage_account(vault_base_url, storage_account_name, parameters, **kwargs)

    def sign(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        key_version,  # type: str
        parameters,  # type: "_models.KeySignParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.KeyOperationResult"
        """Creates a signature from a digest using the specified key.

        The SIGN operation is applicable to asymmetric and symmetric keys stored in Azure Key Vault
        since this operation uses the private portion of the key. This operation requires the keys/sign
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :param key_version: The version of the key.
        :type key_version: str
        :param parameters: The parameters for the signing operation.
        :type parameters: ~azure.keyvault.v7_3.models.KeySignParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.KeyOperationResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('sign')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.1':
            from .v7_1.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.2':
            from .v7_2.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.3':
            from .v7_3.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'sign'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.sign(vault_base_url, key_name, key_version, parameters, **kwargs)

    def unwrap_key(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        key_version,  # type: str
        parameters,  # type: "_models.KeyOperationsParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.KeyOperationResult"
        """Unwraps a symmetric key using the specified key that was initially used for wrapping that key.

        The UNWRAP operation supports decryption of a symmetric key using the target key encryption
        key. This operation is the reverse of the WRAP operation. The UNWRAP operation applies to
        asymmetric and symmetric keys stored in Azure Key Vault since it uses the private portion of
        the key. This operation requires the keys/unwrapKey permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :param key_version: The version of the key.
        :type key_version: str
        :param parameters: The parameters for the key operation.
        :type parameters: ~azure.keyvault.v7_3.models.KeyOperationsParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.KeyOperationResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('unwrap_key')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.1':
            from .v7_1.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.2':
            from .v7_2.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.3':
            from .v7_3.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'unwrap_key'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.unwrap_key(vault_base_url, key_name, key_version, parameters, **kwargs)

    def update_certificate(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        certificate_version,  # type: str
        parameters,  # type: "_models.CertificateUpdateParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CertificateBundle"
        """Updates the specified attributes associated with the given certificate.

        The UpdateCertificate operation applies the specified update on the given certificate; the only
        elements updated are the certificate's attributes. This operation requires the
        certificates/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in the given key vault.
        :type certificate_name: str
        :param certificate_version: The version of the certificate.
        :type certificate_version: str
        :param parameters: The parameters for certificate update.
        :type parameters: ~azure.keyvault.v2016_10_01.models.CertificateUpdateParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('update_certificate')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'update_certificate'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.update_certificate(vault_base_url, certificate_name, certificate_version, parameters, **kwargs)

    def update_certificate_issuer(
        self,
        vault_base_url,  # type: str
        issuer_name,  # type: str
        parameter,  # type: "_models.CertificateIssuerUpdateParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.IssuerBundle"
        """Updates the specified certificate issuer.

        The UpdateCertificateIssuer operation performs an update on the specified certificate issuer
        entity. This operation requires the certificates/setissuers permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer.
        :type issuer_name: str
        :param parameter: Certificate issuer update parameter.
        :type parameter: ~azure.keyvault.v2016_10_01.models.CertificateIssuerUpdateParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IssuerBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.IssuerBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('update_certificate_issuer')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'update_certificate_issuer'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.update_certificate_issuer(vault_base_url, issuer_name, parameter, **kwargs)

    def update_certificate_operation(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        certificate_operation,  # type: "_models.CertificateOperationUpdateParameter"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CertificateOperation"
        """Updates a certificate operation.

        Updates a certificate creation operation that is already in progress. This operation requires
        the certificates/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :param certificate_operation: The certificate operation response.
        :type certificate_operation:
         ~azure.keyvault.v2016_10_01.models.CertificateOperationUpdateParameter
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateOperation, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateOperation
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('update_certificate_operation')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'update_certificate_operation'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.update_certificate_operation(vault_base_url, certificate_name, certificate_operation, **kwargs)

    def update_certificate_policy(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        certificate_policy,  # type: "_models.CertificatePolicy"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CertificatePolicy"
        """Updates the policy for a certificate.

        Set specified members in the certificate policy. Leave others as null. This operation requires
        the certificates/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in the given vault.
        :type certificate_name: str
        :param certificate_policy: The policy for the certificate.
        :type certificate_policy: ~azure.keyvault.v2016_10_01.models.CertificatePolicy
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificatePolicy, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificatePolicy
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('update_certificate_policy')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'update_certificate_policy'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.update_certificate_policy(vault_base_url, certificate_name, certificate_policy, **kwargs)

    def update_key(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        key_version,  # type: str
        parameters,  # type: "_models.KeyUpdateParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.KeyBundle"
        """The update key operation changes specified attributes of a stored key and can be applied to any
        key type and key version stored in Azure Key Vault.

        In order to perform this operation, the key must already exist in the Key Vault. Note: The
        cryptographic material of a key itself cannot be changed. This operation requires the
        keys/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of key to update.
        :type key_name: str
        :param key_version: The version of the key to update.
        :type key_version: str
        :param parameters: The parameters of the key to update.
        :type parameters: ~azure.keyvault.v7_3.models.KeyUpdateParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.KeyBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('update_key')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.1':
            from .v7_1.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.2':
            from .v7_2.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.3':
            from .v7_3.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'update_key'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.update_key(vault_base_url, key_name, key_version, parameters, **kwargs)

    def update_key_rotation_policy(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        key_rotation_policy,  # type: "_models.KeyRotationPolicy"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.KeyRotationPolicy"
        """Updates the rotation policy for a key.

        Set specified members in the key policy. Leave others as undefined. This operation requires the
        keys/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key in the given vault.
        :type key_name: str
        :param key_rotation_policy: The policy for the key.
        :type key_rotation_policy: ~azure.keyvault.v7_3.models.KeyRotationPolicy
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyRotationPolicy, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.KeyRotationPolicy
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('update_key_rotation_policy')
        if api_version == '7.3':
            from .v7_3.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'update_key_rotation_policy'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.update_key_rotation_policy(vault_base_url, key_name, key_rotation_policy, **kwargs)

    def update_sas_definition(
        self,
        vault_base_url,  # type: str
        storage_account_name,  # type: str
        sas_definition_name,  # type: str
        parameters,  # type: "_models.SasDefinitionUpdateParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.SasDefinitionBundle"
        """Updates the specified attributes associated with the given SAS definition. This operation
        requires the storage/setsas permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param sas_definition_name: The name of the SAS definition.
        :type sas_definition_name: str
        :param parameters: The parameters to update a SAS definition.
        :type parameters: ~azure.keyvault.v2016_10_01.models.SasDefinitionUpdateParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SasDefinitionBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SasDefinitionBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('update_sas_definition')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'update_sas_definition'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.update_sas_definition(vault_base_url, storage_account_name, sas_definition_name, parameters, **kwargs)

    def update_secret(
        self,
        vault_base_url,  # type: str
        secret_name,  # type: str
        secret_version,  # type: str
        parameters,  # type: "_models.SecretUpdateParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.SecretBundle"
        """Updates the attributes associated with a specified secret in a given key vault.

        The UPDATE operation changes specified attributes of an existing stored secret. Attributes that
        are not specified in the request are left unchanged. The value of a secret itself cannot be
        changed. This operation requires the secrets/set permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param secret_name: The name of the secret.
        :type secret_name: str
        :param secret_version: The version of the secret.
        :type secret_version: str
        :param parameters: The parameters for update secret operation.
        :type parameters: ~azure.keyvault.v2016_10_01.models.SecretUpdateParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SecretBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SecretBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('update_secret')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'update_secret'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.update_secret(vault_base_url, secret_name, secret_version, parameters, **kwargs)

    def update_storage_account(
        self,
        vault_base_url,  # type: str
        storage_account_name,  # type: str
        parameters,  # type: "_models.StorageAccountUpdateParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.StorageBundle"
        """Updates the specified attributes associated with the given storage account. This operation
        requires the storage/set/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param parameters: The parameters to update a storage account.
        :type parameters: ~azure.keyvault.v2016_10_01.models.StorageAccountUpdateParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StorageBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.StorageBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('update_storage_account')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'update_storage_account'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.update_storage_account(vault_base_url, storage_account_name, parameters, **kwargs)

    def verify(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        key_version,  # type: str
        parameters,  # type: "_models.KeyVerifyParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.KeyVerifyResult"
        """Verifies a signature using a specified key.

        The VERIFY operation is applicable to symmetric keys stored in Azure Key Vault. VERIFY is not
        strictly necessary for asymmetric keys stored in Azure Key Vault since signature verification
        can be performed using the public portion of the key but this operation is supported as a
        convenience for callers that only have a key-reference and not the public portion of the key.
        This operation requires the keys/verify permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :param key_version: The version of the key.
        :type key_version: str
        :param parameters: The parameters for verify operations.
        :type parameters: ~azure.keyvault.v7_3.models.KeyVerifyParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyVerifyResult, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.KeyVerifyResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('verify')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.1':
            from .v7_1.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.2':
            from .v7_2.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.3':
            from .v7_3.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'verify'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.verify(vault_base_url, key_name, key_version, parameters, **kwargs)

    def wrap_key(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        key_version,  # type: str
        parameters,  # type: "_models.KeyOperationsParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.KeyOperationResult"
        """Wraps a symmetric key using a specified key.

        The WRAP operation supports encryption of a symmetric key using a key encryption key that has
        previously been stored in an Azure Key Vault. The WRAP operation is only strictly necessary for
        symmetric keys stored in Azure Key Vault since protection with an asymmetric key can be
        performed using the public portion of the key. This operation is supported for asymmetric keys
        as a convenience for callers that have a key-reference but do not have access to the public key
        material. This operation requires the keys/wrapKey permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :param key_version: The version of the key.
        :type key_version: str
        :param parameters: The parameters for wrap operation.
        :type parameters: ~azure.keyvault.v7_3.models.KeyOperationsParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.KeyOperationResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('wrap_key')
        if api_version == '2016-10-01':
            from .v2016_10_01.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.0':
            from .v7_0.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.1':
            from .v7_1.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.2':
            from .v7_2.operations import KeyVaultClientOperationsMixin as OperationClass
        elif api_version == '7.3':
            from .v7_3.operations import KeyVaultClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'wrap_key'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.wrap_key(vault_base_url, key_name, key_version, parameters, **kwargs)
