# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class ApplicationData(msrest.serialization.Model):
    """Schema of application data resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param application_product_details: Application product details.
    :type application_product_details:
     list[~azure.agrifood.farming.models.ApplicationProductDetail]
    :param avg_material: Schema for storing measurement reading and unit.
    :type avg_material: ~azure.agrifood.farming.models.Measure
    :param total_material: Schema for storing measurement reading and unit.
    :type total_material: ~azure.agrifood.farming.models.Measure
    :param area: Schema for storing measurement reading and unit.
    :type area: ~azure.agrifood.farming.models.Measure
    :param source: Source of the operation data.
    :type source: str
    :param operation_modified_date_time: Modified date-time of the operation data, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
     Note: this will be specified by the source provider itself.
    :type operation_modified_date_time: ~datetime.datetime
    :param operation_start_date_time: Start date-time of the operation data, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :type operation_start_date_time: ~datetime.datetime
    :param operation_end_date_time: End date-time of the operation data, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :type operation_end_date_time: ~datetime.datetime
    :ivar attachments_link: Link for attachments.
    :vartype attachments_link: str
    :param associated_boundary_id: Optional boundary ID of the field for which operation was
     applied.
    :type associated_boundary_id: str
    :param operation_boundary_id: Optional boundary ID of the actual area for which operation was
     applied inside the specified field.
    :type operation_boundary_id: str
    :ivar farmer_id: Farmer ID which belongs to the operation data.
    :vartype farmer_id: str
    :ivar id: Unique resource ID.
    :vartype id: str
    :ivar e_tag: The ETag value to implement optimistic concurrency.
    :vartype e_tag: str
    :param status: Status of the resource.
    :type status: str
    :ivar created_date_time: Date-time when resource was created, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype created_date_time: ~datetime.datetime
    :ivar modified_date_time: Date-time when resource was last modified, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype modified_date_time: ~datetime.datetime
    :param name: Name to identify resource.
    :type name: str
    :param description: Textual description of the resource.
    :type description: str
    :param properties: A collection of key value pairs that belongs to the resource.
     Each pair must not have a key greater than 50 characters
     and must not have a value greater than 150 characters.
     Note: A maximum of 25 key value pairs can be provided for a resource and only string and
     numeral values are supported.
    :type properties: dict[str, any]
    """

    _validation = {
        'source': {'max_length': 100, 'min_length': 2},
        'attachments_link': {'readonly': True},
        'farmer_id': {'readonly': True},
        'id': {'readonly': True},
        'e_tag': {'readonly': True},
        'status': {'max_length': 100, 'min_length': 0},
        'created_date_time': {'readonly': True},
        'modified_date_time': {'readonly': True},
        'name': {'max_length': 100, 'min_length': 0},
        'description': {'max_length': 500, 'min_length': 0},
    }

    _attribute_map = {
        'application_product_details': {'key': 'applicationProductDetails', 'type': '[ApplicationProductDetail]'},
        'avg_material': {'key': 'avgMaterial', 'type': 'Measure'},
        'total_material': {'key': 'totalMaterial', 'type': 'Measure'},
        'area': {'key': 'area', 'type': 'Measure'},
        'source': {'key': 'source', 'type': 'str'},
        'operation_modified_date_time': {'key': 'operationModifiedDateTime', 'type': 'iso-8601'},
        'operation_start_date_time': {'key': 'operationStartDateTime', 'type': 'iso-8601'},
        'operation_end_date_time': {'key': 'operationEndDateTime', 'type': 'iso-8601'},
        'attachments_link': {'key': 'attachmentsLink', 'type': 'str'},
        'associated_boundary_id': {'key': 'associatedBoundaryId', 'type': 'str'},
        'operation_boundary_id': {'key': 'operationBoundaryId', 'type': 'str'},
        'farmer_id': {'key': 'farmerId', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'modified_date_time': {'key': 'modifiedDateTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationData, self).__init__(**kwargs)
        self.application_product_details = kwargs.get('application_product_details', None)
        self.avg_material = kwargs.get('avg_material', None)
        self.total_material = kwargs.get('total_material', None)
        self.area = kwargs.get('area', None)
        self.source = kwargs.get('source', None)
        self.operation_modified_date_time = kwargs.get('operation_modified_date_time', None)
        self.operation_start_date_time = kwargs.get('operation_start_date_time', None)
        self.operation_end_date_time = kwargs.get('operation_end_date_time', None)
        self.attachments_link = None
        self.associated_boundary_id = kwargs.get('associated_boundary_id', None)
        self.operation_boundary_id = kwargs.get('operation_boundary_id', None)
        self.farmer_id = None
        self.id = None
        self.e_tag = None
        self.status = kwargs.get('status', None)
        self.created_date_time = None
        self.modified_date_time = None
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.properties = kwargs.get('properties', None)


class ApplicationDataListResponse(msrest.serialization.Model):
    """Paged response contains list of requested objects and a URL link to get the next set of results.

    :param value: List of requested objects.
    :type value: list[~azure.agrifood.farming.models.ApplicationData]
    :param skip_token: Token used in retrieving the next page. If null, there are no additional
     pages.
    :type skip_token: str
    :param next_link: Continuation link (absolute URI) to the next page of results in the list.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationData]'},
        'skip_token': {'key': '$skipToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationDataListResponse, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.skip_token = kwargs.get('skip_token', None)
        self.next_link = kwargs.get('next_link', None)


class ApplicationProductDetail(msrest.serialization.Model):
    """Schema of product used during application.

    :param product_name: Name of the product applied.
    :type product_name: str
    :param is_carrier: A flag indicating whether product is a carrier for a tank mix.
    :type is_carrier: bool
    :param avg_material: Schema for storing measurement reading and unit.
    :type avg_material: ~azure.agrifood.farming.models.Measure
    :param total_material: Schema for storing measurement reading and unit.
    :type total_material: ~azure.agrifood.farming.models.Measure
    """

    _validation = {
        'product_name': {'max_length': 100, 'min_length': 1},
    }

    _attribute_map = {
        'product_name': {'key': 'productName', 'type': 'str'},
        'is_carrier': {'key': 'isCarrier', 'type': 'bool'},
        'avg_material': {'key': 'avgMaterial', 'type': 'Measure'},
        'total_material': {'key': 'totalMaterial', 'type': 'Measure'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationProductDetail, self).__init__(**kwargs)
        self.product_name = kwargs.get('product_name', None)
        self.is_carrier = kwargs.get('is_carrier', False)
        self.avg_material = kwargs.get('avg_material', None)
        self.total_material = kwargs.get('total_material', None)


class Attachment(msrest.serialization.Model):
    """Schema of attachment resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar farmer_id: Farmer id for this attachment.
    :vartype farmer_id: str
    :param resource_id: Associated Resource id for this attachment.
    :type resource_id: str
    :param resource_type: Associated Resource type for this attachment
     i.e. Farmer, Farm, Field, SeasonalField, Boundary, FarmOperationApplicationData, HarvestData,
     TillageData, PlantingData.
    :type resource_type: str
    :ivar original_file_name: Original File Name for this attachment.
    :vartype original_file_name: str
    :ivar id: Unique id.
    :vartype id: str
    :param status: Status of the resource.
    :type status: str
    :ivar created_date_time: Date when resource was created.
    :vartype created_date_time: ~datetime.datetime
    :ivar modified_date_time: Date when resource was last modified.
    :vartype modified_date_time: ~datetime.datetime
    :param name: Name to identify resource.
    :type name: str
    :param description: Textual description of resource.
    :type description: str
    :ivar e_tag: The ETag value to implement optimistic concurrency.
    :vartype e_tag: str
    """

    _validation = {
        'farmer_id': {'readonly': True},
        'original_file_name': {'readonly': True},
        'id': {'readonly': True},
        'status': {'max_length': 100, 'min_length': 0},
        'created_date_time': {'readonly': True},
        'modified_date_time': {'readonly': True},
        'name': {'max_length': 100, 'min_length': 0},
        'description': {'max_length': 500, 'min_length': 0},
        'e_tag': {'readonly': True},
    }

    _attribute_map = {
        'farmer_id': {'key': 'farmerId', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'original_file_name': {'key': 'originalFileName', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'modified_date_time': {'key': 'modifiedDateTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Attachment, self).__init__(**kwargs)
        self.farmer_id = None
        self.resource_id = kwargs.get('resource_id', None)
        self.resource_type = kwargs.get('resource_type', None)
        self.original_file_name = None
        self.id = None
        self.status = kwargs.get('status', None)
        self.created_date_time = None
        self.modified_date_time = None
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.e_tag = None


class AttachmentListResponse(msrest.serialization.Model):
    """Paged response contains list of requested objects and a URL link to get the next set of results.

    :param value: List of requested objects.
    :type value: list[~azure.agrifood.farming.models.Attachment]
    :param skip_token: Token used in retrieving the next page. If null, there are no additional
     pages.
    :type skip_token: str
    :param next_link: Continuation link (absolute URI) to the next page of results in the list.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Attachment]'},
        'skip_token': {'key': '$skipToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AttachmentListResponse, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.skip_token = kwargs.get('skip_token', None)
        self.next_link = kwargs.get('next_link', None)


class Boundary(msrest.serialization.Model):
    """Schema of boundary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar farmer_id: Farmer ID.
    :vartype farmer_id: str
    :param parent_id: ID of the parent(field or seasonalField) it belongs to.
    :type parent_id: str
    :param geometry: GeoJSON abstract class.
    :type geometry: ~azure.agrifood.farming.models.GeoJsonObject
    :param is_primary: Is the boundary primary.
    :type is_primary: bool
    :ivar acreage: Boundary area in acres.
    :vartype acreage: float
    :ivar parent_type: Type of the parent it belongs to.
    :vartype parent_type: str
    :ivar id: Unique resource ID.
    :vartype id: str
    :ivar e_tag: The ETag value to implement optimistic concurrency.
    :vartype e_tag: str
    :param status: Status of the resource.
    :type status: str
    :ivar created_date_time: Date-time when resource was created, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype created_date_time: ~datetime.datetime
    :ivar modified_date_time: Date-time when resource was last modified, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype modified_date_time: ~datetime.datetime
    :param name: Name to identify resource.
    :type name: str
    :param description: Textual description of the resource.
    :type description: str
    :param properties: A collection of key value pairs that belongs to the resource.
     Each pair must not have a key greater than 50 characters
     and must not have a value greater than 150 characters.
     Note: A maximum of 25 key value pairs can be provided for a resource and only string and
     numeral values are supported.
    :type properties: dict[str, any]
    """

    _validation = {
        'farmer_id': {'readonly': True},
        'acreage': {'readonly': True},
        'parent_type': {'readonly': True},
        'id': {'readonly': True},
        'e_tag': {'readonly': True},
        'status': {'max_length': 100, 'min_length': 0},
        'created_date_time': {'readonly': True},
        'modified_date_time': {'readonly': True},
        'name': {'max_length': 100, 'min_length': 0},
        'description': {'max_length': 500, 'min_length': 0},
    }

    _attribute_map = {
        'farmer_id': {'key': 'farmerId', 'type': 'str'},
        'parent_id': {'key': 'parentId', 'type': 'str'},
        'geometry': {'key': 'geometry', 'type': 'GeoJsonObject'},
        'is_primary': {'key': 'isPrimary', 'type': 'bool'},
        'acreage': {'key': 'acreage', 'type': 'float'},
        'parent_type': {'key': 'parentType', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'modified_date_time': {'key': 'modifiedDateTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Boundary, self).__init__(**kwargs)
        self.farmer_id = None
        self.parent_id = kwargs.get('parent_id', None)
        self.geometry = kwargs.get('geometry', None)
        self.is_primary = kwargs.get('is_primary', None)
        self.acreage = None
        self.parent_type = None
        self.id = None
        self.e_tag = None
        self.status = kwargs.get('status', None)
        self.created_date_time = None
        self.modified_date_time = None
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.properties = kwargs.get('properties', None)


class BoundaryListResponse(msrest.serialization.Model):
    """Paged response contains list of requested objects and a URL link to get the next set of results.

    :param value: List of requested objects.
    :type value: list[~azure.agrifood.farming.models.Boundary]
    :param skip_token: Token used in retrieving the next page. If null, there are no additional
     pages.
    :type skip_token: str
    :param next_link: Continuation link (absolute URI) to the next page of results in the list.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Boundary]'},
        'skip_token': {'key': '$skipToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BoundaryListResponse, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.skip_token = kwargs.get('skip_token', None)
        self.next_link = kwargs.get('next_link', None)


class BoundaryOverlapResponse(msrest.serialization.Model):
    """Schema of boundary overlap response.

    :param boundary_acreage: Acreage of Main boundary.
    :type boundary_acreage: float
    :param other_boundary_acreage: Acreage of other boundary.
    :type other_boundary_acreage: float
    :param intersecting_acreage: Acreage of intersecting boundary.
    :type intersecting_acreage: float
    """

    _attribute_map = {
        'boundary_acreage': {'key': 'boundaryAcreage', 'type': 'float'},
        'other_boundary_acreage': {'key': 'otherBoundaryAcreage', 'type': 'float'},
        'intersecting_acreage': {'key': 'intersectingAcreage', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BoundaryOverlapResponse, self).__init__(**kwargs)
        self.boundary_acreage = kwargs.get('boundary_acreage', None)
        self.other_boundary_acreage = kwargs.get('other_boundary_acreage', None)
        self.intersecting_acreage = kwargs.get('intersecting_acreage', None)


class CascadeDeleteJob(msrest.serialization.Model):
    """Schema of cascade delete job.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param farmer_id: Required. Farmer ID.
    :type farmer_id: str
    :param resource_id: Required. The id of the resource.
    :type resource_id: str
    :param resource_type: Required. The type of the resource.
    :type resource_type: str
    :ivar id: Unique job id.
    :vartype id: str
    :ivar status: Status of the job.
     Possible values: 'Waiting', 'Running', 'Succeeded', 'Failed', 'Cancelled'.
    :vartype status: str
    :ivar duration_in_seconds: Duration of the job in seconds.
    :vartype duration_in_seconds: float
    :ivar message: Status message to capture more details of the job.
    :vartype message: str
    :ivar created_date_time: Job created at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_action_date_time: Job was last acted upon at dateTime. Sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype last_action_date_time: ~datetime.datetime
    :ivar start_time: Job start time when available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Job end time when available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
    :vartype end_time: ~datetime.datetime
    :param name: Name to identify resource.
    :type name: str
    :param description: Textual description of the resource.
    :type description: str
    :param properties: A collection of key value pairs that belongs to the resource.
     Each pair must not have a key greater than 50 characters
     and must not have a value greater than 150 characters.
     Note: A maximum of 25 key value pairs can be provided for a resource and only string and
     numeral values are supported.
    :type properties: dict[str, any]
    """

    _validation = {
        'farmer_id': {'required': True},
        'resource_id': {'required': True},
        'resource_type': {'required': True},
        'id': {'readonly': True},
        'status': {'readonly': True},
        'duration_in_seconds': {'readonly': True},
        'message': {'readonly': True},
        'created_date_time': {'readonly': True},
        'last_action_date_time': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'name': {'max_length': 100, 'min_length': 0},
        'description': {'max_length': 500, 'min_length': 0},
    }

    _attribute_map = {
        'farmer_id': {'key': 'farmerId', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'duration_in_seconds': {'key': 'durationInSeconds', 'type': 'float'},
        'message': {'key': 'message', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_action_date_time': {'key': 'lastActionDateTime', 'type': 'iso-8601'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CascadeDeleteJob, self).__init__(**kwargs)
        self.farmer_id = kwargs['farmer_id']
        self.resource_id = kwargs['resource_id']
        self.resource_type = kwargs['resource_type']
        self.id = None
        self.status = None
        self.duration_in_seconds = None
        self.message = None
        self.created_date_time = None
        self.last_action_date_time = None
        self.start_time = None
        self.end_time = None
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.properties = kwargs.get('properties', None)


class Crop(msrest.serialization.Model):
    """Schema of crop resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param phenotype: Crop phenotype.
    :type phenotype: str
    :ivar id: Unique resource ID.
    :vartype id: str
    :ivar e_tag: The ETag value to implement optimistic concurrency.
    :vartype e_tag: str
    :param status: Status of the resource.
    :type status: str
    :ivar created_date_time: Date-time when resource was created, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype created_date_time: ~datetime.datetime
    :ivar modified_date_time: Date-time when resource was last modified, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype modified_date_time: ~datetime.datetime
    :param name: Name to identify resource.
    :type name: str
    :param description: Textual description of the resource.
    :type description: str
    :param properties: A collection of key value pairs that belongs to the resource.
     Each pair must not have a key greater than 50 characters
     and must not have a value greater than 150 characters.
     Note: A maximum of 25 key value pairs can be provided for a resource and only string and
     numeral values are supported.
    :type properties: dict[str, any]
    """

    _validation = {
        'phenotype': {'max_length': 100, 'min_length': 0},
        'id': {'readonly': True},
        'e_tag': {'readonly': True},
        'status': {'max_length': 100, 'min_length': 0},
        'created_date_time': {'readonly': True},
        'modified_date_time': {'readonly': True},
        'name': {'max_length': 100, 'min_length': 0},
        'description': {'max_length': 500, 'min_length': 0},
    }

    _attribute_map = {
        'phenotype': {'key': 'phenotype', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'modified_date_time': {'key': 'modifiedDateTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Crop, self).__init__(**kwargs)
        self.phenotype = kwargs.get('phenotype', None)
        self.id = None
        self.e_tag = None
        self.status = kwargs.get('status', None)
        self.created_date_time = None
        self.modified_date_time = None
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.properties = kwargs.get('properties', None)


class CropListResponse(msrest.serialization.Model):
    """Paged response contains list of requested objects and a URL link to get the next set of results.

    :param value: List of requested objects.
    :type value: list[~azure.agrifood.farming.models.Crop]
    :param skip_token: Token used in retrieving the next page. If null, there are no additional
     pages.
    :type skip_token: str
    :param next_link: Continuation link (absolute URI) to the next page of results in the list.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Crop]'},
        'skip_token': {'key': '$skipToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CropListResponse, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.skip_token = kwargs.get('skip_token', None)
        self.next_link = kwargs.get('next_link', None)


class CropVariety(msrest.serialization.Model):
    """Schema of crop variety resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar crop_id: ID of the crop it belongs to.
    :vartype crop_id: str
    :param brand: CropVariety Brand.
    :type brand: str
    :param product: CropVariety product.
    :type product: str
    :ivar id: Unique resource ID.
    :vartype id: str
    :ivar e_tag: The ETag value to implement optimistic concurrency.
    :vartype e_tag: str
    :param status: Status of the resource.
    :type status: str
    :ivar created_date_time: Date-time when resource was created, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype created_date_time: ~datetime.datetime
    :ivar modified_date_time: Date-time when resource was last modified, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype modified_date_time: ~datetime.datetime
    :param name: Name to identify resource.
    :type name: str
    :param description: Textual description of the resource.
    :type description: str
    :param properties: A collection of key value pairs that belongs to the resource.
     Each pair must not have a key greater than 50 characters
     and must not have a value greater than 150 characters.
     Note: A maximum of 25 key value pairs can be provided for a resource and only string and
     numeral values are supported.
    :type properties: dict[str, any]
    """

    _validation = {
        'crop_id': {'readonly': True},
        'brand': {'max_length': 100, 'min_length': 0},
        'product': {'max_length': 100, 'min_length': 0},
        'id': {'readonly': True},
        'e_tag': {'readonly': True},
        'status': {'max_length': 100, 'min_length': 0},
        'created_date_time': {'readonly': True},
        'modified_date_time': {'readonly': True},
        'name': {'max_length': 100, 'min_length': 0},
        'description': {'max_length': 500, 'min_length': 0},
    }

    _attribute_map = {
        'crop_id': {'key': 'cropId', 'type': 'str'},
        'brand': {'key': 'brand', 'type': 'str'},
        'product': {'key': 'product', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'modified_date_time': {'key': 'modifiedDateTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CropVariety, self).__init__(**kwargs)
        self.crop_id = None
        self.brand = kwargs.get('brand', None)
        self.product = kwargs.get('product', None)
        self.id = None
        self.e_tag = None
        self.status = kwargs.get('status', None)
        self.created_date_time = None
        self.modified_date_time = None
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.properties = kwargs.get('properties', None)


class CropVarietyListResponse(msrest.serialization.Model):
    """Paged response contains list of requested objects and a URL link to get the next set of results.

    :param value: List of requested objects.
    :type value: list[~azure.agrifood.farming.models.CropVariety]
    :param skip_token: Token used in retrieving the next page. If null, there are no additional
     pages.
    :type skip_token: str
    :param next_link: Continuation link (absolute URI) to the next page of results in the list.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CropVariety]'},
        'skip_token': {'key': '$skipToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CropVarietyListResponse, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.skip_token = kwargs.get('skip_token', None)
        self.next_link = kwargs.get('next_link', None)


class Error(msrest.serialization.Model):
    """An error from the Azure AgPlatform service.

    :param code: Server-defined set of error codes.
    :type code: str
    :param message: Human-readable representation of the error.
    :type message: str
    :param target: Target of the error.
    :type target: str
    :param details: Array of details about specific errors that led to this reported error.
    :type details: list[~azure.agrifood.farming.models.Error]
    :param innererror: Inner error containing list of errors.
    
     :code:`<see
     href="https://github.com/Microsoft/api-guidelines/blob/vNext/Guidelines.md#innererror--object">InnerError
     reference document</see>`.
    :type innererror: ~azure.agrifood.farming.models.InnerError
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[Error]'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Error, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)
        self.innererror = kwargs.get('innererror', None)


class ErrorResponse(msrest.serialization.Model):
    """An error response from the Azure AgPlatform service.

:code:`<see href="https://github.com/Microsoft/api-guidelines/blob/vNext/Guidelines.md#7102-error-condition-responses">ErrorResponse reference document.</see>`.

    :param error: An error from the Azure AgPlatform service.
    :type error: ~azure.agrifood.farming.models.Error
    :param trace_id: Unique trace ID.
    :type trace_id: str
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'Error'},
        'trace_id': {'key': 'traceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)
        self.trace_id = kwargs.get('trace_id', None)


class Farm(msrest.serialization.Model):
    """Schema of farm resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar farmer_id: Farmer ID.
    :vartype farmer_id: str
    :ivar id: Unique resource ID.
    :vartype id: str
    :ivar e_tag: The ETag value to implement optimistic concurrency.
    :vartype e_tag: str
    :param status: Status of the resource.
    :type status: str
    :ivar created_date_time: Date-time when resource was created, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype created_date_time: ~datetime.datetime
    :ivar modified_date_time: Date-time when resource was last modified, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype modified_date_time: ~datetime.datetime
    :param name: Name to identify resource.
    :type name: str
    :param description: Textual description of the resource.
    :type description: str
    :param properties: A collection of key value pairs that belongs to the resource.
     Each pair must not have a key greater than 50 characters
     and must not have a value greater than 150 characters.
     Note: A maximum of 25 key value pairs can be provided for a resource and only string and
     numeral values are supported.
    :type properties: dict[str, any]
    """

    _validation = {
        'farmer_id': {'readonly': True},
        'id': {'readonly': True},
        'e_tag': {'readonly': True},
        'status': {'max_length': 100, 'min_length': 0},
        'created_date_time': {'readonly': True},
        'modified_date_time': {'readonly': True},
        'name': {'max_length': 100, 'min_length': 0},
        'description': {'max_length': 500, 'min_length': 0},
    }

    _attribute_map = {
        'farmer_id': {'key': 'farmerId', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'modified_date_time': {'key': 'modifiedDateTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Farm, self).__init__(**kwargs)
        self.farmer_id = None
        self.id = None
        self.e_tag = None
        self.status = kwargs.get('status', None)
        self.created_date_time = None
        self.modified_date_time = None
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.properties = kwargs.get('properties', None)


class Farmer(msrest.serialization.Model):
    """Schema of farmer resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Unique resource ID.
    :vartype id: str
    :ivar e_tag: The ETag value to implement optimistic concurrency.
    :vartype e_tag: str
    :param status: Status of the resource.
    :type status: str
    :ivar created_date_time: Date-time when resource was created, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype created_date_time: ~datetime.datetime
    :ivar modified_date_time: Date-time when resource was last modified, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype modified_date_time: ~datetime.datetime
    :param name: Name to identify resource.
    :type name: str
    :param description: Textual description of the resource.
    :type description: str
    :param properties: A collection of key value pairs that belongs to the resource.
     Each pair must not have a key greater than 50 characters
     and must not have a value greater than 150 characters.
     Note: A maximum of 25 key value pairs can be provided for a resource and only string and
     numeral values are supported.
    :type properties: dict[str, any]
    """

    _validation = {
        'id': {'readonly': True},
        'e_tag': {'readonly': True},
        'status': {'max_length': 100, 'min_length': 0},
        'created_date_time': {'readonly': True},
        'modified_date_time': {'readonly': True},
        'name': {'max_length': 100, 'min_length': 0},
        'description': {'max_length': 500, 'min_length': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'modified_date_time': {'key': 'modifiedDateTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Farmer, self).__init__(**kwargs)
        self.id = None
        self.e_tag = None
        self.status = kwargs.get('status', None)
        self.created_date_time = None
        self.modified_date_time = None
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.properties = kwargs.get('properties', None)


class FarmerListResponse(msrest.serialization.Model):
    """Paged response contains list of requested objects and a URL link to get the next set of results.

    :param value: List of requested objects.
    :type value: list[~azure.agrifood.farming.models.Farmer]
    :param skip_token: Token used in retrieving the next page. If null, there are no additional
     pages.
    :type skip_token: str
    :param next_link: Continuation link (absolute URI) to the next page of results in the list.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Farmer]'},
        'skip_token': {'key': '$skipToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FarmerListResponse, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.skip_token = kwargs.get('skip_token', None)
        self.next_link = kwargs.get('next_link', None)


class FarmListResponse(msrest.serialization.Model):
    """Paged response contains list of requested objects and a URL link to get the next set of results.

    :param value: List of requested objects.
    :type value: list[~azure.agrifood.farming.models.Farm]
    :param skip_token: Token used in retrieving the next page. If null, there are no additional
     pages.
    :type skip_token: str
    :param next_link: Continuation link (absolute URI) to the next page of results in the list.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Farm]'},
        'skip_token': {'key': '$skipToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FarmListResponse, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.skip_token = kwargs.get('skip_token', None)
        self.next_link = kwargs.get('next_link', None)


class FarmOperationDataIngestionJob(msrest.serialization.Model):
    """Schema of farm operation data ingestion job.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param farmer_id: Required. Farmer ID.
    :type farmer_id: str
    :param auth_provider_id: Required. Authentication provider ID.
    :type auth_provider_id: str
    :param operations: List of operation types for which data needs to be downloaded. Available
     values: AllOperations, Application, Planting, Harvest, Tillage.
    :type operations: list[str]
    :param start_year: Required. Start Year (Minimum = 2000, Maximum = CurrentYear).
    :type start_year: int
    :ivar id: Unique job id.
    :vartype id: str
    :ivar status: Status of the job.
     Possible values: 'Waiting', 'Running', 'Succeeded', 'Failed', 'Cancelled'.
    :vartype status: str
    :ivar duration_in_seconds: Duration of the job in seconds.
    :vartype duration_in_seconds: float
    :ivar message: Status message to capture more details of the job.
    :vartype message: str
    :ivar created_date_time: Job created at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_action_date_time: Job was last acted upon at dateTime. Sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype last_action_date_time: ~datetime.datetime
    :ivar start_time: Job start time when available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Job end time when available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
    :vartype end_time: ~datetime.datetime
    :param name: Name to identify resource.
    :type name: str
    :param description: Textual description of the resource.
    :type description: str
    :param properties: A collection of key value pairs that belongs to the resource.
     Each pair must not have a key greater than 50 characters
     and must not have a value greater than 150 characters.
     Note: A maximum of 25 key value pairs can be provided for a resource and only string and
     numeral values are supported.
    :type properties: dict[str, any]
    """

    _validation = {
        'farmer_id': {'required': True},
        'auth_provider_id': {'required': True},
        'start_year': {'required': True},
        'id': {'readonly': True},
        'status': {'readonly': True},
        'duration_in_seconds': {'readonly': True},
        'message': {'readonly': True},
        'created_date_time': {'readonly': True},
        'last_action_date_time': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'name': {'max_length': 100, 'min_length': 0},
        'description': {'max_length': 500, 'min_length': 0},
    }

    _attribute_map = {
        'farmer_id': {'key': 'farmerId', 'type': 'str'},
        'auth_provider_id': {'key': 'authProviderId', 'type': 'str'},
        'operations': {'key': 'operations', 'type': '[str]'},
        'start_year': {'key': 'startYear', 'type': 'int'},
        'id': {'key': 'id', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'duration_in_seconds': {'key': 'durationInSeconds', 'type': 'float'},
        'message': {'key': 'message', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_action_date_time': {'key': 'lastActionDateTime', 'type': 'iso-8601'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FarmOperationDataIngestionJob, self).__init__(**kwargs)
        self.farmer_id = kwargs['farmer_id']
        self.auth_provider_id = kwargs['auth_provider_id']
        self.operations = kwargs.get('operations', None)
        self.start_year = kwargs['start_year']
        self.id = None
        self.status = None
        self.duration_in_seconds = None
        self.message = None
        self.created_date_time = None
        self.last_action_date_time = None
        self.start_time = None
        self.end_time = None
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.properties = kwargs.get('properties', None)


class Field(msrest.serialization.Model):
    """Schema of field resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param farm_id: ID of the associated Farm.
    :type farm_id: str
    :ivar farmer_id: Farmer ID.
    :vartype farmer_id: str
    :ivar primary_boundary_id: Primary boundary id.
    :vartype primary_boundary_id: str
    :ivar boundary_ids: Boundary Ids.
    :vartype boundary_ids: list[str]
    :ivar id: Unique resource ID.
    :vartype id: str
    :ivar e_tag: The ETag value to implement optimistic concurrency.
    :vartype e_tag: str
    :param status: Status of the resource.
    :type status: str
    :ivar created_date_time: Date-time when resource was created, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype created_date_time: ~datetime.datetime
    :ivar modified_date_time: Date-time when resource was last modified, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype modified_date_time: ~datetime.datetime
    :param name: Name to identify resource.
    :type name: str
    :param description: Textual description of the resource.
    :type description: str
    :param properties: A collection of key value pairs that belongs to the resource.
     Each pair must not have a key greater than 50 characters
     and must not have a value greater than 150 characters.
     Note: A maximum of 25 key value pairs can be provided for a resource and only string and
     numeral values are supported.
    :type properties: dict[str, any]
    """

    _validation = {
        'farmer_id': {'readonly': True},
        'primary_boundary_id': {'readonly': True},
        'boundary_ids': {'readonly': True, 'unique': True},
        'id': {'readonly': True},
        'e_tag': {'readonly': True},
        'status': {'max_length': 100, 'min_length': 0},
        'created_date_time': {'readonly': True},
        'modified_date_time': {'readonly': True},
        'name': {'max_length': 100, 'min_length': 0},
        'description': {'max_length': 500, 'min_length': 0},
    }

    _attribute_map = {
        'farm_id': {'key': 'farmId', 'type': 'str'},
        'farmer_id': {'key': 'farmerId', 'type': 'str'},
        'primary_boundary_id': {'key': 'primaryBoundaryId', 'type': 'str'},
        'boundary_ids': {'key': 'boundaryIds', 'type': '[str]'},
        'id': {'key': 'id', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'modified_date_time': {'key': 'modifiedDateTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Field, self).__init__(**kwargs)
        self.farm_id = kwargs.get('farm_id', None)
        self.farmer_id = None
        self.primary_boundary_id = None
        self.boundary_ids = None
        self.id = None
        self.e_tag = None
        self.status = kwargs.get('status', None)
        self.created_date_time = None
        self.modified_date_time = None
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.properties = kwargs.get('properties', None)


class FieldListResponse(msrest.serialization.Model):
    """Paged response contains list of requested objects and a URL link to get the next set of results.

    :param value: List of requested objects.
    :type value: list[~azure.agrifood.farming.models.Field]
    :param skip_token: Token used in retrieving the next page. If null, there are no additional
     pages.
    :type skip_token: str
    :param next_link: Continuation link (absolute URI) to the next page of results in the list.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Field]'},
        'skip_token': {'key': '$skipToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FieldListResponse, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.skip_token = kwargs.get('skip_token', None)
        self.next_link = kwargs.get('next_link', None)


class GeoJsonObject(msrest.serialization.Model):
    """GeoJSON abstract class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MultiPolygon, Point, Polygon.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. GeoJSON object type.Constant filled by server.  Possible values include:
     "Point", "Polygon", "MultiPolygon".
    :type type: str or ~azure.agrifood.farming.models.GeoJsonObjectType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'MultiPolygon': 'MultiPolygon', 'Point': 'Point', 'Polygon': 'Polygon'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GeoJsonObject, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class HarvestData(msrest.serialization.Model):
    """Schema of harvest data resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param total_yield: Schema for storing measurement reading and unit.
    :type total_yield: ~azure.agrifood.farming.models.Measure
    :param avg_yield: Schema for storing measurement reading and unit.
    :type avg_yield: ~azure.agrifood.farming.models.Measure
    :param total_wet_mass: Schema for storing measurement reading and unit.
    :type total_wet_mass: ~azure.agrifood.farming.models.Measure
    :param avg_wet_mass: Schema for storing measurement reading and unit.
    :type avg_wet_mass: ~azure.agrifood.farming.models.Measure
    :param avg_moisture: Schema for storing measurement reading and unit.
    :type avg_moisture: ~azure.agrifood.farming.models.Measure
    :param avg_speed: Schema for storing measurement reading and unit.
    :type avg_speed: ~azure.agrifood.farming.models.Measure
    :param harvest_product_details: Harvest product details.
    :type harvest_product_details: list[~azure.agrifood.farming.models.HarvestProductDetail]
    :param area: Schema for storing measurement reading and unit.
    :type area: ~azure.agrifood.farming.models.Measure
    :param source: Source of the operation data.
    :type source: str
    :param operation_modified_date_time: Modified date-time of the operation data, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
     Note: this will be specified by the source provider itself.
    :type operation_modified_date_time: ~datetime.datetime
    :param operation_start_date_time: Start date-time of the operation data, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :type operation_start_date_time: ~datetime.datetime
    :param operation_end_date_time: End date-time of the operation data, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :type operation_end_date_time: ~datetime.datetime
    :ivar attachments_link: Link for attachments.
    :vartype attachments_link: str
    :param associated_boundary_id: Optional boundary ID of the field for which operation was
     applied.
    :type associated_boundary_id: str
    :param operation_boundary_id: Optional boundary ID of the actual area for which operation was
     applied inside the specified field.
    :type operation_boundary_id: str
    :ivar farmer_id: Farmer ID which belongs to the operation data.
    :vartype farmer_id: str
    :ivar id: Unique resource ID.
    :vartype id: str
    :ivar e_tag: The ETag value to implement optimistic concurrency.
    :vartype e_tag: str
    :param status: Status of the resource.
    :type status: str
    :ivar created_date_time: Date-time when resource was created, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype created_date_time: ~datetime.datetime
    :ivar modified_date_time: Date-time when resource was last modified, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype modified_date_time: ~datetime.datetime
    :param name: Name to identify resource.
    :type name: str
    :param description: Textual description of the resource.
    :type description: str
    :param properties: A collection of key value pairs that belongs to the resource.
     Each pair must not have a key greater than 50 characters
     and must not have a value greater than 150 characters.
     Note: A maximum of 25 key value pairs can be provided for a resource and only string and
     numeral values are supported.
    :type properties: dict[str, any]
    """

    _validation = {
        'source': {'max_length': 100, 'min_length': 2},
        'attachments_link': {'readonly': True},
        'farmer_id': {'readonly': True},
        'id': {'readonly': True},
        'e_tag': {'readonly': True},
        'status': {'max_length': 100, 'min_length': 0},
        'created_date_time': {'readonly': True},
        'modified_date_time': {'readonly': True},
        'name': {'max_length': 100, 'min_length': 0},
        'description': {'max_length': 500, 'min_length': 0},
    }

    _attribute_map = {
        'total_yield': {'key': 'totalYield', 'type': 'Measure'},
        'avg_yield': {'key': 'avgYield', 'type': 'Measure'},
        'total_wet_mass': {'key': 'totalWetMass', 'type': 'Measure'},
        'avg_wet_mass': {'key': 'avgWetMass', 'type': 'Measure'},
        'avg_moisture': {'key': 'avgMoisture', 'type': 'Measure'},
        'avg_speed': {'key': 'avgSpeed', 'type': 'Measure'},
        'harvest_product_details': {'key': 'harvestProductDetails', 'type': '[HarvestProductDetail]'},
        'area': {'key': 'area', 'type': 'Measure'},
        'source': {'key': 'source', 'type': 'str'},
        'operation_modified_date_time': {'key': 'operationModifiedDateTime', 'type': 'iso-8601'},
        'operation_start_date_time': {'key': 'operationStartDateTime', 'type': 'iso-8601'},
        'operation_end_date_time': {'key': 'operationEndDateTime', 'type': 'iso-8601'},
        'attachments_link': {'key': 'attachmentsLink', 'type': 'str'},
        'associated_boundary_id': {'key': 'associatedBoundaryId', 'type': 'str'},
        'operation_boundary_id': {'key': 'operationBoundaryId', 'type': 'str'},
        'farmer_id': {'key': 'farmerId', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'modified_date_time': {'key': 'modifiedDateTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HarvestData, self).__init__(**kwargs)
        self.total_yield = kwargs.get('total_yield', None)
        self.avg_yield = kwargs.get('avg_yield', None)
        self.total_wet_mass = kwargs.get('total_wet_mass', None)
        self.avg_wet_mass = kwargs.get('avg_wet_mass', None)
        self.avg_moisture = kwargs.get('avg_moisture', None)
        self.avg_speed = kwargs.get('avg_speed', None)
        self.harvest_product_details = kwargs.get('harvest_product_details', None)
        self.area = kwargs.get('area', None)
        self.source = kwargs.get('source', None)
        self.operation_modified_date_time = kwargs.get('operation_modified_date_time', None)
        self.operation_start_date_time = kwargs.get('operation_start_date_time', None)
        self.operation_end_date_time = kwargs.get('operation_end_date_time', None)
        self.attachments_link = None
        self.associated_boundary_id = kwargs.get('associated_boundary_id', None)
        self.operation_boundary_id = kwargs.get('operation_boundary_id', None)
        self.farmer_id = None
        self.id = None
        self.e_tag = None
        self.status = kwargs.get('status', None)
        self.created_date_time = None
        self.modified_date_time = None
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.properties = kwargs.get('properties', None)


class HarvestDataListResponse(msrest.serialization.Model):
    """Paged response contains list of requested objects and a URL link to get the next set of results.

    :param value: List of requested objects.
    :type value: list[~azure.agrifood.farming.models.HarvestData]
    :param skip_token: Token used in retrieving the next page. If null, there are no additional
     pages.
    :type skip_token: str
    :param next_link: Continuation link (absolute URI) to the next page of results in the list.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[HarvestData]'},
        'skip_token': {'key': '$skipToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HarvestDataListResponse, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.skip_token = kwargs.get('skip_token', None)
        self.next_link = kwargs.get('next_link', None)


class HarvestProductDetail(msrest.serialization.Model):
    """Schema of product used during harvesting.

    :param product_name: Name of the product.
    :type product_name: str
    :param area: Schema for storing measurement reading and unit.
    :type area: ~azure.agrifood.farming.models.Measure
    :param total_yield: Schema for storing measurement reading and unit.
    :type total_yield: ~azure.agrifood.farming.models.Measure
    :param avg_yield: Schema for storing measurement reading and unit.
    :type avg_yield: ~azure.agrifood.farming.models.Measure
    :param avg_moisture: Schema for storing measurement reading and unit.
    :type avg_moisture: ~azure.agrifood.farming.models.Measure
    :param total_wet_mass: Schema for storing measurement reading and unit.
    :type total_wet_mass: ~azure.agrifood.farming.models.Measure
    :param avg_wet_mass: Schema for storing measurement reading and unit.
    :type avg_wet_mass: ~azure.agrifood.farming.models.Measure
    """

    _validation = {
        'product_name': {'max_length': 100, 'min_length': 1},
    }

    _attribute_map = {
        'product_name': {'key': 'productName', 'type': 'str'},
        'area': {'key': 'area', 'type': 'Measure'},
        'total_yield': {'key': 'totalYield', 'type': 'Measure'},
        'avg_yield': {'key': 'avgYield', 'type': 'Measure'},
        'avg_moisture': {'key': 'avgMoisture', 'type': 'Measure'},
        'total_wet_mass': {'key': 'totalWetMass', 'type': 'Measure'},
        'avg_wet_mass': {'key': 'avgWetMass', 'type': 'Measure'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HarvestProductDetail, self).__init__(**kwargs)
        self.product_name = kwargs.get('product_name', None)
        self.area = kwargs.get('area', None)
        self.total_yield = kwargs.get('total_yield', None)
        self.avg_yield = kwargs.get('avg_yield', None)
        self.avg_moisture = kwargs.get('avg_moisture', None)
        self.total_wet_mass = kwargs.get('total_wet_mass', None)
        self.avg_wet_mass = kwargs.get('avg_wet_mass', None)


class ImageFile(msrest.serialization.Model):
    """Schema of image file resource.

    All required parameters must be populated in order to send to Azure.

    :param file_link: Link of the image file.
    :type file_link: str
    :param name: Required. Name of the image file.
    :type name: str
    :param image_format: Supported image formats for scene resource. Possible values include:
     "TIF".
    :type image_format: str or ~azure.agrifood.farming.models.ImageFormat
    :param resolution: Resolution of image file in meters.
    :type resolution: float
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'file_link': {'key': 'fileLink', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'image_format': {'key': 'imageFormat', 'type': 'str'},
        'resolution': {'key': 'resolution', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageFile, self).__init__(**kwargs)
        self.file_link = kwargs.get('file_link', None)
        self.name = kwargs['name']
        self.image_format = kwargs.get('image_format', None)
        self.resolution = kwargs.get('resolution', None)


class ImageProcessingRasterizeJob(msrest.serialization.Model):
    """ImageProcessingRasterizeJob.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param farmer_id: Required. Farmer ID.
    :type farmer_id: str
    :param shapefile_attachment_id: Required. Shapefile attachment ID.
    :type shapefile_attachment_id: str
    :param shapefile_column_names: Required. List of shapefile column names to create raster
     attachments.
    :type shapefile_column_names: list[str]
    :ivar id: Unique job id.
    :vartype id: str
    :ivar status: Status of the job.
     Possible values: 'Waiting', 'Running', 'Succeeded', 'Failed', 'Cancelled'.
    :vartype status: str
    :ivar duration_in_seconds: Duration of the job in seconds.
    :vartype duration_in_seconds: float
    :ivar message: Status message to capture more details of the job.
    :vartype message: str
    :ivar created_date_time: Job created at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_action_date_time: Job was last acted upon at dateTime. Sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype last_action_date_time: ~datetime.datetime
    :ivar start_time: Job start time when available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Job end time when available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
    :vartype end_time: ~datetime.datetime
    :param name: Name to identify resource.
    :type name: str
    :param description: Textual description of the resource.
    :type description: str
    :param properties: A collection of key value pairs that belongs to the resource.
     Each pair must not have a key greater than 50 characters
     and must not have a value greater than 150 characters.
     Note: A maximum of 25 key value pairs can be provided for a resource and only string and
     numeral values are supported.
    :type properties: dict[str, any]
    """

    _validation = {
        'farmer_id': {'required': True},
        'shapefile_attachment_id': {'required': True},
        'shapefile_column_names': {'required': True},
        'id': {'readonly': True},
        'status': {'readonly': True},
        'duration_in_seconds': {'readonly': True},
        'message': {'readonly': True},
        'created_date_time': {'readonly': True},
        'last_action_date_time': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'name': {'max_length': 100, 'min_length': 0},
        'description': {'max_length': 500, 'min_length': 0},
    }

    _attribute_map = {
        'farmer_id': {'key': 'farmerId', 'type': 'str'},
        'shapefile_attachment_id': {'key': 'shapefileAttachmentId', 'type': 'str'},
        'shapefile_column_names': {'key': 'shapefileColumnNames', 'type': '[str]'},
        'id': {'key': 'id', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'duration_in_seconds': {'key': 'durationInSeconds', 'type': 'float'},
        'message': {'key': 'message', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_action_date_time': {'key': 'lastActionDateTime', 'type': 'iso-8601'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageProcessingRasterizeJob, self).__init__(**kwargs)
        self.farmer_id = kwargs['farmer_id']
        self.shapefile_attachment_id = kwargs['shapefile_attachment_id']
        self.shapefile_column_names = kwargs['shapefile_column_names']
        self.id = None
        self.status = None
        self.duration_in_seconds = None
        self.message = None
        self.created_date_time = None
        self.last_action_date_time = None
        self.start_time = None
        self.end_time = None
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.properties = kwargs.get('properties', None)


class InnerError(msrest.serialization.Model):
    """Inner error containing list of errors.

:code:`<see href="https://github.com/Microsoft/api-guidelines/blob/vNext/Guidelines.md#innererror--object">InnerError reference document</see>`.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param code: Specific error code than was provided by the
     containing error.
    :type code: str
    :param innererror: Inner error containing list of errors.
    
     :code:`<see
     href="https://github.com/Microsoft/api-guidelines/blob/vNext/Guidelines.md#innererror--object">InnerError
     reference document</see>`.
    :type innererror: ~azure.agrifood.farming.models.InnerError
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'code': {'key': 'code', 'type': 'str'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InnerError, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.code = kwargs.get('code', None)
        self.innererror = kwargs.get('innererror', None)


class Location(msrest.serialization.Model):
    """Location model class.

    All required parameters must be populated in order to send to Azure.

    :param latitude: Required. Latitude of the location.
    :type latitude: float
    :param longitude: Required. Longitude of the location.
    :type longitude: float
    """

    _validation = {
        'latitude': {'required': True, 'maximum': 90, 'minimum': -90},
        'longitude': {'required': True, 'maximum': 180, 'minimum': -180},
    }

    _attribute_map = {
        'latitude': {'key': 'latitude', 'type': 'float'},
        'longitude': {'key': 'longitude', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Location, self).__init__(**kwargs)
        self.latitude = kwargs['latitude']
        self.longitude = kwargs['longitude']


class Measure(msrest.serialization.Model):
    """Schema for storing measurement reading and unit.

    :param unit: Data unit.
    :type unit: str
    :param value: Data value.
    :type value: float
    """

    _validation = {
        'unit': {'max_length': 50, 'min_length': 1},
    }

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Measure, self).__init__(**kwargs)
        self.unit = kwargs.get('unit', None)
        self.value = kwargs.get('value', None)


class MultiPolygonCoordinates(msrest.serialization.Model):
    """Schema of multi polygon coordinates.

    All required parameters must be populated in order to send to Azure.

    :param coordinates: Required. Gets or sets Coordinates of GeoJSON Object.
     It must be an array of polygons, each polygon contains list of linear rings.
     For Polygons with more than one of these rings, the first MUST be the exterior ring,
     and any others MUST be interior rings.
    :type coordinates: list[list[list[list[float]]]]
    """

    _validation = {
        'coordinates': {'required': True},
    }

    _attribute_map = {
        'coordinates': {'key': 'coordinates', 'type': '[[[[float]]]]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MultiPolygonCoordinates, self).__init__(**kwargs)
        self.coordinates = kwargs['coordinates']


class MultiPolygon(GeoJsonObject, MultiPolygonCoordinates):
    """MultiPolygon geometry.

    All required parameters must be populated in order to send to Azure.

    :param coordinates: Required. Gets or sets Coordinates of GeoJSON Object.
     It must be an array of polygons, each polygon contains list of linear rings.
     For Polygons with more than one of these rings, the first MUST be the exterior ring,
     and any others MUST be interior rings.
    :type coordinates: list[list[list[list[float]]]]
    :param type: Required. GeoJSON object type.Constant filled by server.  Possible values include:
     "Point", "Polygon", "MultiPolygon".
    :type type: str or ~azure.agrifood.farming.models.GeoJsonObjectType
    """

    _validation = {
        'coordinates': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'coordinates': {'key': 'coordinates', 'type': '[[[[float]]]]'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MultiPolygon, self).__init__(**kwargs)
        self.coordinates = kwargs['coordinates']
        self.type = 'MultiPolygon'  # type: str
        self.type = 'MultiPolygon'  # type: str


class OAuthConnectRequest(msrest.serialization.Model):
    """Get OAuth config query parameters.

    All required parameters must be populated in order to send to Azure.

    :param farmer_id: Required. ID of the farmer.
    :type farmer_id: str
    :param o_auth_provider_id: Required. ID of the OAuthProvider.
    :type o_auth_provider_id: str
    :param user_redirect_link: Required. Link to redirect the user to, at the end of the oauth
     flow.
    :type user_redirect_link: str
    :param user_redirect_state: State to provide back when redirecting the user, at the end of the
     oauth flow.
    :type user_redirect_state: str
    """

    _validation = {
        'farmer_id': {'required': True},
        'o_auth_provider_id': {'required': True},
        'user_redirect_link': {'required': True, 'max_length': 1000, 'min_length': 0},
        'user_redirect_state': {'max_length': 200, 'min_length': 0},
    }

    _attribute_map = {
        'farmer_id': {'key': 'farmerId', 'type': 'str'},
        'o_auth_provider_id': {'key': 'oAuthProviderId', 'type': 'str'},
        'user_redirect_link': {'key': 'userRedirectLink', 'type': 'str'},
        'user_redirect_state': {'key': 'userRedirectState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OAuthConnectRequest, self).__init__(**kwargs)
        self.farmer_id = kwargs['farmer_id']
        self.o_auth_provider_id = kwargs['o_auth_provider_id']
        self.user_redirect_link = kwargs['user_redirect_link']
        self.user_redirect_state = kwargs.get('user_redirect_state', None)


class OAuthProvider(msrest.serialization.Model):
    """Schema of OAuth provider resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param app_id: OAuth App ID for given OAuth Provider.
    :type app_id: str
    :param app_secret: OAuth App secret for given Provider.
     Note: Won't be sent in response.
    :type app_secret: str
    :param api_key: OAuth Api key for given Provider.
     Note: currently Applicable to Climate provider. Won't be sent in response.
    :type api_key: str
    :param is_production_app: An optional flag to determine if the App is ready to be used for
     Production scenarios in the provider side or not. (Default value: false)
     Note: Currently applicable for JohnDeere.
    :type is_production_app: bool
    :ivar id: Unique OAuth provider ID.
    :vartype id: str
    :ivar e_tag: The ETag value to implement optimistic concurrency.
    :vartype e_tag: str
    :ivar created_date_time: Date-time when resource was created, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype created_date_time: ~datetime.datetime
    :ivar modified_date_time: Date-time when resource was last modified, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype modified_date_time: ~datetime.datetime
    :param name: Name to identify resource.
    :type name: str
    :param description: Textual description of the resource.
    :type description: str
    :param properties: A collection of key value pairs that belongs to the resource.
     Each pair must not have a key greater than 50 characters
     and must not have a value greater than 150 characters.
     Note: A maximum of 25 key value pairs can be provided for a resource and only string and
     numeral values are supported.
    :type properties: dict[str, any]
    """

    _validation = {
        'app_id': {'max_length': 200, 'min_length': 2},
        'app_secret': {'max_length': 200, 'min_length': 2},
        'api_key': {'max_length': 200, 'min_length': 2},
        'id': {'readonly': True},
        'e_tag': {'readonly': True},
        'created_date_time': {'readonly': True},
        'modified_date_time': {'readonly': True},
        'name': {'max_length': 100, 'min_length': 0},
        'description': {'max_length': 500, 'min_length': 0},
    }

    _attribute_map = {
        'app_id': {'key': 'appId', 'type': 'str'},
        'app_secret': {'key': 'appSecret', 'type': 'str'},
        'api_key': {'key': 'apiKey', 'type': 'str'},
        'is_production_app': {'key': 'isProductionApp', 'type': 'bool'},
        'id': {'key': 'id', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'modified_date_time': {'key': 'modifiedDateTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OAuthProvider, self).__init__(**kwargs)
        self.app_id = kwargs.get('app_id', None)
        self.app_secret = kwargs.get('app_secret', None)
        self.api_key = kwargs.get('api_key', None)
        self.is_production_app = kwargs.get('is_production_app', False)
        self.id = None
        self.e_tag = None
        self.created_date_time = None
        self.modified_date_time = None
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.properties = kwargs.get('properties', None)


class OAuthProviderListResponse(msrest.serialization.Model):
    """Paged response contains list of requested objects and a URL link to get the next set of results.

    :param value: List of requested objects.
    :type value: list[~azure.agrifood.farming.models.OAuthProvider]
    :param skip_token: Token used in retrieving the next page. If null, there are no additional
     pages.
    :type skip_token: str
    :param next_link: Continuation link (absolute URI) to the next page of results in the list.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OAuthProvider]'},
        'skip_token': {'key': '$skipToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OAuthProviderListResponse, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.skip_token = kwargs.get('skip_token', None)
        self.next_link = kwargs.get('next_link', None)


class OAuthToken(msrest.serialization.Model):
    """Schema of OAuth token resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param farmer_id: Required. Farmer ID for this OAuth config.
    :type farmer_id: str
    :param auth_provider_id: Required. ID of the OAuth provider resource containing app
     information.
    :type auth_provider_id: str
    :param is_valid: An optional flag indicating whether the token is a valid or expired (Default
     value: true).
    :type is_valid: bool
    :ivar e_tag: The ETag value to implement optimistic concurrency.
    :vartype e_tag: str
    :ivar created_date_time: Date-time when resource was created, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype created_date_time: ~datetime.datetime
    :ivar modified_date_time: Date-time when resource was last modified, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype modified_date_time: ~datetime.datetime
    """

    _validation = {
        'farmer_id': {'required': True},
        'auth_provider_id': {'required': True},
        'e_tag': {'readonly': True},
        'created_date_time': {'readonly': True},
        'modified_date_time': {'readonly': True},
    }

    _attribute_map = {
        'farmer_id': {'key': 'farmerId', 'type': 'str'},
        'auth_provider_id': {'key': 'authProviderId', 'type': 'str'},
        'is_valid': {'key': 'isValid', 'type': 'bool'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'modified_date_time': {'key': 'modifiedDateTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OAuthToken, self).__init__(**kwargs)
        self.farmer_id = kwargs['farmer_id']
        self.auth_provider_id = kwargs['auth_provider_id']
        self.is_valid = kwargs.get('is_valid', True)
        self.e_tag = None
        self.created_date_time = None
        self.modified_date_time = None


class OAuthTokenListResponse(msrest.serialization.Model):
    """Paged response contains list of requested objects and a URL link to get the next set of results.

    :param value: List of requested objects.
    :type value: list[~azure.agrifood.farming.models.OAuthToken]
    :param skip_token: Token used in retrieving the next page. If null, there are no additional
     pages.
    :type skip_token: str
    :param next_link: Continuation link (absolute URI) to the next page of results in the list.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OAuthToken]'},
        'skip_token': {'key': '$skipToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OAuthTokenListResponse, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.skip_token = kwargs.get('skip_token', None)
        self.next_link = kwargs.get('next_link', None)


class Paths1LxjoxzFarmersFarmeridAttachmentsAttachmentidPatchRequestbodyContentMultipartFormDataSchema(msrest.serialization.Model):
    """Paths1LxjoxzFarmersFarmeridAttachmentsAttachmentidPatchRequestbodyContentMultipartFormDataSchema.

    :param file: File to be uploaded.
    :type file: IO
    :param farmer_id: Farmer id for this attachment.
    :type farmer_id: str
    :param resource_id: Associated Resource id for this attachment.
    :type resource_id: str
    :param resource_type: Associated Resource type for this attachment
     i.e. Farmer, Farm, Field, SeasonalField, Boundary, FarmOperationApplicationData, HarvestData,
     TillageData, PlantingData.
    :type resource_type: str
    :param original_file_name: Original File Name for this attachment.
    :type original_file_name: str
    :param id: Unique id.
    :type id: str
    :param status: Status of the resource.
    :type status: str
    :param created_date_time: Date when resource was created.
    :type created_date_time: str
    :param modified_date_time: Date when resource was last modified.
    :type modified_date_time: str
    :param name: Name to identify resource.
    :type name: str
    :param description: Textual description of resource.
    :type description: str
    :param e_tag: The ETag value to implement optimistic concurrency.
    :type e_tag: str
    """

    _attribute_map = {
        'file': {'key': 'file', 'type': 'IO'},
        'farmer_id': {'key': 'FarmerId', 'type': 'str'},
        'resource_id': {'key': 'ResourceId', 'type': 'str'},
        'resource_type': {'key': 'ResourceType', 'type': 'str'},
        'original_file_name': {'key': 'OriginalFileName', 'type': 'str'},
        'id': {'key': 'Id', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'str'},
        'created_date_time': {'key': 'CreatedDateTime', 'type': 'str'},
        'modified_date_time': {'key': 'ModifiedDateTime', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'e_tag': {'key': 'ETag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Paths1LxjoxzFarmersFarmeridAttachmentsAttachmentidPatchRequestbodyContentMultipartFormDataSchema, self).__init__(**kwargs)
        self.file = kwargs.get('file', None)
        self.farmer_id = kwargs.get('farmer_id', None)
        self.resource_id = kwargs.get('resource_id', None)
        self.resource_type = kwargs.get('resource_type', None)
        self.original_file_name = kwargs.get('original_file_name', None)
        self.id = kwargs.get('id', None)
        self.status = kwargs.get('status', None)
        self.created_date_time = kwargs.get('created_date_time', None)
        self.modified_date_time = kwargs.get('modified_date_time', None)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.e_tag = kwargs.get('e_tag', None)


class PlantingData(msrest.serialization.Model):
    """Schema of planting data resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param avg_planting_rate: Schema for storing measurement reading and unit.
    :type avg_planting_rate: ~azure.agrifood.farming.models.Measure
    :param total_material: Schema for storing measurement reading and unit.
    :type total_material: ~azure.agrifood.farming.models.Measure
    :param avg_material: Schema for storing measurement reading and unit.
    :type avg_material: ~azure.agrifood.farming.models.Measure
    :param planting_product_details: Planting product details.
    :type planting_product_details: list[~azure.agrifood.farming.models.PlantingProductDetail]
    :param area: Schema for storing measurement reading and unit.
    :type area: ~azure.agrifood.farming.models.Measure
    :param source: Source of the operation data.
    :type source: str
    :param operation_modified_date_time: Modified date-time of the operation data, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
     Note: this will be specified by the source provider itself.
    :type operation_modified_date_time: ~datetime.datetime
    :param operation_start_date_time: Start date-time of the operation data, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :type operation_start_date_time: ~datetime.datetime
    :param operation_end_date_time: End date-time of the operation data, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :type operation_end_date_time: ~datetime.datetime
    :ivar attachments_link: Link for attachments.
    :vartype attachments_link: str
    :param associated_boundary_id: Optional boundary ID of the field for which operation was
     applied.
    :type associated_boundary_id: str
    :param operation_boundary_id: Optional boundary ID of the actual area for which operation was
     applied inside the specified field.
    :type operation_boundary_id: str
    :ivar farmer_id: Farmer ID which belongs to the operation data.
    :vartype farmer_id: str
    :ivar id: Unique resource ID.
    :vartype id: str
    :ivar e_tag: The ETag value to implement optimistic concurrency.
    :vartype e_tag: str
    :param status: Status of the resource.
    :type status: str
    :ivar created_date_time: Date-time when resource was created, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype created_date_time: ~datetime.datetime
    :ivar modified_date_time: Date-time when resource was last modified, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype modified_date_time: ~datetime.datetime
    :param name: Name to identify resource.
    :type name: str
    :param description: Textual description of the resource.
    :type description: str
    :param properties: A collection of key value pairs that belongs to the resource.
     Each pair must not have a key greater than 50 characters
     and must not have a value greater than 150 characters.
     Note: A maximum of 25 key value pairs can be provided for a resource and only string and
     numeral values are supported.
    :type properties: dict[str, any]
    """

    _validation = {
        'source': {'max_length': 100, 'min_length': 2},
        'attachments_link': {'readonly': True},
        'farmer_id': {'readonly': True},
        'id': {'readonly': True},
        'e_tag': {'readonly': True},
        'status': {'max_length': 100, 'min_length': 0},
        'created_date_time': {'readonly': True},
        'modified_date_time': {'readonly': True},
        'name': {'max_length': 100, 'min_length': 0},
        'description': {'max_length': 500, 'min_length': 0},
    }

    _attribute_map = {
        'avg_planting_rate': {'key': 'avgPlantingRate', 'type': 'Measure'},
        'total_material': {'key': 'totalMaterial', 'type': 'Measure'},
        'avg_material': {'key': 'avgMaterial', 'type': 'Measure'},
        'planting_product_details': {'key': 'plantingProductDetails', 'type': '[PlantingProductDetail]'},
        'area': {'key': 'area', 'type': 'Measure'},
        'source': {'key': 'source', 'type': 'str'},
        'operation_modified_date_time': {'key': 'operationModifiedDateTime', 'type': 'iso-8601'},
        'operation_start_date_time': {'key': 'operationStartDateTime', 'type': 'iso-8601'},
        'operation_end_date_time': {'key': 'operationEndDateTime', 'type': 'iso-8601'},
        'attachments_link': {'key': 'attachmentsLink', 'type': 'str'},
        'associated_boundary_id': {'key': 'associatedBoundaryId', 'type': 'str'},
        'operation_boundary_id': {'key': 'operationBoundaryId', 'type': 'str'},
        'farmer_id': {'key': 'farmerId', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'modified_date_time': {'key': 'modifiedDateTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PlantingData, self).__init__(**kwargs)
        self.avg_planting_rate = kwargs.get('avg_planting_rate', None)
        self.total_material = kwargs.get('total_material', None)
        self.avg_material = kwargs.get('avg_material', None)
        self.planting_product_details = kwargs.get('planting_product_details', None)
        self.area = kwargs.get('area', None)
        self.source = kwargs.get('source', None)
        self.operation_modified_date_time = kwargs.get('operation_modified_date_time', None)
        self.operation_start_date_time = kwargs.get('operation_start_date_time', None)
        self.operation_end_date_time = kwargs.get('operation_end_date_time', None)
        self.attachments_link = None
        self.associated_boundary_id = kwargs.get('associated_boundary_id', None)
        self.operation_boundary_id = kwargs.get('operation_boundary_id', None)
        self.farmer_id = None
        self.id = None
        self.e_tag = None
        self.status = kwargs.get('status', None)
        self.created_date_time = None
        self.modified_date_time = None
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.properties = kwargs.get('properties', None)


class PlantingDataListResponse(msrest.serialization.Model):
    """Paged response contains list of requested objects and a URL link to get the next set of results.

    :param value: List of requested objects.
    :type value: list[~azure.agrifood.farming.models.PlantingData]
    :param skip_token: Token used in retrieving the next page. If null, there are no additional
     pages.
    :type skip_token: str
    :param next_link: Continuation link (absolute URI) to the next page of results in the list.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PlantingData]'},
        'skip_token': {'key': '$skipToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PlantingDataListResponse, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.skip_token = kwargs.get('skip_token', None)
        self.next_link = kwargs.get('next_link', None)


class PlantingProductDetail(msrest.serialization.Model):
    """Schema for Planting product detail.

    :param product_name: Name of the product.
    :type product_name: str
    :param area: Schema for storing measurement reading and unit.
    :type area: ~azure.agrifood.farming.models.Measure
    :param total_material: Schema for storing measurement reading and unit.
    :type total_material: ~azure.agrifood.farming.models.Measure
    :param avg_material: Schema for storing measurement reading and unit.
    :type avg_material: ~azure.agrifood.farming.models.Measure
    """

    _attribute_map = {
        'product_name': {'key': 'productName', 'type': 'str'},
        'area': {'key': 'area', 'type': 'Measure'},
        'total_material': {'key': 'totalMaterial', 'type': 'Measure'},
        'avg_material': {'key': 'avgMaterial', 'type': 'Measure'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PlantingProductDetail, self).__init__(**kwargs)
        self.product_name = kwargs.get('product_name', None)
        self.area = kwargs.get('area', None)
        self.total_material = kwargs.get('total_material', None)
        self.avg_material = kwargs.get('avg_material', None)


class PointCoordinates(msrest.serialization.Model):
    """Schema of the coordinates of a point.

    All required parameters must be populated in order to send to Azure.

    :param coordinates: Required. Gets or sets the coordinate of this point.
     It must be an array of 2 or 3 elements for a 2D or 3D system.
    :type coordinates: list[float]
    """

    _validation = {
        'coordinates': {'required': True},
    }

    _attribute_map = {
        'coordinates': {'key': 'coordinates', 'type': '[float]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PointCoordinates, self).__init__(**kwargs)
        self.coordinates = kwargs['coordinates']


class Point(GeoJsonObject, PointCoordinates):
    """Point geometry.

    All required parameters must be populated in order to send to Azure.

    :param coordinates: Required. Gets or sets the coordinate of this point.
     It must be an array of 2 or 3 elements for a 2D or 3D system.
    :type coordinates: list[float]
    :param type: Required. GeoJSON object type.Constant filled by server.  Possible values include:
     "Point", "Polygon", "MultiPolygon".
    :type type: str or ~azure.agrifood.farming.models.GeoJsonObjectType
    """

    _validation = {
        'coordinates': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'coordinates': {'key': 'coordinates', 'type': '[float]'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Point, self).__init__(**kwargs)
        self.coordinates = kwargs['coordinates']
        self.type = 'Point'  # type: str
        self.type = 'Point'  # type: str


class PolygonCoordinates(msrest.serialization.Model):
    """Schema of polygon coordinates.

    All required parameters must be populated in order to send to Azure.

    :param coordinates: Required. Gets or sets type of the GeoJSON Object.
     It must be an array of linear ring coordinate arrays.
     For Polygons with more than one of these rings, the first MUST be the exterior ring,
     and any others MUST be interior rings.
    :type coordinates: list[list[list[float]]]
    """

    _validation = {
        'coordinates': {'required': True},
    }

    _attribute_map = {
        'coordinates': {'key': 'coordinates', 'type': '[[[float]]]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolygonCoordinates, self).__init__(**kwargs)
        self.coordinates = kwargs['coordinates']


class Polygon(GeoJsonObject, PolygonCoordinates):
    """Polygon geometry.

    All required parameters must be populated in order to send to Azure.

    :param coordinates: Required. Gets or sets type of the GeoJSON Object.
     It must be an array of linear ring coordinate arrays.
     For Polygons with more than one of these rings, the first MUST be the exterior ring,
     and any others MUST be interior rings.
    :type coordinates: list[list[list[float]]]
    :param type: Required. GeoJSON object type.Constant filled by server.  Possible values include:
     "Point", "Polygon", "MultiPolygon".
    :type type: str or ~azure.agrifood.farming.models.GeoJsonObjectType
    """

    _validation = {
        'coordinates': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'coordinates': {'key': 'coordinates', 'type': '[[[float]]]'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Polygon, self).__init__(**kwargs)
        self.coordinates = kwargs['coordinates']
        self.type = 'Polygon'  # type: str
        self.type = 'Polygon'  # type: str


class SatelliteData(msrest.serialization.Model):
    """Data Model for SatelliteIngestionJobRequest.

    :param image_names: List of ImageNames.
    :type image_names: list[str]
    :param image_formats: List of ImageFormats. Available value: TIF.
    :type image_formats: list[str]
    :param image_resolutions: List of ImageResolutions in meters. Available values: 10, 20, 60.
    :type image_resolutions: list[float]
    """

    _attribute_map = {
        'image_names': {'key': 'imageNames', 'type': '[str]'},
        'image_formats': {'key': 'imageFormats', 'type': '[str]'},
        'image_resolutions': {'key': 'imageResolutions', 'type': '[float]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SatelliteData, self).__init__(**kwargs)
        self.image_names = kwargs.get('image_names', None)
        self.image_formats = kwargs.get('image_formats', None)
        self.image_resolutions = kwargs.get('image_resolutions', None)


class SatelliteDataIngestionJob(msrest.serialization.Model):
    """Schema of satellite data ingestion job.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param farmer_id: Required. Farmer ID.
    :type farmer_id: str
    :param boundary_id: Required. The id of the boundary object for which satellite data is being
     fetched.
    :type boundary_id: str
    :param start_date_time: Required. Start Date.
    :type start_date_time: ~datetime.datetime
    :param end_date_time: Required. End Date.
    :type end_date_time: ~datetime.datetime
    :param provider: Provider of satellite data. Possible values include: "Microsoft".
    :type provider: str or ~azure.agrifood.farming.models.DataProvider
    :param source: Source of satellite data. Possible values include: "Sentinel_2_L2A".
    :type source: str or ~azure.agrifood.farming.models.Source
    :param data: Data Model for SatelliteIngestionJobRequest.
    :type data: ~azure.agrifood.farming.models.SatelliteData
    :ivar id: Unique job id.
    :vartype id: str
    :ivar status: Status of the job.
     Possible values: 'Waiting', 'Running', 'Succeeded', 'Failed', 'Cancelled'.
    :vartype status: str
    :ivar duration_in_seconds: Duration of the job in seconds.
    :vartype duration_in_seconds: float
    :ivar message: Status message to capture more details of the job.
    :vartype message: str
    :ivar created_date_time: Job created at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_action_date_time: Job was last acted upon at dateTime. Sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype last_action_date_time: ~datetime.datetime
    :ivar start_time: Job start time when available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Job end time when available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
    :vartype end_time: ~datetime.datetime
    :param name: Name to identify resource.
    :type name: str
    :param description: Textual description of the resource.
    :type description: str
    :param properties: A collection of key value pairs that belongs to the resource.
     Each pair must not have a key greater than 50 characters
     and must not have a value greater than 150 characters.
     Note: A maximum of 25 key value pairs can be provided for a resource and only string and
     numeral values are supported.
    :type properties: dict[str, any]
    """

    _validation = {
        'farmer_id': {'required': True},
        'boundary_id': {'required': True},
        'start_date_time': {'required': True},
        'end_date_time': {'required': True},
        'id': {'readonly': True},
        'status': {'readonly': True},
        'duration_in_seconds': {'readonly': True},
        'message': {'readonly': True},
        'created_date_time': {'readonly': True},
        'last_action_date_time': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'name': {'max_length': 100, 'min_length': 0},
        'description': {'max_length': 500, 'min_length': 0},
    }

    _attribute_map = {
        'farmer_id': {'key': 'farmerId', 'type': 'str'},
        'boundary_id': {'key': 'boundaryId', 'type': 'str'},
        'start_date_time': {'key': 'startDateTime', 'type': 'iso-8601'},
        'end_date_time': {'key': 'endDateTime', 'type': 'iso-8601'},
        'provider': {'key': 'provider', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'data': {'key': 'data', 'type': 'SatelliteData'},
        'id': {'key': 'id', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'duration_in_seconds': {'key': 'durationInSeconds', 'type': 'float'},
        'message': {'key': 'message', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_action_date_time': {'key': 'lastActionDateTime', 'type': 'iso-8601'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SatelliteDataIngestionJob, self).__init__(**kwargs)
        self.farmer_id = kwargs['farmer_id']
        self.boundary_id = kwargs['boundary_id']
        self.start_date_time = kwargs['start_date_time']
        self.end_date_time = kwargs['end_date_time']
        self.provider = kwargs.get('provider', None)
        self.source = kwargs.get('source', None)
        self.data = kwargs.get('data', None)
        self.id = None
        self.status = None
        self.duration_in_seconds = None
        self.message = None
        self.created_date_time = None
        self.last_action_date_time = None
        self.start_time = None
        self.end_time = None
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.properties = kwargs.get('properties', None)


class Scene(msrest.serialization.Model):
    """Schema of scene resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param scene_date_time: Date-time of the scene, sample format: yyyy-MM-ddTHH:mm:ssZ.
    :type scene_date_time: ~datetime.datetime
    :param provider: Data provider of the scene.
    :type provider: str
    :param source: Data source of the scene.
    :type source: str
    :param image_files: Collection of image files.
    :type image_files: list[~azure.agrifood.farming.models.ImageFile]
    :param image_format: Supported image formats for scene resource. Possible values include:
     "TIF".
    :type image_format: str or ~azure.agrifood.farming.models.ImageFormat
    :param cloud_cover_percentage: Cloud cover percentage of the scene.
    :type cloud_cover_percentage: float
    :param dark_pixel_percentage: Dark pixel percentage of the scene.
    :type dark_pixel_percentage: float
    :param ndvi_median_value: Median of NDVI of the scene.
    :type ndvi_median_value: float
    :param boundary_id: Boundary ID which belongs to the scene.
    :type boundary_id: str
    :param farmer_id: Farmer ID which belongs to the scene.
    :type farmer_id: str
    :param id: Unique scene resource ID.
    :type id: str
    :ivar e_tag: The ETag value to implement optimistic concurrency.
    :vartype e_tag: str
    """

    _validation = {
        'provider': {'max_length': 100, 'min_length': 2},
        'source': {'max_length': 100, 'min_length': 2},
        'cloud_cover_percentage': {'maximum': 100, 'minimum': 0},
        'dark_pixel_percentage': {'maximum': 100, 'minimum': 0},
        'ndvi_median_value': {'maximum': 1, 'minimum': 0},
        'boundary_id': {'max_length': 100, 'min_length': 2},
        'e_tag': {'readonly': True},
    }

    _attribute_map = {
        'scene_date_time': {'key': 'sceneDateTime', 'type': 'iso-8601'},
        'provider': {'key': 'provider', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'image_files': {'key': 'imageFiles', 'type': '[ImageFile]'},
        'image_format': {'key': 'imageFormat', 'type': 'str'},
        'cloud_cover_percentage': {'key': 'cloudCoverPercentage', 'type': 'float'},
        'dark_pixel_percentage': {'key': 'darkPixelPercentage', 'type': 'float'},
        'ndvi_median_value': {'key': 'ndviMedianValue', 'type': 'float'},
        'boundary_id': {'key': 'boundaryId', 'type': 'str'},
        'farmer_id': {'key': 'farmerId', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Scene, self).__init__(**kwargs)
        self.scene_date_time = kwargs.get('scene_date_time', None)
        self.provider = kwargs.get('provider', None)
        self.source = kwargs.get('source', None)
        self.image_files = kwargs.get('image_files', None)
        self.image_format = kwargs.get('image_format', None)
        self.cloud_cover_percentage = kwargs.get('cloud_cover_percentage', None)
        self.dark_pixel_percentage = kwargs.get('dark_pixel_percentage', None)
        self.ndvi_median_value = kwargs.get('ndvi_median_value', None)
        self.boundary_id = kwargs.get('boundary_id', None)
        self.farmer_id = kwargs.get('farmer_id', None)
        self.id = kwargs.get('id', None)
        self.e_tag = None


class SceneListResponse(msrest.serialization.Model):
    """Paged response contains list of requested objects and a URL link to get the next set of results.

    :param value: List of requested objects.
    :type value: list[~azure.agrifood.farming.models.Scene]
    :param skip_token: Token used in retrieving the next page. If null, there are no additional
     pages.
    :type skip_token: str
    :param next_link: Continuation link (absolute URI) to the next page of results in the list.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Scene]'},
        'skip_token': {'key': '$skipToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SceneListResponse, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.skip_token = kwargs.get('skip_token', None)
        self.next_link = kwargs.get('next_link', None)


class SearchBoundaryQuery(msrest.serialization.Model):
    """SearchAllBoundaries and SearchBoundaries parameters.

    :param ids: Ids of the resource.
    :type ids: list[str]
    :param names: Names of the resource.
    :type names: list[str]
    :param property_filters: Filters on key-value pairs within the Properties object.
     eg. "{testKey} eq {testValue}".
    :type property_filters: list[str]
    :param statuses: Statuses of the resource.
    :type statuses: list[str]
    :param min_created_date_time: Minimum creation date of resource (inclusive).
    :type min_created_date_time: ~datetime.datetime
    :param max_created_date_time: Maximum creation date of resource (inclusive).
    :type max_created_date_time: ~datetime.datetime
    :param min_last_modified_date_time: Minimum last modified date of resource (inclusive).
    :type min_last_modified_date_time: ~datetime.datetime
    :param max_last_modified_date_time: Maximum last modified date of resource (inclusive).
    :type max_last_modified_date_time: ~datetime.datetime
    :param max_page_size: Maximum number of items needed (inclusive).
     Minimum = 10, Maximum = 1000, Default value = 50.
    :type max_page_size: int
    :param skip_token: Skip token for getting next set of results.
    :type skip_token: str
    :param is_primary: Is the boundary primary.
    :type is_primary: bool
    :param parent_type: Type of the parent it belongs to.
    :type parent_type: str
    :param parent_ids: Parent Ids of the resource.
    :type parent_ids: list[str]
    :param min_acreage: Minimum acreage of the boundary (inclusive).
    :type min_acreage: float
    :param max_acreage: Maximum acreage of the boundary (inclusive).
    :type max_acreage: float
    :param intersects_with_geometry: GeoJSON abstract class.
    :type intersects_with_geometry: ~azure.agrifood.farming.models.GeoJsonObject
    """

    _validation = {
        'max_page_size': {'maximum': 1000, 'minimum': 10},
    }

    _attribute_map = {
        'ids': {'key': 'ids', 'type': '[str]'},
        'names': {'key': 'names', 'type': '[str]'},
        'property_filters': {'key': 'propertyFilters', 'type': '[str]'},
        'statuses': {'key': 'statuses', 'type': '[str]'},
        'min_created_date_time': {'key': 'minCreatedDateTime', 'type': 'iso-8601'},
        'max_created_date_time': {'key': 'maxCreatedDateTime', 'type': 'iso-8601'},
        'min_last_modified_date_time': {'key': 'minLastModifiedDateTime', 'type': 'iso-8601'},
        'max_last_modified_date_time': {'key': 'maxLastModifiedDateTime', 'type': 'iso-8601'},
        'max_page_size': {'key': '$maxPageSize', 'type': 'int'},
        'skip_token': {'key': '$skipToken', 'type': 'str'},
        'is_primary': {'key': 'isPrimary', 'type': 'bool'},
        'parent_type': {'key': 'parentType', 'type': 'str'},
        'parent_ids': {'key': 'parentIds', 'type': '[str]'},
        'min_acreage': {'key': 'minAcreage', 'type': 'float'},
        'max_acreage': {'key': 'maxAcreage', 'type': 'float'},
        'intersects_with_geometry': {'key': 'intersectsWithGeometry', 'type': 'GeoJsonObject'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SearchBoundaryQuery, self).__init__(**kwargs)
        self.ids = kwargs.get('ids', None)
        self.names = kwargs.get('names', None)
        self.property_filters = kwargs.get('property_filters', None)
        self.statuses = kwargs.get('statuses', None)
        self.min_created_date_time = kwargs.get('min_created_date_time', None)
        self.max_created_date_time = kwargs.get('max_created_date_time', None)
        self.min_last_modified_date_time = kwargs.get('min_last_modified_date_time', None)
        self.max_last_modified_date_time = kwargs.get('max_last_modified_date_time', None)
        self.max_page_size = kwargs.get('max_page_size', 50)
        self.skip_token = kwargs.get('skip_token', None)
        self.is_primary = kwargs.get('is_primary', None)
        self.parent_type = kwargs.get('parent_type', None)
        self.parent_ids = kwargs.get('parent_ids', None)
        self.min_acreage = kwargs.get('min_acreage', None)
        self.max_acreage = kwargs.get('max_acreage', None)
        self.intersects_with_geometry = kwargs.get('intersects_with_geometry', None)


class Season(msrest.serialization.Model):
    """Schema of season resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param start_date_time: Season start datetime, sample format: yyyy-MM-ddTHH:mm:ssZ.
    :type start_date_time: ~datetime.datetime
    :param end_date_time: Season end datetime, sample format: yyyy-MM-ddTHH:mm:ssZ.
    :type end_date_time: ~datetime.datetime
    :param year: Season year.
    :type year: int
    :ivar id: Unique resource ID.
    :vartype id: str
    :ivar e_tag: The ETag value to implement optimistic concurrency.
    :vartype e_tag: str
    :param status: Status of the resource.
    :type status: str
    :ivar created_date_time: Date-time when resource was created, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype created_date_time: ~datetime.datetime
    :ivar modified_date_time: Date-time when resource was last modified, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype modified_date_time: ~datetime.datetime
    :param name: Name to identify resource.
    :type name: str
    :param description: Textual description of the resource.
    :type description: str
    :param properties: A collection of key value pairs that belongs to the resource.
     Each pair must not have a key greater than 50 characters
     and must not have a value greater than 150 characters.
     Note: A maximum of 25 key value pairs can be provided for a resource and only string and
     numeral values are supported.
    :type properties: dict[str, any]
    """

    _validation = {
        'id': {'readonly': True},
        'e_tag': {'readonly': True},
        'status': {'max_length': 100, 'min_length': 0},
        'created_date_time': {'readonly': True},
        'modified_date_time': {'readonly': True},
        'name': {'max_length': 100, 'min_length': 0},
        'description': {'max_length': 500, 'min_length': 0},
    }

    _attribute_map = {
        'start_date_time': {'key': 'startDateTime', 'type': 'iso-8601'},
        'end_date_time': {'key': 'endDateTime', 'type': 'iso-8601'},
        'year': {'key': 'year', 'type': 'int'},
        'id': {'key': 'id', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'modified_date_time': {'key': 'modifiedDateTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Season, self).__init__(**kwargs)
        self.start_date_time = kwargs.get('start_date_time', None)
        self.end_date_time = kwargs.get('end_date_time', None)
        self.year = kwargs.get('year', None)
        self.id = None
        self.e_tag = None
        self.status = kwargs.get('status', None)
        self.created_date_time = None
        self.modified_date_time = None
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.properties = kwargs.get('properties', None)


class SeasonalField(msrest.serialization.Model):
    """Schema of seasonal field resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar farmer_id: Farmer ID.
    :vartype farmer_id: str
    :ivar primary_boundary_id: Primary boundary id.
    :vartype primary_boundary_id: str
    :ivar boundary_ids: Boundary Ids.
    :vartype boundary_ids: list[str]
    :param farm_id: ID of the associated Farm.
    :type farm_id: str
    :param field_id: ID of the associated Field.
    :type field_id: str
    :param season_id: ID of the season it belongs to.
    :type season_id: str
    :param crop_variety_ids: CropVariety ids.
    :type crop_variety_ids: list[str]
    :param crop_id: ID of the crop it belongs to.
    :type crop_id: str
    :param avg_yield_value: Average yield value of the seasonal field.
    :type avg_yield_value: float
    :param avg_yield_unit: Unit of the average yield value attribute.
    :type avg_yield_unit: str
    :param avg_seed_population_value: Average seed population value of the seasonal field.
    :type avg_seed_population_value: float
    :param avg_seed_population_unit: Unit of average seed population value attribute.
    :type avg_seed_population_unit: str
    :param planting_date_time: Planting datetime, sample format: yyyy-MM-ddTHH:mm:ssZ.
    :type planting_date_time: ~datetime.datetime
    :ivar id: Unique resource ID.
    :vartype id: str
    :ivar e_tag: The ETag value to implement optimistic concurrency.
    :vartype e_tag: str
    :param status: Status of the resource.
    :type status: str
    :ivar created_date_time: Date-time when resource was created, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype created_date_time: ~datetime.datetime
    :ivar modified_date_time: Date-time when resource was last modified, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype modified_date_time: ~datetime.datetime
    :param name: Name to identify resource.
    :type name: str
    :param description: Textual description of the resource.
    :type description: str
    :param properties: A collection of key value pairs that belongs to the resource.
     Each pair must not have a key greater than 50 characters
     and must not have a value greater than 150 characters.
     Note: A maximum of 25 key value pairs can be provided for a resource and only string and
     numeral values are supported.
    :type properties: dict[str, any]
    """

    _validation = {
        'farmer_id': {'readonly': True},
        'primary_boundary_id': {'readonly': True},
        'boundary_ids': {'readonly': True, 'unique': True},
        'crop_variety_ids': {'unique': True},
        'avg_yield_unit': {'max_length': 32, 'min_length': 2},
        'avg_seed_population_unit': {'max_length': 32, 'min_length': 2},
        'id': {'readonly': True},
        'e_tag': {'readonly': True},
        'status': {'max_length': 100, 'min_length': 0},
        'created_date_time': {'readonly': True},
        'modified_date_time': {'readonly': True},
        'name': {'max_length': 100, 'min_length': 0},
        'description': {'max_length': 500, 'min_length': 0},
    }

    _attribute_map = {
        'farmer_id': {'key': 'farmerId', 'type': 'str'},
        'primary_boundary_id': {'key': 'primaryBoundaryId', 'type': 'str'},
        'boundary_ids': {'key': 'boundaryIds', 'type': '[str]'},
        'farm_id': {'key': 'farmId', 'type': 'str'},
        'field_id': {'key': 'fieldId', 'type': 'str'},
        'season_id': {'key': 'seasonId', 'type': 'str'},
        'crop_variety_ids': {'key': 'cropVarietyIds', 'type': '[str]'},
        'crop_id': {'key': 'cropId', 'type': 'str'},
        'avg_yield_value': {'key': 'avgYieldValue', 'type': 'float'},
        'avg_yield_unit': {'key': 'avgYieldUnit', 'type': 'str'},
        'avg_seed_population_value': {'key': 'avgSeedPopulationValue', 'type': 'float'},
        'avg_seed_population_unit': {'key': 'avgSeedPopulationUnit', 'type': 'str'},
        'planting_date_time': {'key': 'plantingDateTime', 'type': 'iso-8601'},
        'id': {'key': 'id', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'modified_date_time': {'key': 'modifiedDateTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SeasonalField, self).__init__(**kwargs)
        self.farmer_id = None
        self.primary_boundary_id = None
        self.boundary_ids = None
        self.farm_id = kwargs.get('farm_id', None)
        self.field_id = kwargs.get('field_id', None)
        self.season_id = kwargs.get('season_id', None)
        self.crop_variety_ids = kwargs.get('crop_variety_ids', None)
        self.crop_id = kwargs.get('crop_id', None)
        self.avg_yield_value = kwargs.get('avg_yield_value', None)
        self.avg_yield_unit = kwargs.get('avg_yield_unit', None)
        self.avg_seed_population_value = kwargs.get('avg_seed_population_value', None)
        self.avg_seed_population_unit = kwargs.get('avg_seed_population_unit', None)
        self.planting_date_time = kwargs.get('planting_date_time', None)
        self.id = None
        self.e_tag = None
        self.status = kwargs.get('status', None)
        self.created_date_time = None
        self.modified_date_time = None
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.properties = kwargs.get('properties', None)


class SeasonalFieldListResponse(msrest.serialization.Model):
    """Paged response contains list of requested objects and a URL link to get the next set of results.

    :param value: List of requested objects.
    :type value: list[~azure.agrifood.farming.models.SeasonalField]
    :param skip_token: Token used in retrieving the next page. If null, there are no additional
     pages.
    :type skip_token: str
    :param next_link: Continuation link (absolute URI) to the next page of results in the list.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SeasonalField]'},
        'skip_token': {'key': '$skipToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SeasonalFieldListResponse, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.skip_token = kwargs.get('skip_token', None)
        self.next_link = kwargs.get('next_link', None)


class SeasonListResponse(msrest.serialization.Model):
    """Paged response contains list of requested objects and a URL link to get the next set of results.

    :param value: List of requested objects.
    :type value: list[~azure.agrifood.farming.models.Season]
    :param skip_token: Token used in retrieving the next page. If null, there are no additional
     pages.
    :type skip_token: str
    :param next_link: Continuation link (absolute URI) to the next page of results in the list.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Season]'},
        'skip_token': {'key': '$skipToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SeasonListResponse, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.skip_token = kwargs.get('skip_token', None)
        self.next_link = kwargs.get('next_link', None)


class TillageData(msrest.serialization.Model):
    """Schema of tillage data resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tillage_depth: Schema for storing measurement reading and unit.
    :type tillage_depth: ~azure.agrifood.farming.models.Measure
    :param tillage_pressure: Schema for storing measurement reading and unit.
    :type tillage_pressure: ~azure.agrifood.farming.models.Measure
    :param area: Schema for storing measurement reading and unit.
    :type area: ~azure.agrifood.farming.models.Measure
    :param source: Source of the operation data.
    :type source: str
    :param operation_modified_date_time: Modified date-time of the operation data, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
     Note: this will be specified by the source provider itself.
    :type operation_modified_date_time: ~datetime.datetime
    :param operation_start_date_time: Start date-time of the operation data, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :type operation_start_date_time: ~datetime.datetime
    :param operation_end_date_time: End date-time of the operation data, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :type operation_end_date_time: ~datetime.datetime
    :ivar attachments_link: Link for attachments.
    :vartype attachments_link: str
    :param associated_boundary_id: Optional boundary ID of the field for which operation was
     applied.
    :type associated_boundary_id: str
    :param operation_boundary_id: Optional boundary ID of the actual area for which operation was
     applied inside the specified field.
    :type operation_boundary_id: str
    :ivar farmer_id: Farmer ID which belongs to the operation data.
    :vartype farmer_id: str
    :ivar id: Unique resource ID.
    :vartype id: str
    :ivar e_tag: The ETag value to implement optimistic concurrency.
    :vartype e_tag: str
    :param status: Status of the resource.
    :type status: str
    :ivar created_date_time: Date-time when resource was created, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype created_date_time: ~datetime.datetime
    :ivar modified_date_time: Date-time when resource was last modified, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype modified_date_time: ~datetime.datetime
    :param name: Name to identify resource.
    :type name: str
    :param description: Textual description of the resource.
    :type description: str
    :param properties: A collection of key value pairs that belongs to the resource.
     Each pair must not have a key greater than 50 characters
     and must not have a value greater than 150 characters.
     Note: A maximum of 25 key value pairs can be provided for a resource and only string and
     numeral values are supported.
    :type properties: dict[str, any]
    """

    _validation = {
        'source': {'max_length': 100, 'min_length': 2},
        'attachments_link': {'readonly': True},
        'farmer_id': {'readonly': True},
        'id': {'readonly': True},
        'e_tag': {'readonly': True},
        'status': {'max_length': 100, 'min_length': 0},
        'created_date_time': {'readonly': True},
        'modified_date_time': {'readonly': True},
        'name': {'max_length': 100, 'min_length': 0},
        'description': {'max_length': 500, 'min_length': 0},
    }

    _attribute_map = {
        'tillage_depth': {'key': 'tillageDepth', 'type': 'Measure'},
        'tillage_pressure': {'key': 'tillagePressure', 'type': 'Measure'},
        'area': {'key': 'area', 'type': 'Measure'},
        'source': {'key': 'source', 'type': 'str'},
        'operation_modified_date_time': {'key': 'operationModifiedDateTime', 'type': 'iso-8601'},
        'operation_start_date_time': {'key': 'operationStartDateTime', 'type': 'iso-8601'},
        'operation_end_date_time': {'key': 'operationEndDateTime', 'type': 'iso-8601'},
        'attachments_link': {'key': 'attachmentsLink', 'type': 'str'},
        'associated_boundary_id': {'key': 'associatedBoundaryId', 'type': 'str'},
        'operation_boundary_id': {'key': 'operationBoundaryId', 'type': 'str'},
        'farmer_id': {'key': 'farmerId', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'modified_date_time': {'key': 'modifiedDateTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TillageData, self).__init__(**kwargs)
        self.tillage_depth = kwargs.get('tillage_depth', None)
        self.tillage_pressure = kwargs.get('tillage_pressure', None)
        self.area = kwargs.get('area', None)
        self.source = kwargs.get('source', None)
        self.operation_modified_date_time = kwargs.get('operation_modified_date_time', None)
        self.operation_start_date_time = kwargs.get('operation_start_date_time', None)
        self.operation_end_date_time = kwargs.get('operation_end_date_time', None)
        self.attachments_link = None
        self.associated_boundary_id = kwargs.get('associated_boundary_id', None)
        self.operation_boundary_id = kwargs.get('operation_boundary_id', None)
        self.farmer_id = None
        self.id = None
        self.e_tag = None
        self.status = kwargs.get('status', None)
        self.created_date_time = None
        self.modified_date_time = None
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.properties = kwargs.get('properties', None)


class TillageDataListResponse(msrest.serialization.Model):
    """Paged response contains list of requested objects and a URL link to get the next set of results.

    :param value: List of requested objects.
    :type value: list[~azure.agrifood.farming.models.TillageData]
    :param skip_token: Token used in retrieving the next page. If null, there are no additional
     pages.
    :type skip_token: str
    :param next_link: Continuation link (absolute URI) to the next page of results in the list.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TillageData]'},
        'skip_token': {'key': '$skipToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TillageDataListResponse, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.skip_token = kwargs.get('skip_token', None)
        self.next_link = kwargs.get('next_link', None)


class WeatherData(msrest.serialization.Model):
    """Schema of weather data.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param farmer_id: Required. Farmer ID.
    :type farmer_id: str
    :param boundary_id: Required. Boundary ID.
    :type boundary_id: str
    :param extension_id: Required. ID of the weather extension.
    :type extension_id: str
    :param location: Required. Location model class.
    :type location: ~azure.agrifood.farming.models.Location
    :param date_time: Required. Date-time of the weather data, sample format: yyyy-MM-ddTHH:mm:ssZ.
    :type date_time: ~datetime.datetime
    :param unit_system_code: Unit System like US/SI etc.
    :type unit_system_code: str
    :param extension_version: Required. Version of the weather data extension.
    :type extension_version: str
    :param weather_data_type: Required. Type of weather data (forecast/historical).
    :type weather_data_type: str
    :param granularity: Required. Granularity of weather data (daily/hourly).
    :type granularity: str
    :param cloud_cover: Schema for storing measurement reading and unit.
    :type cloud_cover: ~azure.agrifood.farming.models.Measure
    :param dew_point: Schema for storing measurement reading and unit.
    :type dew_point: ~azure.agrifood.farming.models.Measure
    :param growing_degree_day: Schema for storing measurement reading and unit.
    :type growing_degree_day: ~azure.agrifood.farming.models.Measure
    :param precipitation: Schema for storing measurement reading and unit.
    :type precipitation: ~azure.agrifood.farming.models.Measure
    :param pressure: Schema for storing measurement reading and unit.
    :type pressure: ~azure.agrifood.farming.models.Measure
    :param relative_humidity: Schema for storing measurement reading and unit.
    :type relative_humidity: ~azure.agrifood.farming.models.Measure
    :param soil_moisture: Schema for storing measurement reading and unit.
    :type soil_moisture: ~azure.agrifood.farming.models.Measure
    :param soil_temperature: Schema for storing measurement reading and unit.
    :type soil_temperature: ~azure.agrifood.farming.models.Measure
    :param temperature: Schema for storing measurement reading and unit.
    :type temperature: ~azure.agrifood.farming.models.Measure
    :param visibility: Schema for storing measurement reading and unit.
    :type visibility: ~azure.agrifood.farming.models.Measure
    :param wet_bulb_temperature: Schema for storing measurement reading and unit.
    :type wet_bulb_temperature: ~azure.agrifood.farming.models.Measure
    :param wind_chill: Schema for storing measurement reading and unit.
    :type wind_chill: ~azure.agrifood.farming.models.Measure
    :param wind_direction: Schema for storing measurement reading and unit.
    :type wind_direction: ~azure.agrifood.farming.models.Measure
    :param wind_gust: Schema for storing measurement reading and unit.
    :type wind_gust: ~azure.agrifood.farming.models.Measure
    :param wind_speed: Schema for storing measurement reading and unit.
    :type wind_speed: ~azure.agrifood.farming.models.Measure
    :param id: Weather data ID.
    :type id: str
    :ivar e_tag: The ETag value to implement optimistic concurrency.
    :vartype e_tag: str
    :ivar created_date_time: Date-time when resource was created, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype created_date_time: ~datetime.datetime
    :ivar modified_date_time: Date-time when resource was last modified, sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype modified_date_time: ~datetime.datetime
    :param properties: A collection of key value pairs that belongs to the resource.
     Each pair must not have a key greater than 50 characters
     and must not have a value greater than 150 characters.
     Note: A maximum of 25 key value pairs can be provided for a resource and only string and
     numeral values are supported.
    :type properties: dict[str, any]
    """

    _validation = {
        'farmer_id': {'required': True},
        'boundary_id': {'required': True},
        'extension_id': {'required': True},
        'location': {'required': True},
        'date_time': {'required': True},
        'extension_version': {'required': True},
        'weather_data_type': {'required': True},
        'granularity': {'required': True},
        'e_tag': {'readonly': True},
        'created_date_time': {'readonly': True},
        'modified_date_time': {'readonly': True},
    }

    _attribute_map = {
        'farmer_id': {'key': 'farmerId', 'type': 'str'},
        'boundary_id': {'key': 'boundaryId', 'type': 'str'},
        'extension_id': {'key': 'extensionId', 'type': 'str'},
        'location': {'key': 'location', 'type': 'Location'},
        'date_time': {'key': 'dateTime', 'type': 'iso-8601'},
        'unit_system_code': {'key': 'unitSystemCode', 'type': 'str'},
        'extension_version': {'key': 'extensionVersion', 'type': 'str'},
        'weather_data_type': {'key': 'weatherDataType', 'type': 'str'},
        'granularity': {'key': 'granularity', 'type': 'str'},
        'cloud_cover': {'key': 'cloudCover', 'type': 'Measure'},
        'dew_point': {'key': 'dewPoint', 'type': 'Measure'},
        'growing_degree_day': {'key': 'growingDegreeDay', 'type': 'Measure'},
        'precipitation': {'key': 'precipitation', 'type': 'Measure'},
        'pressure': {'key': 'pressure', 'type': 'Measure'},
        'relative_humidity': {'key': 'relativeHumidity', 'type': 'Measure'},
        'soil_moisture': {'key': 'soilMoisture', 'type': 'Measure'},
        'soil_temperature': {'key': 'soilTemperature', 'type': 'Measure'},
        'temperature': {'key': 'temperature', 'type': 'Measure'},
        'visibility': {'key': 'visibility', 'type': 'Measure'},
        'wet_bulb_temperature': {'key': 'wetBulbTemperature', 'type': 'Measure'},
        'wind_chill': {'key': 'windChill', 'type': 'Measure'},
        'wind_direction': {'key': 'windDirection', 'type': 'Measure'},
        'wind_gust': {'key': 'windGust', 'type': 'Measure'},
        'wind_speed': {'key': 'windSpeed', 'type': 'Measure'},
        'id': {'key': 'id', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'modified_date_time': {'key': 'modifiedDateTime', 'type': 'iso-8601'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WeatherData, self).__init__(**kwargs)
        self.farmer_id = kwargs['farmer_id']
        self.boundary_id = kwargs['boundary_id']
        self.extension_id = kwargs['extension_id']
        self.location = kwargs['location']
        self.date_time = kwargs['date_time']
        self.unit_system_code = kwargs.get('unit_system_code', None)
        self.extension_version = kwargs['extension_version']
        self.weather_data_type = kwargs['weather_data_type']
        self.granularity = kwargs['granularity']
        self.cloud_cover = kwargs.get('cloud_cover', None)
        self.dew_point = kwargs.get('dew_point', None)
        self.growing_degree_day = kwargs.get('growing_degree_day', None)
        self.precipitation = kwargs.get('precipitation', None)
        self.pressure = kwargs.get('pressure', None)
        self.relative_humidity = kwargs.get('relative_humidity', None)
        self.soil_moisture = kwargs.get('soil_moisture', None)
        self.soil_temperature = kwargs.get('soil_temperature', None)
        self.temperature = kwargs.get('temperature', None)
        self.visibility = kwargs.get('visibility', None)
        self.wet_bulb_temperature = kwargs.get('wet_bulb_temperature', None)
        self.wind_chill = kwargs.get('wind_chill', None)
        self.wind_direction = kwargs.get('wind_direction', None)
        self.wind_gust = kwargs.get('wind_gust', None)
        self.wind_speed = kwargs.get('wind_speed', None)
        self.id = kwargs.get('id', None)
        self.e_tag = None
        self.created_date_time = None
        self.modified_date_time = None
        self.properties = kwargs.get('properties', None)


class WeatherDataDeleteJob(msrest.serialization.Model):
    """Schema of weather data delete job.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param extension_id: Required. ID of the extension to be used for the providerInput. eg.
     DTN.ClearAg.
    :type extension_id: str
    :param farmer_id: Required. The id of the farmer object for which weather data is being
     fetched.
    :type farmer_id: str
    :param boundary_id: Required. The id of the boundary object for which weather data is being
     fetched.
    :type boundary_id: str
    :param weather_data_type: Type of weather data. Possible values include: 'forecast' ,
     'historical'.
    :type weather_data_type: str
    :param granularity: Granularity of weather data. Possible values include: 'daily' , 'hourly'.
    :type granularity: str
    :param start_date_time: Weather data start UTC date-time (inclusive), sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :type start_date_time: ~datetime.datetime
    :param end_date_time: Weather data end UTC date-time (inclusive), sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :type end_date_time: ~datetime.datetime
    :ivar id: Unique job id.
    :vartype id: str
    :ivar status: Status of the job.
     Possible values: 'Waiting', 'Running', 'Succeeded', 'Failed', 'Cancelled'.
    :vartype status: str
    :ivar duration_in_seconds: Duration of the job in seconds.
    :vartype duration_in_seconds: float
    :ivar message: Status message to capture more details of the job.
    :vartype message: str
    :ivar created_date_time: Job created at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_action_date_time: Job was last acted upon at dateTime. Sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype last_action_date_time: ~datetime.datetime
    :ivar start_time: Job start time when available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Job end time when available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
    :vartype end_time: ~datetime.datetime
    :param name: Name to identify resource.
    :type name: str
    :param description: Textual description of the resource.
    :type description: str
    :param properties: A collection of key value pairs that belongs to the resource.
     Each pair must not have a key greater than 50 characters
     and must not have a value greater than 150 characters.
     Note: A maximum of 25 key value pairs can be provided for a resource and only string and
     numeral values are supported.
    :type properties: dict[str, any]
    """

    _validation = {
        'extension_id': {'required': True, 'max_length': 100, 'min_length': 2, 'pattern': r'^[A-za-z]{3,50}[.][A-za-z]{3,100}$'},
        'farmer_id': {'required': True},
        'boundary_id': {'required': True},
        'id': {'readonly': True},
        'status': {'readonly': True},
        'duration_in_seconds': {'readonly': True},
        'message': {'readonly': True},
        'created_date_time': {'readonly': True},
        'last_action_date_time': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'name': {'max_length': 100, 'min_length': 0},
        'description': {'max_length': 500, 'min_length': 0},
    }

    _attribute_map = {
        'extension_id': {'key': 'extensionId', 'type': 'str'},
        'farmer_id': {'key': 'farmerId', 'type': 'str'},
        'boundary_id': {'key': 'boundaryId', 'type': 'str'},
        'weather_data_type': {'key': 'weatherDataType', 'type': 'str'},
        'granularity': {'key': 'granularity', 'type': 'str'},
        'start_date_time': {'key': 'startDateTime', 'type': 'iso-8601'},
        'end_date_time': {'key': 'endDateTime', 'type': 'iso-8601'},
        'id': {'key': 'id', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'duration_in_seconds': {'key': 'durationInSeconds', 'type': 'float'},
        'message': {'key': 'message', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_action_date_time': {'key': 'lastActionDateTime', 'type': 'iso-8601'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WeatherDataDeleteJob, self).__init__(**kwargs)
        self.extension_id = kwargs['extension_id']
        self.farmer_id = kwargs['farmer_id']
        self.boundary_id = kwargs['boundary_id']
        self.weather_data_type = kwargs.get('weather_data_type', None)
        self.granularity = kwargs.get('granularity', None)
        self.start_date_time = kwargs.get('start_date_time', None)
        self.end_date_time = kwargs.get('end_date_time', None)
        self.id = None
        self.status = None
        self.duration_in_seconds = None
        self.message = None
        self.created_date_time = None
        self.last_action_date_time = None
        self.start_time = None
        self.end_time = None
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.properties = kwargs.get('properties', None)


class WeatherDataIngestionJob(msrest.serialization.Model):
    """Schema of weather ingestion job.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param boundary_id: Required. The id of the boundary object for which weather data is being
     fetched.
    :type boundary_id: str
    :param farmer_id: Required. The id of the farmer object for which weather data is being
     fetched.
    :type farmer_id: str
    :param extension_id: Required. ID of the extension to be used for the providerInput. eg.
     DTN.ClearAg.
    :type extension_id: str
    :param extension_api_name: Required. Extension api name to which request is to be made.
    :type extension_api_name: str
    :param extension_api_input: Required. Extension api input dictionary which would be used to
     feed request query/body/parameter information.
    :type extension_api_input: dict[str, any]
    :param extension_data_provider_app_id: App id of the weather data provider.
    :type extension_data_provider_app_id: str
    :param extension_data_provider_api_key: Api key of the weather data provider.
    :type extension_data_provider_api_key: str
    :ivar id: Unique job id.
    :vartype id: str
    :ivar status: Status of the job.
     Possible values: 'Waiting', 'Running', 'Succeeded', 'Failed', 'Cancelled'.
    :vartype status: str
    :ivar duration_in_seconds: Duration of the job in seconds.
    :vartype duration_in_seconds: float
    :ivar message: Status message to capture more details of the job.
    :vartype message: str
    :ivar created_date_time: Job created at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_action_date_time: Job was last acted upon at dateTime. Sample format:
     yyyy-MM-ddTHH:mm:ssZ.
    :vartype last_action_date_time: ~datetime.datetime
    :ivar start_time: Job start time when available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Job end time when available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
    :vartype end_time: ~datetime.datetime
    :param name: Name to identify resource.
    :type name: str
    :param description: Textual description of the resource.
    :type description: str
    :param properties: A collection of key value pairs that belongs to the resource.
     Each pair must not have a key greater than 50 characters
     and must not have a value greater than 150 characters.
     Note: A maximum of 25 key value pairs can be provided for a resource and only string and
     numeral values are supported.
    :type properties: dict[str, any]
    """

    _validation = {
        'boundary_id': {'required': True},
        'farmer_id': {'required': True},
        'extension_id': {'required': True, 'max_length': 100, 'min_length': 2, 'pattern': r'^[A-za-z]{3,50}[.][A-za-z]{3,100}$'},
        'extension_api_name': {'required': True, 'max_length': 100, 'min_length': 2},
        'extension_api_input': {'required': True},
        'extension_data_provider_app_id': {'max_length': 200, 'min_length': 2},
        'extension_data_provider_api_key': {'max_length': 200, 'min_length': 2},
        'id': {'readonly': True},
        'status': {'readonly': True},
        'duration_in_seconds': {'readonly': True},
        'message': {'readonly': True},
        'created_date_time': {'readonly': True},
        'last_action_date_time': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'name': {'max_length': 100, 'min_length': 0},
        'description': {'max_length': 500, 'min_length': 0},
    }

    _attribute_map = {
        'boundary_id': {'key': 'boundaryId', 'type': 'str'},
        'farmer_id': {'key': 'farmerId', 'type': 'str'},
        'extension_id': {'key': 'extensionId', 'type': 'str'},
        'extension_api_name': {'key': 'extensionApiName', 'type': 'str'},
        'extension_api_input': {'key': 'extensionApiInput', 'type': '{object}'},
        'extension_data_provider_app_id': {'key': 'extensionDataProviderAppId', 'type': 'str'},
        'extension_data_provider_api_key': {'key': 'extensionDataProviderApiKey', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'duration_in_seconds': {'key': 'durationInSeconds', 'type': 'float'},
        'message': {'key': 'message', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_action_date_time': {'key': 'lastActionDateTime', 'type': 'iso-8601'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WeatherDataIngestionJob, self).__init__(**kwargs)
        self.boundary_id = kwargs['boundary_id']
        self.farmer_id = kwargs['farmer_id']
        self.extension_id = kwargs['extension_id']
        self.extension_api_name = kwargs['extension_api_name']
        self.extension_api_input = kwargs['extension_api_input']
        self.extension_data_provider_app_id = kwargs.get('extension_data_provider_app_id', None)
        self.extension_data_provider_api_key = kwargs.get('extension_data_provider_api_key', None)
        self.id = None
        self.status = None
        self.duration_in_seconds = None
        self.message = None
        self.created_date_time = None
        self.last_action_date_time = None
        self.start_time = None
        self.end_time = None
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.properties = kwargs.get('properties', None)


class WeatherDataListResponse(msrest.serialization.Model):
    """Paged response contains list of requested objects and a URL link to get the next set of results.

    :param value: List of requested objects.
    :type value: list[~azure.agrifood.farming.models.WeatherData]
    :param skip_token: Token used in retrieving the next page. If null, there are no additional
     pages.
    :type skip_token: str
    :param next_link: Continuation link (absolute URI) to the next page of results in the list.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WeatherData]'},
        'skip_token': {'key': '$skipToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WeatherDataListResponse, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.skip_token = kwargs.get('skip_token', None)
        self.next_link = kwargs.get('next_link', None)
