# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from io import IOBase
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, List, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.polling.async_base_polling import AsyncLROBasePolling
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ..._operations._operations import (
    build_dev_center_create_dev_box_request,
    build_dev_center_create_or_update_environment_request,
    build_dev_center_delay_all_dev_box_actions_request,
    build_dev_center_delay_dev_box_action_request,
    build_dev_center_delete_dev_box_request,
    build_dev_center_delete_environment_request,
    build_dev_center_get_catalog_request,
    build_dev_center_get_dev_box_action_request,
    build_dev_center_get_dev_box_request,
    build_dev_center_get_environment_definition_request,
    build_dev_center_get_environment_request,
    build_dev_center_get_pool_request,
    build_dev_center_get_project_request,
    build_dev_center_get_remote_connection_request,
    build_dev_center_get_schedule_request,
    build_dev_center_list_all_dev_boxes_by_user_request,
    build_dev_center_list_all_dev_boxes_request,
    build_dev_center_list_all_environments_request,
    build_dev_center_list_catalogs_request,
    build_dev_center_list_dev_box_actions_request,
    build_dev_center_list_dev_boxes_request,
    build_dev_center_list_environment_definitions_by_catalog_request,
    build_dev_center_list_environment_definitions_request,
    build_dev_center_list_environment_types_request,
    build_dev_center_list_environments_request,
    build_dev_center_list_pools_request,
    build_dev_center_list_projects_request,
    build_dev_center_list_schedules_request,
    build_dev_center_restart_dev_box_request,
    build_dev_center_skip_dev_box_action_request,
    build_dev_center_start_dev_box_request,
    build_dev_center_stop_dev_box_request,
)
from .._vendor import DevCenterClientMixinABC

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class DevCenterClientOperationsMixin(DevCenterClientMixinABC):  # pylint: disable=too-many-public-methods
    @distributed_trace
    def list_projects(
        self, *, filter: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Lists all projects.

        :keyword filter: An OData filter clause to apply to the operation. Default value is None.
        :paramtype filter: str
        :keyword top: The maximum number of resources to return from the operation. Example: 'top=10'.
         Default value is None.
        :paramtype top: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "name": "str",  # Name of the project. Required.
                    "description": "str",  # Optional. Description of the project.
                    "maxDevBoxesPerUser": 0  # Optional. When specified, indicates the maximum
                      number of Dev Boxes a single user can create across all pools in the project.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_dev_center_list_projects_request(
                    filter=filter,
                    top=top,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_project(self, project_name: str, **kwargs: Any) -> JSON:
        """Gets a project.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "name": "str",  # Name of the project. Required.
                    "description": "str",  # Optional. Description of the project.
                    "maxDevBoxesPerUser": 0  # Optional. When specified, indicates the maximum
                      number of Dev Boxes a single user can create across all pools in the project.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_dev_center_get_project_request(
            project_name=project_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def list_pools(
        self, project_name: str, *, filter: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Lists available pools.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :keyword filter: An OData filter clause to apply to the operation. Default value is None.
        :paramtype filter: str
        :keyword top: The maximum number of resources to return from the operation. Example: 'top=10'.
         Default value is None.
        :paramtype top: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "healthStatus": "str",  # Overall health status of the Pool. Indicates
                      whether or not the Pool is available to create Dev Boxes. Required. Known values
                      are: "Unknown", "Pending", "Healthy", "Warning", and "Unhealthy".
                    "location": "str",  # Azure region where Dev Boxes in the pool are located.
                      Required.
                    "name": "str",  # Pool name. Required.
                    "hardwareProfile": {
                        "memoryGB": 0,  # Optional. The amount of memory available for the
                          Dev Box.
                        "skuName": "str",  # Optional. The name of the SKU.
                        "vCPUs": 0  # Optional. The number of vCPUs available for the Dev
                          Box.
                    },
                    "hibernateSupport": "str",  # Optional. Indicates whether hibernate is
                      enabled/disabled or unknown. Known values are: "Enabled", "Disabled", and
                      "OsUnsupported".
                    "imageReference": {
                        "name": "str",  # Optional. The name of the image used.
                        "operatingSystem": "str",  # Optional. The operating system of the
                          image.
                        "osBuildNumber": "str",  # Optional. The operating system build
                          number of the image.
                        "publishedDate": "2020-02-20 00:00:00",  # Optional. The datetime
                          that the backing image version was published.
                        "version": "str"  # Optional. The version of the image.
                    },
                    "localAdministrator": "str",  # Optional. Indicates whether owners of Dev
                      Boxes in this pool are local administrators on the Dev Boxes. Known values are:
                      "Enabled" and "Disabled".
                    "osType": "str",  # Optional. The operating system type of Dev Boxes in this
                      pool. "Windows"
                    "stopOnDisconnect": {
                        "status": "str",  # Indicates whether the feature to stop the devbox
                          on disconnect once the grace period has lapsed is enabled. Required. Known
                          values are: "Enabled" and "Disabled".
                        "gracePeriodMinutes": 0  # Optional. The specified time in minutes to
                          wait before stopping a Dev Box once disconnect is detected.
                    },
                    "storageProfile": {
                        "osDisk": {
                            "diskSizeGB": 0  # Optional. The size of the OS Disk in
                              gigabytes.
                        }
                    }
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_dev_center_list_pools_request(
                    project_name=project_name,
                    filter=filter,
                    top=top,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_pool(self, project_name: str, pool_name: str, **kwargs: Any) -> JSON:
        """Gets a pool.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param pool_name: The name of a pool of Dev Boxes. Required.
        :type pool_name: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "healthStatus": "str",  # Overall health status of the Pool. Indicates
                      whether or not the Pool is available to create Dev Boxes. Required. Known values
                      are: "Unknown", "Pending", "Healthy", "Warning", and "Unhealthy".
                    "location": "str",  # Azure region where Dev Boxes in the pool are located.
                      Required.
                    "name": "str",  # Pool name. Required.
                    "hardwareProfile": {
                        "memoryGB": 0,  # Optional. The amount of memory available for the
                          Dev Box.
                        "skuName": "str",  # Optional. The name of the SKU.
                        "vCPUs": 0  # Optional. The number of vCPUs available for the Dev
                          Box.
                    },
                    "hibernateSupport": "str",  # Optional. Indicates whether hibernate is
                      enabled/disabled or unknown. Known values are: "Enabled", "Disabled", and
                      "OsUnsupported".
                    "imageReference": {
                        "name": "str",  # Optional. The name of the image used.
                        "operatingSystem": "str",  # Optional. The operating system of the
                          image.
                        "osBuildNumber": "str",  # Optional. The operating system build
                          number of the image.
                        "publishedDate": "2020-02-20 00:00:00",  # Optional. The datetime
                          that the backing image version was published.
                        "version": "str"  # Optional. The version of the image.
                    },
                    "localAdministrator": "str",  # Optional. Indicates whether owners of Dev
                      Boxes in this pool are local administrators on the Dev Boxes. Known values are:
                      "Enabled" and "Disabled".
                    "osType": "str",  # Optional. The operating system type of Dev Boxes in this
                      pool. "Windows"
                    "stopOnDisconnect": {
                        "status": "str",  # Indicates whether the feature to stop the devbox
                          on disconnect once the grace period has lapsed is enabled. Required. Known
                          values are: "Enabled" and "Disabled".
                        "gracePeriodMinutes": 0  # Optional. The specified time in minutes to
                          wait before stopping a Dev Box once disconnect is detected.
                    },
                    "storageProfile": {
                        "osDisk": {
                            "diskSizeGB": 0  # Optional. The size of the OS Disk in
                              gigabytes.
                        }
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_dev_center_get_pool_request(
            project_name=project_name,
            pool_name=pool_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def list_schedules(
        self,
        project_name: str,
        pool_name: str,
        *,
        filter: Optional[str] = None,
        top: Optional[int] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Lists available schedules for a pool.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param pool_name: The name of a pool of Dev Boxes. Required.
        :type pool_name: str
        :keyword filter: An OData filter clause to apply to the operation. Default value is None.
        :paramtype filter: str
        :keyword top: The maximum number of resources to return from the operation. Example: 'top=10'.
         Default value is None.
        :paramtype top: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "frequency": "str",  # The frequency of this scheduled task. Required.
                      "Daily"
                    "name": "str",  # Display name for the Schedule. Required.
                    "time": "str",  # The target time to trigger the action. The format is HH:MM.
                      Required.
                    "timeZone": "str",  # The IANA timezone id at which the schedule should
                      execute. Required.
                    "type": "str"  # Supported type this scheduled task represents. Required.
                      "StopDevBox"
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_dev_center_list_schedules_request(
                    project_name=project_name,
                    pool_name=pool_name,
                    filter=filter,
                    top=top,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_schedule(self, project_name: str, pool_name: str, schedule_name: str, **kwargs: Any) -> JSON:
        """Gets a schedule.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param pool_name: The name of a pool of Dev Boxes. Required.
        :type pool_name: str
        :param schedule_name: The name of a schedule. Required.
        :type schedule_name: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "frequency": "str",  # The frequency of this scheduled task. Required.
                      "Daily"
                    "name": "str",  # Display name for the Schedule. Required.
                    "time": "str",  # The target time to trigger the action. The format is HH:MM.
                      Required.
                    "timeZone": "str",  # The IANA timezone id at which the schedule should
                      execute. Required.
                    "type": "str"  # Supported type this scheduled task represents. Required.
                      "StopDevBox"
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_dev_center_get_schedule_request(
            project_name=project_name,
            pool_name=pool_name,
            schedule_name=schedule_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def list_all_dev_boxes(
        self, *, filter: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Lists Dev Boxes that the caller has access to in the DevCenter.

        :keyword filter: An OData filter clause to apply to the operation. Default value is None.
        :paramtype filter: str
        :keyword top: The maximum number of resources to return from the operation. Example: 'top=10'.
         Default value is None.
        :paramtype top: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "name": "str",  # Display name for the Dev Box. Required.
                    "poolName": "str",  # The name of the Dev Box pool this machine belongs to.
                      Required.
                    "actionState": "str",  # Optional. The current action state of the Dev Box.
                      This is state is based on previous action performed by user.
                    "createdTime": "2020-02-20 00:00:00",  # Optional. Creation time of this Dev
                      Box.
                    "error": {
                        "code": "str",  # One of a server-defined set of error codes.
                          Required.
                        "message": "str",  # A human-readable representation of the error.
                          Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. One of a server-defined set of
                              error codes.
                            "innererror": ...
                        },
                        "target": "str"  # Optional. The target of the error.
                    },
                    "hardwareProfile": {
                        "memoryGB": 0,  # Optional. The amount of memory available for the
                          Dev Box.
                        "skuName": "str",  # Optional. The name of the SKU.
                        "vCPUs": 0  # Optional. The number of vCPUs available for the Dev
                          Box.
                    },
                    "hibernateSupport": "str",  # Optional. Indicates whether hibernate is
                      enabled/disabled or unknown. Known values are: "Enabled", "Disabled", and
                      "OsUnsupported".
                    "imageReference": {
                        "name": "str",  # Optional. The name of the image used.
                        "operatingSystem": "str",  # Optional. The operating system of the
                          image.
                        "osBuildNumber": "str",  # Optional. The operating system build
                          number of the image.
                        "publishedDate": "2020-02-20 00:00:00",  # Optional. The datetime
                          that the backing image version was published.
                        "version": "str"  # Optional. The version of the image.
                    },
                    "localAdministrator": "str",  # Optional. Indicates whether the owner of the
                      Dev Box is a local administrator. Known values are: "Enabled" and "Disabled".
                    "location": "str",  # Optional. Azure region where this Dev Box is located.
                      This will be the same region as the Virtual Network it is attached to.
                    "osType": "str",  # Optional. The operating system type of this Dev Box.
                      "Windows"
                    "powerState": "str",  # Optional. The current power state of the Dev Box.
                      Known values are: "Unknown", "Running", "Deallocated", "PoweredOff", and
                      "Hibernated".
                    "projectName": "str",  # Optional. Name of the project this Dev Box belongs
                      to.
                    "provisioningState": "str",  # Optional. The current provisioning state of
                      the Dev Box.
                    "storageProfile": {
                        "osDisk": {
                            "diskSizeGB": 0  # Optional. The size of the OS Disk in
                              gigabytes.
                        }
                    },
                    "uniqueId": "str",  # Optional. A unique identifier for the Dev Box. This is
                      a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
                    "user": "str"  # Optional. The AAD object id of the user this Dev Box is
                      assigned to.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_dev_center_list_all_dev_boxes_request(
                    filter=filter,
                    top=top,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_all_dev_boxes_by_user(
        self, user_id: str, *, filter: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Lists Dev Boxes in the Dev Center for a particular user.

        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Required.
        :type user_id: str
        :keyword filter: An OData filter clause to apply to the operation. Default value is None.
        :paramtype filter: str
        :keyword top: The maximum number of resources to return from the operation. Example: 'top=10'.
         Default value is None.
        :paramtype top: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "name": "str",  # Display name for the Dev Box. Required.
                    "poolName": "str",  # The name of the Dev Box pool this machine belongs to.
                      Required.
                    "actionState": "str",  # Optional. The current action state of the Dev Box.
                      This is state is based on previous action performed by user.
                    "createdTime": "2020-02-20 00:00:00",  # Optional. Creation time of this Dev
                      Box.
                    "error": {
                        "code": "str",  # One of a server-defined set of error codes.
                          Required.
                        "message": "str",  # A human-readable representation of the error.
                          Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. One of a server-defined set of
                              error codes.
                            "innererror": ...
                        },
                        "target": "str"  # Optional. The target of the error.
                    },
                    "hardwareProfile": {
                        "memoryGB": 0,  # Optional. The amount of memory available for the
                          Dev Box.
                        "skuName": "str",  # Optional. The name of the SKU.
                        "vCPUs": 0  # Optional. The number of vCPUs available for the Dev
                          Box.
                    },
                    "hibernateSupport": "str",  # Optional. Indicates whether hibernate is
                      enabled/disabled or unknown. Known values are: "Enabled", "Disabled", and
                      "OsUnsupported".
                    "imageReference": {
                        "name": "str",  # Optional. The name of the image used.
                        "operatingSystem": "str",  # Optional. The operating system of the
                          image.
                        "osBuildNumber": "str",  # Optional. The operating system build
                          number of the image.
                        "publishedDate": "2020-02-20 00:00:00",  # Optional. The datetime
                          that the backing image version was published.
                        "version": "str"  # Optional. The version of the image.
                    },
                    "localAdministrator": "str",  # Optional. Indicates whether the owner of the
                      Dev Box is a local administrator. Known values are: "Enabled" and "Disabled".
                    "location": "str",  # Optional. Azure region where this Dev Box is located.
                      This will be the same region as the Virtual Network it is attached to.
                    "osType": "str",  # Optional. The operating system type of this Dev Box.
                      "Windows"
                    "powerState": "str",  # Optional. The current power state of the Dev Box.
                      Known values are: "Unknown", "Running", "Deallocated", "PoweredOff", and
                      "Hibernated".
                    "projectName": "str",  # Optional. Name of the project this Dev Box belongs
                      to.
                    "provisioningState": "str",  # Optional. The current provisioning state of
                      the Dev Box.
                    "storageProfile": {
                        "osDisk": {
                            "diskSizeGB": 0  # Optional. The size of the OS Disk in
                              gigabytes.
                        }
                    },
                    "uniqueId": "str",  # Optional. A unique identifier for the Dev Box. This is
                      a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
                    "user": "str"  # Optional. The AAD object id of the user this Dev Box is
                      assigned to.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_dev_center_list_all_dev_boxes_by_user_request(
                    user_id=user_id,
                    filter=filter,
                    top=top,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_dev_boxes(
        self, project_name: str, user_id: str, *, filter: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Lists Dev Boxes in the project for a particular user.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Required.
        :type user_id: str
        :keyword filter: An OData filter clause to apply to the operation. Default value is None.
        :paramtype filter: str
        :keyword top: The maximum number of resources to return from the operation. Example: 'top=10'.
         Default value is None.
        :paramtype top: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "name": "str",  # Display name for the Dev Box. Required.
                    "poolName": "str",  # The name of the Dev Box pool this machine belongs to.
                      Required.
                    "actionState": "str",  # Optional. The current action state of the Dev Box.
                      This is state is based on previous action performed by user.
                    "createdTime": "2020-02-20 00:00:00",  # Optional. Creation time of this Dev
                      Box.
                    "error": {
                        "code": "str",  # One of a server-defined set of error codes.
                          Required.
                        "message": "str",  # A human-readable representation of the error.
                          Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. One of a server-defined set of
                              error codes.
                            "innererror": ...
                        },
                        "target": "str"  # Optional. The target of the error.
                    },
                    "hardwareProfile": {
                        "memoryGB": 0,  # Optional. The amount of memory available for the
                          Dev Box.
                        "skuName": "str",  # Optional. The name of the SKU.
                        "vCPUs": 0  # Optional. The number of vCPUs available for the Dev
                          Box.
                    },
                    "hibernateSupport": "str",  # Optional. Indicates whether hibernate is
                      enabled/disabled or unknown. Known values are: "Enabled", "Disabled", and
                      "OsUnsupported".
                    "imageReference": {
                        "name": "str",  # Optional. The name of the image used.
                        "operatingSystem": "str",  # Optional. The operating system of the
                          image.
                        "osBuildNumber": "str",  # Optional. The operating system build
                          number of the image.
                        "publishedDate": "2020-02-20 00:00:00",  # Optional. The datetime
                          that the backing image version was published.
                        "version": "str"  # Optional. The version of the image.
                    },
                    "localAdministrator": "str",  # Optional. Indicates whether the owner of the
                      Dev Box is a local administrator. Known values are: "Enabled" and "Disabled".
                    "location": "str",  # Optional. Azure region where this Dev Box is located.
                      This will be the same region as the Virtual Network it is attached to.
                    "osType": "str",  # Optional. The operating system type of this Dev Box.
                      "Windows"
                    "powerState": "str",  # Optional. The current power state of the Dev Box.
                      Known values are: "Unknown", "Running", "Deallocated", "PoweredOff", and
                      "Hibernated".
                    "projectName": "str",  # Optional. Name of the project this Dev Box belongs
                      to.
                    "provisioningState": "str",  # Optional. The current provisioning state of
                      the Dev Box.
                    "storageProfile": {
                        "osDisk": {
                            "diskSizeGB": 0  # Optional. The size of the OS Disk in
                              gigabytes.
                        }
                    },
                    "uniqueId": "str",  # Optional. A unique identifier for the Dev Box. This is
                      a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
                    "user": "str"  # Optional. The AAD object id of the user this Dev Box is
                      assigned to.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_dev_center_list_dev_boxes_request(
                    project_name=project_name,
                    user_id=user_id,
                    filter=filter,
                    top=top,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_dev_box(self, project_name: str, user_id: str, dev_box_name: str, **kwargs: Any) -> JSON:
        """Gets a Dev Box.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Required.
        :type user_id: str
        :param dev_box_name: The name of a Dev Box. Required.
        :type dev_box_name: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "name": "str",  # Display name for the Dev Box. Required.
                    "poolName": "str",  # The name of the Dev Box pool this machine belongs to.
                      Required.
                    "actionState": "str",  # Optional. The current action state of the Dev Box.
                      This is state is based on previous action performed by user.
                    "createdTime": "2020-02-20 00:00:00",  # Optional. Creation time of this Dev
                      Box.
                    "error": {
                        "code": "str",  # One of a server-defined set of error codes.
                          Required.
                        "message": "str",  # A human-readable representation of the error.
                          Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. One of a server-defined set of
                              error codes.
                            "innererror": ...
                        },
                        "target": "str"  # Optional. The target of the error.
                    },
                    "hardwareProfile": {
                        "memoryGB": 0,  # Optional. The amount of memory available for the
                          Dev Box.
                        "skuName": "str",  # Optional. The name of the SKU.
                        "vCPUs": 0  # Optional. The number of vCPUs available for the Dev
                          Box.
                    },
                    "hibernateSupport": "str",  # Optional. Indicates whether hibernate is
                      enabled/disabled or unknown. Known values are: "Enabled", "Disabled", and
                      "OsUnsupported".
                    "imageReference": {
                        "name": "str",  # Optional. The name of the image used.
                        "operatingSystem": "str",  # Optional. The operating system of the
                          image.
                        "osBuildNumber": "str",  # Optional. The operating system build
                          number of the image.
                        "publishedDate": "2020-02-20 00:00:00",  # Optional. The datetime
                          that the backing image version was published.
                        "version": "str"  # Optional. The version of the image.
                    },
                    "localAdministrator": "str",  # Optional. Indicates whether the owner of the
                      Dev Box is a local administrator. Known values are: "Enabled" and "Disabled".
                    "location": "str",  # Optional. Azure region where this Dev Box is located.
                      This will be the same region as the Virtual Network it is attached to.
                    "osType": "str",  # Optional. The operating system type of this Dev Box.
                      "Windows"
                    "powerState": "str",  # Optional. The current power state of the Dev Box.
                      Known values are: "Unknown", "Running", "Deallocated", "PoweredOff", and
                      "Hibernated".
                    "projectName": "str",  # Optional. Name of the project this Dev Box belongs
                      to.
                    "provisioningState": "str",  # Optional. The current provisioning state of
                      the Dev Box.
                    "storageProfile": {
                        "osDisk": {
                            "diskSizeGB": 0  # Optional. The size of the OS Disk in
                              gigabytes.
                        }
                    },
                    "uniqueId": "str",  # Optional. A unique identifier for the Dev Box. This is
                      a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
                    "user": "str"  # Optional. The AAD object id of the user this Dev Box is
                      assigned to.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_dev_center_get_dev_box_request(
            project_name=project_name,
            user_id=user_id,
            dev_box_name=dev_box_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    async def _create_dev_box_initial(
        self, project_name: str, user_id: str, dev_box_name: str, body: Union[JSON, IO], **kwargs: Any
    ) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_dev_center_create_dev_box_request(
            project_name=project_name,
            user_id=user_id,
            dev_box_name=dev_box_name,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    async def begin_create_dev_box(
        self,
        project_name: str,
        user_id: str,
        dev_box_name: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Creates or replaces a Dev Box.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Required.
        :type user_id: str
        :param dev_box_name: The name of a Dev Box. Required.
        :type dev_box_name: str
        :param body: Represents a environment. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # Display name for the Dev Box. Required.
                    "poolName": "str",  # The name of the Dev Box pool this machine belongs to.
                      Required.
                    "actionState": "str",  # Optional. The current action state of the Dev Box.
                      This is state is based on previous action performed by user.
                    "createdTime": "2020-02-20 00:00:00",  # Optional. Creation time of this Dev
                      Box.
                    "error": {
                        "code": "str",  # One of a server-defined set of error codes.
                          Required.
                        "message": "str",  # A human-readable representation of the error.
                          Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. One of a server-defined set of
                              error codes.
                            "innererror": ...
                        },
                        "target": "str"  # Optional. The target of the error.
                    },
                    "hardwareProfile": {
                        "memoryGB": 0,  # Optional. The amount of memory available for the
                          Dev Box.
                        "skuName": "str",  # Optional. The name of the SKU.
                        "vCPUs": 0  # Optional. The number of vCPUs available for the Dev
                          Box.
                    },
                    "hibernateSupport": "str",  # Optional. Indicates whether hibernate is
                      enabled/disabled or unknown. Known values are: "Enabled", "Disabled", and
                      "OsUnsupported".
                    "imageReference": {
                        "name": "str",  # Optional. The name of the image used.
                        "operatingSystem": "str",  # Optional. The operating system of the
                          image.
                        "osBuildNumber": "str",  # Optional. The operating system build
                          number of the image.
                        "publishedDate": "2020-02-20 00:00:00",  # Optional. The datetime
                          that the backing image version was published.
                        "version": "str"  # Optional. The version of the image.
                    },
                    "localAdministrator": "str",  # Optional. Indicates whether the owner of the
                      Dev Box is a local administrator. Known values are: "Enabled" and "Disabled".
                    "location": "str",  # Optional. Azure region where this Dev Box is located.
                      This will be the same region as the Virtual Network it is attached to.
                    "osType": "str",  # Optional. The operating system type of this Dev Box.
                      "Windows"
                    "powerState": "str",  # Optional. The current power state of the Dev Box.
                      Known values are: "Unknown", "Running", "Deallocated", "PoweredOff", and
                      "Hibernated".
                    "projectName": "str",  # Optional. Name of the project this Dev Box belongs
                      to.
                    "provisioningState": "str",  # Optional. The current provisioning state of
                      the Dev Box.
                    "storageProfile": {
                        "osDisk": {
                            "diskSizeGB": 0  # Optional. The size of the OS Disk in
                              gigabytes.
                        }
                    },
                    "uniqueId": "str",  # Optional. A unique identifier for the Dev Box. This is
                      a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
                    "user": "str"  # Optional. The AAD object id of the user this Dev Box is
                      assigned to.
                }

                # response body for status code(s): 200, 201
                response == {
                    "name": "str",  # Display name for the Dev Box. Required.
                    "poolName": "str",  # The name of the Dev Box pool this machine belongs to.
                      Required.
                    "actionState": "str",  # Optional. The current action state of the Dev Box.
                      This is state is based on previous action performed by user.
                    "createdTime": "2020-02-20 00:00:00",  # Optional. Creation time of this Dev
                      Box.
                    "error": {
                        "code": "str",  # One of a server-defined set of error codes.
                          Required.
                        "message": "str",  # A human-readable representation of the error.
                          Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. One of a server-defined set of
                              error codes.
                            "innererror": ...
                        },
                        "target": "str"  # Optional. The target of the error.
                    },
                    "hardwareProfile": {
                        "memoryGB": 0,  # Optional. The amount of memory available for the
                          Dev Box.
                        "skuName": "str",  # Optional. The name of the SKU.
                        "vCPUs": 0  # Optional. The number of vCPUs available for the Dev
                          Box.
                    },
                    "hibernateSupport": "str",  # Optional. Indicates whether hibernate is
                      enabled/disabled or unknown. Known values are: "Enabled", "Disabled", and
                      "OsUnsupported".
                    "imageReference": {
                        "name": "str",  # Optional. The name of the image used.
                        "operatingSystem": "str",  # Optional. The operating system of the
                          image.
                        "osBuildNumber": "str",  # Optional. The operating system build
                          number of the image.
                        "publishedDate": "2020-02-20 00:00:00",  # Optional. The datetime
                          that the backing image version was published.
                        "version": "str"  # Optional. The version of the image.
                    },
                    "localAdministrator": "str",  # Optional. Indicates whether the owner of the
                      Dev Box is a local administrator. Known values are: "Enabled" and "Disabled".
                    "location": "str",  # Optional. Azure region where this Dev Box is located.
                      This will be the same region as the Virtual Network it is attached to.
                    "osType": "str",  # Optional. The operating system type of this Dev Box.
                      "Windows"
                    "powerState": "str",  # Optional. The current power state of the Dev Box.
                      Known values are: "Unknown", "Running", "Deallocated", "PoweredOff", and
                      "Hibernated".
                    "projectName": "str",  # Optional. Name of the project this Dev Box belongs
                      to.
                    "provisioningState": "str",  # Optional. The current provisioning state of
                      the Dev Box.
                    "storageProfile": {
                        "osDisk": {
                            "diskSizeGB": 0  # Optional. The size of the OS Disk in
                              gigabytes.
                        }
                    },
                    "uniqueId": "str",  # Optional. A unique identifier for the Dev Box. This is
                      a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
                    "user": "str"  # Optional. The AAD object id of the user this Dev Box is
                      assigned to.
                }
        """

    @overload
    async def begin_create_dev_box(
        self,
        project_name: str,
        user_id: str,
        dev_box_name: str,
        body: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Creates or replaces a Dev Box.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Required.
        :type user_id: str
        :param dev_box_name: The name of a Dev Box. Required.
        :type dev_box_name: str
        :param body: Represents a environment. Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "name": "str",  # Display name for the Dev Box. Required.
                    "poolName": "str",  # The name of the Dev Box pool this machine belongs to.
                      Required.
                    "actionState": "str",  # Optional. The current action state of the Dev Box.
                      This is state is based on previous action performed by user.
                    "createdTime": "2020-02-20 00:00:00",  # Optional. Creation time of this Dev
                      Box.
                    "error": {
                        "code": "str",  # One of a server-defined set of error codes.
                          Required.
                        "message": "str",  # A human-readable representation of the error.
                          Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. One of a server-defined set of
                              error codes.
                            "innererror": ...
                        },
                        "target": "str"  # Optional. The target of the error.
                    },
                    "hardwareProfile": {
                        "memoryGB": 0,  # Optional. The amount of memory available for the
                          Dev Box.
                        "skuName": "str",  # Optional. The name of the SKU.
                        "vCPUs": 0  # Optional. The number of vCPUs available for the Dev
                          Box.
                    },
                    "hibernateSupport": "str",  # Optional. Indicates whether hibernate is
                      enabled/disabled or unknown. Known values are: "Enabled", "Disabled", and
                      "OsUnsupported".
                    "imageReference": {
                        "name": "str",  # Optional. The name of the image used.
                        "operatingSystem": "str",  # Optional. The operating system of the
                          image.
                        "osBuildNumber": "str",  # Optional. The operating system build
                          number of the image.
                        "publishedDate": "2020-02-20 00:00:00",  # Optional. The datetime
                          that the backing image version was published.
                        "version": "str"  # Optional. The version of the image.
                    },
                    "localAdministrator": "str",  # Optional. Indicates whether the owner of the
                      Dev Box is a local administrator. Known values are: "Enabled" and "Disabled".
                    "location": "str",  # Optional. Azure region where this Dev Box is located.
                      This will be the same region as the Virtual Network it is attached to.
                    "osType": "str",  # Optional. The operating system type of this Dev Box.
                      "Windows"
                    "powerState": "str",  # Optional. The current power state of the Dev Box.
                      Known values are: "Unknown", "Running", "Deallocated", "PoweredOff", and
                      "Hibernated".
                    "projectName": "str",  # Optional. Name of the project this Dev Box belongs
                      to.
                    "provisioningState": "str",  # Optional. The current provisioning state of
                      the Dev Box.
                    "storageProfile": {
                        "osDisk": {
                            "diskSizeGB": 0  # Optional. The size of the OS Disk in
                              gigabytes.
                        }
                    },
                    "uniqueId": "str",  # Optional. A unique identifier for the Dev Box. This is
                      a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
                    "user": "str"  # Optional. The AAD object id of the user this Dev Box is
                      assigned to.
                }
        """

    @distributed_trace_async
    async def begin_create_dev_box(
        self, project_name: str, user_id: str, dev_box_name: str, body: Union[JSON, IO], **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Creates or replaces a Dev Box.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Required.
        :type user_id: str
        :param dev_box_name: The name of a Dev Box. Required.
        :type dev_box_name: str
        :param body: Represents a environment. Is either a JSON type or a IO type. Required.
        :type body: JSON or IO
        :keyword content_type: Body parameter Content-Type. Known values are: application/json. Default
         value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # Display name for the Dev Box. Required.
                    "poolName": "str",  # The name of the Dev Box pool this machine belongs to.
                      Required.
                    "actionState": "str",  # Optional. The current action state of the Dev Box.
                      This is state is based on previous action performed by user.
                    "createdTime": "2020-02-20 00:00:00",  # Optional. Creation time of this Dev
                      Box.
                    "error": {
                        "code": "str",  # One of a server-defined set of error codes.
                          Required.
                        "message": "str",  # A human-readable representation of the error.
                          Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. One of a server-defined set of
                              error codes.
                            "innererror": ...
                        },
                        "target": "str"  # Optional. The target of the error.
                    },
                    "hardwareProfile": {
                        "memoryGB": 0,  # Optional. The amount of memory available for the
                          Dev Box.
                        "skuName": "str",  # Optional. The name of the SKU.
                        "vCPUs": 0  # Optional. The number of vCPUs available for the Dev
                          Box.
                    },
                    "hibernateSupport": "str",  # Optional. Indicates whether hibernate is
                      enabled/disabled or unknown. Known values are: "Enabled", "Disabled", and
                      "OsUnsupported".
                    "imageReference": {
                        "name": "str",  # Optional. The name of the image used.
                        "operatingSystem": "str",  # Optional. The operating system of the
                          image.
                        "osBuildNumber": "str",  # Optional. The operating system build
                          number of the image.
                        "publishedDate": "2020-02-20 00:00:00",  # Optional. The datetime
                          that the backing image version was published.
                        "version": "str"  # Optional. The version of the image.
                    },
                    "localAdministrator": "str",  # Optional. Indicates whether the owner of the
                      Dev Box is a local administrator. Known values are: "Enabled" and "Disabled".
                    "location": "str",  # Optional. Azure region where this Dev Box is located.
                      This will be the same region as the Virtual Network it is attached to.
                    "osType": "str",  # Optional. The operating system type of this Dev Box.
                      "Windows"
                    "powerState": "str",  # Optional. The current power state of the Dev Box.
                      Known values are: "Unknown", "Running", "Deallocated", "PoweredOff", and
                      "Hibernated".
                    "projectName": "str",  # Optional. Name of the project this Dev Box belongs
                      to.
                    "provisioningState": "str",  # Optional. The current provisioning state of
                      the Dev Box.
                    "storageProfile": {
                        "osDisk": {
                            "diskSizeGB": 0  # Optional. The size of the OS Disk in
                              gigabytes.
                        }
                    },
                    "uniqueId": "str",  # Optional. A unique identifier for the Dev Box. This is
                      a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
                    "user": "str"  # Optional. The AAD object id of the user this Dev Box is
                      assigned to.
                }

                # response body for status code(s): 200, 201
                response == {
                    "name": "str",  # Display name for the Dev Box. Required.
                    "poolName": "str",  # The name of the Dev Box pool this machine belongs to.
                      Required.
                    "actionState": "str",  # Optional. The current action state of the Dev Box.
                      This is state is based on previous action performed by user.
                    "createdTime": "2020-02-20 00:00:00",  # Optional. Creation time of this Dev
                      Box.
                    "error": {
                        "code": "str",  # One of a server-defined set of error codes.
                          Required.
                        "message": "str",  # A human-readable representation of the error.
                          Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. One of a server-defined set of
                              error codes.
                            "innererror": ...
                        },
                        "target": "str"  # Optional. The target of the error.
                    },
                    "hardwareProfile": {
                        "memoryGB": 0,  # Optional. The amount of memory available for the
                          Dev Box.
                        "skuName": "str",  # Optional. The name of the SKU.
                        "vCPUs": 0  # Optional. The number of vCPUs available for the Dev
                          Box.
                    },
                    "hibernateSupport": "str",  # Optional. Indicates whether hibernate is
                      enabled/disabled or unknown. Known values are: "Enabled", "Disabled", and
                      "OsUnsupported".
                    "imageReference": {
                        "name": "str",  # Optional. The name of the image used.
                        "operatingSystem": "str",  # Optional. The operating system of the
                          image.
                        "osBuildNumber": "str",  # Optional. The operating system build
                          number of the image.
                        "publishedDate": "2020-02-20 00:00:00",  # Optional. The datetime
                          that the backing image version was published.
                        "version": "str"  # Optional. The version of the image.
                    },
                    "localAdministrator": "str",  # Optional. Indicates whether the owner of the
                      Dev Box is a local administrator. Known values are: "Enabled" and "Disabled".
                    "location": "str",  # Optional. Azure region where this Dev Box is located.
                      This will be the same region as the Virtual Network it is attached to.
                    "osType": "str",  # Optional. The operating system type of this Dev Box.
                      "Windows"
                    "powerState": "str",  # Optional. The current power state of the Dev Box.
                      Known values are: "Unknown", "Running", "Deallocated", "PoweredOff", and
                      "Hibernated".
                    "projectName": "str",  # Optional. Name of the project this Dev Box belongs
                      to.
                    "provisioningState": "str",  # Optional. The current provisioning state of
                      the Dev Box.
                    "storageProfile": {
                        "osDisk": {
                            "diskSizeGB": 0  # Optional. The size of the OS Disk in
                              gigabytes.
                        }
                    },
                    "uniqueId": "str",  # Optional. A unique identifier for the Dev Box. This is
                      a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
                    "user": "str"  # Optional. The AAD object id of the user this Dev Box is
                      assigned to.
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_dev_box_initial(
                project_name=project_name,
                user_id=user_id,
                dev_box_name=dev_box_name,
                body=body,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[JSON].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[JSON](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _delete_dev_box_initial(
        self, project_name: str, user_id: str, dev_box_name: str, **kwargs: Any
    ) -> Optional[JSON]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Optional[JSON]] = kwargs.pop("cls", None)

        _request = build_dev_center_delete_dev_box_request(
            project_name=project_name,
            user_id=user_id,
            dev_box_name=dev_box_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_delete_dev_box(
        self, project_name: str, user_id: str, dev_box_name: str, **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Deletes a Dev Box.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Required.
        :type user_id: str
        :param dev_box_name: The name of a Dev Box. Required.
        :type dev_box_name: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "status": "str",  # Provisioning state of the resource. Required. Known
                      values are: "Running", "Completed", "Canceled", and "Failed".
                    "endTime": "2020-02-20 00:00:00",  # Optional. The end time of the operation.
                    "error": {
                        "code": "str",  # Optional. The error code.
                        "message": "str"  # Optional. The error message.
                    },
                    "id": "str",  # Optional. Fully qualified ID for the operation status.
                    "name": "str",  # Optional. The operation id name.
                    "percentComplete": 0.0,  # Optional. Percent of the operation that is
                      complete.
                    "properties": {},  # Optional. Custom operation properties, populated only
                      for a successful operation.
                    "resourceId": "str",  # Optional. The id of the resource.
                    "startTime": "2020-02-20 00:00:00"  # Optional. The start time of the
                      operation.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_dev_box_initial(
                project_name=project_name,
                user_id=user_id,
                dev_box_name=dev_box_name,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[JSON].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[JSON](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _start_dev_box_initial(self, project_name: str, user_id: str, dev_box_name: str, **kwargs: Any) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_dev_center_start_dev_box_request(
            project_name=project_name,
            user_id=user_id,
            dev_box_name=dev_box_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def begin_start_dev_box(
        self, project_name: str, user_id: str, dev_box_name: str, **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Starts a Dev Box.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Required.
        :type user_id: str
        :param dev_box_name: The name of a Dev Box. Required.
        :type dev_box_name: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "status": "str",  # Provisioning state of the resource. Required. Known
                      values are: "Running", "Completed", "Canceled", and "Failed".
                    "endTime": "2020-02-20 00:00:00",  # Optional. The end time of the operation.
                    "error": {
                        "code": "str",  # Optional. The error code.
                        "message": "str"  # Optional. The error message.
                    },
                    "id": "str",  # Optional. Fully qualified ID for the operation status.
                    "name": "str",  # Optional. The operation id name.
                    "percentComplete": 0.0,  # Optional. Percent of the operation that is
                      complete.
                    "properties": {},  # Optional. Custom operation properties, populated only
                      for a successful operation.
                    "resourceId": "str",  # Optional. The id of the resource.
                    "startTime": "2020-02-20 00:00:00"  # Optional. The start time of the
                      operation.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._start_dev_box_initial(
                project_name=project_name,
                user_id=user_id,
                dev_box_name=dev_box_name,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[JSON].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[JSON](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _stop_dev_box_initial(
        self, project_name: str, user_id: str, dev_box_name: str, *, hibernate: Optional[bool] = None, **kwargs: Any
    ) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_dev_center_stop_dev_box_request(
            project_name=project_name,
            user_id=user_id,
            dev_box_name=dev_box_name,
            hibernate=hibernate,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def begin_stop_dev_box(
        self, project_name: str, user_id: str, dev_box_name: str, *, hibernate: Optional[bool] = None, **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Stops a Dev Box.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Required.
        :type user_id: str
        :param dev_box_name: The name of a Dev Box. Required.
        :type dev_box_name: str
        :keyword hibernate: Optional parameter to hibernate the dev box. Default value is None.
        :paramtype hibernate: bool
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "status": "str",  # Provisioning state of the resource. Required. Known
                      values are: "Running", "Completed", "Canceled", and "Failed".
                    "endTime": "2020-02-20 00:00:00",  # Optional. The end time of the operation.
                    "error": {
                        "code": "str",  # Optional. The error code.
                        "message": "str"  # Optional. The error message.
                    },
                    "id": "str",  # Optional. Fully qualified ID for the operation status.
                    "name": "str",  # Optional. The operation id name.
                    "percentComplete": 0.0,  # Optional. Percent of the operation that is
                      complete.
                    "properties": {},  # Optional. Custom operation properties, populated only
                      for a successful operation.
                    "resourceId": "str",  # Optional. The id of the resource.
                    "startTime": "2020-02-20 00:00:00"  # Optional. The start time of the
                      operation.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._stop_dev_box_initial(
                project_name=project_name,
                user_id=user_id,
                dev_box_name=dev_box_name,
                hibernate=hibernate,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[JSON].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[JSON](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _restart_dev_box_initial(self, project_name: str, user_id: str, dev_box_name: str, **kwargs: Any) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_dev_center_restart_dev_box_request(
            project_name=project_name,
            user_id=user_id,
            dev_box_name=dev_box_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def begin_restart_dev_box(
        self, project_name: str, user_id: str, dev_box_name: str, **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Restarts a Dev Box.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Required.
        :type user_id: str
        :param dev_box_name: The name of a Dev Box. Required.
        :type dev_box_name: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "status": "str",  # Provisioning state of the resource. Required. Known
                      values are: "Running", "Completed", "Canceled", and "Failed".
                    "endTime": "2020-02-20 00:00:00",  # Optional. The end time of the operation.
                    "error": {
                        "code": "str",  # Optional. The error code.
                        "message": "str"  # Optional. The error message.
                    },
                    "id": "str",  # Optional. Fully qualified ID for the operation status.
                    "name": "str",  # Optional. The operation id name.
                    "percentComplete": 0.0,  # Optional. Percent of the operation that is
                      complete.
                    "properties": {},  # Optional. Custom operation properties, populated only
                      for a successful operation.
                    "resourceId": "str",  # Optional. The id of the resource.
                    "startTime": "2020-02-20 00:00:00"  # Optional. The start time of the
                      operation.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._restart_dev_box_initial(
                project_name=project_name,
                user_id=user_id,
                dev_box_name=dev_box_name,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[JSON].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[JSON](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get_remote_connection(self, project_name: str, user_id: str, dev_box_name: str, **kwargs: Any) -> JSON:
        """Gets RDP Connection info.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Required.
        :type user_id: str
        :param dev_box_name: The name of a Dev Box. Required.
        :type dev_box_name: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "rdpConnectionUrl": "str",  # Optional. Link to open a Remote Desktop
                      session.
                    "webUrl": "str"  # Optional. URL to open a browser based RDP session.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_dev_center_get_remote_connection_request(
            project_name=project_name,
            user_id=user_id,
            dev_box_name=dev_box_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def list_dev_box_actions(
        self, project_name: str, user_id: str, dev_box_name: str, **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Lists actions on a Dev Box.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Required.
        :type user_id: str
        :param dev_box_name: The name of a Dev Box. Required.
        :type dev_box_name: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "actionType": "str",  # The action that will be taken. Required. "Stop"
                    "name": "str",  # The name of the action. Required.
                    "sourceId": "str",  # The id of the resource which triggered this action.
                      Required.
                    "next": {
                        "scheduledTime": "2020-02-20 00:00:00"  # The time the action will be
                          triggered (UTC). Required.
                    },
                    "suspendedUntil": "2020-02-20 00:00:00"  # Optional. The earliest time that
                      the action could occur (UTC).
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_dev_center_list_dev_box_actions_request(
                    project_name=project_name,
                    user_id=user_id,
                    dev_box_name=dev_box_name,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_dev_box_action(
        self, project_name: str, user_id: str, dev_box_name: str, action_name: str, **kwargs: Any
    ) -> JSON:
        """Gets an action.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Required.
        :type user_id: str
        :param dev_box_name: The name of a Dev Box. Required.
        :type dev_box_name: str
        :param action_name: The name of an action that will take place on a Dev Box. Required.
        :type action_name: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "actionType": "str",  # The action that will be taken. Required. "Stop"
                    "name": "str",  # The name of the action. Required.
                    "sourceId": "str",  # The id of the resource which triggered this action.
                      Required.
                    "next": {
                        "scheduledTime": "2020-02-20 00:00:00"  # The time the action will be
                          triggered (UTC). Required.
                    },
                    "suspendedUntil": "2020-02-20 00:00:00"  # Optional. The earliest time that
                      the action could occur (UTC).
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_dev_center_get_dev_box_action_request(
            project_name=project_name,
            user_id=user_id,
            dev_box_name=dev_box_name,
            action_name=action_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def skip_dev_box_action(  # pylint: disable=inconsistent-return-statements
        self, project_name: str, user_id: str, dev_box_name: str, action_name: str, **kwargs: Any
    ) -> None:
        """Skips an occurrence of an action.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Required.
        :type user_id: str
        :param dev_box_name: The name of a Dev Box. Required.
        :type dev_box_name: str
        :param action_name: The name of an action that will take place on a Dev Box. Required.
        :type action_name: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_dev_center_skip_dev_box_action_request(
            project_name=project_name,
            user_id=user_id,
            dev_box_name=dev_box_name,
            action_name=action_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def delay_dev_box_action(
        self,
        project_name: str,
        user_id: str,
        dev_box_name: str,
        action_name: str,
        *,
        delay_until: datetime.datetime,
        **kwargs: Any
    ) -> JSON:
        """Delays the occurrence of an action.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Required.
        :type user_id: str
        :param dev_box_name: The name of a Dev Box. Required.
        :type dev_box_name: str
        :param action_name: The name of an action that will take place on a Dev Box. Required.
        :type action_name: str
        :keyword delay_until: The time to delay the Dev Box action or actions until. Required.
        :paramtype delay_until: ~datetime.datetime
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "actionType": "str",  # The action that will be taken. Required. "Stop"
                    "name": "str",  # The name of the action. Required.
                    "sourceId": "str",  # The id of the resource which triggered this action.
                      Required.
                    "next": {
                        "scheduledTime": "2020-02-20 00:00:00"  # The time the action will be
                          triggered (UTC). Required.
                    },
                    "suspendedUntil": "2020-02-20 00:00:00"  # Optional. The earliest time that
                      the action could occur (UTC).
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_dev_center_delay_dev_box_action_request(
            project_name=project_name,
            user_id=user_id,
            dev_box_name=dev_box_name,
            action_name=action_name,
            delay_until=delay_until,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def delay_all_dev_box_actions(
        self, project_name: str, user_id: str, dev_box_name: str, *, delay_until: datetime.datetime, **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Delays all actions.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Required.
        :type user_id: str
        :param dev_box_name: The name of a Dev Box. Required.
        :type dev_box_name: str
        :keyword delay_until: The time to delay the Dev Box action or actions until. Required.
        :paramtype delay_until: ~datetime.datetime
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "name": "str",  # The name of the action. Required.
                    "result": "str",  # The result of the delay operation on this action.
                      Required. Known values are: "Succeeded" and "Failed".
                    "action": {
                        "actionType": "str",  # The action that will be taken. Required.
                          "Stop"
                        "name": "str",  # The name of the action. Required.
                        "sourceId": "str",  # The id of the resource which triggered this
                          action. Required.
                        "next": {
                            "scheduledTime": "2020-02-20 00:00:00"  # The time the action
                              will be triggered (UTC). Required.
                        },
                        "suspendedUntil": "2020-02-20 00:00:00"  # Optional. The earliest
                          time that the action could occur (UTC).
                    },
                    "error": {
                        "code": "str",  # One of a server-defined set of error codes.
                          Required.
                        "message": "str",  # A human-readable representation of the error.
                          Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. One of a server-defined set of
                              error codes.
                            "innererror": ...
                        },
                        "target": "str"  # Optional. The target of the error.
                    }
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_dev_center_delay_all_dev_box_actions_request(
                    project_name=project_name,
                    user_id=user_id,
                    dev_box_name=dev_box_name,
                    delay_until=delay_until,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_all_environments(
        self, project_name: str, *, top: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Lists the environments for a project.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :keyword top: The maximum number of resources to return from the operation. Example: 'top=10'.
         Default value is None.
        :paramtype top: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "catalogName": "str",  # Name of the catalog. Required.
                    "environmentDefinitionName": "str",  # Name of the environment definition.
                      Required.
                    "environmentType": "str",  # Environment type. Required.
                    "error": {
                        "code": "str",  # One of a server-defined set of error codes.
                          Required.
                        "message": "str",  # A human-readable representation of the error.
                          Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. One of a server-defined set of
                              error codes.
                            "innererror": ...
                        },
                        "target": "str"  # Optional. The target of the error.
                    },
                    "name": "str",  # Optional. Environment name.
                    "parameters": {},  # Optional. Parameters object for the environment.
                    "provisioningState": "str",  # Optional. The provisioning state of the
                      environment.
                    "resourceGroupId": "str",  # Optional. The identifier of the resource group
                      containing the environment's resources.
                    "user": "str"  # Optional. The AAD object id of the owner of this
                      Environment.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_dev_center_list_all_environments_request(
                    project_name=project_name,
                    top=top,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_environments(
        self, project_name: str, user_id: str, *, top: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Lists the environments for a project and user.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Required.
        :type user_id: str
        :keyword top: The maximum number of resources to return from the operation. Example: 'top=10'.
         Default value is None.
        :paramtype top: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "catalogName": "str",  # Name of the catalog. Required.
                    "environmentDefinitionName": "str",  # Name of the environment definition.
                      Required.
                    "environmentType": "str",  # Environment type. Required.
                    "error": {
                        "code": "str",  # One of a server-defined set of error codes.
                          Required.
                        "message": "str",  # A human-readable representation of the error.
                          Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. One of a server-defined set of
                              error codes.
                            "innererror": ...
                        },
                        "target": "str"  # Optional. The target of the error.
                    },
                    "name": "str",  # Optional. Environment name.
                    "parameters": {},  # Optional. Parameters object for the environment.
                    "provisioningState": "str",  # Optional. The provisioning state of the
                      environment.
                    "resourceGroupId": "str",  # Optional. The identifier of the resource group
                      containing the environment's resources.
                    "user": "str"  # Optional. The AAD object id of the owner of this
                      Environment.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_dev_center_list_environments_request(
                    project_name=project_name,
                    user_id=user_id,
                    top=top,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_environment(self, project_name: str, user_id: str, environment_name: str, **kwargs: Any) -> JSON:
        """Gets an environment.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Required.
        :type user_id: str
        :param environment_name: The name of the environment. Required.
        :type environment_name: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "catalogName": "str",  # Name of the catalog. Required.
                    "environmentDefinitionName": "str",  # Name of the environment definition.
                      Required.
                    "environmentType": "str",  # Environment type. Required.
                    "error": {
                        "code": "str",  # One of a server-defined set of error codes.
                          Required.
                        "message": "str",  # A human-readable representation of the error.
                          Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. One of a server-defined set of
                              error codes.
                            "innererror": ...
                        },
                        "target": "str"  # Optional. The target of the error.
                    },
                    "name": "str",  # Optional. Environment name.
                    "parameters": {},  # Optional. Parameters object for the environment.
                    "provisioningState": "str",  # Optional. The provisioning state of the
                      environment.
                    "resourceGroupId": "str",  # Optional. The identifier of the resource group
                      containing the environment's resources.
                    "user": "str"  # Optional. The AAD object id of the owner of this
                      Environment.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_dev_center_get_environment_request(
            project_name=project_name,
            user_id=user_id,
            environment_name=environment_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    async def _create_or_update_environment_initial(
        self, project_name: str, user_id: str, environment_name: str, body: Union[JSON, IO], **kwargs: Any
    ) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_dev_center_create_or_update_environment_request(
            project_name=project_name,
            user_id=user_id,
            environment_name=environment_name,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    async def begin_create_or_update_environment(
        self,
        project_name: str,
        user_id: str,
        environment_name: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Creates or updates an environment.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Required.
        :type user_id: str
        :param environment_name: The name of the environment. Required.
        :type environment_name: str
        :param body: Represents an environment. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "catalogName": "str",  # Name of the catalog. Required.
                    "environmentDefinitionName": "str",  # Name of the environment definition.
                      Required.
                    "environmentType": "str",  # Environment type. Required.
                    "error": {
                        "code": "str",  # One of a server-defined set of error codes.
                          Required.
                        "message": "str",  # A human-readable representation of the error.
                          Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. One of a server-defined set of
                              error codes.
                            "innererror": ...
                        },
                        "target": "str"  # Optional. The target of the error.
                    },
                    "name": "str",  # Optional. Environment name.
                    "parameters": {},  # Optional. Parameters object for the environment.
                    "provisioningState": "str",  # Optional. The provisioning state of the
                      environment.
                    "resourceGroupId": "str",  # Optional. The identifier of the resource group
                      containing the environment's resources.
                    "user": "str"  # Optional. The AAD object id of the owner of this
                      Environment.
                }

                # response body for status code(s): 201
                response == {
                    "catalogName": "str",  # Name of the catalog. Required.
                    "environmentDefinitionName": "str",  # Name of the environment definition.
                      Required.
                    "environmentType": "str",  # Environment type. Required.
                    "error": {
                        "code": "str",  # One of a server-defined set of error codes.
                          Required.
                        "message": "str",  # A human-readable representation of the error.
                          Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. One of a server-defined set of
                              error codes.
                            "innererror": ...
                        },
                        "target": "str"  # Optional. The target of the error.
                    },
                    "name": "str",  # Optional. Environment name.
                    "parameters": {},  # Optional. Parameters object for the environment.
                    "provisioningState": "str",  # Optional. The provisioning state of the
                      environment.
                    "resourceGroupId": "str",  # Optional. The identifier of the resource group
                      containing the environment's resources.
                    "user": "str"  # Optional. The AAD object id of the owner of this
                      Environment.
                }
        """

    @overload
    async def begin_create_or_update_environment(
        self,
        project_name: str,
        user_id: str,
        environment_name: str,
        body: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Creates or updates an environment.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Required.
        :type user_id: str
        :param environment_name: The name of the environment. Required.
        :type environment_name: str
        :param body: Represents an environment. Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 201
                response == {
                    "catalogName": "str",  # Name of the catalog. Required.
                    "environmentDefinitionName": "str",  # Name of the environment definition.
                      Required.
                    "environmentType": "str",  # Environment type. Required.
                    "error": {
                        "code": "str",  # One of a server-defined set of error codes.
                          Required.
                        "message": "str",  # A human-readable representation of the error.
                          Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. One of a server-defined set of
                              error codes.
                            "innererror": ...
                        },
                        "target": "str"  # Optional. The target of the error.
                    },
                    "name": "str",  # Optional. Environment name.
                    "parameters": {},  # Optional. Parameters object for the environment.
                    "provisioningState": "str",  # Optional. The provisioning state of the
                      environment.
                    "resourceGroupId": "str",  # Optional. The identifier of the resource group
                      containing the environment's resources.
                    "user": "str"  # Optional. The AAD object id of the owner of this
                      Environment.
                }
        """

    @distributed_trace_async
    async def begin_create_or_update_environment(
        self, project_name: str, user_id: str, environment_name: str, body: Union[JSON, IO], **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Creates or updates an environment.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Required.
        :type user_id: str
        :param environment_name: The name of the environment. Required.
        :type environment_name: str
        :param body: Represents an environment. Is either a JSON type or a IO type. Required.
        :type body: JSON or IO
        :keyword content_type: Body parameter Content-Type. Known values are: application/json. Default
         value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "catalogName": "str",  # Name of the catalog. Required.
                    "environmentDefinitionName": "str",  # Name of the environment definition.
                      Required.
                    "environmentType": "str",  # Environment type. Required.
                    "error": {
                        "code": "str",  # One of a server-defined set of error codes.
                          Required.
                        "message": "str",  # A human-readable representation of the error.
                          Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. One of a server-defined set of
                              error codes.
                            "innererror": ...
                        },
                        "target": "str"  # Optional. The target of the error.
                    },
                    "name": "str",  # Optional. Environment name.
                    "parameters": {},  # Optional. Parameters object for the environment.
                    "provisioningState": "str",  # Optional. The provisioning state of the
                      environment.
                    "resourceGroupId": "str",  # Optional. The identifier of the resource group
                      containing the environment's resources.
                    "user": "str"  # Optional. The AAD object id of the owner of this
                      Environment.
                }

                # response body for status code(s): 201
                response == {
                    "catalogName": "str",  # Name of the catalog. Required.
                    "environmentDefinitionName": "str",  # Name of the environment definition.
                      Required.
                    "environmentType": "str",  # Environment type. Required.
                    "error": {
                        "code": "str",  # One of a server-defined set of error codes.
                          Required.
                        "message": "str",  # A human-readable representation of the error.
                          Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. One of a server-defined set of
                              error codes.
                            "innererror": ...
                        },
                        "target": "str"  # Optional. The target of the error.
                    },
                    "name": "str",  # Optional. Environment name.
                    "parameters": {},  # Optional. Parameters object for the environment.
                    "provisioningState": "str",  # Optional. The provisioning state of the
                      environment.
                    "resourceGroupId": "str",  # Optional. The identifier of the resource group
                      containing the environment's resources.
                    "user": "str"  # Optional. The AAD object id of the owner of this
                      Environment.
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_environment_initial(
                project_name=project_name,
                user_id=user_id,
                environment_name=environment_name,
                body=body,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[JSON].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[JSON](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _delete_environment_initial(
        self, project_name: str, user_id: str, environment_name: str, **kwargs: Any
    ) -> Optional[JSON]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Optional[JSON]] = kwargs.pop("cls", None)

        _request = build_dev_center_delete_environment_request(
            project_name=project_name,
            user_id=user_id,
            environment_name=environment_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_delete_environment(
        self, project_name: str, user_id: str, environment_name: str, **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Deletes an environment and all its associated resources.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Required.
        :type user_id: str
        :param environment_name: The name of the environment. Required.
        :type environment_name: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "status": "str",  # Provisioning state of the resource. Required. Known
                      values are: "Running", "Completed", "Canceled", and "Failed".
                    "endTime": "2020-02-20 00:00:00",  # Optional. The end time of the operation.
                    "error": {
                        "code": "str",  # Optional. The error code.
                        "message": "str"  # Optional. The error message.
                    },
                    "id": "str",  # Optional. Fully qualified ID for the operation status.
                    "name": "str",  # Optional. The operation id name.
                    "percentComplete": 0.0,  # Optional. Percent of the operation that is
                      complete.
                    "properties": {},  # Optional. Custom operation properties, populated only
                      for a successful operation.
                    "resourceId": "str",  # Optional. The id of the resource.
                    "startTime": "2020-02-20 00:00:00"  # Optional. The start time of the
                      operation.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_environment_initial(
                project_name=project_name,
                user_id=user_id,
                environment_name=environment_name,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[JSON].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[JSON](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def list_catalogs(self, project_name: str, *, top: Optional[int] = None, **kwargs: Any) -> AsyncIterable[JSON]:
        """Lists all of the catalogs available for a project.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :keyword top: The maximum number of resources to return from the operation. Example: 'top=10'.
         Default value is None.
        :paramtype top: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "name": "str"  # Name of the catalog. Required.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_dev_center_list_catalogs_request(
                    project_name=project_name,
                    top=top,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_catalog(self, project_name: str, catalog_name: str, **kwargs: Any) -> JSON:
        """Gets the specified catalog within the project.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param catalog_name: The name of the catalog. Required.
        :type catalog_name: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "name": "str"  # Name of the catalog. Required.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_dev_center_get_catalog_request(
            project_name=project_name,
            catalog_name=catalog_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def list_environment_definitions(
        self, project_name: str, *, top: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Lists all environment definitions available for a project.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :keyword top: The maximum number of resources to return from the operation. Example: 'top=10'.
         Default value is None.
        :paramtype top: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "catalogName": "str",  # Name of the catalog. Required.
                    "id": "str",  # The ID of the environment definition. Required.
                    "name": "str",  # Name of the environment definition. Required.
                    "description": "str",  # Optional. A short description of the environment
                      definition.
                    "parameters": [
                        {
                            "id": "str",  # Unique ID of the parameter. Required.
                            "required": bool,  # Whether or not this parameter is
                              required. Required.
                            "type": "str",  # A string of one of the basic JSON types
                              (number, integer, array, object, boolean, string). Required. Known values
                              are: "array", "boolean", "integer", "number", "object", and "string".
                            "allowed": [
                                "str"  # Optional. An array of allowed values.
                            ],
                            "default": "str",  # Optional. Default value of the
                              parameter.
                            "description": "str",  # Optional. Description of the
                              parameter.
                            "name": "str",  # Optional. Display name of the parameter.
                            "readOnly": bool  # Optional. Whether or not this parameter
                              is read-only.  If true, default should have a value.
                        }
                    ],
                    "parametersSchema": "str",  # Optional. JSON schema defining the parameters
                      object passed to an environment.
                    "templatePath": "str"  # Optional. Path to the Environment Definition
                      entrypoint file.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_dev_center_list_environment_definitions_request(
                    project_name=project_name,
                    top=top,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_environment_definitions_by_catalog(
        self, project_name: str, catalog_name: str, *, top: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Lists all environment definitions available within a catalog.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param catalog_name: The name of the catalog. Required.
        :type catalog_name: str
        :keyword top: The maximum number of resources to return from the operation. Example: 'top=10'.
         Default value is None.
        :paramtype top: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "catalogName": "str",  # Name of the catalog. Required.
                    "id": "str",  # The ID of the environment definition. Required.
                    "name": "str",  # Name of the environment definition. Required.
                    "description": "str",  # Optional. A short description of the environment
                      definition.
                    "parameters": [
                        {
                            "id": "str",  # Unique ID of the parameter. Required.
                            "required": bool,  # Whether or not this parameter is
                              required. Required.
                            "type": "str",  # A string of one of the basic JSON types
                              (number, integer, array, object, boolean, string). Required. Known values
                              are: "array", "boolean", "integer", "number", "object", and "string".
                            "allowed": [
                                "str"  # Optional. An array of allowed values.
                            ],
                            "default": "str",  # Optional. Default value of the
                              parameter.
                            "description": "str",  # Optional. Description of the
                              parameter.
                            "name": "str",  # Optional. Display name of the parameter.
                            "readOnly": bool  # Optional. Whether or not this parameter
                              is read-only.  If true, default should have a value.
                        }
                    ],
                    "parametersSchema": "str",  # Optional. JSON schema defining the parameters
                      object passed to an environment.
                    "templatePath": "str"  # Optional. Path to the Environment Definition
                      entrypoint file.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_dev_center_list_environment_definitions_by_catalog_request(
                    project_name=project_name,
                    catalog_name=catalog_name,
                    top=top,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_environment_definition(
        self, project_name: str, catalog_name: str, definition_name: str, **kwargs: Any
    ) -> JSON:
        """Get an environment definition from a catalog.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param catalog_name: The name of the catalog. Required.
        :type catalog_name: str
        :param definition_name: The name of the environment definition. Required.
        :type definition_name: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "catalogName": "str",  # Name of the catalog. Required.
                    "id": "str",  # The ID of the environment definition. Required.
                    "name": "str",  # Name of the environment definition. Required.
                    "description": "str",  # Optional. A short description of the environment
                      definition.
                    "parameters": [
                        {
                            "id": "str",  # Unique ID of the parameter. Required.
                            "required": bool,  # Whether or not this parameter is
                              required. Required.
                            "type": "str",  # A string of one of the basic JSON types
                              (number, integer, array, object, boolean, string). Required. Known values
                              are: "array", "boolean", "integer", "number", "object", and "string".
                            "allowed": [
                                "str"  # Optional. An array of allowed values.
                            ],
                            "default": "str",  # Optional. Default value of the
                              parameter.
                            "description": "str",  # Optional. Description of the
                              parameter.
                            "name": "str",  # Optional. Display name of the parameter.
                            "readOnly": bool  # Optional. Whether or not this parameter
                              is read-only.  If true, default should have a value.
                        }
                    ],
                    "parametersSchema": "str",  # Optional. JSON schema defining the parameters
                      object passed to an environment.
                    "templatePath": "str"  # Optional. Path to the Environment Definition
                      entrypoint file.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_dev_center_get_environment_definition_request(
            project_name=project_name,
            catalog_name=catalog_name,
            definition_name=definition_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def list_environment_types(
        self, project_name: str, *, top: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Lists all environment types configured for a project.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :keyword top: The maximum number of resources to return from the operation. Example: 'top=10'.
         Default value is None.
        :paramtype top: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "deploymentTargetId": "str",  # Id of a subscription or management group that
                      the environment type will be mapped to. The environment's resources will be
                      deployed into this subscription or management group. Required.
                    "name": "str",  # Name of the environment type. Required.
                    "status": "str"  # Indicates whether this environment type is enabled for use
                      in this project. Required. Known values are: "Enabled" and "Disabled".
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_dev_center_list_environment_types_request(
                    project_name=project_name,
                    top=top,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)
