/*
 *	logging utilities
 *
 *	Copyright (C) 2010 Olaf Kirch <okir@suse.de>
 *	Copyright (C) 2011-2021 SUSE LCC
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 *	Authors:
 *		Olaf Kirch
 *		Marius Tomaschewski
 *
 *	libnetcontrol contains source code which is based on wicked.
 *	Wicked is licensed under the GPL-2.0+, but permission has been
 *	granted by the authors of wicked to use the code derived from
 *	wicked under the LGPL-2.1+ in libnetcontrol.
 *	See the wicked project at <https://github.com/openSUSE/wicked>.
 *
 */
#ifndef __NETCONTROL_LOGGING_H
#define __NETCONTROL_LOGGING_H
#if defined(HAVE_CONFIG_H)
#include <config.h>
#endif

#ifdef __GNUC__
# define __fmtattr(f,a)	__attribute__ ((format (printf, f, a)))
# define __noreturn	__attribute__ ((noreturn))
#else
# define __fmtattr(f,a) /* */
# define __noreturn     /* */
#endif

extern void	__nc_fatal(const char *func, const char *file, long long line,
			   const char *fmt, ...) __fmtattr(4,5) __noreturn;
extern void	__nc_error(const char *func, const char *file, long long line,
			   const char *fmt, ...) __fmtattr(4,5);
extern void	__nc_warn (const char *func, const char *file, long long line,
			   const char *fmt, ...) __fmtattr(4,5);
extern void	__nc_info (const char *func, const char *file, long long line,
			   const char *fmt, ...) __fmtattr(4,5);
extern void	__nc_trace(const char *func, const char *file, long long line,
			   const char *fmt, ...) __fmtattr(4,5);

enum {
	NC_TRACE_NETCF		= 0x000001,
	NC_TRACE_IFCFG		= 0x000002,
	NC_TRACE_WICKED		= 0x000003,
};

extern void	__nc_debug(int facility, const char *func, const char *file,
			   long long line, const char *fmt, ...) __fmtattr(5,6);

#define nc_fatal(fmt, args...)		__nc_fatal(__FUNCTION__,__FILE__,__LINE__, fmt, ##args)
#define nc_error(fmt, args...)		__nc_error(__FUNCTION__,__FILE__,__LINE__, fmt, ##args)
#define nc_warn(fmt, args...)		__nc_warn (__FUNCTION__,__FILE__,__LINE__, fmt, ##args)
#define nc_info(fmt, args...)		__nc_info (__FUNCTION__,__FILE__,__LINE__, fmt, ##args)
#define nc_trace(fmt, args...)		__nc_trace(__FUNCTION__,__FILE__,__LINE__, fmt, ##args)

#define nc_debug_netcf(fmt, args...)	__nc_debug(NC_TRACE_NETCF, \
						__FUNCTION__,__FILE__,__LINE__, fmt, ##args)
#define nc_debug_ifcfg(fmt, args...)	__nc_debug(NC_TRACE_IFCFG, \
						__FUNCTION__,__FILE__,__LINE__, fmt, ##args)
#define nc_debug_wicked(fmt, args...)	__nc_debug(NC_TRACE_WICKED, \
						__FUNCTION__,__FILE__,__LINE__, fmt, ##args)

#undef __fmtattr
#undef __noreturn

int		nc_logger_open_stderr(void);
int 		nc_logger_open_syslog(const char *);
int		nc_logger_open_file(const char *);
int		nc_logger_close(void);

#endif /* __NETCONTROL_LOGGING_H */
