//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The KubeVirt Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by deepcopy-gen. DO NOT EDIT.

package v1

import (
	corev1 "k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	types "k8s.io/apimachinery/pkg/types"
)

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ACPI) DeepCopyInto(out *ACPI) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ACPI.
func (in *ACPI) DeepCopy() *ACPI {
	if in == nil {
		return nil
	}
	out := new(ACPI)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AccessCredential) DeepCopyInto(out *AccessCredential) {
	*out = *in
	if in.SSHPublicKey != nil {
		in, out := &in.SSHPublicKey, &out.SSHPublicKey
		*out = new(SSHPublicKeyAccessCredential)
		(*in).DeepCopyInto(*out)
	}
	if in.UserPassword != nil {
		in, out := &in.UserPassword, &out.UserPassword
		*out = new(UserPasswordAccessCredential)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AccessCredential.
func (in *AccessCredential) DeepCopy() *AccessCredential {
	if in == nil {
		return nil
	}
	out := new(AccessCredential)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AccessCredentialSecretSource) DeepCopyInto(out *AccessCredentialSecretSource) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AccessCredentialSecretSource.
func (in *AccessCredentialSecretSource) DeepCopy() *AccessCredentialSecretSource {
	if in == nil {
		return nil
	}
	out := new(AccessCredentialSecretSource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AddVolumeOptions) DeepCopyInto(out *AddVolumeOptions) {
	*out = *in
	if in.Disk != nil {
		in, out := &in.Disk, &out.Disk
		*out = new(Disk)
		(*in).DeepCopyInto(*out)
	}
	if in.VolumeSource != nil {
		in, out := &in.VolumeSource, &out.VolumeSource
		*out = new(HotplugVolumeSource)
		(*in).DeepCopyInto(*out)
	}
	if in.DryRun != nil {
		in, out := &in.DryRun, &out.DryRun
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AddVolumeOptions.
func (in *AddVolumeOptions) DeepCopy() *AddVolumeOptions {
	if in == nil {
		return nil
	}
	out := new(AddVolumeOptions)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ArchConfiguration) DeepCopyInto(out *ArchConfiguration) {
	*out = *in
	if in.Amd64 != nil {
		in, out := &in.Amd64, &out.Amd64
		*out = new(ArchSpecificConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.Arm64 != nil {
		in, out := &in.Arm64, &out.Arm64
		*out = new(ArchSpecificConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.Ppc64le != nil {
		in, out := &in.Ppc64le, &out.Ppc64le
		*out = new(ArchSpecificConfiguration)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ArchConfiguration.
func (in *ArchConfiguration) DeepCopy() *ArchConfiguration {
	if in == nil {
		return nil
	}
	out := new(ArchConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ArchSpecificConfiguration) DeepCopyInto(out *ArchSpecificConfiguration) {
	*out = *in
	if in.EmulatedMachines != nil {
		in, out := &in.EmulatedMachines, &out.EmulatedMachines
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ArchSpecificConfiguration.
func (in *ArchSpecificConfiguration) DeepCopy() *ArchSpecificConfiguration {
	if in == nil {
		return nil
	}
	out := new(ArchSpecificConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AuthorizedKeysFile) DeepCopyInto(out *AuthorizedKeysFile) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AuthorizedKeysFile.
func (in *AuthorizedKeysFile) DeepCopy() *AuthorizedKeysFile {
	if in == nil {
		return nil
	}
	out := new(AuthorizedKeysFile)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BIOS) DeepCopyInto(out *BIOS) {
	*out = *in
	if in.UseSerial != nil {
		in, out := &in.UseSerial, &out.UseSerial
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BIOS.
func (in *BIOS) DeepCopy() *BIOS {
	if in == nil {
		return nil
	}
	out := new(BIOS)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BlockSize) DeepCopyInto(out *BlockSize) {
	*out = *in
	if in.Custom != nil {
		in, out := &in.Custom, &out.Custom
		*out = new(CustomBlockSize)
		**out = **in
	}
	if in.MatchVolume != nil {
		in, out := &in.MatchVolume, &out.MatchVolume
		*out = new(FeatureState)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BlockSize.
func (in *BlockSize) DeepCopy() *BlockSize {
	if in == nil {
		return nil
	}
	out := new(BlockSize)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Bootloader) DeepCopyInto(out *Bootloader) {
	*out = *in
	if in.BIOS != nil {
		in, out := &in.BIOS, &out.BIOS
		*out = new(BIOS)
		(*in).DeepCopyInto(*out)
	}
	if in.EFI != nil {
		in, out := &in.EFI, &out.EFI
		*out = new(EFI)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Bootloader.
func (in *Bootloader) DeepCopy() *Bootloader {
	if in == nil {
		return nil
	}
	out := new(Bootloader)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CDRomTarget) DeepCopyInto(out *CDRomTarget) {
	*out = *in
	if in.ReadOnly != nil {
		in, out := &in.ReadOnly, &out.ReadOnly
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CDRomTarget.
func (in *CDRomTarget) DeepCopy() *CDRomTarget {
	if in == nil {
		return nil
	}
	out := new(CDRomTarget)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CPU) DeepCopyInto(out *CPU) {
	*out = *in
	if in.Features != nil {
		in, out := &in.Features, &out.Features
		*out = make([]CPUFeature, len(*in))
		copy(*out, *in)
	}
	if in.NUMA != nil {
		in, out := &in.NUMA, &out.NUMA
		*out = new(NUMA)
		(*in).DeepCopyInto(*out)
	}
	if in.Realtime != nil {
		in, out := &in.Realtime, &out.Realtime
		*out = new(Realtime)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CPU.
func (in *CPU) DeepCopy() *CPU {
	if in == nil {
		return nil
	}
	out := new(CPU)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CPUFeature) DeepCopyInto(out *CPUFeature) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CPUFeature.
func (in *CPUFeature) DeepCopy() *CPUFeature {
	if in == nil {
		return nil
	}
	out := new(CPUFeature)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CPUTopology) DeepCopyInto(out *CPUTopology) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CPUTopology.
func (in *CPUTopology) DeepCopy() *CPUTopology {
	if in == nil {
		return nil
	}
	out := new(CPUTopology)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CertConfig) DeepCopyInto(out *CertConfig) {
	*out = *in
	if in.Duration != nil {
		in, out := &in.Duration, &out.Duration
		*out = new(metav1.Duration)
		**out = **in
	}
	if in.RenewBefore != nil {
		in, out := &in.RenewBefore, &out.RenewBefore
		*out = new(metav1.Duration)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CertConfig.
func (in *CertConfig) DeepCopy() *CertConfig {
	if in == nil {
		return nil
	}
	out := new(CertConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Chassis) DeepCopyInto(out *Chassis) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Chassis.
func (in *Chassis) DeepCopy() *Chassis {
	if in == nil {
		return nil
	}
	out := new(Chassis)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClientPassthroughDevices) DeepCopyInto(out *ClientPassthroughDevices) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClientPassthroughDevices.
func (in *ClientPassthroughDevices) DeepCopy() *ClientPassthroughDevices {
	if in == nil {
		return nil
	}
	out := new(ClientPassthroughDevices)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Clock) DeepCopyInto(out *Clock) {
	*out = *in
	in.ClockOffset.DeepCopyInto(&out.ClockOffset)
	if in.Timer != nil {
		in, out := &in.Timer, &out.Timer
		*out = new(Timer)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Clock.
func (in *Clock) DeepCopy() *Clock {
	if in == nil {
		return nil
	}
	out := new(Clock)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClockOffset) DeepCopyInto(out *ClockOffset) {
	*out = *in
	if in.UTC != nil {
		in, out := &in.UTC, &out.UTC
		*out = new(ClockOffsetUTC)
		(*in).DeepCopyInto(*out)
	}
	if in.Timezone != nil {
		in, out := &in.Timezone, &out.Timezone
		*out = new(ClockOffsetTimezone)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClockOffset.
func (in *ClockOffset) DeepCopy() *ClockOffset {
	if in == nil {
		return nil
	}
	out := new(ClockOffset)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClockOffsetUTC) DeepCopyInto(out *ClockOffsetUTC) {
	*out = *in
	if in.OffsetSeconds != nil {
		in, out := &in.OffsetSeconds, &out.OffsetSeconds
		*out = new(int)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClockOffsetUTC.
func (in *ClockOffsetUTC) DeepCopy() *ClockOffsetUTC {
	if in == nil {
		return nil
	}
	out := new(ClockOffsetUTC)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CloudInitConfigDriveSource) DeepCopyInto(out *CloudInitConfigDriveSource) {
	*out = *in
	if in.UserDataSecretRef != nil {
		in, out := &in.UserDataSecretRef, &out.UserDataSecretRef
		*out = new(corev1.LocalObjectReference)
		**out = **in
	}
	if in.NetworkDataSecretRef != nil {
		in, out := &in.NetworkDataSecretRef, &out.NetworkDataSecretRef
		*out = new(corev1.LocalObjectReference)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CloudInitConfigDriveSource.
func (in *CloudInitConfigDriveSource) DeepCopy() *CloudInitConfigDriveSource {
	if in == nil {
		return nil
	}
	out := new(CloudInitConfigDriveSource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CloudInitNoCloudSource) DeepCopyInto(out *CloudInitNoCloudSource) {
	*out = *in
	if in.UserDataSecretRef != nil {
		in, out := &in.UserDataSecretRef, &out.UserDataSecretRef
		*out = new(corev1.LocalObjectReference)
		**out = **in
	}
	if in.NetworkDataSecretRef != nil {
		in, out := &in.NetworkDataSecretRef, &out.NetworkDataSecretRef
		*out = new(corev1.LocalObjectReference)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CloudInitNoCloudSource.
func (in *CloudInitNoCloudSource) DeepCopy() *CloudInitNoCloudSource {
	if in == nil {
		return nil
	}
	out := new(CloudInitNoCloudSource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterProfilerRequest) DeepCopyInto(out *ClusterProfilerRequest) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterProfilerRequest.
func (in *ClusterProfilerRequest) DeepCopy() *ClusterProfilerRequest {
	if in == nil {
		return nil
	}
	out := new(ClusterProfilerRequest)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterProfilerResults) DeepCopyInto(out *ClusterProfilerResults) {
	*out = *in
	if in.ComponentResults != nil {
		in, out := &in.ComponentResults, &out.ComponentResults
		*out = make(map[string]ProfilerResult, len(*in))
		for key, val := range *in {
			(*out)[key] = *val.DeepCopy()
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterProfilerResults.
func (in *ClusterProfilerResults) DeepCopy() *ClusterProfilerResults {
	if in == nil {
		return nil
	}
	out := new(ClusterProfilerResults)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CommonInstancetypesDeployment) DeepCopyInto(out *CommonInstancetypesDeployment) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CommonInstancetypesDeployment.
func (in *CommonInstancetypesDeployment) DeepCopy() *CommonInstancetypesDeployment {
	if in == nil {
		return nil
	}
	out := new(CommonInstancetypesDeployment)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComponentConfig) DeepCopyInto(out *ComponentConfig) {
	*out = *in
	if in.NodePlacement != nil {
		in, out := &in.NodePlacement, &out.NodePlacement
		*out = new(NodePlacement)
		(*in).DeepCopyInto(*out)
	}
	if in.Replicas != nil {
		in, out := &in.Replicas, &out.Replicas
		*out = new(byte)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComponentConfig.
func (in *ComponentConfig) DeepCopy() *ComponentConfig {
	if in == nil {
		return nil
	}
	out := new(ComponentConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ConfigDriveSSHPublicKeyAccessCredentialPropagation) DeepCopyInto(out *ConfigDriveSSHPublicKeyAccessCredentialPropagation) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ConfigDriveSSHPublicKeyAccessCredentialPropagation.
func (in *ConfigDriveSSHPublicKeyAccessCredentialPropagation) DeepCopy() *ConfigDriveSSHPublicKeyAccessCredentialPropagation {
	if in == nil {
		return nil
	}
	out := new(ConfigDriveSSHPublicKeyAccessCredentialPropagation)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ConfigMapVolumeSource) DeepCopyInto(out *ConfigMapVolumeSource) {
	*out = *in
	out.LocalObjectReference = in.LocalObjectReference
	if in.Optional != nil {
		in, out := &in.Optional, &out.Optional
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ConfigMapVolumeSource.
func (in *ConfigMapVolumeSource) DeepCopy() *ConfigMapVolumeSource {
	if in == nil {
		return nil
	}
	out := new(ConfigMapVolumeSource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ContainerDiskInfo) DeepCopyInto(out *ContainerDiskInfo) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ContainerDiskInfo.
func (in *ContainerDiskInfo) DeepCopy() *ContainerDiskInfo {
	if in == nil {
		return nil
	}
	out := new(ContainerDiskInfo)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ContainerDiskSource) DeepCopyInto(out *ContainerDiskSource) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ContainerDiskSource.
func (in *ContainerDiskSource) DeepCopy() *ContainerDiskSource {
	if in == nil {
		return nil
	}
	out := new(ContainerDiskSource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CustomBlockSize) DeepCopyInto(out *CustomBlockSize) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CustomBlockSize.
func (in *CustomBlockSize) DeepCopy() *CustomBlockSize {
	if in == nil {
		return nil
	}
	out := new(CustomBlockSize)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CustomProfile) DeepCopyInto(out *CustomProfile) {
	*out = *in
	if in.LocalhostProfile != nil {
		in, out := &in.LocalhostProfile, &out.LocalhostProfile
		*out = new(string)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CustomProfile.
func (in *CustomProfile) DeepCopy() *CustomProfile {
	if in == nil {
		return nil
	}
	out := new(CustomProfile)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CustomizeComponents) DeepCopyInto(out *CustomizeComponents) {
	*out = *in
	if in.Patches != nil {
		in, out := &in.Patches, &out.Patches
		*out = make([]CustomizeComponentsPatch, len(*in))
		copy(*out, *in)
	}
	if in.Flags != nil {
		in, out := &in.Flags, &out.Flags
		*out = new(Flags)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CustomizeComponents.
func (in *CustomizeComponents) DeepCopy() *CustomizeComponents {
	if in == nil {
		return nil
	}
	out := new(CustomizeComponents)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CustomizeComponentsPatch) DeepCopyInto(out *CustomizeComponentsPatch) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CustomizeComponentsPatch.
func (in *CustomizeComponentsPatch) DeepCopy() *CustomizeComponentsPatch {
	if in == nil {
		return nil
	}
	out := new(CustomizeComponentsPatch)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DHCPOptions) DeepCopyInto(out *DHCPOptions) {
	*out = *in
	if in.NTPServers != nil {
		in, out := &in.NTPServers, &out.NTPServers
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.PrivateOptions != nil {
		in, out := &in.PrivateOptions, &out.PrivateOptions
		*out = make([]DHCPPrivateOptions, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DHCPOptions.
func (in *DHCPOptions) DeepCopy() *DHCPOptions {
	if in == nil {
		return nil
	}
	out := new(DHCPOptions)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DHCPPrivateOptions) DeepCopyInto(out *DHCPPrivateOptions) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DHCPPrivateOptions.
func (in *DHCPPrivateOptions) DeepCopy() *DHCPPrivateOptions {
	if in == nil {
		return nil
	}
	out := new(DHCPPrivateOptions)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DataVolumeSource) DeepCopyInto(out *DataVolumeSource) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DataVolumeSource.
func (in *DataVolumeSource) DeepCopy() *DataVolumeSource {
	if in == nil {
		return nil
	}
	out := new(DataVolumeSource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DataVolumeTemplateDummyStatus) DeepCopyInto(out *DataVolumeTemplateDummyStatus) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DataVolumeTemplateDummyStatus.
func (in *DataVolumeTemplateDummyStatus) DeepCopy() *DataVolumeTemplateDummyStatus {
	if in == nil {
		return nil
	}
	out := new(DataVolumeTemplateDummyStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DataVolumeTemplateSpec) DeepCopyInto(out *DataVolumeTemplateSpec) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	if in.Status != nil {
		in, out := &in.Status, &out.Status
		*out = new(DataVolumeTemplateDummyStatus)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DataVolumeTemplateSpec.
func (in *DataVolumeTemplateSpec) DeepCopy() *DataVolumeTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(DataVolumeTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DeprecatedInterfaceMacvtap) DeepCopyInto(out *DeprecatedInterfaceMacvtap) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DeprecatedInterfaceMacvtap.
func (in *DeprecatedInterfaceMacvtap) DeepCopy() *DeprecatedInterfaceMacvtap {
	if in == nil {
		return nil
	}
	out := new(DeprecatedInterfaceMacvtap)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DeprecatedInterfacePasst) DeepCopyInto(out *DeprecatedInterfacePasst) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DeprecatedInterfacePasst.
func (in *DeprecatedInterfacePasst) DeepCopy() *DeprecatedInterfacePasst {
	if in == nil {
		return nil
	}
	out := new(DeprecatedInterfacePasst)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DeprecatedInterfaceSlirp) DeepCopyInto(out *DeprecatedInterfaceSlirp) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DeprecatedInterfaceSlirp.
func (in *DeprecatedInterfaceSlirp) DeepCopy() *DeprecatedInterfaceSlirp {
	if in == nil {
		return nil
	}
	out := new(DeprecatedInterfaceSlirp)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DeveloperConfiguration) DeepCopyInto(out *DeveloperConfiguration) {
	*out = *in
	if in.FeatureGates != nil {
		in, out := &in.FeatureGates, &out.FeatureGates
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.NodeSelectors != nil {
		in, out := &in.NodeSelectors, &out.NodeSelectors
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.MinimumClusterTSCFrequency != nil {
		in, out := &in.MinimumClusterTSCFrequency, &out.MinimumClusterTSCFrequency
		*out = new(int64)
		**out = **in
	}
	if in.DiskVerification != nil {
		in, out := &in.DiskVerification, &out.DiskVerification
		*out = new(DiskVerification)
		(*in).DeepCopyInto(*out)
	}
	if in.LogVerbosity != nil {
		in, out := &in.LogVerbosity, &out.LogVerbosity
		*out = new(LogVerbosity)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DeveloperConfiguration.
func (in *DeveloperConfiguration) DeepCopy() *DeveloperConfiguration {
	if in == nil {
		return nil
	}
	out := new(DeveloperConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Devices) DeepCopyInto(out *Devices) {
	*out = *in
	if in.UseVirtioTransitional != nil {
		in, out := &in.UseVirtioTransitional, &out.UseVirtioTransitional
		*out = new(bool)
		**out = **in
	}
	if in.Disks != nil {
		in, out := &in.Disks, &out.Disks
		*out = make([]Disk, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Watchdog != nil {
		in, out := &in.Watchdog, &out.Watchdog
		*out = new(Watchdog)
		(*in).DeepCopyInto(*out)
	}
	if in.Interfaces != nil {
		in, out := &in.Interfaces, &out.Interfaces
		*out = make([]Interface, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Inputs != nil {
		in, out := &in.Inputs, &out.Inputs
		*out = make([]Input, len(*in))
		copy(*out, *in)
	}
	if in.AutoattachPodInterface != nil {
		in, out := &in.AutoattachPodInterface, &out.AutoattachPodInterface
		*out = new(bool)
		**out = **in
	}
	if in.AutoattachGraphicsDevice != nil {
		in, out := &in.AutoattachGraphicsDevice, &out.AutoattachGraphicsDevice
		*out = new(bool)
		**out = **in
	}
	if in.AutoattachSerialConsole != nil {
		in, out := &in.AutoattachSerialConsole, &out.AutoattachSerialConsole
		*out = new(bool)
		**out = **in
	}
	if in.LogSerialConsole != nil {
		in, out := &in.LogSerialConsole, &out.LogSerialConsole
		*out = new(bool)
		**out = **in
	}
	if in.AutoattachMemBalloon != nil {
		in, out := &in.AutoattachMemBalloon, &out.AutoattachMemBalloon
		*out = new(bool)
		**out = **in
	}
	if in.AutoattachInputDevice != nil {
		in, out := &in.AutoattachInputDevice, &out.AutoattachInputDevice
		*out = new(bool)
		**out = **in
	}
	if in.AutoattachVSOCK != nil {
		in, out := &in.AutoattachVSOCK, &out.AutoattachVSOCK
		*out = new(bool)
		**out = **in
	}
	if in.Rng != nil {
		in, out := &in.Rng, &out.Rng
		*out = new(Rng)
		**out = **in
	}
	if in.BlockMultiQueue != nil {
		in, out := &in.BlockMultiQueue, &out.BlockMultiQueue
		*out = new(bool)
		**out = **in
	}
	if in.NetworkInterfaceMultiQueue != nil {
		in, out := &in.NetworkInterfaceMultiQueue, &out.NetworkInterfaceMultiQueue
		*out = new(bool)
		**out = **in
	}
	if in.GPUs != nil {
		in, out := &in.GPUs, &out.GPUs
		*out = make([]GPU, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.DownwardMetrics != nil {
		in, out := &in.DownwardMetrics, &out.DownwardMetrics
		*out = new(DownwardMetrics)
		**out = **in
	}
	if in.Filesystems != nil {
		in, out := &in.Filesystems, &out.Filesystems
		*out = make([]Filesystem, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.HostDevices != nil {
		in, out := &in.HostDevices, &out.HostDevices
		*out = make([]HostDevice, len(*in))
		copy(*out, *in)
	}
	if in.ClientPassthrough != nil {
		in, out := &in.ClientPassthrough, &out.ClientPassthrough
		*out = new(ClientPassthroughDevices)
		**out = **in
	}
	if in.Sound != nil {
		in, out := &in.Sound, &out.Sound
		*out = new(SoundDevice)
		**out = **in
	}
	if in.TPM != nil {
		in, out := &in.TPM, &out.TPM
		*out = new(TPMDevice)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Devices.
func (in *Devices) DeepCopy() *Devices {
	if in == nil {
		return nil
	}
	out := new(Devices)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DisableFreePageReporting) DeepCopyInto(out *DisableFreePageReporting) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DisableFreePageReporting.
func (in *DisableFreePageReporting) DeepCopy() *DisableFreePageReporting {
	if in == nil {
		return nil
	}
	out := new(DisableFreePageReporting)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DisableSerialConsoleLog) DeepCopyInto(out *DisableSerialConsoleLog) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DisableSerialConsoleLog.
func (in *DisableSerialConsoleLog) DeepCopy() *DisableSerialConsoleLog {
	if in == nil {
		return nil
	}
	out := new(DisableSerialConsoleLog)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Disk) DeepCopyInto(out *Disk) {
	*out = *in
	in.DiskDevice.DeepCopyInto(&out.DiskDevice)
	if in.BootOrder != nil {
		in, out := &in.BootOrder, &out.BootOrder
		*out = new(uint)
		**out = **in
	}
	if in.DedicatedIOThread != nil {
		in, out := &in.DedicatedIOThread, &out.DedicatedIOThread
		*out = new(bool)
		**out = **in
	}
	if in.BlockSize != nil {
		in, out := &in.BlockSize, &out.BlockSize
		*out = new(BlockSize)
		(*in).DeepCopyInto(*out)
	}
	if in.Shareable != nil {
		in, out := &in.Shareable, &out.Shareable
		*out = new(bool)
		**out = **in
	}
	if in.ErrorPolicy != nil {
		in, out := &in.ErrorPolicy, &out.ErrorPolicy
		*out = new(DiskErrorPolicy)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Disk.
func (in *Disk) DeepCopy() *Disk {
	if in == nil {
		return nil
	}
	out := new(Disk)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DiskDevice) DeepCopyInto(out *DiskDevice) {
	*out = *in
	if in.Disk != nil {
		in, out := &in.Disk, &out.Disk
		*out = new(DiskTarget)
		**out = **in
	}
	if in.LUN != nil {
		in, out := &in.LUN, &out.LUN
		*out = new(LunTarget)
		**out = **in
	}
	if in.CDRom != nil {
		in, out := &in.CDRom, &out.CDRom
		*out = new(CDRomTarget)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DiskDevice.
func (in *DiskDevice) DeepCopy() *DiskDevice {
	if in == nil {
		return nil
	}
	out := new(DiskDevice)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DiskTarget) DeepCopyInto(out *DiskTarget) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DiskTarget.
func (in *DiskTarget) DeepCopy() *DiskTarget {
	if in == nil {
		return nil
	}
	out := new(DiskTarget)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DiskVerification) DeepCopyInto(out *DiskVerification) {
	*out = *in
	if in.MemoryLimit != nil {
		in, out := &in.MemoryLimit, &out.MemoryLimit
		x := (*in).DeepCopy()
		*out = &x
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DiskVerification.
func (in *DiskVerification) DeepCopy() *DiskVerification {
	if in == nil {
		return nil
	}
	out := new(DiskVerification)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DomainMemoryDumpInfo) DeepCopyInto(out *DomainMemoryDumpInfo) {
	*out = *in
	if in.StartTimestamp != nil {
		in, out := &in.StartTimestamp, &out.StartTimestamp
		*out = (*in).DeepCopy()
	}
	if in.EndTimestamp != nil {
		in, out := &in.EndTimestamp, &out.EndTimestamp
		*out = (*in).DeepCopy()
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DomainMemoryDumpInfo.
func (in *DomainMemoryDumpInfo) DeepCopy() *DomainMemoryDumpInfo {
	if in == nil {
		return nil
	}
	out := new(DomainMemoryDumpInfo)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DomainSpec) DeepCopyInto(out *DomainSpec) {
	*out = *in
	in.Resources.DeepCopyInto(&out.Resources)
	if in.CPU != nil {
		in, out := &in.CPU, &out.CPU
		*out = new(CPU)
		(*in).DeepCopyInto(*out)
	}
	if in.Memory != nil {
		in, out := &in.Memory, &out.Memory
		*out = new(Memory)
		(*in).DeepCopyInto(*out)
	}
	if in.Machine != nil {
		in, out := &in.Machine, &out.Machine
		*out = new(Machine)
		**out = **in
	}
	if in.Firmware != nil {
		in, out := &in.Firmware, &out.Firmware
		*out = new(Firmware)
		(*in).DeepCopyInto(*out)
	}
	if in.Clock != nil {
		in, out := &in.Clock, &out.Clock
		*out = new(Clock)
		(*in).DeepCopyInto(*out)
	}
	if in.Features != nil {
		in, out := &in.Features, &out.Features
		*out = new(Features)
		(*in).DeepCopyInto(*out)
	}
	in.Devices.DeepCopyInto(&out.Devices)
	if in.IOThreadsPolicy != nil {
		in, out := &in.IOThreadsPolicy, &out.IOThreadsPolicy
		*out = new(IOThreadsPolicy)
		**out = **in
	}
	if in.Chassis != nil {
		in, out := &in.Chassis, &out.Chassis
		*out = new(Chassis)
		**out = **in
	}
	if in.LaunchSecurity != nil {
		in, out := &in.LaunchSecurity, &out.LaunchSecurity
		*out = new(LaunchSecurity)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DomainSpec.
func (in *DomainSpec) DeepCopy() *DomainSpec {
	if in == nil {
		return nil
	}
	out := new(DomainSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DownwardAPIVolumeSource) DeepCopyInto(out *DownwardAPIVolumeSource) {
	*out = *in
	if in.Fields != nil {
		in, out := &in.Fields, &out.Fields
		*out = make([]corev1.DownwardAPIVolumeFile, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DownwardAPIVolumeSource.
func (in *DownwardAPIVolumeSource) DeepCopy() *DownwardAPIVolumeSource {
	if in == nil {
		return nil
	}
	out := new(DownwardAPIVolumeSource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DownwardMetrics) DeepCopyInto(out *DownwardMetrics) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DownwardMetrics.
func (in *DownwardMetrics) DeepCopy() *DownwardMetrics {
	if in == nil {
		return nil
	}
	out := new(DownwardMetrics)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DownwardMetricsVolumeSource) DeepCopyInto(out *DownwardMetricsVolumeSource) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DownwardMetricsVolumeSource.
func (in *DownwardMetricsVolumeSource) DeepCopy() *DownwardMetricsVolumeSource {
	if in == nil {
		return nil
	}
	out := new(DownwardMetricsVolumeSource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EFI) DeepCopyInto(out *EFI) {
	*out = *in
	if in.SecureBoot != nil {
		in, out := &in.SecureBoot, &out.SecureBoot
		*out = new(bool)
		**out = **in
	}
	if in.Persistent != nil {
		in, out := &in.Persistent, &out.Persistent
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EFI.
func (in *EFI) DeepCopy() *EFI {
	if in == nil {
		return nil
	}
	out := new(EFI)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EmptyDiskSource) DeepCopyInto(out *EmptyDiskSource) {
	*out = *in
	out.Capacity = in.Capacity.DeepCopy()
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EmptyDiskSource.
func (in *EmptyDiskSource) DeepCopy() *EmptyDiskSource {
	if in == nil {
		return nil
	}
	out := new(EmptyDiskSource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EphemeralVolumeSource) DeepCopyInto(out *EphemeralVolumeSource) {
	*out = *in
	if in.PersistentVolumeClaim != nil {
		in, out := &in.PersistentVolumeClaim, &out.PersistentVolumeClaim
		*out = new(corev1.PersistentVolumeClaimVolumeSource)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EphemeralVolumeSource.
func (in *EphemeralVolumeSource) DeepCopy() *EphemeralVolumeSource {
	if in == nil {
		return nil
	}
	out := new(EphemeralVolumeSource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FeatureAPIC) DeepCopyInto(out *FeatureAPIC) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FeatureAPIC.
func (in *FeatureAPIC) DeepCopy() *FeatureAPIC {
	if in == nil {
		return nil
	}
	out := new(FeatureAPIC)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FeatureHyperv) DeepCopyInto(out *FeatureHyperv) {
	*out = *in
	if in.Relaxed != nil {
		in, out := &in.Relaxed, &out.Relaxed
		*out = new(FeatureState)
		(*in).DeepCopyInto(*out)
	}
	if in.VAPIC != nil {
		in, out := &in.VAPIC, &out.VAPIC
		*out = new(FeatureState)
		(*in).DeepCopyInto(*out)
	}
	if in.Spinlocks != nil {
		in, out := &in.Spinlocks, &out.Spinlocks
		*out = new(FeatureSpinlocks)
		(*in).DeepCopyInto(*out)
	}
	if in.VPIndex != nil {
		in, out := &in.VPIndex, &out.VPIndex
		*out = new(FeatureState)
		(*in).DeepCopyInto(*out)
	}
	if in.Runtime != nil {
		in, out := &in.Runtime, &out.Runtime
		*out = new(FeatureState)
		(*in).DeepCopyInto(*out)
	}
	if in.SyNIC != nil {
		in, out := &in.SyNIC, &out.SyNIC
		*out = new(FeatureState)
		(*in).DeepCopyInto(*out)
	}
	if in.SyNICTimer != nil {
		in, out := &in.SyNICTimer, &out.SyNICTimer
		*out = new(SyNICTimer)
		(*in).DeepCopyInto(*out)
	}
	if in.Reset != nil {
		in, out := &in.Reset, &out.Reset
		*out = new(FeatureState)
		(*in).DeepCopyInto(*out)
	}
	if in.VendorID != nil {
		in, out := &in.VendorID, &out.VendorID
		*out = new(FeatureVendorID)
		(*in).DeepCopyInto(*out)
	}
	if in.Frequencies != nil {
		in, out := &in.Frequencies, &out.Frequencies
		*out = new(FeatureState)
		(*in).DeepCopyInto(*out)
	}
	if in.Reenlightenment != nil {
		in, out := &in.Reenlightenment, &out.Reenlightenment
		*out = new(FeatureState)
		(*in).DeepCopyInto(*out)
	}
	if in.TLBFlush != nil {
		in, out := &in.TLBFlush, &out.TLBFlush
		*out = new(FeatureState)
		(*in).DeepCopyInto(*out)
	}
	if in.IPI != nil {
		in, out := &in.IPI, &out.IPI
		*out = new(FeatureState)
		(*in).DeepCopyInto(*out)
	}
	if in.EVMCS != nil {
		in, out := &in.EVMCS, &out.EVMCS
		*out = new(FeatureState)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FeatureHyperv.
func (in *FeatureHyperv) DeepCopy() *FeatureHyperv {
	if in == nil {
		return nil
	}
	out := new(FeatureHyperv)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FeatureKVM) DeepCopyInto(out *FeatureKVM) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FeatureKVM.
func (in *FeatureKVM) DeepCopy() *FeatureKVM {
	if in == nil {
		return nil
	}
	out := new(FeatureKVM)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FeatureSpinlocks) DeepCopyInto(out *FeatureSpinlocks) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	if in.Retries != nil {
		in, out := &in.Retries, &out.Retries
		*out = new(uint32)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FeatureSpinlocks.
func (in *FeatureSpinlocks) DeepCopy() *FeatureSpinlocks {
	if in == nil {
		return nil
	}
	out := new(FeatureSpinlocks)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FeatureState) DeepCopyInto(out *FeatureState) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FeatureState.
func (in *FeatureState) DeepCopy() *FeatureState {
	if in == nil {
		return nil
	}
	out := new(FeatureState)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FeatureVendorID) DeepCopyInto(out *FeatureVendorID) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FeatureVendorID.
func (in *FeatureVendorID) DeepCopy() *FeatureVendorID {
	if in == nil {
		return nil
	}
	out := new(FeatureVendorID)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Features) DeepCopyInto(out *Features) {
	*out = *in
	in.ACPI.DeepCopyInto(&out.ACPI)
	if in.APIC != nil {
		in, out := &in.APIC, &out.APIC
		*out = new(FeatureAPIC)
		(*in).DeepCopyInto(*out)
	}
	if in.HypervPassthrough != nil {
		in, out := &in.HypervPassthrough, &out.HypervPassthrough
		*out = new(HyperVPassthrough)
		(*in).DeepCopyInto(*out)
	}
	if in.Hyperv != nil {
		in, out := &in.Hyperv, &out.Hyperv
		*out = new(FeatureHyperv)
		(*in).DeepCopyInto(*out)
	}
	if in.SMM != nil {
		in, out := &in.SMM, &out.SMM
		*out = new(FeatureState)
		(*in).DeepCopyInto(*out)
	}
	if in.KVM != nil {
		in, out := &in.KVM, &out.KVM
		*out = new(FeatureKVM)
		**out = **in
	}
	if in.Pvspinlock != nil {
		in, out := &in.Pvspinlock, &out.Pvspinlock
		*out = new(FeatureState)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Features.
func (in *Features) DeepCopy() *Features {
	if in == nil {
		return nil
	}
	out := new(Features)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Filesystem) DeepCopyInto(out *Filesystem) {
	*out = *in
	if in.Virtiofs != nil {
		in, out := &in.Virtiofs, &out.Virtiofs
		*out = new(FilesystemVirtiofs)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Filesystem.
func (in *Filesystem) DeepCopy() *Filesystem {
	if in == nil {
		return nil
	}
	out := new(Filesystem)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FilesystemVirtiofs) DeepCopyInto(out *FilesystemVirtiofs) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FilesystemVirtiofs.
func (in *FilesystemVirtiofs) DeepCopy() *FilesystemVirtiofs {
	if in == nil {
		return nil
	}
	out := new(FilesystemVirtiofs)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Firmware) DeepCopyInto(out *Firmware) {
	*out = *in
	if in.Bootloader != nil {
		in, out := &in.Bootloader, &out.Bootloader
		*out = new(Bootloader)
		(*in).DeepCopyInto(*out)
	}
	if in.KernelBoot != nil {
		in, out := &in.KernelBoot, &out.KernelBoot
		*out = new(KernelBoot)
		(*in).DeepCopyInto(*out)
	}
	if in.ACPI != nil {
		in, out := &in.ACPI, &out.ACPI
		*out = new(ACPI)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Firmware.
func (in *Firmware) DeepCopy() *Firmware {
	if in == nil {
		return nil
	}
	out := new(Firmware)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Flags) DeepCopyInto(out *Flags) {
	*out = *in
	if in.API != nil {
		in, out := &in.API, &out.API
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Controller != nil {
		in, out := &in.Controller, &out.Controller
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Handler != nil {
		in, out := &in.Handler, &out.Handler
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Flags.
func (in *Flags) DeepCopy() *Flags {
	if in == nil {
		return nil
	}
	out := new(Flags)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FreezeUnfreezeTimeout) DeepCopyInto(out *FreezeUnfreezeTimeout) {
	*out = *in
	if in.UnfreezeTimeout != nil {
		in, out := &in.UnfreezeTimeout, &out.UnfreezeTimeout
		*out = new(metav1.Duration)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FreezeUnfreezeTimeout.
func (in *FreezeUnfreezeTimeout) DeepCopy() *FreezeUnfreezeTimeout {
	if in == nil {
		return nil
	}
	out := new(FreezeUnfreezeTimeout)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GPU) DeepCopyInto(out *GPU) {
	*out = *in
	if in.VirtualGPUOptions != nil {
		in, out := &in.VirtualGPUOptions, &out.VirtualGPUOptions
		*out = new(VGPUOptions)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GPU.
func (in *GPU) DeepCopy() *GPU {
	if in == nil {
		return nil
	}
	out := new(GPU)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GenerationStatus) DeepCopyInto(out *GenerationStatus) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GenerationStatus.
func (in *GenerationStatus) DeepCopy() *GenerationStatus {
	if in == nil {
		return nil
	}
	out := new(GenerationStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GuestAgentCommandInfo) DeepCopyInto(out *GuestAgentCommandInfo) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GuestAgentCommandInfo.
func (in *GuestAgentCommandInfo) DeepCopy() *GuestAgentCommandInfo {
	if in == nil {
		return nil
	}
	out := new(GuestAgentCommandInfo)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GuestAgentPing) DeepCopyInto(out *GuestAgentPing) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GuestAgentPing.
func (in *GuestAgentPing) DeepCopy() *GuestAgentPing {
	if in == nil {
		return nil
	}
	out := new(GuestAgentPing)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HPETTimer) DeepCopyInto(out *HPETTimer) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HPETTimer.
func (in *HPETTimer) DeepCopy() *HPETTimer {
	if in == nil {
		return nil
	}
	out := new(HPETTimer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Handler) DeepCopyInto(out *Handler) {
	*out = *in
	if in.Exec != nil {
		in, out := &in.Exec, &out.Exec
		*out = new(corev1.ExecAction)
		(*in).DeepCopyInto(*out)
	}
	if in.GuestAgentPing != nil {
		in, out := &in.GuestAgentPing, &out.GuestAgentPing
		*out = new(GuestAgentPing)
		**out = **in
	}
	if in.HTTPGet != nil {
		in, out := &in.HTTPGet, &out.HTTPGet
		*out = new(corev1.HTTPGetAction)
		(*in).DeepCopyInto(*out)
	}
	if in.TCPSocket != nil {
		in, out := &in.TCPSocket, &out.TCPSocket
		*out = new(corev1.TCPSocketAction)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Handler.
func (in *Handler) DeepCopy() *Handler {
	if in == nil {
		return nil
	}
	out := new(Handler)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HostDevice) DeepCopyInto(out *HostDevice) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HostDevice.
func (in *HostDevice) DeepCopy() *HostDevice {
	if in == nil {
		return nil
	}
	out := new(HostDevice)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HostDisk) DeepCopyInto(out *HostDisk) {
	*out = *in
	out.Capacity = in.Capacity.DeepCopy()
	if in.Shared != nil {
		in, out := &in.Shared, &out.Shared
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HostDisk.
func (in *HostDisk) DeepCopy() *HostDisk {
	if in == nil {
		return nil
	}
	out := new(HostDisk)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HotplugVolumeSource) DeepCopyInto(out *HotplugVolumeSource) {
	*out = *in
	if in.PersistentVolumeClaim != nil {
		in, out := &in.PersistentVolumeClaim, &out.PersistentVolumeClaim
		*out = new(PersistentVolumeClaimVolumeSource)
		**out = **in
	}
	if in.DataVolume != nil {
		in, out := &in.DataVolume, &out.DataVolume
		*out = new(DataVolumeSource)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HotplugVolumeSource.
func (in *HotplugVolumeSource) DeepCopy() *HotplugVolumeSource {
	if in == nil {
		return nil
	}
	out := new(HotplugVolumeSource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HotplugVolumeStatus) DeepCopyInto(out *HotplugVolumeStatus) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HotplugVolumeStatus.
func (in *HotplugVolumeStatus) DeepCopy() *HotplugVolumeStatus {
	if in == nil {
		return nil
	}
	out := new(HotplugVolumeStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Hugepages) DeepCopyInto(out *Hugepages) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Hugepages.
func (in *Hugepages) DeepCopy() *Hugepages {
	if in == nil {
		return nil
	}
	out := new(Hugepages)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HyperVPassthrough) DeepCopyInto(out *HyperVPassthrough) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HyperVPassthrough.
func (in *HyperVPassthrough) DeepCopy() *HyperVPassthrough {
	if in == nil {
		return nil
	}
	out := new(HyperVPassthrough)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HypervTimer) DeepCopyInto(out *HypervTimer) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HypervTimer.
func (in *HypervTimer) DeepCopy() *HypervTimer {
	if in == nil {
		return nil
	}
	out := new(HypervTimer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *I6300ESBWatchdog) DeepCopyInto(out *I6300ESBWatchdog) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new I6300ESBWatchdog.
func (in *I6300ESBWatchdog) DeepCopy() *I6300ESBWatchdog {
	if in == nil {
		return nil
	}
	out := new(I6300ESBWatchdog)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InitrdInfo) DeepCopyInto(out *InitrdInfo) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InitrdInfo.
func (in *InitrdInfo) DeepCopy() *InitrdInfo {
	if in == nil {
		return nil
	}
	out := new(InitrdInfo)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Input) DeepCopyInto(out *Input) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Input.
func (in *Input) DeepCopy() *Input {
	if in == nil {
		return nil
	}
	out := new(Input)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InstancetypeConfiguration) DeepCopyInto(out *InstancetypeConfiguration) {
	*out = *in
	if in.ReferencePolicy != nil {
		in, out := &in.ReferencePolicy, &out.ReferencePolicy
		*out = new(InstancetypeReferencePolicy)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InstancetypeConfiguration.
func (in *InstancetypeConfiguration) DeepCopy() *InstancetypeConfiguration {
	if in == nil {
		return nil
	}
	out := new(InstancetypeConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InstancetypeMatcher) DeepCopyInto(out *InstancetypeMatcher) {
	*out = *in
	if in.InferFromVolumeFailurePolicy != nil {
		in, out := &in.InferFromVolumeFailurePolicy, &out.InferFromVolumeFailurePolicy
		*out = new(InferFromVolumeFailurePolicy)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InstancetypeMatcher.
func (in *InstancetypeMatcher) DeepCopy() *InstancetypeMatcher {
	if in == nil {
		return nil
	}
	out := new(InstancetypeMatcher)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Interface) DeepCopyInto(out *Interface) {
	*out = *in
	in.InterfaceBindingMethod.DeepCopyInto(&out.InterfaceBindingMethod)
	if in.Binding != nil {
		in, out := &in.Binding, &out.Binding
		*out = new(PluginBinding)
		**out = **in
	}
	if in.Ports != nil {
		in, out := &in.Ports, &out.Ports
		*out = make([]Port, len(*in))
		copy(*out, *in)
	}
	if in.BootOrder != nil {
		in, out := &in.BootOrder, &out.BootOrder
		*out = new(uint)
		**out = **in
	}
	if in.DHCPOptions != nil {
		in, out := &in.DHCPOptions, &out.DHCPOptions
		*out = new(DHCPOptions)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Interface.
func (in *Interface) DeepCopy() *Interface {
	if in == nil {
		return nil
	}
	out := new(Interface)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InterfaceBindingMethod) DeepCopyInto(out *InterfaceBindingMethod) {
	*out = *in
	if in.Bridge != nil {
		in, out := &in.Bridge, &out.Bridge
		*out = new(InterfaceBridge)
		**out = **in
	}
	if in.DeprecatedSlirp != nil {
		in, out := &in.DeprecatedSlirp, &out.DeprecatedSlirp
		*out = new(DeprecatedInterfaceSlirp)
		**out = **in
	}
	if in.Masquerade != nil {
		in, out := &in.Masquerade, &out.Masquerade
		*out = new(InterfaceMasquerade)
		**out = **in
	}
	if in.SRIOV != nil {
		in, out := &in.SRIOV, &out.SRIOV
		*out = new(InterfaceSRIOV)
		**out = **in
	}
	if in.DeprecatedMacvtap != nil {
		in, out := &in.DeprecatedMacvtap, &out.DeprecatedMacvtap
		*out = new(DeprecatedInterfaceMacvtap)
		**out = **in
	}
	if in.DeprecatedPasst != nil {
		in, out := &in.DeprecatedPasst, &out.DeprecatedPasst
		*out = new(DeprecatedInterfacePasst)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InterfaceBindingMethod.
func (in *InterfaceBindingMethod) DeepCopy() *InterfaceBindingMethod {
	if in == nil {
		return nil
	}
	out := new(InterfaceBindingMethod)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InterfaceBindingMigration) DeepCopyInto(out *InterfaceBindingMigration) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InterfaceBindingMigration.
func (in *InterfaceBindingMigration) DeepCopy() *InterfaceBindingMigration {
	if in == nil {
		return nil
	}
	out := new(InterfaceBindingMigration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InterfaceBindingPlugin) DeepCopyInto(out *InterfaceBindingPlugin) {
	*out = *in
	if in.Migration != nil {
		in, out := &in.Migration, &out.Migration
		*out = new(InterfaceBindingMigration)
		**out = **in
	}
	if in.ComputeResourceOverhead != nil {
		in, out := &in.ComputeResourceOverhead, &out.ComputeResourceOverhead
		*out = new(ResourceRequirementsWithoutClaims)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InterfaceBindingPlugin.
func (in *InterfaceBindingPlugin) DeepCopy() *InterfaceBindingPlugin {
	if in == nil {
		return nil
	}
	out := new(InterfaceBindingPlugin)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InterfaceBridge) DeepCopyInto(out *InterfaceBridge) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InterfaceBridge.
func (in *InterfaceBridge) DeepCopy() *InterfaceBridge {
	if in == nil {
		return nil
	}
	out := new(InterfaceBridge)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InterfaceMasquerade) DeepCopyInto(out *InterfaceMasquerade) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InterfaceMasquerade.
func (in *InterfaceMasquerade) DeepCopy() *InterfaceMasquerade {
	if in == nil {
		return nil
	}
	out := new(InterfaceMasquerade)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InterfaceSRIOV) DeepCopyInto(out *InterfaceSRIOV) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InterfaceSRIOV.
func (in *InterfaceSRIOV) DeepCopy() *InterfaceSRIOV {
	if in == nil {
		return nil
	}
	out := new(InterfaceSRIOV)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KSMConfiguration) DeepCopyInto(out *KSMConfiguration) {
	*out = *in
	if in.NodeLabelSelector != nil {
		in, out := &in.NodeLabelSelector, &out.NodeLabelSelector
		*out = new(metav1.LabelSelector)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KSMConfiguration.
func (in *KSMConfiguration) DeepCopy() *KSMConfiguration {
	if in == nil {
		return nil
	}
	out := new(KSMConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KVMTimer) DeepCopyInto(out *KVMTimer) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KVMTimer.
func (in *KVMTimer) DeepCopy() *KVMTimer {
	if in == nil {
		return nil
	}
	out := new(KVMTimer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KernelBoot) DeepCopyInto(out *KernelBoot) {
	*out = *in
	if in.Container != nil {
		in, out := &in.Container, &out.Container
		*out = new(KernelBootContainer)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KernelBoot.
func (in *KernelBoot) DeepCopy() *KernelBoot {
	if in == nil {
		return nil
	}
	out := new(KernelBoot)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KernelBootContainer) DeepCopyInto(out *KernelBootContainer) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KernelBootContainer.
func (in *KernelBootContainer) DeepCopy() *KernelBootContainer {
	if in == nil {
		return nil
	}
	out := new(KernelBootContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KernelBootStatus) DeepCopyInto(out *KernelBootStatus) {
	*out = *in
	if in.KernelInfo != nil {
		in, out := &in.KernelInfo, &out.KernelInfo
		*out = new(KernelInfo)
		**out = **in
	}
	if in.InitrdInfo != nil {
		in, out := &in.InitrdInfo, &out.InitrdInfo
		*out = new(InitrdInfo)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KernelBootStatus.
func (in *KernelBootStatus) DeepCopy() *KernelBootStatus {
	if in == nil {
		return nil
	}
	out := new(KernelBootStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KernelInfo) DeepCopyInto(out *KernelInfo) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KernelInfo.
func (in *KernelInfo) DeepCopy() *KernelInfo {
	if in == nil {
		return nil
	}
	out := new(KernelInfo)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeVirt) DeepCopyInto(out *KubeVirt) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeVirt.
func (in *KubeVirt) DeepCopy() *KubeVirt {
	if in == nil {
		return nil
	}
	out := new(KubeVirt)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *KubeVirt) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeVirtCertificateRotateStrategy) DeepCopyInto(out *KubeVirtCertificateRotateStrategy) {
	*out = *in
	if in.SelfSigned != nil {
		in, out := &in.SelfSigned, &out.SelfSigned
		*out = new(KubeVirtSelfSignConfiguration)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeVirtCertificateRotateStrategy.
func (in *KubeVirtCertificateRotateStrategy) DeepCopy() *KubeVirtCertificateRotateStrategy {
	if in == nil {
		return nil
	}
	out := new(KubeVirtCertificateRotateStrategy)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeVirtCondition) DeepCopyInto(out *KubeVirtCondition) {
	*out = *in
	in.LastProbeTime.DeepCopyInto(&out.LastProbeTime)
	in.LastTransitionTime.DeepCopyInto(&out.LastTransitionTime)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeVirtCondition.
func (in *KubeVirtCondition) DeepCopy() *KubeVirtCondition {
	if in == nil {
		return nil
	}
	out := new(KubeVirtCondition)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeVirtConfiguration) DeepCopyInto(out *KubeVirtConfiguration) {
	*out = *in
	if in.CPURequest != nil {
		in, out := &in.CPURequest, &out.CPURequest
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.DeveloperConfiguration != nil {
		in, out := &in.DeveloperConfiguration, &out.DeveloperConfiguration
		*out = new(DeveloperConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.EmulatedMachines != nil {
		in, out := &in.EmulatedMachines, &out.EmulatedMachines
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.MigrationConfiguration != nil {
		in, out := &in.MigrationConfiguration, &out.MigrationConfiguration
		*out = new(MigrationConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.NetworkConfiguration != nil {
		in, out := &in.NetworkConfiguration, &out.NetworkConfiguration
		*out = new(NetworkConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.SMBIOSConfig != nil {
		in, out := &in.SMBIOSConfig, &out.SMBIOSConfig
		*out = new(SMBiosConfiguration)
		**out = **in
	}
	if in.ArchitectureConfiguration != nil {
		in, out := &in.ArchitectureConfiguration, &out.ArchitectureConfiguration
		*out = new(ArchConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.EvictionStrategy != nil {
		in, out := &in.EvictionStrategy, &out.EvictionStrategy
		*out = new(EvictionStrategy)
		**out = **in
	}
	if in.AdditionalGuestMemoryOverheadRatio != nil {
		in, out := &in.AdditionalGuestMemoryOverheadRatio, &out.AdditionalGuestMemoryOverheadRatio
		*out = new(string)
		**out = **in
	}
	if in.SupportContainerResources != nil {
		in, out := &in.SupportContainerResources, &out.SupportContainerResources
		*out = make([]SupportContainerResources, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.SupportedGuestAgentVersions != nil {
		in, out := &in.SupportedGuestAgentVersions, &out.SupportedGuestAgentVersions
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.MemBalloonStatsPeriod != nil {
		in, out := &in.MemBalloonStatsPeriod, &out.MemBalloonStatsPeriod
		*out = new(uint32)
		**out = **in
	}
	if in.PermittedHostDevices != nil {
		in, out := &in.PermittedHostDevices, &out.PermittedHostDevices
		*out = new(PermittedHostDevices)
		(*in).DeepCopyInto(*out)
	}
	if in.MediatedDevicesConfiguration != nil {
		in, out := &in.MediatedDevicesConfiguration, &out.MediatedDevicesConfiguration
		*out = new(MediatedDevicesConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.ObsoleteCPUModels != nil {
		in, out := &in.ObsoleteCPUModels, &out.ObsoleteCPUModels
		*out = make(map[string]bool, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.VirtualMachineInstancesPerNode != nil {
		in, out := &in.VirtualMachineInstancesPerNode, &out.VirtualMachineInstancesPerNode
		*out = new(int)
		**out = **in
	}
	if in.APIConfiguration != nil {
		in, out := &in.APIConfiguration, &out.APIConfiguration
		*out = new(ReloadableComponentConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.WebhookConfiguration != nil {
		in, out := &in.WebhookConfiguration, &out.WebhookConfiguration
		*out = new(ReloadableComponentConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.ControllerConfiguration != nil {
		in, out := &in.ControllerConfiguration, &out.ControllerConfiguration
		*out = new(ReloadableComponentConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.HandlerConfiguration != nil {
		in, out := &in.HandlerConfiguration, &out.HandlerConfiguration
		*out = new(ReloadableComponentConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.TLSConfiguration != nil {
		in, out := &in.TLSConfiguration, &out.TLSConfiguration
		*out = new(TLSConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.SeccompConfiguration != nil {
		in, out := &in.SeccompConfiguration, &out.SeccompConfiguration
		*out = new(SeccompConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.VirtualMachineOptions != nil {
		in, out := &in.VirtualMachineOptions, &out.VirtualMachineOptions
		*out = new(VirtualMachineOptions)
		(*in).DeepCopyInto(*out)
	}
	if in.KSMConfiguration != nil {
		in, out := &in.KSMConfiguration, &out.KSMConfiguration
		*out = new(KSMConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.AutoCPULimitNamespaceLabelSelector != nil {
		in, out := &in.AutoCPULimitNamespaceLabelSelector, &out.AutoCPULimitNamespaceLabelSelector
		*out = new(metav1.LabelSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.LiveUpdateConfiguration != nil {
		in, out := &in.LiveUpdateConfiguration, &out.LiveUpdateConfiguration
		*out = new(LiveUpdateConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.VMRolloutStrategy != nil {
		in, out := &in.VMRolloutStrategy, &out.VMRolloutStrategy
		*out = new(VMRolloutStrategy)
		**out = **in
	}
	if in.CommonInstancetypesDeployment != nil {
		in, out := &in.CommonInstancetypesDeployment, &out.CommonInstancetypesDeployment
		*out = new(CommonInstancetypesDeployment)
		(*in).DeepCopyInto(*out)
	}
	if in.Instancetype != nil {
		in, out := &in.Instancetype, &out.Instancetype
		*out = new(InstancetypeConfiguration)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeVirtConfiguration.
func (in *KubeVirtConfiguration) DeepCopy() *KubeVirtConfiguration {
	if in == nil {
		return nil
	}
	out := new(KubeVirtConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeVirtList) DeepCopyInto(out *KubeVirtList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]KubeVirt, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeVirtList.
func (in *KubeVirtList) DeepCopy() *KubeVirtList {
	if in == nil {
		return nil
	}
	out := new(KubeVirtList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *KubeVirtList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeVirtSelfSignConfiguration) DeepCopyInto(out *KubeVirtSelfSignConfiguration) {
	*out = *in
	if in.CARotateInterval != nil {
		in, out := &in.CARotateInterval, &out.CARotateInterval
		*out = new(metav1.Duration)
		**out = **in
	}
	if in.CertRotateInterval != nil {
		in, out := &in.CertRotateInterval, &out.CertRotateInterval
		*out = new(metav1.Duration)
		**out = **in
	}
	if in.CAOverlapInterval != nil {
		in, out := &in.CAOverlapInterval, &out.CAOverlapInterval
		*out = new(metav1.Duration)
		**out = **in
	}
	if in.CA != nil {
		in, out := &in.CA, &out.CA
		*out = new(CertConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.Server != nil {
		in, out := &in.Server, &out.Server
		*out = new(CertConfig)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeVirtSelfSignConfiguration.
func (in *KubeVirtSelfSignConfiguration) DeepCopy() *KubeVirtSelfSignConfiguration {
	if in == nil {
		return nil
	}
	out := new(KubeVirtSelfSignConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeVirtSpec) DeepCopyInto(out *KubeVirtSpec) {
	*out = *in
	if in.ImagePullSecrets != nil {
		in, out := &in.ImagePullSecrets, &out.ImagePullSecrets
		*out = make([]corev1.LocalObjectReference, len(*in))
		copy(*out, *in)
	}
	in.WorkloadUpdateStrategy.DeepCopyInto(&out.WorkloadUpdateStrategy)
	in.CertificateRotationStrategy.DeepCopyInto(&out.CertificateRotationStrategy)
	in.Configuration.DeepCopyInto(&out.Configuration)
	if in.Infra != nil {
		in, out := &in.Infra, &out.Infra
		*out = new(ComponentConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.Workloads != nil {
		in, out := &in.Workloads, &out.Workloads
		*out = new(ComponentConfig)
		(*in).DeepCopyInto(*out)
	}
	in.CustomizeComponents.DeepCopyInto(&out.CustomizeComponents)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeVirtSpec.
func (in *KubeVirtSpec) DeepCopy() *KubeVirtSpec {
	if in == nil {
		return nil
	}
	out := new(KubeVirtSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeVirtStatus) DeepCopyInto(out *KubeVirtStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]KubeVirtCondition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.OutdatedVirtualMachineInstanceWorkloads != nil {
		in, out := &in.OutdatedVirtualMachineInstanceWorkloads, &out.OutdatedVirtualMachineInstanceWorkloads
		*out = new(int)
		**out = **in
	}
	if in.ObservedGeneration != nil {
		in, out := &in.ObservedGeneration, &out.ObservedGeneration
		*out = new(int64)
		**out = **in
	}
	if in.Generations != nil {
		in, out := &in.Generations, &out.Generations
		*out = make([]GenerationStatus, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeVirtStatus.
func (in *KubeVirtStatus) DeepCopy() *KubeVirtStatus {
	if in == nil {
		return nil
	}
	out := new(KubeVirtStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeVirtWorkloadUpdateStrategy) DeepCopyInto(out *KubeVirtWorkloadUpdateStrategy) {
	*out = *in
	if in.WorkloadUpdateMethods != nil {
		in, out := &in.WorkloadUpdateMethods, &out.WorkloadUpdateMethods
		*out = make([]WorkloadUpdateMethod, len(*in))
		copy(*out, *in)
	}
	if in.BatchEvictionSize != nil {
		in, out := &in.BatchEvictionSize, &out.BatchEvictionSize
		*out = new(int)
		**out = **in
	}
	if in.BatchEvictionInterval != nil {
		in, out := &in.BatchEvictionInterval, &out.BatchEvictionInterval
		*out = new(metav1.Duration)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeVirtWorkloadUpdateStrategy.
func (in *KubeVirtWorkloadUpdateStrategy) DeepCopy() *KubeVirtWorkloadUpdateStrategy {
	if in == nil {
		return nil
	}
	out := new(KubeVirtWorkloadUpdateStrategy)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LaunchSecurity) DeepCopyInto(out *LaunchSecurity) {
	*out = *in
	if in.SEV != nil {
		in, out := &in.SEV, &out.SEV
		*out = new(SEV)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LaunchSecurity.
func (in *LaunchSecurity) DeepCopy() *LaunchSecurity {
	if in == nil {
		return nil
	}
	out := new(LaunchSecurity)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LiveUpdateConfiguration) DeepCopyInto(out *LiveUpdateConfiguration) {
	*out = *in
	if in.MaxCpuSockets != nil {
		in, out := &in.MaxCpuSockets, &out.MaxCpuSockets
		*out = new(uint32)
		**out = **in
	}
	if in.MaxGuest != nil {
		in, out := &in.MaxGuest, &out.MaxGuest
		x := (*in).DeepCopy()
		*out = &x
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LiveUpdateConfiguration.
func (in *LiveUpdateConfiguration) DeepCopy() *LiveUpdateConfiguration {
	if in == nil {
		return nil
	}
	out := new(LiveUpdateConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LogVerbosity) DeepCopyInto(out *LogVerbosity) {
	*out = *in
	if in.NodeVerbosity != nil {
		in, out := &in.NodeVerbosity, &out.NodeVerbosity
		*out = make(map[string]uint, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LogVerbosity.
func (in *LogVerbosity) DeepCopy() *LogVerbosity {
	if in == nil {
		return nil
	}
	out := new(LogVerbosity)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LunTarget) DeepCopyInto(out *LunTarget) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LunTarget.
func (in *LunTarget) DeepCopy() *LunTarget {
	if in == nil {
		return nil
	}
	out := new(LunTarget)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Machine) DeepCopyInto(out *Machine) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Machine.
func (in *Machine) DeepCopy() *Machine {
	if in == nil {
		return nil
	}
	out := new(Machine)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MediatedDevicesConfiguration) DeepCopyInto(out *MediatedDevicesConfiguration) {
	*out = *in
	if in.MediatedDevicesTypes != nil {
		in, out := &in.MediatedDevicesTypes, &out.MediatedDevicesTypes
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.MediatedDeviceTypes != nil {
		in, out := &in.MediatedDeviceTypes, &out.MediatedDeviceTypes
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.NodeMediatedDeviceTypes != nil {
		in, out := &in.NodeMediatedDeviceTypes, &out.NodeMediatedDeviceTypes
		*out = make([]NodeMediatedDeviceTypesConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MediatedDevicesConfiguration.
func (in *MediatedDevicesConfiguration) DeepCopy() *MediatedDevicesConfiguration {
	if in == nil {
		return nil
	}
	out := new(MediatedDevicesConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MediatedHostDevice) DeepCopyInto(out *MediatedHostDevice) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MediatedHostDevice.
func (in *MediatedHostDevice) DeepCopy() *MediatedHostDevice {
	if in == nil {
		return nil
	}
	out := new(MediatedHostDevice)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Memory) DeepCopyInto(out *Memory) {
	*out = *in
	if in.Hugepages != nil {
		in, out := &in.Hugepages, &out.Hugepages
		*out = new(Hugepages)
		**out = **in
	}
	if in.Guest != nil {
		in, out := &in.Guest, &out.Guest
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.MaxGuest != nil {
		in, out := &in.MaxGuest, &out.MaxGuest
		x := (*in).DeepCopy()
		*out = &x
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Memory.
func (in *Memory) DeepCopy() *Memory {
	if in == nil {
		return nil
	}
	out := new(Memory)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MemoryDumpVolumeSource) DeepCopyInto(out *MemoryDumpVolumeSource) {
	*out = *in
	out.PersistentVolumeClaimVolumeSource = in.PersistentVolumeClaimVolumeSource
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MemoryDumpVolumeSource.
func (in *MemoryDumpVolumeSource) DeepCopy() *MemoryDumpVolumeSource {
	if in == nil {
		return nil
	}
	out := new(MemoryDumpVolumeSource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MemoryStatus) DeepCopyInto(out *MemoryStatus) {
	*out = *in
	if in.GuestAtBoot != nil {
		in, out := &in.GuestAtBoot, &out.GuestAtBoot
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.GuestCurrent != nil {
		in, out := &in.GuestCurrent, &out.GuestCurrent
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.GuestRequested != nil {
		in, out := &in.GuestRequested, &out.GuestRequested
		x := (*in).DeepCopy()
		*out = &x
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MemoryStatus.
func (in *MemoryStatus) DeepCopy() *MemoryStatus {
	if in == nil {
		return nil
	}
	out := new(MemoryStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigrateOptions) DeepCopyInto(out *MigrateOptions) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	if in.DryRun != nil {
		in, out := &in.DryRun, &out.DryRun
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigrateOptions.
func (in *MigrateOptions) DeepCopy() *MigrateOptions {
	if in == nil {
		return nil
	}
	out := new(MigrateOptions)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MigrationConfiguration) DeepCopyInto(out *MigrationConfiguration) {
	*out = *in
	if in.NodeDrainTaintKey != nil {
		in, out := &in.NodeDrainTaintKey, &out.NodeDrainTaintKey
		*out = new(string)
		**out = **in
	}
	if in.ParallelOutboundMigrationsPerNode != nil {
		in, out := &in.ParallelOutboundMigrationsPerNode, &out.ParallelOutboundMigrationsPerNode
		*out = new(uint32)
		**out = **in
	}
	if in.ParallelMigrationsPerCluster != nil {
		in, out := &in.ParallelMigrationsPerCluster, &out.ParallelMigrationsPerCluster
		*out = new(uint32)
		**out = **in
	}
	if in.AllowAutoConverge != nil {
		in, out := &in.AllowAutoConverge, &out.AllowAutoConverge
		*out = new(bool)
		**out = **in
	}
	if in.BandwidthPerMigration != nil {
		in, out := &in.BandwidthPerMigration, &out.BandwidthPerMigration
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.CompletionTimeoutPerGiB != nil {
		in, out := &in.CompletionTimeoutPerGiB, &out.CompletionTimeoutPerGiB
		*out = new(int64)
		**out = **in
	}
	if in.ProgressTimeout != nil {
		in, out := &in.ProgressTimeout, &out.ProgressTimeout
		*out = new(int64)
		**out = **in
	}
	if in.UnsafeMigrationOverride != nil {
		in, out := &in.UnsafeMigrationOverride, &out.UnsafeMigrationOverride
		*out = new(bool)
		**out = **in
	}
	if in.AllowPostCopy != nil {
		in, out := &in.AllowPostCopy, &out.AllowPostCopy
		*out = new(bool)
		**out = **in
	}
	if in.DisableTLS != nil {
		in, out := &in.DisableTLS, &out.DisableTLS
		*out = new(bool)
		**out = **in
	}
	if in.Network != nil {
		in, out := &in.Network, &out.Network
		*out = new(string)
		**out = **in
	}
	if in.MatchSELinuxLevelOnMigration != nil {
		in, out := &in.MatchSELinuxLevelOnMigration, &out.MatchSELinuxLevelOnMigration
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MigrationConfiguration.
func (in *MigrationConfiguration) DeepCopy() *MigrationConfiguration {
	if in == nil {
		return nil
	}
	out := new(MigrationConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MultusNetwork) DeepCopyInto(out *MultusNetwork) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MultusNetwork.
func (in *MultusNetwork) DeepCopy() *MultusNetwork {
	if in == nil {
		return nil
	}
	out := new(MultusNetwork)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NUMA) DeepCopyInto(out *NUMA) {
	*out = *in
	if in.GuestMappingPassthrough != nil {
		in, out := &in.GuestMappingPassthrough, &out.GuestMappingPassthrough
		*out = new(NUMAGuestMappingPassthrough)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NUMA.
func (in *NUMA) DeepCopy() *NUMA {
	if in == nil {
		return nil
	}
	out := new(NUMA)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NUMAGuestMappingPassthrough) DeepCopyInto(out *NUMAGuestMappingPassthrough) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NUMAGuestMappingPassthrough.
func (in *NUMAGuestMappingPassthrough) DeepCopy() *NUMAGuestMappingPassthrough {
	if in == nil {
		return nil
	}
	out := new(NUMAGuestMappingPassthrough)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Network) DeepCopyInto(out *Network) {
	*out = *in
	in.NetworkSource.DeepCopyInto(&out.NetworkSource)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Network.
func (in *Network) DeepCopy() *Network {
	if in == nil {
		return nil
	}
	out := new(Network)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NetworkConfiguration) DeepCopyInto(out *NetworkConfiguration) {
	*out = *in
	if in.DeprecatedPermitSlirpInterface != nil {
		in, out := &in.DeprecatedPermitSlirpInterface, &out.DeprecatedPermitSlirpInterface
		*out = new(bool)
		**out = **in
	}
	if in.PermitBridgeInterfaceOnPodNetwork != nil {
		in, out := &in.PermitBridgeInterfaceOnPodNetwork, &out.PermitBridgeInterfaceOnPodNetwork
		*out = new(bool)
		**out = **in
	}
	if in.Binding != nil {
		in, out := &in.Binding, &out.Binding
		*out = make(map[string]InterfaceBindingPlugin, len(*in))
		for key, val := range *in {
			(*out)[key] = *val.DeepCopy()
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NetworkConfiguration.
func (in *NetworkConfiguration) DeepCopy() *NetworkConfiguration {
	if in == nil {
		return nil
	}
	out := new(NetworkConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NetworkSource) DeepCopyInto(out *NetworkSource) {
	*out = *in
	if in.Pod != nil {
		in, out := &in.Pod, &out.Pod
		*out = new(PodNetwork)
		**out = **in
	}
	if in.Multus != nil {
		in, out := &in.Multus, &out.Multus
		*out = new(MultusNetwork)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NetworkSource.
func (in *NetworkSource) DeepCopy() *NetworkSource {
	if in == nil {
		return nil
	}
	out := new(NetworkSource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NoCloudSSHPublicKeyAccessCredentialPropagation) DeepCopyInto(out *NoCloudSSHPublicKeyAccessCredentialPropagation) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NoCloudSSHPublicKeyAccessCredentialPropagation.
func (in *NoCloudSSHPublicKeyAccessCredentialPropagation) DeepCopy() *NoCloudSSHPublicKeyAccessCredentialPropagation {
	if in == nil {
		return nil
	}
	out := new(NoCloudSSHPublicKeyAccessCredentialPropagation)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NodeMediatedDeviceTypesConfig) DeepCopyInto(out *NodeMediatedDeviceTypesConfig) {
	*out = *in
	if in.NodeSelector != nil {
		in, out := &in.NodeSelector, &out.NodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.MediatedDevicesTypes != nil {
		in, out := &in.MediatedDevicesTypes, &out.MediatedDevicesTypes
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.MediatedDeviceTypes != nil {
		in, out := &in.MediatedDeviceTypes, &out.MediatedDeviceTypes
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NodeMediatedDeviceTypesConfig.
func (in *NodeMediatedDeviceTypesConfig) DeepCopy() *NodeMediatedDeviceTypesConfig {
	if in == nil {
		return nil
	}
	out := new(NodeMediatedDeviceTypesConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NodePlacement) DeepCopyInto(out *NodePlacement) {
	*out = *in
	if in.NodeSelector != nil {
		in, out := &in.NodeSelector, &out.NodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Affinity != nil {
		in, out := &in.Affinity, &out.Affinity
		*out = new(corev1.Affinity)
		(*in).DeepCopyInto(*out)
	}
	if in.Tolerations != nil {
		in, out := &in.Tolerations, &out.Tolerations
		*out = make([]corev1.Toleration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NodePlacement.
func (in *NodePlacement) DeepCopy() *NodePlacement {
	if in == nil {
		return nil
	}
	out := new(NodePlacement)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PITTimer) DeepCopyInto(out *PITTimer) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PITTimer.
func (in *PITTimer) DeepCopy() *PITTimer {
	if in == nil {
		return nil
	}
	out := new(PITTimer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PauseOptions) DeepCopyInto(out *PauseOptions) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	if in.DryRun != nil {
		in, out := &in.DryRun, &out.DryRun
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PauseOptions.
func (in *PauseOptions) DeepCopy() *PauseOptions {
	if in == nil {
		return nil
	}
	out := new(PauseOptions)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PciHostDevice) DeepCopyInto(out *PciHostDevice) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PciHostDevice.
func (in *PciHostDevice) DeepCopy() *PciHostDevice {
	if in == nil {
		return nil
	}
	out := new(PciHostDevice)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PermittedHostDevices) DeepCopyInto(out *PermittedHostDevices) {
	*out = *in
	if in.PciHostDevices != nil {
		in, out := &in.PciHostDevices, &out.PciHostDevices
		*out = make([]PciHostDevice, len(*in))
		copy(*out, *in)
	}
	if in.MediatedDevices != nil {
		in, out := &in.MediatedDevices, &out.MediatedDevices
		*out = make([]MediatedHostDevice, len(*in))
		copy(*out, *in)
	}
	if in.USB != nil {
		in, out := &in.USB, &out.USB
		*out = make([]USBHostDevice, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PermittedHostDevices.
func (in *PermittedHostDevices) DeepCopy() *PermittedHostDevices {
	if in == nil {
		return nil
	}
	out := new(PermittedHostDevices)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PersistentVolumeClaimInfo) DeepCopyInto(out *PersistentVolumeClaimInfo) {
	*out = *in
	if in.AccessModes != nil {
		in, out := &in.AccessModes, &out.AccessModes
		*out = make([]corev1.PersistentVolumeAccessMode, len(*in))
		copy(*out, *in)
	}
	if in.VolumeMode != nil {
		in, out := &in.VolumeMode, &out.VolumeMode
		*out = new(corev1.PersistentVolumeMode)
		**out = **in
	}
	if in.Capacity != nil {
		in, out := &in.Capacity, &out.Capacity
		*out = make(corev1.ResourceList, len(*in))
		for key, val := range *in {
			(*out)[key] = val.DeepCopy()
		}
	}
	if in.Requests != nil {
		in, out := &in.Requests, &out.Requests
		*out = make(corev1.ResourceList, len(*in))
		for key, val := range *in {
			(*out)[key] = val.DeepCopy()
		}
	}
	if in.FilesystemOverhead != nil {
		in, out := &in.FilesystemOverhead, &out.FilesystemOverhead
		*out = new(Percent)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PersistentVolumeClaimInfo.
func (in *PersistentVolumeClaimInfo) DeepCopy() *PersistentVolumeClaimInfo {
	if in == nil {
		return nil
	}
	out := new(PersistentVolumeClaimInfo)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PersistentVolumeClaimVolumeSource) DeepCopyInto(out *PersistentVolumeClaimVolumeSource) {
	*out = *in
	out.PersistentVolumeClaimVolumeSource = in.PersistentVolumeClaimVolumeSource
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PersistentVolumeClaimVolumeSource.
func (in *PersistentVolumeClaimVolumeSource) DeepCopy() *PersistentVolumeClaimVolumeSource {
	if in == nil {
		return nil
	}
	out := new(PersistentVolumeClaimVolumeSource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PluginBinding) DeepCopyInto(out *PluginBinding) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PluginBinding.
func (in *PluginBinding) DeepCopy() *PluginBinding {
	if in == nil {
		return nil
	}
	out := new(PluginBinding)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PodNetwork) DeepCopyInto(out *PodNetwork) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PodNetwork.
func (in *PodNetwork) DeepCopy() *PodNetwork {
	if in == nil {
		return nil
	}
	out := new(PodNetwork)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Port) DeepCopyInto(out *Port) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Port.
func (in *Port) DeepCopy() *Port {
	if in == nil {
		return nil
	}
	out := new(Port)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PreferenceMatcher) DeepCopyInto(out *PreferenceMatcher) {
	*out = *in
	if in.InferFromVolumeFailurePolicy != nil {
		in, out := &in.InferFromVolumeFailurePolicy, &out.InferFromVolumeFailurePolicy
		*out = new(InferFromVolumeFailurePolicy)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PreferenceMatcher.
func (in *PreferenceMatcher) DeepCopy() *PreferenceMatcher {
	if in == nil {
		return nil
	}
	out := new(PreferenceMatcher)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Probe) DeepCopyInto(out *Probe) {
	*out = *in
	in.Handler.DeepCopyInto(&out.Handler)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Probe.
func (in *Probe) DeepCopy() *Probe {
	if in == nil {
		return nil
	}
	out := new(Probe)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ProfilerResult) DeepCopyInto(out *ProfilerResult) {
	*out = *in
	if in.PprofData != nil {
		in, out := &in.PprofData, &out.PprofData
		*out = make(map[string][]byte, len(*in))
		for key, val := range *in {
			var outVal []byte
			if val == nil {
				(*out)[key] = nil
			} else {
				in, out := &val, &outVal
				*out = make([]byte, len(*in))
				copy(*out, *in)
			}
			(*out)[key] = outVal
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ProfilerResult.
func (in *ProfilerResult) DeepCopy() *ProfilerResult {
	if in == nil {
		return nil
	}
	out := new(ProfilerResult)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *QemuGuestAgentSSHPublicKeyAccessCredentialPropagation) DeepCopyInto(out *QemuGuestAgentSSHPublicKeyAccessCredentialPropagation) {
	*out = *in
	if in.Users != nil {
		in, out := &in.Users, &out.Users
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new QemuGuestAgentSSHPublicKeyAccessCredentialPropagation.
func (in *QemuGuestAgentSSHPublicKeyAccessCredentialPropagation) DeepCopy() *QemuGuestAgentSSHPublicKeyAccessCredentialPropagation {
	if in == nil {
		return nil
	}
	out := new(QemuGuestAgentSSHPublicKeyAccessCredentialPropagation)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *QemuGuestAgentUserPasswordAccessCredentialPropagation) DeepCopyInto(out *QemuGuestAgentUserPasswordAccessCredentialPropagation) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new QemuGuestAgentUserPasswordAccessCredentialPropagation.
func (in *QemuGuestAgentUserPasswordAccessCredentialPropagation) DeepCopy() *QemuGuestAgentUserPasswordAccessCredentialPropagation {
	if in == nil {
		return nil
	}
	out := new(QemuGuestAgentUserPasswordAccessCredentialPropagation)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RESTClientConfiguration) DeepCopyInto(out *RESTClientConfiguration) {
	*out = *in
	if in.RateLimiter != nil {
		in, out := &in.RateLimiter, &out.RateLimiter
		*out = new(RateLimiter)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RESTClientConfiguration.
func (in *RESTClientConfiguration) DeepCopy() *RESTClientConfiguration {
	if in == nil {
		return nil
	}
	out := new(RESTClientConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RTCTimer) DeepCopyInto(out *RTCTimer) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RTCTimer.
func (in *RTCTimer) DeepCopy() *RTCTimer {
	if in == nil {
		return nil
	}
	out := new(RTCTimer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RateLimiter) DeepCopyInto(out *RateLimiter) {
	*out = *in
	if in.TokenBucketRateLimiter != nil {
		in, out := &in.TokenBucketRateLimiter, &out.TokenBucketRateLimiter
		*out = new(TokenBucketRateLimiter)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RateLimiter.
func (in *RateLimiter) DeepCopy() *RateLimiter {
	if in == nil {
		return nil
	}
	out := new(RateLimiter)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Realtime) DeepCopyInto(out *Realtime) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Realtime.
func (in *Realtime) DeepCopy() *Realtime {
	if in == nil {
		return nil
	}
	out := new(Realtime)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ReloadableComponentConfiguration) DeepCopyInto(out *ReloadableComponentConfiguration) {
	*out = *in
	if in.RestClient != nil {
		in, out := &in.RestClient, &out.RestClient
		*out = new(RESTClientConfiguration)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ReloadableComponentConfiguration.
func (in *ReloadableComponentConfiguration) DeepCopy() *ReloadableComponentConfiguration {
	if in == nil {
		return nil
	}
	out := new(ReloadableComponentConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RemoveVolumeOptions) DeepCopyInto(out *RemoveVolumeOptions) {
	*out = *in
	if in.DryRun != nil {
		in, out := &in.DryRun, &out.DryRun
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RemoveVolumeOptions.
func (in *RemoveVolumeOptions) DeepCopy() *RemoveVolumeOptions {
	if in == nil {
		return nil
	}
	out := new(RemoveVolumeOptions)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ResourceRequirements) DeepCopyInto(out *ResourceRequirements) {
	*out = *in
	if in.Requests != nil {
		in, out := &in.Requests, &out.Requests
		*out = make(corev1.ResourceList, len(*in))
		for key, val := range *in {
			(*out)[key] = val.DeepCopy()
		}
	}
	if in.Limits != nil {
		in, out := &in.Limits, &out.Limits
		*out = make(corev1.ResourceList, len(*in))
		for key, val := range *in {
			(*out)[key] = val.DeepCopy()
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ResourceRequirements.
func (in *ResourceRequirements) DeepCopy() *ResourceRequirements {
	if in == nil {
		return nil
	}
	out := new(ResourceRequirements)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ResourceRequirementsWithoutClaims) DeepCopyInto(out *ResourceRequirementsWithoutClaims) {
	*out = *in
	if in.Limits != nil {
		in, out := &in.Limits, &out.Limits
		*out = make(corev1.ResourceList, len(*in))
		for key, val := range *in {
			(*out)[key] = val.DeepCopy()
		}
	}
	if in.Requests != nil {
		in, out := &in.Requests, &out.Requests
		*out = make(corev1.ResourceList, len(*in))
		for key, val := range *in {
			(*out)[key] = val.DeepCopy()
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ResourceRequirementsWithoutClaims.
func (in *ResourceRequirementsWithoutClaims) DeepCopy() *ResourceRequirementsWithoutClaims {
	if in == nil {
		return nil
	}
	out := new(ResourceRequirementsWithoutClaims)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RestartOptions) DeepCopyInto(out *RestartOptions) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	if in.GracePeriodSeconds != nil {
		in, out := &in.GracePeriodSeconds, &out.GracePeriodSeconds
		*out = new(int64)
		**out = **in
	}
	if in.DryRun != nil {
		in, out := &in.DryRun, &out.DryRun
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RestartOptions.
func (in *RestartOptions) DeepCopy() *RestartOptions {
	if in == nil {
		return nil
	}
	out := new(RestartOptions)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Rng) DeepCopyInto(out *Rng) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Rng.
func (in *Rng) DeepCopy() *Rng {
	if in == nil {
		return nil
	}
	out := new(Rng)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SEV) DeepCopyInto(out *SEV) {
	*out = *in
	if in.Policy != nil {
		in, out := &in.Policy, &out.Policy
		*out = new(SEVPolicy)
		(*in).DeepCopyInto(*out)
	}
	if in.Attestation != nil {
		in, out := &in.Attestation, &out.Attestation
		*out = new(SEVAttestation)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SEV.
func (in *SEV) DeepCopy() *SEV {
	if in == nil {
		return nil
	}
	out := new(SEV)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SEVAttestation) DeepCopyInto(out *SEVAttestation) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SEVAttestation.
func (in *SEVAttestation) DeepCopy() *SEVAttestation {
	if in == nil {
		return nil
	}
	out := new(SEVAttestation)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SEVMeasurementInfo) DeepCopyInto(out *SEVMeasurementInfo) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SEVMeasurementInfo.
func (in *SEVMeasurementInfo) DeepCopy() *SEVMeasurementInfo {
	if in == nil {
		return nil
	}
	out := new(SEVMeasurementInfo)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *SEVMeasurementInfo) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SEVPlatformInfo) DeepCopyInto(out *SEVPlatformInfo) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SEVPlatformInfo.
func (in *SEVPlatformInfo) DeepCopy() *SEVPlatformInfo {
	if in == nil {
		return nil
	}
	out := new(SEVPlatformInfo)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *SEVPlatformInfo) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SEVPolicy) DeepCopyInto(out *SEVPolicy) {
	*out = *in
	if in.EncryptedState != nil {
		in, out := &in.EncryptedState, &out.EncryptedState
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SEVPolicy.
func (in *SEVPolicy) DeepCopy() *SEVPolicy {
	if in == nil {
		return nil
	}
	out := new(SEVPolicy)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SEVSecretOptions) DeepCopyInto(out *SEVSecretOptions) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SEVSecretOptions.
func (in *SEVSecretOptions) DeepCopy() *SEVSecretOptions {
	if in == nil {
		return nil
	}
	out := new(SEVSecretOptions)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SEVSessionOptions) DeepCopyInto(out *SEVSessionOptions) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SEVSessionOptions.
func (in *SEVSessionOptions) DeepCopy() *SEVSessionOptions {
	if in == nil {
		return nil
	}
	out := new(SEVSessionOptions)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SMBiosConfiguration) DeepCopyInto(out *SMBiosConfiguration) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SMBiosConfiguration.
func (in *SMBiosConfiguration) DeepCopy() *SMBiosConfiguration {
	if in == nil {
		return nil
	}
	out := new(SMBiosConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SSHPublicKeyAccessCredential) DeepCopyInto(out *SSHPublicKeyAccessCredential) {
	*out = *in
	in.Source.DeepCopyInto(&out.Source)
	in.PropagationMethod.DeepCopyInto(&out.PropagationMethod)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SSHPublicKeyAccessCredential.
func (in *SSHPublicKeyAccessCredential) DeepCopy() *SSHPublicKeyAccessCredential {
	if in == nil {
		return nil
	}
	out := new(SSHPublicKeyAccessCredential)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SSHPublicKeyAccessCredentialPropagationMethod) DeepCopyInto(out *SSHPublicKeyAccessCredentialPropagationMethod) {
	*out = *in
	if in.ConfigDrive != nil {
		in, out := &in.ConfigDrive, &out.ConfigDrive
		*out = new(ConfigDriveSSHPublicKeyAccessCredentialPropagation)
		**out = **in
	}
	if in.NoCloud != nil {
		in, out := &in.NoCloud, &out.NoCloud
		*out = new(NoCloudSSHPublicKeyAccessCredentialPropagation)
		**out = **in
	}
	if in.QemuGuestAgent != nil {
		in, out := &in.QemuGuestAgent, &out.QemuGuestAgent
		*out = new(QemuGuestAgentSSHPublicKeyAccessCredentialPropagation)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SSHPublicKeyAccessCredentialPropagationMethod.
func (in *SSHPublicKeyAccessCredentialPropagationMethod) DeepCopy() *SSHPublicKeyAccessCredentialPropagationMethod {
	if in == nil {
		return nil
	}
	out := new(SSHPublicKeyAccessCredentialPropagationMethod)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SSHPublicKeyAccessCredentialSource) DeepCopyInto(out *SSHPublicKeyAccessCredentialSource) {
	*out = *in
	if in.Secret != nil {
		in, out := &in.Secret, &out.Secret
		*out = new(AccessCredentialSecretSource)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SSHPublicKeyAccessCredentialSource.
func (in *SSHPublicKeyAccessCredentialSource) DeepCopy() *SSHPublicKeyAccessCredentialSource {
	if in == nil {
		return nil
	}
	out := new(SSHPublicKeyAccessCredentialSource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ScreenshotOptions) DeepCopyInto(out *ScreenshotOptions) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ScreenshotOptions.
func (in *ScreenshotOptions) DeepCopy() *ScreenshotOptions {
	if in == nil {
		return nil
	}
	out := new(ScreenshotOptions)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SeccompConfiguration) DeepCopyInto(out *SeccompConfiguration) {
	*out = *in
	if in.VirtualMachineInstanceProfile != nil {
		in, out := &in.VirtualMachineInstanceProfile, &out.VirtualMachineInstanceProfile
		*out = new(VirtualMachineInstanceProfile)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SeccompConfiguration.
func (in *SeccompConfiguration) DeepCopy() *SeccompConfiguration {
	if in == nil {
		return nil
	}
	out := new(SeccompConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SecretVolumeSource) DeepCopyInto(out *SecretVolumeSource) {
	*out = *in
	if in.Optional != nil {
		in, out := &in.Optional, &out.Optional
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SecretVolumeSource.
func (in *SecretVolumeSource) DeepCopy() *SecretVolumeSource {
	if in == nil {
		return nil
	}
	out := new(SecretVolumeSource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ServiceAccountVolumeSource) DeepCopyInto(out *ServiceAccountVolumeSource) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ServiceAccountVolumeSource.
func (in *ServiceAccountVolumeSource) DeepCopy() *ServiceAccountVolumeSource {
	if in == nil {
		return nil
	}
	out := new(ServiceAccountVolumeSource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SoundDevice) DeepCopyInto(out *SoundDevice) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SoundDevice.
func (in *SoundDevice) DeepCopy() *SoundDevice {
	if in == nil {
		return nil
	}
	out := new(SoundDevice)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StartOptions) DeepCopyInto(out *StartOptions) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	if in.DryRun != nil {
		in, out := &in.DryRun, &out.DryRun
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StartOptions.
func (in *StartOptions) DeepCopy() *StartOptions {
	if in == nil {
		return nil
	}
	out := new(StartOptions)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StopOptions) DeepCopyInto(out *StopOptions) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	if in.GracePeriod != nil {
		in, out := &in.GracePeriod, &out.GracePeriod
		*out = new(int64)
		**out = **in
	}
	if in.DryRun != nil {
		in, out := &in.DryRun, &out.DryRun
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StopOptions.
func (in *StopOptions) DeepCopy() *StopOptions {
	if in == nil {
		return nil
	}
	out := new(StopOptions)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StorageMigratedVolumeInfo) DeepCopyInto(out *StorageMigratedVolumeInfo) {
	*out = *in
	if in.SourcePVCInfo != nil {
		in, out := &in.SourcePVCInfo, &out.SourcePVCInfo
		*out = new(PersistentVolumeClaimInfo)
		(*in).DeepCopyInto(*out)
	}
	if in.DestinationPVCInfo != nil {
		in, out := &in.DestinationPVCInfo, &out.DestinationPVCInfo
		*out = new(PersistentVolumeClaimInfo)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StorageMigratedVolumeInfo.
func (in *StorageMigratedVolumeInfo) DeepCopy() *StorageMigratedVolumeInfo {
	if in == nil {
		return nil
	}
	out := new(StorageMigratedVolumeInfo)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SupportContainerResources) DeepCopyInto(out *SupportContainerResources) {
	*out = *in
	in.Resources.DeepCopyInto(&out.Resources)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SupportContainerResources.
func (in *SupportContainerResources) DeepCopy() *SupportContainerResources {
	if in == nil {
		return nil
	}
	out := new(SupportContainerResources)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SyNICTimer) DeepCopyInto(out *SyNICTimer) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	if in.Direct != nil {
		in, out := &in.Direct, &out.Direct
		*out = new(FeatureState)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SyNICTimer.
func (in *SyNICTimer) DeepCopy() *SyNICTimer {
	if in == nil {
		return nil
	}
	out := new(SyNICTimer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SysprepSource) DeepCopyInto(out *SysprepSource) {
	*out = *in
	if in.Secret != nil {
		in, out := &in.Secret, &out.Secret
		*out = new(corev1.LocalObjectReference)
		**out = **in
	}
	if in.ConfigMap != nil {
		in, out := &in.ConfigMap, &out.ConfigMap
		*out = new(corev1.LocalObjectReference)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SysprepSource.
func (in *SysprepSource) DeepCopy() *SysprepSource {
	if in == nil {
		return nil
	}
	out := new(SysprepSource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TLSConfiguration) DeepCopyInto(out *TLSConfiguration) {
	*out = *in
	if in.Ciphers != nil {
		in, out := &in.Ciphers, &out.Ciphers
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TLSConfiguration.
func (in *TLSConfiguration) DeepCopy() *TLSConfiguration {
	if in == nil {
		return nil
	}
	out := new(TLSConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TPMDevice) DeepCopyInto(out *TPMDevice) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	if in.Persistent != nil {
		in, out := &in.Persistent, &out.Persistent
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TPMDevice.
func (in *TPMDevice) DeepCopy() *TPMDevice {
	if in == nil {
		return nil
	}
	out := new(TPMDevice)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Timer) DeepCopyInto(out *Timer) {
	*out = *in
	if in.HPET != nil {
		in, out := &in.HPET, &out.HPET
		*out = new(HPETTimer)
		(*in).DeepCopyInto(*out)
	}
	if in.KVM != nil {
		in, out := &in.KVM, &out.KVM
		*out = new(KVMTimer)
		(*in).DeepCopyInto(*out)
	}
	if in.PIT != nil {
		in, out := &in.PIT, &out.PIT
		*out = new(PITTimer)
		(*in).DeepCopyInto(*out)
	}
	if in.RTC != nil {
		in, out := &in.RTC, &out.RTC
		*out = new(RTCTimer)
		(*in).DeepCopyInto(*out)
	}
	if in.Hyperv != nil {
		in, out := &in.Hyperv, &out.Hyperv
		*out = new(HypervTimer)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Timer.
func (in *Timer) DeepCopy() *Timer {
	if in == nil {
		return nil
	}
	out := new(Timer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TokenBucketRateLimiter) DeepCopyInto(out *TokenBucketRateLimiter) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TokenBucketRateLimiter.
func (in *TokenBucketRateLimiter) DeepCopy() *TokenBucketRateLimiter {
	if in == nil {
		return nil
	}
	out := new(TokenBucketRateLimiter)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TopologyHints) DeepCopyInto(out *TopologyHints) {
	*out = *in
	if in.TSCFrequency != nil {
		in, out := &in.TSCFrequency, &out.TSCFrequency
		*out = new(int64)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TopologyHints.
func (in *TopologyHints) DeepCopy() *TopologyHints {
	if in == nil {
		return nil
	}
	out := new(TopologyHints)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *USBHostDevice) DeepCopyInto(out *USBHostDevice) {
	*out = *in
	if in.Selectors != nil {
		in, out := &in.Selectors, &out.Selectors
		*out = make([]USBSelector, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new USBHostDevice.
func (in *USBHostDevice) DeepCopy() *USBHostDevice {
	if in == nil {
		return nil
	}
	out := new(USBHostDevice)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *USBSelector) DeepCopyInto(out *USBSelector) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new USBSelector.
func (in *USBSelector) DeepCopy() *USBSelector {
	if in == nil {
		return nil
	}
	out := new(USBSelector)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UnpauseOptions) DeepCopyInto(out *UnpauseOptions) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	if in.DryRun != nil {
		in, out := &in.DryRun, &out.DryRun
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UnpauseOptions.
func (in *UnpauseOptions) DeepCopy() *UnpauseOptions {
	if in == nil {
		return nil
	}
	out := new(UnpauseOptions)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UserPasswordAccessCredential) DeepCopyInto(out *UserPasswordAccessCredential) {
	*out = *in
	in.Source.DeepCopyInto(&out.Source)
	in.PropagationMethod.DeepCopyInto(&out.PropagationMethod)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UserPasswordAccessCredential.
func (in *UserPasswordAccessCredential) DeepCopy() *UserPasswordAccessCredential {
	if in == nil {
		return nil
	}
	out := new(UserPasswordAccessCredential)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UserPasswordAccessCredentialPropagationMethod) DeepCopyInto(out *UserPasswordAccessCredentialPropagationMethod) {
	*out = *in
	if in.QemuGuestAgent != nil {
		in, out := &in.QemuGuestAgent, &out.QemuGuestAgent
		*out = new(QemuGuestAgentUserPasswordAccessCredentialPropagation)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UserPasswordAccessCredentialPropagationMethod.
func (in *UserPasswordAccessCredentialPropagationMethod) DeepCopy() *UserPasswordAccessCredentialPropagationMethod {
	if in == nil {
		return nil
	}
	out := new(UserPasswordAccessCredentialPropagationMethod)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UserPasswordAccessCredentialSource) DeepCopyInto(out *UserPasswordAccessCredentialSource) {
	*out = *in
	if in.Secret != nil {
		in, out := &in.Secret, &out.Secret
		*out = new(AccessCredentialSecretSource)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UserPasswordAccessCredentialSource.
func (in *UserPasswordAccessCredentialSource) DeepCopy() *UserPasswordAccessCredentialSource {
	if in == nil {
		return nil
	}
	out := new(UserPasswordAccessCredentialSource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VGPUDisplayOptions) DeepCopyInto(out *VGPUDisplayOptions) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	if in.RamFB != nil {
		in, out := &in.RamFB, &out.RamFB
		*out = new(FeatureState)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VGPUDisplayOptions.
func (in *VGPUDisplayOptions) DeepCopy() *VGPUDisplayOptions {
	if in == nil {
		return nil
	}
	out := new(VGPUDisplayOptions)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VGPUOptions) DeepCopyInto(out *VGPUOptions) {
	*out = *in
	if in.Display != nil {
		in, out := &in.Display, &out.Display
		*out = new(VGPUDisplayOptions)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VGPUOptions.
func (in *VGPUOptions) DeepCopy() *VGPUOptions {
	if in == nil {
		return nil
	}
	out := new(VGPUOptions)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VMISelector) DeepCopyInto(out *VMISelector) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VMISelector.
func (in *VMISelector) DeepCopy() *VMISelector {
	if in == nil {
		return nil
	}
	out := new(VMISelector)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VSOCKOptions) DeepCopyInto(out *VSOCKOptions) {
	*out = *in
	if in.UseTLS != nil {
		in, out := &in.UseTLS, &out.UseTLS
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VSOCKOptions.
func (in *VSOCKOptions) DeepCopy() *VSOCKOptions {
	if in == nil {
		return nil
	}
	out := new(VSOCKOptions)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachine) DeepCopyInto(out *VirtualMachine) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachine.
func (in *VirtualMachine) DeepCopy() *VirtualMachine {
	if in == nil {
		return nil
	}
	out := new(VirtualMachine)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *VirtualMachine) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineCondition) DeepCopyInto(out *VirtualMachineCondition) {
	*out = *in
	in.LastProbeTime.DeepCopyInto(&out.LastProbeTime)
	in.LastTransitionTime.DeepCopyInto(&out.LastTransitionTime)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineCondition.
func (in *VirtualMachineCondition) DeepCopy() *VirtualMachineCondition {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineCondition)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstance) DeepCopyInto(out *VirtualMachineInstance) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstance.
func (in *VirtualMachineInstance) DeepCopy() *VirtualMachineInstance {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstance)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *VirtualMachineInstance) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceCondition) DeepCopyInto(out *VirtualMachineInstanceCondition) {
	*out = *in
	in.LastProbeTime.DeepCopyInto(&out.LastProbeTime)
	in.LastTransitionTime.DeepCopyInto(&out.LastTransitionTime)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceCondition.
func (in *VirtualMachineInstanceCondition) DeepCopy() *VirtualMachineInstanceCondition {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceCondition)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceFileSystem) DeepCopyInto(out *VirtualMachineInstanceFileSystem) {
	*out = *in
	if in.Disk != nil {
		in, out := &in.Disk, &out.Disk
		*out = make([]VirtualMachineInstanceFileSystemDisk, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceFileSystem.
func (in *VirtualMachineInstanceFileSystem) DeepCopy() *VirtualMachineInstanceFileSystem {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceFileSystem)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceFileSystemDisk) DeepCopyInto(out *VirtualMachineInstanceFileSystemDisk) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceFileSystemDisk.
func (in *VirtualMachineInstanceFileSystemDisk) DeepCopy() *VirtualMachineInstanceFileSystemDisk {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceFileSystemDisk)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceFileSystemInfo) DeepCopyInto(out *VirtualMachineInstanceFileSystemInfo) {
	*out = *in
	if in.Filesystems != nil {
		in, out := &in.Filesystems, &out.Filesystems
		*out = make([]VirtualMachineInstanceFileSystem, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceFileSystemInfo.
func (in *VirtualMachineInstanceFileSystemInfo) DeepCopy() *VirtualMachineInstanceFileSystemInfo {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceFileSystemInfo)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceFileSystemList) DeepCopyInto(out *VirtualMachineInstanceFileSystemList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]VirtualMachineInstanceFileSystem, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceFileSystemList.
func (in *VirtualMachineInstanceFileSystemList) DeepCopy() *VirtualMachineInstanceFileSystemList {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceFileSystemList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *VirtualMachineInstanceFileSystemList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceGuestAgentInfo) DeepCopyInto(out *VirtualMachineInstanceGuestAgentInfo) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	if in.SupportedCommands != nil {
		in, out := &in.SupportedCommands, &out.SupportedCommands
		*out = make([]GuestAgentCommandInfo, len(*in))
		copy(*out, *in)
	}
	out.OS = in.OS
	if in.UserList != nil {
		in, out := &in.UserList, &out.UserList
		*out = make([]VirtualMachineInstanceGuestOSUser, len(*in))
		copy(*out, *in)
	}
	in.FSInfo.DeepCopyInto(&out.FSInfo)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceGuestAgentInfo.
func (in *VirtualMachineInstanceGuestAgentInfo) DeepCopy() *VirtualMachineInstanceGuestAgentInfo {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceGuestAgentInfo)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *VirtualMachineInstanceGuestAgentInfo) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceGuestOSInfo) DeepCopyInto(out *VirtualMachineInstanceGuestOSInfo) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceGuestOSInfo.
func (in *VirtualMachineInstanceGuestOSInfo) DeepCopy() *VirtualMachineInstanceGuestOSInfo {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceGuestOSInfo)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceGuestOSUser) DeepCopyInto(out *VirtualMachineInstanceGuestOSUser) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceGuestOSUser.
func (in *VirtualMachineInstanceGuestOSUser) DeepCopy() *VirtualMachineInstanceGuestOSUser {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceGuestOSUser)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceGuestOSUserList) DeepCopyInto(out *VirtualMachineInstanceGuestOSUserList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]VirtualMachineInstanceGuestOSUser, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceGuestOSUserList.
func (in *VirtualMachineInstanceGuestOSUserList) DeepCopy() *VirtualMachineInstanceGuestOSUserList {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceGuestOSUserList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *VirtualMachineInstanceGuestOSUserList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceList) DeepCopyInto(out *VirtualMachineInstanceList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]VirtualMachineInstance, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceList.
func (in *VirtualMachineInstanceList) DeepCopy() *VirtualMachineInstanceList {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *VirtualMachineInstanceList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceMigration) DeepCopyInto(out *VirtualMachineInstanceMigration) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceMigration.
func (in *VirtualMachineInstanceMigration) DeepCopy() *VirtualMachineInstanceMigration {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceMigration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *VirtualMachineInstanceMigration) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceMigrationCondition) DeepCopyInto(out *VirtualMachineInstanceMigrationCondition) {
	*out = *in
	in.LastProbeTime.DeepCopyInto(&out.LastProbeTime)
	in.LastTransitionTime.DeepCopyInto(&out.LastTransitionTime)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceMigrationCondition.
func (in *VirtualMachineInstanceMigrationCondition) DeepCopy() *VirtualMachineInstanceMigrationCondition {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceMigrationCondition)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceMigrationList) DeepCopyInto(out *VirtualMachineInstanceMigrationList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]VirtualMachineInstanceMigration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceMigrationList.
func (in *VirtualMachineInstanceMigrationList) DeepCopy() *VirtualMachineInstanceMigrationList {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceMigrationList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *VirtualMachineInstanceMigrationList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceMigrationPhaseTransitionTimestamp) DeepCopyInto(out *VirtualMachineInstanceMigrationPhaseTransitionTimestamp) {
	*out = *in
	in.PhaseTransitionTimestamp.DeepCopyInto(&out.PhaseTransitionTimestamp)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceMigrationPhaseTransitionTimestamp.
func (in *VirtualMachineInstanceMigrationPhaseTransitionTimestamp) DeepCopy() *VirtualMachineInstanceMigrationPhaseTransitionTimestamp {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceMigrationPhaseTransitionTimestamp)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceMigrationSpec) DeepCopyInto(out *VirtualMachineInstanceMigrationSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceMigrationSpec.
func (in *VirtualMachineInstanceMigrationSpec) DeepCopy() *VirtualMachineInstanceMigrationSpec {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceMigrationSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceMigrationState) DeepCopyInto(out *VirtualMachineInstanceMigrationState) {
	*out = *in
	if in.StartTimestamp != nil {
		in, out := &in.StartTimestamp, &out.StartTimestamp
		*out = (*in).DeepCopy()
	}
	if in.EndTimestamp != nil {
		in, out := &in.EndTimestamp, &out.EndTimestamp
		*out = (*in).DeepCopy()
	}
	if in.TargetNodeDomainReadyTimestamp != nil {
		in, out := &in.TargetNodeDomainReadyTimestamp, &out.TargetNodeDomainReadyTimestamp
		*out = (*in).DeepCopy()
	}
	if in.TargetDirectMigrationNodePorts != nil {
		in, out := &in.TargetDirectMigrationNodePorts, &out.TargetDirectMigrationNodePorts
		*out = make(map[string]int, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.MigrationPolicyName != nil {
		in, out := &in.MigrationPolicyName, &out.MigrationPolicyName
		*out = new(string)
		**out = **in
	}
	if in.MigrationConfiguration != nil {
		in, out := &in.MigrationConfiguration, &out.MigrationConfiguration
		*out = new(MigrationConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.TargetCPUSet != nil {
		in, out := &in.TargetCPUSet, &out.TargetCPUSet
		*out = make([]int, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceMigrationState.
func (in *VirtualMachineInstanceMigrationState) DeepCopy() *VirtualMachineInstanceMigrationState {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceMigrationState)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceMigrationStatus) DeepCopyInto(out *VirtualMachineInstanceMigrationStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]VirtualMachineInstanceMigrationCondition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.PhaseTransitionTimestamps != nil {
		in, out := &in.PhaseTransitionTimestamps, &out.PhaseTransitionTimestamps
		*out = make([]VirtualMachineInstanceMigrationPhaseTransitionTimestamp, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.MigrationState != nil {
		in, out := &in.MigrationState, &out.MigrationState
		*out = new(VirtualMachineInstanceMigrationState)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceMigrationStatus.
func (in *VirtualMachineInstanceMigrationStatus) DeepCopy() *VirtualMachineInstanceMigrationStatus {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceMigrationStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceNetworkInterface) DeepCopyInto(out *VirtualMachineInstanceNetworkInterface) {
	*out = *in
	if in.IPs != nil {
		in, out := &in.IPs, &out.IPs
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceNetworkInterface.
func (in *VirtualMachineInstanceNetworkInterface) DeepCopy() *VirtualMachineInstanceNetworkInterface {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceNetworkInterface)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstancePhaseTransitionTimestamp) DeepCopyInto(out *VirtualMachineInstancePhaseTransitionTimestamp) {
	*out = *in
	in.PhaseTransitionTimestamp.DeepCopyInto(&out.PhaseTransitionTimestamp)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstancePhaseTransitionTimestamp.
func (in *VirtualMachineInstancePhaseTransitionTimestamp) DeepCopy() *VirtualMachineInstancePhaseTransitionTimestamp {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstancePhaseTransitionTimestamp)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstancePreset) DeepCopyInto(out *VirtualMachineInstancePreset) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstancePreset.
func (in *VirtualMachineInstancePreset) DeepCopy() *VirtualMachineInstancePreset {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstancePreset)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *VirtualMachineInstancePreset) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstancePresetList) DeepCopyInto(out *VirtualMachineInstancePresetList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]VirtualMachineInstancePreset, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstancePresetList.
func (in *VirtualMachineInstancePresetList) DeepCopy() *VirtualMachineInstancePresetList {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstancePresetList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *VirtualMachineInstancePresetList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstancePresetSpec) DeepCopyInto(out *VirtualMachineInstancePresetSpec) {
	*out = *in
	in.Selector.DeepCopyInto(&out.Selector)
	if in.Domain != nil {
		in, out := &in.Domain, &out.Domain
		*out = new(DomainSpec)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstancePresetSpec.
func (in *VirtualMachineInstancePresetSpec) DeepCopy() *VirtualMachineInstancePresetSpec {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstancePresetSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceProfile) DeepCopyInto(out *VirtualMachineInstanceProfile) {
	*out = *in
	if in.CustomProfile != nil {
		in, out := &in.CustomProfile, &out.CustomProfile
		*out = new(CustomProfile)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceProfile.
func (in *VirtualMachineInstanceProfile) DeepCopy() *VirtualMachineInstanceProfile {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceProfile)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceReplicaSet) DeepCopyInto(out *VirtualMachineInstanceReplicaSet) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceReplicaSet.
func (in *VirtualMachineInstanceReplicaSet) DeepCopy() *VirtualMachineInstanceReplicaSet {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceReplicaSet)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *VirtualMachineInstanceReplicaSet) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceReplicaSetCondition) DeepCopyInto(out *VirtualMachineInstanceReplicaSetCondition) {
	*out = *in
	in.LastProbeTime.DeepCopyInto(&out.LastProbeTime)
	in.LastTransitionTime.DeepCopyInto(&out.LastTransitionTime)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceReplicaSetCondition.
func (in *VirtualMachineInstanceReplicaSetCondition) DeepCopy() *VirtualMachineInstanceReplicaSetCondition {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceReplicaSetCondition)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceReplicaSetList) DeepCopyInto(out *VirtualMachineInstanceReplicaSetList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]VirtualMachineInstanceReplicaSet, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceReplicaSetList.
func (in *VirtualMachineInstanceReplicaSetList) DeepCopy() *VirtualMachineInstanceReplicaSetList {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceReplicaSetList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *VirtualMachineInstanceReplicaSetList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceReplicaSetSpec) DeepCopyInto(out *VirtualMachineInstanceReplicaSetSpec) {
	*out = *in
	if in.Replicas != nil {
		in, out := &in.Replicas, &out.Replicas
		*out = new(int32)
		**out = **in
	}
	if in.Selector != nil {
		in, out := &in.Selector, &out.Selector
		*out = new(metav1.LabelSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(VirtualMachineInstanceTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceReplicaSetSpec.
func (in *VirtualMachineInstanceReplicaSetSpec) DeepCopy() *VirtualMachineInstanceReplicaSetSpec {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceReplicaSetSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceReplicaSetStatus) DeepCopyInto(out *VirtualMachineInstanceReplicaSetStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]VirtualMachineInstanceReplicaSetCondition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceReplicaSetStatus.
func (in *VirtualMachineInstanceReplicaSetStatus) DeepCopy() *VirtualMachineInstanceReplicaSetStatus {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceReplicaSetStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceSpec) DeepCopyInto(out *VirtualMachineInstanceSpec) {
	*out = *in
	in.Domain.DeepCopyInto(&out.Domain)
	if in.NodeSelector != nil {
		in, out := &in.NodeSelector, &out.NodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Affinity != nil {
		in, out := &in.Affinity, &out.Affinity
		*out = new(corev1.Affinity)
		(*in).DeepCopyInto(*out)
	}
	if in.Tolerations != nil {
		in, out := &in.Tolerations, &out.Tolerations
		*out = make([]corev1.Toleration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.TopologySpreadConstraints != nil {
		in, out := &in.TopologySpreadConstraints, &out.TopologySpreadConstraints
		*out = make([]corev1.TopologySpreadConstraint, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.EvictionStrategy != nil {
		in, out := &in.EvictionStrategy, &out.EvictionStrategy
		*out = new(EvictionStrategy)
		**out = **in
	}
	if in.StartStrategy != nil {
		in, out := &in.StartStrategy, &out.StartStrategy
		*out = new(StartStrategy)
		**out = **in
	}
	if in.TerminationGracePeriodSeconds != nil {
		in, out := &in.TerminationGracePeriodSeconds, &out.TerminationGracePeriodSeconds
		*out = new(int64)
		**out = **in
	}
	if in.Volumes != nil {
		in, out := &in.Volumes, &out.Volumes
		*out = make([]Volume, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.LivenessProbe != nil {
		in, out := &in.LivenessProbe, &out.LivenessProbe
		*out = new(Probe)
		(*in).DeepCopyInto(*out)
	}
	if in.ReadinessProbe != nil {
		in, out := &in.ReadinessProbe, &out.ReadinessProbe
		*out = new(Probe)
		(*in).DeepCopyInto(*out)
	}
	if in.Networks != nil {
		in, out := &in.Networks, &out.Networks
		*out = make([]Network, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.DNSConfig != nil {
		in, out := &in.DNSConfig, &out.DNSConfig
		*out = new(corev1.PodDNSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.AccessCredentials != nil {
		in, out := &in.AccessCredentials, &out.AccessCredentials
		*out = make([]AccessCredential, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceSpec.
func (in *VirtualMachineInstanceSpec) DeepCopy() *VirtualMachineInstanceSpec {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceStatus) DeepCopyInto(out *VirtualMachineInstanceStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]VirtualMachineInstanceCondition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.PhaseTransitionTimestamps != nil {
		in, out := &in.PhaseTransitionTimestamps, &out.PhaseTransitionTimestamps
		*out = make([]VirtualMachineInstancePhaseTransitionTimestamp, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Interfaces != nil {
		in, out := &in.Interfaces, &out.Interfaces
		*out = make([]VirtualMachineInstanceNetworkInterface, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	out.GuestOSInfo = in.GuestOSInfo
	if in.MigrationState != nil {
		in, out := &in.MigrationState, &out.MigrationState
		*out = new(VirtualMachineInstanceMigrationState)
		(*in).DeepCopyInto(*out)
	}
	if in.QOSClass != nil {
		in, out := &in.QOSClass, &out.QOSClass
		*out = new(corev1.PodQOSClass)
		**out = **in
	}
	if in.ActivePods != nil {
		in, out := &in.ActivePods, &out.ActivePods
		*out = make(map[types.UID]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.VolumeStatus != nil {
		in, out := &in.VolumeStatus, &out.VolumeStatus
		*out = make([]VolumeStatus, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.KernelBootStatus != nil {
		in, out := &in.KernelBootStatus, &out.KernelBootStatus
		*out = new(KernelBootStatus)
		(*in).DeepCopyInto(*out)
	}
	if in.TopologyHints != nil {
		in, out := &in.TopologyHints, &out.TopologyHints
		*out = new(TopologyHints)
		(*in).DeepCopyInto(*out)
	}
	if in.VSOCKCID != nil {
		in, out := &in.VSOCKCID, &out.VSOCKCID
		*out = new(uint32)
		**out = **in
	}
	if in.Machine != nil {
		in, out := &in.Machine, &out.Machine
		*out = new(Machine)
		**out = **in
	}
	if in.CurrentCPUTopology != nil {
		in, out := &in.CurrentCPUTopology, &out.CurrentCPUTopology
		*out = new(CPUTopology)
		**out = **in
	}
	if in.Memory != nil {
		in, out := &in.Memory, &out.Memory
		*out = new(MemoryStatus)
		(*in).DeepCopyInto(*out)
	}
	if in.MigratedVolumes != nil {
		in, out := &in.MigratedVolumes, &out.MigratedVolumes
		*out = make([]StorageMigratedVolumeInfo, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceStatus.
func (in *VirtualMachineInstanceStatus) DeepCopy() *VirtualMachineInstanceStatus {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineInstanceTemplateSpec) DeepCopyInto(out *VirtualMachineInstanceTemplateSpec) {
	*out = *in
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineInstanceTemplateSpec.
func (in *VirtualMachineInstanceTemplateSpec) DeepCopy() *VirtualMachineInstanceTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineInstanceTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineList) DeepCopyInto(out *VirtualMachineList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]VirtualMachine, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineList.
func (in *VirtualMachineList) DeepCopy() *VirtualMachineList {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *VirtualMachineList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineMemoryDumpRequest) DeepCopyInto(out *VirtualMachineMemoryDumpRequest) {
	*out = *in
	if in.StartTimestamp != nil {
		in, out := &in.StartTimestamp, &out.StartTimestamp
		*out = (*in).DeepCopy()
	}
	if in.EndTimestamp != nil {
		in, out := &in.EndTimestamp, &out.EndTimestamp
		*out = (*in).DeepCopy()
	}
	if in.FileName != nil {
		in, out := &in.FileName, &out.FileName
		*out = new(string)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineMemoryDumpRequest.
func (in *VirtualMachineMemoryDumpRequest) DeepCopy() *VirtualMachineMemoryDumpRequest {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineMemoryDumpRequest)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineOptions) DeepCopyInto(out *VirtualMachineOptions) {
	*out = *in
	if in.DisableFreePageReporting != nil {
		in, out := &in.DisableFreePageReporting, &out.DisableFreePageReporting
		*out = new(DisableFreePageReporting)
		**out = **in
	}
	if in.DisableSerialConsoleLog != nil {
		in, out := &in.DisableSerialConsoleLog, &out.DisableSerialConsoleLog
		*out = new(DisableSerialConsoleLog)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineOptions.
func (in *VirtualMachineOptions) DeepCopy() *VirtualMachineOptions {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineOptions)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineSpec) DeepCopyInto(out *VirtualMachineSpec) {
	*out = *in
	if in.Running != nil {
		in, out := &in.Running, &out.Running
		*out = new(bool)
		**out = **in
	}
	if in.RunStrategy != nil {
		in, out := &in.RunStrategy, &out.RunStrategy
		*out = new(VirtualMachineRunStrategy)
		**out = **in
	}
	if in.Instancetype != nil {
		in, out := &in.Instancetype, &out.Instancetype
		*out = new(InstancetypeMatcher)
		(*in).DeepCopyInto(*out)
	}
	if in.Preference != nil {
		in, out := &in.Preference, &out.Preference
		*out = new(PreferenceMatcher)
		(*in).DeepCopyInto(*out)
	}
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(VirtualMachineInstanceTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.DataVolumeTemplates != nil {
		in, out := &in.DataVolumeTemplates, &out.DataVolumeTemplates
		*out = make([]DataVolumeTemplateSpec, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.UpdateVolumesStrategy != nil {
		in, out := &in.UpdateVolumesStrategy, &out.UpdateVolumesStrategy
		*out = new(UpdateVolumesStrategy)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineSpec.
func (in *VirtualMachineSpec) DeepCopy() *VirtualMachineSpec {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineStartFailure) DeepCopyInto(out *VirtualMachineStartFailure) {
	*out = *in
	if in.RetryAfterTimestamp != nil {
		in, out := &in.RetryAfterTimestamp, &out.RetryAfterTimestamp
		*out = (*in).DeepCopy()
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineStartFailure.
func (in *VirtualMachineStartFailure) DeepCopy() *VirtualMachineStartFailure {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineStartFailure)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineStateChangeRequest) DeepCopyInto(out *VirtualMachineStateChangeRequest) {
	*out = *in
	if in.Data != nil {
		in, out := &in.Data, &out.Data
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.UID != nil {
		in, out := &in.UID, &out.UID
		*out = new(types.UID)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineStateChangeRequest.
func (in *VirtualMachineStateChangeRequest) DeepCopy() *VirtualMachineStateChangeRequest {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineStateChangeRequest)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineStatus) DeepCopyInto(out *VirtualMachineStatus) {
	*out = *in
	if in.SnapshotInProgress != nil {
		in, out := &in.SnapshotInProgress, &out.SnapshotInProgress
		*out = new(string)
		**out = **in
	}
	if in.RestoreInProgress != nil {
		in, out := &in.RestoreInProgress, &out.RestoreInProgress
		*out = new(string)
		**out = **in
	}
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]VirtualMachineCondition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.StateChangeRequests != nil {
		in, out := &in.StateChangeRequests, &out.StateChangeRequests
		*out = make([]VirtualMachineStateChangeRequest, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.VolumeRequests != nil {
		in, out := &in.VolumeRequests, &out.VolumeRequests
		*out = make([]VirtualMachineVolumeRequest, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.VolumeSnapshotStatuses != nil {
		in, out := &in.VolumeSnapshotStatuses, &out.VolumeSnapshotStatuses
		*out = make([]VolumeSnapshotStatus, len(*in))
		copy(*out, *in)
	}
	if in.StartFailure != nil {
		in, out := &in.StartFailure, &out.StartFailure
		*out = new(VirtualMachineStartFailure)
		(*in).DeepCopyInto(*out)
	}
	if in.MemoryDumpRequest != nil {
		in, out := &in.MemoryDumpRequest, &out.MemoryDumpRequest
		*out = new(VirtualMachineMemoryDumpRequest)
		(*in).DeepCopyInto(*out)
	}
	if in.VolumeUpdateState != nil {
		in, out := &in.VolumeUpdateState, &out.VolumeUpdateState
		*out = new(VolumeUpdateState)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineStatus.
func (in *VirtualMachineStatus) DeepCopy() *VirtualMachineStatus {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualMachineVolumeRequest) DeepCopyInto(out *VirtualMachineVolumeRequest) {
	*out = *in
	if in.AddVolumeOptions != nil {
		in, out := &in.AddVolumeOptions, &out.AddVolumeOptions
		*out = new(AddVolumeOptions)
		(*in).DeepCopyInto(*out)
	}
	if in.RemoveVolumeOptions != nil {
		in, out := &in.RemoveVolumeOptions, &out.RemoveVolumeOptions
		*out = new(RemoveVolumeOptions)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualMachineVolumeRequest.
func (in *VirtualMachineVolumeRequest) DeepCopy() *VirtualMachineVolumeRequest {
	if in == nil {
		return nil
	}
	out := new(VirtualMachineVolumeRequest)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Volume) DeepCopyInto(out *Volume) {
	*out = *in
	in.VolumeSource.DeepCopyInto(&out.VolumeSource)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Volume.
func (in *Volume) DeepCopy() *Volume {
	if in == nil {
		return nil
	}
	out := new(Volume)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VolumeMigrationState) DeepCopyInto(out *VolumeMigrationState) {
	*out = *in
	if in.MigratedVolumes != nil {
		in, out := &in.MigratedVolumes, &out.MigratedVolumes
		*out = make([]StorageMigratedVolumeInfo, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VolumeMigrationState.
func (in *VolumeMigrationState) DeepCopy() *VolumeMigrationState {
	if in == nil {
		return nil
	}
	out := new(VolumeMigrationState)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VolumeSnapshotStatus) DeepCopyInto(out *VolumeSnapshotStatus) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VolumeSnapshotStatus.
func (in *VolumeSnapshotStatus) DeepCopy() *VolumeSnapshotStatus {
	if in == nil {
		return nil
	}
	out := new(VolumeSnapshotStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VolumeSource) DeepCopyInto(out *VolumeSource) {
	*out = *in
	if in.HostDisk != nil {
		in, out := &in.HostDisk, &out.HostDisk
		*out = new(HostDisk)
		(*in).DeepCopyInto(*out)
	}
	if in.PersistentVolumeClaim != nil {
		in, out := &in.PersistentVolumeClaim, &out.PersistentVolumeClaim
		*out = new(PersistentVolumeClaimVolumeSource)
		**out = **in
	}
	if in.CloudInitNoCloud != nil {
		in, out := &in.CloudInitNoCloud, &out.CloudInitNoCloud
		*out = new(CloudInitNoCloudSource)
		(*in).DeepCopyInto(*out)
	}
	if in.CloudInitConfigDrive != nil {
		in, out := &in.CloudInitConfigDrive, &out.CloudInitConfigDrive
		*out = new(CloudInitConfigDriveSource)
		(*in).DeepCopyInto(*out)
	}
	if in.Sysprep != nil {
		in, out := &in.Sysprep, &out.Sysprep
		*out = new(SysprepSource)
		(*in).DeepCopyInto(*out)
	}
	if in.ContainerDisk != nil {
		in, out := &in.ContainerDisk, &out.ContainerDisk
		*out = new(ContainerDiskSource)
		**out = **in
	}
	if in.Ephemeral != nil {
		in, out := &in.Ephemeral, &out.Ephemeral
		*out = new(EphemeralVolumeSource)
		(*in).DeepCopyInto(*out)
	}
	if in.EmptyDisk != nil {
		in, out := &in.EmptyDisk, &out.EmptyDisk
		*out = new(EmptyDiskSource)
		(*in).DeepCopyInto(*out)
	}
	if in.DataVolume != nil {
		in, out := &in.DataVolume, &out.DataVolume
		*out = new(DataVolumeSource)
		**out = **in
	}
	if in.ConfigMap != nil {
		in, out := &in.ConfigMap, &out.ConfigMap
		*out = new(ConfigMapVolumeSource)
		(*in).DeepCopyInto(*out)
	}
	if in.Secret != nil {
		in, out := &in.Secret, &out.Secret
		*out = new(SecretVolumeSource)
		(*in).DeepCopyInto(*out)
	}
	if in.DownwardAPI != nil {
		in, out := &in.DownwardAPI, &out.DownwardAPI
		*out = new(DownwardAPIVolumeSource)
		(*in).DeepCopyInto(*out)
	}
	if in.ServiceAccount != nil {
		in, out := &in.ServiceAccount, &out.ServiceAccount
		*out = new(ServiceAccountVolumeSource)
		**out = **in
	}
	if in.DownwardMetrics != nil {
		in, out := &in.DownwardMetrics, &out.DownwardMetrics
		*out = new(DownwardMetricsVolumeSource)
		**out = **in
	}
	if in.MemoryDump != nil {
		in, out := &in.MemoryDump, &out.MemoryDump
		*out = new(MemoryDumpVolumeSource)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VolumeSource.
func (in *VolumeSource) DeepCopy() *VolumeSource {
	if in == nil {
		return nil
	}
	out := new(VolumeSource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VolumeStatus) DeepCopyInto(out *VolumeStatus) {
	*out = *in
	if in.PersistentVolumeClaimInfo != nil {
		in, out := &in.PersistentVolumeClaimInfo, &out.PersistentVolumeClaimInfo
		*out = new(PersistentVolumeClaimInfo)
		(*in).DeepCopyInto(*out)
	}
	if in.HotplugVolume != nil {
		in, out := &in.HotplugVolume, &out.HotplugVolume
		*out = new(HotplugVolumeStatus)
		**out = **in
	}
	if in.MemoryDumpVolume != nil {
		in, out := &in.MemoryDumpVolume, &out.MemoryDumpVolume
		*out = new(DomainMemoryDumpInfo)
		(*in).DeepCopyInto(*out)
	}
	if in.ContainerDiskVolume != nil {
		in, out := &in.ContainerDiskVolume, &out.ContainerDiskVolume
		*out = new(ContainerDiskInfo)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VolumeStatus.
func (in *VolumeStatus) DeepCopy() *VolumeStatus {
	if in == nil {
		return nil
	}
	out := new(VolumeStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VolumeUpdateState) DeepCopyInto(out *VolumeUpdateState) {
	*out = *in
	if in.VolumeMigrationState != nil {
		in, out := &in.VolumeMigrationState, &out.VolumeMigrationState
		*out = new(VolumeMigrationState)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VolumeUpdateState.
func (in *VolumeUpdateState) DeepCopy() *VolumeUpdateState {
	if in == nil {
		return nil
	}
	out := new(VolumeUpdateState)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Watchdog) DeepCopyInto(out *Watchdog) {
	*out = *in
	in.WatchdogDevice.DeepCopyInto(&out.WatchdogDevice)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Watchdog.
func (in *Watchdog) DeepCopy() *Watchdog {
	if in == nil {
		return nil
	}
	out := new(Watchdog)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WatchdogDevice) DeepCopyInto(out *WatchdogDevice) {
	*out = *in
	if in.I6300ESB != nil {
		in, out := &in.I6300ESB, &out.I6300ESB
		*out = new(I6300ESBWatchdog)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WatchdogDevice.
func (in *WatchdogDevice) DeepCopy() *WatchdogDevice {
	if in == nil {
		return nil
	}
	out := new(WatchdogDevice)
	in.DeepCopyInto(out)
	return out
}
