// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License").
// You may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package authregister

import (
	"context"
	"testing"

	"github.com/aws/amazon-ssm-agent/agent/ssm/authregister/mocks"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/ssm"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/mock"
)

func TestSdkService_RegisterManagedInstance(t *testing.T) {
	sdk := &mocks.ISsmSdk{}
	response := &ssm.RegisterManagedInstanceOutput{
		InstanceId: aws.String("SomeInstanceId"),
	}
	sdk.On("RegisterManagedInstanceWithContext", mock.Anything, mock.Anything).Return(response, nil)
	authTokenService := &Client{
		sdk: sdk,
	}

	result, err := authTokenService.RegisterManagedInstanceWithContext(context.Background(), "SomePublicKey", "SomePublicKeyType", "SomeFingerprint", "someIamRole", "")
	assert.NoError(t, err)
	assert.Equal(t, *response.InstanceId, result)
}
