// Copyright 2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may not
// use this file except in compliance with the License. A copy of the
// License is located at
//
// http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
// either express or implied. See the License for the specific language governing
// permissions and limitations under the License.

// Package mocks represents the mock for interface CliCommand in cliutil package.
package mocks

import (
	mock "github.com/stretchr/testify/mock"
)

// CliCommand is an autogenerated mock type for the CliCommand type
type CliCommand struct {
	mock.Mock
}

// Execute provides a mock function with given fields: subcommands, parameters
func (_m *CliCommand) Execute(subcommands []string, parameters map[string][]string) (error, string) {
	ret := _m.Called(subcommands, parameters)

	var r0 error
	if rf, ok := ret.Get(0).(func([]string, map[string][]string) error); ok {
		r0 = rf(subcommands, parameters)
	} else {
		r0 = ret.Error(0)
	}

	var r1 string
	if rf, ok := ret.Get(1).(func([]string, map[string][]string) string); ok {
		r1 = rf(subcommands, parameters)
	} else {
		r1 = ret.Get(1).(string)
	}

	return r0, r1
}

// Help provides a mock function with given fields:
func (_m *CliCommand) Help() string {
	ret := _m.Called()

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// Name provides a mock function with given fields:
func (_m *CliCommand) Name() string {
	ret := _m.Called()

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}
