# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import functools
from typing import Any, AsyncIterable, Callable, Dict, Generic, Optional, TypeVar, Union
import warnings

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._blob_containers_operations import build_clear_legal_hold_request, build_create_or_update_immutability_policy_request, build_create_request, build_delete_immutability_policy_request, build_delete_request, build_extend_immutability_policy_request, build_get_immutability_policy_request, build_get_request, build_lease_request, build_list_request, build_lock_immutability_policy_request, build_set_legal_hold_request, build_update_request
T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class BlobContainersOperations:
    """BlobContainersOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.storage.v2019_04_01.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace
    def list(
        self,
        resource_group_name: str,
        account_name: str,
        skip_token: Optional[str] = None,
        maxpagesize: Optional[str] = None,
        filter: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.ListContainerItems"]:
        """Lists all containers and does not support a prefix like data plane. Also SRP today does not
        return continuation token.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only.
        :type account_name: str
        :param skip_token: Optional. Continuation token for the list operation.
        :type skip_token: str
        :param maxpagesize: Optional. Specified maximum number of containers that can be included in
         the list.
        :type maxpagesize: str
        :param filter: Optional. When specified, only container names starting with the filter will be
         listed.
        :type filter: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ListContainerItems or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.storage.v2019_04_01.models.ListContainerItems]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ListContainerItems"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_request(
                    resource_group_name=resource_group_name,
                    account_name=account_name,
                    subscription_id=self._config.subscription_id,
                    skip_token=skip_token,
                    maxpagesize=maxpagesize,
                    filter=filter,
                    template_url=self.list.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_request(
                    resource_group_name=resource_group_name,
                    account_name=account_name,
                    subscription_id=self._config.subscription_id,
                    skip_token=skip_token,
                    maxpagesize=maxpagesize,
                    filter=filter,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ListContainerItems", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers'}  # type: ignore

    @distributed_trace_async
    async def create(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        blob_container: "_models.BlobContainer",
        **kwargs: Any
    ) -> "_models.BlobContainer":
        """Creates a new container under the specified account as described by request body. The container
        resource includes metadata and properties for that container. It does not include a list of the
        blobs contained by the container.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number.
        :type container_name: str
        :param blob_container: Properties of the blob container to create.
        :type blob_container: ~azure.mgmt.storage.v2019_04_01.models.BlobContainer
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BlobContainer, or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2019_04_01.models.BlobContainer
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.BlobContainer"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(blob_container, 'BlobContainer')

        request = build_create_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            json=_json,
            template_url=self.create.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize('BlobContainer', pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize('BlobContainer', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}'}  # type: ignore


    @distributed_trace_async
    async def update(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        blob_container: "_models.BlobContainer",
        **kwargs: Any
    ) -> "_models.BlobContainer":
        """Updates container properties as specified in request body. Properties not mentioned in the
        request will be unchanged. Update fails if the specified container doesn't already exist.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number.
        :type container_name: str
        :param blob_container: Properties to update for the blob container.
        :type blob_container: ~azure.mgmt.storage.v2019_04_01.models.BlobContainer
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BlobContainer, or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2019_04_01.models.BlobContainer
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.BlobContainer"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(blob_container, 'BlobContainer')

        request = build_update_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            json=_json,
            template_url=self.update.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('BlobContainer', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}'}  # type: ignore


    @distributed_trace_async
    async def get(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        **kwargs: Any
    ) -> "_models.BlobContainer":
        """Gets properties of a specified container.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number.
        :type container_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BlobContainer, or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2019_04_01.models.BlobContainer
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.BlobContainer"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            template_url=self.get.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('BlobContainer', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}'}  # type: ignore


    @distributed_trace_async
    async def delete(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        **kwargs: Any
    ) -> None:
        """Deletes specified container under its account.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number.
        :type container_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_delete_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            template_url=self.delete.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}'}  # type: ignore


    @distributed_trace_async
    async def set_legal_hold(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        legal_hold: "_models.LegalHold",
        **kwargs: Any
    ) -> "_models.LegalHold":
        """Sets legal hold tags. Setting the same tag results in an idempotent operation. SetLegalHold
        follows an append pattern and does not clear out the existing tags that are not specified in
        the request.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number.
        :type container_name: str
        :param legal_hold: The LegalHold property that will be set to a blob container.
        :type legal_hold: ~azure.mgmt.storage.v2019_04_01.models.LegalHold
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LegalHold, or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2019_04_01.models.LegalHold
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.LegalHold"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(legal_hold, 'LegalHold')

        request = build_set_legal_hold_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            json=_json,
            template_url=self.set_legal_hold.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('LegalHold', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    set_legal_hold.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/setLegalHold'}  # type: ignore


    @distributed_trace_async
    async def clear_legal_hold(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        legal_hold: "_models.LegalHold",
        **kwargs: Any
    ) -> "_models.LegalHold":
        """Clears legal hold tags. Clearing the same or non-existent tag results in an idempotent
        operation. ClearLegalHold clears out only the specified tags in the request.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number.
        :type container_name: str
        :param legal_hold: The LegalHold property that will be clear from a blob container.
        :type legal_hold: ~azure.mgmt.storage.v2019_04_01.models.LegalHold
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LegalHold, or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2019_04_01.models.LegalHold
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.LegalHold"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(legal_hold, 'LegalHold')

        request = build_clear_legal_hold_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            json=_json,
            template_url=self.clear_legal_hold.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('LegalHold', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    clear_legal_hold.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/clearLegalHold'}  # type: ignore


    @distributed_trace_async
    async def create_or_update_immutability_policy(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        if_match: Optional[str] = None,
        parameters: Optional["_models.ImmutabilityPolicy"] = None,
        **kwargs: Any
    ) -> "_models.ImmutabilityPolicy":
        """Creates or updates an unlocked immutability policy. ETag in If-Match is honored if given but
        not required for this operation.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update. A value
         of "*" can be used to apply the operation only if the immutability policy already exists. If
         omitted, this operation will always be applied.
        :type if_match: str
        :param parameters: The ImmutabilityPolicy Properties that will be created or updated to a blob
         container.
        :type parameters: ~azure.mgmt.storage.v2019_04_01.models.ImmutabilityPolicy
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ImmutabilityPolicy, or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2019_04_01.models.ImmutabilityPolicy
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ImmutabilityPolicy"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        if parameters is not None:
            _json = self._serialize.body(parameters, 'ImmutabilityPolicy')
        else:
            _json = None

        request = build_create_or_update_immutability_policy_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            json=_json,
            if_match=if_match,
            template_url=self.create_or_update_immutability_policy.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))

        deserialized = self._deserialize('ImmutabilityPolicy', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    create_or_update_immutability_policy.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/{immutabilityPolicyName}'}  # type: ignore


    @distributed_trace_async
    async def get_immutability_policy(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        if_match: Optional[str] = None,
        **kwargs: Any
    ) -> "_models.ImmutabilityPolicy":
        """Gets the existing immutability policy along with the corresponding ETag in response headers and
        body.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update. A value
         of "*" can be used to apply the operation only if the immutability policy already exists. If
         omitted, this operation will always be applied.
        :type if_match: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ImmutabilityPolicy, or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2019_04_01.models.ImmutabilityPolicy
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ImmutabilityPolicy"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_immutability_policy_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            if_match=if_match,
            template_url=self.get_immutability_policy.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))

        deserialized = self._deserialize('ImmutabilityPolicy', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    get_immutability_policy.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/{immutabilityPolicyName}'}  # type: ignore


    @distributed_trace_async
    async def delete_immutability_policy(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        if_match: str,
        **kwargs: Any
    ) -> "_models.ImmutabilityPolicy":
        """Aborts an unlocked immutability policy. The response of delete has
        immutabilityPeriodSinceCreationInDays set to 0. ETag in If-Match is required for this
        operation. Deleting a locked immutability policy is not allowed, only way is to delete the
        container after deleting all blobs inside the container.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update. A value
         of "*" can be used to apply the operation only if the immutability policy already exists. If
         omitted, this operation will always be applied.
        :type if_match: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ImmutabilityPolicy, or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2019_04_01.models.ImmutabilityPolicy
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ImmutabilityPolicy"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_delete_immutability_policy_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            if_match=if_match,
            template_url=self.delete_immutability_policy.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))

        deserialized = self._deserialize('ImmutabilityPolicy', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    delete_immutability_policy.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/{immutabilityPolicyName}'}  # type: ignore


    @distributed_trace_async
    async def lock_immutability_policy(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        if_match: str,
        **kwargs: Any
    ) -> "_models.ImmutabilityPolicy":
        """Sets the ImmutabilityPolicy to Locked state. The only action allowed on a Locked policy is
        ExtendImmutabilityPolicy action. ETag in If-Match is required for this operation.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update. A value
         of "*" can be used to apply the operation only if the immutability policy already exists. If
         omitted, this operation will always be applied.
        :type if_match: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ImmutabilityPolicy, or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2019_04_01.models.ImmutabilityPolicy
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ImmutabilityPolicy"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_lock_immutability_policy_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            if_match=if_match,
            template_url=self.lock_immutability_policy.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))

        deserialized = self._deserialize('ImmutabilityPolicy', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    lock_immutability_policy.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/default/lock'}  # type: ignore


    @distributed_trace_async
    async def extend_immutability_policy(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        if_match: str,
        parameters: Optional["_models.ImmutabilityPolicy"] = None,
        **kwargs: Any
    ) -> "_models.ImmutabilityPolicy":
        """Extends the immutabilityPeriodSinceCreationInDays of a locked immutabilityPolicy. The only
        action allowed on a Locked policy will be this action. ETag in If-Match is required for this
        operation.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update. A value
         of "*" can be used to apply the operation only if the immutability policy already exists. If
         omitted, this operation will always be applied.
        :type if_match: str
        :param parameters: The ImmutabilityPolicy Properties that will be extended for a blob
         container.
        :type parameters: ~azure.mgmt.storage.v2019_04_01.models.ImmutabilityPolicy
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ImmutabilityPolicy, or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2019_04_01.models.ImmutabilityPolicy
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ImmutabilityPolicy"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        if parameters is not None:
            _json = self._serialize.body(parameters, 'ImmutabilityPolicy')
        else:
            _json = None

        request = build_extend_immutability_policy_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            if_match=if_match,
            json=_json,
            template_url=self.extend_immutability_policy.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))

        deserialized = self._deserialize('ImmutabilityPolicy', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    extend_immutability_policy.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/default/extend'}  # type: ignore


    @distributed_trace_async
    async def lease(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        parameters: Optional["_models.LeaseContainerRequest"] = None,
        **kwargs: Any
    ) -> "_models.LeaseContainerResponse":
        """The Lease Container operation establishes and manages a lock on a container for delete
        operations. The lock duration can be 15 to 60 seconds, or can be infinite.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number.
        :type container_name: str
        :param parameters: Lease Container request body.
        :type parameters: ~azure.mgmt.storage.v2019_04_01.models.LeaseContainerRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LeaseContainerResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2019_04_01.models.LeaseContainerResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.LeaseContainerResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        if parameters is not None:
            _json = self._serialize.body(parameters, 'LeaseContainerRequest')
        else:
            _json = None

        request = build_lease_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            json=_json,
            template_url=self.lease.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('LeaseContainerResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    lease.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/lease'}  # type: ignore

