#!/usr/bin/perl

# Title:       Kernel Security Announcement SUSE-SU-2012:0153-1
# Description: An update that solves 10 vulnerabilities and has 29 fixes
# Modified:    2013 Jun 25

##############################################################################
#  Copyright (C) 2013 SUSE LLC
##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; version 2 of the License.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, see <http://www.gnu.org/licenses/>.

#  Authors/Contributors:
#   Jason Record (jrecord@suse.com)

##############################################################################

##############################################################################
# Module Definition
##############################################################################

use strict;
use warnings;
use SDP::Core;
use SDP::SUSE;

##############################################################################
# Overriden (eventually or in part) from SDP::Core Module
##############################################################################

@PATTERN_RESULTS = (
	PROPERTY_NAME_CLASS."=Security",
	PROPERTY_NAME_CATEGORY."=SLE",
	PROPERTY_NAME_COMPONENT."=Kernel",
	PROPERTY_NAME_PATTERN_ID."=$PATTERN_ID",
	PROPERTY_NAME_PRIMARY_LINK."=META_LINK_Security",
	PROPERTY_NAME_OVERALL."=$GSTATUS",
	PROPERTY_NAME_OVERALL_INFO."=None",
	"META_LINK_Security=http://lists.opensuse.org/opensuse-security-announce/2012-02/msg00000.html"
);

##############################################################################
# Main Program Execution
##############################################################################

SDP::Core::processOptions();
	my $SEVERITY = 'Important';
	my $ANNOUNCE_ID = 'SUSE-SU-2012:0153-1';

	if ( SDP::SUSE::securitySeverityKernelAnnouncement(SLE11SP1, SLE11SP2, '2.6.32.54-0.3', $SEVERITY, $ANNOUNCE_ID) ) {
		SDP::Core::updateStatus(STATUS_ERROR, "ABORTED: Kernel Security Annoucement $ANNOUNCE_ID: Outside the kernel scope");
	}
SDP::Core::printPatternResults();

exit;

