<div align="center">
  <img src="assets/bithesis_icon.svg" alt="BIThesis Icon">

📖 _Unofficial LaTeX templates for your bachelor graduation thesis (and maybe more)._

[![BIThesis](./assets/bithesis_badge_solid.svg)](https://bithesis.bitnp.net/)
[![Chinese version](./assets/chinese.svg)](./README-zh.md)
[![Latexmk](https://badgen.net/badge/compiler/Latexmk?color=blue&labelColor=2b2b2b)](https://mg.readthedocs.io/latexmk.html)
[![License](https://badgen.net/github/license/BITNP/BIThesis?color=008080&labelColor=2b2b2b)](./LICENSE)
[![Join on Slack](https://img.shields.io/badge/Slack%20Community-BIThesis-black?logo=slack&style=social&logoColor=2eb67d)](https://join.slack.com/t/bithesis/shared_invite/zt-epmzkyk0-fJRsUS36AlwMNB2AI_Q~Vw)

</div>

<h2>Welcome</h2>

BIThesis is an unofficial LaTeX template set for your **bachelor graduation thesis** and corresponding reports here at BIT. Hand-crafted following the specifications made by the _[Dept. of Undergraduate Academic Affairs](http://jwc.bit.edu.cn/)_ of _[Beijing Institute of Technology](http://http://www.bit.edu.cn/)_.

> This project is supported by the _[Dept. of Undergraduate Academic Affairs, BIT](http://jwc.bit.edu.cn/)_ and the _[School of Computer Science and Technology, BIT](http://cs.bit.edu.cn/)_. See [Acknowledgements - Official Sponsors](https://bithesis.bitnp.net/Guide/5-Acknowledgements/Acknowledgements.html#%E5%AE%98%E6%96%B9%E8%B5%9E%E5%8A%A9-official-sponsors).

<h2>Slack Community</h2>

> Subscribe to new releases, ask questions, request features, etc. Come join our official community on Slack!

[![Join on Slack](./assets/slack.svg)](https://join.slack.com/t/bithesis/shared_invite/zt-epmzkyk0-fJRsUS36AlwMNB2AI_Q~Vw)

<h2>Table of Contents</h2>

- [How do I use BIThesis?](#how-do-i-use-bithesis)
  - [Detailed online Wiki](#detailed-online-wiki)
  - [PDF handbook](#pdf-handbook)
  - [Online Video Tutorials](#online-video-tutorials)
- [Contributing](#contributing)
- [Contributors](#contributors)
- [Similar Projects](#similar-projects)
- [Release status](#release-status)

## How do I use BIThesis?

### Detailed online Wiki

**For a comprehensive guide on how to install LaTeX, compile BIThesis, and use a single one of BIThesis' template, please refer to BIThesis' Wiki. 👇**

[![BIThesis Wiki](https://img.shields.io/badge/BIThesis-Wiki-009944?logo=wikipedia&labelColor=2b2b2b&style=for-the-badge)](https://bithesis.bitnp.net/)

Specifically, detailed guides on how to use a single one of the templates are available at:

- [BIThesis Wiki: Proposal report](https://bithesis.bitnp.net/Guide/3-Templates/Proposal-Report.html)
- [BIThesis Wiki: Graduation thesis](https://bithesis.bitnp.net/Guide/3-Templates/Final-Graduation-Thesis.html)
- [BIThesis Wiki: Lab report](https://bithesis.bitnp.net/Guide/3-Templates/Lab-Report.html)

### PDF handbook

We also provide a PDF handbook on how to use BIThesis. You can download the PDF version of the BIThesis handbook here: [`bithesis-documentation.pdf`](https://github.com/BITNP/BIThesis/releases/latest).

### Online Video Tutorials

You can watch online video tutorials here:

- Bilibili: [BIThesis —— 教你优雅地撰写论文 | LaTeX 毕设模板系列教程](https://www.bilibili.com/video/BV1GT4y1V78d/)
- BIThesis documentation videos (including some code which are referenced in the videos): [BIThesis - Videos](https://bithesis.bitnp.net/Video/)

## Contributing

For details, please see the [contributing doc](./contributing.md).

## Contributors

For more information, please see: [Github Contributors](https://github.com/BITNP/BIThesis/graphs/contributors) and [Acknowledgements](https://bithesis.bitnp.net/Guide/5-Acknowledgements/Acknowledgements.html).

## Similar Projects

- [北京理工大学硕士（博士）学位论文 LaTeX 模板](https://github.com/BIT-thesis/LaTeX-template)
- [fduthesis（复旦大学论文模板）](https://github.com/stone-zeng/fduthesis)
- [上海交通大学 XeLaTeX 学位论文及课程论文模板](https://github.com/sjtug/SJTUThesis)
- ……

## Release status

| CI             | Build status                                                                                                                                                                              |
| :------------- | :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| GitHub Release | ![GitHub Release](https://github.com/BITNP/BIThesis/workflows/Release/badge.svg?branch=master)                                                                                      |
| Netlify Deploy | [![Netlify Status](https://api.netlify.com/api/v1/badges/81f7b49b-59a1-46bc-ba52-02f8be71d247/deploy-status)](https://app.netlify.com/sites/vigorous-hoover-a697eb/deploys)               |


---

📖 **BIThesis** ©Spencer Woo. Released under the [LaTeX Project Public License](LICENSE).

Authored by Spencer Woo. Maintained with help from [contributors](https://github.com/BITNP/BIThesis/graphs/contributors).
