/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import java.math.BigDecimal;
import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;

public class DecimalValidator
implements TypeValidator {
    private BigDecimal _fixed = null;
    private BigDecimal _min = null;
    private BigDecimal _max = null;
    private int _totalDigits = -1;
    private int _fractionDigits = -1;
    private boolean _hasMinExclusive = false;
    private boolean _hasMaxExclusive = false;

    public void clearMax() {
        this._max = null;
        this._hasMaxExclusive = false;
    }

    public void clearMin() {
        this._min = null;
        this._hasMinExclusive = false;
    }

    public BigDecimal getFixed() {
        return this._fixed;
    }

    public BigDecimal getMaxInclusive() {
        return this._max;
    }

    public BigDecimal getMinInclusive() {
        return this._min;
    }

    public boolean hasFixed() {
        return this._fixed != null;
    }

    public void setMinExclusive(BigDecimal minValue) {
        if (minValue == null) {
            throw new IllegalArgumentException("argument 'minValue' must not be null.");
        }
        this._min = minValue;
        this._hasMinExclusive = true;
    }

    public void setMinInclusive(BigDecimal minValue) {
        this._min = minValue;
        this._hasMinExclusive = false;
    }

    public void setMaxExclusive(BigDecimal maxValue) {
        if (maxValue == null) {
            throw new IllegalArgumentException("argument 'maxValue' must not be null.");
        }
        this._max = maxValue;
        this._hasMaxExclusive = true;
    }

    public void setMaxInclusive(BigDecimal maxValue) {
        this._max = maxValue;
        this._hasMaxExclusive = false;
    }

    public void setTotalDigits(int totalDig) {
        if (totalDig <= 0) {
            throw new IllegalArgumentException("DecimalValidator: the totalDigits facet must be positive");
        }
        this._totalDigits = totalDig;
    }

    public void setFractionDigits(int fractionDig) {
        if (fractionDig < 0) {
            throw new IllegalArgumentException("DecimalValidator: the fractionDigits facet must be positive");
        }
        this._fractionDigits = fractionDig;
    }

    public void setFixed(BigDecimal fixed) {
        this._fixed = fixed;
    }

    public void validate(BigDecimal bd) throws ValidationException {
        if (this._fixed != null && !bd.equals(this._fixed)) {
            String err = bd + " is not equal to the fixed value of ";
            err = err + this._fixed;
            throw new ValidationException(err);
        }
        if (this._min != null) {
            if (bd.compareTo(this._min) == -1) {
                String err = bd + " is less than the minimum allowable ";
                err = err + "value of " + this._min;
                throw new ValidationException(err);
            }
            if (bd.compareTo(this._min) == 0 && this._hasMinExclusive) {
                String err = bd + " cannot be equal to the minimum allowable ";
                err = err + "value of " + this._min;
                throw new ValidationException(err);
            }
        }
        if (this._max != null) {
            if (bd.compareTo(this._max) == 1) {
                String err = bd + " is greater than the maximum allowable ";
                err = err + "value of " + this._max;
                throw new ValidationException(err);
            }
            if (bd.compareTo(this._max) == 0 && this._hasMaxExclusive) {
                String err = bd + " cannot be equal to the maximum allowable ";
                err = err + "value of " + this._max;
                throw new ValidationException(err);
            }
        }
        if (this._totalDigits != -1) {
            int length;
            String temp = bd.toString();
            int n = length = temp.indexOf(46) == -1 ? temp.length() : temp.length() - 1;
            if (length > this._totalDigits) {
                String err = bd + " doesn't have the correct number of digits, it must be less than or equal to " + this._totalDigits;
                throw new ValidationException(err);
            }
            temp = null;
        }
        if (this._fractionDigits != -1 && bd.scale() > this._fractionDigits) {
            String err = bd + " doesn't have the correct number of digits in the fraction part: , it must be less than or equal to " + this._fractionDigits;
            throw new ValidationException(err);
        }
    }

    public void validate(Object object) throws ValidationException {
        this.validate(object, null);
    }

    public void validate(Object object, ValidationContext context) throws ValidationException {
        if (object == null) {
            String err = "decimalValidator cannot validate a null object.";
            throw new ValidationException(err);
        }
        BigDecimal value = null;
        try {
            value = new BigDecimal(object.toString());
        }
        catch (Exception ex) {
            String err = "Expecting a decimal, received instead: ";
            err = err + object.getClass().getName();
            throw new ValidationException(err);
        }
        this.validate(value);
    }
}

