/*
 *	sysctl (config file) utilities
 *
 *	Copyright (C) 2011 SUSE LINUX Products GmbH, Nuernberg, Germany.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *	MA  02110-1301  USA
 *
 *	Authors: Marius Tomaschewski <mt@suse.de>
 *
 *	libnetcontrol contains source code which is based on wicked.
 *	Wicked is licensed under the GPL-2.0+, but permission has been
 *	granted by the authors of wicked to use the code derived from
 *	wicked under the LGPL-2.1+ in libnetcontrol.
 *	You can find the wicked project at http://gitorious.org/wicked/.
 *
 */
#ifndef __NETCONTROL_SYSCTL_H
#define __NETCONTROL_SYSCTL_H
#if defined(HAVE_CONFIG_H)
#include <config.h>
#endif

#include <sutils.h>

/*
 * In default sysctl format, a '.' in the interface name has to be
 * rewritten into '/', e.g.: "net.ipv6.conf.br0/42.forwarding".
 * There is an alternative format allowing a normal interface name:
 * "net/ipv6/conf/br0.42/forwarding".
 *
 * This functions accepts both formats, so you don't need to rewrite
 * interface names to use a slash instead of a dot.
 *
 */

/*
 * Loads sysctl settings from file and adds them to a var array.
 * Array is not cleared, so it can be used with multiple files.
 */
int		nc_sysctl_load(nc_var_array_t *vars, const char *filename);

/*
 * A nc_var_array_get variant allowing to use a printf format
 * to construct the sysctl attribute path.
 */
const nc_var_t *nc_sysctl_get_fmt(const nc_var_array_t *vars, const char *fmt, ...);

/*
 * A nc_var_array_set variant allowing to use a printf format
 * to construct the sysctl attribute path.
 */
int		nc_sysctl_set_fmt(nc_var_array_t *vars, const char *value,
		                                        const char *fmt, ...);

/*
 * This utility function rewrites a string to use alternative "slash"
 * format, e.g.: "net/ipv6/conf/br0.42/forwarding".
 */
void		nc_sysctl_rewrite_to_slash(char *variable);

/*
 * This utility function rewrites a string to use the default "dot"
 * format, e.g.: "net.ipv6.conf.br0/42.forwarding".
 */
void		nc_sysctl_rewrite_to_dot(char *variable);

#endif /* __NETCONTROL_SYSCTL_H */
