/*
 * Copyright 2010-2016 Amazon.com, Inc. or its affiliates. All Rights
 * Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.ec2.model;

import java.io.Serializable;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.transform.DescribeAccountAttributesRequestMarshaller;

/**
 * <p>
 * Contains the parameters for DescribeAccountAttributes.
 * </p>
 */
public class DescribeAccountAttributesRequest extends AmazonWebServiceRequest
        implements Serializable, Cloneable,
        DryRunSupportedRequest<DescribeAccountAttributesRequest> {

    /**
     * <p>
     * One or more account attribute names.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<String> attributeNames;

    /**
     * <p>
     * One or more account attribute names.
     * </p>
     * 
     * @return One or more account attribute names.
     * @see AccountAttributeName
     */

    public java.util.List<String> getAttributeNames() {
        if (attributeNames == null) {
            attributeNames = new com.amazonaws.internal.SdkInternalList<String>();
        }
        return attributeNames;
    }

    /**
     * <p>
     * One or more account attribute names.
     * </p>
     * 
     * @param attributeNames
     *        One or more account attribute names.
     * @see AccountAttributeName
     */

    public void setAttributeNames(java.util.Collection<String> attributeNames) {
        if (attributeNames == null) {
            this.attributeNames = null;
            return;
        }

        this.attributeNames = new com.amazonaws.internal.SdkInternalList<String>(
                attributeNames);
    }

    /**
     * <p>
     * One or more account attribute names.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if
     * any). Use {@link #setAttributeNames(java.util.Collection)} or
     * {@link #withAttributeNames(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param attributeNames
     *        One or more account attribute names.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     * @see AccountAttributeName
     */

    public DescribeAccountAttributesRequest withAttributeNames(
            String... attributeNames) {
        if (this.attributeNames == null) {
            setAttributeNames(new com.amazonaws.internal.SdkInternalList<String>(
                    attributeNames.length));
        }
        for (String ele : attributeNames) {
            this.attributeNames.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * One or more account attribute names.
     * </p>
     * 
     * @param attributeNames
     *        One or more account attribute names.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     * @see AccountAttributeName
     */

    public DescribeAccountAttributesRequest withAttributeNames(
            java.util.Collection<String> attributeNames) {
        setAttributeNames(attributeNames);
        return this;
    }

    /**
     * <p>
     * One or more account attribute names.
     * </p>
     * 
     * @param attributeNames
     *        One or more account attribute names.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     * @see AccountAttributeName
     */

    public DescribeAccountAttributesRequest withAttributeNames(
            AccountAttributeName... attributeNames) {
        com.amazonaws.internal.SdkInternalList<String> attributeNamesCopy = new com.amazonaws.internal.SdkInternalList<String>(
                attributeNames.length);
        for (AccountAttributeName value : attributeNames) {
            attributeNamesCopy.add(value.toString());
        }
        if (getAttributeNames() == null) {
            setAttributeNames(attributeNamesCopy);
        } else {
            getAttributeNames().addAll(attributeNamesCopy);
        }
        return this;
    }

    /**
     * This method is intended for internal use only. Returns the marshaled
     * request configured with additional parameters to enable operation
     * dry-run.
     */
    @Override
    public Request<DescribeAccountAttributesRequest> getDryRunRequest() {
        Request<DescribeAccountAttributesRequest> request = new DescribeAccountAttributesRequestMarshaller()
                .marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAttributeNames() != null)
            sb.append("AttributeNames: " + getAttributeNames());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeAccountAttributesRequest == false)
            return false;
        DescribeAccountAttributesRequest other = (DescribeAccountAttributesRequest) obj;
        if (other.getAttributeNames() == null
                ^ this.getAttributeNames() == null)
            return false;
        if (other.getAttributeNames() != null
                && other.getAttributeNames().equals(this.getAttributeNames()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime
                * hashCode
                + ((getAttributeNames() == null) ? 0 : getAttributeNames()
                        .hashCode());
        return hashCode;
    }

    @Override
    public DescribeAccountAttributesRequest clone() {
        return (DescribeAccountAttributesRequest) super.clone();
    }
}