/*
 * Copyright 2010-2016 Amazon.com, Inc. or its affiliates. All Rights
 * Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.cognitoidp.model;

import java.io.Serializable;
import com.amazonaws.AmazonWebServiceRequest;

/**
 * <p>
 * Represents the request to delete user attributes.
 * </p>
 */
public class DeleteUserAttributesRequest extends AmazonWebServiceRequest
        implements Serializable, Cloneable {

    /**
     * <p>
     * An array of strings representing the user attribute names you wish to
     * delete.
     * </p>
     */
    private java.util.List<String> userAttributeNames;
    /**
     * <p>
     * The access token used in the request to delete user attributes.
     * </p>
     */
    private String accessToken;

    /**
     * <p>
     * An array of strings representing the user attribute names you wish to
     * delete.
     * </p>
     * 
     * @return An array of strings representing the user attribute names you
     *         wish to delete.
     */

    public java.util.List<String> getUserAttributeNames() {
        return userAttributeNames;
    }

    /**
     * <p>
     * An array of strings representing the user attribute names you wish to
     * delete.
     * </p>
     * 
     * @param userAttributeNames
     *        An array of strings representing the user attribute names you wish
     *        to delete.
     */

    public void setUserAttributeNames(
            java.util.Collection<String> userAttributeNames) {
        if (userAttributeNames == null) {
            this.userAttributeNames = null;
            return;
        }

        this.userAttributeNames = new java.util.ArrayList<String>(
                userAttributeNames);
    }

    /**
     * <p>
     * An array of strings representing the user attribute names you wish to
     * delete.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if
     * any). Use {@link #setUserAttributeNames(java.util.Collection)} or
     * {@link #withUserAttributeNames(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param userAttributeNames
     *        An array of strings representing the user attribute names you wish
     *        to delete.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public DeleteUserAttributesRequest withUserAttributeNames(
            String... userAttributeNames) {
        if (this.userAttributeNames == null) {
            setUserAttributeNames(new java.util.ArrayList<String>(
                    userAttributeNames.length));
        }
        for (String ele : userAttributeNames) {
            this.userAttributeNames.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * An array of strings representing the user attribute names you wish to
     * delete.
     * </p>
     * 
     * @param userAttributeNames
     *        An array of strings representing the user attribute names you wish
     *        to delete.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public DeleteUserAttributesRequest withUserAttributeNames(
            java.util.Collection<String> userAttributeNames) {
        setUserAttributeNames(userAttributeNames);
        return this;
    }

    /**
     * <p>
     * The access token used in the request to delete user attributes.
     * </p>
     * 
     * @param accessToken
     *        The access token used in the request to delete user attributes.
     */

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    /**
     * <p>
     * The access token used in the request to delete user attributes.
     * </p>
     * 
     * @return The access token used in the request to delete user attributes.
     */

    public String getAccessToken() {
        return this.accessToken;
    }

    /**
     * <p>
     * The access token used in the request to delete user attributes.
     * </p>
     * 
     * @param accessToken
     *        The access token used in the request to delete user attributes.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public DeleteUserAttributesRequest withAccessToken(String accessToken) {
        setAccessToken(accessToken);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getUserAttributeNames() != null)
            sb.append("UserAttributeNames: " + getUserAttributeNames() + ",");
        if (getAccessToken() != null)
            sb.append("AccessToken: " + getAccessToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DeleteUserAttributesRequest == false)
            return false;
        DeleteUserAttributesRequest other = (DeleteUserAttributesRequest) obj;
        if (other.getUserAttributeNames() == null
                ^ this.getUserAttributeNames() == null)
            return false;
        if (other.getUserAttributeNames() != null
                && other.getUserAttributeNames().equals(
                        this.getUserAttributeNames()) == false)
            return false;
        if (other.getAccessToken() == null ^ this.getAccessToken() == null)
            return false;
        if (other.getAccessToken() != null
                && other.getAccessToken().equals(this.getAccessToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime
                * hashCode
                + ((getUserAttributeNames() == null) ? 0
                        : getUserAttributeNames().hashCode());
        hashCode = prime
                * hashCode
                + ((getAccessToken() == null) ? 0 : getAccessToken().hashCode());
        return hashCode;
    }

    @Override
    public DeleteUserAttributesRequest clone() {
        return (DeleteUserAttributesRequest) super.clone();
    }
}