; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefix=X32
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefix=X64

define <8 x i32> @v8i32_cmpgt(<8 x i32> %i, <8 x i32> %j) nounwind readnone {
; X32-LABEL: v8i32_cmpgt:
; X32:       # %bb.0:
; X32-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: v8i32_cmpgt:
; X64:       # %bb.0:
; X64-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; X64-NEXT:    retq
  %bincmp = icmp slt <8 x i32> %i, %j
  %x = sext <8 x i1> %bincmp to <8 x i32>
  ret <8 x i32> %x
}

define <4 x i64> @v4i64_cmpgt(<4 x i64> %i, <4 x i64> %j) nounwind readnone {
; X32-LABEL: v4i64_cmpgt:
; X32:       # %bb.0:
; X32-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: v4i64_cmpgt:
; X64:       # %bb.0:
; X64-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; X64-NEXT:    retq
  %bincmp = icmp slt <4 x i64> %i, %j
  %x = sext <4 x i1> %bincmp to <4 x i64>
  ret <4 x i64> %x
}

define <16 x i16> @v16i16_cmpgt(<16 x i16> %i, <16 x i16> %j) nounwind readnone {
; X32-LABEL: v16i16_cmpgt:
; X32:       # %bb.0:
; X32-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: v16i16_cmpgt:
; X64:       # %bb.0:
; X64-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; X64-NEXT:    retq
  %bincmp = icmp slt <16 x i16> %i, %j
  %x = sext <16 x i1> %bincmp to <16 x i16>
  ret <16 x i16> %x
}

define <32 x i8> @v32i8_cmpgt(<32 x i8> %i, <32 x i8> %j) nounwind readnone {
; X32-LABEL: v32i8_cmpgt:
; X32:       # %bb.0:
; X32-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: v32i8_cmpgt:
; X64:       # %bb.0:
; X64-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; X64-NEXT:    retq
  %bincmp = icmp slt <32 x i8> %i, %j
  %x = sext <32 x i1> %bincmp to <32 x i8>
  ret <32 x i8> %x
}

define <8 x i32> @int256_cmpeq(<8 x i32> %i, <8 x i32> %j) nounwind readnone {
; X32-LABEL: int256_cmpeq:
; X32:       # %bb.0:
; X32-NEXT:    vpcmpeqd %ymm1, %ymm0, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: int256_cmpeq:
; X64:       # %bb.0:
; X64-NEXT:    vpcmpeqd %ymm1, %ymm0, %ymm0
; X64-NEXT:    retq
  %bincmp = icmp eq <8 x i32> %i, %j
  %x = sext <8 x i1> %bincmp to <8 x i32>
  ret <8 x i32> %x
}

define <4 x i64> @v4i64_cmpeq(<4 x i64> %i, <4 x i64> %j) nounwind readnone {
; X32-LABEL: v4i64_cmpeq:
; X32:       # %bb.0:
; X32-NEXT:    vpcmpeqq %ymm1, %ymm0, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: v4i64_cmpeq:
; X64:       # %bb.0:
; X64-NEXT:    vpcmpeqq %ymm1, %ymm0, %ymm0
; X64-NEXT:    retq
  %bincmp = icmp eq <4 x i64> %i, %j
  %x = sext <4 x i1> %bincmp to <4 x i64>
  ret <4 x i64> %x
}

define <16 x i16> @v16i16_cmpeq(<16 x i16> %i, <16 x i16> %j) nounwind readnone {
; X32-LABEL: v16i16_cmpeq:
; X32:       # %bb.0:
; X32-NEXT:    vpcmpeqw %ymm1, %ymm0, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: v16i16_cmpeq:
; X64:       # %bb.0:
; X64-NEXT:    vpcmpeqw %ymm1, %ymm0, %ymm0
; X64-NEXT:    retq
  %bincmp = icmp eq <16 x i16> %i, %j
  %x = sext <16 x i1> %bincmp to <16 x i16>
  ret <16 x i16> %x
}

define <32 x i8> @v32i8_cmpeq(<32 x i8> %i, <32 x i8> %j) nounwind readnone {
; X32-LABEL: v32i8_cmpeq:
; X32:       # %bb.0:
; X32-NEXT:    vpcmpeqb %ymm1, %ymm0, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: v32i8_cmpeq:
; X64:       # %bb.0:
; X64-NEXT:    vpcmpeqb %ymm1, %ymm0, %ymm0
; X64-NEXT:    retq
  %bincmp = icmp eq <32 x i8> %i, %j
  %x = sext <32 x i1> %bincmp to <32 x i8>
  ret <32 x i8> %x
}
