# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING

from azure.core.pipeline.transport import AsyncHttpResponse, HttpRequest
from azure.mgmt.core import AsyncARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential

from ._configuration import AzureArcVMwareManagementServiceAPIConfiguration
from .operations import Operations
from .operations import ResourcePoolsOperations
from .operations import ClustersOperations
from .operations import HostsOperations
from .operations import DatastoresOperations
from .operations import VCentersOperations
from .operations import VirtualMachinesOperations
from .operations import VirtualMachineTemplatesOperations
from .operations import VirtualNetworksOperations
from .operations import InventoryItemsOperations
from .operations import HybridIdentityMetadataOperations
from .operations import MachineExtensionsOperations
from .operations import GuestAgentsOperations
from .. import models


class AzureArcVMwareManagementServiceAPI(object):
    """Self service experience for VMware.

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.connectedvmware.aio.operations.Operations
    :ivar resource_pools: ResourcePoolsOperations operations
    :vartype resource_pools: azure.mgmt.connectedvmware.aio.operations.ResourcePoolsOperations
    :ivar clusters: ClustersOperations operations
    :vartype clusters: azure.mgmt.connectedvmware.aio.operations.ClustersOperations
    :ivar hosts: HostsOperations operations
    :vartype hosts: azure.mgmt.connectedvmware.aio.operations.HostsOperations
    :ivar datastores: DatastoresOperations operations
    :vartype datastores: azure.mgmt.connectedvmware.aio.operations.DatastoresOperations
    :ivar vcenters: VCentersOperations operations
    :vartype vcenters: azure.mgmt.connectedvmware.aio.operations.VCentersOperations
    :ivar virtual_machines: VirtualMachinesOperations operations
    :vartype virtual_machines: azure.mgmt.connectedvmware.aio.operations.VirtualMachinesOperations
    :ivar virtual_machine_templates: VirtualMachineTemplatesOperations operations
    :vartype virtual_machine_templates: azure.mgmt.connectedvmware.aio.operations.VirtualMachineTemplatesOperations
    :ivar virtual_networks: VirtualNetworksOperations operations
    :vartype virtual_networks: azure.mgmt.connectedvmware.aio.operations.VirtualNetworksOperations
    :ivar inventory_items: InventoryItemsOperations operations
    :vartype inventory_items: azure.mgmt.connectedvmware.aio.operations.InventoryItemsOperations
    :ivar hybrid_identity_metadata: HybridIdentityMetadataOperations operations
    :vartype hybrid_identity_metadata: azure.mgmt.connectedvmware.aio.operations.HybridIdentityMetadataOperations
    :ivar machine_extensions: MachineExtensionsOperations operations
    :vartype machine_extensions: azure.mgmt.connectedvmware.aio.operations.MachineExtensionsOperations
    :ivar guest_agents: GuestAgentsOperations operations
    :vartype guest_agents: azure.mgmt.connectedvmware.aio.operations.GuestAgentsOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The Subscription ID.
    :type subscription_id: str
    :param str base_url: Service URL
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = AzureArcVMwareManagementServiceAPIConfiguration(credential, subscription_id, **kwargs)
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize)
        self.resource_pools = ResourcePoolsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.clusters = ClustersOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.hosts = HostsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.datastores = DatastoresOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.vcenters = VCentersOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.virtual_machines = VirtualMachinesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.virtual_machine_templates = VirtualMachineTemplatesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.virtual_networks = VirtualNetworksOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.inventory_items = InventoryItemsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.hybrid_identity_metadata = HybridIdentityMetadataOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.machine_extensions = MachineExtensionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.guest_agents = GuestAgentsOperations(
            self._client, self._config, self._serialize, self._deserialize)

    async def _send_request(self, http_request: HttpRequest, **kwargs: Any) -> AsyncHttpResponse:
        """Runs the network request through the client's chained policies.

        :param http_request: The network request you want to make. Required.
        :type http_request: ~azure.core.pipeline.transport.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to True.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.pipeline.transport.AsyncHttpResponse
        """
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
        }
        http_request.url = self._client.format_url(http_request.url, **path_format_arguments)
        stream = kwargs.pop("stream", True)
        pipeline_response = await self._client._pipeline.run(http_request, stream=stream, **kwargs)
        return pipeline_response.http_response

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "AzureArcVMwareManagementServiceAPI":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
