; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdpal -mcpu=gfx600 < %s | FileCheck -check-prefixes=GFX67,GFX6,GFX67-SDAG,GFX6-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn-amd-amdpal -mcpu=gfx600 < %s | FileCheck -check-prefixes=GFX67,GFX6,GFX67-GISEL,GFX6-GISEL %s

; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdpal -mcpu=gfx700 < %s | FileCheck -check-prefixes=GFX67,GFX7,GFX67-SDAG,GFX7-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn-amd-amdpal -mcpu=gfx700 < %s | FileCheck -check-prefixes=GFX67,GFX7,GFX67-GISEL,GFX7-GISEL %s

; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdpal -mcpu=gfx803 < %s | FileCheck -check-prefixes=GFX8,GFX8-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn-amd-amdpal -mcpu=gfx803 < %s | FileCheck -check-prefixes=GFX8,GFX8-GISEL %s

; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdpal -mcpu=gfx900 < %s | FileCheck -check-prefixes=GFX9,GFX900,GFX9-SDAG,GFX900-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn-amd-amdpal -mcpu=gfx900 < %s | FileCheck -check-prefixes=GFX9,GFX900,GFX9-GISEL,GFX900-GISEL %s

; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdpal -mcpu=gfx90a < %s | FileCheck -check-prefixes=GFX9,GFX90A,GFX9-SDAG,GFX90A-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn-amd-amdpal -mcpu=gfx90a < %s | FileCheck -check-prefixes=GFX9,GFX90A,GFX9-GISEL,GFX90A-GISEL %s

; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdpal -mcpu=gfx1030 < %s | FileCheck -check-prefixes=GFX10,GFX10-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn-amd-amdpal -mcpu=gfx1030 < %s | FileCheck -check-prefixes=GFX10,GFX10-GISEL %s

; Test for integer mad formation for patterns used in clpeak

define i32 @clpeak_imad_pat_i32(i32 %x, i32 %y) {
; GFX67-SDAG-LABEL: clpeak_imad_pat_i32:
; GFX67-SDAG:       ; %bb.0: ; %entry
; GFX67-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v2, v0
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v1, v0, v2
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v0
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX67-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX67-GISEL-LABEL: clpeak_imad_pat_i32:
; GFX67-GISEL:       ; %bb.0: ; %entry
; GFX67-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v2, v0
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v2
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX67-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: clpeak_imad_pat_i32:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, 1, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v2, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v1, v0, v2
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v1, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v0, v1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: clpeak_imad_pat_i32:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, 1, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v2, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_add_u32_e32 v1, vcc, 1, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, 1, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-SDAG-LABEL: clpeak_imad_pat_i32:
; GFX900-SDAG:       ; %bb.0: ; %entry
; GFX900-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-SDAG-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX900-SDAG-NEXT:    v_add_u32_e32 v0, v2, v0
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[1:2], s[4:5], v0, v2, v[0:1]
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v1, v0, v[1:2]
; GFX900-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-GISEL-LABEL: clpeak_imad_pat_i32:
; GFX900-GISEL:       ; %bb.0: ; %entry
; GFX900-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-GISEL-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX900-GISEL-NEXT:    v_add_u32_e32 v0, v2, v0
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX900-GISEL-NEXT:    v_add_u32_e32 v1, 1, v2
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX900-GISEL-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX900-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-SDAG-LABEL: clpeak_imad_pat_i32:
; GFX90A-SDAG:       ; %bb.0: ; %entry
; GFX90A-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v0, v2, v0
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v0, v2, v[0:1]
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v2, v0, v[2:3]
; GFX90A-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-GISEL-LABEL: clpeak_imad_pat_i32:
; GFX90A-GISEL:       ; %bb.0: ; %entry
; GFX90A-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v0, v2, v0
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v1, 1, v2
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v2, 1, v0
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX90A-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: clpeak_imad_pat_i32:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v0, v2, v0
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[1:2], null, v0, v2, v[0:1]
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[0:1], null, v1, v0, v[1:2]
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: clpeak_imad_pat_i32:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, v2, v0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, 1, v2
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %y18 = add i32 %x, 1
  %add = mul i32 %y18, %y
  %mul119 = add i32 %add, %y18
  %add2 = mul i32 %mul119, %y
  %add220 = add i32 %add, 1
  %add422 = add i32 %add2, 1
  %mul521 = mul i32 %add2, %add220
  %add6 = mul i32 %mul521, %add422
  ret i32 %add6
}

define signext i16 @clpeak_imad_pat_i16(i16 signext %x, i16 signext %y) {
; GFX67-SDAG-LABEL: clpeak_imad_pat_i16:
; GFX67-SDAG:       ; %bb.0: ; %entry
; GFX67-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v3, v0, v2
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v4, v1, v3
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v0, v2, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v4
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v1, v1, v3, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v0, v0, v1
; GFX67-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX67-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX67-GISEL-LABEL: clpeak_imad_pat_i16:
; GFX67-GISEL:       ; %bb.0: ; %entry
; GFX67-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v0
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v1
; GFX67-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX67-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: clpeak_imad_pat_i16:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v0, v1, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v0, v1, v0
; GFX8-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: clpeak_imad_pat_i16:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u16_e32 v0, 1, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v2, v0, v1
; GFX8-GISEL-NEXT:    v_add_u16_e32 v3, 1, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v4, v3, v2
; GFX8-GISEL-NEXT:    v_mad_u16 v0, v0, v1, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v0, v4
; GFX8-GISEL-NEXT:    v_mad_u16 v1, v3, v2, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: clpeak_imad_pat_i16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v0, v1, v0, v1
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v1, v0, v1, v0
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v0, v1, v0, v1
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v0, v0, v1, v0
; GFX9-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: clpeak_imad_pat_i16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_add_u16_e32 v0, 1, v0
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v2, v0, v1
; GFX9-GISEL-NEXT:    v_add_u16_e32 v3, 1, v1
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v4, v3, v2
; GFX9-GISEL-NEXT:    v_mad_legacy_u16 v0, v0, v1, 1
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v0, v4
; GFX9-GISEL-NEXT:    v_mad_legacy_u16 v1, v3, v2, 1
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: clpeak_imad_pat_i16:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX10-SDAG-NEXT:    v_mad_u16 v1, v0, v1, v0
; GFX10-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX10-SDAG-NEXT:    v_mad_u16 v0, v0, v1, v0
; GFX10-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: clpeak_imad_pat_i16:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, 1
; GFX10-GISEL-NEXT:    v_add_nc_u16 v2, v1, 1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v1, v2, v0
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, 1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u16 v1, v1, 1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %conv33 = add i16 %x, 1
  %add = mul i16 %conv33, %y
  %conv434 = add i16 %y, 1
  %add8 = mul i16 %conv434, %add
  %conv1035 = add i16 %add, 1
  %add14 = mul i16 %conv1035, %add8
  %conv1636 = add i16 %add8, 1
  %add20 = mul i16 %add14, %conv1636
  ret i16 %add20
}

define <2 x i16> @clpeak_imad_pat_v2i16(<2 x i16> %x, <2 x i16> %y) {
; GFX67-SDAG-LABEL: clpeak_imad_pat_v2i16:
; GFX67-SDAG:       ; %bb.0: ; %entry
; GFX67-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xffff, v0
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_and_b32_e32 v5, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v4, v2, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v1, v5, v3, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v6, v0, v2
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v4, v4, v2, 1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v7, v1, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v5, v5, v3, 1
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v1, v1, v3, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v6
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v0, v2, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v5
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v3, v3, v4
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xffff, v7
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v2, v4, v2
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v0, v3, v0
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v1, v2, v1
; GFX67-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX67-GISEL-LABEL: clpeak_imad_pat_v2i16:
; GFX67-GISEL:       ; %bb.0: ; %entry
; GFX67-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v5, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v0
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX67-GISEL-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v5, v5, v3
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v4, v4, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v5, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v4, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX67-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 1, v5
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 1, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v4, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX67-GISEL-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v4
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v2, 16, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v3
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v2
; GFX67-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: clpeak_imad_pat_v2i16:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_mov_b32_e32 v3, 1
; GFX8-SDAG-NEXT:    v_add_u16_e32 v2, 1, v0
; GFX8-SDAG-NEXT:    v_add_u16_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-SDAG-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v4, v0, v3
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v0, v3, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v5, v2, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v2, v2, v1, v2
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v0, v0, v3
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v1, v2, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v2, v0, v4, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v3, v1, v5, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v2, v0, v2
; GFX8-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v3, v1, v3
; GFX8-SDAG-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: clpeak_imad_pat_v2i16:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v3, 1
; GFX8-GISEL-NEXT:    v_add_u16_e32 v2, 1, v0
; GFX8-GISEL-NEXT:    v_add_u16_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX8-GISEL-NEXT:    v_mad_u16 v4, v2, v1, v2
; GFX8-GISEL-NEXT:    v_mad_u16 v5, v0, v3, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v6, v4, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v7, v5, v3
; GFX8-GISEL-NEXT:    v_mad_u16 v2, v2, v1, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v0, v0, v3, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v1, v4, v1, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v3, v5, v3, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v2, v6, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v7, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v1, v2, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_sdwa v0, v0, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: clpeak_imad_pat_v2i16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v0, v0, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX9-SDAG-NEXT:    v_pk_add_u16 v0, v2, v0
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v1, v2, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v2, v0, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: clpeak_imad_pat_v2i16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_pk_add_u16 v0, v0, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX9-GISEL-NEXT:    v_pk_add_u16 v0, v2, v0
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX9-GISEL-NEXT:    v_pk_add_u16 v1, v2, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_add_u16 v2, v0, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: clpeak_imad_pat_v2i16:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v0, v0, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX10-SDAG-NEXT:    v_pk_add_u16 v0, v2, v0
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v1, v2, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v2, v0, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: clpeak_imad_pat_v2i16:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_pk_add_u16 v0, v0, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX10-GISEL-NEXT:    v_pk_add_u16 v0, v2, v0
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_pk_add_u16 v1, v2, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_add_u16 v2, v0, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %y18 = add <2 x i16> %x, <i16 1, i16 1>
  %add = mul <2 x i16> %y18, %y
  %mul119 = add <2 x i16> %add, %y18
  %add2 = mul <2 x i16> %mul119, %y
  %add220 = add <2 x i16> %add, <i16 1, i16 1>
  %add422 = add <2 x i16> %add2, <i16 1, i16 1>
  %mul521 = mul <2 x i16> %add2, %add220
  %add6 = mul <2 x i16> %mul521, %add422
  ret <2 x i16> %add6
}

define <3 x i16> @clpeak_imad_pat_v3i16(<3 x i16> %x, <3 x i16> %y) {
; GFX67-SDAG-LABEL: clpeak_imad_pat_v3i16:
; GFX67-SDAG:       ; %bb.0: ; %entry
; GFX67-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v6, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v8, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-SDAG-NEXT:    v_add_i32_e32 v2, vcc, 1, v2
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v9, v8, v4
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v6, v3, v0
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v1, v8, v4, v1
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v6, v6, v3, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v7, 0xffff, v2
; GFX67-SDAG-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX67-SDAG-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v2, v7, v5, v2
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v8, v0, v3
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v1, v1, v4
; GFX67-SDAG-NEXT:    v_or_b32_e32 v6, v9, v6
; GFX67-SDAG-NEXT:    s_mov_b32 s4, 0x10000
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v0, v3, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_add_i32_e32 v6, vcc, s4, v6
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v4, v2, v5
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v7, v7, v5, 1
; GFX67-SDAG-NEXT:    v_or_b32_e32 v0, v3, v0
; GFX67-SDAG-NEXT:    v_lshrrev_b32_e32 v3, 16, v6
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v2, v2, v5, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v5, 0xffff, v8
; GFX67-SDAG-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v1, v1, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v4
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, s4, v0
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v5, v5, v6
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v3, v3, v7
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_lshrrev_b32_e32 v4, 16, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v0, v5, v0
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v1, v1, v4
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v2, v3, v2
; GFX67-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX67-GISEL-LABEL: clpeak_imad_pat_v3i16:
; GFX67-GISEL:       ; %bb.0: ; %entry
; GFX67-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v6, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 1, v2
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v6, v6, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v7, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v7, v7, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v8, 0xffff, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v6, v0
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v8, v8, v5
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v7, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v8, v2
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 1, v6
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v4, vcc, 1, v7
; GFX67-GISEL-NEXT:    v_add_i32_e32 v6, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v2, v2, v5
; GFX67-GISEL-NEXT:    v_add_i32_e32 v5, vcc, 1, v8
; GFX67-GISEL-NEXT:    v_add_i32_e32 v7, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v4
; GFX67-GISEL-NEXT:    v_add_i32_e32 v8, vcc, 1, v2
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v5
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v2, v2, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v6
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v7
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v8
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v2, v2, v3
; GFX67-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: clpeak_imad_pat_v3i16:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_mov_b32_e32 v5, 1
; GFX8-SDAG-NEXT:    v_add_u16_e32 v4, 1, v0
; GFX8-SDAG-NEXT:    v_add_u16_sdwa v0, v0, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-SDAG-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX8-SDAG-NEXT:    v_add_u16_e32 v1, 1, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v6, v0, v5
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v0, v5, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v7, v1, v3
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v8, v4, v2
; GFX8-SDAG-NEXT:    v_mad_u16 v4, v4, v2, v4
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v1, v3, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v0, v0, v5
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v1, v1, v3
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v2, v4, v2
; GFX8-SDAG-NEXT:    v_mad_u16 v3, v0, v6, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v4, v2, v8, v2
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v3, v0, v3
; GFX8-SDAG-NEXT:    v_mad_u16 v5, v1, v7, v1
; GFX8-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v2, v4, v2, v4
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v5, v1, v5
; GFX8-SDAG-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: clpeak_imad_pat_v3i16:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v6, 1
; GFX8-GISEL-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX8-GISEL-NEXT:    v_add_u16_e32 v5, 1, v0
; GFX8-GISEL-NEXT:    v_add_u16_sdwa v0, v0, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_add_u16_e32 v1, 1, v1
; GFX8-GISEL-NEXT:    v_mad_u16 v6, v5, v2, v5
; GFX8-GISEL-NEXT:    v_mad_u16 v7, v0, v4, v0
; GFX8-GISEL-NEXT:    v_mad_u16 v8, v1, v3, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v9, v6, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v10, v7, v4
; GFX8-GISEL-NEXT:    v_mad_u16 v5, v5, v2, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v0, v0, v4, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v11, v8, v3
; GFX8-GISEL-NEXT:    v_mad_u16 v1, v1, v3, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v2, v6, v2, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v4, v7, v4, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v5, v9, v5
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v10, v0
; GFX8-GISEL-NEXT:    v_mad_u16 v3, v8, v3, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v1, v11, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v2, v5, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u16_sdwa v0, v0, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v1, v1, v3
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: clpeak_imad_pat_v3i16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v1, v1, -1
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v0, v0, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v4, v0, v2
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v5, v1, v3
; GFX9-SDAG-NEXT:    v_pk_add_u16 v1, v5, v1
; GFX9-SDAG-NEXT:    v_pk_add_u16 v0, v4, v0
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v2, v4, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v3, v5, -1
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v4, v1, -1
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v5, v0, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v5
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v1, v1, v4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: clpeak_imad_pat_v3i16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_pk_add_u16 v0, v0, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_add_u16 v1, v1, 1
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v4, v0, v2
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v5, v1, v3
; GFX9-GISEL-NEXT:    v_pk_add_u16 v0, v4, v0
; GFX9-GISEL-NEXT:    v_pk_add_u16 v1, v5, v1
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX9-GISEL-NEXT:    v_pk_add_u16 v2, v4, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_add_u16 v3, v5, 1
; GFX9-GISEL-NEXT:    v_pk_add_u16 v4, v0, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_add_u16 v5, v1, 1
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v4
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v1, v1, v5
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: clpeak_imad_pat_v3i16:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v1, v1, -1
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v0, v0, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v4, v1, v3
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v5, v0, v2
; GFX10-SDAG-NEXT:    v_pk_add_u16 v1, v4, v1
; GFX10-SDAG-NEXT:    v_pk_add_u16 v0, v5, v0
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v2, v5, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v3, v4, -1
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v4, v1, -1
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v5, v0, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v5
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v1, v1, v4
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: clpeak_imad_pat_v3i16:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_pk_add_u16 v0, v0, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_add_u16 v1, v1, 1
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v4, v0, v2
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v5, v1, v3
; GFX10-GISEL-NEXT:    v_pk_add_u16 v0, v4, v0
; GFX10-GISEL-NEXT:    v_pk_add_u16 v1, v5, v1
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX10-GISEL-NEXT:    v_pk_add_u16 v2, v4, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_add_u16 v3, v5, 1
; GFX10-GISEL-NEXT:    v_pk_add_u16 v4, v0, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_add_u16 v5, v1, 1
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v4
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v1, v1, v5
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %y48 = add <3 x i16> %x, <i16 1, i16 1, i16 1>
  %add = mul <3 x i16> %y48, %y
  %mul1249 = add <3 x i16> %add, %y48
  %add15 = mul <3 x i16> %mul1249, %y
  %add1550 = add <3 x i16> %add, <i16 1, i16 1, i16 1>
  %add2452 = add <3 x i16> %add15, <i16 1, i16 1, i16 1>
  %mul3051 = mul <3 x i16> %add15, %add1550
  %add33 = mul <3 x i16> %mul3051, %add2452
  ret <3 x i16> %add33
}

define <4 x i16> @clpeak_imad_pat_v4i16(<4 x i16> %x, <4 x i16> %y) {
; GFX67-SDAG-LABEL: clpeak_imad_pat_v4i16:
; GFX67-SDAG:       ; %bb.0: ; %entry
; GFX67-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-SDAG-NEXT:    v_add_i32_e32 v3, vcc, 1, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v11, 0xffff, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX67-SDAG-NEXT:    v_add_i32_e32 v2, vcc, 1, v2
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v3, v11, v7, v3
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v9, 0xffff, v2
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v8, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v10, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-SDAG-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v13, v11, v7
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v3, v3, v7
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v7, v9, v6, 1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v12, v10, v5
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v2, v9, v6, v2
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v8, v4, v0
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v1, v10, v5, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX67-SDAG-NEXT:    v_lshlrev_b32_e32 v9, 16, v13
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v8, v8, v4, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_or_b32_e32 v7, v9, v7
; GFX67-SDAG-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; GFX67-SDAG-NEXT:    v_lshlrev_b32_e32 v9, 16, v12
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v10, v0, v4
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v1, v1, v5
; GFX67-SDAG-NEXT:    s_mov_b32 s4, 0x10000
; GFX67-SDAG-NEXT:    v_or_b32_e32 v8, v9, v8
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v0, v4, 1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v5, v2, v6
; GFX67-SDAG-NEXT:    v_add_i32_e32 v8, vcc, s4, v8
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v2, v2, v6, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; GFX67-SDAG-NEXT:    v_add_i32_e32 v7, vcc, s4, v7
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; GFX67-SDAG-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX67-SDAG-NEXT:    v_lshrrev_b32_e32 v4, 16, v8
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_or_b32_e32 v2, v6, v2
; GFX67-SDAG-NEXT:    v_lshrrev_b32_e32 v6, 16, v7
; GFX67-SDAG-NEXT:    v_and_b32_e32 v9, 0xffff, v10
; GFX67-SDAG-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v1, v1, v4
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xffff, v5
; GFX67-SDAG-NEXT:    v_and_b32_e32 v5, 0xffff, v7
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_add_i32_e32 v2, vcc, s4, v2
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, s4, v0
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v8, v9, v8
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v4, v4, v5
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v3, v3, v6
; GFX67-SDAG-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX67-SDAG-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX67-SDAG-NEXT:    v_and_b32_e32 v7, 0xffff, v8
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v0, v7, v0
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v1, v1, v5
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v2, v4, v2
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v3, v3, v6
; GFX67-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX67-GISEL-LABEL: clpeak_imad_pat_v4i16:
; GFX67-GISEL:       ; %bb.0: ; %entry
; GFX67-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 1, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v9, 0xffff, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 1, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v8, 0xffff, v0
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX67-GISEL-NEXT:    v_and_b32_e32 v10, 0xffff, v3
; GFX67-GISEL-NEXT:    v_or_b32_e32 v8, v8, v9
; GFX67-GISEL-NEXT:    v_and_b32_e32 v9, 0xffff, v2
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX67-GISEL-NEXT:    v_or_b32_e32 v9, v9, v10
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; GFX67-GISEL-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX67-GISEL-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v10, v10, v5
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v11, 16, v9
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v8, v8, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; GFX67-GISEL-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX67-GISEL-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v10, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v9, v9, v6
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v11, v11, v7
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v8, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v9, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, v11, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX67-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v3
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX67-GISEL-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v2, v2, v5
; GFX67-GISEL-NEXT:    v_add_i32_e32 v5, vcc, 1, v10
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v4, vcc, 1, v8
; GFX67-GISEL-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v6
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v3, v3, v7
; GFX67-GISEL-NEXT:    v_add_i32_e32 v6, vcc, 1, v9
; GFX67-GISEL-NEXT:    v_add_i32_e32 v7, vcc, 1, v11
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX67-GISEL-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX67-GISEL-NEXT:    v_and_b32_e32 v5, 0xffff, v6
; GFX67-GISEL-NEXT:    v_and_b32_e32 v6, 0xffff, v7
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX67-GISEL-NEXT:    v_add_i32_e32 v7, vcc, 1, v2
; GFX67-GISEL-NEXT:    v_or_b32_e32 v5, v5, v6
; GFX67-GISEL-NEXT:    v_add_i32_e32 v6, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX67-GISEL-NEXT:    v_add_i32_e32 v8, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v9, vcc, 1, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX67-GISEL-NEXT:    v_or_b32_e32 v6, v6, v7
; GFX67-GISEL-NEXT:    v_and_b32_e32 v7, 0xffff, v8
; GFX67-GISEL-NEXT:    v_and_b32_e32 v8, 0xffff, v9
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX67-GISEL-NEXT:    v_or_b32_e32 v7, v7, v8
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v8, 16, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v5
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v9, 16, v5
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v2, v2, v8
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v4, v1, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v3
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v3, v1, v9
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v6
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v5, 16, v7
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v2, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v7
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v6
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v2, v2, v4
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v3, v3, v5
; GFX67-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: clpeak_imad_pat_v4i16:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_mov_b32_e32 v6, 1
; GFX8-SDAG-NEXT:    v_add_u16_e32 v5, 1, v0
; GFX8-SDAG-NEXT:    v_add_u16_sdwa v0, v0, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-SDAG-NEXT:    v_lshrrev_b32_e32 v8, 16, v2
; GFX8-SDAG-NEXT:    v_add_u16_e32 v4, 1, v1
; GFX8-SDAG-NEXT:    v_add_u16_sdwa v1, v1, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-SDAG-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v9, v0, v8
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v0, v8, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v7, v1, v6
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v10, v5, v2
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v11, v4, v3
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v1, v6, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v4, v4, v3, v4
; GFX8-SDAG-NEXT:    v_mad_u16 v5, v5, v2, v5
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v0, v0, v8
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v1, v1, v6
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v2, v5, v2
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v3, v4, v3
; GFX8-SDAG-NEXT:    v_mad_u16 v4, v0, v9, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v5, v1, v7, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v7, v2, v10, v2
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v4, v0, v4
; GFX8-SDAG-NEXT:    v_mad_u16 v6, v3, v11, v3
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v5, v1, v5
; GFX8-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v2, v7, v2, v7
; GFX8-SDAG-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v2, v6, v3, v6
; GFX8-SDAG-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: clpeak_imad_pat_v4i16:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v5, 1
; GFX8-GISEL-NEXT:    v_add_u16_e32 v4, 1, v0
; GFX8-GISEL-NEXT:    v_add_u16_sdwa v0, v0, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_add_u16_e32 v6, 1, v1
; GFX8-GISEL-NEXT:    v_add_u16_sdwa v1, v1, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX8-GISEL-NEXT:    v_lshrrev_b32_e32 v7, 16, v3
; GFX8-GISEL-NEXT:    v_mad_u16 v8, v4, v2, v4
; GFX8-GISEL-NEXT:    v_mad_u16 v9, v0, v5, v0
; GFX8-GISEL-NEXT:    v_mad_u16 v10, v6, v3, v6
; GFX8-GISEL-NEXT:    v_mad_u16 v11, v1, v7, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v12, v8, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v13, v9, v5
; GFX8-GISEL-NEXT:    v_mad_u16 v4, v4, v2, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v0, v0, v5, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v14, v10, v3
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v15, v11, v7
; GFX8-GISEL-NEXT:    v_mad_u16 v6, v6, v3, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v1, v1, v7, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v2, v8, v2, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v5, v9, v5, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v4, v12, v4
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v13, v0
; GFX8-GISEL-NEXT:    v_mad_u16 v3, v10, v3, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v7, v11, v7, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v6, v14, v6
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v1, v15, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v2, v4, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u16_sdwa v0, v0, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v2, v6, v3
; GFX8-GISEL-NEXT:    v_mul_lo_u16_sdwa v1, v1, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: clpeak_imad_pat_v4i16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v1, v1, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v0, v0, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v4, v0, v2
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v5, v1, v3
; GFX9-SDAG-NEXT:    v_pk_add_u16 v1, v5, v1
; GFX9-SDAG-NEXT:    v_pk_add_u16 v0, v4, v0
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v2, v4, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v3, v5, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v4, v1, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v5, v0, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v5
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v1, v1, v4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: clpeak_imad_pat_v4i16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_pk_add_u16 v0, v0, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_add_u16 v1, v1, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v4, v0, v2
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v5, v1, v3
; GFX9-GISEL-NEXT:    v_pk_add_u16 v0, v4, v0
; GFX9-GISEL-NEXT:    v_pk_add_u16 v1, v5, v1
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX9-GISEL-NEXT:    v_pk_add_u16 v2, v4, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_add_u16 v3, v5, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_add_u16 v4, v0, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_add_u16 v5, v1, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v4
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v1, v1, v5
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: clpeak_imad_pat_v4i16:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v1, v1, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v0, v0, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v4, v1, v3
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v5, v0, v2
; GFX10-SDAG-NEXT:    v_pk_add_u16 v1, v4, v1
; GFX10-SDAG-NEXT:    v_pk_add_u16 v0, v5, v0
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v2, v5, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v3, v4, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v4, v1, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v5, v0, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v5
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v1, v1, v4
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: clpeak_imad_pat_v4i16:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_pk_add_u16 v0, v0, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_add_u16 v1, v1, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v4, v0, v2
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v5, v1, v3
; GFX10-GISEL-NEXT:    v_pk_add_u16 v0, v4, v0
; GFX10-GISEL-NEXT:    v_pk_add_u16 v1, v5, v1
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX10-GISEL-NEXT:    v_pk_add_u16 v2, v4, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_add_u16 v3, v5, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_add_u16 v4, v0, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_add_u16 v5, v1, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v4
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v1, v1, v5
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %y18 = add <4 x i16> %x, <i16 1, i16 1, i16 1, i16 1>
  %add = mul <4 x i16> %y18, %y
  %mul119 = add <4 x i16> %add, %y18
  %add2 = mul <4 x i16> %mul119, %y
  %add220 = add <4 x i16> %add, <i16 1, i16 1, i16 1, i16 1>
  %add422 = add <4 x i16> %add2, <i16 1, i16 1, i16 1, i16 1>
  %mul521 = mul <4 x i16> %add2, %add220
  %add6 = mul <4 x i16> %mul521, %add422
  ret <4 x i16> %add6
}

define zeroext i16 @clpeak_umad_pat_i16(i16 zeroext %x, i16 zeroext %y) {
; GFX67-SDAG-LABEL: clpeak_umad_pat_i16:
; GFX67-SDAG:       ; %bb.0: ; %entry
; GFX67-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v2, v0, v1
; GFX67-SDAG-NEXT:    v_add_i32_e32 v3, vcc, 1, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v4, v3, v2
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v0, v1, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v4
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v0, v0, v1
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v1, v3, v2, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v0, v0, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX67-GISEL-LABEL: clpeak_umad_pat_i16:
; GFX67-GISEL:       ; %bb.0: ; %entry
; GFX67-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v0
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: clpeak_umad_pat_i16:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v0, v1, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v0, v1, v0
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: clpeak_umad_pat_i16:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u16_e32 v0, 1, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v2, v0, v1
; GFX8-GISEL-NEXT:    v_add_u16_e32 v3, 1, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v4, v3, v2
; GFX8-GISEL-NEXT:    v_mad_u16 v0, v0, v1, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v0, v4
; GFX8-GISEL-NEXT:    v_mad_u16 v1, v3, v2, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: clpeak_umad_pat_i16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v0, v1, v0, v1
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v1, v0, v1, v0
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v0, v1, v0, v1
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v0, v0, v1, v0
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: clpeak_umad_pat_i16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_add_u16_e32 v0, 1, v0
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v2, v0, v1
; GFX9-GISEL-NEXT:    v_add_u16_e32 v3, 1, v1
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v4, v3, v2
; GFX9-GISEL-NEXT:    v_mad_legacy_u16 v0, v0, v1, 1
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v0, v4
; GFX9-GISEL-NEXT:    v_mad_legacy_u16 v1, v3, v2, 1
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: clpeak_umad_pat_i16:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX10-SDAG-NEXT:    v_mad_u16 v1, v0, v1, v0
; GFX10-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX10-SDAG-NEXT:    v_mad_u16 v0, v0, v1, v0
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: clpeak_umad_pat_i16:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, 1
; GFX10-GISEL-NEXT:    v_add_nc_u16 v2, v1, 1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v1, v2, v0
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, 1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u16 v1, v1, 1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %conv33 = add i16 %x, 1
  %add = mul i16 %conv33, %y
  %conv434 = add i16 %y, 1
  %add8 = mul i16 %conv434, %add
  %conv1035 = add i16 %add, 1
  %add14 = mul i16 %conv1035, %add8
  %conv1636 = add i16 %add8, 1
  %add20 = mul i16 %add14, %conv1636
  ret i16 %add20
}

define <2 x i16> @clpeak_umad_pat_v2i16(<2 x i16> %x, <2 x i16> %y) {
; GFX67-SDAG-LABEL: clpeak_umad_pat_v2i16:
; GFX67-SDAG:       ; %bb.0: ; %entry
; GFX67-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xffff, v0
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_and_b32_e32 v5, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v4, v2, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v1, v5, v3, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v6, v0, v2
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v4, v4, v2, 1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v7, v1, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v5, v5, v3, 1
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v1, v1, v3, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v6
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v0, v2, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v5
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v3, v3, v4
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xffff, v7
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v2, v4, v2
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v0, v3, v0
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v1, v2, v1
; GFX67-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX67-GISEL-LABEL: clpeak_umad_pat_v2i16:
; GFX67-GISEL:       ; %bb.0: ; %entry
; GFX67-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v5, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v0
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX67-GISEL-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v5, v5, v3
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v4, v4, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v5, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v4, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX67-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 1, v5
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 1, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v4, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX67-GISEL-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v4
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v2, 16, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v3
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v2
; GFX67-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: clpeak_umad_pat_v2i16:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_mov_b32_e32 v3, 1
; GFX8-SDAG-NEXT:    v_add_u16_e32 v2, 1, v0
; GFX8-SDAG-NEXT:    v_add_u16_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-SDAG-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v4, v0, v3
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v0, v3, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v5, v2, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v2, v2, v1, v2
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v0, v0, v3
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v1, v2, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v2, v0, v4, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v3, v1, v5, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v2, v0, v2
; GFX8-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v3, v1, v3
; GFX8-SDAG-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: clpeak_umad_pat_v2i16:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v3, 1
; GFX8-GISEL-NEXT:    v_add_u16_e32 v2, 1, v0
; GFX8-GISEL-NEXT:    v_add_u16_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX8-GISEL-NEXT:    v_mad_u16 v4, v2, v1, v2
; GFX8-GISEL-NEXT:    v_mad_u16 v5, v0, v3, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v6, v4, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v7, v5, v3
; GFX8-GISEL-NEXT:    v_mad_u16 v2, v2, v1, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v0, v0, v3, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v1, v4, v1, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v3, v5, v3, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v2, v6, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v7, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v1, v2, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_sdwa v0, v0, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: clpeak_umad_pat_v2i16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v0, v0, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX9-SDAG-NEXT:    v_pk_add_u16 v0, v2, v0
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v1, v2, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v2, v0, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: clpeak_umad_pat_v2i16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_pk_add_u16 v0, v0, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX9-GISEL-NEXT:    v_pk_add_u16 v0, v2, v0
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX9-GISEL-NEXT:    v_pk_add_u16 v1, v2, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_add_u16 v2, v0, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: clpeak_umad_pat_v2i16:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v0, v0, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX10-SDAG-NEXT:    v_pk_add_u16 v0, v2, v0
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v1, v2, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v2, v0, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: clpeak_umad_pat_v2i16:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_pk_add_u16 v0, v0, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX10-GISEL-NEXT:    v_pk_add_u16 v0, v2, v0
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_pk_add_u16 v1, v2, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_add_u16 v2, v0, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %y18 = add <2 x i16> %x, <i16 1, i16 1>
  %add = mul <2 x i16> %y18, %y
  %mul119 = add <2 x i16> %add, %y18
  %add2 = mul <2 x i16> %mul119, %y
  %add220 = add <2 x i16> %add, <i16 1, i16 1>
  %add422 = add <2 x i16> %add2, <i16 1, i16 1>
  %mul521 = mul <2 x i16> %add2, %add220
  %add6 = mul <2 x i16> %mul521, %add422
  ret <2 x i16> %add6
}

define <3 x i16> @clpeak_umad_pat_v3i16(<3 x i16> %x, <3 x i16> %y) {
; GFX67-SDAG-LABEL: clpeak_umad_pat_v3i16:
; GFX67-SDAG:       ; %bb.0: ; %entry
; GFX67-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v6, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v8, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-SDAG-NEXT:    v_add_i32_e32 v2, vcc, 1, v2
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v9, v8, v4
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v6, v3, v0
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v1, v8, v4, v1
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v6, v6, v3, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v7, 0xffff, v2
; GFX67-SDAG-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX67-SDAG-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v2, v7, v5, v2
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v8, v0, v3
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v1, v1, v4
; GFX67-SDAG-NEXT:    v_or_b32_e32 v6, v9, v6
; GFX67-SDAG-NEXT:    s_mov_b32 s4, 0x10000
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v0, v3, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_add_i32_e32 v6, vcc, s4, v6
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v4, v2, v5
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v7, v7, v5, 1
; GFX67-SDAG-NEXT:    v_or_b32_e32 v0, v3, v0
; GFX67-SDAG-NEXT:    v_lshrrev_b32_e32 v3, 16, v6
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v2, v2, v5, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v5, 0xffff, v8
; GFX67-SDAG-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v1, v1, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v4
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, s4, v0
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v5, v5, v6
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v3, v3, v7
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_lshrrev_b32_e32 v4, 16, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v0, v5, v0
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v1, v1, v4
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v2, v3, v2
; GFX67-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX67-GISEL-LABEL: clpeak_umad_pat_v3i16:
; GFX67-GISEL:       ; %bb.0: ; %entry
; GFX67-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v6, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 1, v2
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v6, v6, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v7, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v7, v7, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v8, 0xffff, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v6, v0
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v8, v8, v5
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v7, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v8, v2
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 1, v6
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v4, vcc, 1, v7
; GFX67-GISEL-NEXT:    v_add_i32_e32 v6, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v2, v2, v5
; GFX67-GISEL-NEXT:    v_add_i32_e32 v5, vcc, 1, v8
; GFX67-GISEL-NEXT:    v_add_i32_e32 v7, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v4
; GFX67-GISEL-NEXT:    v_add_i32_e32 v8, vcc, 1, v2
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v5
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v2, v2, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v6
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v7
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v8
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v2, v2, v3
; GFX67-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: clpeak_umad_pat_v3i16:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_mov_b32_e32 v5, 1
; GFX8-SDAG-NEXT:    v_add_u16_e32 v4, 1, v0
; GFX8-SDAG-NEXT:    v_add_u16_sdwa v0, v0, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-SDAG-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX8-SDAG-NEXT:    v_add_u16_e32 v1, 1, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v6, v0, v5
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v0, v5, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v7, v1, v3
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v8, v4, v2
; GFX8-SDAG-NEXT:    v_mad_u16 v4, v4, v2, v4
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v1, v3, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v0, v0, v5
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v1, v1, v3
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v2, v4, v2
; GFX8-SDAG-NEXT:    v_mad_u16 v3, v0, v6, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v4, v2, v8, v2
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v3, v0, v3
; GFX8-SDAG-NEXT:    v_mad_u16 v5, v1, v7, v1
; GFX8-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v2, v4, v2, v4
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v5, v1, v5
; GFX8-SDAG-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: clpeak_umad_pat_v3i16:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v6, 1
; GFX8-GISEL-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX8-GISEL-NEXT:    v_add_u16_e32 v5, 1, v0
; GFX8-GISEL-NEXT:    v_add_u16_sdwa v0, v0, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_add_u16_e32 v1, 1, v1
; GFX8-GISEL-NEXT:    v_mad_u16 v6, v5, v2, v5
; GFX8-GISEL-NEXT:    v_mad_u16 v7, v0, v4, v0
; GFX8-GISEL-NEXT:    v_mad_u16 v8, v1, v3, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v9, v6, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v10, v7, v4
; GFX8-GISEL-NEXT:    v_mad_u16 v5, v5, v2, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v0, v0, v4, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v11, v8, v3
; GFX8-GISEL-NEXT:    v_mad_u16 v1, v1, v3, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v2, v6, v2, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v4, v7, v4, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v5, v9, v5
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v10, v0
; GFX8-GISEL-NEXT:    v_mad_u16 v3, v8, v3, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v1, v11, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v2, v5, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u16_sdwa v0, v0, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v1, v1, v3
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: clpeak_umad_pat_v3i16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v1, v1, -1
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v0, v0, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v4, v0, v2
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v5, v1, v3
; GFX9-SDAG-NEXT:    v_pk_add_u16 v1, v5, v1
; GFX9-SDAG-NEXT:    v_pk_add_u16 v0, v4, v0
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v2, v4, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v3, v5, -1
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v4, v1, -1
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v5, v0, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v5
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v1, v1, v4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: clpeak_umad_pat_v3i16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_pk_add_u16 v0, v0, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_add_u16 v1, v1, 1
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v4, v0, v2
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v5, v1, v3
; GFX9-GISEL-NEXT:    v_pk_add_u16 v0, v4, v0
; GFX9-GISEL-NEXT:    v_pk_add_u16 v1, v5, v1
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX9-GISEL-NEXT:    v_pk_add_u16 v2, v4, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_add_u16 v3, v5, 1
; GFX9-GISEL-NEXT:    v_pk_add_u16 v4, v0, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_add_u16 v5, v1, 1
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v4
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v1, v1, v5
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: clpeak_umad_pat_v3i16:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v1, v1, -1
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v0, v0, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v4, v1, v3
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v5, v0, v2
; GFX10-SDAG-NEXT:    v_pk_add_u16 v1, v4, v1
; GFX10-SDAG-NEXT:    v_pk_add_u16 v0, v5, v0
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v2, v5, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v3, v4, -1
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v4, v1, -1
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v5, v0, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v5
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v1, v1, v4
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: clpeak_umad_pat_v3i16:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_pk_add_u16 v0, v0, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_add_u16 v1, v1, 1
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v4, v0, v2
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v5, v1, v3
; GFX10-GISEL-NEXT:    v_pk_add_u16 v0, v4, v0
; GFX10-GISEL-NEXT:    v_pk_add_u16 v1, v5, v1
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX10-GISEL-NEXT:    v_pk_add_u16 v2, v4, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_add_u16 v3, v5, 1
; GFX10-GISEL-NEXT:    v_pk_add_u16 v4, v0, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_add_u16 v5, v1, 1
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v4
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v1, v1, v5
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %y48 = add <3 x i16> %x, <i16 1, i16 1, i16 1>
  %add = mul <3 x i16> %y48, %y
  %mul1249 = add <3 x i16> %add, %y48
  %add15 = mul <3 x i16> %mul1249, %y
  %add1550 = add <3 x i16> %add, <i16 1, i16 1, i16 1>
  %add2452 = add <3 x i16> %add15, <i16 1, i16 1, i16 1>
  %mul3051 = mul <3 x i16> %add15, %add1550
  %add33 = mul <3 x i16> %mul3051, %add2452
  ret <3 x i16> %add33
}

define <4 x i16> @clpeak_umad_pat_v4i16(<4 x i16> %x, <4 x i16> %y) {
; GFX67-SDAG-LABEL: clpeak_umad_pat_v4i16:
; GFX67-SDAG:       ; %bb.0: ; %entry
; GFX67-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-SDAG-NEXT:    v_add_i32_e32 v3, vcc, 1, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v11, 0xffff, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX67-SDAG-NEXT:    v_add_i32_e32 v2, vcc, 1, v2
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v3, v11, v7, v3
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v9, 0xffff, v2
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v8, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v10, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-SDAG-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v13, v11, v7
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v3, v3, v7
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v7, v9, v6, 1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v12, v10, v5
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v2, v9, v6, v2
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v8, v4, v0
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v1, v10, v5, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX67-SDAG-NEXT:    v_lshlrev_b32_e32 v9, 16, v13
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v8, v8, v4, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_or_b32_e32 v7, v9, v7
; GFX67-SDAG-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; GFX67-SDAG-NEXT:    v_lshlrev_b32_e32 v9, 16, v12
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v10, v0, v4
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v1, v1, v5
; GFX67-SDAG-NEXT:    s_mov_b32 s4, 0x10000
; GFX67-SDAG-NEXT:    v_or_b32_e32 v8, v9, v8
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v0, v4, 1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v5, v2, v6
; GFX67-SDAG-NEXT:    v_add_i32_e32 v8, vcc, s4, v8
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v2, v2, v6, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; GFX67-SDAG-NEXT:    v_add_i32_e32 v7, vcc, s4, v7
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; GFX67-SDAG-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX67-SDAG-NEXT:    v_lshrrev_b32_e32 v4, 16, v8
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_or_b32_e32 v2, v6, v2
; GFX67-SDAG-NEXT:    v_lshrrev_b32_e32 v6, 16, v7
; GFX67-SDAG-NEXT:    v_and_b32_e32 v9, 0xffff, v10
; GFX67-SDAG-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v1, v1, v4
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xffff, v5
; GFX67-SDAG-NEXT:    v_and_b32_e32 v5, 0xffff, v7
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_add_i32_e32 v2, vcc, s4, v2
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, s4, v0
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v8, v9, v8
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v4, v4, v5
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v3, v3, v6
; GFX67-SDAG-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX67-SDAG-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX67-SDAG-NEXT:    v_and_b32_e32 v7, 0xffff, v8
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v0, v7, v0
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v1, v1, v5
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v2, v4, v2
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v3, v3, v6
; GFX67-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX67-GISEL-LABEL: clpeak_umad_pat_v4i16:
; GFX67-GISEL:       ; %bb.0: ; %entry
; GFX67-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 1, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v9, 0xffff, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 1, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v8, 0xffff, v0
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX67-GISEL-NEXT:    v_and_b32_e32 v10, 0xffff, v3
; GFX67-GISEL-NEXT:    v_or_b32_e32 v8, v8, v9
; GFX67-GISEL-NEXT:    v_and_b32_e32 v9, 0xffff, v2
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX67-GISEL-NEXT:    v_or_b32_e32 v9, v9, v10
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; GFX67-GISEL-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX67-GISEL-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v10, v10, v5
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v11, 16, v9
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v8, v8, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; GFX67-GISEL-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX67-GISEL-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v10, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v9, v9, v6
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v11, v11, v7
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v8, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v9, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, v11, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX67-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v3
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX67-GISEL-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v2, v2, v5
; GFX67-GISEL-NEXT:    v_add_i32_e32 v5, vcc, 1, v10
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v4, vcc, 1, v8
; GFX67-GISEL-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v6
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v3, v3, v7
; GFX67-GISEL-NEXT:    v_add_i32_e32 v6, vcc, 1, v9
; GFX67-GISEL-NEXT:    v_add_i32_e32 v7, vcc, 1, v11
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX67-GISEL-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX67-GISEL-NEXT:    v_and_b32_e32 v5, 0xffff, v6
; GFX67-GISEL-NEXT:    v_and_b32_e32 v6, 0xffff, v7
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX67-GISEL-NEXT:    v_add_i32_e32 v7, vcc, 1, v2
; GFX67-GISEL-NEXT:    v_or_b32_e32 v5, v5, v6
; GFX67-GISEL-NEXT:    v_add_i32_e32 v6, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX67-GISEL-NEXT:    v_add_i32_e32 v8, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v9, vcc, 1, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX67-GISEL-NEXT:    v_or_b32_e32 v6, v6, v7
; GFX67-GISEL-NEXT:    v_and_b32_e32 v7, 0xffff, v8
; GFX67-GISEL-NEXT:    v_and_b32_e32 v8, 0xffff, v9
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX67-GISEL-NEXT:    v_or_b32_e32 v7, v7, v8
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v8, 16, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v5
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v9, 16, v5
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v2, v2, v8
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v4, v1, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v3
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v3, v1, v9
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v6
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v5, 16, v7
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v2, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v7
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v6
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v2, v2, v4
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v3, v3, v5
; GFX67-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: clpeak_umad_pat_v4i16:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_mov_b32_e32 v6, 1
; GFX8-SDAG-NEXT:    v_add_u16_e32 v5, 1, v0
; GFX8-SDAG-NEXT:    v_add_u16_sdwa v0, v0, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-SDAG-NEXT:    v_lshrrev_b32_e32 v8, 16, v2
; GFX8-SDAG-NEXT:    v_add_u16_e32 v4, 1, v1
; GFX8-SDAG-NEXT:    v_add_u16_sdwa v1, v1, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-SDAG-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v9, v0, v8
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v0, v8, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v7, v1, v6
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v10, v5, v2
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v11, v4, v3
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v1, v6, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v4, v4, v3, v4
; GFX8-SDAG-NEXT:    v_mad_u16 v5, v5, v2, v5
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v0, v0, v8
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v1, v1, v6
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v2, v5, v2
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v3, v4, v3
; GFX8-SDAG-NEXT:    v_mad_u16 v4, v0, v9, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v5, v1, v7, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v7, v2, v10, v2
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v4, v0, v4
; GFX8-SDAG-NEXT:    v_mad_u16 v6, v3, v11, v3
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v5, v1, v5
; GFX8-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v2, v7, v2, v7
; GFX8-SDAG-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v2, v6, v3, v6
; GFX8-SDAG-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: clpeak_umad_pat_v4i16:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v5, 1
; GFX8-GISEL-NEXT:    v_add_u16_e32 v4, 1, v0
; GFX8-GISEL-NEXT:    v_add_u16_sdwa v0, v0, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_add_u16_e32 v6, 1, v1
; GFX8-GISEL-NEXT:    v_add_u16_sdwa v1, v1, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX8-GISEL-NEXT:    v_lshrrev_b32_e32 v7, 16, v3
; GFX8-GISEL-NEXT:    v_mad_u16 v8, v4, v2, v4
; GFX8-GISEL-NEXT:    v_mad_u16 v9, v0, v5, v0
; GFX8-GISEL-NEXT:    v_mad_u16 v10, v6, v3, v6
; GFX8-GISEL-NEXT:    v_mad_u16 v11, v1, v7, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v12, v8, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v13, v9, v5
; GFX8-GISEL-NEXT:    v_mad_u16 v4, v4, v2, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v0, v0, v5, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v14, v10, v3
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v15, v11, v7
; GFX8-GISEL-NEXT:    v_mad_u16 v6, v6, v3, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v1, v1, v7, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v2, v8, v2, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v5, v9, v5, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v4, v12, v4
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v13, v0
; GFX8-GISEL-NEXT:    v_mad_u16 v3, v10, v3, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v7, v11, v7, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v6, v14, v6
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v1, v15, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v2, v4, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u16_sdwa v0, v0, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v2, v6, v3
; GFX8-GISEL-NEXT:    v_mul_lo_u16_sdwa v1, v1, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: clpeak_umad_pat_v4i16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v1, v1, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v0, v0, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v4, v0, v2
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v5, v1, v3
; GFX9-SDAG-NEXT:    v_pk_add_u16 v1, v5, v1
; GFX9-SDAG-NEXT:    v_pk_add_u16 v0, v4, v0
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v2, v4, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v3, v5, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v4, v1, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v5, v0, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v5
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v1, v1, v4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: clpeak_umad_pat_v4i16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_pk_add_u16 v0, v0, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_add_u16 v1, v1, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v4, v0, v2
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v5, v1, v3
; GFX9-GISEL-NEXT:    v_pk_add_u16 v0, v4, v0
; GFX9-GISEL-NEXT:    v_pk_add_u16 v1, v5, v1
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX9-GISEL-NEXT:    v_pk_add_u16 v2, v4, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_add_u16 v3, v5, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_add_u16 v4, v0, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_add_u16 v5, v1, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v4
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v1, v1, v5
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: clpeak_umad_pat_v4i16:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v1, v1, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v0, v0, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v4, v1, v3
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v5, v0, v2
; GFX10-SDAG-NEXT:    v_pk_add_u16 v1, v4, v1
; GFX10-SDAG-NEXT:    v_pk_add_u16 v0, v5, v0
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v2, v5, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v3, v4, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v4, v1, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v5, v0, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v5
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v1, v1, v4
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: clpeak_umad_pat_v4i16:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_pk_add_u16 v0, v0, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_add_u16 v1, v1, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v4, v0, v2
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v5, v1, v3
; GFX10-GISEL-NEXT:    v_pk_add_u16 v0, v4, v0
; GFX10-GISEL-NEXT:    v_pk_add_u16 v1, v5, v1
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX10-GISEL-NEXT:    v_pk_add_u16 v2, v4, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_add_u16 v3, v5, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_add_u16 v4, v0, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_add_u16 v5, v1, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v4
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v1, v1, v5
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %y18 = add <4 x i16> %x, <i16 1, i16 1, i16 1, i16 1>
  %add = mul <4 x i16> %y18, %y
  %mul119 = add <4 x i16> %add, %y18
  %add2 = mul <4 x i16> %mul119, %y
  %add220 = add <4 x i16> %add, <i16 1, i16 1, i16 1, i16 1>
  %add422 = add <4 x i16> %add2, <i16 1, i16 1, i16 1, i16 1>
  %mul521 = mul <4 x i16> %add2, %add220
  %add6 = mul <4 x i16> %mul521, %add422
  ret <4 x i16> %add6
}

define <2 x i32> @clpeak_imad_pat_v2i32(<2 x i32> %x, <2 x i32> %y) {
; GFX67-SDAG-LABEL: clpeak_imad_pat_v2i32:
; GFX67-SDAG:       ; %bb.0: ; %entry
; GFX67-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v4, v0, v2
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v5, v1, v3
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v4, v0
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v5, v1
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v1, v1, v3
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v4
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v3, v1, v5
; GFX67-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v2, v0
; GFX67-SDAG-NEXT:    v_add_i32_e32 v3, vcc, v3, v1
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v1, v3, v1
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX67-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX67-GISEL-LABEL: clpeak_imad_pat_v2i32:
; GFX67-GISEL:       ; %bb.0: ; %entry
; GFX67-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v4, v0, v2
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v5, v1, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v4, v0
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v5, v1
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 1, v4
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 1, v5
; GFX67-GISEL-NEXT:    v_add_i32_e32 v4, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v2, v1, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v4
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v1, v2, v1
; GFX67-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: clpeak_imad_pat_v2i32:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, 1, v0
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, 1, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v4, v0, v2
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v5, v1, v3
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v4, v0
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v5, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v1, v1, v3
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v4
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v3, v1, v5
; GFX8-SDAG-NEXT:    v_add_u32_e32 v2, vcc, v2, v0
; GFX8-SDAG-NEXT:    v_add_u32_e32 v3, vcc, v3, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v1, v3, v1
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v1, v3
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: clpeak_imad_pat_v2i32:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, 1, v0
; GFX8-GISEL-NEXT:    v_add_u32_e32 v1, vcc, 1, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v4, v0, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v5, v1, v3
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v4, v0
; GFX8-GISEL-NEXT:    v_add_u32_e32 v1, vcc, v5, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v3
; GFX8-GISEL-NEXT:    v_add_u32_e32 v2, vcc, 1, v4
; GFX8-GISEL-NEXT:    v_add_u32_e32 v3, vcc, 1, v5
; GFX8-GISEL-NEXT:    v_add_u32_e32 v4, vcc, 1, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v2, v1, v3
; GFX8-GISEL-NEXT:    v_add_u32_e32 v1, vcc, 1, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v4
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v1, v2, v1
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-SDAG-LABEL: clpeak_imad_pat_v2i32:
; GFX900-SDAG:       ; %bb.0: ; %entry
; GFX900-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-SDAG-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v4, v0, v2
; GFX900-SDAG-NEXT:    v_add_u32_e32 v1, 1, v1
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v5, v1, v3
; GFX900-SDAG-NEXT:    v_add_u32_e32 v0, v4, v0
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX900-SDAG-NEXT:    v_add_u32_e32 v1, v5, v1
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v2, v1, v3
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[3:4], s[4:5], v0, v4, v[0:1]
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v2, v5, v[2:3]
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v3, v0, v[3:4]
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[1:2], s[4:5], v4, v2, v[4:5]
; GFX900-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-GISEL-LABEL: clpeak_imad_pat_v2i32:
; GFX900-GISEL:       ; %bb.0: ; %entry
; GFX900-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-GISEL-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX900-GISEL-NEXT:    v_add_u32_e32 v1, 1, v1
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v4, v0, v2
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v5, v1, v3
; GFX900-GISEL-NEXT:    v_add_u32_e32 v0, v4, v0
; GFX900-GISEL-NEXT:    v_add_u32_e32 v1, v5, v1
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v3
; GFX900-GISEL-NEXT:    v_add_u32_e32 v2, 1, v4
; GFX900-GISEL-NEXT:    v_add_u32_e32 v3, 1, v5
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v2
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v3, v1, v3
; GFX900-GISEL-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX900-GISEL-NEXT:    v_add_u32_e32 v1, 1, v1
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v1, v3, v1
; GFX900-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-SDAG-LABEL: clpeak_imad_pat_v2i32:
; GFX90A-SDAG:       ; %bb.0: ; %entry
; GFX90A-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v1, 1, v1
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v6, v0, v2
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v4, v1, v3
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v1, v4, v1
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v0, v6, v0
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v2, v1, v3
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v2, v4, v[2:3]
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[6:7], s[4:5], v0, v6, v[0:1]
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v6, v0, v[6:7]
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v4, v2, v[4:5]
; GFX90A-SDAG-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-GISEL-LABEL: clpeak_imad_pat_v2i32:
; GFX90A-GISEL:       ; %bb.0: ; %entry
; GFX90A-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v1, 1, v1
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v4, v0, v2
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v5, v1, v3
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v0, v4, v0
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v1, v5, v1
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v3
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v2, 1, v4
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v3, 1, v5
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v4, 1, v0
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v5, 1, v1
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v3
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v4
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v5
; GFX90A-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: clpeak_imad_pat_v2i32:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v1, 1, v1
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v4, v0, v2
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v5, v1, v3
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v0, v4, v0
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v1, v5, v1
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v2, v1, v3
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[3:4], null, v0, v4, v[0:1]
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[4:5], null, v2, v5, v[2:3]
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[0:1], null, v3, v0, v[3:4]
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[1:2], null, v4, v2, v[4:5]
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: clpeak_imad_pat_v2i32:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, 1, v1
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v4, v0, v2
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v5, v1, v3
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, v4, v0
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, v5, v1
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v3
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v2, 1, v4
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v3, 1, v5
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v2
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v3, v1, v3
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, 1, v1
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v1, v3, v1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %y18 = add <2 x i32> %x, <i32 1, i32 1>
  %add = mul <2 x i32> %y18, %y
  %mul119 = add <2 x i32> %add, %y18
  %add2 = mul <2 x i32> %mul119, %y
  %add220 = add <2 x i32> %add, <i32 1, i32 1>
  %add422 = add <2 x i32> %add2, <i32 1, i32 1>
  %mul521 = mul <2 x i32> %add2, %add220
  %add6 = mul <2 x i32> %mul521, %add422
  ret <2 x i32> %add6
}

define <3 x i32> @clpeak_imad_pat_v3i32(<3 x i32> %x, <3 x i32> %y) {
; GFX67-SDAG-LABEL: clpeak_imad_pat_v3i32:
; GFX67-SDAG:       ; %bb.0: ; %entry
; GFX67-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-SDAG-NEXT:    v_add_i32_e32 v2, vcc, 1, v2
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v6, v2, v5
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v7, v0, v3
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v8, v1, v4
; GFX67-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v6, v2
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v7, v0
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v8, v1
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v2, v2, v5
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v3
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v1, v1, v4
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v3, v2, v6
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v4, v0, v7
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v5, v1, v8
; GFX67-SDAG-NEXT:    v_add_i32_e32 v3, vcc, v3, v2
; GFX67-SDAG-NEXT:    v_add_i32_e32 v4, vcc, v4, v0
; GFX67-SDAG-NEXT:    v_add_i32_e32 v5, vcc, v5, v1
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v0, v4, v0
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v1, v5, v1
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v2, v3, v2
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v5
; GFX67-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v2, v3
; GFX67-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX67-GISEL-LABEL: clpeak_imad_pat_v3i32:
; GFX67-GISEL:       ; %bb.0: ; %entry
; GFX67-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 1, v2
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v6, v0, v3
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v7, v1, v4
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v8, v2, v5
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v6, v0
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v7, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v8, v2
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v3
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v4
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v2, v2, v5
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 1, v6
; GFX67-GISEL-NEXT:    v_add_i32_e32 v4, vcc, 1, v7
; GFX67-GISEL-NEXT:    v_add_i32_e32 v5, vcc, 1, v8
; GFX67-GISEL-NEXT:    v_add_i32_e32 v6, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_add_i32_e32 v7, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v3
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v4
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v3, v2, v5
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 1, v2
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v6
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v7
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v2, v3, v2
; GFX67-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: clpeak_imad_pat_v3i32:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_add_u32_e32 v2, vcc, 1, v2
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, 1, v1
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, 1, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v6, v2, v5
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v7, v0, v3
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v8, v1, v4
; GFX8-SDAG-NEXT:    v_add_u32_e32 v2, vcc, v6, v2
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v7, v0
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v8, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v2, v2, v5
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v3
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v1, v1, v4
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v3, v2, v6
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v4, v0, v7
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v5, v1, v8
; GFX8-SDAG-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; GFX8-SDAG-NEXT:    v_add_u32_e32 v4, vcc, v4, v0
; GFX8-SDAG-NEXT:    v_add_u32_e32 v5, vcc, v5, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v0, v4, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v1, v5, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v2, v3, v2
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v0, v4
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v1, v5
; GFX8-SDAG-NEXT:    v_add_u32_e32 v2, vcc, v2, v3
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: clpeak_imad_pat_v3i32:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, 1, v0
; GFX8-GISEL-NEXT:    v_add_u32_e32 v1, vcc, 1, v1
; GFX8-GISEL-NEXT:    v_add_u32_e32 v2, vcc, 1, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v6, v0, v3
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v7, v1, v4
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v8, v2, v5
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v6, v0
; GFX8-GISEL-NEXT:    v_add_u32_e32 v1, vcc, v7, v1
; GFX8-GISEL-NEXT:    v_add_u32_e32 v2, vcc, v8, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v3
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v4
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v2, v2, v5
; GFX8-GISEL-NEXT:    v_add_u32_e32 v3, vcc, 1, v6
; GFX8-GISEL-NEXT:    v_add_u32_e32 v4, vcc, 1, v7
; GFX8-GISEL-NEXT:    v_add_u32_e32 v5, vcc, 1, v8
; GFX8-GISEL-NEXT:    v_add_u32_e32 v6, vcc, 1, v0
; GFX8-GISEL-NEXT:    v_add_u32_e32 v7, vcc, 1, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v3
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v4
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v3, v2, v5
; GFX8-GISEL-NEXT:    v_add_u32_e32 v2, vcc, 1, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v6
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v7
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v2, v3, v2
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-SDAG-LABEL: clpeak_imad_pat_v3i32:
; GFX900-SDAG:       ; %bb.0: ; %entry
; GFX900-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-SDAG-NEXT:    v_add_u32_e32 v2, 1, v2
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v6, v2, v5
; GFX900-SDAG-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX900-SDAG-NEXT:    v_add_u32_e32 v1, 1, v1
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v7, v0, v3
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v8, v1, v4
; GFX900-SDAG-NEXT:    v_add_u32_e32 v2, v6, v2
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v5, v2, v5
; GFX900-SDAG-NEXT:    v_add_u32_e32 v0, v7, v0
; GFX900-SDAG-NEXT:    v_add_u32_e32 v1, v8, v1
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v3
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v2, v1, v4
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[3:4], s[4:5], v5, v6, v[5:6]
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[6:7], s[4:5], v0, v7, v[0:1]
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[7:8], s[4:5], v2, v8, v[2:3]
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v6, v0, v[6:7]
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[1:2], s[4:5], v7, v2, v[7:8]
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v3, v5, v[3:4]
; GFX900-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-GISEL-LABEL: clpeak_imad_pat_v3i32:
; GFX900-GISEL:       ; %bb.0: ; %entry
; GFX900-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-GISEL-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX900-GISEL-NEXT:    v_add_u32_e32 v1, 1, v1
; GFX900-GISEL-NEXT:    v_add_u32_e32 v2, 1, v2
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v6, v0, v3
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v7, v1, v4
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v8, v2, v5
; GFX900-GISEL-NEXT:    v_add_u32_e32 v0, v6, v0
; GFX900-GISEL-NEXT:    v_add_u32_e32 v1, v7, v1
; GFX900-GISEL-NEXT:    v_add_u32_e32 v2, v8, v2
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v3
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v4
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v2, v2, v5
; GFX900-GISEL-NEXT:    v_add_u32_e32 v3, 1, v6
; GFX900-GISEL-NEXT:    v_add_u32_e32 v4, 1, v7
; GFX900-GISEL-NEXT:    v_add_u32_e32 v5, 1, v8
; GFX900-GISEL-NEXT:    v_add_u32_e32 v6, 1, v0
; GFX900-GISEL-NEXT:    v_add_u32_e32 v7, 1, v1
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v3
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v4
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v3, v2, v5
; GFX900-GISEL-NEXT:    v_add_u32_e32 v2, 1, v2
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v6
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v7
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v2, v3, v2
; GFX900-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-SDAG-LABEL: clpeak_imad_pat_v3i32:
; GFX90A-SDAG:       ; %bb.0: ; %entry
; GFX90A-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v1, 1, v1
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v2, 1, v2
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v10, v0, v3
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v8, v1, v4
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v6, v2, v5
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v1, v8, v1
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v0, v10, v0
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v7, v6, v2
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v3
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v2, v1, v4
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v4, v7, v5
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[8:9], s[4:5], v2, v8, v[2:3]
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[10:11], s[4:5], v0, v10, v[0:1]
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[6:7], s[4:5], v4, v6, v[4:5]
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v10, v0, v[10:11]
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[8:9], s[4:5], v8, v2, v[8:9]
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v6, v4, v[6:7]
; GFX90A-SDAG-NEXT:    v_mov_b32_e32 v1, v8
; GFX90A-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-GISEL-LABEL: clpeak_imad_pat_v3i32:
; GFX90A-GISEL:       ; %bb.0: ; %entry
; GFX90A-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v1, 1, v1
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v2, 1, v2
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v6, v0, v3
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v7, v1, v4
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v8, v2, v5
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v0, v6, v0
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v1, v7, v1
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v2, v8, v2
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v3
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v4
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v2, v2, v5
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v3, 1, v6
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v4, 1, v7
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v5, 1, v8
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v6, 1, v0
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v7, 1, v1
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v8, 1, v2
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v3
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v4
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v2, v2, v5
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v6
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v7
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v2, v2, v8
; GFX90A-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: clpeak_imad_pat_v3i32:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v1, 1, v1
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v2, 1, v2
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v6, v0, v3
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v7, v1, v4
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v8, v2, v5
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v0, v6, v0
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v1, v7, v1
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v9, v8, v2
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v3
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v2, v1, v4
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v3, v9, v5
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[4:5], null, v0, v6, v[0:1]
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[5:6], null, v2, v7, v[2:3]
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[6:7], null, v3, v8, v[3:4]
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[0:1], null, v4, v0, v[4:5]
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[1:2], null, v5, v2, v[5:6]
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[2:3], null, v6, v3, v[6:7]
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: clpeak_imad_pat_v3i32:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, 1, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v2, 1, v2
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v6, v0, v3
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v7, v1, v4
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v8, v2, v5
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, v6, v0
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, v7, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v2, v8, v2
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v3
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v4
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v2, v2, v5
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v3, 1, v6
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v4, 1, v7
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v5, 1, v8
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v3, v0, v3
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v4, v1, v4
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v5, v2, v5
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, 1, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v2, 1, v2
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v0, v3, v0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v1, v4, v1
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v2, v5, v2
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %y48 = add <3 x i32> %x, <i32 1, i32 1, i32 1>
  %add = mul <3 x i32> %y48, %y
  %mul1249 = add <3 x i32> %add, %y48
  %add15 = mul <3 x i32> %mul1249, %y
  %add1550 = add <3 x i32> %add, <i32 1, i32 1, i32 1>
  %add2452 = add <3 x i32> %add15, <i32 1, i32 1, i32 1>
  %mul3051 = mul <3 x i32> %add15, %add1550
  %add33 = mul <3 x i32> %mul3051, %add2452
  ret <3 x i32> %add33
}

define <4 x i32> @clpeak_imad_pat_v4i32(<4 x i32> %x, <4 x i32> %y) {
; GFX67-SDAG-LABEL: clpeak_imad_pat_v4i32:
; GFX67-SDAG:       ; %bb.0: ; %entry
; GFX67-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-SDAG-NEXT:    v_add_i32_e32 v3, vcc, 1, v3
; GFX67-SDAG-NEXT:    v_add_i32_e32 v2, vcc, 1, v2
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v8, v0, v4
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v9, v3, v7
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v10, v1, v5
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v11, v2, v6
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v8, v0
; GFX67-SDAG-NEXT:    v_add_i32_e32 v3, vcc, v9, v3
; GFX67-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v11, v2
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v10, v1
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v3, v3, v7
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v2, v2, v6
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v4
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v1, v1, v5
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v4, v3, v9
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v5, v2, v11
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v6, v0, v8
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v7, v1, v10
; GFX67-SDAG-NEXT:    v_add_i32_e32 v4, vcc, v4, v3
; GFX67-SDAG-NEXT:    v_add_i32_e32 v5, vcc, v5, v2
; GFX67-SDAG-NEXT:    v_add_i32_e32 v6, vcc, v6, v0
; GFX67-SDAG-NEXT:    v_add_i32_e32 v7, vcc, v7, v1
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v0, v6, v0
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v1, v7, v1
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v2, v5, v2
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v3, v4, v3
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v6
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v7
; GFX67-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v2, v5
; GFX67-SDAG-NEXT:    v_add_i32_e32 v3, vcc, v3, v4
; GFX67-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX67-GISEL-LABEL: clpeak_imad_pat_v4i32:
; GFX67-GISEL:       ; %bb.0: ; %entry
; GFX67-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 1, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 1, v3
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v8, v0, v4
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v9, v1, v5
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v10, v2, v6
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v11, v3, v7
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v8, v0
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v9, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v10, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, v11, v3
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v4
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v5
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v2, v2, v6
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v3, v3, v7
; GFX67-GISEL-NEXT:    v_add_i32_e32 v4, vcc, 1, v8
; GFX67-GISEL-NEXT:    v_add_i32_e32 v5, vcc, 1, v9
; GFX67-GISEL-NEXT:    v_add_i32_e32 v6, vcc, 1, v10
; GFX67-GISEL-NEXT:    v_add_i32_e32 v7, vcc, 1, v11
; GFX67-GISEL-NEXT:    v_add_i32_e32 v8, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_add_i32_e32 v9, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v10, vcc, 1, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v11, vcc, 1, v3
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v4
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v5
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v2, v2, v6
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v3, v3, v7
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v8
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v9
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v2, v2, v10
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v3, v3, v11
; GFX67-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: clpeak_imad_pat_v4i32:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_add_u32_e32 v3, vcc, 1, v3
; GFX8-SDAG-NEXT:    v_add_u32_e32 v2, vcc, 1, v2
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, 1, v1
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, 1, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v8, v0, v4
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v9, v3, v7
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v10, v1, v5
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v11, v2, v6
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v8, v0
; GFX8-SDAG-NEXT:    v_add_u32_e32 v3, vcc, v9, v3
; GFX8-SDAG-NEXT:    v_add_u32_e32 v2, vcc, v11, v2
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v10, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v3, v3, v7
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v2, v2, v6
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v4
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v1, v1, v5
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v4, v3, v9
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v5, v2, v11
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v6, v0, v8
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v7, v1, v10
; GFX8-SDAG-NEXT:    v_add_u32_e32 v4, vcc, v4, v3
; GFX8-SDAG-NEXT:    v_add_u32_e32 v5, vcc, v5, v2
; GFX8-SDAG-NEXT:    v_add_u32_e32 v6, vcc, v6, v0
; GFX8-SDAG-NEXT:    v_add_u32_e32 v7, vcc, v7, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v0, v6, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v1, v7, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v2, v5, v2
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v3, v4, v3
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v0, v6
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v1, v7
; GFX8-SDAG-NEXT:    v_add_u32_e32 v2, vcc, v2, v5
; GFX8-SDAG-NEXT:    v_add_u32_e32 v3, vcc, v3, v4
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: clpeak_imad_pat_v4i32:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, 1, v0
; GFX8-GISEL-NEXT:    v_add_u32_e32 v1, vcc, 1, v1
; GFX8-GISEL-NEXT:    v_add_u32_e32 v2, vcc, 1, v2
; GFX8-GISEL-NEXT:    v_add_u32_e32 v3, vcc, 1, v3
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v8, v0, v4
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v9, v1, v5
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v10, v2, v6
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v11, v3, v7
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v8, v0
; GFX8-GISEL-NEXT:    v_add_u32_e32 v1, vcc, v9, v1
; GFX8-GISEL-NEXT:    v_add_u32_e32 v2, vcc, v10, v2
; GFX8-GISEL-NEXT:    v_add_u32_e32 v3, vcc, v11, v3
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v4
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v5
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v2, v2, v6
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v3, v3, v7
; GFX8-GISEL-NEXT:    v_add_u32_e32 v4, vcc, 1, v8
; GFX8-GISEL-NEXT:    v_add_u32_e32 v5, vcc, 1, v9
; GFX8-GISEL-NEXT:    v_add_u32_e32 v6, vcc, 1, v10
; GFX8-GISEL-NEXT:    v_add_u32_e32 v7, vcc, 1, v11
; GFX8-GISEL-NEXT:    v_add_u32_e32 v8, vcc, 1, v0
; GFX8-GISEL-NEXT:    v_add_u32_e32 v9, vcc, 1, v1
; GFX8-GISEL-NEXT:    v_add_u32_e32 v10, vcc, 1, v2
; GFX8-GISEL-NEXT:    v_add_u32_e32 v11, vcc, 1, v3
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v4
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v5
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v2, v2, v6
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v3, v3, v7
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v8
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v9
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v2, v2, v10
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v3, v3, v11
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-SDAG-LABEL: clpeak_imad_pat_v4i32:
; GFX900-SDAG:       ; %bb.0: ; %entry
; GFX900-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-SDAG-NEXT:    v_add_u32_e32 v3, 1, v3
; GFX900-SDAG-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX900-SDAG-NEXT:    v_add_u32_e32 v2, 1, v2
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v8, v3, v7
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v11, v0, v4
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v9, v2, v6
; GFX900-SDAG-NEXT:    v_add_u32_e32 v1, 1, v1
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v10, v1, v5
; GFX900-SDAG-NEXT:    v_add_u32_e32 v3, v8, v3
; GFX900-SDAG-NEXT:    v_add_u32_e32 v0, v11, v0
; GFX900-SDAG-NEXT:    v_add_u32_e32 v12, v9, v2
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v4
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v4, v3, v7
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v3, v12, v6
; GFX900-SDAG-NEXT:    v_add_u32_e32 v1, v10, v1
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v2, v1, v5
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[5:6], s[4:5], v4, v8, v[4:5]
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[6:7], s[4:5], v3, v9, v[3:4]
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[7:8], s[4:5], v0, v11, v[0:1]
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[8:9], s[4:5], v2, v10, v[2:3]
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v7, v0, v[7:8]
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[1:2], s[4:5], v8, v2, v[8:9]
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v6, v3, v[6:7]
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[3:4], s[4:5], v5, v4, v[5:6]
; GFX900-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: clpeak_imad_pat_v4i32:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX9-GISEL-NEXT:    v_add_u32_e32 v1, 1, v1
; GFX9-GISEL-NEXT:    v_add_u32_e32 v2, 1, v2
; GFX9-GISEL-NEXT:    v_add_u32_e32 v3, 1, v3
; GFX9-GISEL-NEXT:    v_mul_lo_u32 v8, v0, v4
; GFX9-GISEL-NEXT:    v_mul_lo_u32 v9, v1, v5
; GFX9-GISEL-NEXT:    v_mul_lo_u32 v10, v2, v6
; GFX9-GISEL-NEXT:    v_mul_lo_u32 v11, v3, v7
; GFX9-GISEL-NEXT:    v_add_u32_e32 v0, v8, v0
; GFX9-GISEL-NEXT:    v_add_u32_e32 v1, v9, v1
; GFX9-GISEL-NEXT:    v_add_u32_e32 v2, v10, v2
; GFX9-GISEL-NEXT:    v_add_u32_e32 v3, v11, v3
; GFX9-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v4
; GFX9-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v5
; GFX9-GISEL-NEXT:    v_mul_lo_u32 v2, v2, v6
; GFX9-GISEL-NEXT:    v_mul_lo_u32 v3, v3, v7
; GFX9-GISEL-NEXT:    v_add_u32_e32 v4, 1, v8
; GFX9-GISEL-NEXT:    v_add_u32_e32 v5, 1, v9
; GFX9-GISEL-NEXT:    v_add_u32_e32 v6, 1, v10
; GFX9-GISEL-NEXT:    v_add_u32_e32 v7, 1, v11
; GFX9-GISEL-NEXT:    v_add_u32_e32 v8, 1, v0
; GFX9-GISEL-NEXT:    v_add_u32_e32 v9, 1, v1
; GFX9-GISEL-NEXT:    v_add_u32_e32 v10, 1, v2
; GFX9-GISEL-NEXT:    v_add_u32_e32 v11, 1, v3
; GFX9-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v4
; GFX9-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v5
; GFX9-GISEL-NEXT:    v_mul_lo_u32 v2, v2, v6
; GFX9-GISEL-NEXT:    v_mul_lo_u32 v3, v3, v7
; GFX9-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v8
; GFX9-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v9
; GFX9-GISEL-NEXT:    v_mul_lo_u32 v2, v2, v10
; GFX9-GISEL-NEXT:    v_mul_lo_u32 v3, v3, v11
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-SDAG-LABEL: clpeak_imad_pat_v4i32:
; GFX90A-SDAG:       ; %bb.0: ; %entry
; GFX90A-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v3, 1, v3
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v2, 1, v2
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v1, 1, v1
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v14, v0, v4
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v12, v1, v5
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v10, v2, v6
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v8, v3, v7
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v3, v8, v3
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v9, v10, v2
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v1, v12, v1
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v0, v14, v0
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v4
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v2, v1, v5
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v4, v9, v6
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v6, v3, v7
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[8:9], s[4:5], v6, v8, v[6:7]
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[10:11], s[4:5], v4, v10, v[4:5]
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[12:13], s[4:5], v2, v12, v[2:3]
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[14:15], s[4:5], v0, v14, v[0:1]
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v14, v0, v[14:15]
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[12:13], s[4:5], v12, v2, v[12:13]
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v10, v4, v[10:11]
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v8, v6, v[8:9]
; GFX90A-SDAG-NEXT:    v_mov_b32_e32 v1, v12
; GFX90A-SDAG-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: clpeak_imad_pat_v4i32:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v1, 1, v1
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v2, 1, v2
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v3, 1, v3
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v8, v0, v4
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v9, v1, v5
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v10, v2, v6
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v11, v3, v7
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v0, v8, v0
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v1, v9, v1
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v12, v10, v2
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v4
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v4, v11, v3
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v2, v1, v5
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v3, v12, v6
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v4, v4, v7
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[5:6], null, v0, v8, v[0:1]
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[6:7], null, v2, v9, v[2:3]
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[7:8], null, v3, v10, v[3:4]
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[8:9], null, v4, v11, v[4:5]
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[0:1], null, v5, v0, v[5:6]
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[1:2], null, v6, v2, v[6:7]
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[2:3], null, v7, v3, v[7:8]
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[3:4], null, v8, v4, v[8:9]
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: clpeak_imad_pat_v4i32:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, 1, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v2, 1, v2
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v3, 1, v3
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v8, v0, v4
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v9, v1, v5
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v10, v2, v6
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v11, v3, v7
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, v8, v0
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, v9, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v2, v10, v2
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v3, v11, v3
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v4
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v5
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v2, v2, v6
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v3, v3, v7
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v4, 1, v8
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v5, 1, v9
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v6, 1, v10
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v7, 1, v11
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v8, 1, v0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v4
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v4, v1, v5
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v5, v2, v6
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v6, v3, v7
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, 1, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v2, 1, v2
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v3, 1, v3
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v8
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v1, v4, v1
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v2, v5, v2
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v3, v6, v3
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %y18 = add <4 x i32> %x, <i32 1, i32 1, i32 1, i32 1>
  %add = mul <4 x i32> %y18, %y
  %mul119 = add <4 x i32> %add, %y18
  %add2 = mul <4 x i32> %mul119, %y
  %add220 = add <4 x i32> %add, <i32 1, i32 1, i32 1, i32 1>
  %add422 = add <4 x i32> %add2, <i32 1, i32 1, i32 1, i32 1>
  %mul521 = mul <4 x i32> %add2, %add220
  %add6 = mul <4 x i32> %mul521, %add422
  ret <4 x i32> %add6
}

define i32 @clpeak_imad_pat_i24(i32 %x, i32 %y) {
; GFX67-SDAG-LABEL: clpeak_imad_pat_i24:
; GFX67-SDAG:       ; %bb.0: ; %entry
; GFX67-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 24
; GFX67-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 24
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v2, v1, v0
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v2, v0
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v1, v0, v2
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v0
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX67-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX67-GISEL-LABEL: clpeak_imad_pat_i24:
; GFX67-GISEL:       ; %bb.0: ; %entry
; GFX67-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 24
; GFX67-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 24
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v2, v1, v0
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v2, v0
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v2
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX67-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: clpeak_imad_pat_i24:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 24
; GFX8-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 24
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, 1, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v2, v1, v0
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v2, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v1, v0, v2
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v1, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v0, v1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: clpeak_imad_pat_i24:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 24
; GFX8-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 24
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, 1, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v2, v1, v0
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v2, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_add_u32_e32 v1, vcc, 1, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, 1, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-SDAG-LABEL: clpeak_imad_pat_i24:
; GFX900-SDAG:       ; %bb.0: ; %entry
; GFX900-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 24
; GFX900-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 24
; GFX900-SDAG-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v2, v1, v0
; GFX900-SDAG-NEXT:    v_add_u32_e32 v0, v2, v0
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[1:2], s[4:5], v0, v2, v[0:1]
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v1, v0, v[1:2]
; GFX900-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-GISEL-LABEL: clpeak_imad_pat_i24:
; GFX900-GISEL:       ; %bb.0: ; %entry
; GFX900-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 24
; GFX900-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 24
; GFX900-GISEL-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v2, v1, v0
; GFX900-GISEL-NEXT:    v_add_u32_e32 v0, v2, v0
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX900-GISEL-NEXT:    v_add_u32_e32 v1, 1, v2
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX900-GISEL-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX900-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-SDAG-LABEL: clpeak_imad_pat_i24:
; GFX90A-SDAG:       ; %bb.0: ; %entry
; GFX90A-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 24
; GFX90A-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 24
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v2, v1, v0
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v0, v2, v0
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v0, v2, v[0:1]
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v2, v0, v[2:3]
; GFX90A-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-GISEL-LABEL: clpeak_imad_pat_i24:
; GFX90A-GISEL:       ; %bb.0: ; %entry
; GFX90A-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 24
; GFX90A-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 24
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v2, v1, v0
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v0, v2, v0
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v1, 1, v2
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v2, 1, v0
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX90A-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: clpeak_imad_pat_i24:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 24
; GFX10-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 24
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v2, v1, v0
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v0, v2, v0
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[1:2], null, v0, v2, v[0:1]
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[0:1], null, v1, v0, v[1:2]
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: clpeak_imad_pat_i24:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 24
; GFX10-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 24
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v2, v1, v0
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, v2, v0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, 1, v2
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %shl = shl i32 %x, 8
  %shr = ashr exact i32 %shl, 8
  %shl1 = shl i32 %y, 8
  %shr2 = ashr exact i32 %shl1, 8
  %shr222 = add nsw i32 %shr, 1
  %add = mul i32 %shr2, %shr222
  %mul323 = add i32 %add, %shr222
  %add4 = mul i32 %mul323, %shr2
  %add424 = add i32 %add, 1
  %add626 = add i32 %add4, 1
  %mul725 = mul i32 %add4, %add424
  %add8 = mul i32 %mul725, %add626
  ret i32 %add8
}

define i32 @clpeak_imad_pat_u24(i32 %x, i32 %y) {
; GFX67-SDAG-LABEL: clpeak_imad_pat_u24:
; GFX67-SDAG:       ; %bb.0: ; %entry
; GFX67-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffffff, v1
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v2, v1, v0
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v2, v0
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v1, v0, v2
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v0
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX67-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX67-GISEL-LABEL: clpeak_imad_pat_u24:
; GFX67-GISEL:       ; %bb.0: ; %entry
; GFX67-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffffff, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v2, v1, v0
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v2, v0
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v2
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX67-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: clpeak_imad_pat_u24:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, 0xffffff, v1
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, 1, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v2, v1, v0
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v2, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v1, v0, v2
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v1, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v0, v1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: clpeak_imad_pat_u24:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, 0xffffff, v1
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, 1, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v2, v1, v0
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v2, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_add_u32_e32 v1, vcc, 1, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, 1, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-SDAG-LABEL: clpeak_imad_pat_u24:
; GFX900-SDAG:       ; %bb.0: ; %entry
; GFX900-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-SDAG-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; GFX900-SDAG-NEXT:    v_and_b32_e32 v1, 0xffffff, v1
; GFX900-SDAG-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v2, v1, v0
; GFX900-SDAG-NEXT:    v_add_u32_e32 v0, v2, v0
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[1:2], s[4:5], v0, v2, v[0:1]
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v1, v0, v[1:2]
; GFX900-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-GISEL-LABEL: clpeak_imad_pat_u24:
; GFX900-GISEL:       ; %bb.0: ; %entry
; GFX900-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-GISEL-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; GFX900-GISEL-NEXT:    v_and_b32_e32 v1, 0xffffff, v1
; GFX900-GISEL-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v2, v1, v0
; GFX900-GISEL-NEXT:    v_add_u32_e32 v0, v2, v0
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX900-GISEL-NEXT:    v_add_u32_e32 v1, 1, v2
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX900-GISEL-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX900-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-SDAG-LABEL: clpeak_imad_pat_u24:
; GFX90A-SDAG:       ; %bb.0: ; %entry
; GFX90A-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-SDAG-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; GFX90A-SDAG-NEXT:    v_and_b32_e32 v1, 0xffffff, v1
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v2, v1, v0
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v0, v2, v0
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v0, v2, v[0:1]
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v2, v0, v[2:3]
; GFX90A-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-GISEL-LABEL: clpeak_imad_pat_u24:
; GFX90A-GISEL:       ; %bb.0: ; %entry
; GFX90A-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-GISEL-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; GFX90A-GISEL-NEXT:    v_and_b32_e32 v1, 0xffffff, v1
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v2, v1, v0
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v0, v2, v0
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v1, 1, v2
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v2, 1, v0
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX90A-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: clpeak_imad_pat_u24:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, 0xffffff, v1
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v2, v1, v0
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v0, v2, v0
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[1:2], null, v0, v2, v[0:1]
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[0:1], null, v1, v0, v[1:2]
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: clpeak_imad_pat_u24:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, 0xffffff, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v2, v1, v0
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, v2, v0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, 1, v2
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %shl = and i32 %x, 16777215
  %shl1 = and i32 %y, 16777215
  %shl122 = add nuw nsw i32 %shl, 1
  %add = mul i32 %shl1, %shl122
  %mul323 = add i32 %add, %shl122
  %add4 = mul i32 %mul323, %shl1
  %add424 = add i32 %add, 1
  %add626 = add i32 %add4, 1
  %mul725 = mul i32 %add4, %add424
  %add8 = mul i32 %mul725, %add626
  ret i32 %add8
}

define signext i8 @clpeak_imad_pat_i8(i8 signext %x, i8 signext %y) {
; GFX67-SDAG-LABEL: clpeak_imad_pat_i8:
; GFX67-SDAG:       ; %bb.0: ; %entry
; GFX67-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xff, v1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v3, v0, v2
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v4, v1, v3
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v0, v2, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xff, v4
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v1, v1, v3, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v0, v0, v1
; GFX67-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX67-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX67-GISEL-LABEL: clpeak_imad_pat_i8:
; GFX67-GISEL:       ; %bb.0: ; %entry
; GFX67-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v1
; GFX67-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX67-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: clpeak_imad_pat_i8:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v0, v1, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v0, v1, v0
; GFX8-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: clpeak_imad_pat_i8:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u16_e32 v0, 1, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v2, v0, v1
; GFX8-GISEL-NEXT:    v_add_u16_e32 v3, 1, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v4, v3, v2
; GFX8-GISEL-NEXT:    v_mad_u16 v0, v0, v1, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v0, v4
; GFX8-GISEL-NEXT:    v_mad_u16 v1, v3, v2, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: clpeak_imad_pat_i8:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v0, v1, v0, v1
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v1, v0, v1, v0
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v0, v1, v0, v1
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v0, v0, v1, v0
; GFX9-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: clpeak_imad_pat_i8:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_add_u16_e32 v0, 1, v0
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v2, v0, v1
; GFX9-GISEL-NEXT:    v_add_u16_e32 v3, 1, v1
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v4, v3, v2
; GFX9-GISEL-NEXT:    v_mad_legacy_u16 v0, v0, v1, 1
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v0, v4
; GFX9-GISEL-NEXT:    v_mad_legacy_u16 v1, v3, v2, 1
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: clpeak_imad_pat_i8:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX10-SDAG-NEXT:    v_mad_u16 v1, v0, v1, v0
; GFX10-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX10-SDAG-NEXT:    v_mad_u16 v0, v0, v1, v0
; GFX10-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: clpeak_imad_pat_i8:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, 1
; GFX10-GISEL-NEXT:    v_add_nc_u16 v2, v1, 1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v1, v2, v0
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, 1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u16 v1, v1, 1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %conv33 = add i8 %x, 1
  %add = mul i8 %conv33, %y
  %conv434 = add i8 %y, 1
  %add8 = mul i8 %conv434, %add
  %conv1035 = add i8 %add, 1
  %add14 = mul i8 %conv1035, %add8
  %conv1636 = add i8 %add8, 1
  %add20 = mul i8 %add14, %conv1636
  ret i8 %add20
}

define <2 x i8> @clpeak_imad_pat_v2i8(<2 x i8> %x, <2 x i8> %y) {
; GFX67-SDAG-LABEL: clpeak_imad_pat_v2i8:
; GFX67-SDAG:       ; %bb.0: ; %entry
; GFX67-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v5, 0xff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v1, v5, v3, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v6, v5, v3
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v4, v2, v0
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v1, v1, v3
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v3, v4, v2, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX67-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 8, v6
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v5, v0, v2
; GFX67-SDAG-NEXT:    v_or_b32_e32 v3, v4, v3
; GFX67-SDAG-NEXT:    s_movk_i32 s4, 0x100
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v0, v2, 1
; GFX67-SDAG-NEXT:    v_add_i32_e32 v3, vcc, s4, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX67-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v1
; GFX67-SDAG-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX67-SDAG-NEXT:    v_bfe_u32 v2, v3, 8, 8
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xff, v5
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 0x100, v0
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v3, v4, v3
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v1, v1, v2
; GFX67-SDAG-NEXT:    v_bfe_u32 v2, v0, 8, 8
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v0, v3, v0
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v1, v1, v2
; GFX67-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX67-GISEL-LABEL: clpeak_imad_pat_v2i8:
; GFX67-GISEL:       ; %bb.0: ; %entry
; GFX67-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v4, v4, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v5, 0xff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v5, v5, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v4, v0
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v5, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 1, v4
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 1, v5
; GFX67-GISEL-NEXT:    v_add_i32_e32 v4, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v5, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xff, v3
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xff, v4
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xff, v5
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v2
; GFX67-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: clpeak_imad_pat_v2i8:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_add_u16_e32 v1, 1, v1
; GFX8-SDAG-NEXT:    v_add_u16_e32 v0, 1, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v4, v1, v3
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v1, v3, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v5, v0, v2
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v0, v2, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v1, v1, v3
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_mad_u16 v3, v1, v4, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v2, v0, v5, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v3, v1, v3
; GFX8-SDAG-NEXT:    v_lshlrev_b16_e32 v3, 8, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v2, v0, v2
; GFX8-SDAG-NEXT:    v_or_b32_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: clpeak_imad_pat_v2i8:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u16_e32 v0, 1, v0
; GFX8-GISEL-NEXT:    v_add_u16_e32 v1, 1, v1
; GFX8-GISEL-NEXT:    v_mad_u16 v4, v0, v2, v0
; GFX8-GISEL-NEXT:    v_mad_u16 v5, v1, v3, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v6, v4, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v7, v5, v3
; GFX8-GISEL-NEXT:    v_mad_u16 v0, v0, v2, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v1, v1, v3, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v2, v4, v2, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v3, v5, v3, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v6, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v1, v7, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v1, v1, v3
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: clpeak_imad_pat_v2i8:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_u16_e32 v1, 1, v1
; GFX9-SDAG-NEXT:    v_add_u16_e32 v0, 1, v0
; GFX9-SDAG-NEXT:    v_mul_lo_u16_e32 v4, v1, v3
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v1, v1, v3, v1
; GFX9-SDAG-NEXT:    v_mul_lo_u16_e32 v5, v0, v2
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v0, v0, v2, v0
; GFX9-SDAG-NEXT:    v_mul_lo_u16_e32 v1, v1, v3
; GFX9-SDAG-NEXT:    v_mul_lo_u16_e32 v0, v0, v2
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v3, v1, v4, v1
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v2, v0, v5, v0
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v1, v3, v1, v3
; GFX9-SDAG-NEXT:    v_lshlrev_b16_e32 v3, 8, v1
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v0, v2, v0, v2
; GFX9-SDAG-NEXT:    v_or_b32_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: clpeak_imad_pat_v2i8:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_add_u16_e32 v0, 1, v0
; GFX9-GISEL-NEXT:    v_add_u16_e32 v1, 1, v1
; GFX9-GISEL-NEXT:    v_mad_legacy_u16 v4, v0, v2, v0
; GFX9-GISEL-NEXT:    v_mad_legacy_u16 v5, v1, v3, v1
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v6, v4, v2
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v7, v5, v3
; GFX9-GISEL-NEXT:    v_mad_legacy_u16 v0, v0, v2, 1
; GFX9-GISEL-NEXT:    v_mad_legacy_u16 v1, v1, v3, 1
; GFX9-GISEL-NEXT:    v_mad_legacy_u16 v2, v4, v2, 1
; GFX9-GISEL-NEXT:    v_mad_legacy_u16 v3, v5, v3, 1
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v6, v0
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v1, v7, v1
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v1, v1, v3
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: clpeak_imad_pat_v2i8:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_nc_u16 v1, v1, 1
; GFX10-SDAG-NEXT:    v_add_nc_u16 v0, v0, 1
; GFX10-SDAG-NEXT:    v_mad_u16 v4, v1, v3, v1
; GFX10-SDAG-NEXT:    v_mul_lo_u16 v1, v1, v3
; GFX10-SDAG-NEXT:    v_mad_u16 v5, v0, v2, v0
; GFX10-SDAG-NEXT:    v_mul_lo_u16 v0, v0, v2
; GFX10-SDAG-NEXT:    v_mul_lo_u16 v3, v4, v3
; GFX10-SDAG-NEXT:    v_mul_lo_u16 v2, v5, v2
; GFX10-SDAG-NEXT:    v_mad_u16 v1, v3, v1, v3
; GFX10-SDAG-NEXT:    v_mad_u16 v0, v2, v0, v2
; GFX10-SDAG-NEXT:    v_mad_u16 v1, v1, v3, v1
; GFX10-SDAG-NEXT:    v_mad_u16 v0, v0, v2, v0
; GFX10-SDAG-NEXT:    v_lshlrev_b16 v2, 8, v1
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX10-SDAG-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: clpeak_imad_pat_v2i8:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, 1
; GFX10-GISEL-NEXT:    v_add_nc_u16 v1, v1, 1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v4, v0, v2
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v5, v1, v3
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v4, v0
; GFX10-GISEL-NEXT:    v_add_nc_u16 v1, v5, v1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v0, v0, v2
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v1, v1, v3
; GFX10-GISEL-NEXT:    v_add_nc_u16 v2, v4, 1
; GFX10-GISEL-NEXT:    v_add_nc_u16 v3, v5, 1
; GFX10-GISEL-NEXT:    v_add_nc_u16 v4, v0, 1
; GFX10-GISEL-NEXT:    v_add_nc_u16 v5, v1, 1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v0, v0, v2
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v1, v1, v3
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v0, v0, v4
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v1, v1, v5
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %y18 = add <2 x i8> %x, <i8 1, i8 1>
  %add = mul <2 x i8> %y18, %y
  %mul119 = add <2 x i8> %add, %y18
  %add2 = mul <2 x i8> %mul119, %y
  %add220 = add <2 x i8> %add, <i8 1, i8 1>
  %add422 = add <2 x i8> %add2, <i8 1, i8 1>
  %mul521 = mul <2 x i8> %add2, %add220
  %add6 = mul <2 x i8> %mul521, %add422
  ret <2 x i8> %add6
}

define i64 @clpeak_imad_pat_i64(i64 %x, i64 %y) {
; GFX6-SDAG-LABEL: clpeak_imad_pat_i64:
; GFX6-SDAG:       ; %bb.0: ; %entry
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v4, v0, v3
; GFX6-SDAG-NEXT:    v_mul_hi_u32 v5, v0, v2
; GFX6-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v6, v1, v2
; GFX6-SDAG-NEXT:    v_add_i32_e32 v4, vcc, v5, v4
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v5, v0, v2
; GFX6-SDAG-NEXT:    v_add_i32_e32 v4, vcc, v4, v6
; GFX6-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v5, v0
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v3, v0, v3
; GFX6-SDAG-NEXT:    v_mul_hi_u32 v6, v0, v2
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX6-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, v4, v1, vcc
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v1, v1, v2
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v4
; GFX6-SDAG-NEXT:    v_mul_hi_u32 v4, v0, v5
; GFX6-SDAG-NEXT:    v_add_i32_e32 v3, vcc, v6, v3
; GFX6-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v3, v1
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v3, v1, v5
; GFX6-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v4, v2
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v4, v0, v5
; GFX6-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v2, v3
; GFX6-SDAG-NEXT:    v_add_i32_e32 v3, vcc, v4, v0
; GFX6-SDAG-NEXT:    v_addc_u32_e32 v2, vcc, v2, v1, vcc
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v1, v3, v1
; GFX6-SDAG-NEXT:    v_mul_hi_u32 v4, v3, v0
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v5, v2, v0
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v0, v3, v0
; GFX6-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v4, v1
; GFX6-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v5
; GFX6-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v3
; GFX6-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, v1, v2, vcc
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: clpeak_imad_pat_i64:
; GFX6-GISEL:       ; %bb.0: ; %entry
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX6-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v4, v1, v2
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v5, v0, v3
; GFX6-GISEL-NEXT:    v_mul_hi_u32 v7, v0, v2
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v6, v0, v2
; GFX6-GISEL-NEXT:    v_add_i32_e32 v4, vcc, v4, v5
; GFX6-GISEL-NEXT:    v_add_i32_e32 v4, vcc, v4, v7
; GFX6-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v6, v0
; GFX6-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, v4, v1, vcc
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v2
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v3, v0, v3
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v5, v0, v2
; GFX6-GISEL-NEXT:    v_mul_hi_u32 v0, v0, v2
; GFX6-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX6-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v1, v0
; GFX6-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v6
; GFX6-GISEL-NEXT:    v_addc_u32_e32 v2, vcc, 0, v4, vcc
; GFX6-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 1, v5
; GFX6-GISEL-NEXT:    v_addc_u32_e32 v4, vcc, 0, v0, vcc
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v2, v5, v2
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v6, v5, v1
; GFX6-GISEL-NEXT:    v_mul_hi_u32 v1, v5, v1
; GFX6-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX6-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v1, v0, v3
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v2, v6, v4
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v0, v6, v3
; GFX6-GISEL-NEXT:    v_mul_hi_u32 v3, v6, v3
; GFX6-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v2
; GFX6-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-SDAG-LABEL: clpeak_imad_pat_i64:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_add_i32_e32 v4, vcc, 1, v0
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v6, v4, v3
; GFX7-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v4, v2, 0
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v7, v5, v2
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v6
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v7
; GFX7-SDAG-NEXT:    v_add_i32_e32 v4, vcc, v0, v4
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v5, vcc, v1, v5, vcc
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v6, v4, v3
; GFX7-SDAG-NEXT:    v_mad_u64_u32 v[3:4], s[4:5], v4, v2, 0
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v2, v5, v2
; GFX7-SDAG-NEXT:    v_add_i32_e32 v4, vcc, v4, v6
; GFX7-SDAG-NEXT:    v_add_i32_e32 v4, vcc, v4, v2
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v2, v4, v0
; GFX7-SDAG-NEXT:    v_mad_u64_u32 v[5:6], s[4:5], v3, v0, v[3:4]
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v0, v3, v1
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v2, v6
; GFX7-SDAG-NEXT:    v_add_i32_e32 v6, vcc, v0, v1
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v2, v6, v3
; GFX7-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v5, v3, v[5:6]
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v3, v5, v4
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v2, v1
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v3, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: clpeak_imad_pat_i64:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_add_i32_e32 v6, vcc, 1, v0
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v7, vcc, 0, v1, vcc
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v6, v2, 0
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v6, v3, v[1:2]
; GFX7-GISEL-NEXT:    v_add_i32_e32 v8, vcc, v0, v6
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v7, v2, v[4:5]
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[5:6], s[4:5], v8, v2, 0
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v9, vcc, v4, v7, vcc
; GFX7-GISEL-NEXT:    v_mov_b32_e32 v1, v6
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[6:7], s[4:5], v8, v3, v[1:2]
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v9, v2, v[6:7]
; GFX7-GISEL-NEXT:    v_add_i32_e32 v6, vcc, 1, v0
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v4, vcc
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[3:4], s[4:5], v5, v6, 0
; GFX7-GISEL-NEXT:    v_add_i32_e32 v7, vcc, 1, v5
; GFX7-GISEL-NEXT:    v_mov_b32_e32 v0, v4
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v5, v1, v[0:1]
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v3, v7, 0
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v8, vcc, 0, v2, vcc
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v2, v6, v[4:5]
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[1:2], s[4:5], v3, v8, v[1:2]
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[1:2], s[4:5], v4, v7, v[1:2]
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: clpeak_imad_pat_i64:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_add_u32_e32 v4, vcc, 1, v0
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v6, v4, v3
; GFX8-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v4, v2, 0
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v7, v5, v2
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v1, v6
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v1, v7
; GFX8-SDAG-NEXT:    v_add_u32_e32 v4, vcc, v0, v4
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v5, vcc, v1, v5, vcc
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v6, v4, v3
; GFX8-SDAG-NEXT:    v_mad_u64_u32 v[3:4], s[4:5], v4, v2, 0
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v2, v5, v2
; GFX8-SDAG-NEXT:    v_add_u32_e32 v4, vcc, v4, v6
; GFX8-SDAG-NEXT:    v_add_u32_e32 v4, vcc, v4, v2
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v2, v4, v0
; GFX8-SDAG-NEXT:    v_mad_u64_u32 v[5:6], s[4:5], v3, v0, v[3:4]
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v0, v3, v1
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v2, v6
; GFX8-SDAG-NEXT:    v_add_u32_e32 v6, vcc, v0, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v2, v6, v3
; GFX8-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v5, v3, v[5:6]
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v3, v5, v4
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v2, v1
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v3, v1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: clpeak_imad_pat_i64:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u32_e32 v6, vcc, 1, v0
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v7, vcc, 0, v1, vcc
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v6, v2, 0
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v6, v3, v[1:2]
; GFX8-GISEL-NEXT:    v_add_u32_e32 v8, vcc, v0, v6
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v7, v2, v[4:5]
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[5:6], s[4:5], v8, v2, 0
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v9, vcc, v4, v7, vcc
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v1, v6
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[6:7], s[4:5], v8, v3, v[1:2]
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v9, v2, v[6:7]
; GFX8-GISEL-NEXT:    v_add_u32_e32 v6, vcc, 1, v0
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v4, vcc
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[3:4], s[4:5], v5, v6, 0
; GFX8-GISEL-NEXT:    v_add_u32_e32 v7, vcc, 1, v5
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v0, v4
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v5, v1, v[0:1]
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v3, v7, 0
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v8, vcc, 0, v2, vcc
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v2, v6, v[4:5]
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[1:2], s[4:5], v3, v8, v[1:2]
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[1:2], s[4:5], v4, v7, v[1:2]
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-SDAG-LABEL: clpeak_imad_pat_i64:
; GFX900-SDAG:       ; %bb.0: ; %entry
; GFX900-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-SDAG-NEXT:    v_add_co_u32_e32 v4, vcc, 1, v0
; GFX900-SDAG-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v1, vcc
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v6, v5, v2
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v7, v4, v3
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v4, v2, 0
; GFX900-SDAG-NEXT:    v_add3_u32 v6, v1, v7, v6
; GFX900-SDAG-NEXT:    v_add_co_u32_e32 v1, vcc, v0, v4
; GFX900-SDAG-NEXT:    v_addc_co_u32_e32 v4, vcc, v6, v5, vcc
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v4, v4, v2
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v3, v1, v3
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[1:2], s[4:5], v1, v2, 0
; GFX900-SDAG-NEXT:    v_add3_u32 v2, v2, v3, v4
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v5, v2, v0
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[3:4], s[4:5], v1, v0, v[1:2]
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v0, v1, v6
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v2, v3, v2
; GFX900-SDAG-NEXT:    v_add3_u32 v4, v5, v4, v0
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v5, v4, v1
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v3, v1, v[3:4]
; GFX900-SDAG-NEXT:    v_add3_u32 v1, v5, v1, v2
; GFX900-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-GISEL-LABEL: clpeak_imad_pat_i64:
; GFX900-GISEL:       ; %bb.0: ; %entry
; GFX900-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-GISEL-NEXT:    v_add_co_u32_e32 v6, vcc, 1, v0
; GFX900-GISEL-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v1, vcc
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v6, v2, 0
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v6, v3, v[1:2]
; GFX900-GISEL-NEXT:    v_add_co_u32_e32 v8, vcc, v0, v6
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v7, v2, v[4:5]
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[5:6], s[4:5], v8, v2, 0
; GFX900-GISEL-NEXT:    v_addc_co_u32_e32 v9, vcc, v4, v7, vcc
; GFX900-GISEL-NEXT:    v_mov_b32_e32 v1, v6
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[6:7], s[4:5], v8, v3, v[1:2]
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v9, v2, v[6:7]
; GFX900-GISEL-NEXT:    v_add_co_u32_e32 v6, vcc, 1, v0
; GFX900-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v4, vcc
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[3:4], s[4:5], v5, v6, 0
; GFX900-GISEL-NEXT:    v_add_co_u32_e32 v7, vcc, 1, v5
; GFX900-GISEL-NEXT:    v_mov_b32_e32 v0, v4
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v5, v1, v[0:1]
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v3, v7, 0
; GFX900-GISEL-NEXT:    v_addc_co_u32_e32 v8, vcc, 0, v2, vcc
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v2, v6, v[4:5]
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[1:2], s[4:5], v3, v8, v[1:2]
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[1:2], s[4:5], v4, v7, v[1:2]
; GFX900-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-SDAG-LABEL: clpeak_imad_pat_i64:
; GFX90A-SDAG:       ; %bb.0: ; %entry
; GFX90A-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 1, v0
; GFX90A-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v6, v1, v2
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v7, v0, v3
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v0, v2, 0
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v0, v2, v[0:1]
; GFX90A-SDAG-NEXT:    v_add3_u32 v1, v6, v1, v7
; GFX90A-SDAG-NEXT:    v_add3_u32 v5, v5, v7, v6
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v3, v0, v3
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v6, v1, v2
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v0, v2, 0
; GFX90A-SDAG-NEXT:    v_add3_u32 v1, v1, v3, v6
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v6, v1, v4
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v0, v4, v[0:1]
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v4, v0, v5
; GFX90A-SDAG-NEXT:    v_add3_u32 v3, v6, v3, v4
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v4, v2, v1
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v5, v3, v0
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v2, v0, v[2:3]
; GFX90A-SDAG-NEXT:    v_add3_u32 v1, v5, v1, v4
; GFX90A-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-GISEL-LABEL: clpeak_imad_pat_i64:
; GFX90A-GISEL:       ; %bb.0: ; %entry
; GFX90A-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-GISEL-NEXT:    v_add_co_u32_e32 v6, vcc, 1, v0
; GFX90A-GISEL-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v1, vcc
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v6, v3, 0
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v6, v2, 0
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v7, v2, v[4:5]
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v1, v1, v4
; GFX90A-GISEL-NEXT:    v_add_co_u32_e32 v6, vcc, v0, v6
; GFX90A-GISEL-NEXT:    v_addc_co_u32_e32 v8, vcc, v1, v7, vcc
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v6, v2, 0
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[6:7], s[4:5], v6, v3, 0
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v8, v2, v[6:7]
; GFX90A-GISEL-NEXT:    v_add_co_u32_e32 v6, vcc, 1, v0
; GFX90A-GISEL-NEXT:    v_addc_co_u32_e32 v0, vcc, 0, v1, vcc
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v5, v5, v2
; GFX90A-GISEL-NEXT:    v_add_co_u32_e32 v7, vcc, 1, v4
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v4, v0, 0
; GFX90A-GISEL-NEXT:    v_addc_co_u32_e32 v8, vcc, 0, v5, vcc
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v4, v6, 0
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v5, v6, v[0:1]
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v4, v3, v0
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v2, v7, 0
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v2, v8, 0
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v4, v7, v[2:3]
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v1, v1, v2
; GFX90A-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: clpeak_imad_pat_i64:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_co_u32 v4, vcc_lo, v0, 1
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v5, vcc_lo, 0, v1, vcc_lo
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v7, v4, v3
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[0:1], null, v4, v2, 0
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v6, v5, v2
; GFX10-SDAG-NEXT:    v_add_co_u32 v4, vcc_lo, v0, v4
; GFX10-SDAG-NEXT:    v_add3_u32 v1, v1, v7, v6
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v6, v4, v3
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[3:4], null, v4, v2, 0
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v5, vcc_lo, v1, v5, vcc_lo
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v2, v5, v2
; GFX10-SDAG-NEXT:    v_add3_u32 v4, v4, v6, v2
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v2, v3, v1
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v5, v4, v0
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[0:1], null, v3, v0, v[3:4]
; GFX10-SDAG-NEXT:    v_add3_u32 v1, v5, v1, v2
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v4
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v4, v1, v3
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[0:1], null, v0, v3, v[0:1]
; GFX10-SDAG-NEXT:    v_add3_u32 v1, v4, v1, v2
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: clpeak_imad_pat_i64:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_add_co_u32 v4, vcc_lo, v0, 1
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v5, vcc_lo, 0, v1, vcc_lo
; GFX10-GISEL-NEXT:    v_mad_u64_u32 v[0:1], null, v4, v2, 0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v6, v4, v3
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v7, v5, v2
; GFX10-GISEL-NEXT:    v_add3_u32 v1, v1, v6, v7
; GFX10-GISEL-NEXT:    v_add_co_u32 v6, vcc_lo, v0, v4
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v7, vcc_lo, v1, v5, vcc_lo
; GFX10-GISEL-NEXT:    v_mad_u64_u32 v[4:5], null, v6, v2, 0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v3, v6, v3
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v2, v7, v2
; GFX10-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 1
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v1, v4, v1
; GFX10-GISEL-NEXT:    v_add3_u32 v5, v5, v3, v2
; GFX10-GISEL-NEXT:    v_mad_u64_u32 v[2:3], null, v4, v0, 0
; GFX10-GISEL-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 1
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v0, v5, v0
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v5, vcc_lo, 0, v5, vcc_lo
; GFX10-GISEL-NEXT:    v_add3_u32 v3, v3, v1, v0
; GFX10-GISEL-NEXT:    v_mad_u64_u32 v[0:1], null, v2, v4, 0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v2, v2, v5
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v3, v3, v4
; GFX10-GISEL-NEXT:    v_add3_u32 v1, v1, v2, v3
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %y18 = add i64 %x, 1
  %add = mul i64 %y18, %y
  %mul119 = add i64 %add, %y18
  %add2 = mul i64 %mul119, %y
  %add220 = add i64 %add, 1
  %add422 = add i64 %add2, 1
  %mul521 = mul i64 %add2, %add220
  %add6 = mul i64 %mul521, %add422
  ret i64 %add6
}

define <2 x i64> @clpeak_imad_pat_v2i64(<2 x i64> %x, <2 x i64> %y) {
; GFX6-SDAG-LABEL: clpeak_imad_pat_v2i64:
; GFX6-SDAG:       ; %bb.0: ; %entry
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX6-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v8, v0, v5
; GFX6-SDAG-NEXT:    v_mul_hi_u32 v9, v0, v4
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v10, v1, v4
; GFX6-SDAG-NEXT:    v_add_i32_e32 v2, vcc, 1, v2
; GFX6-SDAG-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX6-SDAG-NEXT:    v_add_i32_e32 v8, vcc, v9, v8
; GFX6-SDAG-NEXT:    v_add_i32_e32 v8, vcc, v8, v10
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v9, v2, v7
; GFX6-SDAG-NEXT:    v_mul_hi_u32 v10, v2, v6
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v12, v3, v6
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v11, v0, v4
; GFX6-SDAG-NEXT:    v_add_i32_e32 v9, vcc, v10, v9
; GFX6-SDAG-NEXT:    v_add_i32_e32 v9, vcc, v9, v12
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v10, v2, v6
; GFX6-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v11, v0
; GFX6-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, v8, v1, vcc
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v5, v0, v5
; GFX6-SDAG-NEXT:    v_mul_hi_u32 v12, v0, v4
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v1, v1, v4
; GFX6-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v10, v2
; GFX6-SDAG-NEXT:    v_addc_u32_e32 v3, vcc, v9, v3, vcc
; GFX6-SDAG-NEXT:    v_add_i32_e32 v5, vcc, v12, v5
; GFX6-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v5, v1
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v5, v2, v7
; GFX6-SDAG-NEXT:    v_mul_hi_u32 v7, v2, v6
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v2, v2, v6
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v3, v3, v6
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v4
; GFX6-SDAG-NEXT:    v_add_i32_e32 v4, vcc, v7, v5
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v5, v2, v9
; GFX6-SDAG-NEXT:    v_mul_hi_u32 v6, v2, v10
; GFX6-SDAG-NEXT:    v_add_i32_e32 v3, vcc, v4, v3
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v4, v3, v10
; GFX6-SDAG-NEXT:    v_add_i32_e32 v5, vcc, v6, v5
; GFX6-SDAG-NEXT:    v_mul_hi_u32 v6, v0, v11
; GFX6-SDAG-NEXT:    v_add_i32_e32 v4, vcc, v5, v4
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v5, v0, v8
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v8, v1, v11
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v7, v2, v10
; GFX6-SDAG-NEXT:    v_add_i32_e32 v5, vcc, v6, v5
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v6, v0, v11
; GFX6-SDAG-NEXT:    v_add_i32_e32 v5, vcc, v5, v8
; GFX6-SDAG-NEXT:    v_add_i32_e32 v6, vcc, v6, v0
; GFX6-SDAG-NEXT:    v_addc_u32_e32 v5, vcc, v5, v1, vcc
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v1, v6, v1
; GFX6-SDAG-NEXT:    v_mul_hi_u32 v8, v6, v0
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v9, v5, v0
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v0, v6, v0
; GFX6-SDAG-NEXT:    v_add_i32_e32 v7, vcc, v7, v2
; GFX6-SDAG-NEXT:    v_addc_u32_e32 v4, vcc, v4, v3, vcc
; GFX6-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v8, v1
; GFX6-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v9
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v3, v7, v3
; GFX6-SDAG-NEXT:    v_mul_hi_u32 v8, v7, v2
; GFX6-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v6
; GFX6-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, v1, v5, vcc
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v5, v4, v2
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v2, v7, v2
; GFX6-SDAG-NEXT:    v_add_i32_e32 v3, vcc, v8, v3
; GFX6-SDAG-NEXT:    v_add_i32_e32 v3, vcc, v3, v5
; GFX6-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v2, v7
; GFX6-SDAG-NEXT:    v_addc_u32_e32 v3, vcc, v3, v4, vcc
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: clpeak_imad_pat_v2i64:
; GFX6-GISEL:       ; %bb.0: ; %entry
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX6-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v8, v1, v4
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v9, v0, v5
; GFX6-GISEL-NEXT:    v_mul_hi_u32 v11, v0, v4
; GFX6-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 1, v2
; GFX6-GISEL-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX6-GISEL-NEXT:    v_add_i32_e32 v8, vcc, v8, v9
; GFX6-GISEL-NEXT:    v_add_i32_e32 v8, vcc, v8, v11
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v9, v3, v6
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v11, v2, v7
; GFX6-GISEL-NEXT:    v_mul_hi_u32 v13, v2, v6
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v10, v0, v4
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v12, v2, v6
; GFX6-GISEL-NEXT:    v_add_i32_e32 v9, vcc, v9, v11
; GFX6-GISEL-NEXT:    v_add_i32_e32 v9, vcc, v9, v13
; GFX6-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v10, v0
; GFX6-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, v8, v1, vcc
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v4
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v5, v0, v5
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v11, v0, v4
; GFX6-GISEL-NEXT:    v_mul_hi_u32 v0, v0, v4
; GFX6-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v12, v2
; GFX6-GISEL-NEXT:    v_addc_u32_e32 v3, vcc, v9, v3, vcc
; GFX6-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v5
; GFX6-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v1, v0
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v1, v3, v6
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v3, v2, v7
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v4, v2, v6
; GFX6-GISEL-NEXT:    v_mul_hi_u32 v2, v2, v6
; GFX6-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX6-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v2
; GFX6-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 1, v10
; GFX6-GISEL-NEXT:    v_addc_u32_e32 v3, vcc, 0, v8, vcc
; GFX6-GISEL-NEXT:    v_add_i32_e32 v5, vcc, 1, v12
; GFX6-GISEL-NEXT:    v_addc_u32_e32 v6, vcc, 0, v9, vcc
; GFX6-GISEL-NEXT:    v_add_i32_e32 v7, vcc, 1, v11
; GFX6-GISEL-NEXT:    v_addc_u32_e32 v8, vcc, 0, v0, vcc
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v3, v11, v3
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v12, v11, v2
; GFX6-GISEL-NEXT:    v_mul_hi_u32 v2, v11, v2
; GFX6-GISEL-NEXT:    v_add_i32_e32 v9, vcc, 1, v4
; GFX6-GISEL-NEXT:    v_addc_u32_e32 v10, vcc, 0, v1, vcc
; GFX6-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v3
; GFX6-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v5
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v2, v4, v6
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v3, v4, v5
; GFX6-GISEL-NEXT:    v_mul_hi_u32 v4, v4, v5
; GFX6-GISEL-NEXT:    v_mul_hi_u32 v5, v12, v7
; GFX6-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v2
; GFX6-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v1, v4
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v1, v0, v7
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v4, v12, v8
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v0, v12, v7
; GFX6-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v4
; GFX6-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v5
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v4, v2, v9
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v5, v3, v10
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v2, v3, v9
; GFX6-GISEL-NEXT:    v_mul_hi_u32 v3, v3, v9
; GFX6-GISEL-NEXT:    v_add_i32_e32 v4, vcc, v4, v5
; GFX6-GISEL-NEXT:    v_add_i32_e32 v3, vcc, v4, v3
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-SDAG-LABEL: clpeak_imad_pat_v2i64:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_add_i32_e32 v8, vcc, 1, v0
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v9, vcc, 0, v1, vcc
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v10, v8, v5
; GFX7-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v8, v4, 0
; GFX7-SDAG-NEXT:    v_add_i32_e32 v11, vcc, 1, v2
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v12, vcc, 0, v3, vcc
; GFX7-SDAG-NEXT:    v_add_i32_e32 v3, vcc, v1, v10
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v10, v9, v4
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v13, v11, v7
; GFX7-SDAG-NEXT:    v_mad_u64_u32 v[1:2], s[4:5], v11, v6, 0
; GFX7-SDAG-NEXT:    v_add_i32_e32 v14, vcc, v3, v10
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v3, v12, v6
; GFX7-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v2, v13
; GFX7-SDAG-NEXT:    v_add_i32_e32 v13, vcc, v2, v3
; GFX7-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v0, v8
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v5, v2, v5
; GFX7-SDAG-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v2, v4, 0
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v9, vcc, v14, v9, vcc
; GFX7-SDAG-NEXT:    v_add_i32_e32 v8, vcc, v1, v11
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v10, vcc, v13, v12, vcc
; GFX7-SDAG-NEXT:    v_add_i32_e32 v3, vcc, v3, v5
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v5, v8, v7
; GFX7-SDAG-NEXT:    v_mad_u64_u32 v[7:8], s[4:5], v8, v6, 0
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v9, v9, v4
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v4, v10, v6
; GFX7-SDAG-NEXT:    v_add_i32_e32 v5, vcc, v8, v5
; GFX7-SDAG-NEXT:    v_add_i32_e32 v3, vcc, v3, v9
; GFX7-SDAG-NEXT:    v_add_i32_e32 v8, vcc, v5, v4
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v6, v8, v1
; GFX7-SDAG-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v7, v1, v[7:8]
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v1, v3, v0
; GFX7-SDAG-NEXT:    v_mad_u64_u32 v[9:10], s[4:5], v2, v0, v[2:3]
; GFX7-SDAG-NEXT:    v_add_i32_e32 v5, vcc, v6, v5
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v6, v7, v13
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v0, v2, v14
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v10
; GFX7-SDAG-NEXT:    v_add_i32_e32 v5, vcc, v6, v5
; GFX7-SDAG-NEXT:    v_add_i32_e32 v10, vcc, v0, v1
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v11, v10, v2
; GFX7-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v9, v2, v[9:10]
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v6, v9, v3
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v9, v5, v7
; GFX7-SDAG-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v4, v7, v[4:5]
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v4, v4, v8
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v11, v1
; GFX7-SDAG-NEXT:    v_add_i32_e32 v3, vcc, v9, v3
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v6, v1
; GFX7-SDAG-NEXT:    v_add_i32_e32 v3, vcc, v4, v3
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: clpeak_imad_pat_v2i64:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_add_i32_e32 v12, vcc, 1, v0
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v13, vcc, 0, v1, vcc
; GFX7-GISEL-NEXT:    v_add_i32_e32 v14, vcc, 1, v2
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v12, v4, 0
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v15, vcc, 0, v3, vcc
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v14, v6, 0
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[8:9], s[4:5], v12, v5, v[1:2]
; GFX7-GISEL-NEXT:    v_mov_b32_e32 v1, v3
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[10:11], s[4:5], v14, v7, v[1:2]
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[8:9], s[4:5], v13, v4, v[8:9]
; GFX7-GISEL-NEXT:    v_add_i32_e32 v3, vcc, v0, v12
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[9:10], s[4:5], v15, v6, v[10:11]
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v18, vcc, v8, v13, vcc
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[10:11], s[4:5], v3, v4, 0
; GFX7-GISEL-NEXT:    v_add_i32_e32 v16, vcc, v2, v14
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[12:13], s[4:5], v16, v6, 0
; GFX7-GISEL-NEXT:    v_mov_b32_e32 v1, v11
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v19, vcc, v9, v15, vcc
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[14:15], s[4:5], v3, v5, v[1:2]
; GFX7-GISEL-NEXT:    v_mov_b32_e32 v1, v13
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[16:17], s[4:5], v16, v7, v[1:2]
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[3:4], s[4:5], v18, v4, v[14:15]
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v19, v6, v[16:17]
; GFX7-GISEL-NEXT:    v_add_i32_e32 v11, vcc, 1, v0
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[5:6], s[4:5], v10, v11, 0
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v8, vcc
; GFX7-GISEL-NEXT:    v_add_i32_e32 v13, vcc, 1, v2
; GFX7-GISEL-NEXT:    v_mov_b32_e32 v0, v6
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v10, v1, v[0:1]
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[6:7], s[4:5], v12, v13, 0
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v2, vcc, 0, v9, vcc
; GFX7-GISEL-NEXT:    v_add_i32_e32 v14, vcc, 1, v10
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[8:9], s[4:5], v3, v11, v[0:1]
; GFX7-GISEL-NEXT:    v_mov_b32_e32 v0, v7
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v15, vcc, 0, v3, vcc
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v12, v2, v[0:1]
; GFX7-GISEL-NEXT:    v_add_i32_e32 v16, vcc, 1, v12
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v5, v14, 0
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[9:10], s[4:5], v4, v13, v[2:3]
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v6, v16, 0
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v17, vcc, 0, v4, vcc
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v5, v15, v[1:2]
; GFX7-GISEL-NEXT:    v_mov_b32_e32 v1, v3
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[10:11], s[4:5], v6, v17, v[1:2]
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[5:6], s[4:5], v8, v14, v[4:5]
; GFX7-GISEL-NEXT:    v_mad_u64_u32 v[3:4], s[4:5], v9, v16, v[10:11]
; GFX7-GISEL-NEXT:    v_mov_b32_e32 v1, v5
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: clpeak_imad_pat_v2i64:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_add_u32_e32 v8, vcc, 1, v0
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v9, vcc, 0, v1, vcc
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v10, v8, v5
; GFX8-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v8, v4, 0
; GFX8-SDAG-NEXT:    v_add_u32_e32 v11, vcc, 1, v2
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v12, vcc, 0, v3, vcc
; GFX8-SDAG-NEXT:    v_add_u32_e32 v3, vcc, v1, v10
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v10, v9, v4
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v13, v11, v7
; GFX8-SDAG-NEXT:    v_mad_u64_u32 v[1:2], s[4:5], v11, v6, 0
; GFX8-SDAG-NEXT:    v_add_u32_e32 v14, vcc, v3, v10
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v3, v12, v6
; GFX8-SDAG-NEXT:    v_add_u32_e32 v2, vcc, v2, v13
; GFX8-SDAG-NEXT:    v_add_u32_e32 v13, vcc, v2, v3
; GFX8-SDAG-NEXT:    v_add_u32_e32 v2, vcc, v0, v8
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v5, v2, v5
; GFX8-SDAG-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v2, v4, 0
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v9, vcc, v14, v9, vcc
; GFX8-SDAG-NEXT:    v_add_u32_e32 v8, vcc, v1, v11
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v10, vcc, v13, v12, vcc
; GFX8-SDAG-NEXT:    v_add_u32_e32 v3, vcc, v3, v5
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v5, v8, v7
; GFX8-SDAG-NEXT:    v_mad_u64_u32 v[7:8], s[4:5], v8, v6, 0
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v9, v9, v4
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v4, v10, v6
; GFX8-SDAG-NEXT:    v_add_u32_e32 v5, vcc, v8, v5
; GFX8-SDAG-NEXT:    v_add_u32_e32 v3, vcc, v3, v9
; GFX8-SDAG-NEXT:    v_add_u32_e32 v8, vcc, v5, v4
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v6, v8, v1
; GFX8-SDAG-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v7, v1, v[7:8]
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v1, v3, v0
; GFX8-SDAG-NEXT:    v_mad_u64_u32 v[9:10], s[4:5], v2, v0, v[2:3]
; GFX8-SDAG-NEXT:    v_add_u32_e32 v5, vcc, v6, v5
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v6, v7, v13
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v0, v2, v14
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v1, v10
; GFX8-SDAG-NEXT:    v_add_u32_e32 v5, vcc, v6, v5
; GFX8-SDAG-NEXT:    v_add_u32_e32 v10, vcc, v0, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v11, v10, v2
; GFX8-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v9, v2, v[9:10]
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v6, v9, v3
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v9, v5, v7
; GFX8-SDAG-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v4, v7, v[4:5]
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v4, v4, v8
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v11, v1
; GFX8-SDAG-NEXT:    v_add_u32_e32 v3, vcc, v9, v3
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v6, v1
; GFX8-SDAG-NEXT:    v_add_u32_e32 v3, vcc, v4, v3
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: clpeak_imad_pat_v2i64:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u32_e32 v12, vcc, 1, v0
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v13, vcc, 0, v1, vcc
; GFX8-GISEL-NEXT:    v_add_u32_e32 v14, vcc, 1, v2
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v12, v4, 0
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v15, vcc, 0, v3, vcc
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v14, v6, 0
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[8:9], s[4:5], v12, v5, v[1:2]
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v1, v3
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[10:11], s[4:5], v14, v7, v[1:2]
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[8:9], s[4:5], v13, v4, v[8:9]
; GFX8-GISEL-NEXT:    v_add_u32_e32 v3, vcc, v0, v12
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[9:10], s[4:5], v15, v6, v[10:11]
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v18, vcc, v8, v13, vcc
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[10:11], s[4:5], v3, v4, 0
; GFX8-GISEL-NEXT:    v_add_u32_e32 v16, vcc, v2, v14
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[12:13], s[4:5], v16, v6, 0
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v1, v11
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v19, vcc, v9, v15, vcc
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[14:15], s[4:5], v3, v5, v[1:2]
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v1, v13
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[16:17], s[4:5], v16, v7, v[1:2]
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[3:4], s[4:5], v18, v4, v[14:15]
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v19, v6, v[16:17]
; GFX8-GISEL-NEXT:    v_add_u32_e32 v11, vcc, 1, v0
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[5:6], s[4:5], v10, v11, 0
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v8, vcc
; GFX8-GISEL-NEXT:    v_add_u32_e32 v13, vcc, 1, v2
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v0, v6
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v10, v1, v[0:1]
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[6:7], s[4:5], v12, v13, 0
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v2, vcc, 0, v9, vcc
; GFX8-GISEL-NEXT:    v_add_u32_e32 v14, vcc, 1, v10
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[8:9], s[4:5], v3, v11, v[0:1]
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v0, v7
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v15, vcc, 0, v3, vcc
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v12, v2, v[0:1]
; GFX8-GISEL-NEXT:    v_add_u32_e32 v16, vcc, 1, v12
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v5, v14, 0
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[9:10], s[4:5], v4, v13, v[2:3]
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v6, v16, 0
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v17, vcc, 0, v4, vcc
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v5, v15, v[1:2]
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v1, v3
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[10:11], s[4:5], v6, v17, v[1:2]
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[5:6], s[4:5], v8, v14, v[4:5]
; GFX8-GISEL-NEXT:    v_mad_u64_u32 v[3:4], s[4:5], v9, v16, v[10:11]
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v1, v5
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-SDAG-LABEL: clpeak_imad_pat_v2i64:
; GFX900-SDAG:       ; %bb.0: ; %entry
; GFX900-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-SDAG-NEXT:    v_add_co_u32_e32 v8, vcc, 1, v2
; GFX900-SDAG-NEXT:    v_addc_co_u32_e32 v9, vcc, 0, v3, vcc
; GFX900-SDAG-NEXT:    v_add_co_u32_e32 v10, vcc, 1, v0
; GFX900-SDAG-NEXT:    v_addc_co_u32_e32 v11, vcc, 0, v1, vcc
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v12, v11, v4
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v13, v10, v5
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v10, v4, 0
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v14, v9, v6
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v15, v8, v7
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v8, v6, 0
; GFX900-SDAG-NEXT:    v_add3_u32 v12, v1, v13, v12
; GFX900-SDAG-NEXT:    v_add3_u32 v1, v3, v15, v14
; GFX900-SDAG-NEXT:    v_add_co_u32_e32 v8, vcc, v2, v8
; GFX900-SDAG-NEXT:    v_addc_co_u32_e32 v9, vcc, v1, v9, vcc
; GFX900-SDAG-NEXT:    v_add_co_u32_e32 v3, vcc, v0, v10
; GFX900-SDAG-NEXT:    v_addc_co_u32_e32 v10, vcc, v12, v11, vcc
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v10, v10, v4
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v11, v3, v5
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[3:4], s[4:5], v3, v4, 0
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v9, v9, v6
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v7, v8, v7
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[5:6], s[4:5], v8, v6, 0
; GFX900-SDAG-NEXT:    v_add3_u32 v4, v4, v11, v10
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v10, v4, v0
; GFX900-SDAG-NEXT:    v_add3_u32 v6, v6, v7, v9
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v9, v6, v2
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[7:8], s[4:5], v5, v2, v[5:6]
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v2, v5, v1
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v3, v0, v[3:4]
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v11, v3, v12
; GFX900-SDAG-NEXT:    v_add3_u32 v8, v9, v8, v2
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v4, v0, v4
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v6, v7, v6
; GFX900-SDAG-NEXT:    v_add3_u32 v1, v10, v1, v11
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v9, v1, v3
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v0, v3, v[0:1]
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v10, v8, v5
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v7, v5, v[7:8]
; GFX900-SDAG-NEXT:    v_add3_u32 v1, v9, v1, v4
; GFX900-SDAG-NEXT:    v_add3_u32 v3, v10, v3, v6
; GFX900-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-GISEL-LABEL: clpeak_imad_pat_v2i64:
; GFX900-GISEL:       ; %bb.0: ; %entry
; GFX900-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-GISEL-NEXT:    v_add_co_u32_e32 v12, vcc, 1, v0
; GFX900-GISEL-NEXT:    v_addc_co_u32_e32 v13, vcc, 0, v1, vcc
; GFX900-GISEL-NEXT:    v_add_co_u32_e32 v14, vcc, 1, v2
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v12, v4, 0
; GFX900-GISEL-NEXT:    v_addc_co_u32_e32 v15, vcc, 0, v3, vcc
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v14, v6, 0
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[8:9], s[4:5], v12, v5, v[1:2]
; GFX900-GISEL-NEXT:    v_mov_b32_e32 v1, v3
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[10:11], s[4:5], v14, v7, v[1:2]
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[8:9], s[4:5], v13, v4, v[8:9]
; GFX900-GISEL-NEXT:    v_add_co_u32_e32 v3, vcc, v0, v12
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[9:10], s[4:5], v15, v6, v[10:11]
; GFX900-GISEL-NEXT:    v_addc_co_u32_e32 v18, vcc, v8, v13, vcc
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[10:11], s[4:5], v3, v4, 0
; GFX900-GISEL-NEXT:    v_add_co_u32_e32 v16, vcc, v2, v14
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[12:13], s[4:5], v16, v6, 0
; GFX900-GISEL-NEXT:    v_mov_b32_e32 v1, v11
; GFX900-GISEL-NEXT:    v_addc_co_u32_e32 v19, vcc, v9, v15, vcc
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[14:15], s[4:5], v3, v5, v[1:2]
; GFX900-GISEL-NEXT:    v_mov_b32_e32 v1, v13
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[16:17], s[4:5], v16, v7, v[1:2]
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[3:4], s[4:5], v18, v4, v[14:15]
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v19, v6, v[16:17]
; GFX900-GISEL-NEXT:    v_add_co_u32_e32 v11, vcc, 1, v0
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[5:6], s[4:5], v10, v11, 0
; GFX900-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v8, vcc
; GFX900-GISEL-NEXT:    v_add_co_u32_e32 v13, vcc, 1, v2
; GFX900-GISEL-NEXT:    v_mov_b32_e32 v0, v6
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v10, v1, v[0:1]
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[6:7], s[4:5], v12, v13, 0
; GFX900-GISEL-NEXT:    v_addc_co_u32_e32 v2, vcc, 0, v9, vcc
; GFX900-GISEL-NEXT:    v_add_co_u32_e32 v14, vcc, 1, v10
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[8:9], s[4:5], v3, v11, v[0:1]
; GFX900-GISEL-NEXT:    v_mov_b32_e32 v0, v7
; GFX900-GISEL-NEXT:    v_addc_co_u32_e32 v15, vcc, 0, v3, vcc
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v12, v2, v[0:1]
; GFX900-GISEL-NEXT:    v_add_co_u32_e32 v16, vcc, 1, v12
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v5, v14, 0
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[9:10], s[4:5], v4, v13, v[2:3]
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v6, v16, 0
; GFX900-GISEL-NEXT:    v_addc_co_u32_e32 v17, vcc, 0, v4, vcc
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v5, v15, v[1:2]
; GFX900-GISEL-NEXT:    v_mov_b32_e32 v1, v3
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[10:11], s[4:5], v6, v17, v[1:2]
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[5:6], s[4:5], v8, v14, v[4:5]
; GFX900-GISEL-NEXT:    v_mad_u64_u32 v[3:4], s[4:5], v9, v16, v[10:11]
; GFX900-GISEL-NEXT:    v_mov_b32_e32 v1, v5
; GFX900-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-SDAG-LABEL: clpeak_imad_pat_v2i64:
; GFX90A-SDAG:       ; %bb.0: ; %entry
; GFX90A-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-SDAG-NEXT:    v_add_co_u32_e32 v2, vcc, 1, v2
; GFX90A-SDAG-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX90A-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 1, v0
; GFX90A-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v12, v1, v4
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v13, v0, v5
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[8:9], s[4:5], v0, v4, 0
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v0, v4, v[0:1]
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v14, v3, v6
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v15, v2, v7
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[10:11], s[4:5], v2, v6, 0
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v2, v6, v[2:3]
; GFX90A-SDAG-NEXT:    v_add3_u32 v1, v12, v1, v13
; GFX90A-SDAG-NEXT:    v_add3_u32 v9, v9, v13, v12
; GFX90A-SDAG-NEXT:    v_add3_u32 v3, v14, v3, v15
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v5, v0, v5
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v12, v1, v4
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v0, v4, 0
; GFX90A-SDAG-NEXT:    v_add3_u32 v1, v1, v5, v12
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v4, v2, v7
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v5, v3, v6
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v2, v6, 0
; GFX90A-SDAG-NEXT:    v_add3_u32 v11, v11, v15, v14
; GFX90A-SDAG-NEXT:    v_add3_u32 v3, v3, v4, v5
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v6, v3, v10
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v2, v10, v[2:3]
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v7, v2, v11
; GFX90A-SDAG-NEXT:    v_add3_u32 v5, v6, v5, v7
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v10, v1, v8
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[6:7], s[4:5], v0, v8, v[0:1]
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v8, v0, v9
; GFX90A-SDAG-NEXT:    v_add3_u32 v7, v10, v7, v8
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v8, v6, v1
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v9, v7, v0
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v6, v0, v[6:7]
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v6, v4, v3
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v7, v5, v2
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v4, v2, v[4:5]
; GFX90A-SDAG-NEXT:    v_add3_u32 v1, v9, v1, v8
; GFX90A-SDAG-NEXT:    v_add3_u32 v3, v7, v3, v6
; GFX90A-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-GISEL-LABEL: clpeak_imad_pat_v2i64:
; GFX90A-GISEL:       ; %bb.0: ; %entry
; GFX90A-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-GISEL-NEXT:    v_add_co_u32_e32 v10, vcc, 1, v0
; GFX90A-GISEL-NEXT:    v_addc_co_u32_e32 v11, vcc, 0, v1, vcc
; GFX90A-GISEL-NEXT:    v_add_co_u32_e32 v12, vcc, 1, v2
; GFX90A-GISEL-NEXT:    v_addc_co_u32_e32 v13, vcc, 0, v3, vcc
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v10, v5, 0
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v10, v4, 0
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v11, v4, v[2:3]
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v1, v1, v2
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[8:9], s[4:5], v12, v7, 0
; GFX90A-GISEL-NEXT:    v_add_co_u32_e32 v10, vcc, v0, v10
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v12, v6, 0
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[8:9], s[4:5], v13, v6, v[8:9]
; GFX90A-GISEL-NEXT:    v_addc_co_u32_e32 v14, vcc, v1, v11, vcc
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v3, v3, v8
; GFX90A-GISEL-NEXT:    v_add_co_u32_e32 v12, vcc, v2, v12
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[8:9], s[4:5], v10, v4, 0
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[10:11], s[4:5], v10, v5, 0
; GFX90A-GISEL-NEXT:    v_addc_co_u32_e32 v13, vcc, v3, v13, vcc
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v14, v4, v[10:11]
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[10:11], s[4:5], v12, v7, 0
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v9, v9, v4
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v12, v6, 0
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[6:7], s[4:5], v13, v6, v[10:11]
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v5, v5, v6
; GFX90A-GISEL-NEXT:    v_add_co_u32_e32 v6, vcc, 1, v0
; GFX90A-GISEL-NEXT:    v_addc_co_u32_e32 v0, vcc, 0, v1, vcc
; GFX90A-GISEL-NEXT:    v_add_co_u32_e32 v10, vcc, 1, v2
; GFX90A-GISEL-NEXT:    v_addc_co_u32_e32 v11, vcc, 0, v3, vcc
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v8, v0, 0
; GFX90A-GISEL-NEXT:    v_add_co_u32_e32 v12, vcc, 1, v8
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v8, v6, 0
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v9, v6, v[0:1]
; GFX90A-GISEL-NEXT:    v_addc_co_u32_e32 v13, vcc, 0, v9, vcc
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v8, v3, v0
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v4, v11, 0
; GFX90A-GISEL-NEXT:    v_add_co_u32_e32 v14, vcc, 1, v4
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[6:7], s[4:5], v4, v10, 0
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v5, v10, v[0:1]
; GFX90A-GISEL-NEXT:    v_addc_co_u32_e32 v15, vcc, 0, v5, vcc
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v7, v7, v0
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v2, v12, 0
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v2, v13, 0
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v8, v12, v[2:3]
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v6, v15, 0
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v1, v1, v2
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v6, v14, 0
; GFX90A-GISEL-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v7, v14, v[4:5]
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v3, v3, v4
; GFX90A-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: clpeak_imad_pat_v2i64:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_co_u32 v8, vcc_lo, v0, 1
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v9, vcc_lo, 0, v1, vcc_lo
; GFX10-SDAG-NEXT:    v_add_co_u32 v10, vcc_lo, v2, 1
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v11, vcc_lo, 0, v3, vcc_lo
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v12, v9, v4
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v13, v8, v5
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[0:1], null, v8, v4, 0
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v14, v11, v6
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v15, v10, v7
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[2:3], null, v10, v6, 0
; GFX10-SDAG-NEXT:    v_add3_u32 v12, v1, v13, v12
; GFX10-SDAG-NEXT:    v_add_co_u32 v1, vcc_lo, v0, v8
; GFX10-SDAG-NEXT:    v_add3_u32 v13, v3, v15, v14
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, v12, v9, vcc_lo
; GFX10-SDAG-NEXT:    v_add_co_u32 v8, vcc_lo, v2, v10
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v9, vcc_lo, v13, v11, vcc_lo
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v10, v3, v4
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v11, v1, v5
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v7, v8, v7
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v9, v9, v6
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[5:6], null, v8, v6, 0
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[3:4], null, v1, v4, 0
; GFX10-SDAG-NEXT:    v_add3_u32 v6, v6, v7, v9
; GFX10-SDAG-NEXT:    v_add3_u32 v4, v4, v11, v10
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v11, v3, v12
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v9, v6, v2
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[7:8], null, v5, v2, v[5:6]
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v10, v4, v0
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[0:1], null, v3, v0, v[3:4]
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v2, v5, v13
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v6, v7, v6
; GFX10-SDAG-NEXT:    v_add3_u32 v1, v10, v1, v11
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v4, v0, v4
; GFX10-SDAG-NEXT:    v_add3_u32 v8, v9, v8, v2
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v9, v1, v3
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[0:1], null, v0, v3, v[0:1]
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v10, v8, v5
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[2:3], null, v7, v5, v[7:8]
; GFX10-SDAG-NEXT:    v_add3_u32 v1, v9, v1, v4
; GFX10-SDAG-NEXT:    v_add3_u32 v3, v10, v3, v6
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: clpeak_imad_pat_v2i64:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_add_co_u32 v8, vcc_lo, v0, 1
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v9, vcc_lo, 0, v1, vcc_lo
; GFX10-GISEL-NEXT:    v_add_co_u32 v10, vcc_lo, v2, 1
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v11, vcc_lo, 0, v3, vcc_lo
; GFX10-GISEL-NEXT:    v_mad_u64_u32 v[0:1], null, v8, v4, 0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v12, v8, v5
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v13, v9, v4
; GFX10-GISEL-NEXT:    v_mad_u64_u32 v[2:3], null, v10, v6, 0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v14, v10, v7
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v15, v11, v6
; GFX10-GISEL-NEXT:    v_add3_u32 v1, v1, v12, v13
; GFX10-GISEL-NEXT:    v_add3_u32 v12, v3, v14, v15
; GFX10-GISEL-NEXT:    v_add_co_u32 v3, vcc_lo, v0, v8
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v13, vcc_lo, v1, v9, vcc_lo
; GFX10-GISEL-NEXT:    v_add_co_u32 v10, vcc_lo, v2, v10
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v11, vcc_lo, v12, v11, vcc_lo
; GFX10-GISEL-NEXT:    v_mad_u64_u32 v[8:9], null, v3, v4, 0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v5, v3, v5
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v13, v13, v4
; GFX10-GISEL-NEXT:    v_mad_u64_u32 v[3:4], null, v10, v6, 0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v7, v10, v7
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v6, v11, v6
; GFX10-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 1
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-GISEL-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 1
; GFX10-GISEL-NEXT:    v_add3_u32 v9, v9, v5, v13
; GFX10-GISEL-NEXT:    v_add3_u32 v10, v4, v7, v6
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v11, vcc_lo, 0, v12, vcc_lo
; GFX10-GISEL-NEXT:    v_mad_u64_u32 v[4:5], null, v8, v0, 0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v1, v8, v1
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v0, v9, v0
; GFX10-GISEL-NEXT:    v_mad_u64_u32 v[6:7], null, v3, v2, 0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v11, v3, v11
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v2, v10, v2
; GFX10-GISEL-NEXT:    v_add_co_u32 v8, vcc_lo, v8, 1
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v9, vcc_lo, 0, v9, vcc_lo
; GFX10-GISEL-NEXT:    v_add_co_u32 v12, vcc_lo, v3, 1
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v10, vcc_lo, 0, v10, vcc_lo
; GFX10-GISEL-NEXT:    v_add3_u32 v3, v5, v1, v0
; GFX10-GISEL-NEXT:    v_add3_u32 v5, v7, v11, v2
; GFX10-GISEL-NEXT:    v_mad_u64_u32 v[0:1], null, v4, v8, 0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v4, v4, v9
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v7, v3, v8
; GFX10-GISEL-NEXT:    v_mad_u64_u32 v[2:3], null, v6, v12, 0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v6, v6, v10
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v5, v5, v12
; GFX10-GISEL-NEXT:    v_add3_u32 v1, v1, v4, v7
; GFX10-GISEL-NEXT:    v_add3_u32 v3, v3, v6, v5
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %y18 = add <2 x i64> %x, <i64 1, i64 1>
  %add = mul <2 x i64> %y18, %y
  %mul119 = add <2 x i64> %add, %y18
  %add2 = mul <2 x i64> %mul119, %y
  %add220 = add <2 x i64> %add, <i64 1, i64 1>
  %add422 = add <2 x i64> %add2, <i64 1, i64 1>
  %mul521 = mul <2 x i64> %add2, %add220
  %add6 = mul <2 x i64> %mul521, %add422
  ret <2 x i64> %add6
}

define i32 @v_multi_use_mul_chain_add_other_use_all(i32 %arg, i32 %arg1, i32 %arg2, ptr addrspace(1) %ptr) {
; GFX6-SDAG-LABEL: v_multi_use_mul_chain_add_other_use_all:
; GFX6-SDAG:       ; %bb.0: ; %bb
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX6-SDAG-NEXT:    s_mov_b32 s6, 0
; GFX6-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-SDAG-NEXT:    s_mov_b32 s4, s6
; GFX6-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v2, v0
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX6-SDAG-NEXT:    v_add_i32_e32 v1, vcc, 1, v2
; GFX6-SDAG-NEXT:    s_mov_b32 s5, s6
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v5, v0, v1
; GFX6-SDAG-NEXT:    buffer_store_dword v2, v[3:4], s[4:7], 0 addr64
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX6-SDAG-NEXT:    buffer_store_dword v0, v[3:4], s[4:7], 0 addr64
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX6-SDAG-NEXT:    buffer_store_dword v5, v[3:4], s[4:7], 0 addr64
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(1)
; GFX6-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v5, v1
; GFX6-SDAG-NEXT:    s_waitcnt expcnt(0)
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: v_multi_use_mul_chain_add_other_use_all:
; GFX6-GISEL:       ; %bb.0: ; %bb
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX6-GISEL-NEXT:    s_mov_b32 s6, 0
; GFX6-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-GISEL-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v2, v0
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX6-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v2
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v5, v0, v1
; GFX6-GISEL-NEXT:    buffer_store_dword v2, v[3:4], s[4:7], 0 addr64
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX6-GISEL-NEXT:    buffer_store_dword v0, v[3:4], s[4:7], 0 addr64
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX6-GISEL-NEXT:    buffer_store_dword v5, v[3:4], s[4:7], 0 addr64
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(1)
; GFX6-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v5, v1
; GFX6-GISEL-NEXT:    s_waitcnt expcnt(0)
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-SDAG-LABEL: v_multi_use_mul_chain_add_other_use_all:
; GFX7-SDAG:       ; %bb.0: ; %bb
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX7-SDAG-NEXT:    s_mov_b32 s6, 0
; GFX7-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-SDAG-NEXT:    s_mov_b32 s4, s6
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v2, v0
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, 1, v2
; GFX7-SDAG-NEXT:    s_mov_b32 s5, s6
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v5, v0, v1
; GFX7-SDAG-NEXT:    buffer_store_dword v2, v[3:4], s[4:7], 0 addr64
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX7-SDAG-NEXT:    buffer_store_dword v0, v[3:4], s[4:7], 0 addr64
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX7-SDAG-NEXT:    buffer_store_dword v5, v[3:4], s[4:7], 0 addr64
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v5, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: v_multi_use_mul_chain_add_other_use_all:
; GFX7-GISEL:       ; %bb.0: ; %bb
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX7-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX7-GISEL-NEXT:    s_mov_b32 s6, 0
; GFX7-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-GISEL-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v2, v0
; GFX7-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v2
; GFX7-GISEL-NEXT:    v_mul_lo_u32 v5, v0, v1
; GFX7-GISEL-NEXT:    buffer_store_dword v2, v[3:4], s[4:7], 0 addr64
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX7-GISEL-NEXT:    buffer_store_dword v0, v[3:4], s[4:7], 0 addr64
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX7-GISEL-NEXT:    buffer_store_dword v5, v[3:4], s[4:7], 0 addr64
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v5, v1
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_multi_use_mul_chain_add_other_use_all:
; GFX8:       ; %bb.0: ; %bb
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 1, v0
; GFX8-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, v2, v0
; GFX8-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, 1, v2
; GFX8-NEXT:    v_mul_lo_u32 v5, v0, v1
; GFX8-NEXT:    flat_store_dword v[3:4], v2
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dword v[3:4], v0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dword v[3:4], v5
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, v5, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_multi_use_mul_chain_add_other_use_all:
; GFX900:       ; %bb.0: ; %bb
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX900-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX900-NEXT:    v_add_u32_e32 v0, v2, v0
; GFX900-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX900-NEXT:    v_add_u32_e32 v1, 1, v2
; GFX900-NEXT:    v_mul_lo_u32 v5, v0, v1
; GFX900-NEXT:    global_store_dword v[3:4], v2, off
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    global_store_dword v[3:4], v0, off
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    global_store_dword v[3:4], v5, off
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    v_add_u32_e32 v0, v5, v1
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-SDAG-LABEL: v_multi_use_mul_chain_add_other_use_all:
; GFX90A-SDAG:       ; %bb.0: ; %bb
; GFX90A-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v0, v2, v0
; GFX90A-SDAG-NEXT:    v_mov_b32_e32 v5, v4
; GFX90A-SDAG-NEXT:    v_mov_b32_e32 v4, v3
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v1, 1, v2
; GFX90A-SDAG-NEXT:    global_store_dword v[4:5], v2, off
; GFX90A-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-SDAG-NEXT:    global_store_dword v[4:5], v0, off
; GFX90A-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX90A-SDAG-NEXT:    global_store_dword v[4:5], v0, off
; GFX90A-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v0, v0, v1
; GFX90A-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-GISEL-LABEL: v_multi_use_mul_chain_add_other_use_all:
; GFX90A-GISEL:       ; %bb.0: ; %bb
; GFX90A-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX90A-GISEL-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-GISEL-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v4, v0, v1
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v0, v4, v0
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v1, 1, v4
; GFX90A-GISEL-NEXT:    global_store_dword v[2:3], v4, off
; GFX90A-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-GISEL-NEXT:    global_store_dword v[2:3], v0, off
; GFX90A-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX90A-GISEL-NEXT:    global_store_dword v[2:3], v0, off
; GFX90A-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v0, v0, v1
; GFX90A-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_multi_use_mul_chain_add_other_use_all:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX10-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX10-NEXT:    v_add_nc_u32_e32 v0, v2, v0
; GFX10-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX10-NEXT:    v_add_nc_u32_e32 v0, 1, v2
; GFX10-NEXT:    v_mul_lo_u32 v5, v1, v0
; GFX10-NEXT:    global_store_dword v[3:4], v2, off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_store_dword v[3:4], v1, off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_store_dword v[3:4], v5, off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_nc_u32_e32 v0, v5, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
bb:
  %i = add i32 %arg, 1
  %i3 = mul i32 %i, %arg1
  store volatile i32 %i3, ptr addrspace(1) %ptr
  %i4 = add i32 %i3, %i
  %i5 = mul i32 %i4, %arg1
  store volatile i32 %i5, ptr addrspace(1) %ptr
  %i6 = add i32 %i3, 1
  %i7 = mul i32 %i5, %i6
  store volatile i32 %i7, ptr addrspace(1) %ptr
  %i8 = add i32 %i7, %i6
  ret i32 %i8
}

define i32 @v_multi_use_mul_chain_add_other_use_some(i32 %arg, i32 %arg1, i32 %arg2, ptr addrspace(1) %ptr) {
; GFX6-SDAG-LABEL: v_multi_use_mul_chain_add_other_use_some:
; GFX6-SDAG:       ; %bb.0: ; %bb
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX6-SDAG-NEXT:    s_mov_b32 s6, 0
; GFX6-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-SDAG-NEXT:    s_mov_b32 s4, s6
; GFX6-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v2, v0
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX6-SDAG-NEXT:    v_add_i32_e32 v1, vcc, 1, v2
; GFX6-SDAG-NEXT:    s_mov_b32 s5, s6
; GFX6-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX6-SDAG-NEXT:    buffer_store_dword v2, v[3:4], s[4:7], 0 addr64
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX6-SDAG-NEXT:    buffer_store_dword v0, v[3:4], s[4:7], 0 addr64
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GFX6-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: v_multi_use_mul_chain_add_other_use_some:
; GFX6-GISEL:       ; %bb.0: ; %bb
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX6-GISEL-NEXT:    s_mov_b32 s6, 0
; GFX6-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-GISEL-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v2, v0
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX6-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v2
; GFX6-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX6-GISEL-NEXT:    buffer_store_dword v2, v[3:4], s[4:7], 0 addr64
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX6-GISEL-NEXT:    buffer_store_dword v0, v[3:4], s[4:7], 0 addr64
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GFX6-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-SDAG-LABEL: v_multi_use_mul_chain_add_other_use_some:
; GFX7-SDAG:       ; %bb.0: ; %bb
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX7-SDAG-NEXT:    s_mov_b32 s6, 0
; GFX7-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-SDAG-NEXT:    s_mov_b32 s4, s6
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v2, v0
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, 1, v2
; GFX7-SDAG-NEXT:    s_mov_b32 s5, s6
; GFX7-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX7-SDAG-NEXT:    buffer_store_dword v2, v[3:4], s[4:7], 0 addr64
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX7-SDAG-NEXT:    buffer_store_dword v0, v[3:4], s[4:7], 0 addr64
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: v_multi_use_mul_chain_add_other_use_some:
; GFX7-GISEL:       ; %bb.0: ; %bb
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX7-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX7-GISEL-NEXT:    s_mov_b32 s6, 0
; GFX7-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-GISEL-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v2, v0
; GFX7-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v2
; GFX7-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX7-GISEL-NEXT:    buffer_store_dword v2, v[3:4], s[4:7], 0 addr64
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX7-GISEL-NEXT:    buffer_store_dword v0, v[3:4], s[4:7], 0 addr64
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_multi_use_mul_chain_add_other_use_some:
; GFX8:       ; %bb.0: ; %bb
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 1, v0
; GFX8-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, v2, v0
; GFX8-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, 1, v2
; GFX8-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX8-NEXT:    flat_store_dword v[3:4], v2
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dword v[3:4], v0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_multi_use_mul_chain_add_other_use_some:
; GFX900:       ; %bb.0: ; %bb
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX900-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX900-NEXT:    v_add_u32_e32 v0, v2, v0
; GFX900-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX900-NEXT:    v_add_u32_e32 v1, 1, v2
; GFX900-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX900-NEXT:    global_store_dword v[3:4], v2, off
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    global_store_dword v[3:4], v0, off
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    v_add_u32_e32 v0, v0, v1
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-SDAG-LABEL: v_multi_use_mul_chain_add_other_use_some:
; GFX90A-SDAG:       ; %bb.0: ; %bb
; GFX90A-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v0, v2, v0
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v1, 1, v2
; GFX90A-SDAG-NEXT:    v_mov_b32_e32 v5, v4
; GFX90A-SDAG-NEXT:    v_mov_b32_e32 v4, v3
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX90A-SDAG-NEXT:    global_store_dword v[4:5], v2, off
; GFX90A-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-SDAG-NEXT:    global_store_dword v[4:5], v0, off
; GFX90A-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v0, v0, v1
; GFX90A-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-GISEL-LABEL: v_multi_use_mul_chain_add_other_use_some:
; GFX90A-GISEL:       ; %bb.0: ; %bb
; GFX90A-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX90A-GISEL-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-GISEL-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v4, v0, v1
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v0, v4, v0
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v1, 1, v4
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX90A-GISEL-NEXT:    global_store_dword v[2:3], v4, off
; GFX90A-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-GISEL-NEXT:    global_store_dword v[2:3], v0, off
; GFX90A-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v0, v0, v1
; GFX90A-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_multi_use_mul_chain_add_other_use_some:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX10-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX10-NEXT:    v_add_nc_u32_e32 v0, v2, v0
; GFX10-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX10-NEXT:    v_add_nc_u32_e32 v1, 1, v2
; GFX10-NEXT:    v_mul_lo_u32 v5, v0, v1
; GFX10-NEXT:    global_store_dword v[3:4], v2, off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_store_dword v[3:4], v5, off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_nc_u32_e32 v0, v5, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
bb:
  %i = add i32 %arg, 1
  %i3 = mul i32 %i, %arg1
  store volatile i32 %i3, ptr addrspace(1) %ptr
  %i4 = add i32 %i3, %i
  %i5 = mul i32 %i4, %arg1
  %i6 = add i32 %i3, 1
  %i7 = mul i32 %i5, %i6
  store volatile i32 %i7, ptr addrspace(1) %ptr
  %i8 = add i32 %i7, %i6
  ret i32 %i8
}

define i32 @clpeak_imad_pat_i32_x2(i32 %x, i32 %y) {
; GFX67-SDAG-LABEL: clpeak_imad_pat_i32_x2:
; GFX67-SDAG:       ; %bb.0: ; %entry
; GFX67-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v2, v0
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, 1, v2
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v2, v1
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, 1, v2
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v2, v1
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v1, v0, v2
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v0
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX67-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX67-GISEL-LABEL: clpeak_imad_pat_i32_x2:
; GFX67-GISEL:       ; %bb.0: ; %entry
; GFX67-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v2, v0
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v2
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v2, v1
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v2
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v2, v1
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v2
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX67-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: clpeak_imad_pat_i32_x2:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, 1, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v2, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, 1, v2
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v2, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, 1, v2
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v2, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v1, v0, v2
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v1, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v0, v1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: clpeak_imad_pat_i32_x2:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, 1, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v2, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_add_u32_e32 v1, vcc, 1, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX8-GISEL-NEXT:    v_add_u32_e32 v1, vcc, v2, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX8-GISEL-NEXT:    v_add_u32_e32 v1, vcc, 1, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX8-GISEL-NEXT:    v_add_u32_e32 v1, vcc, v2, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX8-GISEL-NEXT:    v_add_u32_e32 v1, vcc, 1, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, 1, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-SDAG-LABEL: clpeak_imad_pat_i32_x2:
; GFX900-SDAG:       ; %bb.0: ; %entry
; GFX900-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-SDAG-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX900-SDAG-NEXT:    v_add_u32_e32 v0, v2, v0
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX900-SDAG-NEXT:    v_add_u32_e32 v1, 1, v2
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX900-SDAG-NEXT:    v_add_u32_e32 v1, v2, v1
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX900-SDAG-NEXT:    v_add_u32_e32 v1, 1, v2
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX900-SDAG-NEXT:    v_add_u32_e32 v1, v2, v1
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[1:2], s[4:5], v0, v2, v[0:1]
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v1, v0, v[1:2]
; GFX900-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-GISEL-LABEL: clpeak_imad_pat_i32_x2:
; GFX900-GISEL:       ; %bb.0: ; %entry
; GFX900-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-GISEL-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX900-GISEL-NEXT:    v_add_u32_e32 v0, v2, v0
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX900-GISEL-NEXT:    v_add_u32_e32 v1, 1, v2
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX900-GISEL-NEXT:    v_add_u32_e32 v1, v2, v1
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX900-GISEL-NEXT:    v_add_u32_e32 v1, 1, v2
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX900-GISEL-NEXT:    v_add_u32_e32 v1, v2, v1
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX900-GISEL-NEXT:    v_add_u32_e32 v1, 1, v2
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX900-GISEL-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX900-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-SDAG-LABEL: clpeak_imad_pat_i32_x2:
; GFX90A-SDAG:       ; %bb.0: ; %entry
; GFX90A-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v0, v2, v0
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v1, 1, v2
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v1, v2, v1
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v1, 1, v2
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v1, v2, v1
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v0, v2, v[0:1]
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v2, v0, v[2:3]
; GFX90A-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-GISEL-LABEL: clpeak_imad_pat_i32_x2:
; GFX90A-GISEL:       ; %bb.0: ; %entry
; GFX90A-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v0, v2, v0
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v1, 1, v2
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v1, v2, v1
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v1, 1, v2
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v1, v2, v1
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v1, 1, v2
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v2, 1, v0
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX90A-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: clpeak_imad_pat_i32_x2:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v0, v2, v0
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v1, 1, v2
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v1, v2, v1
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v1, 1, v2
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v1, v2, v1
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[1:2], null, v0, v2, v[0:1]
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[0:1], null, v1, v0, v[1:2]
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: clpeak_imad_pat_i32_x2:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, v2, v0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, 1, v2
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, v2, v1
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, 1, v2
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, v2, v1
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, 1, v2
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %y38 = add i32 %x, 1
  %add = mul i32 %y38, %y
  %mul139 = add i32 %add, %y38
  %add2 = mul i32 %mul139, %y
  %add240 = add i32 %add, 1
  %add4 = mul i32 %add2, %add240
  %mul541 = add i32 %add4, %add240
  %add6 = mul i32 %mul541, %add2
  %add642 = add i32 %add4, 1
  %add8 = mul i32 %add6, %add642
  %mul943 = add i32 %add8, %add642
  %add10 = mul i32 %mul943, %add6
  %add1044 = add i32 %add8, 1
  %add1246 = add i32 %add10, 1
  %mul1345 = mul i32 %add10, %add1044
  %add14 = mul i32 %mul1345, %add1246
  ret i32 %add14
}

define <2 x i32> @clpeak_imad_pat_v2i32_x2(<2 x i32> %x, <2 x i32> %y) {
; GFX67-SDAG-LABEL: clpeak_imad_pat_v2i32_x2:
; GFX67-SDAG:       ; %bb.0: ; %entry
; GFX67-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v5, v0, v2
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v4, v1, v3
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v5, v0
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v4, v1
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v1, v1, v3
; GFX67-SDAG-NEXT:    v_add_i32_e32 v2, vcc, 1, v5
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v3, v0, v2
; GFX67-SDAG-NEXT:    v_add_i32_e32 v4, vcc, 1, v4
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v5, v1, v4
; GFX67-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v3, v2
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX67-SDAG-NEXT:    v_add_i32_e32 v4, vcc, v5, v4
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v1, v4, v1
; GFX67-SDAG-NEXT:    v_add_i32_e32 v2, vcc, 1, v3
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v3, v0, v2
; GFX67-SDAG-NEXT:    v_add_i32_e32 v4, vcc, 1, v5
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v5, v1, v4
; GFX67-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v3, v2
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX67-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v5, v4
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v1, v2, v1
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v3
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v3, v1, v5
; GFX67-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v2, v0
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX67-SDAG-NEXT:    v_add_i32_e32 v3, vcc, v3, v1
; GFX67-SDAG-NEXT:    v_mul_lo_u32 v1, v3, v1
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX67-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX67-GISEL-LABEL: clpeak_imad_pat_v2i32_x2:
; GFX67-GISEL:       ; %bb.0: ; %entry
; GFX67-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v4, v0, v2
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v5, v1, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v4, v0
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v5, v1
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 1, v4
; GFX67-GISEL-NEXT:    v_add_i32_e32 v4, vcc, 1, v5
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v3, v0, v2
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v5, v1, v4
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v3, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v4, vcc, v5, v4
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v1, v4, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 1, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v4, vcc, 1, v5
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v3, v0, v2
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v5, v1, v4
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v3, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v4, vcc, v5, v4
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v1, v4, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 1, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 1, v5
; GFX67-GISEL-NEXT:    v_add_i32_e32 v4, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v2, v1, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v4
; GFX67-GISEL-NEXT:    v_mul_lo_u32 v1, v2, v1
; GFX67-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: clpeak_imad_pat_v2i32_x2:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, 1, v0
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, 1, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v5, v0, v2
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v4, v1, v3
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v5, v0
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v4, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v1, v1, v3
; GFX8-SDAG-NEXT:    v_add_u32_e32 v2, vcc, 1, v5
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v3, v0, v2
; GFX8-SDAG-NEXT:    v_add_u32_e32 v4, vcc, 1, v4
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v5, v1, v4
; GFX8-SDAG-NEXT:    v_add_u32_e32 v2, vcc, v3, v2
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX8-SDAG-NEXT:    v_add_u32_e32 v4, vcc, v5, v4
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v1, v4, v1
; GFX8-SDAG-NEXT:    v_add_u32_e32 v2, vcc, 1, v3
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v3, v0, v2
; GFX8-SDAG-NEXT:    v_add_u32_e32 v4, vcc, 1, v5
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v5, v1, v4
; GFX8-SDAG-NEXT:    v_add_u32_e32 v2, vcc, v3, v2
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX8-SDAG-NEXT:    v_add_u32_e32 v2, vcc, v5, v4
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v1, v2, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v2, v0, v3
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v3, v1, v5
; GFX8-SDAG-NEXT:    v_add_u32_e32 v2, vcc, v2, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX8-SDAG-NEXT:    v_add_u32_e32 v3, vcc, v3, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u32 v1, v3, v1
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v1, v3
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: clpeak_imad_pat_v2i32_x2:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, 1, v0
; GFX8-GISEL-NEXT:    v_add_u32_e32 v1, vcc, 1, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v4, v0, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v5, v1, v3
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v4, v0
; GFX8-GISEL-NEXT:    v_add_u32_e32 v1, vcc, v5, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v3
; GFX8-GISEL-NEXT:    v_add_u32_e32 v2, vcc, 1, v4
; GFX8-GISEL-NEXT:    v_add_u32_e32 v4, vcc, 1, v5
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v3, v0, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v5, v1, v4
; GFX8-GISEL-NEXT:    v_add_u32_e32 v2, vcc, v3, v2
; GFX8-GISEL-NEXT:    v_add_u32_e32 v4, vcc, v5, v4
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v1, v4, v1
; GFX8-GISEL-NEXT:    v_add_u32_e32 v2, vcc, 1, v3
; GFX8-GISEL-NEXT:    v_add_u32_e32 v4, vcc, 1, v5
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v3, v0, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v5, v1, v4
; GFX8-GISEL-NEXT:    v_add_u32_e32 v2, vcc, v3, v2
; GFX8-GISEL-NEXT:    v_add_u32_e32 v4, vcc, v5, v4
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v1, v4, v1
; GFX8-GISEL-NEXT:    v_add_u32_e32 v2, vcc, 1, v3
; GFX8-GISEL-NEXT:    v_add_u32_e32 v3, vcc, 1, v5
; GFX8-GISEL-NEXT:    v_add_u32_e32 v4, vcc, 1, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v2, v1, v3
; GFX8-GISEL-NEXT:    v_add_u32_e32 v1, vcc, 1, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v4
; GFX8-GISEL-NEXT:    v_mul_lo_u32 v1, v2, v1
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-SDAG-LABEL: clpeak_imad_pat_v2i32_x2:
; GFX900-SDAG:       ; %bb.0: ; %entry
; GFX900-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-SDAG-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v4, v0, v2
; GFX900-SDAG-NEXT:    v_add_u32_e32 v1, 1, v1
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v5, v1, v3
; GFX900-SDAG-NEXT:    v_add_u32_e32 v0, v4, v0
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX900-SDAG-NEXT:    v_add_u32_e32 v1, v5, v1
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v1, v1, v3
; GFX900-SDAG-NEXT:    v_add_u32_e32 v2, 1, v4
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v3, v0, v2
; GFX900-SDAG-NEXT:    v_add_u32_e32 v4, 1, v5
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v5, v1, v4
; GFX900-SDAG-NEXT:    v_add_u32_e32 v2, v3, v2
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX900-SDAG-NEXT:    v_add_u32_e32 v2, v5, v4
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v1, v2, v1
; GFX900-SDAG-NEXT:    v_add_u32_e32 v2, 1, v3
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v3, v0, v2
; GFX900-SDAG-NEXT:    v_add_u32_e32 v4, 1, v5
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v5, v1, v4
; GFX900-SDAG-NEXT:    v_add_u32_e32 v2, v3, v2
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX900-SDAG-NEXT:    v_add_u32_e32 v2, v5, v4
; GFX900-SDAG-NEXT:    v_mul_lo_u32 v2, v2, v1
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[3:4], s[4:5], v0, v3, v[0:1]
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v2, v5, v[2:3]
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v3, v0, v[3:4]
; GFX900-SDAG-NEXT:    v_mad_u64_u32 v[1:2], s[4:5], v4, v2, v[4:5]
; GFX900-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-GISEL-LABEL: clpeak_imad_pat_v2i32_x2:
; GFX900-GISEL:       ; %bb.0: ; %entry
; GFX900-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-GISEL-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX900-GISEL-NEXT:    v_add_u32_e32 v1, 1, v1
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v4, v0, v2
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v5, v1, v3
; GFX900-GISEL-NEXT:    v_add_u32_e32 v0, v4, v0
; GFX900-GISEL-NEXT:    v_add_u32_e32 v1, v5, v1
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v3
; GFX900-GISEL-NEXT:    v_add_u32_e32 v2, 1, v4
; GFX900-GISEL-NEXT:    v_add_u32_e32 v3, 1, v5
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v4, v0, v2
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v5, v1, v3
; GFX900-GISEL-NEXT:    v_add_u32_e32 v2, v4, v2
; GFX900-GISEL-NEXT:    v_add_u32_e32 v3, v5, v3
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v1, v3, v1
; GFX900-GISEL-NEXT:    v_add_u32_e32 v2, 1, v4
; GFX900-GISEL-NEXT:    v_add_u32_e32 v3, 1, v5
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v4, v0, v2
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v5, v1, v3
; GFX900-GISEL-NEXT:    v_add_u32_e32 v2, v4, v2
; GFX900-GISEL-NEXT:    v_add_u32_e32 v3, v5, v3
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v1, v3, v1
; GFX900-GISEL-NEXT:    v_add_u32_e32 v2, 1, v4
; GFX900-GISEL-NEXT:    v_add_u32_e32 v3, 1, v5
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v2
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v3, v1, v3
; GFX900-GISEL-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX900-GISEL-NEXT:    v_add_u32_e32 v1, 1, v1
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX900-GISEL-NEXT:    v_mul_lo_u32 v1, v3, v1
; GFX900-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-SDAG-LABEL: clpeak_imad_pat_v2i32_x2:
; GFX90A-SDAG:       ; %bb.0: ; %entry
; GFX90A-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v1, 1, v1
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v4, v0, v2
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v5, v1, v3
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v1, v5, v1
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v0, v4, v0
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v1, v1, v3
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v2, 1, v4
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v3, 1, v5
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v4, v1, v3
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v5, v0, v2
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v2, v5, v2
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v3, v4, v3
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v1, v3, v1
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v2, 1, v4
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v3, 1, v5
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v6, v0, v3
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v4, v1, v2
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v2, v4, v2
; GFX90A-SDAG-NEXT:    v_add_u32_e32 v3, v6, v3
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v0, v3, v0
; GFX90A-SDAG-NEXT:    v_mul_lo_u32 v2, v2, v1
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v2, v4, v[2:3]
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[6:7], s[4:5], v0, v6, v[0:1]
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v6, v0, v[6:7]
; GFX90A-SDAG-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v4, v2, v[4:5]
; GFX90A-SDAG-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-GISEL-LABEL: clpeak_imad_pat_v2i32_x2:
; GFX90A-GISEL:       ; %bb.0: ; %entry
; GFX90A-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v0, 1, v0
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v1, 1, v1
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v4, v0, v2
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v5, v1, v3
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v0, v4, v0
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v1, v5, v1
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v3
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v2, 1, v4
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v3, 1, v5
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v4, v0, v2
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v5, v1, v3
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v2, v4, v2
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v3, v5, v3
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v1, v3, v1
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v2, 1, v4
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v3, 1, v5
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v4, v0, v2
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v5, v1, v3
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v2, v4, v2
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v3, v5, v3
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v1, v3, v1
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v2, 1, v4
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v3, 1, v5
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v4, 1, v0
; GFX90A-GISEL-NEXT:    v_add_u32_e32 v5, 1, v1
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v3
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v4
; GFX90A-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v5
; GFX90A-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: clpeak_imad_pat_v2i32_x2:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v1, 1, v1
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v4, v0, v2
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v5, v1, v3
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v0, v4, v0
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v1, v5, v1
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v2, 1, v4
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v1, v1, v3
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v3, 1, v5
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v4, v0, v2
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v5, v1, v3
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v2, v4, v2
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v3, v5, v3
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v2, 1, v4
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v1, v3, v1
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v3, 1, v5
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v4, v0, v2
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v5, v1, v3
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v2, v4, v2
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v3, v5, v3
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX10-SDAG-NEXT:    v_mul_lo_u32 v2, v3, v1
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[3:4], null, v0, v4, v[0:1]
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[4:5], null, v2, v5, v[2:3]
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[0:1], null, v3, v0, v[3:4]
; GFX10-SDAG-NEXT:    v_mad_u64_u32 v[1:2], null, v4, v2, v[4:5]
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: clpeak_imad_pat_v2i32_x2:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, 1, v1
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v4, v0, v2
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v5, v1, v3
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, v4, v0
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, v5, v1
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v1, v1, v3
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v2, 1, v4
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v3, 1, v5
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v4, v0, v2
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v5, v1, v3
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v2, v4, v2
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v3, v5, v3
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v1, v3, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v2, 1, v4
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v3, 1, v5
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v4, v0, v2
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v5, v1, v3
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v2, v4, v2
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v3, v5, v3
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v1, v3, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v2, 1, v4
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v3, 1, v5
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v2, v0, v2
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v3, v1, v3
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, 1, v1
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX10-GISEL-NEXT:    v_mul_lo_u32 v1, v3, v1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %y38 = add <2 x i32> %x, <i32 1, i32 1>
  %add = mul <2 x i32> %y38, %y
  %mul139 = add <2 x i32> %add, %y38
  %add2 = mul <2 x i32> %mul139, %y
  %add240 = add <2 x i32> %add, <i32 1, i32 1>
  %add4 = mul <2 x i32> %add2, %add240
  %mul541 = add <2 x i32> %add4, %add240
  %add6 = mul <2 x i32> %mul541, %add2
  %add642 = add <2 x i32> %add4, <i32 1, i32 1>
  %add8 = mul <2 x i32> %add6, %add642
  %mul943 = add <2 x i32> %add8, %add642
  %add10 = mul <2 x i32> %mul943, %add6
  %add1044 = add <2 x i32> %add8, <i32 1, i32 1>
  %add1246 = add <2 x i32> %add10, <i32 1, i32 1>
  %mul1345 = mul <2 x i32> %add10, %add1044
  %add14 = mul <2 x i32> %mul1345, %add1246
  ret <2 x i32> %add14
}

define signext i16 @clpeak_imad_pat_i16_x2(i16 signext %x, i16 signext %y) {
; GFX67-SDAG-LABEL: clpeak_imad_pat_i16_x2:
; GFX67-SDAG:       ; %bb.0: ; %entry
; GFX67-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v3, v0, v2
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v4, v1, v3
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v0, v2, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v4
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v4, v0, v2
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v1, v1, v3, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v4
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v4, v1, v3
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v0, v2, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v4
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v4, v0, v2
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v1, v1, v3, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v4
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v4, v1, v3
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v0, v2, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v4
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v1, v1, v3, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v0, v0, v1
; GFX67-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX67-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX67-GISEL-LABEL: clpeak_imad_pat_i16_x2:
; GFX67-GISEL:       ; %bb.0: ; %entry
; GFX67-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v0
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v0
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v0
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v1
; GFX67-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX67-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: clpeak_imad_pat_i16_x2:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v0, v1, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v0, v1, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v0, v1, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v0, v1, v0
; GFX8-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: clpeak_imad_pat_i16_x2:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u16_e32 v0, 1, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v2, v0, v1
; GFX8-GISEL-NEXT:    v_add_u16_e32 v3, 1, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v4, v3, v2
; GFX8-GISEL-NEXT:    v_mad_u16 v0, v0, v1, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v1, v0, v4
; GFX8-GISEL-NEXT:    v_mad_u16 v2, v3, v2, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v3, v2, v1
; GFX8-GISEL-NEXT:    v_mad_u16 v0, v0, v4, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v4, v0, v3
; GFX8-GISEL-NEXT:    v_mad_u16 v1, v2, v1, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v2, v1, v4
; GFX8-GISEL-NEXT:    v_mad_u16 v0, v0, v3, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_mad_u16 v1, v1, v4, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: clpeak_imad_pat_i16_x2:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v0, v1, v0, v1
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v1, v0, v1, v0
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v0, v1, v0, v1
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v1, v0, v1, v0
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v0, v1, v0, v1
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v1, v0, v1, v0
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v0, v1, v0, v1
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v0, v0, v1, v0
; GFX9-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: clpeak_imad_pat_i16_x2:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_add_u16_e32 v0, 1, v0
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v2, v0, v1
; GFX9-GISEL-NEXT:    v_add_u16_e32 v3, 1, v1
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v4, v3, v2
; GFX9-GISEL-NEXT:    v_mad_legacy_u16 v0, v0, v1, 1
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v1, v0, v4
; GFX9-GISEL-NEXT:    v_mad_legacy_u16 v2, v3, v2, 1
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v3, v2, v1
; GFX9-GISEL-NEXT:    v_mad_legacy_u16 v0, v0, v4, 1
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v4, v0, v3
; GFX9-GISEL-NEXT:    v_mad_legacy_u16 v1, v2, v1, 1
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v2, v1, v4
; GFX9-GISEL-NEXT:    v_mad_legacy_u16 v0, v0, v3, 1
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    v_mad_legacy_u16 v1, v1, v4, 1
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: clpeak_imad_pat_i16_x2:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX10-SDAG-NEXT:    v_mad_u16 v1, v0, v1, v0
; GFX10-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX10-SDAG-NEXT:    v_mad_u16 v1, v0, v1, v0
; GFX10-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX10-SDAG-NEXT:    v_mad_u16 v1, v0, v1, v0
; GFX10-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX10-SDAG-NEXT:    v_mad_u16 v0, v0, v1, v0
; GFX10-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: clpeak_imad_pat_i16_x2:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, 1
; GFX10-GISEL-NEXT:    v_add_nc_u16 v2, v1, 1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v1, v2, v0
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, 1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u16 v1, v1, 1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v1, v1, v0
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, 1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u16 v1, v1, 1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v1, v1, v0
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, 1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u16 v1, v1, 1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %conv69 = add i16 %x, 1
  %add = mul i16 %conv69, %y
  %conv470 = add i16 %y, 1
  %add8 = mul i16 %conv470, %add
  %conv1071 = add i16 %add, 1
  %add14 = mul i16 %conv1071, %add8
  %conv1672 = add i16 %add8, 1
  %add20 = mul i16 %conv1672, %add14
  %conv2273 = add i16 %add14, 1
  %add26 = mul i16 %conv2273, %add20
  %conv2874 = add i16 %add20, 1
  %add32 = mul i16 %conv2874, %add26
  %conv3475 = add i16 %add26, 1
  %add38 = mul i16 %conv3475, %add32
  %conv4076 = add i16 %add32, 1
  %add44 = mul i16 %add38, %conv4076
  ret i16 %add44
}

define zeroext i16 @clpeak_umad_pat_i16_x2(i16 zeroext %x, i16 zeroext %y) {
; GFX67-SDAG-LABEL: clpeak_umad_pat_i16_x2:
; GFX67-SDAG:       ; %bb.0: ; %entry
; GFX67-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v2, v0, v1
; GFX67-SDAG-NEXT:    v_add_i32_e32 v3, vcc, 1, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v4, v3, v2
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v0, v1, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v4
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v4, v0, v1
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v2, v3, v2, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v4
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v4, v2, v3
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v0, v1, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v4
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v4, v0, v1
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v2, v2, v3, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v4
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v4, v2, v3
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v0, v1, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v4
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v0, v0, v1
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v1, v2, v3, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v0, v0, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX67-GISEL-LABEL: clpeak_umad_pat_i16_x2:
; GFX67-GISEL:       ; %bb.0: ; %entry
; GFX67-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v0
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v0
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v0
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: clpeak_umad_pat_i16_x2:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v0, v1, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v0, v1, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v0, v1, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v0, v1, v0
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: clpeak_umad_pat_i16_x2:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u16_e32 v0, 1, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v2, v0, v1
; GFX8-GISEL-NEXT:    v_add_u16_e32 v3, 1, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v4, v3, v2
; GFX8-GISEL-NEXT:    v_mad_u16 v0, v0, v1, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v1, v0, v4
; GFX8-GISEL-NEXT:    v_mad_u16 v2, v3, v2, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v3, v2, v1
; GFX8-GISEL-NEXT:    v_mad_u16 v0, v0, v4, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v4, v0, v3
; GFX8-GISEL-NEXT:    v_mad_u16 v1, v2, v1, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v2, v1, v4
; GFX8-GISEL-NEXT:    v_mad_u16 v0, v0, v3, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_mad_u16 v1, v1, v4, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: clpeak_umad_pat_i16_x2:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v0, v1, v0, v1
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v1, v0, v1, v0
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v0, v1, v0, v1
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v1, v0, v1, v0
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v0, v1, v0, v1
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v1, v0, v1, v0
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v0, v1, v0, v1
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v0, v0, v1, v0
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: clpeak_umad_pat_i16_x2:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_add_u16_e32 v0, 1, v0
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v2, v0, v1
; GFX9-GISEL-NEXT:    v_add_u16_e32 v3, 1, v1
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v4, v3, v2
; GFX9-GISEL-NEXT:    v_mad_legacy_u16 v0, v0, v1, 1
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v1, v0, v4
; GFX9-GISEL-NEXT:    v_mad_legacy_u16 v2, v3, v2, 1
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v3, v2, v1
; GFX9-GISEL-NEXT:    v_mad_legacy_u16 v0, v0, v4, 1
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v4, v0, v3
; GFX9-GISEL-NEXT:    v_mad_legacy_u16 v1, v2, v1, 1
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v2, v1, v4
; GFX9-GISEL-NEXT:    v_mad_legacy_u16 v0, v0, v3, 1
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    v_mad_legacy_u16 v1, v1, v4, 1
; GFX9-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: clpeak_umad_pat_i16_x2:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX10-SDAG-NEXT:    v_mad_u16 v1, v0, v1, v0
; GFX10-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX10-SDAG-NEXT:    v_mad_u16 v1, v0, v1, v0
; GFX10-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX10-SDAG-NEXT:    v_mad_u16 v1, v0, v1, v0
; GFX10-SDAG-NEXT:    v_mad_u16 v0, v1, v0, v1
; GFX10-SDAG-NEXT:    v_mad_u16 v0, v0, v1, v0
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: clpeak_umad_pat_i16_x2:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, 1
; GFX10-GISEL-NEXT:    v_add_nc_u16 v2, v1, 1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v1, v2, v0
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, 1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u16 v1, v1, 1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v1, v1, v0
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, 1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u16 v1, v1, 1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v1, v1, v0
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, 1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u16 v1, v1, 1
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %conv69 = add i16 %x, 1
  %add = mul i16 %conv69, %y
  %conv470 = add i16 %y, 1
  %add8 = mul i16 %conv470, %add
  %conv1071 = add i16 %add, 1
  %add14 = mul i16 %conv1071, %add8
  %conv1672 = add i16 %add8, 1
  %add20 = mul i16 %conv1672, %add14
  %conv2273 = add i16 %add14, 1
  %add26 = mul i16 %conv2273, %add20
  %conv2874 = add i16 %add20, 1
  %add32 = mul i16 %conv2874, %add26
  %conv3475 = add i16 %add26, 1
  %add38 = mul i16 %conv3475, %add32
  %conv4076 = add i16 %add32, 1
  %add44 = mul i16 %add38, %conv4076
  ret i16 %add44
}

define <2 x i16> @clpeak_imad_pat_v2i16_x2(<2 x i16> %x, <2 x i16> %y) {
; GFX67-SDAG-LABEL: clpeak_imad_pat_v2i16_x2:
; GFX67-SDAG:       ; %bb.0: ; %entry
; GFX67-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xffff, v0
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_and_b32_e32 v5, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v4, v2, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v1, v5, v3, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v2, v4, v2, 1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v1, v1, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xffff, v2
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v3, v5, v3, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v5, 0xffff, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v2, v0, v4, v2
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v3, v1, v5, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v2, v2, v0
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v0, v4, 1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v3, v3, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xffff, v0
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v1, v1, v5, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_and_b32_e32 v5, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v2, v4, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v1, v3, v5, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v6, v0, v2
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v4, v2, v4, 1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v7, v1, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v5, v3, v5, 1
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v1, v1, v3, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v6
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v0, v2, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v5
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v3, v3, v4
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xffff, v7
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v2, v4, v2
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v0, v3, v0
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v1, v2, v1
; GFX67-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX67-GISEL-LABEL: clpeak_imad_pat_v2i16_x2:
; GFX67-GISEL:       ; %bb.0: ; %entry
; GFX67-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v5, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v0
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX67-GISEL-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v5, v5, v3
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v4, v4, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v5, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v4, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX67-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 1, v5
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 1, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v5, 0xffff, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v2
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX67-GISEL-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v5, v1, v5
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v4, v0, v4
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, v5, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v4, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX67-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v3, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 1, v5
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v2, v0
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 1, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v5, 0xffff, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v2
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX67-GISEL-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v5, v1, v5
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v4, v0, v4
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, v5, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v4, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX67-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v3, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 1, v5
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v2, v0
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 1, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v4, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX67-GISEL-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v4
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v2, 16, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v3
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v2
; GFX67-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: clpeak_imad_pat_v2i16_x2:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_mov_b32_e32 v3, 1
; GFX8-SDAG-NEXT:    v_add_u16_e32 v2, 1, v0
; GFX8-SDAG-NEXT:    v_add_u16_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-SDAG-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v4, v0, v3, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v5, v2, v1, v2
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v4, v4, v3
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v0, v3, 1
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v5, v5, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v2, v1, 1
; GFX8-SDAG-NEXT:    v_mad_u16 v2, v4, v0, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v3, v5, v1, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v2, v2, v4
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v4, v0, 1
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v3, v3, v5
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v5, v1, 1
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v4, v2, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v2, v0, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v5, v3, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v3, v1, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v1, v1, v3
; GFX8-SDAG-NEXT:    v_mad_u16 v2, v0, v4, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v3, v1, v5, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v2, v0, v2
; GFX8-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v3, v1, v3
; GFX8-SDAG-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: clpeak_imad_pat_v2i16_x2:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v3, 1
; GFX8-GISEL-NEXT:    v_add_u16_e32 v2, 1, v0
; GFX8-GISEL-NEXT:    v_add_u16_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX8-GISEL-NEXT:    v_mad_u16 v4, v2, v1, v2
; GFX8-GISEL-NEXT:    v_mad_u16 v5, v0, v3, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v4, v4, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_sdwa v5, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-GISEL-NEXT:    v_mad_u16 v1, v2, v1, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v0, v0, v3, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v2, v4, v1, v1
; GFX8-GISEL-NEXT:    v_mad_u16 v3, v5, v0, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v2, v2, v4
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v3, v3, v5
; GFX8-GISEL-NEXT:    v_mad_u16 v1, v4, v1, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v0, v5, v0, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v4, v2, v1, v1
; GFX8-GISEL-NEXT:    v_mad_u16 v5, v3, v0, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v6, v4, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v7, v5, v3
; GFX8-GISEL-NEXT:    v_mad_u16 v1, v2, v1, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v0, v3, v0, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v2, v4, v2, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v3, v5, v3, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v1, v6, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v7, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v1, v1, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u16_sdwa v0, v0, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: clpeak_imad_pat_v2i16_x2:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v0, v0, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX9-SDAG-NEXT:    v_pk_add_u16 v0, v2, v0
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v1, v2, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX9-SDAG-NEXT:    v_pk_add_u16 v1, v2, v1
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v1, v0
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v1, v2, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX9-SDAG-NEXT:    v_pk_add_u16 v1, v2, v1
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v1, v0
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v1, v2, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v2, v0, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: clpeak_imad_pat_v2i16_x2:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_pk_add_u16 v0, v0, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX9-GISEL-NEXT:    v_pk_add_u16 v0, v2, v0
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX9-GISEL-NEXT:    v_pk_add_u16 v1, v2, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX9-GISEL-NEXT:    v_pk_add_u16 v1, v2, v1
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v1, v0
; GFX9-GISEL-NEXT:    v_pk_add_u16 v1, v2, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX9-GISEL-NEXT:    v_pk_add_u16 v1, v2, v1
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v1, v0
; GFX9-GISEL-NEXT:    v_pk_add_u16 v1, v2, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_add_u16 v2, v0, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: clpeak_imad_pat_v2i16_x2:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v0, v0, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX10-SDAG-NEXT:    v_pk_add_u16 v0, v2, v0
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v2, v2, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v1, v0, v2
; GFX10-SDAG-NEXT:    v_pk_add_u16 v2, v1, v2
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v1, v1, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v2, v0
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX10-SDAG-NEXT:    v_pk_add_u16 v1, v2, v1
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v1, v0
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v1, v2, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v2, v0, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: clpeak_imad_pat_v2i16_x2:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_pk_add_u16 v0, v0, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX10-GISEL-NEXT:    v_pk_add_u16 v0, v2, v0
; GFX10-GISEL-NEXT:    v_pk_add_u16 v2, v2, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v1, v0, v2
; GFX10-GISEL-NEXT:    v_pk_add_u16 v2, v1, v2
; GFX10-GISEL-NEXT:    v_pk_add_u16 v1, v1, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v2, v0
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX10-GISEL-NEXT:    v_pk_add_u16 v1, v2, v1
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v1, v0
; GFX10-GISEL-NEXT:    v_pk_add_u16 v1, v2, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_add_u16 v2, v0, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %y38 = add <2 x i16> %x, <i16 1, i16 1>
  %add = mul <2 x i16> %y38, %y
  %mul139 = add <2 x i16> %add, %y38
  %add2 = mul <2 x i16> %mul139, %y
  %add240 = add <2 x i16> %add, <i16 1, i16 1>
  %add4 = mul <2 x i16> %add2, %add240
  %mul541 = add <2 x i16> %add4, %add240
  %add6 = mul <2 x i16> %mul541, %add2
  %add642 = add <2 x i16> %add4, <i16 1, i16 1>
  %add8 = mul <2 x i16> %add6, %add642
  %mul943 = add <2 x i16> %add8, %add642
  %add10 = mul <2 x i16> %mul943, %add6
  %add1044 = add <2 x i16> %add8, <i16 1, i16 1>
  %add1246 = add <2 x i16> %add10, <i16 1, i16 1>
  %mul1345 = mul <2 x i16> %add10, %add1044
  %add14 = mul <2 x i16> %mul1345, %add1246
  ret <2 x i16> %add14
}

define <2 x i16> @clpeak_umad_pat_v2i16_x2(<2 x i16> %x, <2 x i16> %y) {
; GFX67-SDAG-LABEL: clpeak_umad_pat_v2i16_x2:
; GFX67-SDAG:       ; %bb.0: ; %entry
; GFX67-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-SDAG-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xffff, v0
; GFX67-SDAG-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_and_b32_e32 v5, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v4, v2, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v1, v5, v3, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v2, v4, v2, 1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v1, v1, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xffff, v2
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v3, v5, v3, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v5, 0xffff, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v2, v0, v4, v2
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v3, v1, v5, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v2, v2, v0
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v0, v4, 1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v3, v3, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xffff, v0
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v1, v1, v5, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_and_b32_e32 v5, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v2, v4, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v1, v3, v5, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v6, v0, v2
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v4, v2, v4, 1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v7, v1, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v5, v3, v5, 1
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v1, v1, v3, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v6
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v0, v2, 1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v5
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v3, v3, v4
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xffff, v7
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v2, v4, v2
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v0, v3, v0
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v1, v2, v1
; GFX67-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX67-GISEL-LABEL: clpeak_umad_pat_v2i16_x2:
; GFX67-GISEL:       ; %bb.0: ; %entry
; GFX67-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v5, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v0
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX67-GISEL-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v5, v5, v3
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v4, v4, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v5, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v4, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX67-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 1, v5
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 1, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v5, 0xffff, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v2
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX67-GISEL-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v5, v1, v5
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v4, v0, v4
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, v5, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v4, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX67-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v3, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 1, v5
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v2, v0
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 1, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v5, 0xffff, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v2
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX67-GISEL-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v5, v1, v5
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v4, v0, v4
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, v5, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v4, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX67-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v3, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 1, v5
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v2, v0
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 1, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v4, vcc, 1, v1
; GFX67-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 1, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX67-GISEL-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v4
; GFX67-GISEL-NEXT:    v_lshrrev_b32_e32 v2, 16, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v3
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v2
; GFX67-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: clpeak_umad_pat_v2i16_x2:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_mov_b32_e32 v3, 1
; GFX8-SDAG-NEXT:    v_add_u16_e32 v2, 1, v0
; GFX8-SDAG-NEXT:    v_add_u16_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-SDAG-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v4, v0, v3, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v5, v2, v1, v2
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v4, v4, v3
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v0, v3, 1
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v5, v5, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v2, v1, 1
; GFX8-SDAG-NEXT:    v_mad_u16 v2, v4, v0, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v3, v5, v1, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v2, v2, v4
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v4, v0, 1
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v3, v3, v5
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v5, v1, 1
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v4, v2, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v2, v0, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v5, v3, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v3, v1, v1
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v1, v1, v3
; GFX8-SDAG-NEXT:    v_mad_u16 v2, v0, v4, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v3, v1, v5, v1
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v2, v0, v2
; GFX8-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX8-SDAG-NEXT:    v_mad_u16 v1, v3, v1, v3
; GFX8-SDAG-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: clpeak_umad_pat_v2i16_x2:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v3, 1
; GFX8-GISEL-NEXT:    v_add_u16_e32 v2, 1, v0
; GFX8-GISEL-NEXT:    v_add_u16_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX8-GISEL-NEXT:    v_mad_u16 v4, v2, v1, v2
; GFX8-GISEL-NEXT:    v_mad_u16 v5, v0, v3, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v4, v4, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_sdwa v5, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-GISEL-NEXT:    v_mad_u16 v1, v2, v1, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v0, v0, v3, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v2, v4, v1, v1
; GFX8-GISEL-NEXT:    v_mad_u16 v3, v5, v0, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v2, v2, v4
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v3, v3, v5
; GFX8-GISEL-NEXT:    v_mad_u16 v1, v4, v1, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v0, v5, v0, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v4, v2, v1, v1
; GFX8-GISEL-NEXT:    v_mad_u16 v5, v3, v0, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v6, v4, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v7, v5, v3
; GFX8-GISEL-NEXT:    v_mad_u16 v1, v2, v1, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v0, v3, v0, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v2, v4, v2, 1
; GFX8-GISEL-NEXT:    v_mad_u16 v3, v5, v3, 1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v1, v6, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v0, v7, v0
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v1, v1, v2
; GFX8-GISEL-NEXT:    v_mul_lo_u16_sdwa v0, v0, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: clpeak_umad_pat_v2i16_x2:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v0, v0, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX9-SDAG-NEXT:    v_pk_add_u16 v0, v2, v0
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v1, v2, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX9-SDAG-NEXT:    v_pk_add_u16 v1, v2, v1
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v1, v0
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v1, v2, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX9-SDAG-NEXT:    v_pk_add_u16 v1, v2, v1
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v1, v0
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v1, v2, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v2, v0, -1 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX9-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: clpeak_umad_pat_v2i16_x2:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_pk_add_u16 v0, v0, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX9-GISEL-NEXT:    v_pk_add_u16 v0, v2, v0
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX9-GISEL-NEXT:    v_pk_add_u16 v1, v2, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX9-GISEL-NEXT:    v_pk_add_u16 v1, v2, v1
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v1, v0
; GFX9-GISEL-NEXT:    v_pk_add_u16 v1, v2, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX9-GISEL-NEXT:    v_pk_add_u16 v1, v2, v1
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v1, v0
; GFX9-GISEL-NEXT:    v_pk_add_u16 v1, v2, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_add_u16 v2, v0, 1 op_sel_hi:[1,0]
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX9-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: clpeak_umad_pat_v2i16_x2:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v0, v0, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX10-SDAG-NEXT:    v_pk_add_u16 v0, v2, v0
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v2, v2, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v1, v0, v2
; GFX10-SDAG-NEXT:    v_pk_add_u16 v2, v1, v2
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v1, v1, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v2, v0
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX10-SDAG-NEXT:    v_pk_add_u16 v1, v2, v1
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v1, v0
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v1, v2, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v2, v0, -1 op_sel_hi:[1,0]
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: clpeak_umad_pat_v2i16_x2:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_pk_add_u16 v0, v0, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX10-GISEL-NEXT:    v_pk_add_u16 v0, v2, v0
; GFX10-GISEL-NEXT:    v_pk_add_u16 v2, v2, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v1, v0, v2
; GFX10-GISEL-NEXT:    v_pk_add_u16 v2, v1, v2
; GFX10-GISEL-NEXT:    v_pk_add_u16 v1, v1, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v2, v0
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v2, v0, v1
; GFX10-GISEL-NEXT:    v_pk_add_u16 v1, v2, v1
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v1, v0
; GFX10-GISEL-NEXT:    v_pk_add_u16 v1, v2, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_add_u16 v2, v0, 1 op_sel_hi:[1,0]
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %y38 = add <2 x i16> %x, <i16 1, i16 1>
  %add = mul <2 x i16> %y38, %y
  %mul139 = add <2 x i16> %add, %y38
  %add2 = mul <2 x i16> %mul139, %y
  %add240 = add <2 x i16> %add, <i16 1, i16 1>
  %add4 = mul <2 x i16> %add2, %add240
  %mul541 = add <2 x i16> %add4, %add240
  %add6 = mul <2 x i16> %mul541, %add2
  %add642 = add <2 x i16> %add4, <i16 1, i16 1>
  %add8 = mul <2 x i16> %add6, %add642
  %mul943 = add <2 x i16> %add8, %add642
  %add10 = mul <2 x i16> %mul943, %add6
  %add1044 = add <2 x i16> %add8, <i16 1, i16 1>
  %add1246 = add <2 x i16> %add10, <i16 1, i16 1>
  %mul1345 = mul <2 x i16> %add10, %add1044
  %add14 = mul <2 x i16> %mul1345, %add1246
  ret <2 x i16> %add14
}

; Multiple uses of mul with different variable addend
define <2 x i32> @multi_use_mul_mad_i32_var(i32 %x, i32 %y, i32 %z0, i32 %z1) {
; GFX67-LABEL: multi_use_mul_mad_i32_var:
; GFX67:       ; %bb.0: ; %entry
; GFX67-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX67-NEXT:    v_add_i32_e32 v0, vcc, v1, v2
; GFX67-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX67-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: multi_use_mul_mad_i32_var:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, v1, v2
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, v1, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: multi_use_mul_mad_i32_var:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX9-NEXT:    v_add_u32_e32 v0, v1, v2
; GFX9-NEXT:    v_add_u32_e32 v1, v1, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: multi_use_mul_mad_i32_var:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX10-NEXT:    v_add_nc_u32_e32 v0, v1, v2
; GFX10-NEXT:    v_add_nc_u32_e32 v1, v1, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
entry:
  %mul = mul i32 %x, %y
  %add0 = add i32 %mul, %z0
  %add1 = add i32 %mul, %z1
  %insert.0 = insertelement <2 x i32> poison, i32 %add0, i32 0
  %insert.1 = insertelement <2 x i32> %insert.0, i32 %add1, i32 1
  ret <2 x i32> %insert.1
}

define <2 x i16> @multi_use_mul_mad_i16_var(i16 %x, i16 %y, i16 %z0, i16 %z1) {
; GFX67-SDAG-LABEL: multi_use_mul_mad_i16_var:
; GFX67-SDAG:       ; %bb.0: ; %entry
; GFX67-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v4, v1, v2
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v1, v4, v1, v3
; GFX67-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX67-GISEL-LABEL: multi_use_mul_mad_i16_var:
; GFX67-GISEL:       ; %bb.0: ; %entry
; GFX67-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v0, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v1, v2
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX67-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: multi_use_mul_mad_i16_var:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_mad_u16 v3, v0, v1, v3
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v0, v1, v2
; GFX8-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; GFX8-SDAG-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: multi_use_mul_mad_i16_var:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_mad_u16 v2, v0, v1, v2
; GFX8-GISEL-NEXT:    v_mad_u16 v0, v0, v1, v3
; GFX8-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: multi_use_mul_mad_i16_var:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v2, v0, v1, v2
; GFX9-SDAG-NEXT:    v_mad_legacy_u16 v0, v0, v1, v3
; GFX9-SDAG-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-SDAG-NEXT:    v_perm_b32 v0, v0, v2, s4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: multi_use_mul_mad_i16_var:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mad_legacy_u16 v2, v0, v1, v2
; GFX9-GISEL-NEXT:    v_mad_legacy_u16 v0, v0, v1, v3
; GFX9-GISEL-NEXT:    v_lshl_or_b32 v0, v0, 16, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: multi_use_mul_mad_i16_var:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mad_u16 v2, v0, v1, v2
; GFX10-SDAG-NEXT:    v_mad_u16 v0, v0, v1, v3
; GFX10-SDAG-NEXT:    v_perm_b32 v0, v0, v2, 0x5040100
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: multi_use_mul_mad_i16_var:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u16 v1, v0, v2
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, v3
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX10-GISEL-NEXT:    v_lshl_or_b32 v0, v0, 16, v1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %mul = mul i16 %x, %y
  %add0 = add i16 %mul, %z0
  %add1 = add i16 %mul, %z1
  %insert.0 = insertelement <2 x i16> poison, i16 %add0, i16 0
  %insert.1 = insertelement <2 x i16> %insert.0, i16 %add1, i16 1
  ret <2 x i16> %insert.1
}

define i32 @other_use_mul_mad_i32_var(i32 %x, i32 %y, i32 %z, ptr addrspace(3) %ptr) {
; GFX67-LABEL: other_use_mul_mad_i32_var:
; GFX67:       ; %bb.0: ; %entry
; GFX67-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX67-NEXT:    s_mov_b32 m0, -1
; GFX67-NEXT:    v_add_i32_e32 v0, vcc, v1, v2
; GFX67-NEXT:    ds_write_b32 v3, v1
; GFX67-NEXT:    s_waitcnt lgkmcnt(0)
; GFX67-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: other_use_mul_mad_i32_var:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, v1, v2
; GFX8-NEXT:    ds_write_b32 v3, v1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: other_use_mul_mad_i32_var:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX9-NEXT:    v_add_u32_e32 v0, v1, v2
; GFX9-NEXT:    ds_write_b32 v3, v1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: other_use_mul_mad_i32_var:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX10-NEXT:    v_add_nc_u32_e32 v0, v1, v2
; GFX10-NEXT:    ds_write_b32 v3, v1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
entry:
  %mul = mul i32 %x, %y
  %add0 = add i32 %mul, %z
  store i32 %mul, ptr addrspace(3) %ptr
  ret i32 %add0
}

define i16 @other_use_mul_mad_i16_var(i16 %x, i16 %y, i16 %z, ptr addrspace(3) %ptr) {
; GFX67-SDAG-LABEL: other_use_mul_mad_i16_var:
; GFX67-SDAG:       ; %bb.0: ; %entry
; GFX67-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v4, v0, v1
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v0, v1, v2
; GFX67-SDAG-NEXT:    s_mov_b32 m0, -1
; GFX67-SDAG-NEXT:    ds_write_b16 v3, v4
; GFX67-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX67-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX67-GISEL-LABEL: other_use_mul_mad_i16_var:
; GFX67-GISEL:       ; %bb.0: ; %entry
; GFX67-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v0, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v1, v2
; GFX67-GISEL-NEXT:    s_mov_b32 m0, -1
; GFX67-GISEL-NEXT:    ds_write_b16 v3, v1
; GFX67-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX67-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: other_use_mul_mad_i16_var:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_lo_u16_e32 v4, v0, v1
; GFX8-NEXT:    v_mad_u16 v0, v0, v1, v2
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_write_b16 v3, v4
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: other_use_mul_mad_i16_var:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_lo_u16_e32 v4, v0, v1
; GFX9-NEXT:    v_mad_legacy_u16 v0, v0, v1, v2
; GFX9-NEXT:    ds_write_b16 v3, v4
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: other_use_mul_mad_i16_var:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mul_lo_u16 v4, v0, v1
; GFX10-SDAG-NEXT:    v_mad_u16 v0, v0, v1, v2
; GFX10-SDAG-NEXT:    ds_write_b16 v3, v4
; GFX10-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: other_use_mul_mad_i16_var:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_lo_u16 v1, v0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v1, v2
; GFX10-GISEL-NEXT:    ds_write_b16 v3, v1
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %mul = mul i16 %x, %y
  %add0 = add i16 %mul, %z
  store i16 %mul, ptr addrspace(3) %ptr
  ret i16 %add0
}

define <4 x i16> @multi_use_mul_mad_v2i16_var(<2 x i16> %x, <2 x i16> %y, <2 x i16> %z0, <2 x i16> %z1) {
; GFX67-SDAG-LABEL: multi_use_mul_mad_v2i16_var:
; GFX67-SDAG:       ; %bb.0: ; %entry
; GFX67-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-SDAG-NEXT:    v_and_b32_e32 v8, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v5, v1, v3, v5
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v4, v8, v2, v4
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v3, v1, v3, v7
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v2, v8, v2, v6
; GFX67-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 16, v5
; GFX67-SDAG-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX67-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX67-SDAG-NEXT:    v_or_b32_e32 v2, v2, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v5
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX67-GISEL-LABEL: multi_use_mul_mad_v2i16_var:
; GFX67-GISEL:       ; %bb.0: ; %entry
; GFX67-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v2, v0, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v3
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v3, v0, v1
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v2, v4
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v3, v5
; GFX67-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v2, v6
; GFX67-GISEL-NEXT:    v_add_i32_e32 v3, vcc, v3, v7
; GFX67-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: multi_use_mul_mad_v2i16_var:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_lshrrev_b32_e32 v4, 16, v1
; GFX8-SDAG-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX8-SDAG-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX8-SDAG-NEXT:    v_mad_u16 v6, v5, v4, v6
; GFX8-SDAG-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX8-SDAG-NEXT:    v_mad_u16 v2, v0, v1, v2
; GFX8-SDAG-NEXT:    v_or_b32_e32 v2, v2, v6
; GFX8-SDAG-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; GFX8-SDAG-NEXT:    v_mad_u16 v4, v5, v4, v6
; GFX8-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v0, v1, v3
; GFX8-SDAG-NEXT:    v_or_b32_e32 v1, v0, v4
; GFX8-SDAG-NEXT:    v_mov_b32_e32 v0, v2
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: multi_use_mul_mad_v2i16_var:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_lshrrev_b32_e32 v4, 16, v0
; GFX8-GISEL-NEXT:    v_lshrrev_b32_e32 v5, 16, v1
; GFX8-GISEL-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX8-GISEL-NEXT:    v_mad_u16 v6, v4, v5, v6
; GFX8-GISEL-NEXT:    v_mad_u16 v2, v0, v1, v2
; GFX8-GISEL-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX8-GISEL-NEXT:    v_or_b32_e32 v2, v2, v6
; GFX8-GISEL-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; GFX8-GISEL-NEXT:    v_mad_u16 v0, v0, v1, v3
; GFX8-GISEL-NEXT:    v_mad_u16 v1, v4, v5, v6
; GFX8-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX8-GISEL-NEXT:    v_or_b32_e32 v1, v0, v1
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v0, v2
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: multi_use_mul_mad_v2i16_var:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_mul_lo_u16 v1, v0, v1
; GFX9-NEXT:    v_pk_add_u16 v0, v1, v2
; GFX9-NEXT:    v_pk_add_u16 v1, v1, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: multi_use_mul_mad_v2i16_var:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_mul_lo_u16 v1, v0, v1
; GFX10-NEXT:    v_pk_add_u16 v0, v1, v2
; GFX10-NEXT:    v_pk_add_u16 v1, v1, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
entry:
  %mul = mul <2 x i16> %x, %y
  %add0 = add <2 x i16> %mul, %z0
  %add1 = add <2 x i16> %mul, %z1
  %shuffle = shufflevector <2 x i16> %add0, <2 x i16> %add1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x i16> %shuffle
}

define <2 x i16> @other_use_mul_mad_v2i16_var(<2 x i16> %x, <2 x i16> %y, <2 x i16> %z, ptr addrspace(3) %ptr) {
; GFX67-SDAG-LABEL: other_use_mul_mad_v2i16_var:
; GFX67-SDAG:       ; %bb.0: ; %entry
; GFX67-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v7, v0, v2
; GFX67-SDAG-NEXT:    v_mul_u32_u24_e32 v8, v1, v3
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v1, v1, v3, v5
; GFX67-SDAG-NEXT:    v_mad_u32_u24 v0, v0, v2, v4
; GFX67-SDAG-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX67-SDAG-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX67-SDAG-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-SDAG-NEXT:    v_or_b32_e32 v7, v7, v8
; GFX67-SDAG-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX67-SDAG-NEXT:    s_mov_b32 m0, -1
; GFX67-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-SDAG-NEXT:    ds_write_b32 v6, v7
; GFX67-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX67-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX67-GISEL-LABEL: other_use_mul_mad_v2i16_var:
; GFX67-GISEL:       ; %bb.0: ; %entry
; GFX67-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX67-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v3
; GFX67-GISEL-NEXT:    v_mul_u32_u24_e32 v1, v1, v2
; GFX67-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v1
; GFX67-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v0
; GFX67-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX67-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX67-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GFX67-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v5
; GFX67-GISEL-NEXT:    s_mov_b32 m0, -1
; GFX67-GISEL-NEXT:    ds_write_b32 v6, v2
; GFX67-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX67-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: other_use_mul_mad_v2i16_var:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_lshrrev_b32_e32 v4, 16, v1
; GFX8-SDAG-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX8-SDAG-NEXT:    v_mul_lo_u16_sdwa v6, v5, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-SDAG-NEXT:    v_mul_lo_u16_e32 v7, v0, v1
; GFX8-SDAG-NEXT:    v_or_b32_e32 v6, v7, v6
; GFX8-SDAG-NEXT:    v_lshrrev_b32_e32 v7, 16, v2
; GFX8-SDAG-NEXT:    v_mad_u16 v4, v5, v4, v7
; GFX8-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX8-SDAG-NEXT:    v_mad_u16 v0, v0, v1, v2
; GFX8-SDAG-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX8-SDAG-NEXT:    s_mov_b32 m0, -1
; GFX8-SDAG-NEXT:    ds_write_b32 v3, v6
; GFX8-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: other_use_mul_mad_v2i16_var:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_lshrrev_b32_e32 v4, 16, v0
; GFX8-GISEL-NEXT:    v_lshrrev_b32_e32 v5, 16, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_e32 v6, v0, v1
; GFX8-GISEL-NEXT:    v_mul_lo_u16_sdwa v7, v4, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_or_b32_e32 v6, v6, v7
; GFX8-GISEL-NEXT:    v_lshrrev_b32_e32 v7, 16, v2
; GFX8-GISEL-NEXT:    v_mad_u16 v0, v0, v1, v2
; GFX8-GISEL-NEXT:    v_mad_u16 v1, v4, v5, v7
; GFX8-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    s_mov_b32 m0, -1
; GFX8-GISEL-NEXT:    ds_write_b32 v3, v6
; GFX8-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: other_use_mul_mad_v2i16_var:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_mul_lo_u16 v1, v0, v1
; GFX9-NEXT:    v_pk_add_u16 v0, v1, v2
; GFX9-NEXT:    ds_write_b32 v3, v1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: other_use_mul_mad_v2i16_var:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_mul_lo_u16 v1, v0, v1
; GFX10-NEXT:    v_pk_add_u16 v0, v1, v2
; GFX10-NEXT:    ds_write_b32 v3, v1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
entry:
  %mul = mul <2 x i16> %x, %y
  %add0 = add <2 x i16> %mul, %z
  store <2 x i16> %mul, ptr addrspace(3) %ptr
  ret <2 x i16> %add0
}

;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX6: {{.*}}
; GFX7: {{.*}}
; GFX90A: {{.*}}
