<!--
Copyright (C) 1998 - 2022 Daniel Stenberg, <daniel@haxx.se>, et al.

SPDX-License-Identifier: curl
-->

# [![curl logo](https://curl.se/logo/curl-logo.svg)](https://curl.se/)

[![OpenSSF Best Practices](https://bestpractices.coreinfrastructure.org/projects/63/badge)](https://bestpractices.coreinfrastructure.org/projects/63)
[![Coverity passed](https://scan.coverity.com/projects/curl/badge.svg)](https://scan.coverity.com/projects/curl)
[![AppVeyor Build Status](https://ci.appveyor.com/api/projects/status/l1vv31029huhf4g4?svg=true)](https://ci.appveyor.com/project/curlorg/curl)
[![Azure DevOps Build Status](https://dev.azure.com/daniel0244/curl/_apis/build/status/curl.curl?branchName=master)](https://dev.azure.com/daniel0244/curl/_build/latest?definitionId=1&branchName=master)
[![Cirrus Build Status](https://api.cirrus-ci.com/github/curl/curl.svg?branch=master)](https://cirrus-ci.com/github/curl/curl)
[![GitHub Actions Linux Build Status](https://github.com/curl/curl/actions/workflows/linux.yml/badge.svg)](https://github.com/curl/curl/actions/workflows/linux.yml)
[![GitHub Actions macOS Build Status](https://github.com/curl/curl/actions/workflows/macos.yml/badge.svg)](https://github.com/curl/curl/actions/workflows/macos.yml)
[![Backers on Open Collective](https://opencollective.com/curl/backers/badge.svg)](#backers)
[![Sponsors on Open Collective](https://opencollective.com/curl/sponsors/badge.svg)](#sponsors)
[![Language Grade: C/C++](https://img.shields.io/lgtm/grade/cpp/g/curl/curl.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/curl/curl/context:cpp)
[![Fuzzing Status](https://oss-fuzz-build-logs.storage.googleapis.com/badges/curl.svg)](https://bugs.chromium.org/p/oss-fuzz/issues/list?sort=-opened&can=1&q=proj:curl)
[![REUSE status](https://api.reuse.software/badge/github.com/curl/curl)](https://api.reuse.software/info/github.com/curl/curl)

Curl is a command-line tool for transferring data specified with URL
syntax. Find out how to use curl by reading [the curl.1 man
page](https://curl.se/docs/manpage.html) or [the MANUAL
document](https://curl.se/docs/manual.html). Find out how to install Curl
by reading [the INSTALL document](https://curl.se/docs/install.html).

libcurl is the library curl is using to do its job. It is readily available to
be used by your software. Read [the libcurl.3 man
page](https://curl.se/libcurl/c/libcurl.html) to learn how.

You can find answers to the most frequent questions we get in [the FAQ
document](https://curl.se/docs/faq.html).

Study [the COPYING file](https://curl.se/docs/copyright.html) for
distribution terms.

## Contact

If you have problems, questions, ideas or suggestions, please contact us by
posting to a suitable [mailing list](https://curl.se/mail/).

All contributors to the project are listed in [the THANKS
document](https://curl.se/docs/thanks.html).

## Commercial support

For commercial support, maybe private and dedicated help with your problems or
applications using (lib)curl visit [the support page](https://curl.se/support.html).

## Website

Visit the [curl website](https://curl.se/) for the latest news and
downloads.

## Git

To download the latest source from the Git server, do this:

    git clone https://github.com/curl/curl.git

(you will get a directory named curl created, filled with the source code)

## Security problems

Report suspected security problems via [our HackerOne
page](https://hackerone.com/curl) and not in public.

## Notice

Curl contains pieces of source code that is Copyright (c) 1998, 1999 Kungliga
Tekniska Högskolan. This notice is included here to comply with the
distribution terms.

## Backers

Thank you to all our backers! 🙏 [[Become a backer](https://opencollective.com/curl#backer)]

[![Open Collective Backers](https://opencollective.com/curl/backers.svg?width=890)](https://opencollective.com/curl#backers)

## Sponsors

Support this project by becoming a sponsor. Your logo will show up here with a
link to your website. [[Become a sponsor](https://opencollective.com/curl#sponsor)]
<!-- markdown-link-check-disable -->
[![Open Collective Sponsor 0](https://opencollective.com/curl/sponsor/0/avatar.svg)](https://opencollective.com/curl/sponsor/0/website)
[![Open Collective Sponsor 1](https://opencollective.com/curl/sponsor/1/avatar.svg)](https://opencollective.com/curl/sponsor/1/website)
[![Open Collective Sponsor 2](https://opencollective.com/curl/sponsor/2/avatar.svg)](https://opencollective.com/curl/sponsor/2/website)
[![Open Collective Sponsor 3](https://opencollective.com/curl/sponsor/3/avatar.svg)](https://opencollective.com/curl/sponsor/3/website)
[![Open Collective Sponsor 4](https://opencollective.com/curl/sponsor/4/avatar.svg)](https://opencollective.com/curl/sponsor/4/website)
[![Open Collective Sponsor 5](https://opencollective.com/curl/sponsor/5/avatar.svg)](https://opencollective.com/curl/sponsor/5/website)
[![Open Collective Sponsor 6](https://opencollective.com/curl/sponsor/6/avatar.svg)](https://opencollective.com/curl/sponsor/6/website)
[![Open Collective Sponsor 7](https://opencollective.com/curl/sponsor/7/avatar.svg)](https://opencollective.com/curl/sponsor/7/website)
[![Open Collective Sponsor 8](https://opencollective.com/curl/sponsor/8/avatar.svg)](https://opencollective.com/curl/sponsor/8/website)
[![Open Collective Sponsor 9](https://opencollective.com/curl/sponsor/9/avatar.svg)](https://opencollective.com/curl/sponsor/9/website)
