/*
 *	network related utilities
 *
 *	Copyright (C) 2009-2010 Olaf Kirch <okir@suse.de>
 *	Copyright (C) 2011-2021 SUSE LCC
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 *	Authors:
 *		Olaf Kirch
 *		Marius Tomaschewski
 *
 *	libnetcontrol contains source code which is based on wicked.
 *	Wicked is licensed under the GPL-2.0+, but permission has been
 *	granted by the authors of wicked to use the code derived from
 *	wicked under the LGPL-2.1+ in libnetcontrol.
 *	See the wicked project at <https://github.com/openSUSE/wicked>..
 *
 */
#ifndef __NETCONTROL_NUTILS_H
#define __NETCONTROL_NUTILS_H
#if defined(HAVE_CONFIG_H)
#include <config.h>
#endif

#include <ntypes.h>
#include <sutils.h>

int		nc_hw_address_parse(nc_hwaddr_t *hwa, unsigned int type, const char *hwastr);
const char *	nc_hw_address_format(const nc_hwaddr_t *hwa, nc_stringbuf_t *nsb);
int /* bool */	nc_hw_address_equal(const nc_hwaddr_t *hwa1, const nc_hwaddr_t *hwa2);

nc_address_t *	nc_address_new(int af, unsigned int prefix_len,
				const nc_sockaddr_t *local_addr);
void		nc_address_free(nc_address_t *);
nc_address_t *	nc_address_clone(const nc_address_t *src);
unsigned int	nc_address_bits(int af);
unsigned int	nc_address_byte(int af);

int		nc_address_parse(nc_sockaddr_t *ss, const char *string, int af);
const char *	nc_address_format(const nc_sockaddr_t *ss, nc_stringbuf_t *nsb);

int 		nc_address_prefix_parse(nc_sockaddr_t *ss, unsigned int *plen, const char *string, int af);

int /* bool */	nc_address_equal(const nc_sockaddr_t *, const nc_sockaddr_t *);
int /* bool */	nc_address_prefix_match(unsigned int prefix_bits, const nc_sockaddr_t *laddr,
		                                                  const nc_sockaddr_t *gw);

int /* bool */	nc_address_can_reach(const nc_address_t *laddr, const nc_sockaddr_t *gw);
int /* bool */	nc_address_can_reach_one(const nc_address_array_t *laddrs, const nc_sockaddr_t *gw);

int             nc_netmask_build(int af, unsigned int prefix_len, nc_sockaddr_t *mask);
unsigned int	nc_netmask_bits(const nc_sockaddr_t *mask);

void		nc_address_array_init   (nc_address_array_t *array);
int		nc_address_array_copy   (nc_address_array_t *dst, const nc_address_array_t *src);
int		nc_address_array_append (nc_address_array_t *array, nc_address_t *ap);
void		nc_address_array_destroy(nc_address_array_t *array);

nc_route_t *	nc_route_new(void);
nc_route_t *	nc_route_create(unsigned int prefixlen, const nc_sockaddr_t *dest,
				const nc_sockaddr_t *gw, const char *ifname, const char *opts);
nc_route_t *	nc_route_ref(nc_route_t *rp);
unsigned int	nc_route_free(nc_route_t *rp);
nc_route_t *	nc_route_clone(const nc_route_t *rp);

void		nc_route_array_init(nc_route_array_t *array);
void		nc_route_array_destroy(nc_route_array_t *array);
int		nc_route_array_copy   (nc_route_array_t *dst, const nc_route_array_t *src);
int		nc_route_array_append (nc_route_array_t *array, nc_route_t *rp);
int		nc_route_array_remove_index(nc_route_array_t *array, unsigned int pos);

#endif /* __NETCONTROL_NUTILS_H */
