/*
 *	log output redirection hooks
 *
 *	Copyright (C) 2011 SUSE LINUX Products GmbH, Nuernberg, Germany.
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation; either
 *	version 2.1 of the License, or (at your option) any later version.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *	MA  02110-1301  USA
 *
 *	Authors: Marius Tomaschewski <mt@suse.de>
 *
 *	libnetcontrol contains source code which is based on wicked.
 *	Wicked is licensed under the GPL-2.0+, but permission has been
 *	granted by the authors of wicked to use the code derived from
 *	wicked under the LGPL-2.1+ in libnetcontrol.
 *	You can find the wicked project at http://gitorious.org/wicked/.
 */
#ifndef NETCONTROL_LOGGER_H
#define NETCONTROL_LOGGER_H

#include <sys/types.h>

/**
 * @brief priorities used by nc_logger_t
 */
typedef enum {
        NC_LOG_FATAL = 0,
        NC_LOG_ERROR,
        NC_LOG_WARN,
        NC_LOG_INFO,
        NC_LOG_DEBUG,
} nc_logger_priority_t;

/**
 * @brief Log driver redirection callback function.
 * @param category A category string, may be NULL.
 * @param priority The priority of the log messages.
 * @param func     Function name where the message were issued.
 * @param file     File name where the message were issued.
 * @param line     File line number where the message were issued.
 * @param msg      The log message string.
 * @param len      Length of the log message.
 */
typedef void  (*nc_logger_t)(const char *category, int priority,
                             const char *func, const char *file,
                             long long   line,
			     const char *msg, size_t len);

/**
 * @brief Redirect netcontrol log messages.
 *
 * Redirects netcontrol log messages to the specified function.
 *
 * @param logger Callback function to redirect log messages to.
 * @return 0 on success,
 *         -1 on initialization / mutex locking error,
 *         -2 when a redirection is already active.
 */
int             nc_logger_redirect_to(nc_logger_t logger);

#endif /* NETCONTROL_LOGGER_H */
