Object.assign(window.search, {"doc_urls":["index.html#rust-style-guide","index.html#motivation---why-use-a-formatting-tool","index.html#formatting-conventions","index.html#indentation-and-line-width","index.html#blank-lines","index.html#module-level-items","index.html#statements","index.html#expressions","index.html#types","index.html#comments","index.html#attributes","index.html#small--items","index.html#non-formatting-conventions","index.html#cargotoml-conventions","index.html#principles-used-for-deciding-these-guidelines","items.html#items","items.html#function-definitions","items.html#tuples-and-tuple-structs","items.html#enums","items.html#structs-and-unions","items.html#tuple-structs","items.html#traits","items.html#impls","items.html#extern-crate","items.html#modules","items.html#macro_rules","items.html#generics","items.html#where-clauses","items.html#type-aliases","items.html#associated-types","items.html#extern-items","items.html#imports-use-statements","statements.html#let-statements","statements.html#macros-in-statement-position","statements.html#expressions-in-statement-position","expressions.html#expressions","expressions.html#blocks","expressions.html#closures","expressions.html#struct-literals","expressions.html#tuple-literals","expressions.html#tuple-struct-literals","expressions.html#enum-literals","expressions.html#array-literals","expressions.html#array-accesses-indexing-and-slicing","expressions.html#unary-operations","expressions.html#binary-operations","expressions.html#control-flow","expressions.html#function-calls","expressions.html#method-calls","expressions.html#macro-uses","expressions.html#casts-as","expressions.html#chains-of-fields-and-method-calls","expressions.html#control-flow-expressions","expressions.html#match","expressions.html#combinable-expressions","expressions.html#ranges","expressions.html#hexadecimal-literals","expressions.html#patterns","types.html#types-and-bounds","types.html#single-line-formatting","types.html#line-breaks","advice.html#other-style-advice","advice.html#expressions","advice.html#names","advice.html#modules","cargo.html#cargotoml-conventions","cargo.html#formatting-conventions","cargo.html#metadata-conventions","principles.html#guiding-principles-and-rationale","principles.html#overarching-guidelines"],"index":{"documentStore":{"docInfo":{"0":{"body":0,"breadcrumbs":4,"title":3},"1":{"body":92,"breadcrumbs":5,"title":4},"10":{"body":68,"breadcrumbs":2,"title":1},"11":{"body":71,"breadcrumbs":3,"title":2},"12":{"body":0,"breadcrumbs":4,"title":3},"13":{"body":0,"breadcrumbs":3,"title":2},"14":{"body":0,"breadcrumbs":5,"title":4},"15":{"body":46,"breadcrumbs":4,"title":1},"16":{"body":64,"breadcrumbs":5,"title":2},"17":{"body":24,"breadcrumbs":6,"title":3},"18":{"body":78,"breadcrumbs":4,"title":1},"19":{"body":89,"breadcrumbs":5,"title":2},"2":{"body":0,"breadcrumbs":3,"title":2},"20":{"body":65,"breadcrumbs":5,"title":2},"21":{"body":76,"breadcrumbs":4,"title":1},"22":{"body":47,"breadcrumbs":4,"title":1},"23":{"body":11,"breadcrumbs":5,"title":2},"24":{"body":15,"breadcrumbs":4,"title":1},"25":{"body":6,"breadcrumbs":4,"title":1},"26":{"body":101,"breadcrumbs":4,"title":1},"27":{"body":174,"breadcrumbs":4,"title":1},"28":{"body":54,"breadcrumbs":5,"title":2},"29":{"body":17,"breadcrumbs":5,"title":2},"3":{"body":24,"breadcrumbs":4,"title":3},"30":{"body":21,"breadcrumbs":5,"title":2},"31":{"body":267,"breadcrumbs":6,"title":3},"32":{"body":321,"breadcrumbs":2,"title":1},"33":{"body":18,"breadcrumbs":4,"title":3},"34":{"body":39,"breadcrumbs":4,"title":3},"35":{"body":0,"breadcrumbs":2,"title":1},"36":{"body":131,"breadcrumbs":2,"title":1},"37":{"body":72,"breadcrumbs":2,"title":1},"38":{"body":55,"breadcrumbs":3,"title":2},"39":{"body":25,"breadcrumbs":3,"title":2},"4":{"body":52,"breadcrumbs":3,"title":2},"40":{"body":13,"breadcrumbs":4,"title":3},"41":{"body":23,"breadcrumbs":3,"title":2},"42":{"body":75,"breadcrumbs":3,"title":2},"43":{"body":42,"breadcrumbs":5,"title":4},"44":{"body":18,"breadcrumbs":3,"title":2},"45":{"body":83,"breadcrumbs":3,"title":2},"46":{"body":21,"breadcrumbs":3,"title":2},"47":{"body":90,"breadcrumbs":3,"title":2},"48":{"body":10,"breadcrumbs":3,"title":2},"49":{"body":58,"breadcrumbs":3,"title":2},"5":{"body":0,"breadcrumbs":4,"title":3},"50":{"body":11,"breadcrumbs":2,"title":1},"51":{"body":134,"breadcrumbs":5,"title":4},"52":{"body":134,"breadcrumbs":4,"title":3},"53":{"body":311,"breadcrumbs":2,"title":1},"54":{"body":84,"breadcrumbs":3,"title":2},"55":{"body":42,"breadcrumbs":2,"title":1},"56":{"body":35,"breadcrumbs":3,"title":2},"57":{"body":12,"breadcrumbs":2,"title":1},"58":{"body":0,"breadcrumbs":3,"title":2},"59":{"body":119,"breadcrumbs":4,"title":3},"6":{"body":0,"breadcrumbs":2,"title":1},"60":{"body":58,"breadcrumbs":3,"title":2},"61":{"body":0,"breadcrumbs":5,"title":2},"62":{"body":18,"breadcrumbs":4,"title":1},"63":{"body":48,"breadcrumbs":4,"title":1},"64":{"body":4,"breadcrumbs":4,"title":1},"65":{"body":0,"breadcrumbs":4,"title":2},"66":{"body":215,"breadcrumbs":4,"title":2},"67":{"body":104,"breadcrumbs":4,"title":2},"68":{"body":84,"breadcrumbs":7,"title":3},"69":{"body":48,"breadcrumbs":6,"title":2},"7":{"body":0,"breadcrumbs":2,"title":1},"8":{"body":0,"breadcrumbs":2,"title":1},"9":{"body":164,"breadcrumbs":2,"title":1}},"docs":{"0":{"body":"","breadcrumbs":"Introduction » Rust Style Guide","id":"0","title":"Rust Style Guide"},"1":{"body":"Formatting code is a mostly mechanical task which takes both time and mental effort. By using an automatic formatting tool, a programmer is relieved of this task and can concentrate on more important things. Furthermore, by sticking to an established style guide (such as this one), programmers don't need to formulate ad hoc style rules, nor do they need to debate with other programmers what style rules should be used, saving time, communication overhead, and mental energy. Humans comprehend information through pattern matching. By ensuring that all Rust code has similar formatting, less mental effort is required to comprehend a new project, lowering the barrier to entry for new developers. Thus, there are productivity benefits to using a formatting tool (such as rustfmt), and even larger benefits by using a community-consistent formatting, typically by using a formatting tool's default settings.","breadcrumbs":"Introduction » Motivation - why use a formatting tool?","id":"1","title":"Motivation - why use a formatting tool?"},"10":{"body":"Put each attribute on its own line, indented to the level of the item. In the case of inner attributes (#!), indent it to the level of the inside of the item. Prefer outer attributes, where possible. For attributes with argument lists, format like functions. #[repr(C)]\n#[foo(foo, bar)]\nstruct CRepr { #![repr(C)] x: f32, y: f32,\n} For attributes with an equal sign, there should be a single space before and after the =, e.g., #[foo = 42]. There must only be a single derive attribute. Note for tool authors: if combining multiple derive attributes into a single attribute, the ordering of the derived names should be preserved. E.g., #[derive(bar)] #[derive(foo)] struct Baz; should be formatted to #[derive(bar, foo)] struct Baz;.","breadcrumbs":"Introduction » Attributes","id":"10","title":"Attributes"},"11":{"body":"In many places in this guide we specify that a formatter may format an item differently if it is small , for example struct literals: // Normal formatting\nFoo { f1: an_expression, f2: another_expression(),\n} // *small* formatting\nFoo { f1, f2 } We leave it to individual tools to decide on exactly what small means. In particular, tools are free to use different definitions in different circumstances. Some suitable heuristics are the size of the item (in characters) or the complexity of an item (for example, that all components must be simple names, not more complex sub-expressions). For more discussion on suitable heuristics, see this issue . Tools should give the user an option to ignore such heuristics and always use the normal formatting.","breadcrumbs":"Introduction » small items","id":"11","title":"small items"},"12":{"body":"","breadcrumbs":"Introduction » Non-formatting conventions","id":"12","title":"Non-formatting conventions"},"13":{"body":"","breadcrumbs":"Introduction » Cargo.toml conventions","id":"13","title":"Cargo.toml conventions"},"14":{"body":"","breadcrumbs":"Introduction » Principles used for deciding these guidelines","id":"14","title":"Principles used for deciding these guidelines"},"15":{"body":"extern crate statements must be first in a file. They must be ordered alphabetically. use statements, and module declarations (mod foo;, not mod { ... }) must come before other items. We recommend that imports come before module declarations; if imports and modules are separated, then they should be ordered alphabetically. When sorting, self and super must come before any other names. Module declarations should not be moved if they are annotated with #[macro_use], since that may be semantics changing. Tools should make the above ordering optional.","breadcrumbs":"Module-level items » Items","id":"15","title":"Items"},"16":{"body":"In Rust, one finds functions by searching for fn [function-name]; It's important that you style your code so that it's very searchable in this way. The proper ordering and spacing is: [pub] [unsafe] [extern [\"ABI\"]] fn foo(arg1: i32, arg2: i32) -> i32 { ...\n} Avoid comments within the signature itself. If the function signature does not fit on one line, then break after the opening parenthesis and before the closing parenthesis and put each argument on its own block-indented line. For example, fn foo( arg1: i32, arg2: i32,\n) -> i32 { ...\n} Note the trailing comma on the last argument.","breadcrumbs":"Module-level items » Function definitions","id":"16","title":"Function definitions"},"17":{"body":"Write the type list as you would a parameter list to a function. Build a tuple or tuple struct as you would call a function. Single-line struct Bar(Type1, Type2); let x = Bar(11, 22);\nlet y = (11, 22, 33);","breadcrumbs":"Module-level items » Tuples and tuple structs","id":"17","title":"Tuples and tuple structs"},"18":{"body":"In the declaration, put each variant on its own line, block indented. Format each variant accordingly as either a struct, tuple struct, or identifier, which doesn't require special formatting (but without the struct keyword. enum FooBar { First(u32), Second, Error { err: Box<Error>, line: u32, },\n} If a struct variant is small , it may be formatted on one line. In this case, do not use a trailing comma for the field list, but do put spaces around each brace: enum FooBar { Error { err: Box<Error>, line: u32 },\n} In an enum with multiple struct variants, if any struct variant is written on multiple lines, then the multi-line formatting should be used for all struct variants. However, such a situation might be an indication that you should factor out the fields of the variant into their own struct.","breadcrumbs":"Module-level items » Enums","id":"18","title":"Enums"},"19":{"body":"Struct names follow on the same line as the struct keyword, with the opening brace on the same line when it fits within the right margin. All struct fields are indented once and end with a trailing comma. The closing brace is not indented and appears on its own line. struct Foo { a: A, b: B,\n} If and only if the type of a field does not fit within the right margin, it is pulled down to its own line and indented again. struct Foo { a: A, long_name: LongType,\n} Prefer using a unit struct (e.g., struct Foo;) to an empty struct (e.g., struct Foo(); or struct Foo {}, these only exist to simplify code generation), but if you must use an empty struct, keep it on one line with no space between the braces: struct Foo; or struct Foo {}. The same guidelines are used for untagged union declarations. union Foo { a: A, b: B, long_name: LongType,\n}","breadcrumbs":"Module-level items » Structs and Unions","id":"19","title":"Structs and Unions"},"2":{"body":"","breadcrumbs":"Introduction » Formatting conventions","id":"2","title":"Formatting conventions"},"20":{"body":"Put the whole struct on one line if possible. Types in the parentheses should be separated by a comma and space with no trailing comma. No spaces around the parentheses or semi-colon: pub struct Foo(String, u8); Prefer unit structs to empty tuple structs (these only exist to simplify code generation), e.g., struct Foo; rather than struct Foo();. For more than a few fields, prefer a proper struct with named fields. Given this, a tuple struct should always fit on one line. If it does not, block format the fields with a field on each line and a trailing comma: pub struct Foo( String, u8,\n);","breadcrumbs":"Module-level items » Tuple structs","id":"20","title":"Tuple structs"},"21":{"body":"Trait items should be block-indented. If there are no items, the trait may be formatted on a single line. Otherwise there should be line-breaks after the opening brace and before the closing brace: trait Foo {} pub trait Bar { ...\n} If the trait has bounds, there should be a space after the colon but not before and before and after each +, e.g., trait Foo: Debug + Bar {} Prefer not to line-break in the bounds if possible (consider using a where clause). Prefer to break between bounds than to break any individual bound. If you must break the bounds, put each bound (including the first) on its own block-indented line, break before the + and put the opening brace on its own line: pub trait IndexRanges: Index<Range<usize>, Output=Self> + Index<RangeTo<usize>, Output=Self> + Index<RangeFrom<usize>, Output=Self> + Index<RangeFull, Output=Self>\n{ ...\n}","breadcrumbs":"Module-level items » Traits","id":"21","title":"Traits"},"22":{"body":"Impl items should be block indented. If there are no items, the impl may be formatted on a single line. Otherwise there should be line-breaks after the opening brace and before the closing brace: impl Foo {} impl Bar for Foo { ...\n} Avoid line-breaking in the signature if possible. If a line break is required in a non-inherent impl, break immediately before for, block indent the concrete type and put the opening brace on its own line: impl Bar for Foo\n{ ...\n}","breadcrumbs":"Module-level items » Impls","id":"22","title":"Impls"},"23":{"body":"extern crate foo; Use spaces around keywords, no spaces around the semi-colon.","breadcrumbs":"Module-level items » Extern crate","id":"23","title":"Extern crate"},"24":{"body":"mod foo {\n} mod foo; Use spaces around keywords and before the opening brace, no spaces around the semi-colon.","breadcrumbs":"Module-level items » Modules","id":"24","title":"Modules"},"25":{"body":"Use {} for the full definition of the macro. macro_rules! foo {\n}","breadcrumbs":"Module-level items » macro_rules!","id":"25","title":"macro_rules!"},"26":{"body":"Prefer to put a generics clause on one line. Break other parts of an item declaration rather than line-breaking a generics clause. If a generics clause is large enough to require line-breaking, you should prefer to use a where clause instead. Do not put spaces before or after < nor before >. Only put a space after > if it is followed by a word or opening brace, not an opening parenthesis. There should be a space after each comma and no trailing comma. fn foo<T: Display, U: Debug>(x: Vec<T>, y: Vec<U>) ... impl<T: Display, U: Debug> SomeType<T, U> { ... If the generics clause must be formatted across multiple lines, each parameter should have its own block-indented line, there should be newlines after the opening bracket and before the closing bracket, and the should be a trailing comma. fn foo< T: Display, U: Debug,\n>(x: Vec<T>, y: Vec<U>) ... If an associated type is bound in a generic type, then there should be spaces on either side of the =: <T: Example<Item = u32>> Prefer to use single-letter names for generic parameters.","breadcrumbs":"Module-level items » Generics","id":"26","title":"Generics"},"27":{"body":"These rules apply for where clauses on any item. A where clause may immediately follow a closing bracket of any kind. Otherwise, it must start a new line, with no indent. Each component of a where clause must be on its own line and be block indented. There should be a trailing comma, unless the clause is terminated with a semicolon. If the where clause is followed by a block (or assignment), the block should be started on a new line. Examples: fn function<T, U>(args)\nwhere T: Bound, U: AnotherBound,\n{ body\n} fn foo<T>( args\n) -> ReturnType\nwhere T: Bound,\n{ body\n} fn foo<T, U>( args,\n) where T: Bound, U: AnotherBound,\n{ body\n} fn foo<T, U>( args\n) -> ReturnType\nwhere T: Bound, U: AnotherBound; // Note, no trailing comma. // Note that where clauses on `type` aliases are not enforced and should not\n// be used.\ntype Foo<T>\nwhere T: Bound\n= Bar<T>; If a where clause is very short, we recommend using an inline bound on the type parameter. If a component of a where clause is long, it may be broken before + and further block indented. Each bound should go on its own line. E.g., impl<T: ?Sized, Idx> IndexRanges<Idx> for T\nwhere T: Index<Range<Idx>, Output = Self::Output> + Index<RangeTo<Idx>, Output = Self::Output> + Index<RangeFrom<Idx>, Output = Self::Output> + Index<RangeInclusive<Idx>, Output = Self::Output> + Index<RangeToInclusive<Idx>, Output = Self::Output> + Index<RangeFull> Option - where_single_line where_single_line is false by default. If true, then a where clause with exactly one component may be formatted on a single line if the rest of the item's signature is also kept on one line. In this case, there is no need for a trailing comma and if followed by a block, no need for a newline before the block. E.g., // May be single-lined.\nfn foo<T>(args) -> ReturnType\nwhere T: Bound { body\n} // Must be multi-lined.\nfn foo<T>( args\n) -> ReturnType\nwhere T: Bound,\n{ body\n}","breadcrumbs":"Module-level items » where clauses","id":"27","title":"where clauses"},"28":{"body":"Type aliases should generally be kept on one line. If necessary to break the line, do so after the =; the right-hand-side should be block indented: pub type Foo = Bar<T>; // If multi-line is required\ntype VeryLongType<T, U: SomeBound> = AnEvenLongerType<T, U, Foo<T>>; Where possible avoid where clauses and keep type constraints inline. Where that is not possible split the line before and after the where clause (and split the where clause as normal), e.g., type VeryLongType<T, U>\nwhere T: U::AnAssociatedType, U: SomeBound,\n= AnEvenLongerType<T, U, Foo<T>>;","breadcrumbs":"Module-level items » Type aliases","id":"28","title":"Type aliases"},"29":{"body":"Associated types should follow the guidelines above for type aliases. Where an associated type has a bound, there should be a space after the colon but not before: pub type Foo: Bar;","breadcrumbs":"Module-level items » Associated types","id":"29","title":"Associated types"},"3":{"body":"Use spaces, not tabs. Each level of indentation must be four spaces (that is, all indentation outside of string literals and comments must be a multiple of four). The maximum width for a line is 100 characters. A tool should be configurable for all three of these variables.","breadcrumbs":"Introduction » Indentation and line width","id":"3","title":"Indentation and line width"},"30":{"body":"When writing extern items (such as extern \"C\" fn), always be explicit about the ABI. For example, write extern \"C\" fn foo ..., not extern fn foo ..., or extern \"C\" { ... }.","breadcrumbs":"Module-level items » extern items","id":"30","title":"extern items"},"31":{"body":"If an import can be formatted on one line, do so. There should be no spaces around braces. use a::b::c;\nuse a::b::d::*;\nuse a::b::{foo, bar, baz}; Large list imports Prefer to use multiple imports rather than a multi-line import. However, tools should not split imports by default (they may offer this as an option). If an import does require multiple lines (either because a list of single names does not fit within the max width, or because of the rules for nested imports below), then break after the opening brace and before the closing brace, use a trailing comma, and block indent the names. // Prefer\nfoo::{long, list, of, imports};\nfoo::{more, imports}; // If necessary\nfoo::{ long, list, of, imports, more, imports, // Note trailing comma\n}; Ordering of imports A group of imports is a set of imports on the same or sequential lines. One or more blank lines or other items (e.g., a function) separate groups of imports. Within a group of imports, imports must be sorted ascii-betically. Groups of imports must not be merged or re-ordered. E.g., input: use d;\nuse c; use b;\nuse a; output: use c;\nuse d; use a;\nuse b; Because of macro_use, attributes must also start a new group and prevent re-ordering. Note that tools which only have access to syntax (such as Rustfmt) cannot tell which imports are from an external crate or the std lib, etc. Ordering list import Names in a list import must be sorted ascii-betically, but with self and super first, and groups and glob imports last. This applies recursively. For example, a::* comes before b::a but a::b comes before a::*. E.g., use foo::bar::{a, b::c, b::d, b::d::{x, y, z}, b::{self, r, s}};. Normalisation Tools must make the following normalisations: use a::self; -> use a; use a::{}; -> (nothing) use a::{b}; -> use a::b; And must apply these recursively. Tools must not otherwise merge or un-merge import lists or adjust glob imports (without an explicit option). Nested imports If there are any nested imports in a list import, then use the multi-line form, even if the import fits on one line. Each nested import must be on its own line, but non-nested imports must be grouped on as few lines as possible. For example, use a::b::{ x, y, z, u::{...}, w::{...},\n}; Merging/un-merging imports An example: // Un-merged\nuse a::b;\nuse a::c::d; // Merged\nuse a::{b, c::d}; Tools must not merge or un-merge imports by default. They may offer merging or un-merging as an option.","breadcrumbs":"Module-level items » Imports (use statements)","id":"31","title":"Imports (use statements)"},"32":{"body":"There should be spaces after the : and on both sides of the = (if they are present). No space before the semi-colon. // A comment.\nlet pattern: Type = expr; let pattern;\nlet pattern: Type;\nlet pattern = expr; If possible the declaration should be formatted on a single line. If this is not possible, then try splitting after the =, if the declaration can fit on two lines. The expression should be block indented. let pattern: Type = expr; If the first line does not fit on a single line, then split after the colon, using block indentation. If the type covers multiple lines, even after line- breaking after the :, then the first line may be placed on the same line as the :, subject to the combining rules (WIP). let pattern: Type = expr; e.g, let Foo { f: abcd, g: qwer,\n}: Foo<Bar> = Foo { f, g }; let (abcd, defg): Baz =\n{ ... } If the expression covers multiple lines, if the first line of the expression fits in the remaining space, it stays on the same line as the =, the rest of the expression is not indented. If the first line does not fit, then it should start on the next lines, and should be block indented. If the expression is a block and the type or pattern cover multiple lines, then the opening brace should be on a new line and not indented (this provides separation for the interior of the block from the type), otherwise the opening brace follows the =. Examples: let foo = Foo { f: abcd, g: qwer,\n}; let foo = ALongName { f: abcd, g: qwer, }; let foo: Type = { an_expression(); ...\n}; let foo: ALongType =\n{ an_expression(); ...\n}; let Foo { f: abcd, g: qwer,\n}: Foo<Bar> = Foo { f: blimblimblim, g: blamblamblam,\n}; let Foo { f: abcd, g: qwer,\n}: Foo<Bar> = foo( blimblimblim, blamblamblam,\n); else blocks (let-else statements) If a let statement contains an else component, also known as a let-else statement, then the else component should be formatted according to the same rules as the else block in control flow expressions (i.e. if-else, and if-let-else expressions) . Apply the same formatting rules to the components preceding the else block (i.e. the let pattern: Type = initializer_expr ... portion) as described above Similarly to if-else expressions, if the initializer expression is multi-lined, then the else keyword and opening brace of the block (i.e. else {) should be put on the same line as the end of the initializer expression with a preceding space if all the following are true: The initializer expression ends with one or more closing parentheses, square brackets, and/or braces There is nothing else on that line That line is not indented beyond the indent of the first line containing the let keyword For example: let Some(x) = y.foo( \"abc\", fairly_long_identifier, \"def\", \"123456\", \"string\", \"cheese\",\n) else { bar()\n} Otherwise, the else keyword and opening brace should be placed on the next line after the end of the initializer expression, and should not be indented (the else keyword should be aligned with the let keyword). For example: let Some(x) = abcdef() .foo( \"abc\", some_really_really_really_long_ident, \"ident\", \"123456\", ) .bar() .baz() .qux(\"fffffffffffffffff\")\nelse { foo_bar()\n} Single line let-else statements The entire let-else statement may be formatted on a single line if all the following are true: the entire statement is short the else block contains a single-line expression and no statements the else block contains no comments the let statement components preceding the else block can be formatted on a single line let Some(1) = opt else { return }; let Some(1) = opt else { return;\n}; let Some(1) = opt else { // nope return\n}; Formatters may allow users to configure the value of the threshold used to determine whether a let-else statement is short .","breadcrumbs":"Statements » Let statements","id":"32","title":"Let statements"},"33":{"body":"A macro use in statement position should use parentheses or square brackets as delimiters and should be terminated with a semi-colon. There should be no spaces between the name, !, the delimiters, or the ;. // A comment.\na_macro!(...);","breadcrumbs":"Statements » Macros in statement position","id":"33","title":"Macros in statement position"},"34":{"body":"There should be no space between the expression and the semi-colon. <expr>; All expressions in statement position should be terminated with a semi-colon, unless they end with a block or are used as the value for a block. E.g., { an_expression(); expr_as_value()\n} return foo(); loop { break;\n} Use a semi-colon where an expression has void type, even if it could be propagated. E.g., fn foo() { ... } fn bar() { foo();\n}","breadcrumbs":"Statements » Expressions in statement position","id":"34","title":"Expressions in statement position"},"35":{"body":"","breadcrumbs":"Expressions » Expressions","id":"35","title":"Expressions"},"36":{"body":"A block expression should have a newline after the initial { and before the terminal }. Any qualifier before the block (e.g., unsafe) should always be on the same line as the opening brace, and separated with a single space. The contents of the block should be block indented: fn block_as_stmt() { a_call(); { a_call_inside_a_block(); // a comment in a block the_value }\n} fn block_as_expr() { let foo = { a_call_inside_a_block(); // a comment in a block the_value };\n} fn unsafe_block_as_stmt() { a_call(); unsafe { a_call_inside_a_block(); // a comment in a block the_value }\n} If a block has an attribute, it should be on its own line: fn block_as_stmt() { #[an_attribute] { #![an_inner_attribute] // a comment in a block the_value }\n} Avoid writing comments on the same line as the braces. An empty block should be written as {}. A block may be written on a single line if: it is either used in expression position (not statement position) or is an unsafe block in statement position contains a single-line expression and no statements contains no comments A single line block should have spaces after the opening brace and before the closing brace. Examples: fn main() { // Single line let _ = { a_call() }; let _ = unsafe { a_call() }; // Not allowed on one line // Statement position. { a_call() } // Contains a statement let _ = { a_call(); }; unsafe { a_call(); } // Contains a comment let _ = { // A comment }; let _ = { // A comment a_call() }; // Multiple lines let _ = { a_call(); another_call() }; let _ = { a_call( an_argument, another_arg, ) };\n}","breadcrumbs":"Expressions » Blocks","id":"36","title":"Blocks"},"37":{"body":"Don't put any extra spaces before the first | (unless the closure is prefixed by move); put a space between the second | and the expression of the closure. Between the |s, you should use function definition syntax, however, elide types where possible. Use closures without the enclosing {}, if possible. Add the {} when you have a return type, when there are statements, there are comments in the body, or the body expression spans multiple lines and is a control-flow expression. If using braces, follow the rules above for blocks. Examples: |arg1, arg2| expr move |arg1: i32, arg2: i32| -> i32 { expr1; expr2\n} || Foo { field1, field2: 0,\n} || { if true { blah } else { boo }\n} |x| unsafe { expr\n}","breadcrumbs":"Expressions » Closures","id":"37","title":"Closures"},"38":{"body":"If a struct literal is small it may be formatted on a single line. If not, each field should be on it's own, block-indented line. There should be a trailing comma in the multi-line form only. There should be a space after the colon only. There should be a space before the opening brace. In the single-line form there should be spaces after the opening brace and before the closing brace. Foo { field1, field2: 0 }\nlet f = Foo { field1, field2: an_expr,\n}; Functional record update syntax is treated like a field, but it must never have a trailing comma. There should be no space after ... let f = Foo { field1, ..an_expr };","breadcrumbs":"Expressions » Struct literals","id":"38","title":"Struct literals"},"39":{"body":"Use a single-line form where possible. There should not be spaces around the parentheses. Where a single-line form is not possible, each element of the tuple should be on its own block-indented line and there should be a trailing comma. (a, b, c) let x = ( a_long_expr, another_very_long_expr,\n);","breadcrumbs":"Expressions » Tuple literals","id":"39","title":"Tuple literals"},"4":{"body":"Separate items and statements by either zero or one blank lines (i.e., one or two newlines). E.g, fn foo() { let x = ...; let y = ...; let z = ...;\n} fn bar() {}\nfn baz() {} Formatting tools should make the bounds on blank lines configurable: there should be separate minimum and maximum numbers of newlines between both statements and (top-level) items (i.e., four options). As described above, the defaults for both statements and items should be minimum: 1, maximum: 2.","breadcrumbs":"Introduction » Blank lines","id":"4","title":"Blank lines"},"40":{"body":"There should be no space between the identifier and the opening parenthesis. Otherwise, follow the rules for tuple literals, e.g., Foo(a, b).","breadcrumbs":"Expressions » Tuple struct literals","id":"40","title":"Tuple struct literals"},"41":{"body":"Follow the formatting rules for the various struct literals. Prefer using the name of the enum as a qualifying name, unless the enum is in the prelude. E.g., Foo::Bar(a, b)\nFoo::Baz { field1, field2: 1001,\n}\nOk(an_expr)","breadcrumbs":"Expressions » Enum literals","id":"41","title":"Enum literals"},"42":{"body":"For simple array literals, avoid line breaking, no spaces around square brackets, contents of the array should be separated by commas and spaces. If using the repeating initialiser, there should be a space after the semicolon only. Apply the same rules if using the vec! or similar macros (always use square brackets here). Examples: fn main() { [1, 2, 3]; vec![a, b, c, d]; let a = [42; 10];\n} If a line must be broken, prefer breaking only after the ;, if possible. Otherwise, follow the rules below for function calls. In any case, the contents of the initialiser should be block indented and there should be line breaks after the opening bracket and before the closing bracket: fn main() { [ a_long_expression(); 1234567890 ] let x = [ an_expression, another_expression, a_third_expression, ];\n}","breadcrumbs":"Expressions » Array literals","id":"42","title":"Array literals"},"43":{"body":"No spaces around the square brackets, avoid breaking lines if possible, never break a line between the target expression and the opening bracket. If the indexing expression covers multiple lines, then it should be block indented and there should be newlines after the opening brackets and before the closing bracket. However, this should be avoided where possible. Examples: fn main() { foo[42]; &foo[..10]; bar[0..100]; foo[4 + 5 / bar]; a_long_target[ a_long_indexing_expression ];\n}","breadcrumbs":"Expressions » Array accesses, indexing, and slicing.","id":"43","title":"Array accesses, indexing, and slicing."},"44":{"body":"Do not include a space between a unary op and its operand (i.e., !x, not ! x). However, there must be a space after &mut. Avoid line-breaking between a unary operator and its operand.","breadcrumbs":"Expressions » Unary operations","id":"44","title":"Unary operations"},"45":{"body":"Do include spaces around binary ops (i.e., x + 1, not x+1) (including = and other assignment operators such as += or *=). For comparison operators, because for T op U, &T op &U is also implemented: if you have t: &T, and u: U, prefer *t op u to t op &u. In general, within expressions, prefer dereferencing to taking references. Use parentheses liberally, do not necessarily elide them due to precedence. Tools should not automatically insert or remove parentheses. Do not use spaces to indicate precedence. If line-breaking, put the operator on a new line and block indent. Put each sub-expression on its own line. E.g., foo_bar + bar + baz + qux + whatever Prefer line-breaking at an assignment operator (either = or +=, etc.) rather than at other binary operators.","breadcrumbs":"Expressions » Binary operations","id":"45","title":"Binary operations"},"46":{"body":"Do not include extraneous parentheses for if and while expressions. if true {\n} is better than if (true) {\n} Do include extraneous parentheses if it makes an arithmetic or logic expression easier to understand ((x * 15) + (y * 20) is fine)","breadcrumbs":"Expressions » Control flow","id":"46","title":"Control flow"},"47":{"body":"Do not put a space between the function name, and the opening parenthesis. Do not put a space between an argument, and the comma which follows. Do put a space between an argument, and the comma which precedes it. Prefer not to break a line in the callee expression. Single-line calls Do not put a space between the function name and open paren, between the open paren and the first argument, or between the last argument and the close paren. Do not put a comma after the last argument. foo(x, y, z) Multi-line calls If the function call is not small , it would otherwise over-run the max width, or any argument or the callee is multi-line, then the call should be formatted across multiple lines. In this case, each argument should be on it's own block- indented line, there should be a newline after the opening parenthesis and before the closing parenthesis, and there should be a trailing comma. E.g., a_function_call( arg1, a_nested_call(a, b),\n)","breadcrumbs":"Expressions » Function calls","id":"47","title":"Function calls"},"48":{"body":"Follow the function rules for calling. Do not put any spaces around the .. x.foo().bar().baz(x, y, z);","breadcrumbs":"Expressions » Method calls","id":"48","title":"Method calls"},"49":{"body":"Macros which can be parsed like other constructs should be formatted like those constructs. For example, a macro use foo!(a, b, c) can be parsed like a function call (ignoring the !), therefore it should be formatted following the rules for function calls. Special case macros Macros which take a format string and where all other arguments are small may be formatted with arguments before and after the format string on a single line and the format string on its own line, rather than putting each argument on its own line. For example, println!( \"Hello {} and {}\", name1, name2,\n); assert_eq!( x, y, \"x and y were not equal, see {}\", reason,\n);","breadcrumbs":"Expressions » Macro uses","id":"49","title":"Macro uses"},"5":{"body":"","breadcrumbs":"Introduction » Module-level items","id":"5","title":"Module-level items"},"50":{"body":"Put spaces before and after as: let cstr = \"Hi\\0\" as *const str as *const [u8] as *const std::os::raw::c_char;","breadcrumbs":"Expressions » Casts (as)","id":"50","title":"Casts (as)"},"51":{"body":"A chain is a sequence of field accesses and/or method calls. A chain may also include the try operator ('?'). E.g., a.b.c().d or foo?.bar().baz?. Prefer formatting on one line if possible, and the chain is small . If formatting on multiple lines, each field access or method call in the chain should be on its own line with the line-break before the . and after any ?. Each line should be block-indented. E.g., let foo = bar .baz? .qux(); If the length of the last line of the first element plus its indentation is less than or equal to the indentation of the second line (and there is space), then combine the first and second lines, e.g., x.baz? .qux() let foo = x .baz? .qux(); foo( expr1, expr2,\n).baz? .qux(); Multi-line elements If any element in a chain is formatted across multiple lines, then that element and any later elements must be on their own line. Earlier elements may be kept on a single line. E.g., a.b.c()?.d .foo( an_expr, another_expr, ) .bar .baz Note there is block indent due to the chain and the function call in the above example. Prefer formatting the whole chain in multi-line style and each element on one line, rather than putting some elements on multiple lines and some on a single line, e.g., // Better\nself.pre_comment .as_ref() .map_or(false, |comment| comment.starts_with(\"//\")) // Worse\nself.pre_comment.as_ref().map_or( false, |comment| comment.starts_with(\"//\"),\n)","breadcrumbs":"Expressions » Chains of fields and method calls","id":"51","title":"Chains of fields and method calls"},"52":{"body":"This section covers if, if let, loop, while, while let, and for expressions. The keyword, any initial clauses, and the opening brace of the block should be on a single line. The usual rules for block formatting should be applied to the block. If there is an else component, then the closing brace, else, any following clause, and the opening brace should all be on the same line. There should be a single space before and after the else keyword. For example: if ... { ...\n} else { ...\n} if let ... { ...\n} else if ... { ...\n} else { ...\n} If the control line needs to be broken, then prefer to break before the = in * let expressions and before in in a for expression; the following line should be block indented. If the control line is broken for any reason, then the opening brace should be on its own line and not indented. Examples: while let Some(foo) = a_long_expression\n{ ...\n} for foo in a_long_expression\n{ ...\n} if a_long_expression && another_long_expression || a_third_long_expression\n{ ...\n} Where the initial clause is multi-lined and ends with one or more closing parentheses, square brackets, or braces, and there is nothing else on that line, and that line is not indented beyond the indent on the first line of the control flow expression, then the opening brace of the block should be put on the same line with a preceding space. For example: if !self.config.file_lines().intersects( &self.codemap.lookup_line_range( stmt.span, ),\n) { // Opening brace on same line as initial clause. ...\n} Single line if else Formatters may place an if else or if let else on a single line if it occurs in expression context (i.e., is not a standalone statement), it contains a single else clause, and is small . For example: let y = if x { 0 } else { 1 }; // Examples that must be multi-line.\nlet y = if something_very_long { not_small\n} else { also_not_small\n}; if x { 0\n} else { 1\n}","breadcrumbs":"Expressions » Control flow expressions","id":"52","title":"Control flow expressions"},"53":{"body":"Prefer not to line-break inside the discriminant expression. There must always be a line break after the opening brace and before the closing brace. The match arms must be block indented once: match foo { // arms\n} let x = match foo.bar.baz() { // arms\n}; Use a trailing comma for a match arm if and only if not using a block. Never start a match arm pattern with |, e.g., match foo { // Don't do this. | foo => bar, // Or this. | a_very_long_pattern | another_pattern | yet_another_pattern | a_forth_pattern => { ... }\n} Prefer match foo { foo => bar, a_very_long_pattern | another_pattern | yet_another_pattern | a_forth_pattern => { ... }\n} Avoid splitting the left-hand side (before the =>) of a match arm where possible. If the right-hand side of the match arm is kept on the same line, never use a block (unless the block is empty). If the right-hand side consists of multiple statements or has line comments or the start of the line cannot be fit on the same line as the left-hand side, use a block. The body of a block arm should be block indented once. Examples: match foo { foo => bar, a_very_long_patten | another_pattern if an_expression() => { no_room_for_this_expression() } foo => { // A comment. an_expression() } foo => { let a = statement(); an_expression() } bar => {} // Trailing comma on last item. foo => bar,\n} If the body is a single expression with no line comments and not a control flow expression, then it may be started on the same line as the right-hand side. If not, then it must be in a block. Example, match foo { // A combinable expression. foo => a_function_call(another_call( argument1, argument2, )), // A non-combinable expression bar => { a_function_call( another_call( argument1, argument2, ), another_argument, ) }\n} Line-breaking Where it is possible to use a block form on the right-hand side and avoid breaking the left-hand side, do that. E.g. // Assuming the following line does done fit in the max width a_very_long_pattern | another_pattern => ALongStructName { ... }, // Prefer this a_very_long_pattern | another_pattern => { ALongStructName { ... } } // To splitting the pattern. Never break after => without using the block form of the body. If the left-hand side must be split and there is an if clause, break before the if and block indent. In this case, always use a block body and start the body on a new line: a_very_long_pattern | another_pattern if expr => { ... } If required to break the pattern, put each clause of the pattern on its own line with no additional indent, breaking before the |. If there is an if clause, then you must use the above form: a_very_long_pattern | another_pattern | yet_another_pattern | a_forth_pattern => { ... } a_very_long_pattern | another_pattern | yet_another_pattern | a_forth_pattern if expr => { ... } If the pattern is multi-line, and the last line is less wide than the indent, do not put the if clause on a newline. E.g., Token::Dimension { value, ref unit, .. } if num_context.is_ok(context.parsing_mode, value) => { ... } If every clause in a pattern is small , but does not fit on one line, then the pattern may be formatted across multiple lines with as many clauses per line as possible. Again break before a |: foo | bar | baz | qux => { ... } We define a pattern clause to be small if it matches the following grammar: [small, ntp]: - single token - `&[single-line, ntp]` [small]: - `[small, ntp]` - unary tuple constructor `([small, ntp])` - `&[small]` E.g., &&Some(foo) matches, Foo(4, Bar) does not.","breadcrumbs":"Expressions » Match","id":"53","title":"Match"},"54":{"body":"Where a function call has a single argument, and that argument is formatted across multiple-lines, the outer call may be formatted as if it were a single- line call. The same combining behaviour may be applied to any similar expressions which have multi-line, block-indented lists of sub-expressions delimited by parentheses (e.g., macros or tuple struct literals). E.g., foo(bar( an_expr, another_expr,\n)) let x = foo(Bar { field: whatever,\n}); foo(|param| { action(); foo(param)\n}) Such behaviour should extend recursively, however, tools may choose to limit the depth of nesting. Only where the multi-line sub-expression is a closure with an explicit block, this combining behaviour may be used where there are other arguments, as long as all the arguments and the first line of the closure fit on the first line, the closure is the last argument, and there is only one closure argument: foo(first_arg, x, |param| { action(); foo(param)\n})","breadcrumbs":"Expressions » Combinable expressions","id":"54","title":"Combinable expressions"},"55":{"body":"Do not put spaces in ranges, e.g., 0..10, x..=y, ..x.len(), foo... When writing a range with both upper and lower bounds, if the line must be broken, break before the range operator and block indent the second line: a_long_expression ..another_long_expression For the sake of indicating precedence, we recommend that if either bound is a compound expression, then use parentheses around it, e.g., ..(x + 1), (x.f)..(x.f.len()), or 0..(x - 10).","breadcrumbs":"Expressions » Ranges","id":"55","title":"Ranges"},"56":{"body":"Hexadecimal literals may use upper- or lower-case letters, but they must not be mixed within the same literal. Projects should use the same case for all literals, but we do not make a recommendation for either lower- or upper-case. Tools should have an option to convert mixed case literals to upper-case, and may have an option to convert all literals to either lower- or upper-case.","breadcrumbs":"Expressions » Hexadecimal literals","id":"56","title":"Hexadecimal literals"},"57":{"body":"Patterns should be formatted like their corresponding expressions. See the section on match for additional formatting for patterns in match arms.","breadcrumbs":"Expressions » Patterns","id":"57","title":"Patterns"},"58":{"body":"","breadcrumbs":"Types » Types and Bounds","id":"58","title":"Types and Bounds"},"59":{"body":"[T] no spaces [T; expr], e.g., [u32; 42], [Vec<Foo>; 10 * 2 + foo()] (space after colon, no spaces around square brackets) *const T, *mut T (no space after *, space before type) &'a T, &T, &'a mut T, &mut T (no space after &, single spaces separating other words) unsafe extern \"C\" fn<'a, 'b, 'c>(T, U, V) -> W or fn() (single spaces around keyowrds and sigils, and after commas, no trailing commas, no spaces around brackets) ! should be treated like any other type name, Name (A, B, C, D) (spaces after commas, no spaces around parens, no trailing comma unless it is a one-tuple) <Baz<T> as SomeTrait>::Foo::Bar or Foo::Bar or ::Foo::Bar (no spaces around :: or angle brackets, single spaces around as) Foo::Bar<T, U, V> (spaces after commas, no trailing comma, no spaces around angle brackets) T + T + T (single spaces between types, and +). impl T + T + T (single spaces between keyword, types, and +). Parentheses used in types should not be surrounded by whitespace, e.g., (Foo)","breadcrumbs":"Types » Single line formatting","id":"59","title":"Single line formatting"},"6":{"body":"","breadcrumbs":"Introduction » Statements","id":"6","title":"Statements"},"60":{"body":"Avoid breaking lines in types where possible. Prefer breaking at outermost scope, e.g., prefer Foo< Bar, Baz<Type1, Type2>,\n> to Foo<Bar, Baz< Type1, Type2,\n>> [T; expr] may be broken after the ; if necessary. Function types may be broken following the rules for function declarations. Generic types may be broken following the rules for generics. Types with + may be broken after any + using block indent and breaking before the +. When breaking such a type, all +s should be line broken, e.g., impl Clone + Copy + Debug Box< Clone + Copy + Debug\n>","breadcrumbs":"Types » Line breaks","id":"60","title":"Line breaks"},"61":{"body":"","breadcrumbs":"Non-formatting conventions » Other style advice","id":"61","title":"Other style advice"},"62":{"body":"Prefer to use Rust's expression oriented nature where possible; // use\nlet x = if y { 1 } else { 0 };\n// not\nlet x;\nif y { x = 1;\n} else { x = 0;\n}","breadcrumbs":"Non-formatting conventions » Expressions","id":"62","title":"Expressions"},"63":{"body":"Types shall be UpperCamelCase, Enum variants shall be UpperCamelCase, Struct fields shall be snake_case, Function and method names shall be snake_case, Local variables shall be snake_case, Macro names shall be snake_case, Constants (consts and immutable statics) shall be SCREAMING_SNAKE_CASE. When a name is forbidden because it is a reserved word (e.g., crate), use a trailing underscore to make the name legal (e.g., crate_), or use raw identifiers if possible.","breadcrumbs":"Non-formatting conventions » Names","id":"63","title":"Names"},"64":{"body":"Avoid #[path] annotations where possible.","breadcrumbs":"Non-formatting conventions » Modules","id":"64","title":"Modules"},"65":{"body":"","breadcrumbs":"Cargo.toml conventions » Cargo.toml conventions","id":"65","title":"Cargo.toml conventions"},"66":{"body":"Use the same line width and indentation as Rust code. Put a blank line between the last key-value pair in a section and the header of the next section. Do not place a blank line between section headers and the key-value pairs in that section, or between key-value pairs in a section. Sort key names alphabetically within each section, with the exception of the [package] section. Put the [package] section at the top of the file; put the name and version keys in that order at the top of that section, followed by the remaining keys other than description in alphabetical order, followed by the description at the end of that section. Don't use quotes around any standard key names; use bare keys. Only use quoted keys for non-standard keys whose names require them, and avoid introducing such key names when possible. See the TOML specification for details. Put a single space both before and after the = between a key and value. Do not indent any key names; start all key names at the start of a line. Use multi-line strings (rather than newline escape sequences) for any string values that include multiple lines, such as the crate description. For array values, such as a list of authors, put the entire list on the same line as the key, if it fits. Otherwise, use block indentation: put a newline after the opening square bracket, indent each item by one indentation level, put a comma after each item (including the last), and put the closing square bracket at the start of a line by itself after the last item. authors = [ \"A Uthor <a.uthor@example.org>\", \"Another Author <author@example.net>\",\n] For table values, such as a crate dependency with a path, write the entire table using curly braces and commas on the same line as the key if it fits. If the entire table does not fit on the same line as the key, separate it out into a separate section with key-value pairs: [dependencies]\ncrate1 = { path = \"crate1\", version = \"1.2.3\" } [dependencies.extremely_long_crate_name_goes_here]\npath = \"extremely_long_path_name_goes_right_here\"\nversion = \"4.5.6\"","breadcrumbs":"Cargo.toml conventions » Formatting conventions","id":"66","title":"Formatting conventions"},"67":{"body":"The authors list should consist of strings that each contain an author name followed by an email address in angle brackets: Full Name <email@address>. It should not contain bare email addresses, or names without email addresses. (The authors list may also include a mailing list address without an associated name.) The license field must contain a valid SPDX expression , using valid SPDX license names . (As an exception, by widespread convention, the license field may use / in place of OR; for example, MIT/Apache-2.0.) The homepage field, if present, must consist of a single URL, including the scheme (e.g. https://example.org/, not just example.org.) Within the description field, wrap text at 80 columns. Don't start the description field with the name of the crate (e.g. \"cratename is a ...\"); just describe the crate itself. If providing a multi-sentence description, the first sentence should go on a line by itself and summarize the crate, like the subject of an email or commit message; subsequent sentences can then describe the crate in more detail.","breadcrumbs":"Cargo.toml conventions » Metadata conventions","id":"67","title":"Metadata conventions"},"68":{"body":"When deciding on style guidelines, the style team tried to be guided by the following principles (in rough priority order): readability scan-ability avoiding misleading formatting accessibility - readable and editable by users using the the widest variety of hardware, including non-visual accessibility interfaces readability of code in contexts without syntax highlighting or IDE assistance, such as rustc error messages, diffs, grep, and other plain-text contexts aesthetics sense of 'beauty' consistent with other languages/tools specifics compatibility with version control practices - preserving diffs, merge-friendliness, etc. preventing right-ward drift minimising vertical space application ease of manual application ease of implementation (in Rustfmt, and in other tools/editors/code generators) internal consistency simplicity of formatting rules","breadcrumbs":"Principles used for deciding these guidelines » Guiding principles and rationale","id":"68","title":"Guiding principles and rationale"},"69":{"body":"Prefer block indent over visual indent. E.g., // Block indent\na_function_call( foo, bar,\n); // Visual indent\na_function_call(foo, bar); This makes for smaller diffs (e.g., if a_function_call is renamed in the above example) and less rightward drift. Lists should have a trailing comma when followed by a newline, see the block indent example above. This choice makes moving code (e.g., by copy and paste) easier and makes smaller diffs.","breadcrumbs":"Principles used for deciding these guidelines » Overarching guidelines","id":"69","title":"Overarching guidelines"},"7":{"body":"","breadcrumbs":"Introduction » Expressions","id":"7","title":"Expressions"},"8":{"body":"","breadcrumbs":"Introduction » Types","id":"8","title":"Types"},"9":{"body":"The following guidelines for comments are recommendations only, a mechanical formatter might skip formatting of comments. Prefer line comments (//) to block comments (/* ... */). When using line comments there should be a single space after the opening sigil. When using single-line block comments there should be a single space after the opening sigil and before the closing sigil. Multi-line block comments should have a newline after the opening sigil and before the closing sigil. Prefer to put a comment on its own line. Where a comment follows code, there should be a single space before it. Where a block comment is inline, there should be surrounding whitespace as if it were an identifier or keyword. There should be no trailing whitespace after a comment or at the end of any line in a multi-line comment. Examples: // A comment on an item.\nstruct Foo { ... } fn foo() {} // A comment after an item. pub fn foo(/* a comment before an argument */ x: T) {...} Comments should usually be complete sentences. Start with a capital letter, end with a period (.). An inline block comment may be treated as a note without punctuation. Source lines which are entirely a comment should be limited to 80 characters in length (including comment sigils, but excluding indentation) or the maximum width of the line (including comment sigils and indentation), whichever is smaller: // This comment goes up to the ................................. 80 char margin. { // This comment is .............................................. 80 chars wide.\n} { { { { { { // This comment is limited by the ......................... 100 char margin. } } } } }\n} Doc comments Prefer line comments (///) to block comments (/** ... */). Prefer outer doc comments (/// or /** ... */), only use inner doc comments (//! and /*! ... */) to write module-level or crate-level documentation. Doc comments should come before attributes.","breadcrumbs":"Introduction » Comments","id":"9","title":"Comments"}},"length":70,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{".":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"55":{"tf":1.0}}}},"1":{"0":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":4,"docs":{"37":{"tf":1.0},"38":{"tf":1.0},"52":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951}}},"1":{".":{"2":{".":{"3":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"1":{"df":1,"docs":{"41":{"tf":1.0}}},"df":2,"docs":{"3":{"tf":1.0},"9":{"tf":1.0}}},"df":3,"docs":{"42":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.0}}},"1":{"df":1,"docs":{"17":{"tf":1.0}}},"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"0":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"32":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"df":1,"docs":{"46":{"tf":1.0}}},"df":6,"docs":{"4":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"52":{"tf":1.4142135623730951},"55":{"tf":1.0},"62":{"tf":1.4142135623730951}}},"2":{".":{"0":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"0":{"df":1,"docs":{"46":{"tf":1.0}}},"2":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}},"df":3,"docs":{"4":{"tf":1.0},"42":{"tf":1.0},"59":{"tf":1.0}}},"3":{"3":{"df":1,"docs":{"17":{"tf":1.0}}},"df":1,"docs":{"42":{"tf":1.0}}},"4":{".":{"5":{".":{"6":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"df":3,"docs":{"10":{"tf":1.0},"42":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}},"5":{"df":1,"docs":{"43":{"tf":1.0}}},"8":{"0":{"df":2,"docs":{"67":{"tf":1.0},"9":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"_":{"df":1,"docs":{"36":{"tf":2.6457513110645907}}},"a":{".":{"b":{".":{"c":{"(":{")":{".":{"d":{"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}},"?":{".":{"d":{"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"@":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},":":{":":{"b":{":":{":":{"c":{"df":1,"docs":{"31":{"tf":1.0}}},"d":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{},"{":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"31":{"tf":2.0}}},"c":{":":{":":{"d":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"{":{"b":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":3.1622776601683795}},"l":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"_":{"a":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"36":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":2.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"47":{"tf":1.0},"53":{"tf":1.0},"69":{"tf":1.4142135623730951}},"l":{"(":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"42":{"tf":1.0},"52":{"tf":1.7320508075688772},"55":{"tf":1.0}}}}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"a":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"42":{"tf":1.0}}}}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"52":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.0}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":2.6457513110645907}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"b":{"c":{"d":{"df":1,"docs":{"32":{"tf":2.449489742783178}},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"32":{"tf":1.0}}}}},"df":1,"docs":{"32":{"tf":1.4142135623730951}}},"df":0,"docs":{},"i":{"df":2,"docs":{"16":{"tf":1.0},"30":{"tf":1.0}},"l":{"df":1,"docs":{"68":{"tf":1.0}}}},"o":{"df":0,"docs":{},"v":{"df":8,"docs":{"15":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"69":{"tf":1.4142135623730951}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"31":{"tf":1.0},"43":{"tf":1.0},"51":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"32":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}}}}},"d":{"d":{"df":1,"docs":{"37":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"53":{"tf":1.0},"57":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"67":{"tf":2.0}}}}}}},"df":1,"docs":{"1":{"tf":1.0}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"19":{"tf":1.0},"53":{"tf":1.0}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"27":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"32":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"32":{"tf":1.0},"36":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"53":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"32":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"h":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"y":{"df":6,"docs":{"11":{"tf":1.0},"20":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.0},"42":{"tf":1.0},"53":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"n":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"36":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":3,"docs":{"38":{"tf":1.4142135623730951},"51":{"tf":1.0},"54":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"11":{"tf":1.0},"32":{"tf":1.4142135623730951},"34":{"tf":1.0},"42":{"tf":1.0},"53":{"tf":1.7320508075688772}}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"32":{"tf":1.0},"51":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}}}}}}}}}},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"59":{"tf":1.4142135623730951},"67":{"tf":1.0}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"15":{"tf":1.0},"64":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"66":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"36":{"tf":1.0}},"u":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"36":{"tf":1.0},"53":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"51":{"tf":1.0},"54":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"11":{"tf":1.0},"42":{"tf":1.0}}}}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"52":{"tf":1.0},"55":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":2.8284271247461903}}}}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}},"df":6,"docs":{"27":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"42":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"g":{"1":{"df":3,"docs":{"16":{"tf":1.0},"37":{"tf":1.4142135623730951},"47":{"tf":1.0}}},"2":{"df":2,"docs":{"16":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951}}},"df":1,"docs":{"27":{"tf":2.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"1":{"df":1,"docs":{"53":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"53":{"tf":1.4142135623730951}}},"df":6,"docs":{"10":{"tf":1.0},"16":{"tf":1.4142135623730951},"47":{"tf":2.6457513110645907},"49":{"tf":1.7320508075688772},"54":{"tf":2.449489742783178},"9":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}},"m":{"df":2,"docs":{"53":{"tf":2.8284271247461903},"57":{"tf":1.0}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":13,"docs":{"18":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"31":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":2.6457513110645907},"66":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"42":{"tf":1.7320508075688772},"43":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":1,"docs":{"49":{"tf":1.0}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"27":{"tf":1.0},"45":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":3,"docs":{"26":{"tf":1.0},"29":{"tf":1.7320508075688772},"67":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"10":{"tf":3.0},"31":{"tf":1.0},"36":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"@":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"10":{"tf":1.0},"66":{"tf":1.7320508075688772},"67":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"45":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":12,"docs":{"16":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"53":{"tf":1.4142135623730951},"60":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0}}},"df":0,"docs":{}}}}},"b":{":":{":":{"a":{"df":1,"docs":{"31":{"tf":1.0}}},"c":{"df":1,"docs":{"31":{"tf":1.0}}},"d":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"x":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{},"{":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"31":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"(":{"1":{"1":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}}}},"<":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.0}}}},"[":{"0":{".":{".":{"1":{"0":{"0":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":14,"docs":{"10":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"29":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"34":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"51":{"tf":1.4142135623730951},"53":{"tf":2.8284271247461903},"60":{"tf":1.0},"69":{"tf":1.4142135623730951}},"e":{"df":2,"docs":{"66":{"tf":1.0},"67":{"tf":1.0}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"z":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":8,"docs":{"10":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"4":{"tf":1.0},"45":{"tf":1.0},"51":{"tf":2.0},"53":{"tf":1.0},"60":{"tf":1.0}}}},"df":9,"docs":{"19":{"tf":2.0},"31":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"59":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":28,"docs":{"10":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"21":{"tf":2.0},"22":{"tf":1.4142135623730951},"24":{"tf":1.0},"26":{"tf":1.7320508075688772},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.7320508075688772},"32":{"tf":1.0},"36":{"tf":1.7320508075688772},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.7320508075688772},"53":{"tf":2.23606797749979},"55":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"66":{"tf":1.0},"9":{"tf":2.23606797749979}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"54":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"31":{"tf":1.0},"42":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"46":{"tf":1.0},"51":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":12,"docs":{"19":{"tf":1.0},"21":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.4142135623730951},"4":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"47":{"tf":2.449489742783178},"59":{"tf":1.4142135623730951},"66":{"tf":2.0}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"32":{"tf":1.0},"52":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"45":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"h":{"df":1,"docs":{"37":{"tf":1.0}}},"m":{"b":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"k":{"df":3,"docs":{"31":{"tf":1.0},"4":{"tf":1.7320508075688772},"66":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"k":{"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":28,"docs":{"16":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":2.449489742783178},"28":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":3.4641016151377544},"34":{"tf":1.4142135623730951},"36":{"tf":3.7416573867739413},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":2.23606797749979},"53":{"tf":3.4641016151377544},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"60":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.7320508075688772},"9":{"tf":2.449489742783178}}}},"df":0,"docs":{}}},"o":{"d":{"df":0,"docs":{},"i":{"df":3,"docs":{"27":{"tf":2.23606797749979},"37":{"tf":1.4142135623730951},"53":{"tf":2.23606797749979}}}},"df":0,"docs":{},"o":{"df":1,"docs":{"37":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":5,"docs":{"1":{"tf":1.0},"32":{"tf":1.0},"4":{"tf":1.4142135623730951},"55":{"tf":1.0},"66":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":7,"docs":{"21":{"tf":2.449489742783178},"26":{"tf":1.0},"27":{"tf":3.0},"29":{"tf":1.0},"4":{"tf":1.0},"55":{"tf":1.4142135623730951},"58":{"tf":1.0}}},"df":0,"docs":{}}},"x":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}}}}}},"df":1,"docs":{"60":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":14,"docs":{"18":{"tf":1.0},"19":{"tf":1.7320508075688772},"21":{"tf":1.7320508075688772},"22":{"tf":1.7320508075688772},"24":{"tf":1.0},"26":{"tf":1.0},"31":{"tf":1.7320508075688772},"32":{"tf":2.23606797749979},"36":{"tf":2.0},"37":{"tf":1.0},"38":{"tf":1.7320508075688772},"52":{"tf":2.6457513110645907},"53":{"tf":1.4142135623730951},"66":{"tf":1.0}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":10,"docs":{"26":{"tf":1.4142135623730951},"27":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"42":{"tf":2.0},"43":{"tf":2.0},"52":{"tf":1.0},"59":{"tf":2.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":18,"docs":{"16":{"tf":1.0},"21":{"tf":2.449489742783178},"22":{"tf":2.0},"26":{"tf":1.7320508075688772},"28":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"42":{"tf":1.7320508075688772},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"47":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":3.0},"55":{"tf":1.0},"60":{"tf":2.23606797749979}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"27":{"tf":1.0},"42":{"tf":1.0},"52":{"tf":1.4142135623730951},"55":{"tf":1.0},"60":{"tf":2.23606797749979}}}}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{":":{":":{"d":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},">":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":7,"docs":{"17":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":2.23606797749979},"48":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"51":{"tf":2.0},"54":{"tf":1.7320508075688772}},"e":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"13":{"tf":1.0},"65":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":8,"docs":{"10":{"tf":1.0},"18":{"tf":1.0},"27":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":2.449489742783178}}},"t":{"df":1,"docs":{"50":{"tf":1.0}}}}},"df":6,"docs":{"30":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951},"39":{"tf":1.0},"42":{"tf":1.0},"49":{"tf":1.0},"59":{"tf":1.4142135623730951}},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":2.8284271247461903}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"15":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.0},"3":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"32":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":6,"docs":{"21":{"tf":1.0},"26":{"tf":2.23606797749979},"27":{"tf":3.1622776601683795},"28":{"tf":1.7320508075688772},"52":{"tf":2.23606797749979},"53":{"tf":2.6457513110645907}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":17,"docs":{"16":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"66":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"37":{"tf":2.0},"54":{"tf":2.0}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":8,"docs":{"1":{"tf":1.4142135623730951},"16":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":10,"docs":{"20":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.7320508075688772},"38":{"tf":1.0},"59":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"10":{"tf":1.0},"32":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"15":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"m":{"a":{"df":15,"docs":{"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.7320508075688772},"26":{"tf":1.7320508075688772},"27":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":2.0},"53":{"tf":1.4142135623730951},"59":{"tf":2.449489742783178},"66":{"tf":1.4142135623730951},"69":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"51":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":9,"docs":{"16":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"36":{"tf":3.0},"37":{"tf":1.0},"51":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772},"9":{"tf":5.477225575051661}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"45":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}},"x":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"11":{"tf":1.0},"27":{"tf":1.7320508075688772},"32":{"tf":2.0},"52":{"tf":1.0}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"3":{"tf":1.0},"32":{"tf":1.0},"4":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.0},"53":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}},"df":3,"docs":{"50":{"tf":1.7320508075688772},"59":{"tf":1.0},"63":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"32":{"tf":2.0},"36":{"tf":2.0},"52":{"tf":1.0},"67":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":1.0},"42":{"tf":1.4142135623730951}}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"52":{"tf":1.0},"68":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":6,"docs":{"32":{"tf":1.0},"37":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":2.0},"53":{"tf":1.0},"68":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"2":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}}}}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"60":{"tf":1.4142135623730951},"69":{"tf":1.0}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"32":{"tf":1.7320508075688772},"43":{"tf":1.0},"52":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}},"_":{"df":1,"docs":{"63":{"tf":1.0}}},"df":7,"docs":{"15":{"tf":1.0},"23":{"tf":1.4142135623730951},"31":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":2.0},"9":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"50":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"d":{"df":3,"docs":{"31":{"tf":1.4142135623730951},"42":{"tf":1.0},"59":{"tf":1.0}},"e":{"b":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{">":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":3,"docs":{"21":{"tf":1.0},"26":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}}}},"c":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"11":{"tf":1.0},"14":{"tf":1.0},"68":{"tf":1.0}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"r":{"df":6,"docs":{"15":{"tf":1.7320508075688772},"18":{"tf":1.0},"19":{"tf":1.0},"26":{"tf":1.0},"32":{"tf":1.4142135623730951},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.0},"27":{"tf":1.0},"31":{"tf":1.4142135623730951},"4":{"tf":1.0}}}}}},"df":1,"docs":{"32":{"tf":1.0}},"g":{"df":1,"docs":{"32":{"tf":1.0}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"11":{"tf":1.0},"16":{"tf":1.0},"25":{"tf":1.0},"37":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"33":{"tf":1.4142135623730951},"54":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"66":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"54":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"10":{"tf":1.7320508075688772}},"e":{"(":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":3,"docs":{"32":{"tf":1.0},"4":{"tf":1.0},"67":{"tf":1.4142135623730951}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"66":{"tf":1.7320508075688772},"67":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"66":{"tf":1.0},"67":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"32":{"tf":1.0}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"1":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":2,"docs":{"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.7320508075688772}}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"26":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"o":{"c":{"df":1,"docs":{"9":{"tf":2.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"1":{"tf":1.0},"37":{"tf":1.0},"53":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"53":{"tf":1.0}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"19":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":2,"docs":{"68":{"tf":1.0},"69":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"e":{"df":2,"docs":{"45":{"tf":1.0},"51":{"tf":1.0}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":24,"docs":{"10":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"31":{"tf":1.7320508075688772},"32":{"tf":1.0},"34":{"tf":1.4142135623730951},"36":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"51":{"tf":2.23606797749979},"53":{"tf":2.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":18,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.7320508075688772},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"3":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.7320508075688772},"53":{"tf":1.0},"66":{"tf":1.7320508075688772},"67":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}}}}},"s":{"df":1,"docs":{"68":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"46":{"tf":1.0},"69":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"39":{"tf":1.0},"51":{"tf":2.8284271247461903}}}}}}},"i":{"d":{"df":2,"docs":{"37":{"tf":1.0},"45":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"@":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"67":{"tf":2.0}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":4,"docs":{"19":{"tf":1.4142135623730951},"20":{"tf":1.0},"36":{"tf":1.0},"53":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"d":{"df":6,"docs":{"19":{"tf":1.0},"32":{"tf":1.7320508075688772},"34":{"tf":1.0},"52":{"tf":1.0},"66":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":3,"docs":{"32":{"tf":1.4142135623730951},"66":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":3,"docs":{"18":{"tf":2.0},"41":{"tf":1.7320508075688772},"63":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"10":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"18":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"c":{"df":3,"docs":{"31":{"tf":1.0},"45":{"tf":1.0},"68":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"1":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"11":{"tf":1.0},"27":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":17,"docs":{"11":{"tf":1.4142135623730951},"16":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.7320508075688772},"32":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":2.23606797749979},"53":{"tf":1.4142135623730951},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"9":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"66":{"tf":1.0},"67":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"31":{"tf":1.0},"54":{"tf":1.0}}}}},"df":0,"docs":{}}},"r":{"1":{"df":2,"docs":{"37":{"tf":1.0},"51":{"tf":1.0}}},"2":{"df":2,"docs":{"37":{"tf":1.0},"51":{"tf":1.0}}},"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":6,"docs":{"32":{"tf":2.0},"34":{"tf":1.0},"37":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":18,"docs":{"11":{"tf":1.0},"32":{"tf":3.605551275463989},"34":{"tf":2.0},"35":{"tf":1.0},"36":{"tf":1.7320508075688772},"37":{"tf":1.7320508075688772},"43":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"52":{"tf":2.449489742783178},"53":{"tf":2.23606797749979},"54":{"tf":2.0},"55":{"tf":1.0},"57":{"tf":1.0},"62":{"tf":1.4142135623730951},"67":{"tf":1.0},"7":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"n":{"df":6,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.4142135623730951},"30":{"tf":2.449489742783178},"31":{"tf":1.0},"59":{"tf":1.0}}}}},"r":{"a":{"df":1,"docs":{"37":{"tf":1.0}},"n":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}}},"f":{"1":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}},"3":{"2":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"32":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"s":{"df":2,"docs":{"27":{"tf":1.0},"51":{"tf":1.0}}}}},"df":2,"docs":{"32":{"tf":2.6457513110645907},"38":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"20":{"tf":1.0},"31":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"1":{"df":3,"docs":{"37":{"tf":1.0},"38":{"tf":1.7320508075688772},"41":{"tf":1.0}}},"2":{"df":3,"docs":{"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"41":{"tf":1.0}}},"df":8,"docs":{"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":2.0},"38":{"tf":1.4142135623730951},"51":{"tf":1.7320508075688772},"54":{"tf":1.0},"63":{"tf":1.0},"67":{"tf":2.23606797749979}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"15":{"tf":1.0},"66":{"tf":1.0}}}},"n":{"d":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"46":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":10,"docs":{"15":{"tf":1.0},"21":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":2.23606797749979},"37":{"tf":1.0},"47":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.4142135623730951},"67":{"tf":1.0}}}}},"t":{"df":8,"docs":{"16":{"tf":1.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":2.0},"53":{"tf":1.7320508075688772},"54":{"tf":1.0},"66":{"tf":1.7320508075688772}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":5,"docs":{"32":{"tf":1.0},"37":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.0}}}}},"n":{"<":{"'":{"a":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":11,"docs":{"16":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951},"27":{"tf":2.449489742783178},"30":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"36":{"tf":2.23606797749979},"4":{"tf":1.7320508075688772},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"59":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":21,"docs":{"19":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.7320508075688772},"29":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"o":{"!":{"(":{"a":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"(":{"4":{"df":1,"docs":{"53":{"tf":1.0}}},"a":{"df":1,"docs":{"40":{"tf":1.0}},"r":{"df":0,"docs":{},"g":{"1":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}}},"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"54":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"10":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}},"x":{"df":1,"docs":{"47":{"tf":1.0}}},"|":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},".":{"b":{"a":{"df":0,"docs":{},"r":{".":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"(":{"a":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"{":{"a":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"z":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"{":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"df":0,"docs":{}},"<":{"b":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"32":{"tf":1.7320508075688772},"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{">":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"26":{"tf":1.0},"27":{"tf":2.23606797749979},"28":{"tf":1.4142135623730951}}}},"?":{".":{"b":{"a":{"df":0,"docs":{},"r":{"(":{")":{".":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"[":{".":{".":{"1":{"0":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"2":{"df":1,"docs":{"43":{"tf":1.0}}},"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"_":{"b":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"32":{"tf":1.0},"45":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":30,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":2.8284271247461903},"20":{"tf":1.7320508075688772},"21":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":3.4641016151377544},"34":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.7320508075688772},"4":{"tf":1.0},"51":{"tf":2.0},"52":{"tf":1.0},"53":{"tf":3.605551275463989},"55":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"69":{"tf":1.0},"9":{"tf":1.7320508075688772}}},"r":{"b":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"63":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":27,"docs":{"1":{"tf":2.6457513110645907},"10":{"tf":1.4142135623730951},"11":{"tf":2.0},"12":{"tf":1.0},"18":{"tf":2.0},"2":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":2.23606797749979},"38":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":2.449489742783178},"51":{"tf":2.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"59":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.4142135623730951},"9":{"tf":1.0}},"t":{"df":4,"docs":{"11":{"tf":1.0},"32":{"tf":1.0},"52":{"tf":1.0},"9":{"tf":1.0}}}}},"df":4,"docs":{"31":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"3":{"tf":1.4142135623730951},"4":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"11":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"68":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"25":{"tf":1.0},"67":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":14,"docs":{"10":{"tf":1.0},"16":{"tf":2.0},"17":{"tf":1.4142135623730951},"31":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":2.0},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"51":{"tf":1.0},"54":{"tf":1.0},"60":{"tf":1.4142135623730951},"63":{"tf":1.0}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}}}}}}}},"g":{"df":1,"docs":{"32":{"tf":2.6457513110645907}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"26":{"tf":2.6457513110645907},"28":{"tf":1.0},"45":{"tf":1.0},"60":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"11":{"tf":1.0}},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"o":{"df":2,"docs":{"27":{"tf":1.0},"67":{"tf":1.0}},"e":{"df":1,"docs":{"9":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"68":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"31":{"tf":2.6457513110645907}}}}}},"u":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"11":{"tf":1.0},"68":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"14":{"tf":1.0},"19":{"tf":1.0},"29":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"9":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"28":{"tf":1.0},"53":{"tf":2.8284271247461903}}},"df":0,"docs":{}},"r":{"d":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"49":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"42":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.7320508075688772}}}}}}},"x":{"a":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"\\":{"0":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}}}}}}},"o":{"c":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{".":{"df":5,"docs":{"32":{"tf":1.7320508075688772},"4":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.0},"52":{"tf":1.0}}},"3":{"2":{"df":2,"docs":{"16":{"tf":2.449489742783178},"37":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"d":{"df":1,"docs":{"68":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":4,"docs":{"18":{"tf":1.0},"40":{"tf":1.0},"63":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"x":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":1.0},"49":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"22":{"tf":1.0},"27":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.0},"27":{"tf":1.0}}}},"df":3,"docs":{"22":{"tf":2.6457513110645907},"59":{"tf":1.0},"60":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"68":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"31":{"tf":5.744562646538029}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":9,"docs":{"21":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"51":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":28,"docs":{"10":{"tf":1.4142135623730951},"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.7320508075688772},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.7320508075688772},"28":{"tf":1.0},"3":{"tf":1.7320508075688772},"31":{"tf":1.0},"32":{"tf":2.8284271247461903},"36":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"51":{"tf":2.0},"52":{"tf":2.0},"53":{"tf":2.23606797749979},"54":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"66":{"tf":2.23606797749979},"69":{"tf":2.23606797749979},"9":{"tf":1.4142135623730951}}}},"x":{"<":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"<":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"21":{"tf":1.0},"27":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"<":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"43":{"tf":1.4142135623730951}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"21":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"<":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"i":{"c":{"df":3,"docs":{"18":{"tf":1.0},"45":{"tf":1.0},"55":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":2,"docs":{"11":{"tf":1.0},"21":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":3,"docs":{"32":{"tf":2.0},"36":{"tf":1.0},"52":{"tf":1.7320508075688772}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}}},"i":{"d":{"df":2,"docs":{"10":{"tf":1.0},"53":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}},"n":{"df":1,"docs":{"68":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"11":{"tf":1.0}}}}},"t":{"'":{"df":3,"docs":{"16":{"tf":1.4142135623730951},"38":{"tf":1.0},"47":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":14,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":2.0},"15":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"4":{"tf":1.7320508075688772},"5":{"tf":1.0},"53":{"tf":1.0},"66":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":3,"docs":{"16":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.4142135623730951}}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":2,"docs":{"19":{"tf":1.0},"28":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":4,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0}}}},"y":{"df":1,"docs":{"66":{"tf":4.242640687119285}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":8,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"32":{"tf":2.23606797749979},"52":{"tf":1.4142135623730951},"59":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"26":{"tf":1.0},"31":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":7,"docs":{"16":{"tf":1.0},"31":{"tf":1.0},"47":{"tf":1.4142135623730951},"51":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"66":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":2.0}}}},"g":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"51":{"tf":1.0},"9":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"1":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"69":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"26":{"tf":1.0},"56":{"tf":1.0},"9":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":6,"docs":{"10":{"tf":1.4142135623730951},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"66":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"i":{"b":{"df":1,"docs":{"31":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"45":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"67":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"54":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"e":{"df":35,"docs":{"10":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":2.449489742783178},"19":{"tf":2.23606797749979},"20":{"tf":1.7320508075688772},"21":{"tf":2.23606797749979},"22":{"tf":2.23606797749979},"26":{"tf":2.23606797749979},"27":{"tf":2.8284271247461903},"28":{"tf":2.0},"3":{"tf":1.4142135623730951},"31":{"tf":3.0},"32":{"tf":5.0},"36":{"tf":3.0},"37":{"tf":1.0},"38":{"tf":2.0},"39":{"tf":1.7320508075688772},"4":{"tf":1.7320508075688772},"42":{"tf":1.7320508075688772},"43":{"tf":1.7320508075688772},"44":{"tf":1.0},"45":{"tf":2.0},"47":{"tf":2.449489742783178},"49":{"tf":1.7320508075688772},"51":{"tf":4.0},"52":{"tf":3.872983346207417},"53":{"tf":4.242640687119285},"54":{"tf":2.449489742783178},"55":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.7320508075688772},"66":{"tf":3.1622776601683795},"67":{"tf":1.0},"9":{"tf":3.1622776601683795}}}},"s":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"31":{"tf":2.8284271247461903},"54":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772},"69":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"11":{"tf":1.0},"3":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"54":{"tf":1.0},"56":{"tf":2.449489742783178}}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":3,"docs":{"27":{"tf":1.0},"31":{"tf":1.0},"54":{"tf":1.0}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}}}}},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"34":{"tf":1.0},"52":{"tf":1.0}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"1":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.7320508075688772}}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"25":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"15":{"tf":1.0},"31":{"tf":1.0}}}}},"df":6,"docs":{"25":{"tf":1.0},"33":{"tf":1.4142135623730951},"42":{"tf":1.0},"49":{"tf":2.23606797749979},"54":{"tf":1.0},"63":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}}},"n":{"df":3,"docs":{"36":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":7,"docs":{"15":{"tf":1.0},"31":{"tf":1.0},"4":{"tf":1.0},"46":{"tf":1.0},"56":{"tf":1.0},"63":{"tf":1.0},"69":{"tf":1.7320508075688772}}}},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"11":{"tf":1.0},"53":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"51":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"1":{"tf":1.0},"53":{"tf":3.7416573867739413},"57":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"x":{"df":3,"docs":{"31":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":3,"docs":{"3":{"tf":1.0},"4":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.0}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"1":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"31":{"tf":3.1622776601683795},"68":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"67":{"tf":1.0},"68":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":3,"docs":{"48":{"tf":1.0},"51":{"tf":1.7320508075688772},"63":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"68":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}}}}},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"/":{"a":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"x":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}},"o":{"d":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"l":{"df":5,"docs":{"15":{"tf":2.0},"24":{"tf":1.0},"5":{"tf":1.0},"64":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":7,"docs":{"1":{"tf":1.0},"11":{"tf":1.4142135623730951},"20":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"52":{"tf":1.0},"67":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"1":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":3,"docs":{"15":{"tf":1.0},"37":{"tf":1.4142135623730951},"69":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":14,"docs":{"18":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"38":{"tf":1.0},"47":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":1.0},"9":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"l":{"df":14,"docs":{"10":{"tf":1.0},"18":{"tf":1.4142135623730951},"26":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.0},"51":{"tf":1.7320508075688772},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"66":{"tf":1.0}}}}}}},"t":{"df":2,"docs":{"44":{"tf":1.0},"59":{"tf":1.7320508075688772}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"49":{"tf":1.0}}},"2":{"df":1,"docs":{"49":{"tf":1.0}}},"df":15,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"26":{"tf":1.0},"31":{"tf":1.7320508075688772},"33":{"tf":1.0},"41":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"63":{"tf":2.23606797749979},"66":{"tf":2.6457513110645907},"67":{"tf":2.449489742783178}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"28":{"tf":1.0},"31":{"tf":1.0},"60":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"45":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":3,"docs":{"1":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"52":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"31":{"tf":2.23606797749979},"54":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"38":{"tf":1.0},"43":{"tf":1.0},"53":{"tf":1.7320508075688772}}}}},"w":{"df":6,"docs":{"1":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"45":{"tf":1.0},"53":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":10,"docs":{"26":{"tf":1.0},"27":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.4142135623730951},"43":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"66":{"tf":1.4142135623730951},"69":{"tf":1.0},"9":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.4142135623730951},"66":{"tf":1.0}}}}},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"n":{"df":6,"docs":{"12":{"tf":1.0},"22":{"tf":1.0},"31":{"tf":1.0},"53":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.0}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"28":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":6,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"27":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"51":{"tf":1.0},"9":{"tf":1.0}}},"h":{"df":3,"docs":{"31":{"tf":1.0},"32":{"tf":1.0},"52":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"p":{"df":1,"docs":{"53":{"tf":2.0}}}},"u":{"df":0,"docs":{},"m":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"52":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}}}},"k":{"(":{"a":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"41":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"c":{"df":2,"docs":{"19":{"tf":1.0},"53":{"tf":1.4142135623730951}}},"df":18,"docs":{"1":{"tf":1.0},"16":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"31":{"tf":1.7320508075688772},"32":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"59":{"tf":1.0},"66":{"tf":1.0}}},"p":{"df":2,"docs":{"44":{"tf":1.0},"45":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"n":{"df":18,"docs":{"16":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"24":{"tf":1.0},"26":{"tf":1.7320508075688772},"31":{"tf":1.0},"32":{"tf":2.0},"36":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"40":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"47":{"tf":2.0},"52":{"tf":2.23606797749979},"53":{"tf":1.0},"66":{"tf":1.0},"9":{"tf":1.7320508075688772}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":4,"docs":{"44":{"tf":1.4142135623730951},"45":{"tf":2.449489742783178},"51":{"tf":1.0},"55":{"tf":1.0}}}},"t":{"df":1,"docs":{"32":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":6,"docs":{"11":{"tf":1.0},"15":{"tf":1.0},"27":{"tf":1.0},"31":{"tf":1.7320508075688772},"4":{"tf":1.0},"56":{"tf":1.4142135623730951}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"10":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"31":{"tf":2.0},"66":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":9,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"27":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"40":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"66":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.0},"66":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"10":{"tf":1.0},"54":{"tf":1.0},"9":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"21":{"tf":2.0}}}}}}},"df":2,"docs":{"27":{"tf":2.23606797749979},"31":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}},"df":2,"docs":{"47":{"tf":1.0},"69":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":2.0}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"54":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"47":{"tf":1.7320508075688772},"59":{"tf":1.0}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":10,"docs":{"20":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.0}},"i":{"df":4,"docs":{"16":{"tf":1.4142135623730951},"26":{"tf":1.0},"40":{"tf":1.0},"47":{"tf":1.7320508075688772}}}}}}}}},"s":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}},"t":{"df":1,"docs":{"26":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"64":{"tf":1.0},"66":{"tf":1.7320508075688772}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"1":{"tf":1.0},"32":{"tf":2.8284271247461903},"53":{"tf":2.8284271247461903},"57":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"53":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":5,"docs":{"11":{"tf":1.0},"32":{"tf":1.4142135623730951},"52":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"68":{"tf":1.0}}}}},"df":0,"docs":{},"u":{"df":1,"docs":{"51":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"33":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"36":{"tf":2.0}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":18,"docs":{"10":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"51":{"tf":1.0},"53":{"tf":1.7320508075688772},"60":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":5,"docs":{"32":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"47":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":17,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"26":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951},"41":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.7320508075688772},"47":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.7320508075688772},"60":{"tf":1.4142135623730951},"62":{"tf":1.0},"69":{"tf":1.0},"9":{"tf":2.0}}}},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"37":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.0},"67":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":2,"docs":{"10":{"tf":1.0},"68":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"31":{"tf":1.0},"68":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"14":{"tf":1.0},"68":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"68":{"tf":1.0}}}}}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":1,"docs":{"1":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"56":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"20":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"32":{"tf":1.0},"67":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"b":{"df":6,"docs":{"16":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"df":20,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"26":{"tf":1.7320508075688772},"32":{"tf":1.0},"37":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"47":{"tf":2.23606797749979},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"55":{"tf":1.0},"66":{"tf":2.8284271247461903},"9":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"36":{"tf":1.0},"41":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}},"x":{"(":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"32":{"tf":1.0}}}}}}}}}}}}}}}}}}}},"df":0,"docs":{}},"df":3,"docs":{"45":{"tf":1.0},"51":{"tf":2.0},"53":{"tf":1.0}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":2.23606797749979}}}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"55":{"tf":2.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}}}}},"w":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":1,"docs":{"31":{"tf":1.0}},"e":{"a":{"d":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"49":{"tf":1.0},"52":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"15":{"tf":1.0},"27":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"d":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"31":{"tf":1.4142135623730951},"54":{"tf":1.0}}}}}},"df":1,"docs":{"31":{"tf":1.4142135623730951}},"f":{"df":1,"docs":{"53":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"45":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"32":{"tf":1.0},"66":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"45":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"(":{"c":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":8,"docs":{"1":{"tf":1.0},"18":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"53":{"tf":1.0},"66":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"63":{"tf":1.0}}}}},"t":{"df":2,"docs":{"27":{"tf":1.0},"32":{"tf":1.0}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"32":{"tf":1.7320508075688772},"34":{"tf":1.0},"37":{"tf":1.0}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"27":{"tf":2.0}}}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":4,"docs":{"19":{"tf":1.4142135623730951},"28":{"tf":1.0},"53":{"tf":2.0},"68":{"tf":1.0}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":13,"docs":{"1":{"tf":1.4142135623730951},"27":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":1.4142135623730951},"68":{"tf":1.0}}}},"n":{"df":1,"docs":{"47":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"62":{"tf":1.0}}},"c":{"df":1,"docs":{"68":{"tf":1.0}}},"df":4,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"16":{"tf":1.0},"66":{"tf":1.0}},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"31":{"tf":1.0},"68":{"tf":1.0}}}}}}}}},"s":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"55":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":10,"docs":{"19":{"tf":1.7320508075688772},"31":{"tf":1.0},"32":{"tf":2.23606797749979},"36":{"tf":1.4142135623730951},"42":{"tf":1.0},"52":{"tf":1.7320508075688772},"53":{"tf":1.7320508075688772},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"66":{"tf":2.0}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"1":{"tf":1.0}}}}},"c":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"60":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"31":{"tf":1.0},"37":{"tf":1.0},"60":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"18":{"tf":1.0},"37":{"tf":1.0},"51":{"tf":1.4142135623730951},"55":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"52":{"tf":1.0},"57":{"tf":1.0},"66":{"tf":3.3166247903554}}}}}}},"df":0,"docs":{},"e":{"df":5,"docs":{"11":{"tf":1.0},"49":{"tf":1.0},"57":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0}}},"l":{"df":0,"docs":{},"f":{".":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"52":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"(":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"51":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},":":{":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":2.23606797749979}}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"15":{"tf":1.0},"31":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"27":{"tf":1.0},"42":{"tf":1.0}}}}}}},"df":6,"docs":{"20":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.7320508075688772}}}},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"68":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"67":{"tf":1.7320508075688772},"9":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":9,"docs":{"15":{"tf":1.0},"20":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.4142135623730951},"42":{"tf":1.0},"59":{"tf":1.0},"66":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"51":{"tf":1.0},"66":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}}}}},"t":{"df":2,"docs":{"1":{"tf":1.0},"31":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":2.6457513110645907}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"32":{"tf":1.4142135623730951}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":4,"docs":{"26":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0},"53":{"tf":2.8284271247461903}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"59":{"tf":1.0},"9":{"tf":2.6457513110645907}}}},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"16":{"tf":1.4142135623730951},"22":{"tf":1.0},"27":{"tf":1.0}}}}}},"df":1,"docs":{"10":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"1":{"tf":1.0},"42":{"tf":1.0},"54":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.0},"42":{"tf":1.0}},"i":{"c":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":21,"docs":{"10":{"tf":1.7320508075688772},"17":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":2.449489742783178},"36":{"tf":2.23606797749979},"38":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"47":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":2.23606797749979},"53":{"tf":1.7320508075688772},"54":{"tf":1.4142135623730951},"59":{"tf":2.449489742783178},"66":{"tf":1.0},"67":{"tf":1.0},"9":{"tf":2.0}}}}},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"e":{"df":2,"docs":{"11":{"tf":1.0},"27":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"9":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":8,"docs":{"11":{"tf":2.0},"18":{"tf":1.0},"38":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":2.6457513110645907}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"69":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"63":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"1":{"df":1,"docs":{"32":{"tf":1.7320508075688772}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":2,"docs":{"52":{"tf":1.0},"53":{"tf":1.0}}}}},"x":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}},"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"52":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{">":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"15":{"tf":1.0},"31":{"tf":1.4142135623730951},"66":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":34,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"26":{"tf":2.0},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":2.0},"33":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":2.0},"39":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"47":{"tf":2.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"55":{"tf":1.0},"59":{"tf":4.123105625617661},"66":{"tf":1.0},"68":{"tf":1.0},"9":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}},"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"18":{"tf":1.0},"49":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":2,"docs":{"66":{"tf":1.0},"68":{"tf":1.0}},"i":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"28":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"df":7,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"66":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}},"r":{"d":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":7,"docs":{"27":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"53":{"tf":2.0},"66":{"tf":1.7320508075688772},"67":{"tf":1.0},"9":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":11,"docs":{"15":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":3.1622776601683795},"33":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"36":{"tf":2.23606797749979},"37":{"tf":1.0},"4":{"tf":1.7320508075688772},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"6":{"tf":1.0}}}}}}},"i":{"c":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}}},"y":{"df":1,"docs":{"32":{"tf":1.0}}}},"d":{":":{":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{":":{":":{"c":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"df":1,"docs":{"50":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":6,"docs":{"20":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"49":{"tf":1.7320508075688772},"66":{"tf":1.4142135623730951},"67":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":12,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"17":{"tf":1.7320508075688772},"18":{"tf":2.8284271247461903},"19":{"tf":3.7416573867739413},"20":{"tf":3.1622776601683795},"38":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"54":{"tf":1.0},"63":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":6,"docs":{"0":{"tf":1.0},"1":{"tf":1.7320508075688772},"16":{"tf":1.0},"51":{"tf":1.0},"61":{"tf":1.0},"68":{"tf":1.4142135623730951}}}}}},"u":{"b":{"df":3,"docs":{"11":{"tf":1.0},"45":{"tf":1.0},"54":{"tf":1.4142135623730951}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"h":{"df":10,"docs":{"1":{"tf":1.4142135623730951},"11":{"tf":1.0},"18":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"45":{"tf":1.0},"54":{"tf":1.0},"60":{"tf":1.0},"66":{"tf":2.0},"68":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"15":{"tf":1.0},"31":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"59":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":4,"docs":{"31":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"68":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"a":{"b":{"df":1,"docs":{"3":{"tf":1.0}},"l":{"df":1,"docs":{"66":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":3,"docs":{"1":{"tf":1.0},"45":{"tf":1.0},"49":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}},"df":7,"docs":{"26":{"tf":1.4142135623730951},"27":{"tf":3.0},"28":{"tf":1.0},"45":{"tf":2.449489742783178},"59":{"tf":3.7416573867739413},"60":{"tf":1.0},"9":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.0}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"27":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"67":{"tf":1.0},"68":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"36":{"tf":2.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"49":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"3":{"tf":1.0}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"u":{"df":1,"docs":{"1":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{":":{":":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"53":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"66":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"1":{"tf":1.0}}},"df":10,"docs":{"1":{"tf":1.7320508075688772},"10":{"tf":1.0},"11":{"tf":1.7320508075688772},"15":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":2.23606797749979},"4":{"tf":1.0},"45":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"p":{"df":2,"docs":{"4":{"tf":1.0},"66":{"tf":1.4142135623730951}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":15,"docs":{"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"63":{"tf":1.0},"69":{"tf":1.0},"9":{"tf":1.0}}},"t":{"df":1,"docs":{"21":{"tf":2.8284271247461903}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"38":{"tf":1.0},"59":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":3,"docs":{"32":{"tf":1.0},"51":{"tf":1.0},"68":{"tf":1.0}}},"u":{"df":0,"docs":{},"e":{"df":4,"docs":{"27":{"tf":1.0},"32":{"tf":1.4142135623730951},"37":{"tf":1.0},"46":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":8,"docs":{"17":{"tf":2.0},"18":{"tf":1.0},"20":{"tf":1.7320508075688772},"39":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.0},"59":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":2,"docs":{"32":{"tf":1.0},"4":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"60":{"tf":1.0}}},"2":{"df":2,"docs":{"17":{"tf":1.0},"60":{"tf":1.4142135623730951}}},"df":16,"docs":{"17":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"28":{"tf":2.449489742783178},"29":{"tf":2.23606797749979},"32":{"tf":3.0},"34":{"tf":1.0},"37":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":2.23606797749979},"60":{"tf":2.23606797749979},"63":{"tf":1.0},"8":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"3":{"2":{"df":3,"docs":{"18":{"tf":1.4142135623730951},"26":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}},"8":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"50":{"tf":1.0}}},":":{":":{"a":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},">":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"26":{"tf":2.0},"27":{"tf":2.23606797749979},"28":{"tf":2.23606797749979},"31":{"tf":1.0},"45":{"tf":2.449489742783178},"59":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"44":{"tf":1.7320508075688772},"53":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"31":{"tf":2.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"19":{"tf":1.7320508075688772}}}},"t":{"df":3,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"53":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":6,"docs":{"27":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"53":{"tf":1.0},"59":{"tf":1.0}}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":4,"docs":{"16":{"tf":1.0},"36":{"tf":2.23606797749979},"37":{"tf":1.0},"59":{"tf":1.0}},"e":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"55":{"tf":1.0},"56":{"tf":2.0}}}}}},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}}}},"s":{"df":36,"docs":{"1":{"tf":2.449489742783178},"11":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"21":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"3":{"tf":1.0},"31":{"tf":5.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.7320508075688772},"39":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"53":{"tf":2.8284271247461903},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"66":{"tf":2.6457513110645907},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"9":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"11":{"tf":1.0},"32":{"tf":1.0},"68":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"52":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"u":{"df":4,"docs":{"32":{"tf":1.0},"34":{"tf":1.0},"53":{"tf":1.4142135623730951},"66":{"tf":2.8284271247461903}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"3":{"tf":1.0},"63":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":2.6457513110645907},"63":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"68":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"41":{"tf":1.0}}}}}}},"df":1,"docs":{"59":{"tf":1.4142135623730951}},"e":{"c":{"!":{"[":{"a":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"59":{"tf":1.0}}}}},"t":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}},"u":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}},"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"16":{"tf":1.0},"27":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"66":{"tf":1.7320508075688772},"68":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"68":{"tf":1.0},"69":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"y":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":2,"docs":{"31":{"tf":1.0},"59":{"tf":1.0}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"45":{"tf":1.0},"54":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":2,"docs":{"59":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"20":{"tf":1.0},"51":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"53":{"tf":1.0},"9":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":6,"docs":{"3":{"tf":1.4142135623730951},"31":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"66":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{},"p":{"df":1,"docs":{"32":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":7,"docs":{"16":{"tf":1.0},"19":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"45":{"tf":1.0},"56":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":7,"docs":{"18":{"tf":1.0},"31":{"tf":1.0},"37":{"tf":1.0},"53":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"26":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"51":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":6,"docs":{"17":{"tf":1.0},"30":{"tf":1.4142135623730951},"36":{"tf":1.0},"55":{"tf":1.0},"66":{"tf":1.0},"9":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"18":{"tf":1.0},"36":{"tf":1.4142135623730951}}}}}}}}},"x":{"+":{"1":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}},".":{".":{"=":{"df":0,"docs":{},"i":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}},"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{")":{".":{".":{"(":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"(":{")":{".":{"b":{"a":{"df":0,"docs":{},"r":{"(":{")":{".":{"b":{"a":{"df":0,"docs":{},"z":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"df":19,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"26":{"tf":1.0},"31":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"62":{"tf":2.0},"9":{"tf":1.0}}},"y":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"df":11,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"26":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"4":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":2.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"z":{"df":4,"docs":{"31":{"tf":1.4142135623730951},"4":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"4":{"tf":1.0}}}}}}}},"breadcrumbs":{"root":{"0":{".":{".":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"55":{"tf":1.0}}}},"1":{"0":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":4,"docs":{"37":{"tf":1.0},"38":{"tf":1.0},"52":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951}}},"1":{".":{"2":{".":{"3":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"1":{"df":1,"docs":{"41":{"tf":1.0}}},"df":2,"docs":{"3":{"tf":1.0},"9":{"tf":1.0}}},"df":3,"docs":{"42":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.0}}},"1":{"df":1,"docs":{"17":{"tf":1.0}}},"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"0":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"32":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"df":1,"docs":{"46":{"tf":1.0}}},"df":6,"docs":{"4":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"52":{"tf":1.4142135623730951},"55":{"tf":1.0},"62":{"tf":1.4142135623730951}}},"2":{".":{"0":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"0":{"df":1,"docs":{"46":{"tf":1.0}}},"2":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}},"df":3,"docs":{"4":{"tf":1.0},"42":{"tf":1.0},"59":{"tf":1.0}}},"3":{"3":{"df":1,"docs":{"17":{"tf":1.0}}},"df":1,"docs":{"42":{"tf":1.0}}},"4":{".":{"5":{".":{"6":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"df":3,"docs":{"10":{"tf":1.0},"42":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}},"5":{"df":1,"docs":{"43":{"tf":1.0}}},"8":{"0":{"df":2,"docs":{"67":{"tf":1.0},"9":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"_":{"df":1,"docs":{"36":{"tf":2.6457513110645907}}},"a":{".":{"b":{".":{"c":{"(":{")":{".":{"d":{"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}},"?":{".":{"d":{"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"@":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},":":{":":{"b":{":":{":":{"c":{"df":1,"docs":{"31":{"tf":1.0}}},"d":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{},"{":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"31":{"tf":2.0}}},"c":{":":{":":{"d":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"{":{"b":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":3.1622776601683795}},"l":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"_":{"a":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"36":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":2.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"47":{"tf":1.0},"53":{"tf":1.0},"69":{"tf":1.4142135623730951}},"l":{"(":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"42":{"tf":1.0},"52":{"tf":1.7320508075688772},"55":{"tf":1.0}}}}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"a":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"42":{"tf":1.0}}}}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"52":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.0}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":2.6457513110645907}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"b":{"c":{"d":{"df":1,"docs":{"32":{"tf":2.449489742783178}},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"32":{"tf":1.0}}}}},"df":1,"docs":{"32":{"tf":1.4142135623730951}}},"df":0,"docs":{},"i":{"df":2,"docs":{"16":{"tf":1.0},"30":{"tf":1.0}},"l":{"df":1,"docs":{"68":{"tf":1.0}}}},"o":{"df":0,"docs":{},"v":{"df":8,"docs":{"15":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"69":{"tf":1.4142135623730951}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"31":{"tf":1.0},"43":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"32":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}}}}},"d":{"d":{"df":1,"docs":{"37":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"53":{"tf":1.0},"57":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"67":{"tf":2.0}}}}}}},"df":1,"docs":{"1":{"tf":1.0}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"19":{"tf":1.0},"53":{"tf":1.0}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"27":{"tf":1.0},"28":{"tf":1.7320508075688772},"29":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"32":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"32":{"tf":1.0},"36":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"53":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"32":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"h":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"y":{"df":6,"docs":{"11":{"tf":1.0},"20":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.0},"42":{"tf":1.0},"53":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"n":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"36":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":3,"docs":{"38":{"tf":1.4142135623730951},"51":{"tf":1.0},"54":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"11":{"tf":1.0},"32":{"tf":1.4142135623730951},"34":{"tf":1.0},"42":{"tf":1.0},"53":{"tf":1.7320508075688772}}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"32":{"tf":1.0},"51":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}}}}}}}}}},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"59":{"tf":1.4142135623730951},"67":{"tf":1.0}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"15":{"tf":1.0},"64":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"66":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"36":{"tf":1.0}},"u":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"36":{"tf":1.0},"53":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"51":{"tf":1.0},"54":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"11":{"tf":1.0},"42":{"tf":1.0}}}}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"52":{"tf":1.0},"55":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":2.8284271247461903}}}}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}},"df":6,"docs":{"27":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"42":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"g":{"1":{"df":3,"docs":{"16":{"tf":1.0},"37":{"tf":1.4142135623730951},"47":{"tf":1.0}}},"2":{"df":2,"docs":{"16":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951}}},"df":1,"docs":{"27":{"tf":2.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"1":{"df":1,"docs":{"53":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"53":{"tf":1.4142135623730951}}},"df":6,"docs":{"10":{"tf":1.0},"16":{"tf":1.4142135623730951},"47":{"tf":2.6457513110645907},"49":{"tf":1.7320508075688772},"54":{"tf":2.449489742783178},"9":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}},"m":{"df":2,"docs":{"53":{"tf":2.8284271247461903},"57":{"tf":1.0}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":13,"docs":{"18":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"31":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":2.6457513110645907},"66":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"42":{"tf":2.0},"43":{"tf":1.4142135623730951},"66":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":1,"docs":{"49":{"tf":1.0}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"27":{"tf":1.0},"45":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":3,"docs":{"26":{"tf":1.0},"29":{"tf":2.0},"67":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"10":{"tf":3.1622776601683795},"31":{"tf":1.0},"36":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"@":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"10":{"tf":1.0},"66":{"tf":1.7320508075688772},"67":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"45":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":12,"docs":{"16":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"53":{"tf":1.4142135623730951},"60":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0}}},"df":0,"docs":{}}}}},"b":{":":{":":{"a":{"df":1,"docs":{"31":{"tf":1.0}}},"c":{"df":1,"docs":{"31":{"tf":1.0}}},"d":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"x":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{},"{":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"31":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"(":{"1":{"1":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}}}},"<":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.0}}}},"[":{"0":{".":{".":{"1":{"0":{"0":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":14,"docs":{"10":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"29":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"34":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"51":{"tf":1.4142135623730951},"53":{"tf":2.8284271247461903},"60":{"tf":1.0},"69":{"tf":1.4142135623730951}},"e":{"df":2,"docs":{"66":{"tf":1.0},"67":{"tf":1.0}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"z":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":8,"docs":{"10":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"4":{"tf":1.0},"45":{"tf":1.0},"51":{"tf":2.0},"53":{"tf":1.0},"60":{"tf":1.0}}}},"df":9,"docs":{"19":{"tf":2.0},"31":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"59":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":28,"docs":{"10":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"21":{"tf":2.0},"22":{"tf":1.4142135623730951},"24":{"tf":1.0},"26":{"tf":1.7320508075688772},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.7320508075688772},"32":{"tf":1.0},"36":{"tf":1.7320508075688772},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.7320508075688772},"53":{"tf":2.23606797749979},"55":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"66":{"tf":1.0},"9":{"tf":2.23606797749979}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"54":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"31":{"tf":1.0},"42":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"46":{"tf":1.0},"51":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":12,"docs":{"19":{"tf":1.0},"21":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.4142135623730951},"4":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"47":{"tf":2.449489742783178},"59":{"tf":1.4142135623730951},"66":{"tf":2.0}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"32":{"tf":1.0},"52":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"45":{"tf":2.0}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"h":{"df":1,"docs":{"37":{"tf":1.0}}},"m":{"b":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"k":{"df":3,"docs":{"31":{"tf":1.0},"4":{"tf":2.0},"66":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"k":{"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":28,"docs":{"16":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":2.449489742783178},"28":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":3.4641016151377544},"34":{"tf":1.4142135623730951},"36":{"tf":3.872983346207417},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":2.23606797749979},"53":{"tf":3.4641016151377544},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"60":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.7320508075688772},"9":{"tf":2.449489742783178}}}},"df":0,"docs":{}}},"o":{"d":{"df":0,"docs":{},"i":{"df":3,"docs":{"27":{"tf":2.23606797749979},"37":{"tf":1.4142135623730951},"53":{"tf":2.23606797749979}}}},"df":0,"docs":{},"o":{"df":1,"docs":{"37":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":5,"docs":{"1":{"tf":1.0},"32":{"tf":1.0},"4":{"tf":1.4142135623730951},"55":{"tf":1.0},"66":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":7,"docs":{"21":{"tf":2.449489742783178},"26":{"tf":1.0},"27":{"tf":3.0},"29":{"tf":1.0},"4":{"tf":1.0},"55":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"x":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}}}}}},"df":1,"docs":{"60":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":14,"docs":{"18":{"tf":1.0},"19":{"tf":1.7320508075688772},"21":{"tf":1.7320508075688772},"22":{"tf":1.7320508075688772},"24":{"tf":1.0},"26":{"tf":1.0},"31":{"tf":1.7320508075688772},"32":{"tf":2.23606797749979},"36":{"tf":2.0},"37":{"tf":1.0},"38":{"tf":1.7320508075688772},"52":{"tf":2.6457513110645907},"53":{"tf":1.4142135623730951},"66":{"tf":1.0}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":10,"docs":{"26":{"tf":1.4142135623730951},"27":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"42":{"tf":2.0},"43":{"tf":2.0},"52":{"tf":1.0},"59":{"tf":2.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":18,"docs":{"16":{"tf":1.0},"21":{"tf":2.449489742783178},"22":{"tf":2.0},"26":{"tf":1.7320508075688772},"28":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"42":{"tf":1.7320508075688772},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"47":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":3.0},"55":{"tf":1.0},"60":{"tf":2.449489742783178}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"27":{"tf":1.0},"42":{"tf":1.0},"52":{"tf":1.4142135623730951},"55":{"tf":1.0},"60":{"tf":2.23606797749979}}}}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{":":{":":{"d":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},">":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":7,"docs":{"17":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":2.449489742783178},"48":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951},"51":{"tf":2.23606797749979},"54":{"tf":1.7320508075688772}},"e":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":4,"docs":{"13":{"tf":1.4142135623730951},"65":{"tf":1.7320508075688772},"66":{"tf":1.0},"67":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":8,"docs":{"10":{"tf":1.0},"18":{"tf":1.0},"27":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":2.449489742783178}}},"t":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}}}},"df":6,"docs":{"30":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951},"39":{"tf":1.0},"42":{"tf":1.0},"49":{"tf":1.0},"59":{"tf":1.4142135623730951}},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":3.0}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"15":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.0},"3":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"32":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":6,"docs":{"21":{"tf":1.0},"26":{"tf":2.23606797749979},"27":{"tf":3.3166247903554},"28":{"tf":1.7320508075688772},"52":{"tf":2.23606797749979},"53":{"tf":2.6457513110645907}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":17,"docs":{"16":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"66":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"37":{"tf":2.23606797749979},"54":{"tf":2.0}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":8,"docs":{"1":{"tf":1.4142135623730951},"16":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":10,"docs":{"20":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.7320508075688772},"38":{"tf":1.0},"59":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"10":{"tf":1.0},"32":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":2.0}}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"15":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"m":{"a":{"df":15,"docs":{"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.7320508075688772},"26":{"tf":1.7320508075688772},"27":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":2.0},"53":{"tf":1.4142135623730951},"59":{"tf":2.449489742783178},"66":{"tf":1.4142135623730951},"69":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"51":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":9,"docs":{"16":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"36":{"tf":3.0},"37":{"tf":1.0},"51":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772},"9":{"tf":5.5677643628300215}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"45":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}},"x":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"11":{"tf":1.0},"27":{"tf":1.7320508075688772},"32":{"tf":2.0},"52":{"tf":1.0}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"3":{"tf":1.0},"32":{"tf":1.0},"4":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.0},"53":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}},"df":3,"docs":{"50":{"tf":1.7320508075688772},"59":{"tf":1.0},"63":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"32":{"tf":2.0},"36":{"tf":2.0},"52":{"tf":1.0},"67":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":1.0},"42":{"tf":1.4142135623730951}}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"52":{"tf":1.0},"68":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":6,"docs":{"32":{"tf":1.0},"37":{"tf":1.0},"46":{"tf":1.4142135623730951},"52":{"tf":2.23606797749979},"53":{"tf":1.0},"68":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":10,"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.7320508075688772},"66":{"tf":1.7320508075688772},"67":{"tf":2.0}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}}}}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"60":{"tf":1.4142135623730951},"69":{"tf":1.0}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"32":{"tf":1.7320508075688772},"43":{"tf":1.0},"52":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}},"_":{"df":1,"docs":{"63":{"tf":1.0}}},"df":7,"docs":{"15":{"tf":1.0},"23":{"tf":1.7320508075688772},"31":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":2.0},"9":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"50":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"d":{"df":3,"docs":{"31":{"tf":1.4142135623730951},"42":{"tf":1.0},"59":{"tf":1.0}},"e":{"b":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{">":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":3,"docs":{"21":{"tf":1.0},"26":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}}}},"c":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"11":{"tf":1.0},"14":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"69":{"tf":1.0}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"r":{"df":6,"docs":{"15":{"tf":1.7320508075688772},"18":{"tf":1.0},"19":{"tf":1.0},"26":{"tf":1.0},"32":{"tf":1.4142135623730951},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.0},"27":{"tf":1.0},"31":{"tf":1.4142135623730951},"4":{"tf":1.0}}}}}},"df":1,"docs":{"32":{"tf":1.0}},"g":{"df":1,"docs":{"32":{"tf":1.0}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"11":{"tf":1.0},"16":{"tf":1.4142135623730951},"25":{"tf":1.0},"37":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"33":{"tf":1.4142135623730951},"54":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"66":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"54":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"10":{"tf":1.7320508075688772}},"e":{"(":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":3,"docs":{"32":{"tf":1.0},"4":{"tf":1.0},"67":{"tf":1.4142135623730951}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"66":{"tf":1.7320508075688772},"67":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"66":{"tf":1.0},"67":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"32":{"tf":1.0}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"1":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":2,"docs":{"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.7320508075688772}}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"26":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"o":{"c":{"df":1,"docs":{"9":{"tf":2.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"1":{"tf":1.0},"37":{"tf":1.0},"53":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"53":{"tf":1.0}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"19":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":2,"docs":{"68":{"tf":1.0},"69":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"e":{"df":2,"docs":{"45":{"tf":1.0},"51":{"tf":1.0}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":24,"docs":{"10":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"31":{"tf":1.7320508075688772},"32":{"tf":1.0},"34":{"tf":1.4142135623730951},"36":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"51":{"tf":2.23606797749979},"53":{"tf":2.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":18,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.7320508075688772},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"3":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.7320508075688772},"53":{"tf":1.0},"66":{"tf":1.7320508075688772},"67":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}}}}},"s":{"df":1,"docs":{"68":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"46":{"tf":1.0},"69":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"39":{"tf":1.0},"51":{"tf":2.8284271247461903}}}}}}},"i":{"d":{"df":2,"docs":{"37":{"tf":1.0},"45":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"@":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"67":{"tf":2.0}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":4,"docs":{"19":{"tf":1.4142135623730951},"20":{"tf":1.0},"36":{"tf":1.0},"53":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"d":{"df":6,"docs":{"19":{"tf":1.0},"32":{"tf":1.7320508075688772},"34":{"tf":1.0},"52":{"tf":1.0},"66":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":3,"docs":{"32":{"tf":1.4142135623730951},"66":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":3,"docs":{"18":{"tf":2.23606797749979},"41":{"tf":2.0},"63":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"10":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"18":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"c":{"df":3,"docs":{"31":{"tf":1.0},"45":{"tf":1.0},"68":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"1":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"11":{"tf":1.0},"27":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":17,"docs":{"11":{"tf":1.4142135623730951},"16":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.7320508075688772},"32":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":2.23606797749979},"53":{"tf":1.4142135623730951},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"9":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"66":{"tf":1.0},"67":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"31":{"tf":1.0},"54":{"tf":1.0}}}}},"df":0,"docs":{}}},"r":{"1":{"df":2,"docs":{"37":{"tf":1.0},"51":{"tf":1.0}}},"2":{"df":2,"docs":{"37":{"tf":1.0},"51":{"tf":1.0}}},"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":6,"docs":{"32":{"tf":2.0},"34":{"tf":1.0},"37":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":29,"docs":{"11":{"tf":1.0},"32":{"tf":3.605551275463989},"34":{"tf":2.23606797749979},"35":{"tf":1.7320508075688772},"36":{"tf":2.0},"37":{"tf":2.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":1.0},"45":{"tf":1.7320508075688772},"46":{"tf":1.7320508075688772},"47":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":2.8284271247461903},"53":{"tf":2.449489742783178},"54":{"tf":2.449489742783178},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"62":{"tf":1.7320508075688772},"67":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"n":{"df":6,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.7320508075688772},"30":{"tf":2.6457513110645907},"31":{"tf":1.0},"59":{"tf":1.0}}}}},"r":{"a":{"df":1,"docs":{"37":{"tf":1.0}},"n":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}}},"f":{"1":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}},"3":{"2":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"32":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"s":{"df":2,"docs":{"27":{"tf":1.0},"51":{"tf":1.0}}}}},"df":2,"docs":{"32":{"tf":2.6457513110645907},"38":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"20":{"tf":1.0},"31":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"1":{"df":3,"docs":{"37":{"tf":1.0},"38":{"tf":1.7320508075688772},"41":{"tf":1.0}}},"2":{"df":3,"docs":{"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"41":{"tf":1.0}}},"df":8,"docs":{"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":2.0},"38":{"tf":1.4142135623730951},"51":{"tf":2.0},"54":{"tf":1.0},"63":{"tf":1.0},"67":{"tf":2.23606797749979}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"15":{"tf":1.0},"66":{"tf":1.0}}}},"n":{"d":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"46":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":10,"docs":{"15":{"tf":1.0},"21":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":2.23606797749979},"37":{"tf":1.0},"47":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.4142135623730951},"67":{"tf":1.0}}}}},"t":{"df":8,"docs":{"16":{"tf":1.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":2.0},"53":{"tf":1.7320508075688772},"54":{"tf":1.0},"66":{"tf":1.7320508075688772}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":5,"docs":{"32":{"tf":1.0},"37":{"tf":1.0},"46":{"tf":1.4142135623730951},"52":{"tf":1.7320508075688772},"53":{"tf":1.0}}}}},"n":{"<":{"'":{"a":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":11,"docs":{"16":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951},"27":{"tf":2.449489742783178},"30":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"36":{"tf":2.23606797749979},"4":{"tf":1.7320508075688772},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"59":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":21,"docs":{"19":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.7320508075688772},"29":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"o":{"!":{"(":{"a":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"(":{"4":{"df":1,"docs":{"53":{"tf":1.0}}},"a":{"df":1,"docs":{"40":{"tf":1.0}},"r":{"df":0,"docs":{},"g":{"1":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}}},"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"54":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"10":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}},"x":{"df":1,"docs":{"47":{"tf":1.0}}},"|":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},".":{"b":{"a":{"df":0,"docs":{},"r":{".":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"(":{"a":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"{":{"a":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"z":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"{":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"df":0,"docs":{}},"<":{"b":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"32":{"tf":1.7320508075688772},"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{">":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"26":{"tf":1.0},"27":{"tf":2.23606797749979},"28":{"tf":1.4142135623730951}}}},"?":{".":{"b":{"a":{"df":0,"docs":{},"r":{"(":{")":{".":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"[":{".":{".":{"1":{"0":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"2":{"df":1,"docs":{"43":{"tf":1.0}}},"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"_":{"b":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"32":{"tf":1.0},"45":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":30,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":2.8284271247461903},"20":{"tf":1.7320508075688772},"21":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":3.4641016151377544},"34":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.7320508075688772},"4":{"tf":1.0},"51":{"tf":2.0},"52":{"tf":1.0},"53":{"tf":3.605551275463989},"55":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"69":{"tf":1.0},"9":{"tf":1.7320508075688772}}},"r":{"b":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"63":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":31,"docs":{"1":{"tf":2.8284271247461903},"10":{"tf":1.4142135623730951},"11":{"tf":2.0},"12":{"tf":1.4142135623730951},"18":{"tf":2.0},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":2.23606797749979},"38":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":2.449489742783178},"51":{"tf":2.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"9":{"tf":1.0}},"t":{"df":4,"docs":{"11":{"tf":1.0},"32":{"tf":1.0},"52":{"tf":1.0},"9":{"tf":1.0}}}}},"df":4,"docs":{"31":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"3":{"tf":1.4142135623730951},"4":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"11":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"68":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"25":{"tf":1.0},"67":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":14,"docs":{"10":{"tf":1.0},"16":{"tf":2.23606797749979},"17":{"tf":1.4142135623730951},"31":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":2.23606797749979},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"51":{"tf":1.0},"54":{"tf":1.0},"60":{"tf":1.4142135623730951},"63":{"tf":1.0}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}}}}}}}},"g":{"df":1,"docs":{"32":{"tf":2.6457513110645907}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"26":{"tf":2.8284271247461903},"28":{"tf":1.0},"45":{"tf":1.0},"60":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"11":{"tf":1.0}},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"o":{"df":2,"docs":{"27":{"tf":1.0},"67":{"tf":1.0}},"e":{"df":1,"docs":{"9":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"68":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"31":{"tf":2.6457513110645907}}}}}},"u":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"11":{"tf":1.0},"68":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"14":{"tf":1.4142135623730951},"19":{"tf":1.0},"29":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"28":{"tf":1.0},"53":{"tf":2.8284271247461903}}},"df":0,"docs":{}},"r":{"d":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"49":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"42":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.7320508075688772}}}}}}},"x":{"a":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"56":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"\\":{"0":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}}}}}}},"o":{"c":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{".":{"df":5,"docs":{"32":{"tf":1.7320508075688772},"4":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.0},"52":{"tf":1.0}}},"3":{"2":{"df":2,"docs":{"16":{"tf":2.449489742783178},"37":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"d":{"df":1,"docs":{"68":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":4,"docs":{"18":{"tf":1.0},"40":{"tf":1.0},"63":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"x":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":1.0},"49":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"22":{"tf":1.0},"27":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.0},"27":{"tf":1.0}}}},"df":3,"docs":{"22":{"tf":2.8284271247461903},"59":{"tf":1.0},"60":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"68":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"31":{"tf":5.830951894845301}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":9,"docs":{"21":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"51":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":28,"docs":{"10":{"tf":1.4142135623730951},"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.7320508075688772},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.7320508075688772},"28":{"tf":1.0},"3":{"tf":2.0},"31":{"tf":1.0},"32":{"tf":2.8284271247461903},"36":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"51":{"tf":2.0},"52":{"tf":2.0},"53":{"tf":2.23606797749979},"54":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"66":{"tf":2.23606797749979},"69":{"tf":2.23606797749979},"9":{"tf":1.4142135623730951}}}},"x":{"<":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"<":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"21":{"tf":1.0},"27":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"<":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"43":{"tf":1.7320508075688772}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"21":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"<":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"i":{"c":{"df":3,"docs":{"18":{"tf":1.0},"45":{"tf":1.0},"55":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":2,"docs":{"11":{"tf":1.0},"21":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":3,"docs":{"32":{"tf":2.0},"36":{"tf":1.0},"52":{"tf":1.7320508075688772}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}}},"i":{"d":{"df":2,"docs":{"10":{"tf":1.0},"53":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}},"n":{"df":1,"docs":{"68":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"66":{"tf":1.0}},"t":{"df":15,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"11":{"tf":1.0}}}}},"t":{"'":{"df":3,"docs":{"16":{"tf":1.4142135623730951},"38":{"tf":1.0},"47":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":24,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":2.23606797749979},"15":{"tf":2.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.7320508075688772},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":2.0},"31":{"tf":1.4142135623730951},"4":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"53":{"tf":1.0},"66":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":3,"docs":{"16":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.4142135623730951}}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":2,"docs":{"19":{"tf":1.0},"28":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":4,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0}}}},"y":{"df":1,"docs":{"66":{"tf":4.242640687119285}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":8,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"32":{"tf":2.23606797749979},"52":{"tf":1.4142135623730951},"59":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"26":{"tf":1.0},"31":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":7,"docs":{"16":{"tf":1.0},"31":{"tf":1.0},"47":{"tf":1.4142135623730951},"51":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"66":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":2.0}}}},"g":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"51":{"tf":1.0},"9":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"1":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"69":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"26":{"tf":1.0},"56":{"tf":1.0},"9":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":23,"docs":{"10":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.4142135623730951},"66":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"i":{"b":{"df":1,"docs":{"31":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"45":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"67":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"54":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"e":{"df":35,"docs":{"10":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":2.449489742783178},"19":{"tf":2.23606797749979},"20":{"tf":1.7320508075688772},"21":{"tf":2.23606797749979},"22":{"tf":2.23606797749979},"26":{"tf":2.23606797749979},"27":{"tf":2.8284271247461903},"28":{"tf":2.0},"3":{"tf":1.7320508075688772},"31":{"tf":3.0},"32":{"tf":5.0},"36":{"tf":3.0},"37":{"tf":1.0},"38":{"tf":2.0},"39":{"tf":1.7320508075688772},"4":{"tf":2.0},"42":{"tf":1.7320508075688772},"43":{"tf":1.7320508075688772},"44":{"tf":1.0},"45":{"tf":2.0},"47":{"tf":2.449489742783178},"49":{"tf":1.7320508075688772},"51":{"tf":4.0},"52":{"tf":3.872983346207417},"53":{"tf":4.242640687119285},"54":{"tf":2.449489742783178},"55":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":2.0},"66":{"tf":3.1622776601683795},"67":{"tf":1.0},"9":{"tf":3.1622776601683795}}}},"s":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"31":{"tf":2.8284271247461903},"54":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772},"69":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"11":{"tf":1.0},"3":{"tf":1.0},"38":{"tf":1.7320508075688772},"39":{"tf":1.4142135623730951},"40":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"42":{"tf":1.7320508075688772},"54":{"tf":1.0},"56":{"tf":2.6457513110645907}}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":3,"docs":{"27":{"tf":1.0},"31":{"tf":1.0},"54":{"tf":1.0}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}}}}},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"34":{"tf":1.0},"52":{"tf":1.0}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"1":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.7320508075688772}}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"25":{"tf":1.7320508075688772}}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"15":{"tf":1.0},"31":{"tf":1.0}}}}},"df":6,"docs":{"25":{"tf":1.0},"33":{"tf":1.7320508075688772},"42":{"tf":1.0},"49":{"tf":2.449489742783178},"54":{"tf":1.0},"63":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}}},"n":{"df":3,"docs":{"36":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":7,"docs":{"15":{"tf":1.0},"31":{"tf":1.0},"4":{"tf":1.0},"46":{"tf":1.0},"56":{"tf":1.0},"63":{"tf":1.0},"69":{"tf":1.7320508075688772}}}},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"11":{"tf":1.0},"53":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"51":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"1":{"tf":1.0},"53":{"tf":3.872983346207417},"57":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"x":{"df":3,"docs":{"31":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":3,"docs":{"3":{"tf":1.0},"4":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.0}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"1":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"31":{"tf":3.1622776601683795},"68":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"67":{"tf":1.0},"68":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":3,"docs":{"48":{"tf":1.4142135623730951},"51":{"tf":2.0},"63":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"68":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}}}}},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"/":{"a":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"x":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}},"o":{"d":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"l":{"df":20,"docs":{"15":{"tf":2.23606797749979},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"5":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":7,"docs":{"1":{"tf":1.0},"11":{"tf":1.4142135623730951},"20":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"52":{"tf":1.0},"67":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}},"v":{"df":0,"docs":{},"e":{"df":3,"docs":{"15":{"tf":1.0},"37":{"tf":1.4142135623730951},"69":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":14,"docs":{"18":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"38":{"tf":1.0},"47":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":1.0},"9":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"l":{"df":14,"docs":{"10":{"tf":1.0},"18":{"tf":1.4142135623730951},"26":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.0},"51":{"tf":1.7320508075688772},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"66":{"tf":1.0}}}}}}},"t":{"df":2,"docs":{"44":{"tf":1.0},"59":{"tf":1.7320508075688772}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"49":{"tf":1.0}}},"2":{"df":1,"docs":{"49":{"tf":1.0}}},"df":15,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"26":{"tf":1.0},"31":{"tf":1.7320508075688772},"33":{"tf":1.0},"41":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"63":{"tf":2.449489742783178},"66":{"tf":2.6457513110645907},"67":{"tf":2.449489742783178}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"28":{"tf":1.0},"31":{"tf":1.0},"60":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"45":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":3,"docs":{"1":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"52":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"31":{"tf":2.23606797749979},"54":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"38":{"tf":1.0},"43":{"tf":1.0},"53":{"tf":1.7320508075688772}}}}},"w":{"df":6,"docs":{"1":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"45":{"tf":1.0},"53":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":10,"docs":{"26":{"tf":1.0},"27":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.4142135623730951},"43":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"66":{"tf":1.4142135623730951},"69":{"tf":1.0},"9":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.4142135623730951},"66":{"tf":1.0}}}}},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"n":{"df":10,"docs":{"12":{"tf":1.4142135623730951},"22":{"tf":1.0},"31":{"tf":1.0},"53":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.0}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"28":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":6,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"27":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"51":{"tf":1.0},"9":{"tf":1.0}}},"h":{"df":3,"docs":{"31":{"tf":1.0},"32":{"tf":1.0},"52":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"p":{"df":1,"docs":{"53":{"tf":2.0}}}},"u":{"df":0,"docs":{},"m":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"52":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}}}},"k":{"(":{"a":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"41":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"c":{"df":2,"docs":{"19":{"tf":1.0},"53":{"tf":1.4142135623730951}}},"df":18,"docs":{"1":{"tf":1.0},"16":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"31":{"tf":1.7320508075688772},"32":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"59":{"tf":1.0},"66":{"tf":1.0}}},"p":{"df":2,"docs":{"44":{"tf":1.0},"45":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"n":{"df":18,"docs":{"16":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"24":{"tf":1.0},"26":{"tf":1.7320508075688772},"31":{"tf":1.0},"32":{"tf":2.0},"36":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"40":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"47":{"tf":2.0},"52":{"tf":2.23606797749979},"53":{"tf":1.0},"66":{"tf":1.0},"9":{"tf":1.7320508075688772}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":4,"docs":{"44":{"tf":1.7320508075688772},"45":{"tf":2.6457513110645907},"51":{"tf":1.0},"55":{"tf":1.0}}}},"t":{"df":1,"docs":{"32":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":6,"docs":{"11":{"tf":1.0},"15":{"tf":1.0},"27":{"tf":1.0},"31":{"tf":1.7320508075688772},"4":{"tf":1.0},"56":{"tf":1.4142135623730951}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"10":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"31":{"tf":2.0},"66":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":9,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"27":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"40":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"66":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.0},"66":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"10":{"tf":1.0},"54":{"tf":1.0},"9":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"21":{"tf":2.0}}}}}}},"df":2,"docs":{"27":{"tf":2.23606797749979},"31":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":2,"docs":{"47":{"tf":1.0},"69":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":2.0}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"54":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"47":{"tf":1.7320508075688772},"59":{"tf":1.0}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":10,"docs":{"20":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.0}},"i":{"df":4,"docs":{"16":{"tf":1.4142135623730951},"26":{"tf":1.0},"40":{"tf":1.0},"47":{"tf":1.7320508075688772}}}}}}}}},"s":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}},"t":{"df":1,"docs":{"26":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"64":{"tf":1.0},"66":{"tf":1.7320508075688772}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"1":{"tf":1.0},"32":{"tf":2.8284271247461903},"53":{"tf":2.8284271247461903},"57":{"tf":2.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"53":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":5,"docs":{"11":{"tf":1.0},"32":{"tf":1.4142135623730951},"52":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"68":{"tf":1.0}}}}},"df":0,"docs":{},"u":{"df":1,"docs":{"51":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"33":{"tf":1.7320508075688772},"34":{"tf":1.7320508075688772},"36":{"tf":2.0}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":18,"docs":{"10":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"51":{"tf":1.0},"53":{"tf":1.7320508075688772},"60":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":5,"docs":{"32":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"47":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":17,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"26":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951},"41":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.7320508075688772},"47":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.7320508075688772},"60":{"tf":1.4142135623730951},"62":{"tf":1.0},"69":{"tf":1.0},"9":{"tf":2.0}}}},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"37":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.0},"67":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":2,"docs":{"10":{"tf":1.0},"68":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"31":{"tf":1.0},"68":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"14":{"tf":1.4142135623730951},"68":{"tf":2.0},"69":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"68":{"tf":1.0}}}}}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":1,"docs":{"1":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"56":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"20":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"32":{"tf":1.0},"67":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"b":{"df":6,"docs":{"16":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"df":20,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"26":{"tf":1.7320508075688772},"32":{"tf":1.0},"37":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"47":{"tf":2.23606797749979},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"55":{"tf":1.0},"66":{"tf":2.8284271247461903},"9":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"36":{"tf":1.0},"41":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}},"x":{"(":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"32":{"tf":1.0}}}}}}}}}}}}}}}}}}}},"df":0,"docs":{}},"df":3,"docs":{"45":{"tf":1.0},"51":{"tf":2.0},"53":{"tf":1.0}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":2.23606797749979}}}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"55":{"tf":2.23606797749979}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"w":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":1,"docs":{"31":{"tf":1.0}},"e":{"a":{"d":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"49":{"tf":1.0},"52":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"15":{"tf":1.0},"27":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"d":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"31":{"tf":1.4142135623730951},"54":{"tf":1.0}}}}}},"df":1,"docs":{"31":{"tf":1.4142135623730951}},"f":{"df":1,"docs":{"53":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"45":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"32":{"tf":1.0},"66":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"45":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"(":{"c":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":8,"docs":{"1":{"tf":1.0},"18":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"53":{"tf":1.0},"66":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"63":{"tf":1.0}}}}},"t":{"df":2,"docs":{"27":{"tf":1.0},"32":{"tf":1.0}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"32":{"tf":1.7320508075688772},"34":{"tf":1.0},"37":{"tf":1.0}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"27":{"tf":2.0}}}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":4,"docs":{"19":{"tf":1.4142135623730951},"28":{"tf":1.0},"53":{"tf":2.0},"68":{"tf":1.0}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":13,"docs":{"1":{"tf":1.4142135623730951},"27":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":1.4142135623730951},"68":{"tf":1.0}}}},"n":{"df":1,"docs":{"47":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"62":{"tf":1.0}}},"c":{"df":1,"docs":{"68":{"tf":1.0}}},"df":4,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"16":{"tf":1.0},"66":{"tf":1.0}},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"31":{"tf":1.0},"68":{"tf":1.0}}}}}}}}},"s":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"55":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":10,"docs":{"19":{"tf":1.7320508075688772},"31":{"tf":1.0},"32":{"tf":2.23606797749979},"36":{"tf":1.4142135623730951},"42":{"tf":1.0},"52":{"tf":1.7320508075688772},"53":{"tf":1.7320508075688772},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"66":{"tf":2.0}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"1":{"tf":1.0}}}}},"c":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"60":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"31":{"tf":1.0},"37":{"tf":1.0},"60":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"18":{"tf":1.0},"37":{"tf":1.0},"51":{"tf":1.4142135623730951},"55":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"52":{"tf":1.0},"57":{"tf":1.0},"66":{"tf":3.3166247903554}}}}}}},"df":0,"docs":{},"e":{"df":5,"docs":{"11":{"tf":1.0},"49":{"tf":1.0},"57":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0}}},"l":{"df":0,"docs":{},"f":{".":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"52":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"(":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"51":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},":":{":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":2.23606797749979}}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"15":{"tf":1.0},"31":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"27":{"tf":1.0},"42":{"tf":1.0}}}}}}},"df":6,"docs":{"20":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.7320508075688772}}}},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"68":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"67":{"tf":1.7320508075688772},"9":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":9,"docs":{"15":{"tf":1.0},"20":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.4142135623730951},"42":{"tf":1.0},"59":{"tf":1.0},"66":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"51":{"tf":1.0},"66":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}}}}},"t":{"df":2,"docs":{"1":{"tf":1.0},"31":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":2.6457513110645907}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"32":{"tf":1.4142135623730951}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":4,"docs":{"26":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0},"53":{"tf":2.8284271247461903}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"59":{"tf":1.0},"9":{"tf":2.6457513110645907}}}},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"16":{"tf":1.4142135623730951},"22":{"tf":1.0},"27":{"tf":1.0}}}}}},"df":1,"docs":{"10":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"1":{"tf":1.0},"42":{"tf":1.0},"54":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.0},"42":{"tf":1.0}},"i":{"c":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":21,"docs":{"10":{"tf":1.7320508075688772},"17":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":2.449489742783178},"36":{"tf":2.23606797749979},"38":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"47":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":2.23606797749979},"53":{"tf":1.7320508075688772},"54":{"tf":1.4142135623730951},"59":{"tf":2.6457513110645907},"66":{"tf":1.0},"67":{"tf":1.0},"9":{"tf":2.0}}}}},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"e":{"df":2,"docs":{"11":{"tf":1.0},"27":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"9":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":8,"docs":{"11":{"tf":2.23606797749979},"18":{"tf":1.0},"38":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":2.6457513110645907}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"69":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"63":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"1":{"df":1,"docs":{"32":{"tf":1.7320508075688772}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":2,"docs":{"52":{"tf":1.0},"53":{"tf":1.0}}}}},"x":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}},"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"52":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{">":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"15":{"tf":1.0},"31":{"tf":1.4142135623730951},"66":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":34,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"26":{"tf":2.0},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":2.0},"33":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":2.0},"39":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"47":{"tf":2.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"55":{"tf":1.0},"59":{"tf":4.123105625617661},"66":{"tf":1.0},"68":{"tf":1.0},"9":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}},"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"18":{"tf":1.0},"49":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":2,"docs":{"66":{"tf":1.0},"68":{"tf":1.0}},"i":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"28":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"df":7,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"66":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}},"r":{"d":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":7,"docs":{"27":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"53":{"tf":2.0},"66":{"tf":1.7320508075688772},"67":{"tf":1.0},"9":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":11,"docs":{"15":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"32":{"tf":3.4641016151377544},"33":{"tf":2.0},"34":{"tf":2.0},"36":{"tf":2.23606797749979},"37":{"tf":1.0},"4":{"tf":1.7320508075688772},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951}}}}}}},"i":{"c":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}}},"y":{"df":1,"docs":{"32":{"tf":1.0}}}},"d":{":":{":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{":":{":":{"c":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"df":1,"docs":{"50":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":6,"docs":{"20":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"49":{"tf":1.7320508075688772},"66":{"tf":1.4142135623730951},"67":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":12,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"17":{"tf":2.0},"18":{"tf":2.8284271247461903},"19":{"tf":3.872983346207417},"20":{"tf":3.3166247903554},"38":{"tf":1.7320508075688772},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"54":{"tf":1.0},"63":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":6,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.7320508075688772},"16":{"tf":1.0},"51":{"tf":1.0},"61":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951}}}}}},"u":{"b":{"df":3,"docs":{"11":{"tf":1.0},"45":{"tf":1.0},"54":{"tf":1.4142135623730951}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"h":{"df":10,"docs":{"1":{"tf":1.4142135623730951},"11":{"tf":1.0},"18":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"45":{"tf":1.0},"54":{"tf":1.0},"60":{"tf":1.0},"66":{"tf":2.0},"68":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"15":{"tf":1.0},"31":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"59":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":4,"docs":{"31":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"68":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"a":{"b":{"df":1,"docs":{"3":{"tf":1.0}},"l":{"df":1,"docs":{"66":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":3,"docs":{"1":{"tf":1.0},"45":{"tf":1.0},"49":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}},"df":7,"docs":{"26":{"tf":1.4142135623730951},"27":{"tf":3.0},"28":{"tf":1.0},"45":{"tf":2.449489742783178},"59":{"tf":3.7416573867739413},"60":{"tf":1.0},"9":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.0}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"27":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"67":{"tf":1.0},"68":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"36":{"tf":2.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"49":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"3":{"tf":1.0}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"u":{"df":1,"docs":{"1":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{":":{":":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"53":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"66":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"1":{"tf":1.0}}},"df":10,"docs":{"1":{"tf":2.0},"10":{"tf":1.0},"11":{"tf":1.7320508075688772},"15":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":2.23606797749979},"4":{"tf":1.0},"45":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"p":{"df":2,"docs":{"4":{"tf":1.0},"66":{"tf":1.4142135623730951}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":15,"docs":{"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"63":{"tf":1.0},"69":{"tf":1.0},"9":{"tf":1.0}}},"t":{"df":1,"docs":{"21":{"tf":3.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"38":{"tf":1.0},"59":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":3,"docs":{"32":{"tf":1.0},"51":{"tf":1.0},"68":{"tf":1.0}}},"u":{"df":0,"docs":{},"e":{"df":4,"docs":{"27":{"tf":1.0},"32":{"tf":1.4142135623730951},"37":{"tf":1.0},"46":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":8,"docs":{"17":{"tf":2.449489742783178},"18":{"tf":1.0},"20":{"tf":2.0},"39":{"tf":1.7320508075688772},"40":{"tf":1.7320508075688772},"53":{"tf":1.0},"54":{"tf":1.0},"59":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":2,"docs":{"32":{"tf":1.0},"4":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"60":{"tf":1.0}}},"2":{"df":2,"docs":{"17":{"tf":1.0},"60":{"tf":1.4142135623730951}}},"df":16,"docs":{"17":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"28":{"tf":2.6457513110645907},"29":{"tf":2.449489742783178},"32":{"tf":3.0},"34":{"tf":1.0},"37":{"tf":1.4142135623730951},"58":{"tf":1.7320508075688772},"59":{"tf":2.449489742783178},"60":{"tf":2.449489742783178},"63":{"tf":1.0},"8":{"tf":1.4142135623730951}}},"i":{"c":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"3":{"2":{"df":3,"docs":{"18":{"tf":1.4142135623730951},"26":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}},"8":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"50":{"tf":1.0}}},":":{":":{"a":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},">":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"26":{"tf":2.0},"27":{"tf":2.23606797749979},"28":{"tf":2.23606797749979},"31":{"tf":1.0},"45":{"tf":2.449489742783178},"59":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"44":{"tf":2.0},"53":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"31":{"tf":2.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"19":{"tf":2.0}}}},"t":{"df":3,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"53":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":6,"docs":{"27":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"53":{"tf":1.0},"59":{"tf":1.0}}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":4,"docs":{"16":{"tf":1.0},"36":{"tf":2.23606797749979},"37":{"tf":1.0},"59":{"tf":1.0}},"e":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"55":{"tf":1.0},"56":{"tf":2.0}}}}}},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}}}},"s":{"df":37,"docs":{"1":{"tf":2.6457513110645907},"11":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"21":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"3":{"tf":1.0},"31":{"tf":5.0990195135927845},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.7320508075688772},"39":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"49":{"tf":1.7320508075688772},"53":{"tf":2.8284271247461903},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"66":{"tf":2.6457513110645907},"67":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"9":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"11":{"tf":1.0},"32":{"tf":1.0},"68":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"52":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"u":{"df":4,"docs":{"32":{"tf":1.0},"34":{"tf":1.0},"53":{"tf":1.4142135623730951},"66":{"tf":2.8284271247461903}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"3":{"tf":1.0},"63":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":2.6457513110645907},"63":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"68":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"41":{"tf":1.0}}}}}}},"df":1,"docs":{"59":{"tf":1.4142135623730951}},"e":{"c":{"!":{"[":{"a":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"59":{"tf":1.0}}}}},"t":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}},"u":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}},"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"16":{"tf":1.0},"27":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"66":{"tf":1.7320508075688772},"68":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"68":{"tf":1.0},"69":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"y":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":2,"docs":{"31":{"tf":1.0},"59":{"tf":1.0}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"45":{"tf":1.0},"54":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":2,"docs":{"59":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"20":{"tf":1.0},"51":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"53":{"tf":1.0},"9":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":6,"docs":{"3":{"tf":1.7320508075688772},"31":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"66":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{},"p":{"df":1,"docs":{"32":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":7,"docs":{"16":{"tf":1.0},"19":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"45":{"tf":1.0},"56":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":7,"docs":{"18":{"tf":1.0},"31":{"tf":1.0},"37":{"tf":1.0},"53":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"26":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"51":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":6,"docs":{"17":{"tf":1.0},"30":{"tf":1.4142135623730951},"36":{"tf":1.0},"55":{"tf":1.0},"66":{"tf":1.0},"9":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"18":{"tf":1.0},"36":{"tf":1.4142135623730951}}}}}}}}},"x":{"+":{"1":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}},".":{".":{"=":{"df":0,"docs":{},"i":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}},"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{")":{".":{".":{"(":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"(":{")":{".":{"b":{"a":{"df":0,"docs":{},"r":{"(":{")":{".":{"b":{"a":{"df":0,"docs":{},"z":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"df":19,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"26":{"tf":1.0},"31":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"62":{"tf":2.0},"9":{"tf":1.0}}},"y":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"df":11,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"26":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"4":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":2.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"z":{"df":4,"docs":{"31":{"tf":1.4142135623730951},"4":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"4":{"tf":1.0}}}}}}}},"title":{"root":{"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"42":{"tf":1.0},"43":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"45":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"47":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"13":{"tf":1.0},"65":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":1.0}}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"54":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"46":{"tf":1.0},"52":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"2":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0}}}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"23":{"tf":1.0}}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"18":{"tf":1.0},"41":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":6,"docs":{"34":{"tf":1.0},"35":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"62":{"tf":1.0},"7":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"23":{"tf":1.0},"30":{"tf":1.0}}}}}}}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"46":{"tf":1.0},"52":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"1":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.0},"59":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"16":{"tf":1.0},"47":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"0":{"tf":1.0},"68":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"14":{"tf":1.0},"69":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":1.0}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"x":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":4,"docs":{"11":{"tf":1.0},"15":{"tf":1.0},"30":{"tf":1.0},"5":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":4,"docs":{"3":{"tf":1.0},"4":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"56":{"tf":1.0}}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"df":2,"docs":{"33":{"tf":1.0},"49":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"48":{"tf":1.0},"51":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":3,"docs":{"24":{"tf":1.0},"5":{"tf":1.0},"64":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"63":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"44":{"tf":1.0},"45":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"57":{"tf":1.0}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"33":{"tf":1.0},"34":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"14":{"tf":1.0},"68":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"55":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"6":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"17":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"0":{"tf":1.0},"61":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"17":{"tf":1.4142135623730951},"20":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":4,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"58":{"tf":1.0},"8":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"s":{"df":4,"docs":{"1":{"tf":1.0},"14":{"tf":1.0},"31":{"tf":1.0},"49":{"tf":1.0}}}},"w":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}});