Object.assign(window.search, {"doc_urls":["index.html#clippy","installation.html#installation","installation.html#using-rustup","installation.html#from-source","usage.html#usage","usage.html#cargo-subcommand","usage.html#using-clippy-without-cargo-clippy-driver","configuration.html#configuring-clippy","lint_configuration.html#lint-configuration-options","lints.html#clippys-lints","lints.html#correctness","lints.html#suspicious","lints.html#complexity","lints.html#perf","lints.html#style","lints.html#pedantic","lints.html#restriction","lints.html#cargo","continuous_integration/index.html#continuous-integration","continuous_integration/github_actions.html#github-actions","continuous_integration/travis.html#travis-ci","development/index.html#clippy-development","development/index.html#getting-started","development/index.html#writing-code","development/basics.html#basics-for-hacking-on-clippy","development/basics.html#get-the-code","development/basics.html#building-and-testing","development/basics.html#cargo-dev","development/basics.html#lintcheck","development/basics.html#pr","development/basics.html#common-abbreviations","development/basics.html#install-from-source","development/adding_lints.html#adding-a-new-lint","development/adding_lints.html#setup","development/adding_lints.html#getting-started","development/adding_lints.html#defining-our-lint","development/adding_lints.html#testing","development/adding_lints.html#rustfix-tests","development/adding_lints.html#testing-manually","development/adding_lints.html#running-directly","development/adding_lints.html#lint-declaration","development/adding_lints.html#lint-registration","development/adding_lints.html#lint-passes","development/adding_lints.html#emitting-a-lint","development/adding_lints.html#adding-the-lint-logic","development/adding_lints.html#specifying-the-lints-minimum-supported-rust-version-msrv","development/adding_lints.html#author-lint","development/adding_lints.html#print-hir-lint","development/adding_lints.html#documentation","development/adding_lints.html#running-rustfmt","development/adding_lints.html#debugging","development/adding_lints.html#pr-checklist","development/adding_lints.html#adding-configuration-to-a-lint","development/adding_lints.html#cheat-sheet","development/type_checking.html#type-checking","development/type_checking.html#latecontext-and-typeckresults","development/type_checking.html#ty","development/type_checking.html#tykind","development/type_checking.html#hirty-and-tyty","development/type_checking.html#useful-links","development/common_tools_writing_lints.html#common-tools-for-writing-lints","development/common_tools_writing_lints.html#retrieving-the-type-of-expression","development/common_tools_writing_lints.html#checking-if-an-expr-is-calling-a-specific-method","development/common_tools_writing_lints.html#checking-for-a-specific-type","development/common_tools_writing_lints.html#checking-if-a-type-implements-a-specific-trait","development/common_tools_writing_lints.html#checking-if-a-type-defines-a-specific-method","development/common_tools_writing_lints.html#dealing-with-macros-and-expansions","development/infrastructure/index.html#infrastructure","development/infrastructure/sync.html#syncing-changes-between-clippy-and--rust-langrust","development/infrastructure/sync.html#patching-git-subtree-to-work-with-big-repos","development/infrastructure/sync.html#defining-remotes","development/infrastructure/sync.html#performing-the-sync-from--rust-langrust--to-clippy","development/infrastructure/sync.html#performing-the-sync-from-clippy-to--rust-langrust","development/infrastructure/backport.html#backport-changes","development/infrastructure/backport.html#backport-the-changes","development/infrastructure/backport.html#update-clippy-in-the-rust-repository","development/infrastructure/changelog_update.html#changelog-update","development/infrastructure/changelog_update.html#when-to-update","development/infrastructure/changelog_update.html#changelog-update-walkthrough","development/infrastructure/release.html#release-a-new-clippy-version","development/infrastructure/release.html#remerge-the-beta-branch","development/infrastructure/release.html#update-the-beta-branch","development/infrastructure/release.html#find-the-clippy-commit","development/infrastructure/release.html#tag-the-stable-commit","development/infrastructure/release.html#update-the-stable-branch","development/infrastructure/release.html#update-changelogmd","development/infrastructure/book.html#the-clippy-book","development/infrastructure/book.html#get-mdbook","development/infrastructure/book.html#make-changes","development/proposals/index.html#proposals","development/proposals/roadmap-2021.html#roadmap-2021","development/proposals/roadmap-2021.html#summary","development/proposals/roadmap-2021.html#motivation","development/proposals/roadmap-2021.html#explanation","development/proposals/roadmap-2021.html#user-facing","development/proposals/roadmap-2021.html#internal","development/proposals/roadmap-2021.html#prioritization","development/proposals/roadmap-2021.html#prior-art","development/proposals/roadmap-2021.html#rust-roadmap","development/proposals/roadmap-2021.html#drawbacks","development/proposals/roadmap-2021.html#big-roadmap","development/proposals/syntax-tree-patterns.html#summary","development/proposals/syntax-tree-patterns.html#motivation","development/proposals/syntax-tree-patterns.html#approach","development/proposals/syntax-tree-patterns.html#guide-level-explanation","development/proposals/syntax-tree-patterns.html#pattern-syntax","development/proposals/syntax-tree-patterns.html#the-result-type","development/proposals/syntax-tree-patterns.html#implementing-clippy-lints-using-patterns","development/proposals/syntax-tree-patterns.html#reference-level-explanation","development/proposals/syntax-tree-patterns.html#overview","development/proposals/syntax-tree-patterns.html#patterntree","development/proposals/syntax-tree-patterns.html#parsing--lowering","development/proposals/syntax-tree-patterns.html#the-ismatch-trait","development/proposals/syntax-tree-patterns.html#drawbacks","development/proposals/syntax-tree-patterns.html#rationale-and-alternatives","development/proposals/syntax-tree-patterns.html#alternatives","development/proposals/syntax-tree-patterns.html#prior-art","development/proposals/syntax-tree-patterns.html#unresolved-questions","development/proposals/syntax-tree-patterns.html#future-possibilities"],"index":{"documentStore":{"docInfo":{"0":{"body":120,"breadcrumbs":2,"title":1},"1":{"body":27,"breadcrumbs":2,"title":1},"10":{"body":34,"breadcrumbs":3,"title":1},"100":{"body":21,"breadcrumbs":6,"title":2},"101":{"body":27,"breadcrumbs":6,"title":1},"102":{"body":175,"breadcrumbs":6,"title":1},"103":{"body":118,"breadcrumbs":6,"title":1},"104":{"body":105,"breadcrumbs":8,"title":3},"105":{"body":362,"breadcrumbs":7,"title":2},"106":{"body":275,"breadcrumbs":7,"title":2},"107":{"body":20,"breadcrumbs":10,"title":5},"108":{"body":0,"breadcrumbs":8,"title":3},"109":{"body":64,"breadcrumbs":6,"title":1},"11":{"body":47,"breadcrumbs":3,"title":1},"110":{"body":113,"breadcrumbs":6,"title":1},"111":{"body":63,"breadcrumbs":7,"title":2},"112":{"body":125,"breadcrumbs":7,"title":2},"113":{"body":175,"breadcrumbs":6,"title":1},"114":{"body":105,"breadcrumbs":7,"title":2},"115":{"body":293,"breadcrumbs":6,"title":1},"116":{"body":33,"breadcrumbs":7,"title":2},"117":{"body":79,"breadcrumbs":7,"title":2},"118":{"body":395,"breadcrumbs":7,"title":2},"12":{"body":40,"breadcrumbs":3,"title":1},"13":{"body":29,"breadcrumbs":3,"title":1},"14":{"body":44,"breadcrumbs":3,"title":1},"15":{"body":57,"breadcrumbs":3,"title":1},"16":{"body":54,"breadcrumbs":3,"title":1},"17":{"body":16,"breadcrumbs":3,"title":1},"18":{"body":81,"breadcrumbs":4,"title":2},"19":{"body":50,"breadcrumbs":6,"title":2},"2":{"body":9,"breadcrumbs":3,"title":2},"20":{"body":49,"breadcrumbs":6,"title":2},"21":{"body":29,"breadcrumbs":3,"title":2},"22":{"body":15,"breadcrumbs":3,"title":2},"23":{"body":84,"breadcrumbs":3,"title":2},"24":{"body":35,"breadcrumbs":5,"title":3},"25":{"body":72,"breadcrumbs":3,"title":1},"26":{"body":78,"breadcrumbs":4,"title":2},"27":{"body":86,"breadcrumbs":4,"title":2},"28":{"body":43,"breadcrumbs":3,"title":1},"29":{"body":11,"breadcrumbs":3,"title":1},"3":{"body":15,"breadcrumbs":2,"title":1},"30":{"body":55,"breadcrumbs":4,"title":2},"31":{"body":126,"breadcrumbs":4,"title":2},"32":{"body":87,"breadcrumbs":6,"title":3},"33":{"body":3,"breadcrumbs":4,"title":1},"34":{"body":44,"breadcrumbs":5,"title":2},"35":{"body":104,"breadcrumbs":5,"title":2},"36":{"body":251,"breadcrumbs":4,"title":1},"37":{"body":38,"breadcrumbs":5,"title":2},"38":{"body":32,"breadcrumbs":5,"title":2},"39":{"body":47,"breadcrumbs":5,"title":2},"4":{"body":26,"breadcrumbs":2,"title":1},"40":{"body":167,"breadcrumbs":5,"title":2},"41":{"body":82,"breadcrumbs":5,"title":2},"42":{"body":68,"breadcrumbs":5,"title":2},"43":{"body":145,"breadcrumbs":5,"title":2},"44":{"body":141,"breadcrumbs":6,"title":3},"45":{"body":178,"breadcrumbs":10,"title":7},"46":{"body":57,"breadcrumbs":5,"title":2},"47":{"body":37,"breadcrumbs":6,"title":3},"48":{"body":61,"breadcrumbs":4,"title":1},"49":{"body":40,"breadcrumbs":5,"title":2},"5":{"body":346,"breadcrumbs":3,"title":2},"50":{"body":17,"breadcrumbs":4,"title":1},"51":{"body":35,"breadcrumbs":5,"title":2},"52":{"body":214,"breadcrumbs":6,"title":3},"53":{"body":80,"breadcrumbs":5,"title":2},"54":{"body":19,"breadcrumbs":5,"title":2},"55":{"body":68,"breadcrumbs":5,"title":2},"56":{"body":105,"breadcrumbs":4,"title":1},"57":{"body":75,"breadcrumbs":4,"title":1},"58":{"body":54,"breadcrumbs":5,"title":2},"59":{"body":16,"breadcrumbs":5,"title":2},"6":{"body":36,"breadcrumbs":7,"title":6},"60":{"body":47,"breadcrumbs":7,"title":4},"61":{"body":113,"breadcrumbs":6,"title":3},"62":{"body":42,"breadcrumbs":8,"title":5},"63":{"body":86,"breadcrumbs":6,"title":3},"64":{"body":103,"breadcrumbs":8,"title":5},"65":{"body":49,"breadcrumbs":8,"title":5},"66":{"body":204,"breadcrumbs":6,"title":3},"67":{"body":77,"breadcrumbs":3,"title":1},"68":{"body":104,"breadcrumbs":14,"title":6},"69":{"body":139,"breadcrumbs":14,"title":6},"7":{"body":328,"breadcrumbs":3,"title":2},"70":{"body":63,"breadcrumbs":10,"title":2},"71":{"body":139,"breadcrumbs":13,"title":5},"72":{"body":39,"breadcrumbs":13,"title":5},"73":{"body":46,"breadcrumbs":6,"title":2},"74":{"body":120,"breadcrumbs":6,"title":2},"75":{"body":80,"breadcrumbs":8,"title":4},"76":{"body":7,"breadcrumbs":6,"title":2},"77":{"body":45,"breadcrumbs":5,"title":1},"78":{"body":300,"breadcrumbs":7,"title":3},"79":{"body":53,"breadcrumbs":9,"title":4},"8":{"body":1272,"breadcrumbs":6,"title":3},"80":{"body":95,"breadcrumbs":8,"title":3},"81":{"body":70,"breadcrumbs":8,"title":3},"82":{"body":52,"breadcrumbs":8,"title":3},"83":{"body":38,"breadcrumbs":8,"title":3},"84":{"body":58,"breadcrumbs":8,"title":3},"85":{"body":60,"breadcrumbs":7,"title":2},"86":{"body":22,"breadcrumbs":6,"title":2},"87":{"body":35,"breadcrumbs":5,"title":1},"88":{"body":51,"breadcrumbs":6,"title":2},"89":{"body":47,"breadcrumbs":3,"title":1},"9":{"body":54,"breadcrumbs":4,"title":2},"90":{"body":0,"breadcrumbs":6,"title":2},"91":{"body":36,"breadcrumbs":5,"title":1},"92":{"body":55,"breadcrumbs":5,"title":1},"93":{"body":34,"breadcrumbs":5,"title":1},"94":{"body":207,"breadcrumbs":6,"title":2},"95":{"body":401,"breadcrumbs":5,"title":1},"96":{"body":61,"breadcrumbs":5,"title":1},"97":{"body":0,"breadcrumbs":6,"title":2},"98":{"body":19,"breadcrumbs":6,"title":2},"99":{"body":0,"breadcrumbs":5,"title":1}},"docs":{"0":{"body":"Clippy Test License: MIT OR Apache-2.0 A collection of lints to catch common mistakes and improve your Rust code. There are over 600 lints included in this crate! Lints are divided into categories, each with a default lint level . You can choose how much Clippy is supposed to annoy help you by changing the lint level by category. Category Description Default level clippy::all all lints that are on by default (correctness, suspicious, style, complexity, perf) warn/deny clippy::correctness code that is outright wrong or useless deny clippy::suspicious code that is most likely wrong or useless warn clippy::complexity code that does something simple but in a complex way warn clippy::perf code that can be written to run faster warn clippy::style code that should be written in a more idiomatic way warn clippy::pedantic lints which are rather strict or might have false positives allow clippy::nursery new lints that are still under development allow clippy::cargo lints for the cargo manifest allow More to come, please file an issue if you have ideas! The lint list also contains \"restriction lints\", which are for things which are usually not considered \"bad\", but may be useful to turn on in specific cases. These should be used very selectively, if at all.","breadcrumbs":"Introduction » Clippy","id":"0","title":"Clippy"},"1":{"body":"If you're using rustup to install and manage your Rust toolchains, Clippy is usually already installed . In that case you can skip this chapter and go to the Usage chapter. Note: If you used the minimal profile when installing a Rust toolchain, Clippy is not automatically installed.","breadcrumbs":"Installation » Installation","id":"1","title":"Installation"},"10":{"body":"The clippy::correctness group is the only lint group in Clippy which lints are deny-by-default and abort the compilation when triggered. This is for good reason: If you see a correctness lint, it means that your code is outright wrong or useless, and you should try to fix it. Lints in this category are carefully picked and should be free of false positives. So just #[allow]ing those lints is not recommended.","breadcrumbs":"Clippy's Lints » Correctness","id":"10","title":"Correctness"},"100":{"body":"This roadmap is pretty big and not all items listed in this document might be addressed during 2021. Because this is the first roadmap for Clippy, having open tasks at the end of 2021 is fine, but they should be revisited in the 2022 roadmap.","breadcrumbs":"Development » Proposals » Roadmap 2021 » Big Roadmap","id":"100","title":"Big Roadmap"},"101":{"body":"Feature Name: syntax-tree-patterns Start Date: 2019-03-12 RFC PR: #3875 Introduce a domain-specific language (similar to regular expressions) that allows to describe lints using syntax tree patterns .","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Summary","id":"101","title":"Summary"},"102":{"body":"Finding parts of a syntax tree (AST, HIR, ...) that have certain properties (e.g. \" an if that has a block as its condition \") is a major task when writing lints. For non-trivial lints, it often requires nested pattern matching of AST / HIR nodes. For example, testing that an expression is a boolean literal requires the following checks: if let ast::ExprKind::Lit(lit) = &expr.node { if let ast::LitKind::Bool(_) = &lit.node { ... }\n} Writing this kind of matching code quickly becomes a complex task and the resulting code is often hard to comprehend. The code below shows a simplified version of the pattern matching required by the collapsible_if lint: // simplified version of the collapsible_if lint\nif let ast::ExprKind::If(check, then, None) = &expr.node { if then.stmts.len() == 1 { if let ast::StmtKind::Expr(inner) | ast::StmtKind::Semi(inner) = &then.stmts[0].node { if let ast::ExprKind::If(check_inner, content, None) = &inner.node { ... } } }\n} The if_chain macro can improve readability by flattening the nested if statements, but the resulting code is still quite hard to read: // simplified version of the collapsible_if lint\nif_chain! { if let ast::ExprKind::If(check, then, None) = &expr.node; if then.stmts.len() == 1; if let ast::StmtKind::Expr(inner) | ast::StmtKind::Semi(inner) = &then.stmts[0].node; if let ast::ExprKind::If(check_inner, content, None) = &inner.node; then { ... }\n} The code above matches if expressions that contain only another if expression (where both ifs don't have an else branch). While it's easy to explain what the lint does, it's hard to see that from looking at the code samples above. Following the motivation above, the first goal this RFC is to simplify writing and reading lints . The second part of the motivation is clippy's dependence on unstable compiler-internal data structures. Clippy lints are currently written against the compiler's AST / HIR which means that even small changes in these data structures might break a lot of lints. The second goal of this RFC is to make lints independent of the compiler's AST / HIR data structures .","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Motivation","id":"102","title":"Motivation"},"103":{"body":"A lot of complexity in writing lints currently seems to come from having to manually implement the matching logic (see code samples above). It's an imperative style that describes how to match a syntax tree node instead of specifying what should be matched against declaratively. In other areas, it's common to use declarative patterns to describe desired information and let the implementation do the actual matching. A well-known example of this approach are regular expressions . Instead of writing code that detects certain character sequences, one can describe a search pattern using a domain-specific language and search for matches using that pattern. The advantage of using a declarative domain-specific language is that its limited domain (e.g. matching character sequences in the case of regular expressions) allows to express entities in that domain in a very natural and expressive way. While regular expressions are very useful when searching for patterns in flat character sequences, they cannot easily be applied to hierarchical data structures like syntax trees. This RFC therefore proposes a pattern matching system that is inspired by regular expressions and designed for hierarchical syntax trees.","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Approach","id":"103","title":"Approach"},"104":{"body":"This proposal adds a pattern! macro that can be used to specify a syntax tree pattern to search for. A simple pattern is shown below: pattern!{ my_pattern: Expr = Lit(Bool(false))\n} This macro call defines a pattern named my_pattern that can be matched against an Expr syntax tree node. The actual pattern (Lit(Bool(false)) in this case) defines which syntax trees should match the pattern. This pattern matches expressions that are boolean literals with value false. The pattern can then be used to implement lints in the following way: ... impl EarlyLintPass for MyAwesomeLint { fn check_expr(&mut self, cx: &EarlyContext, expr: &syntax::ast::Expr) { if my_pattern(expr).is_some() { cx.span_lint( MY_AWESOME_LINT, expr.span, \"This is a match for a simple pattern. Well done!\", ); } }\n} The pattern! macro call expands to a function my_pattern that expects a syntax tree expression as its argument and returns an Option that indicates whether the pattern matched. Note: The result type is explained in more detail in a later section . For now, it's enough to know that the result is Some if the pattern matched and None otherwise.","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Guide-level explanation","id":"104","title":"Guide-level explanation"},"105":{"body":"The following examples demonstate the pattern syntax: Any (_) The simplest pattern is the any pattern. It matches anything and is therefore similar to regex's *. pattern!{ // matches any expression my_pattern: Expr = _\n} Node (<node-name>(<args>)) Nodes are used to match a specific variant of an AST node. A node has a name and a number of arguments that depends on the node type. For example, the Lit node has a single argument that describes the type of the literal. As another example, the If node has three arguments describing the if's condition, then block and else block. pattern!{ // matches any expression that is a literal my_pattern: Expr = Lit(_)\n} pattern!{ // matches any expression that is a boolean literal my_pattern: Expr = Lit(Bool(_))\n} pattern!{ // matches if expressions that have a boolean literal in their condition // Note: The `_?` syntax here means that the else branch is optional and can be anything. // This is discussed in more detail in the section `Repetition`. my_pattern: Expr = If( Lit(Bool(_)) , _, _?)\n} Literal (<lit>) A pattern can also contain Rust literals. These literals match themselves. pattern!{ // matches the boolean literal false my_pattern: Expr = Lit(Bool(false))\n} pattern!{ // matches the character literal 'x' my_pattern: Expr = Lit(Char('x'))\n} Alternations (a | b) pattern!{ // matches if the literal is a boolean or integer literal my_pattern: Lit = Bool(_) | Int(_)\n} pattern!{ // matches if the expression is a char literal with value 'x' or 'y' my_pattern: Expr = Lit( Char('x' | 'y') )\n} Empty (()) The empty pattern represents an empty sequence or the None variant of an optional. pattern!{ // matches if the expression is an empty array my_pattern: Expr = Array( () )\n} pattern!{ // matches if expressions that don't have an else clause my_pattern: Expr = If(_, _, ())\n} Sequence (<a> <b>) pattern!{ // matches the array [true, false] my_pattern: Expr = Array( Lit(Bool(true)) Lit(Bool(false)) )\n} Repetition (<a>*, <a>+, <a>?, <a>{n}, <a>{n,m}, <a>{n,}) Elements may be repeated. The syntax for specifying repetitions is identical to regex's syntax . pattern!{ // matches arrays that contain 2 'x's as their last or second-last elements // Examples: // ['x', 'x'] match // ['x', 'x', 'y'] match // ['a', 'b', 'c', 'x', 'x', 'y'] match // ['x', 'x', 'y', 'z'] no match my_pattern: Expr = Array( _* Lit(Char('x')){2} _? )\n} pattern!{ // matches if expressions that **may or may not** have an else block // Attn: `If(_, _, _)` matches only ifs that **have** an else block // // | if with else block | if without else block // If(_, _, _) | match | no match // If(_, _, _?) | match | match // If(_, _, ()) | no match | match my_pattern: Expr = If(_, _, _?)\n} Named submatch (<a>#<name>) pattern!{ // matches character literals and gives the literal the name foo my_pattern: Expr = Lit(Char(_)#foo)\n} pattern!{ // matches character literals and gives the char the name bar my_pattern: Expr = Lit(Char(_#bar))\n} pattern!{ // matches character literals and gives the expression the name baz my_pattern: Expr = Lit(Char(_))#baz\n} The reason for using named submatches is described in the section The result type . Summary The following table gives an summary of the pattern syntax: Syntax Concept Examples _ Any _ <node-name>(<args>) Node Lit(Bool(true)), If(_, _, _) <lit> Literal 'x', false, 101 <a> \\| <b> Alternation Char(_) \\| Bool(_) () Empty Array( () ) <a> <b> Sequence Tuple( Lit(Bool(_)) Lit(Int(_)) Lit(_) ) <a>* <a>+ <a>? <a>{n} <a>{n,m} <a>{n,} Repetition Array( _* ), Block( Semi(_)+ ), If(_, _, Block(_)?), Array( Lit(_){10} ), Lit(_){5,10}, Lit(Bool(_)){10,} <a>#<name> Named submatch Lit(Int(_))#foo Lit(Int(_#bar))","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Pattern syntax","id":"105","title":"Pattern syntax"},"106":{"body":"A lot of lints require checks that go beyond what the pattern syntax described above can express. For example, a lint might want to check whether a node was created as part of a macro expansion or whether there's no comment above a node. Another example would be a lint that wants to match two nodes that have the same value (as needed by lints like almost_swapped). Instead of allowing users to write these checks into the pattern directly (which might make patterns hard to read), the proposed solution allows users to assign names to parts of a pattern expression. When matching a pattern against a syntax tree node, the return value will contain references to all nodes that were matched by these named subpatterns. This is similar to capture groups in regular expressions. For example, given the following pattern pattern!{ // matches character literals my_pattern: Expr = Lit(Char(_#val_inner)#val)#val_outer\n} one could get references to the nodes that matched the subpatterns in the following way: ...\nfn check_expr(expr: &syntax::ast::Expr) { if let Some(result) = my_pattern(expr) { result.val_inner // type: &char result.val // type: &syntax::ast::Lit result.val_outer // type: &syntax::ast::Expr }\n} The types in the result struct depend on the pattern. For example, the following pattern pattern!{ // matches arrays of character literals my_pattern_seq: Expr = Array( Lit(_)*#foo )\n} matches arrays that consist of any number of literal expressions. Because those expressions are named foo, the result struct contains a foo attribute which is a vector of expressions: ...\nif let Some(result) = my_pattern_seq(expr) { result.foo // type: Vec<&syntax::ast::Expr>\n} Another result type occurs when a name is only defined in one branch of an alternation: pattern!{ // matches if expression is a boolean or integer literal my_pattern_alt: Expr = Lit( Bool(_#bar) | Int(_) )\n} In the pattern above, the bar name is only defined if the pattern matches a boolean literal. If it matches an integer literal, the name isn't set. To account for this, the result struct's bar attribute is an option type: ...\nif let Some(result) = my_pattern_alt(expr) { result.bar // type: Option<&bool>\n} It's also possible to use a name in multiple alternation branches if they have compatible types: pattern!{ // matches if expression is a boolean or integer literal my_pattern_mult: Expr = Lit(_#baz) | Array( Lit(_#baz) )\n}\n...\nif let Some(result) = my_pattern_mult(expr) { result.baz // type: &syntax::ast::Lit\n} Named submatches are a flat namespace and this is intended. In the example above, two different sub-structures are assigned to a flat name. I expect that for most lints, a flat namespace is sufficient and easier to work with than a hierarchical one. Two stages Using named subpatterns, users can write lints in two stages. First, a coarse selection of possible matches is produced by the pattern syntax. In the second stage, the named subpattern references can be used to do additional tests like asserting that a node hasn't been created as part of a macro expansion.","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » The result type","id":"106","title":"The result type"},"107":{"body":"As a \"real-world\" example, I re-implemented the collapsible_if lint using patterns. The code can be found here . The pattern-based version passes all test cases that were written for collapsible_if.","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Implementing clippy lints using patterns","id":"107","title":"Implementing clippy lints using patterns"},"108":{"body":"","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Reference-level explanation","id":"108","title":"Reference-level explanation"},"109":{"body":"The following diagram shows the dependencies between the main parts of the proposed solution: Pattern syntax | | parsing / lowering v PatternTree ^ | | IsMatch trait | | +---------------+-----------+---------+ | | | | v v v v syntax::ast rustc::hir syn ... The pattern syntax described in the previous section is parsed / lowered into the so-called PatternTree data structure that represents a valid syntax tree pattern. Matching a PatternTree against an actual syntax tree (e.g. rust ast / hir or the syn ast, ...) is done using the IsMatch trait. The PatternTree and the IsMatch trait are introduced in more detail in the following sections.","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Overview","id":"109","title":"Overview"},"11":{"body":"The clippy::suspicious group is similar to the correctness lints in that it contains lints that trigger on code that is really sus and should be fixed. As opposed to correctness lints, it might be possible that the linted code is intentionally written like it is. It is still recommended to fix code that is linted by lints out of this group instead of #[allow]ing the lint. In case you intentionally have written code that offends the lint you should specifically and locally #[allow] the lint and add give a reason why the code is correct as written.","breadcrumbs":"Clippy's Lints » Suspicious","id":"11","title":"Suspicious"},"110":{"body":"The core data structure of this RFC is the PatternTree . It's a data structure similar to rust's AST / HIR, but with the following differences: The PatternTree doesn't contain parsing information like Spans The PatternTree can represent alternatives, sequences and optionals The code below shows a simplified version of the current PatternTree: Note: The current implementation can be found here . pub enum Expr { Lit(Alt<Lit>), Array(Seq<Expr>), Block_(Alt<BlockType>), If(Alt<Expr>, Alt<BlockType>, Opt<Expr>), IfLet( Alt<BlockType>, Opt<Expr>, ),\n} pub enum Lit { Char(Alt<char>), Bool(Alt<bool>), Int(Alt<u128>),\n} pub enum Stmt { Expr(Alt<Expr>), Semi(Alt<Expr>),\n} pub enum BlockType { Block(Seq<Stmt>),\n} The Alt, Seq and Opt structs look like these: Note: The current implementation can be found here . pub enum Alt<T> { Any, Elmt(Box<T>), Alt(Box<Self>, Box<Self>), Named(Box<Self>, ...)\n} pub enum Opt<T> { Any, // anything, but not None Elmt(Box<T>), None, Alt(Box<Self>, Box<Self>), Named(Box<Self>, ...)\n} pub enum Seq<T> { Any, Empty, Elmt(Box<T>), Repeat(Box<Self>, RepeatRange), Seq(Box<Self>, Box<Self>), Alt(Box<Self>, Box<Self>), Named(Box<Self>, ...)\n} pub struct RepeatRange { pub start: usize, pub end: Option<usize> // exclusive\n}","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » PatternTree","id":"110","title":"PatternTree"},"111":{"body":"The input of a pattern! macro call is parsed into a ParseTree first and then lowered to a PatternTree. Valid patterns depend on the PatternTree definitions. For example, the pattern Lit(Bool(_)*) isn't valid because the parameter type of the Lit variant of the Expr enum is Any<Lit> and therefore doesn't support repetition (*). As another example, Array( Lit(_)* ) is a valid pattern because the parameter of Array is of type Seq<Expr> which allows sequences and repetitions. Note: names in the pattern syntax correspond to PatternTree enum variants . For example, the Lit in the pattern above refers to the Lit variant of the Expr enum (Expr::Lit), not the Lit enum.","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Parsing / Lowering","id":"111","title":"Parsing / Lowering"},"112":{"body":"The pattern syntax and the PatternTree are independent of specific syntax tree implementations (rust ast / hir, syn, ...). When looking at the different pattern examples in the previous sections, it can be seen that the patterns don't contain any information specific to a certain syntax tree implementation. In contrast, clippy lints currently match against ast / hir syntax tree nodes and therefore directly depend on their implementation. The connection between the PatternTree and specific syntax tree implementations is the IsMatch trait. It defines how to match PatternTree nodes against specific syntax tree nodes. A simplified implementation of the IsMatch trait is shown below: pub trait IsMatch<O> { fn is_match(&self, other: &'o O) -> bool;\n} This trait needs to be implemented on each enum of the PatternTree (for the corresponding syntax tree types). For example, the IsMatch implementation for matching ast::LitKind against the PatternTree's Lit enum might look like this: impl IsMatch<ast::LitKind> for Lit { fn is_match(&self, other: &ast::LitKind) -> bool { match (self, other) { (Lit::Char(i), ast::LitKind::Char(j)) => i.is_match(j), (Lit::Bool(i), ast::LitKind::Bool(j)) => i.is_match(j), (Lit::Int(i), ast::LitKind::Int(j, _)) => i.is_match(j), _ => false, } }\n} All IsMatch implementations for matching the current PatternTree against syntax::ast can be found here .","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » The IsMatch Trait","id":"112","title":"The IsMatch Trait"},"113":{"body":"Performance The pattern matching code is currently not optimized for performance, so it might be slower than hand-written matching code. Additionally, the two-stage approach (matching against the coarse pattern first and checking for additional properties later) might be slower than the current practice of checking for structure and additional properties in one pass. For example, the following lint pattern!{ pat_if_without_else: Expr = If( _, Block( Expr( If(_, _, ())#inner ) | Semi( If(_, _, ())#inner ) )#then, () )\n}\n...\nfn check_expr(&mut self, cx: &EarlyContext<'_>, expr: &ast::Expr) { if let Some(result) = pat_if_without_else(expr) { if !block_starts_with_comment(cx, result.then) { ... }\n} first matches against the pattern and then checks that the then block doesn't start with a comment. Using clippy's current approach, it's possible to check for these conditions earlier: fn check_expr(&mut self, cx: &EarlyContext<'_>, expr: &ast::Expr) { if_chain! { if let ast::ExprKind::If(ref check, ref then, None) = expr.node; if !block_starts_with_comment(cx, then); if let Some(inner) = expr_block(then); if let ast::ExprKind::If(ref check_inner, ref content, None) = inner.node; then { ... } }\n} Whether or not this causes performance regressions depends on actual patterns. If it turns out to be a problem, the pattern matching algorithms could be extended to allow \"early filtering\" (see the Early Filtering section in Future Possibilities). That being said, I don't see any conceptual limitations regarding pattern matching performance. Applicability Even though I'd expect that a lot of lints can be written using the proposed pattern syntax, it's unlikely that all lints can be expressed using patterns. I suspect that there will still be lints that need to be implemented by writing custom pattern matching code. This would lead to mix within clippy's codebase where some lints are implemented using patterns and others aren't. This inconsistency might be considered a drawback.","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Drawbacks","id":"113","title":"Drawbacks"},"114":{"body":"Specifying lints using syntax tree patterns has a couple of advantages compared to the current approach of manually writing matching code. First, syntax tree patterns allow users to describe patterns in a simple and expressive way. This makes it easier to write new lints for both novices and experts and also makes reading / modifying existing lints simpler. Another advantage is that lints are independent of specific syntax tree implementations (e.g. AST / HIR, ...). When these syntax tree implementations change, only the IsMatch trait implementations need to be adapted and existing lints can remain unchanged. This also means that if the IsMatch trait implementations were integrated into the compiler, updating the IsMatch implementations would be required for the compiler to compile successfully. This could reduce the number of times clippy breaks because of changes in the compiler. Another advantage of the pattern's independence is that converting an EarlyLintPass lint into a LatePassLint wouldn't require rewriting the whole pattern matching code. In fact, the pattern might work just fine without any adaptions.","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Rationale and alternatives","id":"114","title":"Rationale and alternatives"},"115":{"body":"Rust-like pattern syntax The proposed pattern syntax requires users to know the structure of the PatternTree (which is very similar to the AST's / HIR's structure) and also the pattern syntax. An alternative would be to introduce a pattern syntax that is similar to actual Rust syntax (probably like the quote! macro). For example, a pattern that matches if expressions that have false in their condition could look like this: if false { #[*]\n} Problems Extending Rust syntax (which is quite complex by itself) with additional syntax needed for specifying patterns (alternations, sequences, repetitions, named submatches, ...) might become difficult to read and really hard to parse properly. For example, a pattern that matches a binary operation that has 0 on both sides might look like this: 0 #[*:BinOpKind] 0 Now consider this slightly more complex example: 1 + 0 #[*:BinOpKind] 0 The parser would need to know the precedence of #[*:BinOpKind] because it affects the structure of the resulting AST. 1 + 0 + 0 is parsed as (1 + 0) + 0 while 1 + 0 * 0 is parsed as 1 + (0 * 0). Since the pattern could be any BinOpKind, the precedence cannot be known in advance. Another example of a problem would be named submatches. Take a look at this pattern: fn test() { 1 #foo\n} Which node is #foo referring to? int, ast::Lit, ast::Expr, ast::Stmt? Naming subpatterns in a rust-like syntax is difficult because a lot of AST nodes don't have a syntactic element that can be used to put the name tag on. In these situations, the only sensible option would be to assign the name tag to the outermost node (ast::Stmt in the example above), because the information of all child nodes can be retrieved through the outermost node. The problem with this then would be that accessing inner nodes (like ast::Lit) would again require manual pattern matching. In general, Rust syntax contains a lot of code structure implicitly. This structure is reconstructed during parsing (e.g. binary operations are reconstructed using operator precedence and left-to-right) and is one of the reasons why parsing is a complex task. The advantage of this approach is that writing code is simpler for users. When writing syntax tree patterns , each element of the hierarchy might have alternatives, repetitions, etc.. Respecting that while still allowing human-friendly syntax that contains structure implicitly seems to be really complex, if not impossible. Developing such a syntax would also require to maintain a custom parser that is at least as complex as the Rust parser itself. Additionally, future changes in the Rust syntax might be incompatible with such a syntax. In summary, I think that developing such a syntax would introduce a lot of complexity to solve a relatively minor problem. The issue of users not knowing about the PatternTree structure could be solved by a tool that, given a rust program, generates a pattern that matches only this program (similar to the clippy author lint). For some simple cases (like the first example above), it might be possible to successfully mix Rust and pattern syntax. This space could be further explored in a future extension.","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Alternatives","id":"115","title":"Alternatives"},"116":{"body":"The pattern syntax is heavily inspired by regular expressions (repetitions, alternatives, sequences, ...). From what I've seen until now, other linters also implement lints that directly work on syntax tree data structures, just like clippy does currently. I would therefore consider the pattern syntax to be new , but please correct me if I'm wrong.","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Prior art","id":"116","title":"Prior art"},"117":{"body":"How to handle multiple matches? When matching a syntax tree node against a pattern, there are possibly multiple ways in which the pattern can be matched. A simple example of this would be the following pattern: pattern!{ my_pattern: Expr = Array( _* Lit(_)+#literals)\n} This pattern matches arrays that end with at least one literal. Now given the array [x, 1, 2], should 1 be matched as part of the _* or the Lit(_)+ part of the pattern? The difference is important because the named submatch #literals would contain 1 or 2 elements depending how the pattern is matched. In regular expressions, this problem is solved by matching \"greedy\" by default and \"non-greedy\" optionally. I haven't looked much into this yet because I don't know how relevant it is for most lints. The current implementation simply returns the first match it finds.","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Unresolved questions","id":"117","title":"Unresolved questions"},"118":{"body":"Implement rest of Rust Syntax The current project only implements a small part of the Rust syntax. In the future, this should incrementally be extended to more syntax to allow implementing more lints. Implementing more of the Rust syntax requires extending the PatternTree and IsMatch implementations, but should be relatively straight-forward. Early filtering As described in the Drawbacks/Performance section, allowing additional checks during the pattern matching might be beneficial. The pattern below shows how this could look like: pattern!{ pat_if_without_else: Expr = If( _, Block( Expr( If(_, _, ())#inner ) | Semi( If(_, _, ())#inner ) )#then, () ) where !in_macro(#then.span);\n} The difference compared to the currently proposed two-stage filtering is that using early filtering, the condition (!in_macro(#then.span) in this case) would be evaluated as soon as the Block(_)#then was matched. Another idea in this area would be to introduce a syntax for backreferences. They could be used to require that multiple parts of a pattern should match the same value. For example, the assign_op_pattern lint that searches for a = a op b and recommends changing it to a op= b requires that both occurrences of a are the same. Using =#... as syntax for backreferences, the lint could be implemented like this: pattern!{ assign_op_pattern: Expr = Assign(_#target, Binary(_, =#target, _)\n} Match descendant A lot of lints currently implement custom visitors that check whether any subtree (which might not be a direct descendant) of the current node matches some properties. This cannot be expressed with the proposed pattern syntax. Extending the pattern syntax to allow patterns like \"a function that contains at least two return statements\" could be a practical addition. Negation operator for alternatives For patterns like \"a literal that is not a boolean literal\" one currently needs to list all alternatives except the boolean case. Introducing a negation operator that allows to write Lit(!Bool(_)) might be a good idea. This pattern would be equivalent to Lit( Char(_) | Int(_) ) (given that currently only three literal types are implemented). Functional composition Patterns currently don't have any concept of composition. This leads to repetitions within patterns. For example, one of the collapsible-if patterns currently has to be written like this: pattern!{ pat_if_else: Expr = If( _, _, Block_( Block( Expr((If(_, _, _?) | IfLet(_, _?))#else_) | Semi((If(_, _, _?) | IfLet(_, _?))#else_) )#block_inner )#block ) | IfLet( _, Block_( Block( Expr((If(_, _, _?) | IfLet(_, _?))#else_) | Semi((If(_, _, _?) | IfLet(_, _?))#else_) )#block_inner )#block )\n} If patterns supported defining functions of subpatterns, the code could be simplified as follows: pattern!{ fn expr_or_semi(expr: Expr) -> Stmt { Expr(expr) | Semi(expr) } fn if_or_if_let(then: Block, else: Opt<Expr>) -> Expr { If(_, then, else) | IfLet(then, else) } pat_if_else: Expr = if_or_if_let( _, Block_( Block( expr_or_semi( if_or_if_let(_, _?)#else_ ) )#block_inner )#block )\n} Additionally, common patterns like expr_or_semi could be shared between different lints. Clippy Pattern Author Another improvement could be to create a tool that, given some valid Rust syntax, generates a pattern that matches this syntax exactly. This would make starting to write a pattern easier. A user could take a look at the patterns generated for a couple of Rust code examples and use that information to write a pattern that matches all of them. This is similar to clippy's author lint. Supporting other syntaxes Most of the proposed system is language-agnostic. For example, the pattern syntax could also be used to describe patterns for other programming languages. In order to support other languages' syntaxes, one would need to implement another PatternTree that sufficiently describes the languages' AST and implement IsMatch for this PatternTree and the languages' AST. One aspect of this is that it would even be possible to write lints that work on the pattern syntax itself. For example, when writing the following pattern pattern!{ my_pattern: Expr = Array( Lit(Bool(false)) Lit(Bool(false)) )\n} a lint that works on the pattern syntax's AST could suggest using this pattern instead: pattern!{ my_pattern: Expr = Array( Lit(Bool(false)){2} )\n} In the future, clippy could use this system to also provide lints for custom syntaxes like those found in macros.","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Future possibilities","id":"118","title":"Future possibilities"},"12":{"body":"The clippy::complexity group offers lints that give you suggestions on how to simplify your code. It mostly focuses on code that can be written in a shorter and more readable way, while preserving the semantics. If you should see a complexity lint, it usually means that you can remove or replace some code, and it is recommended to do so. However, if you need the more complex code for some expressiveness reason, it is recommended to allow complexity lints on a case-by-case basis.","breadcrumbs":"Clippy's Lints » Complexity","id":"12","title":"Complexity"},"13":{"body":"The clippy::perf group gives you suggestions on how you can increase the performance of your code. Those lints are mostly about code that the compiler can't trivially optimize, but has to be written in a slightly different way to make the optimizer job easier. Perf lints are usually easy to apply, and it is recommended to do so.","breadcrumbs":"Clippy's Lints » Perf","id":"13","title":"Perf"},"14":{"body":"The clippy::style group is mostly about writing idiomatic code. Because style is subjective, this lint group is the most opinionated warn-by-default group in Clippy. If you see a style lint, applying the suggestion usually makes your code more readable and idiomatic. But because we know that this is opinionated, feel free to sprinkle #[allow]s for style lints in your code or #![allow] a style lint on your whole crate if you disagree with the suggested style completely.","breadcrumbs":"Clippy's Lints » Style","id":"14","title":"Style"},"15":{"body":"The clippy::pedantic group makes Clippy even more pedantic . You can enable the whole group with #![warn(clippy::pedantic)] in the lib.rs/main.rs of your crate. This lint group is for Clippy power users that want an in depth check of their code. Note: Instead of enabling the whole group (like Clippy itself does), you may want to cherry-pick lints out of the pedantic group. If you enable this group, expect to also use #[allow] attributes generously throughout your code. Lints in this group are designed to be pedantic and false positives sometimes are intentional in order to prevent false negatives.","breadcrumbs":"Clippy's Lints » Pedantic","id":"15","title":"Pedantic"},"16":{"body":"The clippy::restriction group contains lints that will restrict you from using certain parts of the Rust language. It is not recommended to enable the whole group, but rather cherry-pick lints that are useful for your code base and your use case. Note: Clippy will produce a warning if it finds a #![warn(clippy::restriction)] attribute in your code! Lints from this group will restrict you in some way. If you enable a restriction lint for your crate it is recommended to also fix code that this lint triggers on. However, those lints are really strict by design, and you might want to #[allow] them in some special cases, with a comment justifying that.","breadcrumbs":"Clippy's Lints » Restriction","id":"16","title":"Restriction"},"17":{"body":"The clippy::cargo group gives you suggestions on how to improve your Cargo.toml file. This might be especially interesting if you want to publish your crate and are not sure if you have all useful information in your Cargo.toml.","breadcrumbs":"Clippy's Lints » Cargo","id":"17","title":"Cargo"},"18":{"body":"It is recommended to run Clippy on CI with -Dwarnings, so that Clippy lints prevent CI from passing. To enforce errors on warnings on all cargo commands not just cargo clippy, you can set the env var RUSTFLAGS=\"-Dwarnings\". We recommend to use Clippy from the same toolchain, that you use for compiling your crate for maximum compatibility. E.g. if your crate is compiled with the stable toolchain, you should also use stable Clippy. Note: New Clippy lints are first added to the nightly toolchain. If you want to help with improving Clippy and have CI resources left, please consider adding a nightly Clippy check to your CI and report problems like false positives back to us. With that we can fix bugs early, before they can get to stable. This chapter will give an overview on how to use Clippy on different popular CI providers.","breadcrumbs":"Continuous Integration » Continuous Integration","id":"18","title":"Continuous Integration"},"19":{"body":"GitHub hosted runners using the latest stable version of Rust have Clippy pre-installed. It is as simple as running cargo clippy to run lints against the codebase. on: push\nname: Clippy check # Make sure CI fails on all warnings, including Clippy lints\nenv: RUSTFLAGS: \"-Dwarnings\" jobs: clippy_check: runs-on: ubuntu-latest steps: - uses: actions/checkout@v3 - name: Run Clippy run: cargo clippy --all-targets --all-features","breadcrumbs":"Continuous Integration » GitHub Actions » GitHub Actions","id":"19","title":"GitHub Actions"},"2":{"body":"If Clippy was not installed for a toolchain, it can be installed with $ rustup component add clippy [--toolchain=<name>]","breadcrumbs":"Installation » Using Rustup","id":"2","title":"Using Rustup"},"20":{"body":"You can add Clippy to Travis CI in the same way you use it locally: language: rust\nrust: - stable - beta\nbefore_script: - rustup component add clippy\nscript: - cargo clippy # if you want the build job to fail when encountering warnings, use - cargo clippy -- -D warnings # in order to also check tests and non-default crate features, use - cargo clippy --all-targets --all-features -- -D warnings - cargo test # etc.","breadcrumbs":"Continuous Integration » Travis CI » Travis CI","id":"20","title":"Travis CI"},"21":{"body":"Hello fellow Rustacean! If you made it here, you're probably interested in making Clippy better by contributing to it. In that case, welcome to the project! Note: If you're just interested in using Clippy, there's nothing to see from this point onward, and you should return to one of the earlier chapters.","breadcrumbs":"Development » Clippy Development","id":"21","title":"Clippy Development"},"22":{"body":"If this is your first time contributing to Clippy, you should first read the Basics docs . This will explain the basics on how to get the source code and how to compile and test the code.","breadcrumbs":"Development » Getting started","id":"22","title":"Getting started"},"23":{"body":"If you have done the basic setup, it's time to start hacking. The Adding lints chapter is a walk through on how to add a new lint to Clippy. This is also interesting if you just want to fix a lint, because it also covers how to test lints and gives an overview of the bigger picture. If you want to add a new lint or change existing ones apart from bugfixing, it's also a good idea to give the stability guarantees and lint categories sections of the Clippy 1.0 RFC a quick read. The lint categories are also described earlier in this book . Note: Some higher level things about contributing to Clippy are still covered in the CONTRIBUTING.md document. Some of those will be moved to the book over time, like: Finding something to fix IDE setup High level overview on how Clippy works Triage procedure Bors and Homu","breadcrumbs":"Development » Writing code","id":"23","title":"Writing code"},"24":{"body":"This document explains the basics for hacking on Clippy. Besides others, this includes how to build and test Clippy. For a more in depth description on the codebase take a look at Adding Lints or Common Tools . Basics for hacking on Clippy Get the Code Building and Testing cargo dev lintcheck PR Common Abbreviations Install from source","breadcrumbs":"Development » Basics » Basics for hacking on Clippy","id":"24","title":"Basics for hacking on Clippy"},"25":{"body":"First, make sure you have checked out the latest version of Clippy. If this is your first time working on Clippy, create a fork of the repository and clone it afterwards with the following command: git clone git@github.com:<your-username>/rust-clippy If you've already cloned Clippy in the past, update it to the latest version: # If the upstream remote has not been added yet\ngit remote add upstream https://github.com/rust-lang/rust-clippy\n# upstream has to be the remote of the rust-lang/rust-clippy repo\ngit fetch upstream\n# make sure that you are on the master branch\ngit checkout master\n# rebase your master branch on the upstream master\ngit rebase upstream/master\n# push to the master branch of your fork\ngit push","breadcrumbs":"Development » Basics » Get the Code","id":"25","title":"Get the Code"},"26":{"body":"You can build and test Clippy like every other Rust project: cargo build # builds Clippy\ncargo test # tests Clippy Since Clippy's test suite is pretty big, there are some commands that only run a subset of Clippy's tests: # only run UI tests\ncargo uitest\n# only run UI tests starting with `test_`\nTESTNAME=\"test_\" cargo uitest\n# only run dogfood tests\ncargo dev dogfood If the output of a UI test differs from the expected output, you can update the reference file with: cargo dev bless For example, this is necessary if you fix a typo in an error message of a lint, or if you modify a test file to add a test case. Note: This command may update more files than you intended. In that case only commit the files you wanted to update.","breadcrumbs":"Development » Basics » Building and Testing","id":"26","title":"Building and Testing"},"27":{"body":"Clippy has some dev tools to make working on Clippy more convenient. These tools can be accessed through the cargo dev command. Available tools are listed below. To get more information about these commands, just call them with --help. # formats the whole Clippy codebase and all tests\ncargo dev fmt\n# register or update lint names/groups/...\ncargo dev update_lints\n# create a new lint and register it\ncargo dev new_lint\n# deprecate a lint and attempt to remove code relating to it\ncargo dev deprecate\n# automatically formatting all code before each commit\ncargo dev setup git-hook\n# (experimental) Setup Clippy to work with IntelliJ-Rust\ncargo dev setup intellij\n# runs the `dogfood` tests\ncargo dev dogfood More about intellij command usage and reasons.","breadcrumbs":"Development » Basics » cargo dev","id":"27","title":"cargo dev"},"28":{"body":"cargo lintcheck will build and run clippy on a fixed set of crates and generate a log of the results. You can git diff the updated log against its previous version and see what impact your lint made on a small set of crates. If you add a new lint, please audit the resulting warnings and make sure there are no false positives and that the suggestions are valid. Refer to the tools README for more details.","breadcrumbs":"Development » Basics » lintcheck","id":"28","title":"lintcheck"},"29":{"body":"We follow a rustc no merge-commit policy. See https://rustc-dev-guide.rust-lang.org/contributing.html#opening-a-pr .","breadcrumbs":"Development » Basics » PR","id":"29","title":"PR"},"3":{"body":"Take a look at the Basics chapter in the Clippy developer guide to find step-by-step instructions on how to build and install Clippy from source.","breadcrumbs":"Installation » From Source","id":"3","title":"From Source"},"30":{"body":"Abbreviation Meaning UB Undefined Behavior FP False Positive FN False Negative ICE Internal Compiler Error AST Abstract Syntax Tree MIR Mid-Level Intermediate Representation HIR High-Level Intermediate Representation TCX Type context This is a concise list of abbreviations that can come up during Clippy development. An extensive general list can be found in the rustc-dev-guide glossary . Always feel free to ask if an abbreviation or meaning is unclear to you.","breadcrumbs":"Development » Basics » Common Abbreviations","id":"30","title":"Common Abbreviations"},"31":{"body":"If you are hacking on Clippy and want to install it from source, do the following: First, take note of the toolchain override in /rust-toolchain. We will use this override to install Clippy into the right toolchain. Tip: You can view the active toolchain for the current directory with rustup show active-toolchain. From the Clippy project root, run the following command to build the Clippy binaries and copy them into the toolchain directory. This will override the currently installed Clippy component. cargo build --release --bin cargo-clippy --bin clippy-driver -Zunstable-options --out-dir \"$(rustc --print=sysroot)/bin\" Now you may run cargo clippy in any project, using the toolchain where you just installed Clippy. cd my-project\ncargo +nightly-2021-07-01 clippy ...or clippy-driver clippy-driver +nightly-2021-07-01 <filename> If you need to restore the default Clippy installation, run the following (from the Clippy project root). rustup component remove clippy\nrustup component add clippy DO NOT install using cargo install --path . --force since this will overwrite rustup proxies . That is, ~/.cargo/bin/cargo-clippy and ~/.cargo/bin/clippy-driver should be hard or soft links to ~/.cargo/bin/rustup. You can repair these by running rustup update.","breadcrumbs":"Development » Basics » Install from source","id":"31","title":"Install from source"},"32":{"body":"You are probably here because you want to add a new lint to Clippy. If this is the first time you're contributing to Clippy, this document guides you through creating an example lint from scratch. To get started, we will create a lint that detects functions called foo, because that's clearly a non-descriptive name. Adding a new lint Setup Getting Started Defining Our Lint Standalone Specific Type Tests Location Testing Cargo lints Rustfix tests Testing manually Running directly Lint declaration Lint registration Lint passes Emitting a lint Adding the lint logic Specifying the lint's minimum supported Rust version (MSRV) Author lint Print HIR lint Documentation Running rustfmt Debugging PR Checklist Adding configuration to a lint Cheat Sheet","breadcrumbs":"Development » Adding Lints » Adding a new lint","id":"32","title":"Adding a new lint"},"33":{"body":"See the Basics documentation.","breadcrumbs":"Development » Adding Lints » Setup","id":"33","title":"Setup"},"34":{"body":"There is a bit of boilerplate code that needs to be set up when creating a new lint. Fortunately, you can use the Clippy dev tools to handle this for you. We are naming our new lint foo_functions (lints are generally written in snake case), and we don't need type information, so it will have an early pass type (more on this later). If you're unsure if the name you chose fits the lint, take a look at our lint naming guidelines .","breadcrumbs":"Development » Adding Lints » Getting Started","id":"34","title":"Getting Started"},"35":{"body":"To get started, there are two ways to define our lint. Standalone Command: cargo dev new_lint --name=foo_functions --pass=early --category=pedantic (category will default to nursery if not provided) This command will create a new file: clippy_lints/src/foo_functions.rs, as well as register the lint . Specific Type Command: cargo dev new_lint --name=foo_functions --type=functions --category=pedantic This command will create a new file: clippy_lints/src/{type}/foo_functions.rs. Notice how this command has a --type flag instead of --pass. Unlike a standalone definition, this lint won't be registered in the traditional sense. Instead, you will call your lint from within the type's lint pass, found in clippy_lints/src/{type}/mod.rs. A \"type\" is just the name of a directory in clippy_lints/src, like functions in the example command. These are groupings of lints with common behaviors, so if your lint falls into one, it would be best to add it to that type. Tests Location Both commands will create a file: tests/ui/foo_functions.rs. For cargo lints, two project hierarchies (fail/pass) will be created by default under tests/ui-cargo. Next, we'll open up these files and add our lint!","breadcrumbs":"Development » Adding Lints » Defining Our Lint","id":"35","title":"Defining Our Lint"},"36":{"body":"Let's write some tests first that we can execute while we iterate on our lint. Clippy uses UI tests for testing. UI tests check that the output of Clippy is exactly as expected. Each test is just a plain Rust file that contains the code we want to check. The output of Clippy is compared against a .stderr file. Note that you don't have to create this file yourself, we'll get to generating the .stderr files further down. We start by opening the test file created at tests/ui/foo_functions.rs. Update the file with some examples to get started: #![allow(unused)]\n#![warn(clippy::foo_functions)] // Impl methods\nstruct A;\nimpl A { pub fn fo(&self) {} pub fn foo(&self) {} pub fn food(&self) {}\n} // Default trait methods\ntrait B { fn fo(&self) {} fn foo(&self) {} fn food(&self) {}\n} // Plain functions\nfn fo() {}\nfn foo() {}\nfn food() {} fn main() { // We also don't want to lint method calls foo(); let a = A; a.foo();\n} Now we can run the test with TESTNAME=foo_functions cargo uitest, currently this test is meaningless though. While we are working on implementing our lint, we can keep running the UI test. That allows us to check if the output is turning into what we want. Once we are satisfied with the output, we need to run cargo dev bless to update the .stderr file for our lint. Please note that, we should run TESTNAME=foo_functions cargo uitest every time before running cargo dev bless. Running TESTNAME=foo_functions cargo uitest should pass then. When we commit our lint, we need to commit the generated .stderr files, too. In general, you should only commit files changed by cargo dev bless for the specific lint you are creating/editing. Note that if the generated files are empty, they should be removed. Note: you can run multiple test files by specifying a comma separated list: TESTNAME=foo_functions,test2,test3. Cargo lints For cargo lints, the process of testing differs in that we are interested in the Cargo.toml manifest file. We also need a minimal crate associated with that manifest. If our new lint is named e.g. foo_categories, after running cargo dev new_lint --name=foo_categories --type=cargo --category=cargo we will find by default two new crates, each with its manifest file: tests/ui-cargo/foo_categories/fail/Cargo.toml: this file should cause the new lint to raise an error. tests/ui-cargo/foo_categories/pass/Cargo.toml: this file should not trigger the lint. If you need more cases, you can copy one of those crates (under foo_categories) and rename it. The process of generating the .stderr file is the same, and prepending the TESTNAME variable to cargo uitest works too.","breadcrumbs":"Development » Adding Lints » Testing","id":"36","title":"Testing"},"37":{"body":"If the lint you are working on is making use of structured suggestions, the test file should include a // run-rustfix comment at the top. This will additionally run rustfix for that test. Rustfix will apply the suggestions from the lint to the code of the test file and compare that to the contents of a .fixed file. Use cargo dev bless to automatically generate the .fixed file after running the tests.","breadcrumbs":"Development » Adding Lints » Rustfix tests","id":"37","title":"Rustfix tests"},"38":{"body":"Manually testing against an example file can be useful if you have added some println!s and the test suite output becomes unreadable. To try Clippy with your local modifications, run cargo dev lint input.rs from the working copy root. With tests in place, let's have a look at implementing our lint now.","breadcrumbs":"Development » Adding Lints » Testing manually","id":"38","title":"Testing manually"},"39":{"body":"While it's easier to just use cargo dev lint, it might be desirable to get target/release/cargo-clippy and target/release/clippy-driver to work as well in some cases. By default, they don't work because clippy dynamically links rustc. To help them find rustc, add the path printed byrustc --print target-libdir (ran inside this workspace so that the rustc version matches) to your library search path. On linux, this can be done by setting the LD_LIBRARY_PATH environment variable to that path.","breadcrumbs":"Development » Adding Lints » Running directly","id":"39","title":"Running directly"},"4":{"body":"This chapter describes how to use Clippy to get the most out of it. Clippy can be used as a cargo subcommand or, like rustc, directly with the clippy-driver binary. Note: This chapter assumes that you have Clippy installed already. If you're not sure, take a look at the Installation chapter.","breadcrumbs":"Usage » Usage","id":"4","title":"Usage"},"40":{"body":"Let's start by opening the new file created in the clippy_lints crate at clippy_lints/src/foo_functions.rs. That's the crate where all the lint code is. This file has already imported some initial things we will need: use rustc_lint::{EarlyLintPass, EarlyContext};\nuse rustc_session::{declare_lint_pass, declare_tool_lint};\nuse rustc_ast::ast::*; The next step is to update the lint declaration. Lints are declared using the declare_clippy_lint! macro, and we just need to update the auto-generated lint declaration to have a real description, something like this: declare_clippy_lint! { /// ### What it does /// /// ### Why is this bad? /// /// ### Example /// ```rust /// // example code /// ``` #[clippy::version = \"1.29.0\"] pub FOO_FUNCTIONS, pedantic, \"function named `foo`, which is not a descriptive name\"\n} The section of lines prefixed with /// constitutes the lint documentation section. This is the default documentation style and will be displayed like this . To render and open this documentation locally in a browser, run cargo dev serve. The #[clippy::version] attribute will be rendered as part of the lint documentation. The value should be set to the current Rust version that the lint is developed in, it can be retrieved by running rustc -vV in the rust-clippy directory. The version is listed under release . (Use the version without the -nightly) suffix. FOO_FUNCTIONS is the name of our lint. Be sure to follow the lint naming guidelines here when naming your lint. In short, the name should state the thing that is being checked for and read well when used with allow/warn/deny. pedantic sets the lint level to Allow. The exact mapping can be found here The last part should be a text that explains what exactly is wrong with the code The rest of this file contains an empty implementation for our lint pass, which in this case is EarlyLintPass and should look like this: // clippy_lints/src/foo_functions.rs // .. imports and lint declaration .. declare_lint_pass!(FooFunctions => [FOO_FUNCTIONS]); impl EarlyLintPass for FooFunctions {}","breadcrumbs":"Development » Adding Lints » Lint declaration","id":"40","title":"Lint declaration"},"41":{"body":"When using cargo dev new_lint, the lint is automatically registered and nothing more has to be done. When declaring a new lint by hand and cargo dev update_lints is used, the lint pass may have to be registered manually in the register_plugins function in clippy_lints/src/lib.rs: store.register_early_pass(|| Box::new(foo_functions::FooFunctions)); As one may expect, there is a corresponding register_late_pass method available as well. Without a call to one of register_early_pass or register_late_pass, the lint pass in question will not be run. One reason that cargo dev update_lints does not automate this step is that multiple lints can use the same lint pass, so registering the lint pass may already be done when adding a new lint. Another reason that this step is not automated is that the order that the passes are registered determines the order the passes actually run, which in turn affects the order that any emitted lints are output in.","breadcrumbs":"Development » Adding Lints » Lint registration","id":"41","title":"Lint registration"},"42":{"body":"Writing a lint that only checks for the name of a function means that we only have to deal with the AST and don't have to deal with the type system at all. This is good, because it makes writing this particular lint less complicated. We have to make this decision with every new Clippy lint. It boils down to using either EarlyLintPass or LateLintPass . In short, the LateLintPass has access to type information while the EarlyLintPass doesn't. If you don't need access to type information, use the EarlyLintPass. The EarlyLintPass is also faster. However, linting speed hasn't really been a concern with Clippy so far. Since we don't need type information for checking the function name, we used --pass=early when running the new lint automation and all the imports were added accordingly.","breadcrumbs":"Development » Adding Lints » Lint passes","id":"42","title":"Lint passes"},"43":{"body":"With UI tests and the lint declaration in place, we can start working on the implementation of the lint logic. Let's start by implementing the EarlyLintPass for our FooFunctions: impl EarlyLintPass for FooFunctions { fn check_fn(&mut self, cx: &EarlyContext<'_>, fn_kind: FnKind<'_>, span: Span, _: NodeId) { // TODO: Emit lint here }\n} We implement the check_fn method from the EarlyLintPass trait. This gives us access to various information about the function that is currently being checked. More on that in the next section. Let's worry about the details later and emit our lint for every function definition first. Depending on how complex we want our lint message to be, we can choose from a variety of lint emission functions. They can all be found in clippy_utils/src/diagnostics.rs . span_lint_and_help seems most appropriate in this case. It allows us to provide an extra help message, and we can't really suggest a better name automatically. This is how it looks: impl EarlyLintPass for FooFunctions { fn check_fn(&mut self, cx: &EarlyContext<'_>, fn_kind: FnKind<'_>, span: Span, _: NodeId) { span_lint_and_help( cx, FOO_FUNCTIONS, span, \"function named `foo`\", None, \"consider using a more meaningful name\" ); }\n} Running our UI test should now produce output that contains the lint message. According to the rustc-dev-guide , the text should be matter of fact and avoid capitalization and periods, unless multiple sentences are needed. When code or an identifier must appear in a message or label, it should be surrounded with single grave accents `.","breadcrumbs":"Development » Adding Lints » Emitting a lint","id":"43","title":"Emitting a lint"},"44":{"body":"Writing the logic for your lint will most likely be different from our example, so this section is kept rather short. Using the check_fn method gives us access to FnKind that has the FnKind::Fn variant. It provides access to the name of the function/method via an Ident . With that we can expand our check_fn method to: impl EarlyLintPass for FooFunctions { fn check_fn(&mut self, cx: &EarlyContext<'_>, fn_kind: FnKind<'_>, span: Span, _: NodeId) { if is_foo_fn(fn_kind) { span_lint_and_help( cx, FOO_FUNCTIONS, span, \"function named `foo`\", None, \"consider using a more meaningful name\" ); } }\n} We separate the lint conditional from the lint emissions because it makes the code a bit easier to read. In some cases this separation would also allow to write some unit tests (as opposed to only UI tests) for the separate function. In our example, is_foo_fn looks like: // use statements, impl EarlyLintPass, check_fn, .. fn is_foo_fn(fn_kind: FnKind<'_>) -> bool { match fn_kind { FnKind::Fn(_, ident, ..) => { // check if `fn` name is `foo` ident.name.as_str() == \"foo\" } // ignore closures FnKind::Closure(..) => false }\n} Now we should also run the full test suite with cargo test. At this point running cargo test should produce the expected output. Remember to run cargo dev bless to update the .stderr file. cargo test (as opposed to cargo uitest) will also ensure that our lint implementation is not violating any Clippy lints itself. That should be it for the lint implementation. Running cargo test should now pass.","breadcrumbs":"Development » Adding Lints » Adding the lint logic","id":"44","title":"Adding the lint logic"},"45":{"body":"Sometimes a lint makes suggestions that require a certain version of Rust. For example, the manual_strip lint suggests using str::strip_prefix and str::strip_suffix which is only available after Rust 1.45. In such cases, you need to ensure that the MSRV configured for the project is >= the MSRV of the required Rust feature. If multiple features are required, just use the one with a lower MSRV. First, add an MSRV alias for the required feature in clippy_utils::msrvs . This can be accessed later as msrvs::STR_STRIP_PREFIX, for example. msrv_aliases! { .. 1,45,0 { STR_STRIP_PREFIX }\n} In order to access the project-configured MSRV, you need to have an msrv field in the LintPass struct, and a constructor to initialize the field. The msrv value is passed to the constructor in clippy_lints/lib.rs. pub struct ManualStrip { msrv: Msrv,\n} impl ManualStrip { #[must_use] pub fn new(msrv: Msrv) -> Self { Self { msrv } }\n} The project's MSRV can then be matched against the feature MSRV in the LintPass using the Msrv::meets method. if !self.msrv.meets(msrvs::STR_STRIP_PREFIX) { return;\n} The project's MSRV can also be specified as an attribute, which overrides the value from clippy.toml. This can be accounted for using the extract_msrv_attr!(LintContext) macro and passing LateContext/EarlyContext. impl<'tcx> LateLintPass<'tcx> for ManualStrip { fn check_expr(&mut self, cx: &LateContext<'tcx>, expr: &'tcx Expr<'_>) { ... } extract_msrv_attr!(LateContext);\n} Once the msrv is added to the lint, a relevant test case should be added to the lint's test file, tests/ui/manual_strip.rs in this example. It should have a case for the version below the MSRV and one with the same contents but for the MSRV version itself. ... #[clippy::msrv = \"1.44\"]\nfn msrv_1_44() { /* something that would trigger the lint */\n} #[clippy::msrv = \"1.45\"]\nfn msrv_1_45() { /* something that would trigger the lint */\n} As a last step, the lint should be added to the lint documentation. This is done in clippy_lints/src/utils/conf.rs: define_Conf! { /// Lint: LIST, OF, LINTS, <THE_NEWLY_ADDED_LINT>. The minimum rust version that the project supports (msrv: Option<String> = None), ...\n}","breadcrumbs":"Development » Adding Lints » Specifying the lint's minimum supported Rust version (MSRV)","id":"45","title":"Specifying the lint's minimum supported Rust version (MSRV)"},"46":{"body":"If you have trouble implementing your lint, there is also the internal author lint to generate Clippy code that detects the offending pattern. It does not work for all the Rust syntax, but can give a good starting point. The quickest way to use it, is the Rust playground: play.rust-lang.org . Put the code you want to lint into the editor and add the #[clippy::author] attribute above the item. Then run Clippy via Tools -> Clippy and you should see the generated code in the output below. Here is an example on the playground. If the command was executed successfully, you can copy the code over to where you are implementing your lint.","breadcrumbs":"Development » Adding Lints » Author lint","id":"46","title":"Author lint"},"47":{"body":"To implement a lint, it's helpful to first understand the internal representation that rustc uses. Clippy has the #[clippy::dump] attribute that prints the High-Level Intermediate Representation (HIR) of the item, statement, or expression that the attribute is attached to. To attach the attribute to expressions you often need to enable #![feature(stmt_expr_attributes)]. Here you can find an example, just select Tools and run Clippy .","breadcrumbs":"Development » Adding Lints » Print HIR lint","id":"47","title":"Print HIR lint"},"48":{"body":"The final thing before submitting our PR is to add some documentation to our lint declaration. Please document your lint with a doc comment akin to the following: declare_clippy_lint! { /// ### What it does /// Checks for ... (describe what the lint matches). /// /// ### Why is this bad? /// Supply the reason for linting the code. /// /// ### Example /// /// ```rust,ignore /// // A short example of code that triggers the lint /// ``` /// /// Use instead: /// ```rust,ignore /// // A short example of improved code that doesn't trigger the lint /// ``` #[clippy::version = \"1.29.0\"] pub FOO_FUNCTIONS, pedantic, \"function named `foo`, which is not a descriptive name\"\n} Once your lint is merged, this documentation will show up in the lint list .","breadcrumbs":"Development » Adding Lints » Documentation","id":"48","title":"Documentation"},"49":{"body":"Rustfmt is a tool for formatting Rust code according to style guidelines. Your code has to be formatted by rustfmt before a PR can be merged. Clippy uses nightly rustfmt in the CI. It can be installed via rustup: rustup component add rustfmt --toolchain=nightly Use cargo dev fmt to format the whole codebase. Make sure that rustfmt is installed for the nightly toolchain.","breadcrumbs":"Development » Adding Lints » Running rustfmt","id":"49","title":"Running rustfmt"},"5":{"body":"The easiest and most common way to run Clippy is through cargo. To do that, just run cargo clippy Lint configuration The above command will run the default set of lints, which are included in the lint group clippy::all. You might want to use even more lints, or you may not agree with every Clippy lint, and for that there are ways to configure lint levels. Note: Clippy is meant to be used with a generous sprinkling of #[allow(..)]s through your code. So if you disagree with a lint, don't feel bad disabling them for parts of your code or the whole project. Command line You can configure lint levels on the command line by adding -A/W/D clippy::lint_name like this: cargo clippy -- -Aclippy::style -Wclippy::double_neg -Dclippy::perf For CI all warnings can be elevated to errors which will inturn fail the build and cause Clippy to exit with a code other than 0. cargo clippy -- -Dwarnings Note: Adding -D warnings will cause your build to fail if any warnings are found in your code. That includes warnings found by rustc (e.g. dead_code, etc.). For more information on configuring lint levels, see the rustc documentation . Even more lints Clippy has lint groups which are allow-by-default. This means, that you will have to enable the lints in those groups manually. For a full list of all lints with their description and examples, please refer to Clippy's lint list . The two most important allow-by-default groups are described below: clippy::pedantic The first group is the pedantic group. This group contains really opinionated lints, that may have some intentional false positives in order to prevent false negatives. So while this group is ready to be used in production, you can expect to sprinkle multiple #[allow(..)]s in your code. If you find any false positives, you're still welcome to report them to us for future improvements. FYI: Clippy uses the whole group to lint itself. clippy::restriction The second group is the restriction group. This group contains lints that \"restrict\" the language in some way. For example the clippy::unwrap lint from this group won't allow you to use .unwrap() in your code. You may want to look through the lints in this group and enable the ones that fit your need. Note: You shouldn't enable the whole lint group, but cherry-pick lints from this group. Some lints in this group will even contradict other Clippy lints! Too many lints The most opinionated warn-by-default group of Clippy is the clippy::style group. Some people prefer to disable this group completely and then cherry-pick some lints they like from this group. The same is of course possible with every other of Clippy's lint groups. Note: We try to keep the warn-by-default groups free from false positives (FP). If you find that a lint wrongly triggers, please report it in an issue (if there isn't an issue for that FP already) Source Code You can configure lint levels in source code the same way you can configure rustc lints: #![allow(clippy::style)] #[warn(clippy::double_neg)]\nfn main() { let x = 1; let y = --x; // ^^ warning: double negation\n} Automatically applying Clippy suggestions Clippy can automatically apply some lint suggestions, just like the compiler. cargo clippy --fix Workspaces All the usual workspace options should work with Clippy. For example the following command will run Clippy on the example crate in your workspace: cargo clippy -p example As with cargo check, this includes dependencies that are members of the workspace, like path dependencies. If you want to run Clippy only on the given crate, use the --no-deps option like this: cargo clippy -p example -- --no-deps","breadcrumbs":"Usage » Cargo subcommand","id":"5","title":"Cargo subcommand"},"50":{"body":"If you want to debug parts of your lint implementation, you can use the dbg! macro anywhere in your code. Running the tests should then include the debug output in the stdout part.","breadcrumbs":"Development » Adding Lints » Debugging","id":"50","title":"Debugging"},"51":{"body":"Before submitting your PR make sure you followed all the basic requirements: [ ] Followed lint naming conventions [ ] Added passing UI tests (including committed .stderr file) [ ] cargo test passes locally [ ] Executed cargo dev update_lints [ ] Added lint documentation [ ] Run cargo dev fmt","breadcrumbs":"Development » Adding Lints » PR Checklist","id":"51","title":"PR Checklist"},"52":{"body":"Clippy supports the configuration of lints values using a clippy.toml file in the workspace directory. Adding a configuration to a lint can be useful for thresholds or to constrain some behavior that can be seen as a false positive for some users. Adding a configuration is done in the following steps: Adding a new configuration entry to clippy_lints::utils::conf like this: /// Lint: LINT_NAME.\n///\n/// <The configuration field doc comment>\n(configuration_ident: Type = DefaultValue), The doc comment is automatically added to the documentation of the listed lints. The default value will be formatted using the Debug implementation of the type. Adding the configuration value to the lint impl struct: This first requires the definition of a lint impl struct. Lint impl structs are usually generated with the declare_lint_pass! macro. This struct needs to be defined manually to add some kind of metadata to it: // Generated struct definition\ndeclare_lint_pass!(StructName => [ LINT_NAME\n]); // New manual definition struct\n#[derive(Copy, Clone)]\npub struct StructName {} impl_lint_pass!(StructName => [ LINT_NAME\n]); Next add the configuration value and a corresponding creation method like this: #[derive(Copy, Clone)]\npub struct StructName { configuration_ident: Type,\n} // ... impl StructName { pub fn new(configuration_ident: Type) -> Self { Self { configuration_ident, } }\n} Passing the configuration value to the lint impl struct: First find the struct construction in the clippy_lints lib file . The configuration value is now cloned or copied into a local value that is then passed to the impl struct like this: // Default generated registration:\nstore.register_*_pass(|| box module::StructName); // New registration with configuration value\nlet configuration_ident = conf.configuration_ident.clone();\nstore.register_*_pass(move || box module::StructName::new(configuration_ident)); Congratulations the work is almost done. The configuration value can now be accessed in the linting code via self.configuration_ident. Adding tests: The default configured value can be tested like any normal lint in tests/ui . The configuration itself will be tested separately in tests/ui-toml . Simply add a new subfolder with a fitting name. This folder contains a clippy.toml file with the configuration value and a rust file that should be linted by Clippy. The test can otherwise be written as usual. Update Lint Configuration Run cargo collect-metadata to generate documentation changes for the book.","breadcrumbs":"Development » Adding Lints » Adding configuration to a lint","id":"52","title":"Adding configuration to a lint"},"53":{"body":"Here are some pointers to things you are likely going to need for every lint: Clippy utils - Various helper functions. Maybe the function you need is already in here ( is_type_diagnostic_item , implements_trait , snippet , etc) Clippy diagnostics Let chains from_expansion and in_external_macro Span Applicability Common tools for writing lints helps with common operations The rustc-dev-guide explains a lot of internal compiler concepts The nightly rustc docs which has been linked to throughout this guide For EarlyLintPass lints: EarlyLintPass rustc_ast::ast For LateLintPass lints: LateLintPass Ty::TyKind While most of Clippy's lint utils are documented, most of rustc's internals lack documentation currently. This is unfortunate, but in most cases you can probably get away with copying things from existing similar lints. If you are stuck, don't hesitate to ask on Zulip or in the issue/PR.","breadcrumbs":"Development » Adding Lints » Cheat Sheet","id":"53","title":"Cheat Sheet"},"54":{"body":"When we work on a new lint or improve an existing lint, we might want to retrieve the type Ty of an expression Expr for a variety of reasons. This can be achieved by utilizing the LateContext that is available for LateLintPass .","breadcrumbs":"Development » Type Checking » Type Checking","id":"54","title":"Type Checking"},"55":{"body":"The lint context LateContext and TypeckResults (returned by LateContext::typeck_results) are the two most useful data structures in LateLintPass. They allow us to jump to type definitions and other compilation stages such as HIR. Note: LateContext.typeck_results's return value is TypeckResults and is created in the type checking step, it includes useful information such as types of expressions, ways to resolve methods and so on. TypeckResults contains useful methods such as expr_ty , which gives us access to the underlying structure Ty of a given expression. pub fn expr_ty(&self, expr: &Expr<'_>) -> Ty<'tcx> As a side note, besides expr_ty, TypeckResults contains a pat_ty() method that is useful for retrieving a type from a pattern.","breadcrumbs":"Development » Type Checking » LateContext and TypeckResults","id":"55","title":"LateContext and TypeckResults"},"56":{"body":"Ty struct contains the type information of an expression. Let's take a look at rustc_middle's Ty struct to examine this struct: pub struct Ty<'tcx>(Interned<'tcx, WithStableHash<TyS<'tcx>>>); At a first glance, this struct looks quite esoteric. But at a closer look, we will see that this struct contains many useful methods for type checking. For instance, is_char checks if the given Ty struct corresponds to the primitive character type. is_* Usage In some scenarios, all we need to do is check if the Ty of an expression is a specific type, such as char type, so we could write the following: impl LateLintPass<'_> for MyStructLint { fn check_expr(&mut self, cx: &LateContext<'_>, expr: &Expr<'_>) { // Get type of `expr` let ty = cx.typeck_results().expr_ty(expr); // Check if the `Ty` of this expression is of character type if ty.is_char() { println!(\"Our expression is a char!\"); } }\n} Furthermore, if we examine the source code for is_char, we find something very interesting: #[inline]\npub fn is_char(self) -> bool { matches!(self.kind(), Char)\n} Indeed, we just discovered Ty's kind method , which provides us with TyKind of a Ty.","breadcrumbs":"Development » Type Checking » Ty","id":"56","title":"Ty"},"57":{"body":"TyKind defines the kinds of types in Rust's type system. Peeking into TyKind documentation , we will see that it is an enum of 27 variants, including items such as Bool, Int, Ref, etc. kind Usage The TyKind of Ty can be returned by calling Ty.kind method . We often use this method to perform pattern matching in Clippy. For instance, if we want to check for a struct, we could examine if the ty.kind corresponds to an Adt (algebraic data type) and if its AdtDef is a struct: impl LateLintPass<'_> for MyStructLint { fn check_expr(&mut self, cx: &LateContext<'_>, expr: &Expr<'_>) { // Get type of `expr` let ty = cx.typeck_results().expr_ty(expr); // Match its kind to enter the type match ty.kind { ty::Adt(adt_def, _) if adt_def.is_struct() => println!(\"Our `expr` is a struct!\"), _ => () } }\n}","breadcrumbs":"Development » Type Checking » TyKind","id":"57","title":"TyKind"},"58":{"body":"We've been talking about ty::Ty this whole time without addressing hir::Ty , but the latter is also important to understand. hir::Ty would represent what an user wrote, while ty::Ty would understand the meaning of it (because it has more information). Example: fn foo(x: u32) -> u32 { x } Here the HIR sees the types without \"thinking\" about them, it knows that the function takes an u32 and returns an u32. But at the ty::Ty level the compiler understands that they're the same type, in-depth lifetimes, etc... you can use the hir_ty_to_ty function to convert from a hir::Ty to a ty::Ty","breadcrumbs":"Development » Type Checking » hir::Ty and ty::Ty","id":"58","title":"hir::Ty and ty::Ty"},"59":{"body":"Below are some useful links to further explore the concepts covered in this chapter: Stages of compilation Diagnostic items Type checking Ty module","breadcrumbs":"Development » Type Checking » Useful Links","id":"59","title":"Useful Links"},"6":{"body":"Clippy can also be used in projects that do not use cargo. To do so, run clippy-driver with the same arguments you use for rustc. For example: clippy-driver --edition 2018 -Cpanic=abort foo.rs Note: clippy-driver is designed for running Clippy and should not be used as a general replacement for rustc. clippy-driver may produce artifacts that are not optimized as expected, for example.","breadcrumbs":"Usage » Using Clippy without cargo: clippy-driver","id":"6","title":"Using Clippy without cargo: clippy-driver"},"60":{"body":"You may need following tooltips to catch up with common operations. Common tools for writing lints Retrieving the type of expression Checking if an expr is calling a specific method Checking for a specific type Checking if a type implements a specific trait Checking if a type defines a specific method Dealing with macros Useful Rustc dev guide links: Stages of compilation Diagnostic items Type checking Ty module","breadcrumbs":"Development » Common Tools » Common tools for writing lints","id":"60","title":"Common tools for writing lints"},"61":{"body":"Sometimes you may want to retrieve the type Ty of an expression Expr, for example to answer following questions: which type does this expression correspond to (using its TyKind )? is it a sized type? is it a primitive type? does it implement a trait? This operation is performed using the expr_ty() method from the TypeckResults struct, that gives you access to the underlying structure Ty . Example of use: impl LateLintPass<'_> for MyStructLint { fn check_expr(&mut self, cx: &LateContext<'_>, expr: &Expr<'_>) { // Get type of `expr` let ty = cx.typeck_results().expr_ty(expr); // Match its kind to enter its type match ty.kind { ty::Adt(adt_def, _) if adt_def.is_struct() => println!(\"Our `expr` is a struct!\"), _ => () } }\n} Similarly, in TypeckResults methods, you have the pat_ty() method to retrieve a type from a pattern. Two noticeable items here: cx is the lint context LateContext . The two most useful data structures in this context are tcx and the TypeckResults returned by LateContext::typeck_results, allowing us to jump to type definitions and other compilation stages such as HIR. typeck_results's return value is TypeckResults and is created by type checking step, it includes useful information such as types of expressions, ways to resolve methods and so on.","breadcrumbs":"Development » Common Tools » Retrieving the type of expression","id":"61","title":"Retrieving the type of expression"},"62":{"body":"Starting with an expr, you can check whether it is calling a specific method some_method: impl<'tcx> LateLintPass<'tcx> for MyStructLint { fn check_expr(&mut self, cx: &LateContext<'tcx>, expr: &'tcx hir::Expr<'_>) { // Check our expr is calling a method if let hir::ExprKind::MethodCall(path, _, _self_arg, ..) = &expr.kind // Check the name of this method is `some_method` && path.ident.name == sym!(some_method) // Optionally, check the type of the self argument. // - See \"Checking for a specific type\" { // ... } }\n}","breadcrumbs":"Development » Common Tools » Checking if an expr is calling a specific method","id":"62","title":"Checking if an expr is calling a specific method"},"63":{"body":"There are three ways to check if an expression type is a specific type we want to check for. All of these methods only check for the base type, generic arguments have to be checked separately. use clippy_utils::ty::{is_type_diagnostic_item, is_type_lang_item};\nuse clippy_utils::{paths, match_def_path};\nuse rustc_span::symbol::sym;\nuse rustc_hir::LangItem; impl LateLintPass<'_> for MyStructLint { fn check_expr(&mut self, cx: &LateContext<'_>, expr: &Expr<'_>) { // Getting the expression type let ty = cx.typeck_results().expr_ty(expr); // 1. Using diagnostic items // The last argument is the diagnostic item to check for if is_type_diagnostic_item(cx, ty, sym::Option) { // The type is an `Option` } // 2. Using lang items if is_type_lang_item(cx, ty, LangItem::RangeFull) { // The type is a full range like `.drain(..)` } // 3. Using the type path // This method should be avoided if possible if match_def_path(cx, def_id, &paths::RESULT) { // The type is a `core::result::Result` } }\n} Prefer using diagnostic items and lang items where possible.","breadcrumbs":"Development » Common Tools » Checking for a specific type","id":"63","title":"Checking for a specific type"},"64":{"body":"There are three ways to do this, depending on if the target trait has a diagnostic item, lang item or neither. use clippy_utils::ty::implements_trait;\nuse clippy_utils::is_trait_method;\nuse rustc_span::symbol::sym; impl LateLintPass<'_> for MyStructLint { fn check_expr(&mut self, cx: &LateContext<'_>, expr: &Expr<'_>) { // 1. Using diagnostic items with the expression // we use `is_trait_method` function from Clippy's utils if is_trait_method(cx, expr, sym::Iterator) { // method call in `expr` belongs to `Iterator` trait } // 2. Using lang items with the expression type let ty = cx.typeck_results().expr_ty(expr); if cx.tcx.lang_items() // we are looking for the `DefId` of `Drop` trait in lang items .drop_trait() // then we use it with our type `ty` by calling `implements_trait` from Clippy's utils .map_or(false, |id| implements_trait(cx, ty, id, &[])) { // `expr` implements `Drop` trait } }\n} Prefer using diagnostic and lang items, if the target trait has one. We access lang items through the type context tcx. tcx is of type TyCtxt and is defined in the rustc_middle crate. A list of defined paths for Clippy can be found in paths.rs","breadcrumbs":"Development » Common Tools » Checking if a type implements a specific trait","id":"64","title":"Checking if a type implements a specific trait"},"65":{"body":"To check if our type defines a method called some_method: use clippy_utils::ty::is_type_diagnostic_item;\nuse clippy_utils::return_ty; impl<'tcx> LateLintPass<'tcx> for MyTypeImpl { fn check_impl_item(&mut self, cx: &LateContext<'tcx>, impl_item: &'tcx ImplItem<'_>) { // Check if item is a method/function if let ImplItemKind::Fn(ref signature, _) = impl_item.kind // Check the method is named `some_method` && impl_item.ident.name == sym!(some_method) // We can also check it has a parameter `self` && signature.decl.implicit_self.has_implicit_self() // We can go further and even check if its return type is `String` && is_type_diagnostic_item(cx, return_ty(cx, impl_item.hir_id), sym!(string_type)) { // ... } }\n}","breadcrumbs":"Development » Common Tools » Checking if a type defines a specific method","id":"65","title":"Checking if a type defines a specific method"},"66":{"body":"Keep in mind that macros are already expanded and desugaring is already applied to the code representation that you are working with in Clippy. This unfortunately causes a lot of false positives because macro expansions are \"invisible\" unless you actively check for them. Generally speaking, code with macro expansions should just be ignored by Clippy because that code can be dynamic in ways that are difficult or impossible to see. Use the following functions to deal with macros: span.from_expansion(): detects if a span is from macro expansion or desugaring. Checking this is a common first step in a lint. if expr.span.from_expansion() { // just forget it return;\n} span.ctxt(): the span's context represents whether it is from expansion, and if so, which macro call expanded it. It is sometimes useful to check if the context of two spans are equal. // expands to `1 + 0`, but don't lint\n1 + mac!() if left.span.ctxt() != right.span.ctxt() { // the coder most likely cannot modify this expression return;\n} Note: Code that is not from expansion is in the \"root\" context. So any spans where from_expansion returns true can be assumed to have the same context. And so just using span.from_expansion() is often good enough. in_external_macro(span): detect if the given span is from a macro defined in a foreign crate. If you want the lint to work with macro-generated code, this is the next line of defense to avoid macros not defined in the current crate. It doesn't make sense to lint code that the coder can't change. You may want to use it for example to not start linting in macros from other crates use rustc_middle::lint::in_external_macro; use a_crate_with_macros::foo; // `foo` is defined in `a_crate_with_macros`\nfoo!(\"bar\"); // if we lint the `match` of `foo` call and test its span\nassert_eq!(in_external_macro(cx.sess(), match_span), true); span.ctxt(): the span's context represents whether it is from expansion, and if so, what expanded it One thing SpanContext is useful for is to check if two spans are in the same context. For example, in a == b, a and b have the same context. In a macro_rules! with a == $b, $b is expanded to some expression with a different context from a. macro_rules! m { ($a:expr, $b:expr) => { if $a.is_some() { $b; } }\n} let x: Option<u32> = Some(42);\nm!(x, x.unwrap()); // These spans are not from the same context\n// x.is_some() is from inside the macro\n// x.unwrap() is from outside the macro\nassert_eq!(x_is_some_span.ctxt(), x_unwrap_span.ctxt());","breadcrumbs":"Development » Common Tools » Dealing with macros and expansions","id":"66","title":"Dealing with macros and expansions"},"67":{"body":"In order to deploy Clippy over rustup, some infrastructure is necessary. This chapter describes the different parts of the Clippy infrastructure that need to be maintained to make this possible. The most important part is the sync between the rust-lang/rust repository and the Clippy repository that takes place every two weeks. This process is described in the Syncing changes between Clippy and rust-lang/rust section. A new Clippy release is done together with every Rust release, so every six weeks. The release process is described in the Release a new Clippy Version section. During a release cycle a changelog entry for the next release has to be written. The format of that and how to do that is documented in the Changelog Update section. Note: The Clippy CI should also be described in this chapter, but for now is left as a TODO.","breadcrumbs":"Development » Infrastructure » Infrastructure","id":"67","title":"Infrastructure"},"68":{"body":"Clippy currently gets built with a pinned nightly version. In the rust-lang/rust repository, where rustc resides, there's a copy of Clippy that compiler hackers modify from time to time to adapt to changes in the unstable API of the compiler. We need to sync these changes back to this repository periodically, and the changes made to this repository in the meantime also need to be synced to the rust-lang/rust repository. To avoid flooding the rust-lang/rust PR queue, this two-way sync process is done in a bi-weekly basis if there's no urgent changes. This is done starting on the day of the Rust stable release and then every other week. That way we guarantee that we keep this repo up to date with the latest compiler API, and every feature in Clippy is available for 2 weeks in nightly, before it can get to beta. For reference, the first sync following this cadence was performed the 2020-08-27. This process is described in detail in the following sections. For general information about subtrees in the Rust repository see the rustc-dev-guide .","breadcrumbs":"Development » Infrastructure » Syncing changes between Clippy and rust-lang/rust » Syncing changes between Clippy and rust-lang/rust","id":"68","title":"Syncing changes between Clippy and rust-lang/rust"},"69":{"body":"Currently, there's a bug in git-subtree that prevents it from working properly with the rust-lang/rust repo. There's an open PR to fix that, but it's stale. Before continuing with the following steps, we need to manually apply that fix to our local copy of git-subtree. You can get the patched version of git-subtree from here . Put this file under /usr/lib/git-core (making a backup of the previous file) and make sure it has the proper permissions: sudo cp --backup /path/to/patched/git-subtree.sh /usr/lib/git-core/git-subtree\nsudo chmod --reference=/usr/lib/git-core/git-subtree~ /usr/lib/git-core/git-subtree\nsudo chown --reference=/usr/lib/git-core/git-subtree~ /usr/lib/git-core/git-subtree Note: The first time running git subtree push a cache has to be built. This involves going through the complete Clippy history once. For this you have to increase the stack limit though, which you can do with ulimit -s 60000. Make sure to run the ulimit command from the same session you call git subtree. Note: If you are a Debian user, dash is the shell used by default for scripts instead of sh. This shell has a hardcoded recursion limit set to 1,000. In order to make this process work, you need to force the script to run bash instead. You can do this by editing the first line of the git-subtree script and changing sh to bash.","breadcrumbs":"Development » Infrastructure » Syncing changes between Clippy and rust-lang/rust » Patching git-subtree to work with big repos","id":"69","title":"Patching git-subtree to work with big repos"},"7":{"body":"Note: The configuration file is unstable and may be deprecated in the future. Some lints can be configured in a TOML file named clippy.toml or .clippy.toml. It contains a basic variable = value mapping e.g. avoid-breaking-exported-api = false\ndisallowed-names = [\"toto\", \"tata\", \"titi\"] The table of configurations contains all config values, their default, and a list of lints they affect. Each configurable lint , also contains information about these values. For configurations that are a list type with default values such as disallowed-names , you can use the unique value \"..\" to extend the default values instead of replacing them. # default of disallowed-names is [\"foo\", \"baz\", \"quux\"]\ndisallowed-names = [\"bar\", \"..\"] # -> [\"bar\", \"foo\", \"baz\", \"quux\"] To deactivate the \"for further information visit lint-link \" message you can define the CLIPPY_DISABLE_DOCS_LINKS environment variable. Allowing/denying lints You can add options to your code to allow/warn/deny Clippy lints: the whole set of Warn lints using the clippy lint group (#![deny(clippy::all)]) all lints using both the clippy and clippy::pedantic lint groups (#![deny(clippy::all)], #![deny(clippy::pedantic)]). Note that clippy::pedantic contains some very aggressive lints prone to false positives. only some lints (#![deny(clippy::single_match, clippy::box_vec)], etc.) allow/warn/deny can be limited to a single function or module using #[allow(...)], etc. Note: allow means to suppress the lint for your code. With warn the lint will only emit a warning, while with deny the lint will emit an error, when triggering for your code. An error causes clippy to exit with an error code, so is useful in scripts like CI/CD. If you do not want to include your lint levels in your code, you can globally enable/disable lints by passing extra flags to Clippy during the run: To allow lint_name, run cargo clippy -- -A clippy::lint_name And to warn on lint_name, run cargo clippy -- -W clippy::lint_name This also works with lint groups. For example, you can run Clippy with warnings for all lints enabled: cargo clippy -- -W clippy::pedantic If you care only about a single lint, you can allow all others and then explicitly warn on the lint(s) you are interested in: cargo clippy -- -A clippy::all -W clippy::useless_format -W clippy::... Specifying the minimum supported Rust version Projects that intend to support old versions of Rust can disable lints pertaining to newer features by specifying the minimum supported Rust version (MSRV) in the clippy configuration file. msrv = \"1.30.0\" The MSRV can also be specified as an attribute, like below. #![feature(custom_inner_attributes)]\n#![clippy::msrv = \"1.30.0\"] fn main() { ...\n} You can also omit the patch version when specifying the MSRV, so msrv = 1.30 is equivalent to msrv = 1.30.0. Note: custom_inner_attributes is an unstable feature, so it has to be enabled explicitly. Lints that recognize this configuration option can be found here Disabling evaluation of certain code Note: This should only be used in cases where other solutions, like #[allow(clippy::all)], are not sufficient. Very rarely, you may wish to prevent Clippy from evaluating certain sections of code entirely. You can do this with conditional compilation by checking that the cargo-clippy feature is not set. You may need to provide a stub so that the code compiles: #[cfg(not(feature = \"cargo-clippy\"))]\ninclude!(concat!(env!(\"OUT_DIR\"), \"/my_big_function-generated.rs\")); #[cfg(feature = \"cargo-clippy\")]\nfn my_big_function(_input: &str) -> Option<MyStruct> { None\n} This feature is not actually part of your crate, so specifying --all-features to other tools, e.g. cargo test --all-features, will not disable it.","breadcrumbs":"Configuration » Configuring Clippy","id":"7","title":"Configuring Clippy"},"70":{"body":"You may want to define remotes, so you don't have to type out the remote addresses on every sync. You can do this with the following commands (these commands still have to be run inside the rust directory): # Set clippy-upstream remote for pulls\n$ git remote add clippy-upstream https://github.com/rust-lang/rust-clippy\n# Make sure to not push to the upstream repo\n$ git remote set-url --push clippy-upstream DISABLED\n# Set a local remote\n$ git remote add clippy-local /path/to/rust-clippy Note: The following sections assume that you have set those remotes with the above remote names.","breadcrumbs":"Development » Infrastructure » Syncing changes between Clippy and rust-lang/rust » Defining remotes","id":"70","title":"Defining remotes"},"71":{"body":"Here is a TL;DR version of the sync process (all the following commands have to be run inside the rust directory): Clone the rust-lang/rust repository or make sure it is up-to-date. Checkout the commit from the latest available nightly. You can get it using rustup check. Sync the changes to the rust-copy of Clippy to your Clippy fork: # Be sure to either use a net-new branch, e.g. `sync-from-rust`, or delete the branch beforehand\n# because changes cannot be fast forwarded and you have to run this command again.\ngit subtree push -P src/tools/clippy clippy-local sync-from-rust Note: Most of the time you have to create a merge commit in the rust-clippy repo (this has to be done in the Clippy repo, not in the rust-copy of Clippy): git fetch upstream # assuming upstream is the rust-lang/rust remote\ngit checkout sync-from-rust\ngit merge upstream/master --no-ff Note: This is one of the few instances where a merge commit is allowed in a PR. Bump the nightly version in the Clippy repository by changing the date in the rust-toolchain file to the current date and committing it with the message: git commit -m \"Bump nightly version -> YYYY-MM-DD\" Open a PR to rust-lang/rust-clippy and wait for it to get merged (to accelerate the process ping the @rust-lang/clippy team in your PR and/or ask them in the Zulip stream.)","breadcrumbs":"Development » Infrastructure » Syncing changes between Clippy and rust-lang/rust » Performing the sync from rust-lang/rust to Clippy","id":"71","title":"Performing the sync from rust-lang/rust to Clippy"},"72":{"body":"All the following commands have to be run inside the rust directory. Make sure you have checked out the latest master of rust-lang/rust. Sync the rust-lang/rust-clippy master to the rust-copy of Clippy: git checkout -b sync-from-clippy\ngit subtree pull -P src/tools/clippy clippy-upstream master Open a PR to rust-lang/rust","breadcrumbs":"Development » Infrastructure » Syncing changes between Clippy and rust-lang/rust » Performing the sync from Clippy to rust-lang/rust","id":"72","title":"Performing the sync from Clippy to rust-lang/rust"},"73":{"body":"Sometimes it is necessary to backport changes to the beta release of Clippy. Backports in Clippy are rare and should be approved by the Clippy team. For example, a backport is done, if a crucial ICE was fixed or a lint is broken to a point, that it has to be disabled, before landing on stable. Backports are done to the beta branch of Clippy. Backports to stable Clippy releases basically don't exist, since this would require a Rust point release, which is almost never justifiable for a Clippy fix.","breadcrumbs":"Development » Infrastructure » Backporting Changes » Backport Changes","id":"73","title":"Backport Changes"},"74":{"body":"Backports are done on the beta branch of the Clippy repository. # Assuming the current directory corresponds to the Clippy repository\n$ git checkout beta\n$ git checkout -b backport\n$ git cherry-pick <SHA> # `<SHA>` is the commit hash of the commit(s), that should be backported\n$ git push origin backport Now you should test that the backport passes all the tests in the Rust repository. You can do this with: # Assuming the current directory corresponds to the Rust repository\n$ git checkout beta\n# Make sure to change `your-github-name` to your github name in the following command\n$ git subtree pull -p src/tools/clippy https://github.com/<your-github-name>/rust-clippy backport\n$ ./x.py test src/tools/clippy Should the test fail, you can fix Clippy directly in the Rust repository. This has to be first applied to the Clippy beta branch and then again synced to the Rust repository, though. The easiest way to do this is: # In the Rust repository\n$ git diff --patch --relative=src/tools/clippy > clippy.patch\n# In the Clippy repository\n$ git apply /path/to/clippy.patch\n$ git add -u\n$ git commit -m \"Fix rustup fallout\"\n$ git push origin backport After this, you can open a PR to the beta branch of the Clippy repository.","breadcrumbs":"Development » Infrastructure » Backporting Changes » Backport the changes","id":"74","title":"Backport the changes"},"75":{"body":"This step must be done, after the PR of the previous step was merged. After the backport landed in the Clippy repository, the branch has to be synced back to the beta branch of the Rust repository. # Assuming the current directory corresponds to the Rust repository\n$ git checkout beta\n$ git checkout -b clippy_backport\n$ git subtree pull -p src/tools/clippy https://github.com/rust-lang/rust-clippy beta\n$ git push origin clippy_backport Make sure to test the backport in the Rust repository before opening a PR. This is done with ./x.py test src/tools/clippy. If that passes all tests, open a PR to the beta branch of the Rust repository. In this PR you should tag the Clippy team member, that agreed to the backport or the @rust-lang/clippy team. Make sure to add [beta] to the title of the PR.","breadcrumbs":"Development » Infrastructure » Backporting Changes » Update Clippy in the Rust Repository","id":"75","title":"Update Clippy in the Rust Repository"},"76":{"body":"If you want to help with updating the changelog , you're in the right place.","breadcrumbs":"Development » Infrastructure » Updating the Changelog » Changelog Update","id":"76","title":"Changelog Update"},"77":{"body":"Typos and other small fixes/additions are always welcome. Special care needs to be taken when it comes to updating the changelog for a new Rust release. For that purpose, the changelog is ideally updated during the week before an upcoming stable release. You can find the release dates on the Rust Forge . Most of the time we only need to update the changelog for minor Rust releases. It's been very rare that Clippy changes were included in a patch release.","breadcrumbs":"Development » Infrastructure » Updating the Changelog » When to update","id":"77","title":"When to update"},"78":{"body":"1. Finding the relevant Clippy commits Each Rust release ships with its own version of Clippy. The Clippy subtree can be found in the tools directory of the Rust repository. Depending on the current time and what exactly you want to update, the following bullet points might be helpful: When writing the release notes for the upcoming stable release you need to check out the Clippy commit of the current Rust beta branch. Link When writing the release notes for the upcoming beta release , you need to check out the Clippy commit of the current Rust master. Link When writing the (forgotten) release notes for a past stable release , you need to check out the Rust release tag of the stable release. Link Usually you want to write the changelog of the upcoming stable release . Make sure though, that beta was already branched in the Rust repository. To find the commit hash, issue the following command when in a rust-lang/rust checkout: git log --oneline -- src/tools/clippy/ | grep -o \"Merge commit '[a-f0-9]*' into .*\" | head -1 | sed -e \"s/Merge commit '\\([a-f0-9]*\\)' into .*/\\1/g\" 2. Fetching the PRs between those commits Once you've got the correct commit range, run util/fetch_prs_between.sh commit1 commit2 > changes.txt and open that file in your editor of choice. When updating the changelog it's also a good idea to make sure that commit1 is already correct in the current changelog. 3. Authoring the final changelog The above script should have dumped all the relevant PRs to the file you specified. It should have filtered out most of the irrelevant PRs already, but it's a good idea to do a manual cleanup pass where you look for more irrelevant PRs. If you're not sure about some PRs, just leave them in for the review and ask for feedback. With the PRs filtered, you can start to take each PR and move the changelog: content to CHANGELOG.md. Adapt the wording as you see fit but try to keep it somewhat coherent. The order should roughly be: New lints Moves or deprecations of lints Changes that expand what code existing lints cover False positive fixes Suggestion fixes/improvements ICE fixes Documentation improvements Others As section headers, we use: ### New Lints\n### Moves and Deprecations\n### Enhancements\n### False Positive Fixes\n### Suggestion Fixes/Improvements\n### ICE Fixes\n### Documentation Improvements\n### Others Please also be sure to update the Beta/Unreleased sections at the top with the relevant commit ranges. 3.1 Include beta-accepted PRs Look for the beta-accepted label and make sure to also include the PRs with that label in the changelog. If you can, remove the beta-accepted labels after the changelog PR was merged. Note: Some of those PRs might even get backported to the previous beta. Those have to be included in the changelog of the previous release. 4. Update clippy::version attributes Next, make sure to check that the #[clippy::version] attributes for the added lints contain the correct version.","breadcrumbs":"Development » Infrastructure » Updating the Changelog » Changelog update walkthrough","id":"78","title":"Changelog update walkthrough"},"79":{"body":"NOTE: This document is probably only relevant to you, if you're a member of the Clippy team. Clippy is released together with stable Rust releases. The dates for these releases can be found at the Rust Forge . This document explains the necessary steps to create a Clippy release. Remerge the beta branch Update the beta branch Find the Clippy commit Tag the stable commit Update CHANGELOG.md NOTE: This document is for stable Rust releases, not for point releases. For point releases, step 1. and 2. should be enough.","breadcrumbs":"Development » Infrastructure » Release a New Version » Release a new Clippy Version","id":"79","title":"Release a new Clippy Version"},"8":{"body":"Option Default Value arithmetic-side-effects-allowed {} arithmetic-side-effects-allowed-binary [] arithmetic-side-effects-allowed-unary {} avoid-breaking-exported-api true msrv None cognitive-complexity-threshold 25 disallowed-names [\"foo\", \"baz\", \"quux\"] doc-valid-idents [\"KiB\", \"MiB\", \"GiB\", \"TiB\", \"PiB\", \"EiB\", \"DirectX\", \"ECMAScript\", \"GPLv2\", \"GPLv3\", \"GitHub\", \"GitLab\", \"IPv4\", \"IPv6\", \"ClojureScript\", \"CoffeeScript\", \"JavaScript\", \"PureScript\", \"TypeScript\", \"NaN\", \"NaNs\", \"OAuth\", \"GraphQL\", \"OCaml\", \"OpenGL\", \"OpenMP\", \"OpenSSH\", \"OpenSSL\", \"OpenStreetMap\", \"OpenDNS\", \"WebGL\", \"TensorFlow\", \"TrueType\", \"iOS\", \"macOS\", \"FreeBSD\", \"TeX\", \"LaTeX\", \"BibTeX\", \"BibLaTeX\", \"MinGW\", \"CamelCase\"] too-many-arguments-threshold 7 type-complexity-threshold 250 single-char-binding-names-threshold 4 too-large-for-stack 200 enum-variant-name-threshold 3 enum-variant-size-threshold 200 verbose-bit-mask-threshold 1 literal-representation-threshold 16384 trivial-copy-size-limit None pass-by-value-size-limit 256 too-many-lines-threshold 100 array-size-threshold 512000 vec-box-size-threshold 4096 max-trait-bounds 3 max-struct-bools 3 max-fn-params-bools 3 warn-on-all-wildcard-imports false disallowed-macros [] disallowed-methods [] disallowed-types [] unreadable-literal-lint-fractions true upper-case-acronyms-aggressive false matches-for-let-else WellKnownTypes cargo-ignore-publish false standard-macro-braces [] enforced-import-renames [] allowed-scripts [\"Latin\"] enable-raw-pointer-heuristic-for-send true max-suggested-slice-pattern-length 3 await-holding-invalid-types [] max-include-file-size 1000000 allow-expect-in-tests false allow-unwrap-in-tests false allow-dbg-in-tests false allow-print-in-tests false large-error-threshold 128 ignore-interior-mutability [\"bytes::Bytes\"] allow-mixed-uninlined-format-args true suppress-restriction-lint-in-const false missing-docs-in-crate-items false future-size-threshold 16384 arithmetic-side-effects-allowed Suppress checking of the passed type names in all types of operations. If a specific operation is desired, consider using arithmetic_side_effects_allowed_binary or arithmetic_side_effects_allowed_unary instead. Example arithmetic-side-effects-allowed = [\"SomeType\", \"AnotherType\"] Noteworthy A type, say SomeType, listed in this configuration has the same behavior of [\"SomeType\" , \"*\"], [\"*\", \"SomeType\"] in arithmetic_side_effects_allowed_binary. Default Value: {} (rustc_data_structures::fx::FxHashSet<String>) arithmetic_side_effects arithmetic-side-effects-allowed-binary Suppress checking of the passed type pair names in binary operations like addition or multiplication. Supports the \"*\" wildcard to indicate that a certain type won't trigger the lint regardless of the involved counterpart. For example, [\"SomeType\", \"*\"] or [\"*\", \"AnotherType\"]. Pairs are asymmetric, which means that [\"SomeType\", \"AnotherType\"] is not the same as [\"AnotherType\", \"SomeType\"]. Example arithmetic-side-effects-allowed-binary = [[\"SomeType\" , \"f32\"], [\"AnotherType\", \"*\"]] Default Value: [] (Vec<[String; 2]>) arithmetic_side_effects arithmetic-side-effects-allowed-unary Suppress checking of the passed type names in unary operations like \"negation\" (-). Example arithmetic-side-effects-allowed-unary = [\"SomeType\", \"AnotherType\"] Default Value: {} (rustc_data_structures::fx::FxHashSet<String>) arithmetic_side_effects avoid-breaking-exported-api Suppress lints whenever the suggested change would cause breakage for other crates. Default Value: true (bool) enum_variant_names large_types_passed_by_value trivially_copy_pass_by_ref unnecessary_wraps unused_self upper_case_acronyms wrong_self_convention box_collection redundant_allocation rc_buffer vec_box option_option linkedlist rc_mutex unnecessary_box_returns msrv The minimum rust version that the project supports Default Value: None (Option<String>) manual_split_once manual_str_repeat cloned_instead_of_copied redundant_field_names redundant_static_lifetimes filter_map_next checked_conversions manual_range_contains use_self mem_replace_with_default manual_non_exhaustive option_as_ref_deref map_unwrap_or match_like_matches_macro manual_strip missing_const_for_fn unnested_or_patterns from_over_into ptr_as_ptr if_then_some_else_none approx_constant deprecated_cfg_attr index_refutable_slice map_clone borrow_as_ptr manual_bits err_expect cast_abs_to_unsigned uninlined_format_args manual_clamp manual_let_else unchecked_duration_subtraction collapsible_str_replace seek_from_current seek_rewind unnecessary_lazy_evaluations transmute_ptr_to_ref almost_complete_range needless_borrow derivable_impls manual_is_ascii_check manual_rem_euclid manual_retain cognitive-complexity-threshold The maximum cognitive complexity a function can have Default Value: 25 (u64) cognitive_complexity disallowed-names The list of disallowed names to lint about. NB: bar is not here since it has legitimate uses. The value \"..\" can be used as part of the list to indicate, that the configured values should be appended to the default configuration of Clippy. By default, any configuration will replace the default value. Default Value: [\"foo\", \"baz\", \"quux\"] (Vec<String>) disallowed_names doc-valid-idents The list of words this lint should not consider as identifiers needing ticks. The value \"..\" can be used as part of the list to indicate, that the configured values should be appended to the default configuration of Clippy. By default, any configuration will replace the default value. For example: doc-valid-idents = [\"ClipPy\"] would replace the default list with [\"ClipPy\"]. doc-valid-idents = [\"ClipPy\", \"..\"] would append ClipPy to the default list. Default list: Default Value: [\"KiB\", \"MiB\", \"GiB\", \"TiB\", \"PiB\", \"EiB\", \"DirectX\", \"ECMAScript\", \"GPLv2\", \"GPLv3\", \"GitHub\", \"GitLab\", \"IPv4\", \"IPv6\", \"ClojureScript\", \"CoffeeScript\", \"JavaScript\", \"PureScript\", \"TypeScript\", \"NaN\", \"NaNs\", \"OAuth\", \"GraphQL\", \"OCaml\", \"OpenGL\", \"OpenMP\", \"OpenSSH\", \"OpenSSL\", \"OpenStreetMap\", \"OpenDNS\", \"WebGL\", \"TensorFlow\", \"TrueType\", \"iOS\", \"macOS\", \"FreeBSD\", \"TeX\", \"LaTeX\", \"BibTeX\", \"BibLaTeX\", \"MinGW\", \"CamelCase\"] (Vec<String>) doc_markdown too-many-arguments-threshold The maximum number of argument a function or method can have Default Value: 7 (u64) too_many_arguments type-complexity-threshold The maximum complexity a type can have Default Value: 250 (u64) type_complexity single-char-binding-names-threshold The maximum number of single char bindings a scope may have Default Value: 4 (u64) many_single_char_names too-large-for-stack The maximum size of objects (in bytes) that will be linted. Larger objects are ok on the heap Default Value: 200 (u64) boxed_local useless_vec enum-variant-name-threshold The minimum number of enum variants for the lints about variant names to trigger Default Value: 3 (u64) enum_variant_names enum-variant-size-threshold The maximum size of an enum's variant to avoid box suggestion Default Value: 200 (u64) large_enum_variant verbose-bit-mask-threshold The maximum allowed size of a bit mask before suggesting to use 'trailing_zeros' Default Value: 1 (u64) verbose_bit_mask literal-representation-threshold The lower bound for linting decimal literals Default Value: 16384 (u64) decimal_literal_representation trivial-copy-size-limit The maximum size (in bytes) to consider a Copy type for passing by value instead of by reference. Default Value: None (Option<u64>) trivially_copy_pass_by_ref pass-by-value-size-limit The minimum size (in bytes) to consider a type for passing by reference instead of by value. Default Value: 256 (u64) large_types_passed_by_value too-many-lines-threshold The maximum number of lines a function or method can have Default Value: 100 (u64) too_many_lines array-size-threshold The maximum allowed size for arrays on the stack Default Value: 512000 (u64) large_stack_arrays large_const_arrays vec-box-size-threshold The size of the boxed type in bytes, where boxing in a Vec is allowed Default Value: 4096 (u64) vec_box max-trait-bounds The maximum number of bounds a trait can have to be linted Default Value: 3 (u64) type_repetition_in_bounds max-struct-bools The maximum number of bool fields a struct can have Default Value: 3 (u64) struct_excessive_bools max-fn-params-bools The maximum number of bool parameters a function can have Default Value: 3 (u64) fn_params_excessive_bools warn-on-all-wildcard-imports Whether to allow certain wildcard imports (prelude, super in tests). Default Value: false (bool) wildcard_imports disallowed-macros The list of disallowed macros, written as fully qualified paths. Default Value: [] (Vec<crate::utils::conf::DisallowedPath>) disallowed_macros disallowed-methods The list of disallowed methods, written as fully qualified paths. Default Value: [] (Vec<crate::utils::conf::DisallowedPath>) disallowed_methods disallowed-types The list of disallowed types, written as fully qualified paths. Default Value: [] (Vec<crate::utils::conf::DisallowedPath>) disallowed_types unreadable-literal-lint-fractions Should the fraction of a decimal be linted to include separators. Default Value: true (bool) unreadable_literal upper-case-acronyms-aggressive Enables verbose mode. Triggers if there is more than one uppercase char next to each other Default Value: false (bool) upper_case_acronyms matches-for-let-else Whether the matches should be considered by the lint, and whether there should be filtering for common types. Default Value: WellKnownTypes (crate::manual_let_else::MatchLintBehaviour) manual_let_else cargo-ignore-publish For internal testing only, ignores the current publish settings in the Cargo manifest. Default Value: false (bool) _cargo_common_metadata standard-macro-braces Enforce the named macros always use the braces specified. A MacroMatcher can be added like so { name = \"macro_name\", brace = \"(\" }. If the macro could be used with a full path two MacroMatchers have to be added one with the full path crate_name::macro_name and one with just the macro name. Default Value: [] (Vec<crate::nonstandard_macro_braces::MacroMatcher>) nonstandard_macro_braces enforced-import-renames The list of imports to always rename, a fully qualified path followed by the rename. Default Value: [] (Vec<crate::utils::conf::Rename>) missing_enforced_import_renames allowed-scripts The list of unicode scripts allowed to be used in the scope. Default Value: [\"Latin\"] (Vec<String>) disallowed_script_idents enable-raw-pointer-heuristic-for-send Whether to apply the raw pointer heuristic to determine if a type is Send. Default Value: true (bool) non_send_fields_in_send_ty max-suggested-slice-pattern-length When Clippy suggests using a slice pattern, this is the maximum number of elements allowed in the slice pattern that is suggested. If more elements are necessary, the lint is suppressed. For example, [_, _, _, e, ..] is a slice pattern with 4 elements. Default Value: 3 (u64) index_refutable_slice await-holding-invalid-types Default Value: [] (Vec<crate::utils::conf::DisallowedPath>) await_holding_invalid_type max-include-file-size The maximum size of a file included via include_bytes!() or include_str!(), in bytes Default Value: 1000000 (u64) large_include_file allow-expect-in-tests Whether expect should be allowed in test functions or #[cfg(test)] Default Value: false (bool) expect_used allow-unwrap-in-tests Whether unwrap should be allowed in test functions or #[cfg(test)] Default Value: false (bool) unwrap_used allow-dbg-in-tests Whether dbg! should be allowed in test functions or #[cfg(test)] Default Value: false (bool) dbg_macro allow-print-in-tests Whether print macros (ex. println!) should be allowed in test functions or #[cfg(test)] Default Value: false (bool) print_stdout print_stderr large-error-threshold The maximum size of the Err-variant in a Result returned from a function Default Value: 128 (u64) result_large_err ignore-interior-mutability A list of paths to types that should be treated like Arc, i.e. ignored but for the generic parameters for determining interior mutability Default Value: [\"bytes::Bytes\"] (Vec<String>) mutable_key_type ifs_same_cond allow-mixed-uninlined-format-args Whether to allow mixed uninlined format args, e.g. format!(\"{} {}\", a, foo.bar) Default Value: true (bool) uninlined_format_args suppress-restriction-lint-in-const Whether to suppress a restriction lint in constant code. In same cases the restructured operation might not be unavoidable, as the suggested counterparts are unavailable in constant code. This configuration will cause restriction lints to trigger even if no suggestion can be made. Default Value: false (bool) indexing_slicing missing-docs-in-crate-items Whether to only check for missing documentation in items visible within the current crate. For example, pub(crate) items. Default Value: false (bool) missing_docs_in_private_items future-size-threshold The maximum byte size a Future can have, before it triggers the clippy::large_futures lint Default Value: 16384 (u64) large_futures","breadcrumbs":"Configuration » Lint Configuration » Lint Configuration Options","id":"8","title":"Lint Configuration Options"},"80":{"body":"This step is only necessary, if since the last release something was backported to the beta Rust release. The remerge is then necessary, to make sure that the Clippy commit, that was used by the now stable Rust release, persists in the tree of the Clippy repository. To find out if this step is necessary run # Assumes that the local master branch of rust-lang/rust-clippy is up-to-date\n$ git fetch upstream\n$ git branch master --contains upstream/beta If this command outputs master, this step is not necessary. # Assuming `HEAD` is the current `master` branch of rust-lang/rust-clippy\n$ git checkout -b backport_remerge\n$ git merge upstream/beta\n$ git diff # This diff has to be empty, otherwise something with the remerge failed\n$ git push origin backport_remerge # This can be pushed to your fork After this, open a PR to the master branch. In this PR, the commit hash of the HEAD of the beta branch must exist. In addition to that, no files should be changed by this PR.","breadcrumbs":"Development » Infrastructure » Release a New Version » Remerge the beta branch","id":"80","title":"Remerge the beta branch"},"81":{"body":"This step must be done after the PR of the previous step was merged. First, the Clippy commit of the beta branch of the Rust repository has to be determined. # Assuming the current directory corresponds to the Rust repository\n$ git fetch upstream\n$ git checkout upstream/beta\n$ BETA_SHA=$(git log --oneline -- src/tools/clippy/ | grep -o \"Merge commit '[a-f0-9]*' into .*\" | head -1 | sed -e \"s/Merge commit '\\([a-f0-9]*\\)' into .*/\\1/g\") After finding the Clippy commit, the beta branch in the Clippy repository can be updated. # Assuming the current directory corresponds to the Clippy repository\n$ git checkout beta\n$ git reset --hard $BETA_SHA\n$ git push upstream beta","breadcrumbs":"Development » Infrastructure » Release a New Version » Update the beta branch","id":"81","title":"Update the beta branch"},"82":{"body":"The first step is to tag the Clippy commit, that is included in the stable Rust release. This commit can be found in the Rust repository. # Assuming the current directory corresponds to the Rust repository\n$ git fetch upstream # `upstream` is the `rust-lang/rust` remote\n$ git checkout 1.XX.0 # XX should be exchanged with the corresponding version\n$ SHA=$(git log --oneline -- src/tools/clippy/ | grep -o \"Merge commit '[a-f0-9]*' into .*\" | head -1 | sed -e \"s/Merge commit '\\([a-f0-9]*\\)' into .*/\\1/g\")","breadcrumbs":"Development » Infrastructure » Release a New Version » Find the Clippy commit","id":"82","title":"Find the Clippy commit"},"83":{"body":"After finding the Clippy commit, it can be tagged with the release number. # Assuming the current directory corresponds to the Clippy repository\n$ git checkout $SHA\n$ git tag rust-1.XX.0 # XX should be exchanged with the corresponding version\n$ git push upstream rust-1.XX.0 # `upstream` is the `rust-lang/rust-clippy` remote After this, the release should be available on the Clippy release page .","breadcrumbs":"Development » Infrastructure » Release a New Version » Tag the stable commit","id":"83","title":"Tag the stable commit"},"84":{"body":"At this step you should have already checked out the commit of the rust-1.XX.0 tag. Updating the stable branch from here is as easy as: # Assuming the current directory corresponds to the Clippy repository and the\n# commit of the just created rust-1.XX.0 tag is checked out.\n$ git push upstream rust-1.XX.0:stable # `upstream` is the `rust-lang/rust-clippy` remote NOTE: Usually there are no stable backports for Clippy, so this update should be possible without force pushing or anything like this. If there should have happened a stable backport, make sure to re-merge those changes just as with the beta branch.","breadcrumbs":"Development » Infrastructure » Release a New Version » Update the stable branch","id":"84","title":"Update the stable branch"},"85":{"body":"For this see the document on how to update the changelog . If you don't have time to do a complete changelog update right away, just update the following parts: Remove the (beta) from the new stable version: ## Rust 1.XX (beta) -> ## Rust 1.XX Update the release date line of the new stable version: Current beta, release 20YY-MM-DD -> Current stable, released 20YY-MM-DD Update the release date line of the previous stable version: Current stable, released 20YY-MM-DD -> Released 20YY-MM-DD","breadcrumbs":"Development » Infrastructure » Release a New Version » Update CHANGELOG.md","id":"85","title":"Update CHANGELOG.md"},"86":{"body":"This document explains how to make additions and changes to the Clippy book, the guide to Clippy that you're reading right now. The Clippy book is formatted with Markdown and generated by mdBook . Get mdBook Make changes","breadcrumbs":"Development » Infrastructure » The Clippy Book » The Clippy Book","id":"86","title":"The Clippy Book"},"87":{"body":"While not strictly necessary since the book source is simply Markdown text files, having mdBook locally will allow you to build, test and serve the book locally to view changes before you commit them to the repository. You likely already have cargo installed, so the easiest option is to: cargo install mdbook See the mdBook installation instructions for other options.","breadcrumbs":"Development » Infrastructure » The Clippy Book » Get mdBook","id":"87","title":"Get mdBook"},"88":{"body":"The book's src directory contains all the markdown files used to generate the book. If you want to see your changes in real time, you can use the mdBook serve command to run a web server locally that will automatically update changes as they are made. From the top level of your rust-clippy directory: mdbook serve book --open Then navigate to http://localhost:3000 to see the generated book. While the server is running, changes you make will automatically be updated. For more information, see the mdBook guide .","breadcrumbs":"Development » Infrastructure » The Clippy Book » Make changes","id":"88","title":"Make changes"},"89":{"body":"This chapter is about accepted proposals for changes that should be worked on in or around Clippy in the long run. Besides adding more and more lints and improve the lints that Clippy already has, Clippy is also interested in making the experience of its users, developers and maintainers better over time. Projects that address bigger picture things like this usually take more time, and it is useful to have a proposal for those first. This is the place where such proposals are collected, so that we can refer to them when working on them.","breadcrumbs":"Development » Proposals » Proposals","id":"89","title":"Proposals"},"9":{"body":"Clippy offers a bunch of additional lints, to help its users write more correct and idiomatic Rust code. A full list of all lints, that can be filtered by category, lint level or keywords, can be found in the Clippy lint documentation . This chapter will give an overview of the different lint categories, which kind of lints they offer and recommended actions when you should see a lint out of that category. For examples, see the Clippy lint documentation and filter by category. The different lint groups were defined in the Clippy 1.0 RFC .","breadcrumbs":"Clippy's Lints » Clippy's Lints","id":"9","title":"Clippy's Lints"},"90":{"body":"","breadcrumbs":"Development » Proposals » Roadmap 2021 » Roadmap 2021","id":"90","title":"Roadmap 2021"},"91":{"body":"This Roadmap lays out the plans for Clippy in 2021: Improving usability and reliability Improving experience of contributors and maintainers Develop and specify processes Members of the Clippy team will be assigned tasks from one or more of these topics. The team member is then responsible to complete the assigned tasks. This can either be done by implementing them or by providing mentorship to interested contributors.","breadcrumbs":"Development » Proposals » Roadmap 2021 » Summary","id":"91","title":"Summary"},"92":{"body":"With the ongoing growth of the Rust language and with that of the whole ecosystem, also Clippy gets more and more users and contributors. This is good for the project, but also brings challenges along. Some of these challenges are: More issues about reliability or usability are popping up Traffic is hard to handle for a small team Bigger projects don't get completed due to the lack of processes and/or time of the team members Additionally, according to the Rust Roadmap 2021 , clear processes should be defined by every team and unified across teams. This Roadmap is the first step towards this.","breadcrumbs":"Development » Proposals » Roadmap 2021 » Motivation","id":"92","title":"Motivation"},"93":{"body":"This section will explain the things that should be done in 2021. It is important to note, that this document focuses on the \"What?\", not the \"How?\". The later will be addressed in follow-up tracking issue, with an assigned team member. The following is split up in two major sections. The first section covers the user facing plans, the second section the internal plans.","breadcrumbs":"Development » Proposals » Roadmap 2021 » Explanation","id":"93","title":"Explanation"},"94":{"body":"Clippy should be as pleasant to use and configure as possible. This section covers plans that should be implemented to improve the situation of Clippy in this regard. Usability In the following, plans to improve the usability are covered. No Output After cargo check Currently, when cargo clippy is run after cargo check, it does not produce any output. This is especially problematic since rust-analyzer is on the rise, and it uses cargo check for checking code. A fix is already implemented, but it still has to be pushed over the finish line. This also includes the stabilization of the cargo clippy --fix command or the support of multi-span suggestions in rustfix. #4612 lints.toml Configuration This is something that comes up every now and then: a reusable configuration file, where lint levels can be defined. Discussions about this often lead to nothing specific or to \"we need an RFC for this\". And this is exactly what needs to be done. Get together with the cargo team and write an RFC and implement such a configuration file somehow and somewhere. #3164 cargo#5034 IRLO Lint Groups There are more and more issues about managing lints in Clippy popping up. Lints are hard to implement with a guarantee of no/few false positives (FPs). One way to address this might be to introduce more lint groups to give users the ability to better manage lints, or improve the process of classifying lints, so that disabling lints due to FPs becomes rare. It is important to note, that Clippy lints are less conservative than rustc lints, which won't change in the future. #5537 #6366 Reliability In the following, plans to improve the reliability are covered. False Positive Rate In the worst case, new lints are only available in nightly for 2 weeks, before hitting beta and ultimately stable. This and the fact that fewer people use nightly Rust nowadays makes it more probable that a lint with many FPs hits stable. This leads to annoyed users, that will disable these new lints in the best case and to more annoyed users, that will stop using Clippy in the worst. A process should be developed and implemented to prevent this from happening. #6429","breadcrumbs":"Development » Proposals » Roadmap 2021 » User Facing","id":"94","title":"User Facing"},"95":{"body":"(The end of) 2020 has shown, that Clippy has to think about the available resources, especially regarding management and maintenance of the project. This section address issues affecting team members and contributors. Management In 2020 Clippy achieved over 1000 open issues with regularly between 25-35 open PRs. This is simultaneously a win and a loss. More issues and PRs means more people are interested in Clippy and in contributing to it. On the other hand, it means for team members more work and for contributors longer wait times for reviews. The following will describe plans how to improve the situation for both team members and contributors. Clear Expectations for Team Members According to the Rust Roadmap 2021 , a document specifying what it means to be a member of the team should be produced. This should not put more pressure on the team members, but rather help them and interested folks to know what the expectations are. With this it should also be easier to recruit new team members and may encourage people to get in touch, if they're interested to join. Scaling up the Team More people means less work for each individual. Together with the document about expectations for team members, a document defining the process of how to join the team should be produced. This can also increase the stability of the team, in case of current members dropping out (temporarily). There can also be different roles in the team, like people triaging vs. people reviewing. Regular Meetings Other teams have regular meetings. Clippy is big enough that it might be worth to also do them. Especially if more people join the team, this can be important for sync-ups. Besides the asynchronous communication, that works well for working on separate lints, a meeting adds a synchronous alternative at a known time. This is especially helpful if there are bigger things that need to be discussed (like the projects in this roadmap). For starters bi-weekly meetings before Rust syncs might make sense. Triaging To get a handle on the influx of open issues, a process for triaging issues and PRs should be developed. Officially, Clippy follows the Rust triage process, but currently no one enforces it. This can be improved by sharing triage teams across projects or by implementing dashboards / tools which simplify triaging. Development Improving the developer and contributor experience is something the Clippy team works on regularly. Though, some things might need special attention and planing. These topics are listed in the following. Process for New and Existing Lints As already mentioned above, classifying new lints gets quite hard, because the probability of a buggy lint getting into stable is quite high. A process should be implemented on how to classify lints. In addition, a test system should be developed to find out which lints are currently problematic in real world code to fix or disable them. #6429 (comment) #6429 (comment) Processes Related to the point before, a process for suggesting and discussing major changes should be implemented. It's also not clearly defined when a lint should be enabled or disabled by default. This can also be improved by the test system mentioned above. Dev-Tools There's already cargo dev which makes Clippy development easier and more pleasant. This can still be expanded, so that it covers more areas of the development process. #5394 Contributor Guide Similar to a Clippy Book, which describes how to use Clippy, a book about how to contribute to Clippy might be helpful for new and existing contributors. There's already the doc directory in the Clippy repo, this can be turned into a mdbook. rustc integration Recently Clippy was integrated with git subtree into the rust-lang/rust repository. This made syncing between the two repositories easier. A #[non_exhaustive] list of things that still can be improved is: Use the same rustfmt version and configuration as rustc. Make cargo dev work in the Rust repo, just as it works in the Clippy repo. E.g. cargo dev bless or cargo dev update_lints. And even add more things to it that might be useful for the Rust repo, e.g. cargo dev deprecate. Easier sync process. The subtree situation is not ideal.","breadcrumbs":"Development » Proposals » Roadmap 2021 » Internal","id":"95","title":"Internal"},"96":{"body":"The most pressing issues for users of Clippy are of course the user facing issues. So there should be a priority on those issues, but without losing track of the internal issues listed in this document. Getting the FP rate of warn/deny-by-default lints under control should have the highest priority. Other user facing issues should also get a high priority, but shouldn't be in the way of addressing internal issues. To better manage the upcoming projects, the basic internal processes, like meetings, tracking issues and documentation, should be established as soon as possible. They might even be necessary to properly manage the projects, regarding the user facing issues.","breadcrumbs":"Development » Proposals » Roadmap 2021 » Prioritization","id":"96","title":"Prioritization"},"97":{"body":"","breadcrumbs":"Development » Proposals » Roadmap 2021 » Prior Art","id":"97","title":"Prior Art"},"98":{"body":"Rust's roadmap process was established by RFC 1728 in 2016. Since then every year a roadmap was published, that defined the bigger plans for the coming years. This year roadmap can be found here .","breadcrumbs":"Development » Proposals » Roadmap 2021 » Rust Roadmap","id":"98","title":"Rust Roadmap"},"99":{"body":"","breadcrumbs":"Development » Proposals » Roadmap 2021 » Drawbacks","id":"99","title":"Drawbacks"}},"length":119,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{"1":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}},"3":{"df":1,"docs":{"101":{"tf":1.0}}},"7":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}},"8":{"df":1,"docs":{"68":{"tf":1.0}}},"df":3,"docs":{"115":{"tf":3.605551275463989},"5":{"tf":1.0},"66":{"tf":1.0}}},"1":{",":{"0":{"0":{"0":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"5":{",":{"0":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"0":{"df":2,"docs":{"23":{"tf":1.0},"9":{"tf":1.0}}},"2":{"9":{".":{"0":{"df":2,"docs":{"40":{"tf":1.0},"48":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"0":{".":{"0":{"df":1,"docs":{"7":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"4":{"4":{"df":1,"docs":{"45":{"tf":1.0}}},"5":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{},"x":{"df":0,"docs":{},"x":{".":{"0":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":3,"docs":{"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"85":{"tf":1.4142135623730951}}}}},"/":{"df":0,"docs":{},"g":{"df":3,"docs":{"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}},"0":{"0":{"0":{"0":{"0":{"0":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"95":{"tf":1.0}}},"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"1":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}},"2":{"8":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":1,"docs":{"101":{"tf":1.0}}},"6":{"3":{"8":{"4":{"df":1,"docs":{"8":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"2":{"8":{"df":1,"docs":{"98":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":12,"docs":{"102":{"tf":1.4142135623730951},"115":{"tf":2.449489742783178},"117":{"tf":1.7320508075688772},"5":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"8":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.0}}},"2":{".":{"0":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"0":{"0":{"df":1,"docs":{"8":{"tf":2.0}}},"1":{"6":{"df":1,"docs":{"98":{"tf":1.0}}},"8":{"df":1,"docs":{"6":{"tf":1.0}}},"9":{"df":1,"docs":{"101":{"tf":1.0}}},"df":0,"docs":{}},"2":{"0":{"df":2,"docs":{"68":{"tf":1.0},"95":{"tf":1.4142135623730951}}},"1":{"df":7,"docs":{"100":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.0}}},"2":{"df":1,"docs":{"100":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":1,"docs":{"85":{"tf":2.0}}}}},"5":{"0":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"6":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":2,"docs":{"8":{"tf":1.4142135623730951},"95":{"tf":1.0}}},"7":{"df":2,"docs":{"57":{"tf":1.0},"68":{"tf":1.0}}},"df":9,"docs":{"105":{"tf":1.0},"117":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"94":{"tf":1.0}}},"3":{".":{"1":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"1":{"6":{"4":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"df":1,"docs":{"95":{"tf":1.0}}},"8":{"7":{"5":{"df":1,"docs":{"101":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"63":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":3.1622776601683795}}},"4":{"0":{"9":{"6":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"1":{"2":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"78":{"tf":1.0},"8":{"tf":1.7320508075688772}}},"5":{"1":{"2":{"0":{"0":{"0":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"9":{"4":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"3":{"7":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"0":{"0":{"0":{"0":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"3":{"6":{"6":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"2":{"9":{"df":2,"docs":{"94":{"tf":1.0},"95":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"9":{"df":3,"docs":{"78":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951}}},"_":{"?":{")":{"#":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}}}}}},")":{"#":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":1,"docs":{"118":{"tf":2.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":12,"docs":{"105":{"tf":4.795831523312719},"112":{"tf":1.4142135623730951},"113":{"tf":1.7320508075688772},"117":{"tf":1.4142135623730951},"118":{"tf":4.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"57":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"65":{"tf":1.0},"8":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"a":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"36":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"/":{"df":0,"docs":{},"w":{"/":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},">":{"#":{"<":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"105":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"{":{"df":0,"docs":{},"n":{",":{"df":0,"docs":{},"m":{"df":1,"docs":{"105":{"tf":1.4142135623730951}}}},"df":1,"docs":{"105":{"tf":2.0}}}}},"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"66":{"tf":1.0}},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"b":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":2,"docs":{"24":{"tf":1.0},"30":{"tf":2.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"94":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"v":{"df":10,"docs":{"102":{"tf":1.7320508075688772},"103":{"tf":1.0},"106":{"tf":2.0},"111":{"tf":1.0},"115":{"tf":1.4142135623730951},"46":{"tf":1.0},"5":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"78":{"tf":1.7320508075688772},"89":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":10,"docs":{"115":{"tf":1.0},"27":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"52":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":4,"docs":{"43":{"tf":1.0},"49":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"42":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"106":{"tf":1.0},"45":{"tf":1.0}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"54":{"tf":1.0},"95":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"19":{"tf":1.0},"9":{"tf":1.0}},"s":{"/":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"@":{"df":0,"docs":{},"v":{"3":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"df":2,"docs":{"31":{"tf":1.4142135623730951},"66":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":7,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"109":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"41":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"114":{"tf":1.4142135623730951},"68":{"tf":1.0},"78":{"tf":1.0}}}}},"d":{"df":22,"docs":{"104":{"tf":1.0},"11":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.4142135623730951},"39":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.7320508075688772},"7":{"tf":1.0},"70":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"95":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":9,"docs":{"106":{"tf":1.0},"113":{"tf":1.4142135623730951},"115":{"tf":1.0},"118":{"tf":1.4142135623730951},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"95":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"113":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.0},"37":{"tf":1.0},"92":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":8,"docs":{"100":{"tf":1.0},"58":{"tf":1.0},"70":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}}}}}},"df":16,"docs":{"18":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"32":{"tf":2.0},"38":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":2.6457513110645907},"78":{"tf":1.0},"8":{"tf":1.4142135623730951},"89":{"tf":1.0}},"t":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"57":{"tf":1.0},"61":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"57":{"tf":1.0}}}}},"df":1,"docs":{"57":{"tf":1.0}}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"115":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"103":{"tf":1.0},"114":{"tf":1.7320508075688772},"115":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"115":{"tf":1.0},"41":{"tf":1.0},"7":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"115":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":13,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"106":{"tf":1.0},"109":{"tf":1.0},"112":{"tf":2.0},"113":{"tf":1.4142135623730951},"117":{"tf":1.0},"19":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"45":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"5":{"tf":1.0},"75":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":1,"docs":{"113":{"tf":1.0}}}}}}}}},"i":{"a":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{".":{".":{")":{"]":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"40":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"]":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"14":{"tf":1.0}}},"df":25,"docs":{"0":{"tf":1.7320508075688772},"101":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.4142135623730951},"11":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":2.0},"12":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.7320508075688772},"55":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":2.0},"71":{"tf":1.0},"8":{"tf":5.656854249492381},"87":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"106":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"92":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":14,"docs":{"1":{"tf":1.0},"25":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0},"66":{"tf":1.4142135623730951},"78":{"tf":1.7320508075688772},"84":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"110":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"<":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"110":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"110":{"tf":1.0}}}},"df":1,"docs":{"110":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":8,"docs":{"105":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"110":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":2.0},"116":{"tf":1.0},"118":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"30":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":1,"docs":{"94":{"tf":1.0}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"71":{"tf":1.0},"92":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":2,"docs":{"0":{"tf":1.0},"94":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":8,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"111":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.0},"118":{"tf":1.7320508075688772},"41":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":2.449489742783178}}}}}}}}}},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"y":{"<":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"105":{"tf":1.4142135623730951},"110":{"tf":1.0},"84":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"50":{"tf":1.0}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":3,"docs":{"68":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"113":{"tf":1.0},"53":{"tf":1.0}}},"df":9,"docs":{"103":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"37":{"tf":1.0},"5":{"tf":1.4142135623730951},"66":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"a":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"103":{"tf":1.4142135623730951},"113":{"tf":1.4142135623730951},"114":{"tf":1.0},"115":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"43":{"tf":1.0}}}}},"v":{"df":1,"docs":{"73":{"tf":1.0}}},"x":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{},"e":{"a":{"df":3,"docs":{"103":{"tf":1.0},"118":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"113":{"tf":1.0}}}},"df":0,"docs":{}}},"g":{"df":1,"docs":{"8":{"tf":1.7320508075688772}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"104":{"tf":1.0},"105":{"tf":1.7320508075688772},"6":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":3.0}},"i":{"c":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.7320508075688772}},"s":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"d":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"110":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":6,"docs":{"105":{"tf":3.0},"106":{"tf":2.0},"111":{"tf":1.4142135623730951},"117":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"t":{"df":2,"docs":{"116":{"tf":1.0},"97":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"k":{"df":4,"docs":{"30":{"tf":1.0},"53":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"(":{"c":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"x":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{".":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"106":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"(":{"_":{"#":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":4,"docs":{"106":{"tf":1.4142135623730951},"115":{"tf":1.0},"91":{"tf":1.4142135623730951},"93":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":11,"docs":{"4":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}}}},"t":{"'":{"df":1,"docs":{"115":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"113":{"tf":1.4142135623730951},"115":{"tf":1.0}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"(":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"102":{"tf":1.4142135623730951}}}}}},"df":1,"docs":{"102":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"113":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"102":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.4142135623730951}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"_":{"df":1,"docs":{"102":{"tf":1.0}}},"df":0,"docs":{},"j":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"j":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"j":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"112":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.4142135623730951}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"102":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"102":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":10,"docs":{"102":{"tf":2.0},"105":{"tf":1.0},"109":{"tf":1.4142135623730951},"110":{"tf":1.0},"112":{"tf":1.4142135623730951},"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"118":{"tf":1.7320508075688772},"30":{"tf":1.0},"42":{"tf":1.0}}},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}},"n":{"df":1,"docs":{"105":{"tf":1.0}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":9,"docs":{"106":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.7320508075688772},"7":{"tf":1.0},"78":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"115":{"tf":1.0},"118":{"tf":1.4142135623730951},"32":{"tf":1.0},"46":{"tf":1.4142135623730951},"78":{"tf":1.0}}}}},"o":{"df":1,"docs":{"40":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"t":{"df":8,"docs":{"1":{"tf":1.0},"27":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.4142135623730951},"52":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"df":2,"docs":{"41":{"tf":1.4142135623730951},"42":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":9,"docs":{"27":{"tf":1.0},"41":{"tf":1.0},"45":{"tf":1.0},"54":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"83":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":6,"docs":{"43":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"y":{"df":2,"docs":{"53":{"tf":1.0},"85":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"a":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"18":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":1.0}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"80":{"tf":1.4142135623730951}}}}}}}}},"df":6,"docs":{"73":{"tf":2.449489742783178},"74":{"tf":2.8284271247461903},"75":{"tf":1.7320508075688772},"78":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}}}}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}}}},"d":{"df":4,"docs":{"0":{"tf":1.0},"40":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":4,"docs":{"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"8":{"tf":1.0}}},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"107":{"tf":1.0},"16":{"tf":1.0},"63":{"tf":1.0}}},"h":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}},"i":{"c":{"df":9,"docs":{"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.7320508075688772},"3":{"tf":1.0},"33":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0},"96":{"tf":1.0}}},"df":2,"docs":{"12":{"tf":1.0},"68":{"tf":1.0}}}},"z":{"df":3,"docs":{"105":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}},"df":8,"docs":{"105":{"tf":2.23606797749979},"118":{"tf":1.4142135623730951},"36":{"tf":1.0},"66":{"tf":2.23606797749979},"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"80":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":4,"docs":{"102":{"tf":1.0},"115":{"tf":1.0},"38":{"tf":1.0},"94":{"tf":1.0}}}}},"df":3,"docs":{"113":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":15,"docs":{"18":{"tf":1.0},"27":{"tf":1.0},"36":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.4142135623730951},"87":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"30":{"tf":1.0},"35":{"tf":1.0},"52":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"64":{"tf":1.0}}}},"w":{"df":11,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"27":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"59":{"tf":1.0},"7":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"118":{"tf":1.0}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"24":{"tf":1.0},"55":{"tf":1.0},"89":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":2,"docs":{"35":{"tf":1.0},"94":{"tf":1.0}}}},"t":{"a":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"=":{"$":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"81":{"tf":1.0}}},"df":0,"docs":{}}}},"df":12,"docs":{"20":{"tf":1.0},"68":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":2.23606797749979},"75":{"tf":2.23606797749979},"78":{"tf":2.6457513110645907},"79":{"tf":1.4142135623730951},"80":{"tf":1.7320508075688772},"81":{"tf":2.23606797749979},"84":{"tf":1.0},"85":{"tf":1.7320508075688772},"94":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"21":{"tf":1.0},"43":{"tf":1.0},"89":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":7,"docs":{"109":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"78":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"106":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"b":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}},"df":2,"docs":{"68":{"tf":1.0},"95":{"tf":1.0}},"g":{"df":4,"docs":{"100":{"tf":1.4142135623730951},"26":{"tf":1.0},"69":{"tf":1.0},"95":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"23":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"115":{"tf":1.4142135623730951},"31":{"tf":1.0},"4":{"tf":1.0},"8":{"tf":2.0}}},"y":{"(":{"_":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"d":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}},"df":1,"docs":{"31":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"115":{"tf":2.0}}},"df":0,"docs":{}}}}}}},"t":{"df":3,"docs":{"34":{"tf":1.0},"44":{"tf":1.0},"8":{"tf":1.7320508075688772}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"26":{"tf":1.0},"36":{"tf":1.7320508075688772},"37":{"tf":1.0},"44":{"tf":1.0},"95":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"k":{"(":{"_":{")":{"#":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"118":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"110":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"_":{"(":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"110":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"118":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"118":{"tf":1.7320508075688772}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"113":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":4,"docs":{"102":{"tf":1.0},"105":{"tf":2.6457513110645907},"113":{"tf":1.4142135623730951},"118":{"tf":2.8284271247461903}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"110":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"42":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"88":{"tf":1.0}}},"df":6,"docs":{"23":{"tf":1.4142135623730951},"52":{"tf":1.0},"86":{"tf":1.7320508075688772},"87":{"tf":1.4142135623730951},"88":{"tf":1.7320508075688772},"95":{"tf":1.4142135623730951}}},"l":{"(":{"_":{"#":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"105":{"tf":1.4142135623730951}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"110":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":5,"docs":{"112":{"tf":1.4142135623730951},"44":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"8":{"tf":4.358898943540674}},"e":{"a":{"df":0,"docs":{},"n":{"df":5,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":2.0},"106":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"r":{"df":1,"docs":{"23":{"tf":1.0}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"h":{"df":7,"docs":{"102":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.0},"35":{"tf":1.0},"7":{"tf":1.0},"95":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":2.0}}},"df":0,"docs":{}}},"x":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"110":{"tf":2.0}}}}}}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":2,"docs":{"52":{"tf":1.4142135623730951},"8":{"tf":2.23606797749979}},"e":{"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":2.0}}}},"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":13,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":1.7320508075688772},"75":{"tf":1.7320508075688772},"78":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"80":{"tf":2.449489742783178},"81":{"tf":1.7320508075688772},"84":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":4,"docs":{"102":{"tf":1.0},"114":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"92":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"73":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"18":{"tf":1.0},"69":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"23":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"95":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"l":{"d":{"df":8,"docs":{"20":{"tf":1.0},"24":{"tf":1.4142135623730951},"26":{"tf":2.0},"28":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"87":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":2,"docs":{"68":{"tf":1.0},"69":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":2.449489742783178}},"s":{":":{":":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"69":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":15,"docs":{"104":{"tf":1.4142135623730951},"109":{"tf":1.0},"111":{"tf":1.0},"27":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.7320508075688772},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"69":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":1.0},"43":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"7":{"tf":1.0},"77":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}},"g":{"df":0,"docs":{},"o":{"#":{"5":{"0":{"3":{"4":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"36":{"tf":1.0}}}}}}},"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"31":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":30,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":2.0},"24":{"tf":1.0},"26":{"tf":2.449489742783178},"27":{"tf":3.0},"28":{"tf":1.0},"31":{"tf":2.23606797749979},"32":{"tf":1.0},"35":{"tf":2.0},"36":{"tf":3.1622776601683795},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.7320508075688772},"44":{"tf":2.449489742783178},"49":{"tf":1.0},"5":{"tf":3.0},"51":{"tf":1.7320508075688772},"52":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":2.8284271247461903},"8":{"tf":1.7320508075688772},"87":{"tf":1.4142135623730951},"94":{"tf":2.449489742783178},"95":{"tf":2.23606797749979}}}}},"s":{"df":0,"docs":{},"e":{"df":24,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"107":{"tf":1.0},"11":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"21":{"tf":1.0},"26":{"tf":1.4142135623730951},"34":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.7320508075688772},"53":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.7320508075688772},"94":{"tf":1.4142135623730951},"95":{"tf":1.0}}},"t":{"_":{"a":{"b":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"0":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"0":{"tf":1.7320508075688772},"10":{"tf":1.0},"23":{"tf":1.4142135623730951},"35":{"tf":1.0},"9":{"tf":2.0}}},"y":{"=":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"u":{"df":0,"docs":{},"s":{"df":6,"docs":{"113":{"tf":1.0},"36":{"tf":1.0},"5":{"tf":1.4142135623730951},"66":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"d":{"df":1,"docs":{"31":{"tf":1.0}}},"df":1,"docs":{"105":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":7,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"112":{"tf":1.0},"16":{"tf":1.0},"45":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":2.0}}}}}}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"92":{"tf":1.4142135623730951}}}}}}},"n":{"df":0,"docs":{},"g":{"df":26,"docs":{"0":{"tf":1.0},"102":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.0},"118":{"tf":1.0},"23":{"tf":1.0},"36":{"tf":1.0},"52":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":2.23606797749979},"69":{"tf":1.0},"71":{"tf":1.7320508075688772},"73":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":2.0},"89":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"m":{"d":{"df":3,"docs":{"78":{"tf":1.0},"79":{"tf":1.0},"85":{"tf":1.0}}},"df":0,"docs":{}}},"df":5,"docs":{"67":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"77":{"tf":1.7320508075688772},"78":{"tf":3.0},"85":{"tf":1.4142135623730951}}}}},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":10,"docs":{"1":{"tf":1.4142135623730951},"18":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.7320508075688772},"59":{"tf":1.0},"67":{"tf":1.4142135623730951},"89":{"tf":1.0},"9":{"tf":1.0}}}}}},"r":{"(":{"'":{"df":0,"docs":{},"x":{"df":1,"docs":{"105":{"tf":1.0}}}},"_":{"df":2,"docs":{"105":{"tf":1.0},"118":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"110":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"103":{"tf":1.7320508075688772},"105":{"tf":2.0},"106":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":4,"docs":{"105":{"tf":1.4142135623730951},"106":{"tf":1.0},"56":{"tf":1.7320508075688772},"8":{"tf":2.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.0},"53":{"tf":1.0}}}},"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":9,"docs":{"104":{"tf":1.0},"113":{"tf":1.4142135623730951},"45":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"f":{"df":0,"docs":{},"n":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"43":{"tf":1.4142135623730951},"44":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":2,"docs":{"43":{"tf":1.0},"44":{"tf":1.7320508075688772}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"113":{"tf":1.0}}}}}},"df":35,"docs":{"102":{"tf":1.0},"106":{"tf":1.7320508075688772},"113":{"tf":2.23606797749979},"118":{"tf":1.4142135623730951},"15":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"25":{"tf":1.0},"36":{"tf":1.7320508075688772},"40":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":2.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":2.23606797749979},"61":{"tf":1.0},"62":{"tf":2.449489742783178},"63":{"tf":2.449489742783178},"64":{"tf":1.0},"65":{"tf":2.449489742783178},"66":{"tf":2.0},"7":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"78":{"tf":2.0},"8":{"tf":2.0},"84":{"tf":1.4142135623730951},"94":{"tf":2.0}},"e":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.0},"51":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":10,"docs":{"25":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"74":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"78":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"5":{"tf":1.4142135623730951},"74":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"115":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"0":{"tf":1.0},"43":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"34":{"tf":1.0}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"i":{"/":{"c":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"18":{"tf":2.23606797749979},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"49":{"tf":1.0},"5":{"tf":1.0},"67":{"tf":1.0}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"94":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"105":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"78":{"tf":1.0}}}}},"r":{"df":2,"docs":{"92":{"tf":1.0},"95":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"32":{"tf":1.0},"95":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":76,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"100":{"tf":1.0},"102":{"tf":1.0},"107":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"18":{"tf":3.0},"19":{"tf":2.449489742783178},"2":{"tf":1.4142135623730951},"20":{"tf":2.23606797749979},"21":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":2.0},"24":{"tf":2.0},"25":{"tf":2.449489742783178},"26":{"tf":1.7320508075688772},"27":{"tf":2.0},"28":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":4.123105625617661},"32":{"tf":1.4142135623730951},"34":{"tf":1.0},"36":{"tf":1.7320508075688772},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"4":{"tf":2.0},"40":{"tf":1.0},"42":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.7320508075688772},"47":{"tf":1.4142135623730951},"49":{"tf":1.0},"5":{"tf":4.358898943540674},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"57":{"tf":1.0},"6":{"tf":2.8284271247461903},"64":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":2.6457513110645907},"68":{"tf":2.0},"69":{"tf":1.0},"7":{"tf":4.123105625617661},"70":{"tf":2.449489742783178},"71":{"tf":3.0},"72":{"tf":2.23606797749979},"73":{"tf":2.449489742783178},"74":{"tf":2.6457513110645907},"75":{"tf":2.0},"77":{"tf":1.0},"78":{"tf":2.23606797749979},"79":{"tf":2.23606797749979},"8":{"tf":2.6457513110645907},"80":{"tf":2.0},"81":{"tf":2.0},"82":{"tf":1.4142135623730951},"83":{"tf":2.0},"84":{"tf":1.7320508075688772},"86":{"tf":2.0},"88":{"tf":1.0},"89":{"tf":1.7320508075688772},"9":{"tf":2.0},"91":{"tf":1.4142135623730951},"92":{"tf":1.0},"94":{"tf":2.6457513110645907},"95":{"tf":3.605551275463989},"96":{"tf":1.0}}},"y":{"'":{"df":8,"docs":{"102":{"tf":1.0},"113":{"tf":1.4142135623730951},"118":{"tf":1.0},"26":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"53":{"tf":1.0},"64":{"tf":1.4142135623730951},"9":{"tf":1.0}}},".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":3,"docs":{"45":{"tf":1.0},"52":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}}}}},":":{":":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"0":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":2,"docs":{"0":{"tf":1.0},"17":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":2,"docs":{"0":{"tf":1.0},"12":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"10":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"47":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":2,"docs":{"45":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}}},"p":{"df":0,"docs":{},"e":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"0":{"tf":1.0},"15":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":2,"docs":{"0":{"tf":1.0},"13":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"16":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":3,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"5":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"11":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":3,"docs":{"40":{"tf":1.4142135623730951},"48":{"tf":1.0},"78":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"40":{"tf":1.0},"52":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"r":{"c":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"35":{"tf":1.0},"40":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"{":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"}":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"65":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"t":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"{":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"63":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"63":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}},"n":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":3,"docs":{"25":{"tf":1.7320508075688772},"52":{"tf":1.7320508075688772},"71":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"o":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"106":{"tf":1.0},"113":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"s":{"df":5,"docs":{"113":{"tf":1.0},"19":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.0},"49":{"tf":1.0}}}},"df":0,"docs":{}},"df":41,"docs":{"0":{"tf":2.449489742783178},"10":{"tf":1.0},"102":{"tf":2.449489742783178},"103":{"tf":1.4142135623730951},"107":{"tf":1.0},"11":{"tf":2.23606797749979},"110":{"tf":1.0},"113":{"tf":1.7320508075688772},"114":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"12":{"tf":2.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.7320508075688772},"15":{"tf":1.4142135623730951},"16":{"tf":1.7320508075688772},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.4142135623730951},"34":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":2.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951},"5":{"tf":2.8284271247461903},"50":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"66":{"tf":2.449489742783178},"7":{"tf":2.8284271247461903},"78":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}},"r":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":1,"docs":{"118":{"tf":1.0}},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":2,"docs":{"102":{"tf":1.7320508075688772},"107":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"52":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"df":6,"docs":{"0":{"tf":1.0},"103":{"tf":1.0},"30":{"tf":1.0},"77":{"tf":1.0},"94":{"tf":1.0},"98":{"tf":1.0}}},"m":{"a":{"df":1,"docs":{"36":{"tf":1.0}},"n":{"d":{"df":17,"docs":{"18":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"31":{"tf":1.0},"35":{"tf":2.6457513110645907},"46":{"tf":1.0},"5":{"tf":2.0},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"88":{"tf":1.0},"94":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"106":{"tf":1.0},"113":{"tf":1.0},"16":{"tf":1.0},"37":{"tf":1.0},"48":{"tf":1.0},"52":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"t":{"(":{"df":1,"docs":{"74":{"tf":1.0}}},"1":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"78":{"tf":1.0}}},"df":15,"docs":{"26":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":1.0},"36":{"tf":1.7320508075688772},"51":{"tf":1.0},"71":{"tf":2.23606797749979},"74":{"tf":1.4142135623730951},"78":{"tf":3.0},"79":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"81":{"tf":2.0},"82":{"tf":2.23606797749979},"83":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"87":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":11,"docs":{"0":{"tf":1.0},"103":{"tf":1.0},"118":{"tf":1.0},"24":{"tf":1.4142135623730951},"30":{"tf":1.0},"35":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.4142135623730951},"60":{"tf":1.7320508075688772},"66":{"tf":1.0},"8":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"114":{"tf":1.0},"118":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0}}},"t":{"df":2,"docs":{"106":{"tf":1.0},"18":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":16,"docs":{"10":{"tf":1.0},"102":{"tf":1.0},"114":{"tf":2.0},"13":{"tf":1.0},"18":{"tf":1.4142135623730951},"22":{"tf":1.0},"30":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"68":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"102":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"14":{"tf":1.0},"5":{"tf":1.0},"69":{"tf":1.0},"85":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0}}},"x":{"df":7,"docs":{"0":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.0},"115":{"tf":2.449489742783178},"12":{"tf":2.0},"43":{"tf":1.0},"8":{"tf":2.449489742783178}}}},"i":{"c":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"2":{"tf":1.0},"20":{"tf":1.0},"31":{"tf":1.7320508075688772},"49":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"102":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":4,"docs":{"105":{"tf":1.0},"118":{"tf":1.0},"53":{"tf":1.0},"59":{"tf":1.0}},"u":{"df":1,"docs":{"113":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"42":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":7,"docs":{"102":{"tf":1.0},"105":{"tf":1.4142135623730951},"113":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.0},"44":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{},"f":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"7":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"52":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":8,"docs":{"32":{"tf":1.0},"45":{"tf":1.4142135623730951},"5":{"tf":2.449489742783178},"52":{"tf":4.0},"7":{"tf":2.8284271247461903},"8":{"tf":3.0},"94":{"tf":2.0},"95":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"94":{"tf":1.0}}}}},"i":{"d":{"df":8,"docs":{"0":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"18":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"8":{"tf":2.23606797749979}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"106":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"8":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}},"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":22,"docs":{"0":{"tf":1.0},"102":{"tf":1.0},"105":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"11":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.0},"115":{"tf":1.4142135623730951},"117":{"tf":1.0},"118":{"tf":1.0},"16":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.4142135623730951},"52":{"tf":1.0},"55":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"7":{"tf":2.0},"78":{"tf":1.0},"80":{"tf":1.0},"88":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"102":{"tf":1.4142135623730951},"113":{"tf":1.0},"37":{"tf":1.0},"45":{"tf":1.0},"78":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":5,"docs":{"30":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.4142135623730951},"64":{"tf":1.0},"66":{"tf":3.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":2,"docs":{"18":{"tf":1.0},"69":{"tf":1.0}}}}},"r":{"a":{"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"112":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.0},"95":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"91":{"tf":1.4142135623730951},"92":{"tf":1.0},"95":{"tf":2.449489742783178}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"96":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}},"t":{"df":1,"docs":{"51":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"114":{"tf":1.0},"58":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":11,"docs":{"31":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"8":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":2.23606797749979}}}}}},":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"110":{"tf":1.0},"69":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"0":{"tf":1.0},"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"116":{"tf":1.0},"78":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":13,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"41":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"114":{"tf":1.0},"118":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"5":{"tf":1.0},"96":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"23":{"tf":1.4142135623730951},"59":{"tf":1.0},"78":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.7320508075688772},"95":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"=":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"69":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":15,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"20":{"tf":1.0},"28":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772},"40":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"64":{"tf":1.0},"66":{"tf":1.7320508075688772},"7":{"tf":1.0},"8":{"tf":2.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":14,"docs":{"106":{"tf":1.4142135623730951},"118":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.0},"32":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":2.0},"36":{"tf":1.4142135623730951},"40":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.0},"84":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":30,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"110":{"tf":1.7320508075688772},"112":{"tf":1.4142135623730951},"113":{"tf":1.7320508075688772},"114":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":2.8284271247461903},"31":{"tf":1.4142135623730951},"36":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"53":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.0},"78":{"tf":2.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.7320508075688772},"94":{"tf":1.0},"95":{"tf":1.7320508075688772}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":3,"docs":{"113":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.4142135623730951}}}}}}},"x":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"104":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"c":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"64":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"(":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":5,"docs":{"56":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":12,"docs":{"104":{"tf":1.0},"113":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0}}},"y":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"69":{"tf":1.0}}}},"t":{"a":{"df":8,"docs":{"102":{"tf":1.7320508075688772},"103":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.4142135623730951},"116":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":7,"docs":{"101":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.7320508075688772},"77":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":1.4142135623730951}}}},"y":{"df":1,"docs":{"68":{"tf":1.0}}}},"b":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":2,"docs":{"50":{"tf":1.0},"8":{"tf":1.7320508075688772}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"d":{"df":2,"docs":{"71":{"tf":1.0},"85":{"tf":2.0}}},"df":2,"docs":{"20":{"tf":1.4142135623730951},"5":{"tf":1.0}},"e":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":3,"docs":{"42":{"tf":1.4142135623730951},"60":{"tf":1.0},"66":{"tf":1.4142135623730951}}}},"b":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"g":{"df":3,"docs":{"32":{"tf":1.0},"50":{"tf":1.7320508075688772},"52":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"s":{"df":1,"docs":{"42":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":6,"docs":{"103":{"tf":1.7320508075688772},"32":{"tf":1.0},"40":{"tf":2.23606797749979},"41":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.0}},"e":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"40":{"tf":1.4142135623730951},"48":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"!":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"52":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":17,"docs":{"0":{"tf":1.7320508075688772},"10":{"tf":1.0},"117":{"tf":1.0},"14":{"tf":1.0},"20":{"tf":1.0},"31":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"5":{"tf":2.23606797749979},"52":{"tf":1.7320508075688772},"69":{"tf":1.0},"7":{"tf":2.0},"8":{"tf":7.681145747868608},"95":{"tf":1.0},"96":{"tf":1.0}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"52":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.0}}}}},"i":{"d":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":19,"docs":{"104":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"112":{"tf":1.0},"118":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.4142135623730951},"52":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"66":{"tf":1.7320508075688772},"7":{"tf":1.0},"70":{"tf":1.4142135623730951},"9":{"tf":1.0},"92":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.4142135623730951},"98":{"tf":1.0}},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":6,"docs":{"111":{"tf":1.0},"35":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.7320508075688772},"55":{"tf":1.0},"61":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"105":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"i":{"df":3,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"7":{"tf":1.0}}},"y":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"p":{"df":1,"docs":{"5":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"d":{"df":12,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.4142135623730951},"64":{"tf":1.0},"78":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"67":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":4,"docs":{"27":{"tf":1.4142135623730951},"7":{"tf":1.0},"78":{"tf":1.4142135623730951},"95":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"15":{"tf":1.0},"24":{"tf":1.0},"58":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"b":{"df":14,"docs":{"101":{"tf":1.0},"103":{"tf":1.7320508075688772},"105":{"tf":1.7320508075688772},"106":{"tf":1.0},"109":{"tf":1.0},"114":{"tf":1.0},"118":{"tf":1.7320508075688772},"23":{"tf":1.0},"4":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"67":{"tf":2.0},"68":{"tf":1.0},"95":{"tf":1.4142135623730951}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":6,"docs":{"0":{"tf":1.0},"24":{"tf":1.0},"32":{"tf":1.0},"40":{"tf":1.4142135623730951},"48":{"tf":1.0},"5":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":4,"docs":{"103":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"6":{"tf":1.0}}}},"r":{"df":3,"docs":{"103":{"tf":1.0},"39":{"tf":1.0},"8":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":6,"docs":{"104":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":1.0},"28":{"tf":1.0},"43":{"tf":1.0},"68":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"103":{"tf":1.0},"32":{"tf":1.0},"46":{"tf":1.0},"66":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"41":{"tf":1.0},"8":{"tf":1.4142135623730951},"81":{"tf":1.0}}}}}}}},"v":{"df":21,"docs":{"24":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":3.1622776601683795},"29":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":2.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.4142135623730951},"53":{"tf":1.0},"60":{"tf":1.0},"68":{"tf":1.0},"95":{"tf":2.449489742783178}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":10,"docs":{"0":{"tf":1.0},"115":{"tf":1.4142135623730951},"21":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"40":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":2.449489742783178}}}}}}}},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"53":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.7320508075688772},"64":{"tf":1.7320508075688772}}}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"109":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":3,"docs":{"28":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":14,"docs":{"106":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"13":{"tf":1.0},"18":{"tf":1.0},"26":{"tf":1.0},"36":{"tf":1.0},"44":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"9":{"tf":1.4142135623730951},"95":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"115":{"tf":1.4142135623730951},"66":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"r":{"df":1,"docs":{"31":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":7,"docs":{"106":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0},"32":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"74":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":16,"docs":{"31":{"tf":1.4142135623730951},"35":{"tf":1.0},"40":{"tf":1.0},"52":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"88":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}},"x":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"5":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"70":{"tf":1.0},"73":{"tf":1.0},"94":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"14":{"tf":1.0},"5":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"7":{"tf":2.0},"8":{"tf":3.4641016151377544}},"e":{"d":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"56":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"105":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"c":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":6,"docs":{"22":{"tf":1.0},"48":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"8":{"tf":2.449489742783178},"95":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":23,"docs":{"100":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"40":{"tf":2.0},"45":{"tf":1.0},"48":{"tf":2.0},"5":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"57":{"tf":1.0},"67":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.7320508075688772},"8":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.4142135623730951},"93":{"tf":1.0},"95":{"tf":1.7320508075688772},"96":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":6,"docs":{"110":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"101":{"tf":1.0},"103":{"tf":2.0}}}}},"df":0,"docs":{}},"n":{"'":{"df":0,"docs":{},"t":{"df":18,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.4142135623730951},"39":{"tf":1.0},"42":{"tf":1.7320508075688772},"5":{"tf":1.0},"53":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"85":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":17,"docs":{"104":{"tf":1.0},"109":{"tf":1.0},"23":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.4142135623730951},"45":{"tf":1.0},"52":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"71":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"81":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"36":{"tf":1.0},"42":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"63":{"tf":1.0}}}},"w":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"113":{"tf":1.4142135623730951},"99":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"118":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"31":{"tf":2.0},"39":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":2.23606797749979}}}}}},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"64":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"e":{"df":2,"docs":{"92":{"tf":1.0},"94":{"tf":1.0}}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"78":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":7,"docs":{"100":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.0},"30":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0},"77":{"tf":1.0}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"5":{"tf":1.0}}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"39":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":12,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"109":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"18":{"tf":1.0},"36":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951},"71":{"tf":1.0},"8":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":9,"docs":{"0":{"tf":1.0},"112":{"tf":1.0},"115":{"tf":1.0},"27":{"tf":1.0},"36":{"tf":1.4142135623730951},"7":{"tf":1.0},"78":{"tf":1.4142135623730951},"8":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"113":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"18":{"tf":1.0},"34":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"113":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0}}}}},"y":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"<":{"'":{"_":{"df":3,"docs":{"113":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"44":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"104":{"tf":1.0},"40":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":7,"docs":{"104":{"tf":1.0},"114":{"tf":1.0},"40":{"tf":1.4142135623730951},"42":{"tf":2.0},"43":{"tf":2.0},"44":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}}}}},"s":{"df":0,"docs":{},"i":{"df":3,"docs":{"102":{"tf":1.0},"13":{"tf":1.0},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"106":{"tf":1.0},"114":{"tf":1.0},"118":{"tf":1.0},"13":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0},"95":{"tf":2.0}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"5":{"tf":1.0},"74":{"tf":1.0},"87":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"103":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"92":{"tf":1.0}}}}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"6":{"tf":1.0},"69":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"46":{"tf":1.0},"78":{"tf":1.0}}}}}}},"df":4,"docs":{"78":{"tf":1.0},"8":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":3.0}}}},"df":0,"docs":{}}}},"i":{"b":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"105":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"117":{"tf":1.0},"8":{"tf":1.7320508075688772}}}}}},"v":{"df":1,"docs":{"5":{"tf":1.0}}}},"m":{"df":0,"docs":{},"t":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"110":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"43":{"tf":1.0},"44":{"tf":1.0}}}},"t":{"df":4,"docs":{"32":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":5,"docs":{"105":{"tf":2.23606797749979},"110":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"80":{"tf":1.0}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":7,"docs":{"15":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951},"47":{"tf":1.0},"5":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"95":{"tf":1.0}},"e":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{}}}}},"d":{"df":4,"docs":{"100":{"tf":1.0},"110":{"tf":1.0},"117":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":3,"docs":{"18":{"tf":1.0},"8":{"tf":1.7320508075688772},"95":{"tf":1.0}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":4,"docs":{"104":{"tf":1.0},"66":{"tf":1.0},"79":{"tf":1.0},"95":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"44":{"tf":1.0},"45":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"57":{"tf":1.0},"61":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"103":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"52":{"tf":1.0},"67":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"8":{"tf":1.0}}},"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":5,"docs":{"110":{"tf":2.6457513110645907},"111":{"tf":2.0},"112":{"tf":1.4142135623730951},"57":{"tf":1.0},"8":{"tf":2.23606797749979}}}},"v":{"df":2,"docs":{"18":{"tf":1.0},"19":{"tf":1.0}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"39":{"tf":1.0},"7":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"118":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"8":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":7,"docs":{"18":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":3,"docs":{"17":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"96":{"tf":1.0},"98":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"c":{"df":7,"docs":{"115":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"7":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":2,"docs":{"118":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":10,"docs":{"102":{"tf":1.0},"113":{"tf":1.0},"118":{"tf":1.0},"15":{"tf":1.0},"5":{"tf":1.7320508075688772},"65":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"118":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"78":{"tf":1.0},"94":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"56":{"tf":1.4142135623730951},"57":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":31,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":2.23606797749979},"106":{"tf":2.23606797749979},"107":{"tf":1.0},"111":{"tf":1.7320508075688772},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"115":{"tf":2.449489742783178},"117":{"tf":1.0},"118":{"tf":2.23606797749979},"26":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"45":{"tf":1.7320508075688772},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.7320508075688772},"5":{"tf":2.449489742783178},"58":{"tf":1.0},"6":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"7":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":2.6457513110645907},"9":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"82":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"110":{"tf":1.0}}}}}},"df":1,"docs":{"8":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"36":{"tf":1.0},"46":{"tf":1.0},"51":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":8,"docs":{"114":{"tf":1.4142135623730951},"23":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"t":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"104":{"tf":1.0},"44":{"tf":1.0},"66":{"tf":2.23606797749979},"78":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"106":{"tf":1.4142135623730951},"66":{"tf":2.6457513110645907}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":12,"docs":{"104":{"tf":1.0},"106":{"tf":1.0},"113":{"tf":1.0},"15":{"tf":1.0},"26":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.7320508075688772},"95":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"89":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"114":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":9,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"40":{"tf":1.0},"53":{"tf":1.0},"79":{"tf":1.0},"86":{"tf":1.0},"93":{"tf":1.0}}}},"n":{"df":3,"docs":{"104":{"tf":1.0},"108":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"115":{"tf":1.0},"59":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"r":{"(":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"(":{"_":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"110":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"118":{"tf":1.0}}}}}}},".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"102":{"tf":1.7320508075688772},"113":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"104":{"tf":1.0}}}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"'":{"_":{"df":7,"docs":{"45":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"113":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"118":{"tf":1.0}}}}}}},"df":1,"docs":{"118":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"55":{"tf":1.4142135623730951},"61":{"tf":1.0}}},"y":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"55":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":18,"docs":{"104":{"tf":1.7320508075688772},"105":{"tf":3.872983346207417},"106":{"tf":2.0},"110":{"tf":1.0},"111":{"tf":1.4142135623730951},"113":{"tf":2.0},"117":{"tf":1.0},"118":{"tf":3.0},"45":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"60":{"tf":1.0},"61":{"tf":2.0},"62":{"tf":2.0},"63":{"tf":1.0},"64":{"tf":2.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":22,"docs":{"101":{"tf":1.0},"102":{"tf":1.7320508075688772},"103":{"tf":2.449489742783178},"104":{"tf":1.4142135623730951},"105":{"tf":3.0},"106":{"tf":2.8284271247461903},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"12":{"tf":1.0},"47":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"56":{"tf":2.0},"60":{"tf":1.0},"61":{"tf":2.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"113":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.7320508075688772},"7":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"115":{"tf":1.0},"30":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"!":{"(":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":2,"docs":{"43":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"0":{"df":3,"docs":{"78":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951}}},"3":{"2":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"e":{"df":3,"docs":{"93":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.7320508075688772}}},"t":{"df":3,"docs":{"114":{"tf":1.0},"43":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":5,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.4142135623730951},"74":{"tf":1.0},"80":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"74":{"tf":1.0}}}}}},"s":{"df":18,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.7320508075688772},"112":{"tf":1.0},"115":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"18":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.4142135623730951},"44":{"tf":1.0},"5":{"tf":2.0},"52":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"8":{"tf":4.242640687119285},"94":{"tf":1.4142135623730951}}}},"r":{"df":1,"docs":{"42":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"42":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":6,"docs":{"101":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"45":{"tf":2.0},"68":{"tf":1.0},"7":{"tf":2.449489742783178}},"e":{"(":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"d":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":3,"docs":{"14":{"tf":1.0},"30":{"tf":1.0},"5":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"25":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":1,"docs":{"71":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"94":{"tf":1.0}}}}}},"f":{"df":1,"docs":{"71":{"tf":1.0}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":3,"docs":{"45":{"tf":1.4142135623730951},"52":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":21,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"26":{"tf":2.0},"35":{"tf":2.0},"36":{"tf":4.0},"37":{"tf":2.0},"38":{"tf":1.0},"40":{"tf":1.7320508075688772},"44":{"tf":1.0},"45":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":2.0},"69":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"71":{"tf":1.0},"78":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"80":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"94":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":5,"docs":{"113":{"tf":1.4142135623730951},"118":{"tf":1.7320508075688772},"78":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"48":{"tf":1.0},"78":{"tf":1.0}}}},"d":{"df":19,"docs":{"102":{"tf":1.0},"117":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":2,"docs":{"100":{"tf":1.0},"114":{"tf":1.0}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"94":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":29,"docs":{"100":{"tf":1.0},"102":{"tf":1.0},"106":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.4142135623730951},"114":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.0},"18":{"tf":1.0},"22":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.4142135623730951},"56":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"74":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}}}},"t":{"df":4,"docs":{"34":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"78":{"tf":1.0}}},"x":{"df":15,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"16":{"tf":1.0},"18":{"tf":1.0},"23":{"tf":1.4142135623730951},"26":{"tf":1.0},"28":{"tf":1.0},"37":{"tf":1.4142135623730951},"5":{"tf":1.0},"69":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"78":{"tf":2.0},"94":{"tf":1.4142135623730951},"95":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"/":{"a":{"d":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"35":{"tf":1.0},"7":{"tf":1.0}}},"t":{"df":2,"docs":{"103":{"tf":1.0},"106":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"102":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"t":{"df":3,"docs":{"27":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0}}}},"n":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"43":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":24,"docs":{"104":{"tf":1.0},"106":{"tf":1.0},"112":{"tf":1.4142135623730951},"113":{"tf":1.4142135623730951},"115":{"tf":1.0},"118":{"tf":1.4142135623730951},"30":{"tf":1.0},"36":{"tf":3.1622776601683795},"43":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772},"45":{"tf":2.0},"5":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{":":{":":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"(":{"_":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}},"<":{"'":{"_":{"df":2,"docs":{"43":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"12":{"tf":1.0},"93":{"tf":1.0}}}}},"df":1,"docs":{"36":{"tf":1.0}},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"52":{"tf":1.0}}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"95":{"tf":1.0}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":33,"docs":{"102":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"106":{"tf":1.7320508075688772},"109":{"tf":1.4142135623730951},"110":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"25":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.7320508075688772},"40":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.4142135623730951},"8":{"tf":1.0},"85":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"95":{"tf":1.7320508075688772}}}}}},"o":{"!":{"(":{"\"":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"x":{"df":1,"docs":{"58":{"tf":1.0}}}},".":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}}},"_":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"34":{"tf":1.0},"40":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0}}}},"df":0,"docs":{}}}}},"d":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"36":{"tf":1.0}}},"df":12,"docs":{"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"32":{"tf":1.0},"36":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"48":{"tf":1.0},"66":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"40":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"c":{"df":3,"docs":{"31":{"tf":1.0},"69":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"g":{"df":2,"docs":{"77":{"tf":1.0},"79":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.0}}}}}}}},"k":{"df":3,"docs":{"25":{"tf":1.4142135623730951},"71":{"tf":1.0},"80":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"27":{"tf":1.4142135623730951},"49":{"tf":1.7320508075688772},"52":{"tf":1.0},"67":{"tf":1.0},"8":{"tf":2.0},"86":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.0}}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"118":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"df":16,"docs":{"107":{"tf":1.0},"110":{"tf":1.4142135623730951},"112":{"tf":1.0},"118":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.4142135623730951},"64":{"tf":1.0},"7":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":4,"docs":{"30":{"tf":1.0},"5":{"tf":1.4142135623730951},"94":{"tf":1.7320508075688772},"96":{"tf":1.0}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"s":{"d":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":4,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"30":{"tf":1.0},"5":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"115":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"53":{"tf":1.0},"66":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"44":{"tf":1.0},"5":{"tf":1.0},"63":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}},"i":{"df":1,"docs":{"8":{"tf":2.0}}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":17,"docs":{"104":{"tf":1.0},"118":{"tf":1.7320508075688772},"32":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":2.0},"44":{"tf":1.4142135623730951},"48":{"tf":1.0},"53":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"64":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":3.0}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"115":{"tf":1.0},"36":{"tf":1.0},"59":{"tf":1.0},"65":{"tf":1.0},"7":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":7,"docs":{"113":{"tf":1.0},"115":{"tf":1.4142135623730951},"118":{"tf":1.7320508075688772},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.7320508075688772},"94":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":19,"docs":{"115":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"15":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":2.23606797749979},"37":{"tf":1.0},"40":{"tf":1.0},"46":{"tf":1.4142135623730951},"5":{"tf":1.0},"52":{"tf":2.0},"6":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.4142135623730951},"68":{"tf":1.0},"8":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.4142135623730951}}}}},"t":{"df":8,"docs":{"22":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.4142135623730951},"96":{"tf":1.0}}}},"i":{"b":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{},"t":{"@":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{":":{"<":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"25":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":16,"docs":{"25":{"tf":2.449489742783178},"27":{"tf":1.0},"28":{"tf":1.0},"69":{"tf":2.6457513110645907},"70":{"tf":1.7320508075688772},"71":{"tf":2.23606797749979},"72":{"tf":1.4142135623730951},"74":{"tf":3.3166247903554},"75":{"tf":2.0},"78":{"tf":1.0},"80":{"tf":2.449489742783178},"81":{"tf":2.23606797749979},"82":{"tf":1.4142135623730951},"83":{"tf":1.7320508075688772},"84":{"tf":1.0},"95":{"tf":1.0}},"h":{"df":0,"docs":{},"u":{"b":{"df":3,"docs":{"19":{"tf":1.4142135623730951},"74":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"l":{"a":{"b":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":14,"docs":{"105":{"tf":2.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"23":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.0}},"n":{"df":8,"docs":{"106":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"5":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"66":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"o":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"102":{"tf":1.4142135623730951}}}},"df":5,"docs":{"1":{"tf":1.0},"106":{"tf":1.0},"53":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0}},"o":{"d":{"df":8,"docs":{"10":{"tf":1.0},"118":{"tf":1.0},"23":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.0},"66":{"tf":1.0},"78":{"tf":1.4142135623730951},"92":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"2":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"3":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"117":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"p":{"df":3,"docs":{"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":14,"docs":{"10":{"tf":1.4142135623730951},"106":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":2.6457513110645907},"16":{"tf":1.7320508075688772},"17":{"tf":1.0},"35":{"tf":1.0},"5":{"tf":4.795831523312719},"7":{"tf":1.7320508075688772},"9":{"tf":1.0},"94":{"tf":1.4142135623730951}}}},"w":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"92":{"tf":1.0}}}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"23":{"tf":1.0},"68":{"tf":1.0},"94":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"df":11,"docs":{"104":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"43":{"tf":1.0},"53":{"tf":1.4142135623730951},"60":{"tf":1.0},"68":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"95":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"34":{"tf":1.0},"40":{"tf":1.0},"49":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"h":{"a":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"23":{"tf":1.0},"24":{"tf":1.7320508075688772},"31":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"113":{"tf":1.0},"41":{"tf":1.0},"95":{"tf":1.0}},"l":{"df":4,"docs":{"117":{"tf":1.0},"34":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"84":{"tf":1.0},"94":{"tf":1.0}}}}}},"r":{"d":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":8,"docs":{"102":{"tf":1.7320508075688772},"106":{"tf":1.0},"115":{"tf":1.0},"31":{"tf":1.0},"81":{"tf":1.0},"92":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":3,"docs":{"74":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0}}},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"106":{"tf":1.0},"42":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":3,"docs":{"100":{"tf":1.0},"103":{"tf":1.0},"87":{"tf":1.0}},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":4,"docs":{"78":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.0}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"116":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"21":{"tf":1.0}}}},"p":{"df":11,"docs":{"0":{"tf":1.0},"18":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"9":{"tf":1.0},"95":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":19,"docs":{"105":{"tf":1.0},"107":{"tf":1.0},"110":{"tf":1.4142135623730951},"112":{"tf":1.0},"21":{"tf":1.0},"32":{"tf":1.0},"40":{"tf":1.4142135623730951},"43":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.4142135623730951},"58":{"tf":1.0},"61":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0},"98":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"106":{"tf":1.0}},"i":{"df":2,"docs":{"115":{"tf":1.0},"35":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"h":{"df":5,"docs":{"23":{"tf":1.0},"30":{"tf":1.0},"47":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}}}}},"r":{"'":{"df":1,"docs":{"115":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"<":{"'":{"_":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"58":{"tf":2.0}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"58":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":11,"docs":{"102":{"tf":2.0},"109":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.4142135623730951},"114":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"47":{"tf":1.4142135623730951},"55":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"94":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"u":{"df":1,"docs":{"23":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"27":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"3":{"0":{"0":{"0":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"<":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"74":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"25":{"tf":1.0},"70":{"tf":1.0},"75":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"'":{"d":{"df":1,"docs":{"113":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":1,"docs":{"116":{"tf":1.0}}},"v":{"df":1,"docs":{"116":{"tf":1.0}}}},".":{"df":1,"docs":{"8":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"j":{"df":1,"docs":{"112":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"c":{"df":3,"docs":{"30":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.4142135623730951}}},"d":{"df":2,"docs":{"23":{"tf":1.0},"64":{"tf":1.4142135623730951}},"e":{"a":{"df":4,"docs":{"0":{"tf":1.0},"118":{"tf":1.4142135623730951},"23":{"tf":1.0},"78":{"tf":1.4142135623730951}},"l":{"df":2,"docs":{"77":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":3,"docs":{"105":{"tf":1.0},"44":{"tf":1.4142135623730951},"8":{"tf":2.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"43":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"14":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"'":{"df":1,"docs":{"105":{"tf":1.0}}},"(":{"_":{"df":3,"docs":{"105":{"tf":2.8284271247461903},"113":{"tf":1.4142135623730951},"118":{"tf":1.7320508075688772}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"110":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"102":{"tf":1.4142135623730951},"113":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"_":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"118":{"tf":1.0}}}}}}},"df":1,"docs":{"118":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"102":{"tf":1.0},"105":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"_":{"df":1,"docs":{"118":{"tf":2.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"118":{"tf":1.0}}}}}}},"df":2,"docs":{"110":{"tf":1.0},"118":{"tf":1.0}}}}},"s":{"_":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"44":{"tf":1.0},"66":{"tf":1.0},"8":{"tf":2.449489742783178}}}}}},"m":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"103":{"tf":1.0}}}},"l":{"<":{"'":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"x":{"df":3,"docs":{"45":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"65":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"!":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":13,"docs":{"104":{"tf":1.0},"112":{"tf":1.0},"36":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"52":{"tf":2.449489742783178},"56":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":25,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"107":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"112":{"tf":2.8284271247461903},"113":{"tf":1.4142135623730951},"114":{"tf":2.23606797749979},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":3.1622776601683795},"36":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.4142135623730951},"91":{"tf":1.0},"94":{"tf":2.23606797749979},"95":{"tf":1.7320508075688772}},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"64":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"53":{"tf":1.0},"64":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"<":{"'":{"_":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":10,"docs":{"117":{"tf":1.0},"40":{"tf":1.4142135623730951},"42":{"tf":1.0},"5":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":1.0},"8":{"tf":2.449489742783178},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"115":{"tf":1.0},"66":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":13,"docs":{"0":{"tf":1.0},"102":{"tf":1.0},"118":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"78":{"tf":1.4142135623730951},"89":{"tf":1.0},"91":{"tf":1.4142135623730951},"94":{"tf":2.0},"95":{"tf":2.23606797749979}}}}}}},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"(":{"#":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":16,"docs":{"0":{"tf":1.0},"19":{"tf":1.0},"24":{"tf":1.0},"37":{"tf":1.0},"5":{"tf":1.7320508075688772},"50":{"tf":1.0},"51":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.7320508075688772},"8":{"tf":2.0},"82":{"tf":1.0},"94":{"tf":1.0}},"e":{"!":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"a":{"df":0,"docs":{},"t":{"!":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"!":{"(":{"\"":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"113":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"13":{"tf":1.0},"69":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"56":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"102":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"x":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"i":{"c":{"df":2,"docs":{"104":{"tf":1.0},"8":{"tf":1.7320508075688772}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"95":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":18,"docs":{"103":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.0},"17":{"tf":1.0},"27":{"tf":1.0},"34":{"tf":1.0},"42":{"tf":1.7320508075688772},"43":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.4142135623730951},"88":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"67":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"40":{"tf":1.0},"45":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"102":{"tf":1.4142135623730951},"113":{"tf":1.0}}},"df":0,"docs":{}}}},"df":3,"docs":{"113":{"tf":1.4142135623730951},"115":{"tf":1.0},"118":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":1,"docs":{"111":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":5,"docs":{"39":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"103":{"tf":1.0},"116":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":9,"docs":{"1":{"tf":2.23606797749979},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"24":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":2.8284271247461903},"4":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"87":{"tf":1.7320508075688772}}},"n":{"c":{"df":3,"docs":{"56":{"tf":1.0},"57":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":10,"docs":{"103":{"tf":1.4142135623730951},"106":{"tf":1.0},"11":{"tf":1.0},"118":{"tf":1.0},"15":{"tf":1.0},"35":{"tf":1.4142135623730951},"48":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"(":{"_":{"df":3,"docs":{"105":{"tf":1.0},"106":{"tf":1.0},"118":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"u":{"1":{"2":{"8":{"df":1,"docs":{"110":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"115":{"tf":1.0},"57":{"tf":1.0}},"e":{"df":0,"docs":{},"g":{"df":2,"docs":{"105":{"tf":1.0},"106":{"tf":1.7320508075688772}},"r":{"df":3,"docs":{"114":{"tf":1.0},"18":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"j":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}}}}},"n":{"d":{"df":3,"docs":{"106":{"tf":1.0},"26":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":2,"docs":{"15":{"tf":1.0},"5":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":9,"docs":{"17":{"tf":1.0},"21":{"tf":1.4142135623730951},"23":{"tf":1.0},"36":{"tf":1.0},"56":{"tf":1.0},"7":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}}}},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"30":{"tf":1.4142135623730951},"47":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":9,"docs":{"102":{"tf":1.0},"30":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.4142135623730951},"8":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":5,"docs":{"101":{"tf":1.0},"109":{"tf":1.0},"115":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"94":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"69":{"tf":1.0},"8":{"tf":1.0}}}}}}},"o":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"v":{"4":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"6":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"94":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}}}}},"s":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"df":1,"docs":{"56":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":1,"docs":{"56":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"112":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"(":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"64":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"(":{"c":{"df":0,"docs":{},"x":{"df":2,"docs":{"63":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"53":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"(":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"63":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"<":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":4,"docs":{"109":{"tf":1.7320508075688772},"112":{"tf":2.23606797749979},"114":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"106":{"tf":1.0},"111":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":9,"docs":{"0":{"tf":1.0},"115":{"tf":1.0},"5":{"tf":1.4142135623730951},"78":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":2.23606797749979},"96":{"tf":2.8284271247461903}},"e":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"t":{"'":{"df":13,"docs":{"102":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"106":{"tf":1.0},"110":{"tf":1.0},"113":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"39":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"95":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":11,"docs":{"100":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":2.23606797749979},"64":{"tf":2.6457513110645907},"65":{"tf":1.0},"8":{"tf":2.0}}},"r":{"df":2,"docs":{"36":{"tf":1.0},"64":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":7,"docs":{"115":{"tf":1.4142135623730951},"118":{"tf":1.0},"15":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0}}}}}}}},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"b":{"df":3,"docs":{"13":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.7320508075688772}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":2,"docs":{"55":{"tf":1.0},"61":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"16":{"tf":1.0},"73":{"tf":1.0}}}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":5,"docs":{"36":{"tf":1.0},"5":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"78":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}}}},"i":{"b":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"102":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.7320508075688772},"61":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":6,"docs":{"104":{"tf":1.0},"115":{"tf":1.7320508075688772},"117":{"tf":1.0},"14":{"tf":1.0},"58":{"tf":1.0},"95":{"tf":1.0}},"n":{"df":3,"docs":{"103":{"tf":1.0},"115":{"tf":1.0},"95":{"tf":1.0}}}}}}},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"43":{"tf":1.0},"78":{"tf":1.7320508075688772}}}}},"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"53":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"73":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"#":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"46":{"tf":1.0}}}}}},"/":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"71":{"tf":1.0},"75":{"tf":1.0}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":14,"docs":{"25":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"68":{"tf":2.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":2.0},"72":{"tf":2.0},"75":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"95":{"tf":1.0}}}}}}},"df":2,"docs":{"63":{"tf":1.4142135623730951},"64":{"tf":2.23606797749979}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{":":{":":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"a":{"df":0,"docs":{},"g":{"df":7,"docs":{"101":{"tf":1.0},"103":{"tf":1.4142135623730951},"118":{"tf":2.23606797749979},"16":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"8":{"tf":2.0}},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"k":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"b":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"105":{"tf":1.4142135623730951},"40":{"tf":1.0},"45":{"tf":1.0},"63":{"tf":1.0},"80":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"/":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"55":{"tf":1.0},"61":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"<":{"'":{"_":{"df":5,"docs":{"56":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0}}},"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"x":{"df":3,"docs":{"45":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":3,"docs":{"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"61":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"<":{"'":{"_":{"df":5,"docs":{"56":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0}}},"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"x":{"df":3,"docs":{"45":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":4,"docs":{"42":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"114":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"r":{"df":6,"docs":{"104":{"tf":1.0},"113":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"93":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"19":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"68":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0}}}},"x":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.0}}}}}},"y":{"df":1,"docs":{"91":{"tf":1.0}}}},"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"d":{"df":3,"docs":{"113":{"tf":1.0},"118":{"tf":1.0},"94":{"tf":1.4142135623730951}}},"df":0,"docs":{},"v":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{".":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":3,"docs":{"115":{"tf":1.0},"18":{"tf":1.0},"67":{"tf":1.0}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"42":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}},"t":{"'":{"df":5,"docs":{"36":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.4142135623730951},"56":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":13,"docs":{"0":{"tf":1.7320508075688772},"104":{"tf":1.0},"108":{"tf":1.0},"23":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"40":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":2.0},"58":{"tf":1.0},"7":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.0}}}}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":1,"docs":{"52":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"103":{"tf":1.0},"113":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":2.0}}}}},"n":{"df":0,"docs":{},"e":{"df":7,"docs":{"40":{"tf":1.0},"5":{"tf":1.4142135623730951},"66":{"tf":1.0},"69":{"tf":1.0},"8":{"tf":1.7320508075688772},"85":{"tf":1.4142135623730951},"94":{"tf":1.0}}},"k":{"df":7,"docs":{"31":{"tf":1.0},"39":{"tf":1.0},"53":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"7":{"tf":1.0},"78":{"tf":1.7320508075688772}},"e":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"t":{"'":{"df":2,"docs":{"32":{"tf":1.0},"45":{"tf":1.4142135623730951}}},"(":{"df":1,"docs":{"7":{"tf":1.0}}},"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"52":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"24":{"tf":1.0},"28":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":63,"docs":{"0":{"tf":3.3166247903554},"10":{"tf":2.23606797749979},"101":{"tf":1.0},"102":{"tf":3.1622776601683795},"103":{"tf":1.0},"104":{"tf":1.0},"106":{"tf":2.449489742783178},"107":{"tf":1.4142135623730951},"11":{"tf":3.0},"112":{"tf":1.0},"113":{"tf":2.23606797749979},"114":{"tf":2.449489742783178},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":3.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.4142135623730951},"14":{"tf":2.0},"15":{"tf":1.7320508075688772},"16":{"tf":2.449489742783178},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"23":{"tf":2.6457513110645907},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"32":{"tf":3.872983346207417},"34":{"tf":2.23606797749979},"35":{"tf":3.1622776601683795},"36":{"tf":3.3166247903554},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":3.7416573867739413},"41":{"tf":3.1622776601683795},"42":{"tf":2.449489742783178},"43":{"tf":2.8284271247461903},"44":{"tf":2.6457513110645907},"45":{"tf":3.0},"46":{"tf":2.23606797749979},"47":{"tf":1.4142135623730951},"48":{"tf":2.8284271247461903},"5":{"tf":5.477225575051661},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":3.605551275463989},"53":{"tf":2.449489742783178},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"66":{"tf":2.449489742783178},"7":{"tf":4.69041575982343},"73":{"tf":1.0},"78":{"tf":2.23606797749979},"8":{"tf":4.358898943540674},"89":{"tf":1.4142135623730951},"9":{"tf":3.1622776601683795},"94":{"tf":3.605551275463989},"95":{"tf":2.6457513110645907},"96":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"116":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"94":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"39":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":17,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"118":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.4142135623730951},"36":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.4142135623730951},"52":{"tf":1.0},"64":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":3.7416573867739413},"9":{"tf":1.0},"95":{"tf":1.4142135623730951},"96":{"tf":1.0}}}},"t":{"(":{"!":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"_":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"_":{"#":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"106":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},")":{"*":{"#":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"106":{"tf":1.0}}}}}},"df":0,"docs":{}},"+":{"#":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"117":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"{":{"1":{"0":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}},"5":{",":{"1":{"0":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":3,"docs":{"105":{"tf":1.4142135623730951},"111":{"tf":1.0},"117":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"110":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"_":{")":{")":{"df":0,"docs":{},"{":{"1":{"0":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"105":{"tf":1.7320508075688772},"111":{"tf":1.0}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":3,"docs":{"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951}},"e":{")":{")":{"df":0,"docs":{},"{":{"2":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"105":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"(":{"'":{"df":0,"docs":{},"x":{"'":{")":{")":{"df":0,"docs":{},"{":{"2":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"105":{"tf":1.0}}}},"_":{"#":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"105":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{")":{"#":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{")":{"#":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"106":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},")":{"#":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"105":{"tf":1.0}}}}}},")":{"#":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"105":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"_":{"#":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"105":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},")":{")":{"#":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"105":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"102":{"tf":1.0}}},"df":0,"docs":{}}}},":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":6,"docs":{"105":{"tf":2.23606797749979},"106":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":2.0},"112":{"tf":1.4142135623730951},"118":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":4.123105625617661},"106":{"tf":2.6457513110645907},"117":{"tf":1.4142135623730951},"118":{"tf":1.7320508075688772},"8":{"tf":2.23606797749979}}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":12,"docs":{"11":{"tf":1.0},"20":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"80":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.0}}},"t":{"df":2,"docs":{"32":{"tf":1.0},"35":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":4,"docs":{"28":{"tf":1.4142135623730951},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}},"i":{"c":{"df":4,"docs":{"103":{"tf":1.0},"32":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"89":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":18,"docs":{"102":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.4142135623730951},"115":{"tf":1.7320508075688772},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"24":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.7320508075688772},"64":{"tf":1.0},"78":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"96":{"tf":1.0}}},"s":{"df":1,"docs":{"95":{"tf":1.0}}}},"t":{"df":8,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.7320508075688772},"118":{"tf":1.0},"53":{"tf":1.0},"66":{"tf":1.0}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"109":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"45":{"tf":1.0},"8":{"tf":1.0}}}}}}},"m":{"!":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}},"a":{"c":{"df":1,"docs":{"66":{"tf":1.0}},"o":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}}}},"df":13,"docs":{"102":{"tf":1.0},"104":{"tf":1.7320508075688772},"106":{"tf":1.4142135623730951},"111":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":1.0},"66":{"tf":3.605551275463989},"8":{"tf":3.0}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"e":{"df":6,"docs":{"21":{"tf":1.0},"28":{"tf":1.0},"68":{"tf":1.0},"8":{"tf":1.0},"88":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"109":{"tf":1.0},"36":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"115":{"tf":1.0},"67":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"102":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":34,"docs":{"102":{"tf":1.0},"106":{"tf":1.0},"114":{"tf":1.4142135623730951},"118":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.4142135623730951},"27":{"tf":1.0},"28":{"tf":1.0},"37":{"tf":1.0},"42":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":2.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"78":{"tf":2.0},"80":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"89":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.7320508075688772}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"1":{"tf":1.0},"94":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":4,"docs":{"5":{"tf":1.0},"56":{"tf":1.0},"8":{"tf":2.0},"94":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"36":{"tf":1.7320508075688772},"8":{"tf":1.0}}}}}}},"u":{"a":{"df":0,"docs":{},"l":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"i":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"45":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"df":10,"docs":{"103":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"32":{"tf":1.0},"38":{"tf":1.4142135623730951},"41":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.4142135623730951},"69":{"tf":1.0},"78":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"45":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"y":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"p":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"64":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"40":{"tf":1.0},"7":{"tf":1.0}}},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":3,"docs":{"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"25":{"tf":2.23606797749979},"72":{"tf":1.7320508075688772},"78":{"tf":1.0},"80":{"tf":2.23606797749979}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"(":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"63":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":20,"docs":{"102":{"tf":2.0},"103":{"tf":2.6457513110645907},"104":{"tf":2.449489742783178},"105":{"tf":5.477225575051661},"106":{"tf":3.4641016151377544},"109":{"tf":1.0},"112":{"tf":2.23606797749979},"113":{"tf":2.6457513110645907},"114":{"tf":1.4142135623730951},"115":{"tf":2.0},"117":{"tf":2.8284271247461903},"118":{"tf":2.6457513110645907},"39":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"57":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"66":{"tf":1.0},"8":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"s":{"!":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"x":{"df":1,"docs":{"8":{"tf":3.1622776601683795}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"18":{"tf":1.0},"8":{"tf":4.123105625617661}}}}}}},"y":{"b":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}},"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":4,"docs":{"86":{"tf":1.4142135623730951},"87":{"tf":2.0},"88":{"tf":1.7320508075688772},"95":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":3,"docs":{"66":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":12,"docs":{"10":{"tf":1.0},"102":{"tf":1.0},"105":{"tf":1.0},"114":{"tf":1.0},"12":{"tf":1.0},"30":{"tf":1.4142135623730951},"42":{"tf":1.0},"5":{"tf":1.0},"58":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"95":{"tf":2.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"43":{"tf":1.0},"44":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}}},"t":{"df":1,"docs":{"5":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"68":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"95":{"tf":2.0},"96":{"tf":1.0}}}},"m":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"5":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0},"91":{"tf":1.4142135623730951},"92":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":3.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"91":{"tf":1.0}}}}}}}}}},"r":{"df":0,"docs":{},"g":{"df":10,"docs":{"29":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"71":{"tf":2.0},"75":{"tf":1.0},"78":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"84":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"26":{"tf":1.0},"43":{"tf":2.0},"7":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":16,"docs":{"36":{"tf":1.7320508075688772},"41":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":2.0},"62":{"tf":2.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.7320508075688772},"8":{"tf":2.23606797749979}}},"df":0,"docs":{}}}}},"i":{"b":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"w":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"1":{"tf":1.0},"36":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":4,"docs":{"32":{"tf":1.0},"45":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"115":{"tf":1.0},"77":{"tf":1.0}}}}},"r":{"df":1,"docs":{"30":{"tf":1.0}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"0":{"tf":1.0}}},"x":{"df":3,"docs":{"113":{"tf":1.0},"115":{"tf":1.0},"8":{"tf":1.7320508075688772}}}},"m":{"df":2,"docs":{"71":{"tf":1.0},"85":{"tf":2.0}}},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}}},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"38":{"tf":1.0}},"i":{"df":4,"docs":{"114":{"tf":1.0},"26":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":3,"docs":{"59":{"tf":1.0},"60":{"tf":1.0},"7":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"52":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":29,"docs":{"0":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.7320508075688772},"28":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"5":{"tf":1.7320508075688772},"58":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.7320508075688772},"9":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.7320508075688772},"94":{"tf":2.23606797749979},"95":{"tf":3.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"102":{"tf":1.7320508075688772},"92":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"23":{"tf":1.0},"78":{"tf":1.7320508075688772}}}}},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}}}}},"df":0,"docs":{}},"_":{"1":{"_":{"4":{"4":{"df":1,"docs":{"45":{"tf":1.0}}},"5":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":4,"docs":{"32":{"tf":1.0},"45":{"tf":4.358898943540674},"7":{"tf":2.449489742783178},"8":{"tf":1.4142135623730951}},"s":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"0":{"tf":1.0},"117":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"94":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":9,"docs":{"106":{"tf":1.0},"117":{"tf":1.4142135623730951},"118":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"45":{"tf":1.0}}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.7320508075688772}},"e":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"y":{"_":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"104":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"104":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"106":{"tf":1.0}}}}}}},"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}}}}}}},"df":1,"docs":{"106":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}}}}}}},"df":1,"docs":{"106":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}}}}}}},"df":1,"docs":{"106":{"tf":1.0}}}}}},"df":5,"docs":{"104":{"tf":1.7320508075688772},"105":{"tf":4.0},"106":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"104":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"56":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.0}}}}}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},">":{"(":{"<":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"105":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"74":{"tf":1.0}}}}}}},"df":0,"docs":{}},"d":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"110":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":25,"docs":{"101":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":2.6457513110645907},"106":{"tf":3.3166247903554},"111":{"tf":1.0},"115":{"tf":2.23606797749979},"117":{"tf":1.0},"19":{"tf":1.4142135623730951},"32":{"tf":1.0},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":2.449489742783178},"42":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772},"44":{"tf":2.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"7":{"tf":2.23606797749979},"70":{"tf":1.0},"74":{"tf":1.4142135623730951},"8":{"tf":3.7416573867739413}},"s":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"106":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"n":{"df":1,"docs":{"8":{"tf":2.0}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"103":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"b":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":8,"docs":{"26":{"tf":1.0},"67":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":2.0},"87":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":29,"docs":{"106":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"12":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.4142135623730951},"36":{"tf":2.0},"40":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":1.4142135623730951},"47":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"56":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"7":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.7320508075688772},"8":{"tf":1.0},"94":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"g":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"118":{"tf":1.4142135623730951},"5":{"tf":1.0},"8":{"tf":1.0}}}},"df":3,"docs":{"15":{"tf":1.0},"30":{"tf":1.0},"5":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"102":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"71":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"73":{"tf":1.0}}}}},"w":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"45":{"tf":1.0}}}}}}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"27":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"41":{"tf":1.0}}}}}}},"df":24,"docs":{"0":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0},"18":{"tf":1.0},"23":{"tf":1.4142135623730951},"27":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"52":{"tf":2.0},"54":{"tf":1.0},"67":{"tf":1.4142135623730951},"71":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"85":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"95":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"t":{"df":8,"docs":{"35":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":8,"docs":{"18":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"40":{"tf":1.0},"49":{"tf":1.4142135623730951},"53":{"tf":1.0},"68":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"94":{"tf":1.4142135623730951}}}}}}}},"o":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"94":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"e":{"df":9,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":3.1622776601683795},"106":{"tf":2.6457513110645907},"112":{"tf":1.7320508075688772},"115":{"tf":2.449489742783178},"117":{"tf":1.0},"118":{"tf":1.0}},"i":{"d":{"df":2,"docs":{"43":{"tf":1.4142135623730951},"44":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":4,"docs":{"102":{"tf":1.0},"117":{"tf":1.0},"20":{"tf":1.0},"32":{"tf":1.0}},"e":{"df":10,"docs":{"102":{"tf":2.0},"104":{"tf":1.0},"105":{"tf":1.0},"110":{"tf":1.4142135623730951},"113":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":2.0}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"b":{"df":0,"docs":{},"r":{"a":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":28,"docs":{"1":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"110":{"tf":1.4142135623730951},"111":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0},"31":{"tf":1.0},"36":{"tf":2.0},"4":{"tf":1.0},"5":{"tf":2.0},"55":{"tf":1.4142135623730951},"6":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":2.23606797749979},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"78":{"tf":2.0},"79":{"tf":1.4142135623730951},"84":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}},"h":{"df":3,"docs":{"21":{"tf":1.0},"41":{"tf":1.0},"94":{"tf":1.0}}},"i":{"c":{"df":2,"docs":{"35":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"a":{"d":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"94":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":15,"docs":{"104":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"31":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"67":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"94":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"105":{"tf":1.0},"106":{"tf":1.0},"114":{"tf":1.0},"8":{"tf":2.8284271247461903},"83":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}}},"o":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}},"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}},"r":{"df":1,"docs":{"118":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":4,"docs":{"112":{"tf":1.4142135623730951},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"11":{"tf":1.0},"46":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":2,"docs":{"12":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{}}}},"k":{"df":1,"docs":{"8":{"tf":1.0}}},"l":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"n":{"c":{"df":5,"docs":{"36":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"69":{"tf":1.0},"78":{"tf":1.0}}},"df":20,"docs":{"103":{"tf":1.0},"106":{"tf":1.7320508075688772},"113":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":2.0},"21":{"tf":1.0},"23":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"5":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.7320508075688772},"91":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"92":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"p":{"df":1,"docs":{"118":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"df":13,"docs":{"100":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.4142135623730951},"69":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"78":{"tf":1.0},"80":{"tf":1.0},"88":{"tf":1.0},"95":{"tf":1.7320508075688772}},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"l":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}}}},"r":{"df":6,"docs":{"115":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951},"53":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"8":{"tf":2.23606797749979}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"11":{"tf":1.0},"44":{"tf":1.4142135623730951}}}}},"t":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"110":{"tf":1.4142135623730951},"118":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"110":{"tf":1.0}}}},"df":1,"docs":{"110":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"113":{"tf":1.0},"13":{"tf":1.4142135623730951},"6":{"tf":1.0}}},"o":{"df":0,"docs":{},"n":{"<":{"&":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"106":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"45":{"tf":1.0},"8":{"tf":1.0}}}}},"u":{"3":{"2":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":1,"docs":{"110":{"tf":1.0}}}}},"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":13,"docs":{"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"106":{"tf":1.0},"110":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.0},"31":{"tf":1.0},"5":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"118":{"tf":1.0},"15":{"tf":1.0},"20":{"tf":1.0},"41":{"tf":1.7320508075688772},"45":{"tf":1.0},"5":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"78":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"74":{"tf":1.4142135623730951},"75":{"tf":1.0},"80":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"113":{"tf":1.0},"24":{"tf":1.0},"7":{"tf":1.0},"78":{"tf":1.4142135623730951}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":3,"docs":{"104":{"tf":1.0},"52":{"tf":1.0},"80":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":14,"docs":{"11":{"tf":1.0},"113":{"tf":1.0},"15":{"tf":1.0},"25":{"tf":1.0},"31":{"tf":1.0},"4":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"78":{"tf":2.0},"80":{"tf":1.0},"84":{"tf":1.4142135623730951},"9":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":10,"docs":{"26":{"tf":1.4142135623730951},"36":{"tf":2.0},"38":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"80":{"tf":1.0},"94":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"10":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"0":{"tf":1.0},"23":{"tf":1.0},"46":{"tf":1.0},"67":{"tf":1.0},"89":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"31":{"tf":1.7320508075688772},"45":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":4,"docs":{"109":{"tf":1.0},"18":{"tf":1.0},"23":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}}}}}},"p":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"83":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"111":{"tf":1.4142135623730951},"65":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"s":{"df":4,"docs":{"109":{"tf":1.4142135623730951},"110":{"tf":1.0},"111":{"tf":1.4142135623730951},"115":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"115":{"tf":1.7320508075688772}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"111":{"tf":1.0}}}}}}},"t":{"df":13,"docs":{"102":{"tf":1.4142135623730951},"106":{"tf":1.7320508075688772},"109":{"tf":1.0},"117":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"16":{"tf":1.0},"40":{"tf":1.4142135623730951},"5":{"tf":1.0},"50":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"85":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"35":{"tf":1.0},"42":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":19,"docs":{"107":{"tf":1.0},"113":{"tf":1.0},"18":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.449489742783178},"42":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"7":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":2.6457513110645907}}},"t":{"df":2,"docs":{"25":{"tf":1.0},"78":{"tf":1.0}}}},"t":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":2,"docs":{"113":{"tf":1.0},"118":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"113":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"55":{"tf":1.0},"61":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"69":{"tf":1.4142135623730951},"7":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"d":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":6,"docs":{"31":{"tf":1.0},"39":{"tf":1.7320508075688772},"5":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"8":{"tf":2.6457513110645907}},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"64":{"tf":1.0}}}},":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"114":{"tf":1.0}}},"df":21,"docs":{"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"103":{"tf":2.23606797749979},"104":{"tf":3.605551275463989},"105":{"tf":4.795831523312719},"106":{"tf":3.872983346207417},"107":{"tf":1.7320508075688772},"109":{"tf":1.7320508075688772},"111":{"tf":2.449489742783178},"112":{"tf":1.7320508075688772},"113":{"tf":3.3166247903554},"114":{"tf":2.23606797749979},"115":{"tf":3.605551275463989},"116":{"tf":1.4142135623730951},"117":{"tf":2.6457513110645907},"118":{"tf":5.477225575051661},"46":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"8":{"tf":2.23606797749979}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":6,"docs":{"109":{"tf":2.0},"110":{"tf":2.23606797749979},"111":{"tf":1.7320508075688772},"112":{"tf":2.23606797749979},"115":{"tf":1.4142135623730951},"118":{"tf":1.7320508075688772}},"e":{"'":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"df":5,"docs":{"5":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0}},"e":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"15":{"tf":2.0},"40":{"tf":1.4142135623730951},"48":{"tf":1.0},"5":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"df":1,"docs":{"57":{"tf":1.0}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"5":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":2.449489742783178}}}}},"r":{"df":0,"docs":{},"f":{"df":2,"docs":{"0":{"tf":1.0},"13":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":7,"docs":{"113":{"tf":2.0},"13":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"43":{"tf":1.0},"68":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}}}},"i":{"b":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"c":{"df":0,"docs":{},"k":{"df":5,"docs":{"10":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"5":{"tf":1.4142135623730951},"74":{"tf":1.0}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"23":{"tf":1.0},"89":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"68":{"tf":1.0}},"g":{"df":1,"docs":{"71":{"tf":1.0}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":5,"docs":{"38":{"tf":1.0},"43":{"tf":1.0},"67":{"tf":1.0},"76":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}},"n":{"df":5,"docs":{"91":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.7320508075688772},"95":{"tf":1.0},"98":{"tf":1.0}},"e":{"df":1,"docs":{"95":{"tf":1.0}}}},"y":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"94":{"tf":1.0},"95":{"tf":1.0}}}}},"df":8,"docs":{"0":{"tf":1.0},"116":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.4142135623730951},"78":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"21":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"73":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.4142135623730951},"95":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"53":{"tf":1.0},"8":{"tf":1.7320508075688772}}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":2,"docs":{"92":{"tf":1.0},"94":{"tf":1.0}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":12,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"15":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"5":{"tf":1.7320508075688772},"52":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0},"78":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":12,"docs":{"106":{"tf":1.4142135623730951},"11":{"tf":1.0},"113":{"tf":1.4142135623730951},"115":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"5":{"tf":1.0},"63":{"tf":1.4142135623730951},"67":{"tf":1.0},"84":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"113":{"tf":1.0},"118":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":17,"docs":{"101":{"tf":1.0},"24":{"tf":1.0},"29":{"tf":1.4142135623730951},"32":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":2.23606797749979},"78":{"tf":3.3166247903554},"80":{"tf":1.7320508075688772},"81":{"tf":1.0},"95":{"tf":1.7320508075688772}},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"115":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":1,"docs":{"19":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"5":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"40":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"12":{"tf":1.0}}}}},"s":{"df":1,"docs":{"96":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"100":{"tf":1.0},"26":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"15":{"tf":1.0},"18":{"tf":1.0},"5":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"94":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":8,"docs":{"109":{"tf":1.0},"112":{"tf":1.0},"28":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.4142135623730951},"81":{"tf":1.0},"85":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"56":{"tf":1.0},"61":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{")":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":4,"docs":{"32":{"tf":1.0},"39":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"56":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"38":{"tf":1.0}}},"df":1,"docs":{"8":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"116":{"tf":1.0},"97":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}},"i":{"df":1,"docs":{"96":{"tf":1.7320508075688772}}}}}}}},"o":{"b":{"a":{"b":{"df":0,"docs":{},"l":{"df":7,"docs":{"115":{"tf":1.0},"21":{"tf":1.0},"32":{"tf":1.0},"53":{"tf":1.0},"79":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"94":{"tf":1.0},"95":{"tf":1.0}}}},"df":4,"docs":{"113":{"tf":1.0},"115":{"tf":2.0},"117":{"tf":1.0},"18":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":11,"docs":{"36":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"71":{"tf":1.4142135623730951},"91":{"tf":1.0},"92":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"95":{"tf":3.0},"96":{"tf":1.0},"98":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":7,"docs":{"106":{"tf":1.0},"16":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"6":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.4142135623730951}},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"115":{"tf":1.4142135623730951},"118":{"tf":1.0}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}},"df":14,"docs":{"118":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.0},"31":{"tf":2.0},"35":{"tf":1.0},"45":{"tf":1.7320508075688772},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.4142135623730951},"95":{"tf":1.7320508075688772},"96":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"115":{"tf":1.0},"69":{"tf":1.0},"96":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"102":{"tf":1.0},"113":{"tf":1.4142135623730951},"118":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"s":{"df":8,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"106":{"tf":1.0},"109":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.7320508075688772},"89":{"tf":2.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":8,"docs":{"118":{"tf":1.0},"18":{"tf":1.0},"35":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"56":{"tf":1.0},"7":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}}},"x":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"b":{"(":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":9,"docs":{"110":{"tf":3.1622776601683795},"112":{"tf":1.0},"36":{"tf":1.7320508075688772},"40":{"tf":1.0},"45":{"tf":1.4142135623730951},"48":{"tf":1.0},"52":{"tf":1.7320508075688772},"55":{"tf":1.0},"56":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":3,"docs":{"17":{"tf":1.0},"8":{"tf":1.7320508075688772},"98":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"70":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":12,"docs":{"19":{"tf":1.0},"25":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.4142135623730951},"94":{"tf":1.0}}}},"t":{"df":4,"docs":{"115":{"tf":1.0},"46":{"tf":1.0},"69":{"tf":1.0},"95":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":2.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"117":{"tf":1.0},"41":{"tf":1.0},"61":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"68":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"23":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"102":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":4,"docs":{"102":{"tf":1.0},"115":{"tf":1.0},"56":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}},"u":{"df":0,"docs":{},"x":{"df":2,"docs":{"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}},"n":{"df":1,"docs":{"39":{"tf":1.0}},"g":{"df":2,"docs":{"63":{"tf":1.0},"78":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"e":{"df":4,"docs":{"7":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.0},"94":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"94":{"tf":1.0},"96":{"tf":1.0}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"114":{"tf":1.0}}}},"df":0,"docs":{}}}}},"w":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}}},"c":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"d":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"102":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.0}}}},"df":0,"docs":{}},"df":9,"docs":{"102":{"tf":1.4142135623730951},"106":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"86":{"tf":1.0}},"i":{"df":1,"docs":{"5":{"tf":1.0}}},"m":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":4,"docs":{"107":{"tf":1.0},"40":{"tf":1.0},"88":{"tf":1.0},"95":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":6,"docs":{"11":{"tf":1.0},"115":{"tf":1.4142135623730951},"16":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"10":{"tf":1.0},"105":{"tf":1.0},"11":{"tf":1.0},"115":{"tf":1.0},"12":{"tf":1.0},"27":{"tf":1.0},"41":{"tf":1.4142135623730951},"48":{"tf":1.0},"54":{"tf":1.0}}}}}},"b":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"25":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":8,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"118":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"16":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":2,"docs":{"107":{"tf":1.0},"84":{"tf":1.0}},"f":{"df":2,"docs":{"113":{"tf":1.4142135623730951},"57":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":10,"docs":{"106":{"tf":1.7320508075688772},"108":{"tf":1.0},"111":{"tf":1.0},"115":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"5":{"tf":1.0},"68":{"tf":1.0},"8":{"tf":1.4142135623730951},"89":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"=":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":4,"docs":{"113":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"'":{"df":1,"docs":{"105":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"27":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"41":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"41":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"41":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"r":{"df":3,"docs":{"32":{"tf":1.0},"41":{"tf":1.0},"52":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"113":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":6,"docs":{"101":{"tf":1.0},"103":{"tf":2.0},"106":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"95":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"95":{"tf":1.0}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"/":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"74":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"115":{"tf":1.0},"118":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":12,"docs":{"31":{"tf":1.0},"40":{"tf":1.0},"67":{"tf":2.449489742783178},"68":{"tf":1.0},"73":{"tf":1.7320508075688772},"77":{"tf":2.23606797749979},"78":{"tf":3.3166247903554},"79":{"tf":2.8284271247461903},"80":{"tf":1.7320508075688772},"82":{"tf":1.0},"83":{"tf":1.7320508075688772},"85":{"tf":2.449489742783178}}}},"df":0,"docs":{},"v":{"df":4,"docs":{"117":{"tf":1.0},"45":{"tf":1.0},"78":{"tf":1.7320508075688772},"79":{"tf":1.0}}}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"91":{"tf":1.0},"92":{"tf":1.0},"94":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"114":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"79":{"tf":1.0},"80":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"t":{"df":6,"docs":{"25":{"tf":1.7320508075688772},"70":{"tf":3.1622776601683795},"71":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}},"v":{"df":6,"docs":{"12":{"tf":1.0},"27":{"tf":1.0},"31":{"tf":1.0},"36":{"tf":1.0},"78":{"tf":1.0},"85":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"36":{"tf":1.0},"8":{"tf":2.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"110":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"105":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"110":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"105":{"tf":2.0},"111":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"116":{"tf":1.0},"118":{"tf":1.0}}}}}},"l":{"a":{"c":{"df":4,"docs":{"12":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":6,"docs":{"25":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"95":{"tf":2.0}},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.0},"5":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":14,"docs":{"25":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":2.23606797749979},"71":{"tf":1.4142135623730951},"74":{"tf":3.0},"75":{"tf":2.449489742783178},"78":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":2.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":5,"docs":{"105":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"58":{"tf":1.0},"66":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"30":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"66":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":9,"docs":{"102":{"tf":1.7320508075688772},"106":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.7320508075688772},"118":{"tf":1.7320508075688772},"45":{"tf":2.0},"51":{"tf":1.0},"52":{"tf":1.0},"73":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}}},"i":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"55":{"tf":1.0},"61":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"18":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"91":{"tf":1.0}}}}}},"t":{"df":2,"docs":{"118":{"tf":1.0},"40":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"0":{"tf":1.0},"16":{"tf":2.0},"5":{"tf":1.4142135623730951},"8":{"tf":2.0}}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{".":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}}},"z":{"df":1,"docs":{"106":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"106":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"113":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"106":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"106":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"106":{"tf":1.0}}}},"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":7,"docs":{"102":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"106":{"tf":2.23606797749979},"115":{"tf":1.0},"28":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":6,"docs":{"115":{"tf":1.0},"40":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.7320508075688772}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"(":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":13,"docs":{"104":{"tf":1.0},"106":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"21":{"tf":1.0},"45":{"tf":1.0},"55":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.7320508075688772},"8":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"94":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"78":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"100":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"114":{"tf":1.0}}}}}}},"f":{"c":{"df":8,"docs":{"101":{"tf":1.0},"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"110":{"tf":1.0},"23":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.4142135623730951},"98":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{".":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":5,"docs":{"115":{"tf":1.0},"31":{"tf":1.0},"76":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"94":{"tf":1.0}}}}},"o":{"a":{"d":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":6,"docs":{"100":{"tf":2.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951},"98":{"tf":2.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"95":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":3,"docs":{"31":{"tf":1.4142135623730951},"38":{"tf":1.0},"66":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"78":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":35,"docs":{"0":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":2.23606797749979},"26":{"tf":2.0},"27":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":2.0},"32":{"tf":1.4142135623730951},"36":{"tf":2.8284271247461903},"37":{"tf":1.7320508075688772},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":2.0},"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":2.23606797749979},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772},"7":{"tf":2.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.0},"94":{"tf":1.0}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"'":{"df":3,"docs":{"110":{"tf":1.0},"57":{"tf":1.0},"98":{"tf":1.0}}},",":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}}}}}},"a":{"c":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"'":{"df":1,"docs":{"53":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"109":{"tf":1.0}}}}}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{":":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"40":{"tf":1.0},"53":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"x":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"x":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"63":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"64":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"56":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"66":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"{":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"p":{"a":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":2,"docs":{"63":{"tf":1.0},"64":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":15,"docs":{"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":1.7320508075688772},"4":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.7320508075688772},"53":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"60":{"tf":1.0},"68":{"tf":1.4142135623730951},"94":{"tf":1.0},"95":{"tf":1.4142135623730951}}},"df":47,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"105":{"tf":1.0},"109":{"tf":1.0},"112":{"tf":1.0},"115":{"tf":3.0},"118":{"tf":2.23606797749979},"16":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.7320508075688772},"45":{"tf":2.23606797749979},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"52":{"tf":1.0},"67":{"tf":1.7320508075688772},"68":{"tf":2.449489742783178},"69":{"tf":1.0},"7":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":3.605551275463989},"72":{"tf":2.449489742783178},"73":{"tf":1.0},"74":{"tf":2.23606797749979},"75":{"tf":2.449489742783178},"77":{"tf":1.7320508075688772},"78":{"tf":2.6457513110645907},"79":{"tf":1.7320508075688772},"8":{"tf":1.0},"80":{"tf":2.0},"81":{"tf":1.4142135623730951},"82":{"tf":2.0},"83":{"tf":1.7320508075688772},"84":{"tf":2.0},"85":{"tf":1.4142135623730951},"88":{"tf":1.0},"9":{"tf":1.0},"92":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"95":{"tf":2.449489742783178},"98":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":3,"docs":{"32":{"tf":1.0},"37":{"tf":2.0},"94":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"18":{"tf":1.0},"19":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"t":{"df":3,"docs":{"32":{"tf":1.0},"49":{"tf":2.449489742783178},"95":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"p":{"df":8,"docs":{"1":{"tf":1.0},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"31":{"tf":2.23606797749979},"49":{"tf":1.4142135623730951},"67":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0}}}}}}}},"s":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":3,"docs":{"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}}}}},"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":14,"docs":{"106":{"tf":1.0},"118":{"tf":1.4142135623730951},"18":{"tf":1.0},"20":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":1.4142135623730951},"58":{"tf":1.0},"6":{"tf":1.0},"66":{"tf":2.0},"69":{"tf":1.0},"8":{"tf":1.7320508075688772},"95":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"102":{"tf":1.0},"103":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"95":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"r":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"20":{"tf":1.0},"69":{"tf":1.7320508075688772},"7":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.7320508075688772}}}}}}},"df":1,"docs":{"69":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"103":{"tf":1.7320508075688772},"104":{"tf":1.0},"118":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"102":{"tf":1.4142135623730951},"105":{"tf":1.0},"106":{"tf":1.0},"5":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":18,"docs":{"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"109":{"tf":1.4142135623730951},"112":{"tf":1.0},"113":{"tf":1.0},"118":{"tf":1.0},"23":{"tf":1.0},"40":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"67":{"tf":1.7320508075688772},"68":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.4142135623730951},"93":{"tf":2.0},"94":{"tf":1.0},"95":{"tf":1.0}}}}}}},"d":{"df":3,"docs":{"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":23,"docs":{"10":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"113":{"tf":1.4142135623730951},"12":{"tf":1.0},"14":{"tf":1.0},"21":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"78":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951}},"k":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"m":{"df":3,"docs":{"103":{"tf":1.0},"115":{"tf":1.0},"43":{"tf":1.0}}},"n":{"df":3,"docs":{"112":{"tf":1.0},"116":{"tf":1.0},"52":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"106":{"tf":1.0},"47":{"tf":1.0}}}},"df":0,"docs":{}},"f":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":14,"docs":{"104":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.7320508075688772},"52":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.4142135623730951}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"(":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"(":{"_":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"_":{"df":1,"docs":{"105":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"110":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"118":{"tf":1.0}}}}}}},"df":2,"docs":{"113":{"tf":1.0},"118":{"tf":1.0}}}},"n":{"d":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}},"df":0,"docs":{},"s":{"df":3,"docs":{"35":{"tf":1.0},"66":{"tf":1.0},"95":{"tf":1.0}},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":6,"docs":{"36":{"tf":1.0},"44":{"tf":1.7320508075688772},"52":{"tf":1.0},"63":{"tf":1.0},"8":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"110":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"110":{"tf":1.0}}}},"df":1,"docs":{"110":{"tf":1.0}},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":6,"docs":{"103":{"tf":1.7320508075688772},"105":{"tf":1.7320508075688772},"110":{"tf":1.0},"111":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"v":{"df":3,"docs":{"40":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"t":{"df":11,"docs":{"106":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.4142135623730951},"34":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"5":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":2.0},"8":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":4,"docs":{"23":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"32":{"tf":1.0},"33":{"tf":1.0}}}}}},"h":{"a":{"=":{"$":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"74":{"tf":1.4142135623730951},"83":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"118":{"tf":1.0},"95":{"tf":1.0}}}}},"df":1,"docs":{"69":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.0},"53":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"78":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"40":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"5":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"w":{"df":6,"docs":{"102":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"118":{"tf":1.0},"31":{"tf":1.0},"48":{"tf":1.0}},"n":{"df":3,"docs":{"104":{"tf":1.0},"112":{"tf":1.0},"95":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":3,"docs":{"115":{"tf":1.0},"55":{"tf":1.0},"8":{"tf":3.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.0}},"e":{".":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":9,"docs":{"101":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"11":{"tf":1.0},"110":{"tf":1.0},"115":{"tf":1.7320508075688772},"118":{"tf":1.0},"53":{"tf":1.0},"95":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":6,"docs":{"0":{"tf":1.0},"104":{"tf":1.4142135623730951},"114":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.0},"19":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"114":{"tf":1.0},"115":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"105":{"tf":1.0}}}}},"i":{"df":3,"docs":{"117":{"tf":1.0},"52":{"tf":1.0},"87":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":6,"docs":{"102":{"tf":2.0},"110":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"12":{"tf":1.0},"95":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":4,"docs":{"105":{"tf":1.0},"43":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}}}},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"115":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"x":{"df":1,"docs":{"67":{"tf":1.0}}},"z":{"df":0,"docs":{},"e":{"df":2,"docs":{"61":{"tf":1.0},"8":{"tf":4.898979485566356}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"1":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":2.23606797749979}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"115":{"tf":1.0},"13":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"113":{"tf":1.4142135623730951}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"102":{"tf":1.0},"118":{"tf":1.0},"28":{"tf":1.0},"77":{"tf":1.0},"92":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"106":{"tf":1.0},"109":{"tf":1.0},"7":{"tf":1.0}}}},"v":{"df":2,"docs":{"115":{"tf":1.4142135623730951},"117":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"(":{"4":{"2":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"113":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"106":{"tf":2.0},"113":{"tf":1.0}}}}}}}}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"62":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"94":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":8,"docs":{"0":{"tf":1.0},"23":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.4142135623730951},"56":{"tf":1.0},"80":{"tf":1.4142135623730951},"94":{"tf":1.0},"95":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":5,"docs":{"15":{"tf":1.0},"45":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"73":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":3.0}}}}},"w":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"94":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"118":{"tf":1.0},"96":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":7,"docs":{"22":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"56":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}},".":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":2,"docs":{"43":{"tf":1.4142135623730951},"44":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}}}}},"df":6,"docs":{"110":{"tf":1.0},"43":{"tf":2.23606797749979},"44":{"tf":1.7320508075688772},"53":{"tf":1.0},"66":{"tf":2.6457513110645907},"94":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"66":{"tf":1.0}}}},"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"16":{"tf":1.0},"77":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":18,"docs":{"0":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.4142135623730951},"105":{"tf":1.0},"11":{"tf":1.0},"112":{"tf":2.0},"114":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":2.0},"62":{"tf":1.7320508075688772},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.0},"8":{"tf":1.0},"94":{"tf":1.0}},"i":{"df":13,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0},"45":{"tf":1.4142135623730951},"7":{"tf":2.23606797749979},"78":{"tf":1.0},"8":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":2,"docs":{"14":{"tf":1.0},"5":{"tf":1.4142135623730951}}}}}}}},"r":{"c":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"/":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":7,"docs":{"71":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"23":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}},"l":{"df":15,"docs":{"18":{"tf":1.7320508075688772},"19":{"tf":1.0},"20":{"tf":1.0},"68":{"tf":1.0},"73":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":2.0},"79":{"tf":1.7320508075688772},"80":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":2.0},"85":{"tf":2.23606797749979},"94":{"tf":1.4142135623730951},"95":{"tf":1.0}}}},"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"69":{"tf":1.0},"8":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":7,"docs":{"106":{"tf":1.7320508075688772},"113":{"tf":1.0},"118":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"69":{"tf":1.0}}}},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"32":{"tf":1.0},"35":{"tf":1.4142135623730951}}}}},"r":{"d":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":18,"docs":{"101":{"tf":1.0},"110":{"tf":1.0},"113":{"tf":1.0},"118":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0},"32":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"78":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"102":{"tf":1.0},"118":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":3,"docs":{"36":{"tf":2.23606797749979},"44":{"tf":1.0},"51":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":17,"docs":{"19":{"tf":1.0},"3":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"45":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"80":{"tf":1.7320508075688772},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"84":{"tf":1.0},"92":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":10,"docs":{"0":{"tf":1.0},"102":{"tf":1.0},"11":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"23":{"tf":1.0},"5":{"tf":1.0},"70":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}},"m":{"df":0,"docs":{},"t":{"df":2,"docs":{"110":{"tf":1.0},"118":{"tf":1.0}}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"94":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"*":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"df":1,"docs":{"52":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"41":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"r":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}}}}},"df":1,"docs":{"7":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"16":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"87":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"65":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"106":{"tf":1.0}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":9,"docs":{"106":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"36":{"tf":1.0},"45":{"tf":1.4142135623730951},"52":{"tf":3.3166247903554},"56":{"tf":2.6457513110645907},"57":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"52":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":11,"docs":{"102":{"tf":1.7320508075688772},"103":{"tf":1.0},"106":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.4142135623730951},"113":{"tf":1.0},"115":{"tf":2.6457513110645907},"116":{"tf":1.0},"37":{"tf":1.0},"55":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"u":{"b":{"df":1,"docs":{"7":{"tf":1.0}}},"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":5,"docs":{"0":{"tf":1.0},"103":{"tf":1.0},"14":{"tf":2.449489742783178},"40":{"tf":1.0},"49":{"tf":1.0}}}}}},"u":{"b":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"4":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"106":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"105":{"tf":1.7320508075688772},"106":{"tf":1.0},"115":{"tf":1.4142135623730951},"117":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"51":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"106":{"tf":2.0},"115":{"tf":1.0},"118":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":9,"docs":{"118":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":3.4641016151377544},"71":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"95":{"tf":1.4142135623730951}},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"46":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"h":{"df":9,"docs":{"115":{"tf":1.7320508075688772},"45":{"tf":1.0},"55":{"tf":1.7320508075688772},"56":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.4142135623730951},"7":{"tf":1.0},"89":{"tf":1.0},"94":{"tf":1.0}}}},"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"69":{"tf":1.7320508075688772}}}},"df":1,"docs":{"11":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":3,"docs":{"106":{"tf":1.0},"118":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{},"x":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":14,"docs":{"118":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"17":{"tf":1.0},"28":{"tf":1.0},"37":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"8":{"tf":3.0},"94":{"tf":1.0},"95":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"26":{"tf":1.0},"38":{"tf":1.0},"44":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"101":{"tf":1.0},"105":{"tf":1.4142135623730951},"115":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"48":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":8,"docs":{"111":{"tf":1.0},"118":{"tf":1.7320508075688772},"32":{"tf":1.0},"45":{"tf":1.4142135623730951},"52":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951},"94":{"tf":1.0}}}},"s":{"df":1,"docs":{"0":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":2.8284271247461903}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":17,"docs":{"17":{"tf":1.0},"19":{"tf":1.0},"25":{"tf":1.4142135623730951},"28":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"78":{"tf":2.449489742783178},"80":{"tf":1.0},"84":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"113":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"11":{"tf":1.0}}}},"df":0,"docs":{}}}}},"y":{"df":0,"docs":{},"m":{"!":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"62":{"tf":1.0},"65":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"c":{"df":8,"docs":{"67":{"tf":1.4142135623730951},"68":{"tf":2.23606797749979},"70":{"tf":1.0},"71":{"tf":2.449489742783178},"72":{"tf":1.7320508075688772},"74":{"tf":1.0},"75":{"tf":1.0},"95":{"tf":2.0}},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.0}}}}}}},"df":2,"docs":{"109":{"tf":1.4142135623730951},"112":{"tf":1.0}},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{},"x":{"'":{"df":1,"docs":{"118":{"tf":1.0}}},":":{":":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"104":{"tf":1.0},"106":{"tf":1.4142135623730951}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"106":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":2,"docs":{"109":{"tf":1.0},"112":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":17,"docs":{"101":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.7320508075688772},"104":{"tf":2.0},"105":{"tf":2.6457513110645907},"106":{"tf":1.7320508075688772},"109":{"tf":2.0},"111":{"tf":1.0},"112":{"tf":2.6457513110645907},"113":{"tf":1.0},"114":{"tf":2.0},"115":{"tf":4.0},"116":{"tf":1.7320508075688772},"117":{"tf":1.0},"118":{"tf":3.872983346207417},"30":{"tf":1.0},"46":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":5,"docs":{"103":{"tf":1.0},"118":{"tf":1.4142135623730951},"42":{"tf":1.0},"57":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"105":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":7,"docs":{"115":{"tf":1.4142135623730951},"75":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951}}},"k":{"df":0,"docs":{},"e":{"df":12,"docs":{"115":{"tf":1.0},"118":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":1.0},"78":{"tf":1.0},"89":{"tf":1.0}},"n":{"df":1,"docs":{"77":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"58":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":5,"docs":{"118":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"39":{"tf":1.0},"64":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"k":{"df":4,"docs":{"100":{"tf":1.0},"102":{"tf":1.4142135623730951},"115":{"tf":1.0},"91":{"tf":1.4142135623730951}}}},"t":{"a":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"x":{"df":6,"docs":{"30":{"tf":1.0},"45":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":9,"docs":{"71":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.4142135623730951},"79":{"tf":1.0},"91":{"tf":1.4142135623730951},"92":{"tf":2.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":4.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"95":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}}}}},"s":{"df":0,"docs":{},"t":{"_":{"df":1,"docs":{"26":{"tf":1.0}}},"df":29,"docs":{"0":{"tf":1.0},"102":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"115":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"26":{"tf":3.4641016151377544},"27":{"tf":1.4142135623730951},"32":{"tf":2.0},"35":{"tf":1.0},"36":{"tf":3.4641016151377544},"37":{"tf":2.23606797749979},"38":{"tf":2.0},"43":{"tf":1.4142135623730951},"44":{"tf":2.6457513110645907},"45":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":2.0},"66":{"tf":1.0},"7":{"tf":1.0},"74":{"tf":2.0},"75":{"tf":1.7320508075688772},"8":{"tf":3.7416573867739413},"87":{"tf":1.0},"95":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"36":{"tf":1.0}},"e":{"=":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{",":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"2":{",":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"3":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"35":{"tf":1.0},"36":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":3,"docs":{"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"x":{"df":1,"docs":{"8":{"tf":1.4142135623730951}},"t":{"df":3,"docs":{"40":{"tf":1.0},"43":{"tf":1.0},"87":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"32":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"a":{"d":{"d":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"105":{"tf":1.0}}}}}}},"n":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"102":{"tf":1.4142135623730951}}}}}},"[":{"0":{"]":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"102":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"'":{"df":5,"docs":{"106":{"tf":1.0},"21":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"103":{"tf":1.0},"105":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0}}}}}}},"y":{"'":{"df":0,"docs":{},"r":{"df":2,"docs":{"58":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":9,"docs":{"0":{"tf":1.0},"23":{"tf":1.0},"40":{"tf":1.4142135623730951},"48":{"tf":1.0},"53":{"tf":1.4142135623730951},"66":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":2.0}}},"k":{"df":3,"docs":{"115":{"tf":1.0},"58":{"tf":1.0},"95":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":13,"docs":{"10":{"tf":1.0},"106":{"tf":1.0},"118":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0},"36":{"tf":1.0},"5":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.7320508075688772},"84":{"tf":1.0},"89":{"tf":1.0},"96":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":6,"docs":{"113":{"tf":1.0},"36":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"95":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":4,"docs":{"105":{"tf":1.0},"118":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"52":{"tf":1.0},"8":{"tf":5.0990195135927845}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":7,"docs":{"115":{"tf":1.0},"23":{"tf":1.0},"27":{"tf":1.0},"32":{"tf":1.0},"5":{"tf":1.7320508075688772},"64":{"tf":1.0},"69":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"15":{"tf":1.0},"53":{"tf":1.0}}}}}}}}}}},"i":{"b":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":17,"docs":{"114":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"25":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0},"58":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"71":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"92":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"p":{"df":1,"docs":{"31":{"tf":1.0}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}},"l":{"df":1,"docs":{"75":{"tf":1.0}}}}},"l":{";":{"d":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"o":{"df":2,"docs":{"43":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"67":{"tf":1.0},"79":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"52":{"tf":1.0},"7":{"tf":1.0}}}},"o":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"=":{"<":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"49":{"tf":1.0}}}}}}}}}},"df":6,"docs":{"1":{"tf":1.4142135623730951},"18":{"tf":1.7320508075688772},"2":{"tf":1.0},"31":{"tf":2.6457513110645907},"49":{"tf":1.0},"71":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":14,"docs":{"115":{"tf":1.0},"118":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.7320508075688772},"28":{"tf":1.0},"34":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"53":{"tf":1.0},"60":{"tf":1.4142135623730951},"7":{"tf":1.0},"78":{"tf":1.0},"95":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"p":{"df":3,"docs":{"37":{"tf":1.0},"78":{"tf":1.0},"88":{"tf":1.0}},"i":{"c":{"df":2,"docs":{"91":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"7":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"92":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"93":{"tf":1.0},"96":{"tf":1.4142135623730951}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"92":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"t":{"df":9,"docs":{"109":{"tf":1.7320508075688772},"112":{"tf":2.23606797749979},"114":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"43":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":2.449489742783178},"8":{"tf":1.7320508075688772}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"v":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":13,"docs":{"101":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.7320508075688772},"104":{"tf":2.0},"106":{"tf":1.0},"109":{"tf":1.4142135623730951},"112":{"tf":2.449489742783178},"114":{"tf":2.0},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"30":{"tf":1.0},"80":{"tf":1.0}}}},"i":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"23":{"tf":1.0},"95":{"tf":2.449489742783178}}}},"df":4,"docs":{"10":{"tf":1.0},"38":{"tf":1.0},"5":{"tf":1.0},"78":{"tf":1.0}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"16":{"tf":1.0},"36":{"tf":1.0},"45":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":2.23606797749979}}}}}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"102":{"tf":1.0},"13":{"tf":1.0},"8":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"y":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"e":{"df":3,"docs":{"105":{"tf":1.0},"66":{"tf":1.4142135623730951},"8":{"tf":2.8284271247461903}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"105":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":5,"docs":{"0":{"tf":1.0},"113":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.0},"95":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":14,"docs":{"106":{"tf":2.0},"113":{"tf":1.0},"118":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.0},"8":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.0}}}},"y":{"'":{"df":1,"docs":{"56":{"tf":1.0}}},".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"57":{"tf":1.7320508075688772},"61":{"tf":1.0}}},"df":0,"docs":{}}}}},":":{":":{"a":{"d":{"df":0,"docs":{},"t":{"(":{"a":{"d":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":2,"docs":{"57":{"tf":1.0},"61":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"58":{"tf":2.23606797749979}}},"y":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"<":{"'":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"x":{">":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"d":{"<":{"'":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":9,"docs":{"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":2.8284271247461903},"57":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.7320508075688772},"63":{"tf":1.7320508075688772},"64":{"tf":1.7320508075688772}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"56":{"tf":1.0},"57":{"tf":2.0},"61":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"=":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}}}},"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"55":{"tf":2.23606797749979},"61":{"tf":2.0}}}}}}}}}},"df":27,"docs":{"104":{"tf":1.0},"105":{"tf":1.7320508075688772},"106":{"tf":3.3166247903554},"111":{"tf":1.4142135623730951},"112":{"tf":1.0},"118":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":2.0},"42":{"tf":2.0},"52":{"tf":2.0},"54":{"tf":1.4142135623730951},"55":{"tf":2.0},"56":{"tf":2.6457513110645907},"57":{"tf":2.23606797749979},"58":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":2.23606797749979},"61":{"tf":3.3166247903554},"62":{"tf":1.4142135623730951},"63":{"tf":3.0},"64":{"tf":2.23606797749979},"65":{"tf":1.7320508075688772},"7":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":4.47213595499958}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"o":{"df":2,"docs":{"26":{"tf":1.0},"77":{"tf":1.0}}}}}},"u":{"3":{"2":{"df":1,"docs":{"58":{"tf":2.0}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"8":{"tf":4.47213595499958}}},"df":0,"docs":{}},"b":{"df":1,"docs":{"30":{"tf":1.0}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"df":1,"docs":{"74":{"tf":1.0}},"i":{"df":5,"docs":{"26":{"tf":1.7320508075688772},"36":{"tf":1.7320508075688772},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"51":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"26":{"tf":1.4142135623730951},"36":{"tf":2.0},"44":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"94":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":2.0}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"114":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"_":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}},"r":{"df":6,"docs":{"0":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"69":{"tf":1.0},"96":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"55":{"tf":1.0},"61":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"47":{"tf":1.0},"58":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"53":{"tf":1.0},"66":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"92":{"tf":1.0}}}},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.7320508075688772}},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"7":{"tf":1.0}}}},"t":{"df":1,"docs":{"44":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"43":{"tf":1.0},"66":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":2,"docs":{"113":{"tf":1.0},"35":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"z":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"38":{"tf":1.0},"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"117":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"102":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"116":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":2,"docs":{"5":{"tf":1.0},"8":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"p":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"77":{"tf":1.0},"78":{"tf":1.7320508075688772},"96":{"tf":1.0}}}}},"d":{"a":{"df":0,"docs":{},"t":{"df":20,"docs":{"114":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.7320508075688772},"27":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"36":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"44":{"tf":1.0},"52":{"tf":1.0},"67":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":2.0},"78":{"tf":2.23606797749979},"79":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772},"85":{"tf":2.449489742783178},"88":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"27":{"tf":1.0},"41":{"tf":1.4142135623730951},"51":{"tf":1.0},"95":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":12,"docs":{"30":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"80":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"/":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"80":{"tf":1.4142135623730951},"81":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"25":{"tf":1.0},"71":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":9,"docs":{"25":{"tf":2.23606797749979},"70":{"tf":2.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"l":{"df":1,"docs":{"70":{"tf":1.0}}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"91":{"tf":1.0},"92":{"tf":1.0},"94":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":5,"docs":{"1":{"tf":1.0},"27":{"tf":1.0},"4":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0}}}},"df":63,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.4142135623730951},"101":{"tf":1.0},"103":{"tf":2.23606797749979},"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"106":{"tf":1.7320508075688772},"107":{"tf":1.4142135623730951},"109":{"tf":1.0},"113":{"tf":2.0},"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"118":{"tf":2.6457513110645907},"15":{"tf":1.0},"16":{"tf":1.7320508075688772},"17":{"tf":1.0},"18":{"tf":2.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"20":{"tf":1.7320508075688772},"21":{"tf":1.0},"31":{"tf":1.7320508075688772},"34":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.4142135623730951},"40":{"tf":2.449489742783178},"41":{"tf":1.7320508075688772},"42":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"45":{"tf":2.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"5":{"tf":2.449489742783178},"50":{"tf":1.0},"52":{"tf":1.7320508075688772},"55":{"tf":2.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.4142135623730951},"6":{"tf":2.23606797749979},"60":{"tf":1.0},"61":{"tf":2.23606797749979},"63":{"tf":2.8284271247461903},"64":{"tf":2.8284271247461903},"65":{"tf":1.4142135623730951},"66":{"tf":2.6457513110645907},"69":{"tf":1.0},"7":{"tf":2.449489742783178},"71":{"tf":1.4142135623730951},"78":{"tf":1.0},"8":{"tf":3.0},"80":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.0},"94":{"tf":2.0},"95":{"tf":1.7320508075688772}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}},"df":2,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0}}}}}},"r":{"df":14,"docs":{"106":{"tf":1.7320508075688772},"114":{"tf":1.0},"115":{"tf":1.7320508075688772},"118":{"tf":1.0},"15":{"tf":1.0},"52":{"tf":1.0},"58":{"tf":1.0},"69":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":2.0},"96":{"tf":2.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{">":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"110":{"tf":1.0}}}},"r":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":2.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"u":{"a":{"df":0,"docs":{},"l":{"df":10,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.4142135623730951},"78":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":3,"docs":{"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"64":{"tf":1.4142135623730951}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":5,"docs":{"109":{"tf":1.0},"111":{"tf":1.7320508075688772},"118":{"tf":1.0},"28":{"tf":1.0},"8":{"tf":2.0}}},"df":0,"docs":{}},"u":{"df":11,"docs":{"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"118":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.4142135623730951},"52":{"tf":3.3166247903554},"55":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":2.449489742783178},"8":{"tf":7.745966692414834}}}},"r":{"df":1,"docs":{"18":{"tf":1.0}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"36":{"tf":1.0},"39":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"105":{"tf":1.4142135623730951},"111":{"tf":1.7320508075688772},"44":{"tf":1.0},"57":{"tf":1.0},"8":{"tf":2.8284271247461903}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"43":{"tf":1.0},"54":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":2,"docs":{"43":{"tf":1.0},"53":{"tf":1.0}}}}}}},"df":1,"docs":{"109":{"tf":2.23606797749979}},"e":{"c":{"<":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{":":{":":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"[":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"b":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{":":{":":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":2.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":2.0}}}}}},"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":1,"docs":{"8":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.7320508075688772}},"e":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":6,"docs":{"0":{"tf":1.0},"103":{"tf":1.4142135623730951},"115":{"tf":1.0},"56":{"tf":1.0},"7":{"tf":1.4142135623730951},"77":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":22,"docs":{"102":{"tf":1.7320508075688772},"107":{"tf":1.0},"110":{"tf":1.0},"19":{"tf":1.0},"25":{"tf":1.4142135623730951},"28":{"tf":1.0},"32":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.7320508075688772},"45":{"tf":2.23606797749979},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":2.0},"71":{"tf":1.7320508075688772},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.7320508075688772},"95":{"tf":1.0}}}}}}}},"i":{"a":{"df":5,"docs":{"44":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"31":{"tf":1.0},"87":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"118":{"tf":1.0}}}}}}}},"s":{"df":1,"docs":{"95":{"tf":1.0}}},"v":{"df":1,"docs":{"40":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"71":{"tf":1.0},"95":{"tf":1.0}}}},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"23":{"tf":1.0}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"78":{"tf":1.0}}}}}}}}}}},"n":{"df":0,"docs":{},"t":{"df":25,"docs":{"106":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.4142135623730951},"26":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.7320508075688772},"43":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.7320508075688772},"50":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.4142135623730951},"7":{"tf":1.0},"70":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.4142135623730951},"88":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{":":{":":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"96":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":10,"docs":{"0":{"tf":2.0},"14":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.7320508075688772},"28":{"tf":1.0},"5":{"tf":2.6457513110645907},"7":{"tf":2.449489742783178},"8":{"tf":1.4142135623730951}}}},"y":{"df":22,"docs":{"0":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.0},"106":{"tf":1.0},"114":{"tf":1.0},"117":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":1.0},"35":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":2.0},"55":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.4142135623730951},"74":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{":":{":":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"7":{"tf":2.0}},"e":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"35":{"tf":1.0},"36":{"tf":1.0}}}},"v":{"df":1,"docs":{"58":{"tf":1.0}}}},"b":{"df":1,"docs":{"88":{"tf":1.0}},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"df":4,"docs":{"67":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"77":{"tf":1.0},"94":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"68":{"tf":1.0},"95":{"tf":1.0}}}}}},"l":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"21":{"tf":1.0},"5":{"tf":1.0},"77":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":7,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"95":{"tf":1.0}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}}}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"8":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"104":{"tf":1.0},"106":{"tf":1.4142135623730951},"113":{"tf":1.0},"118":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.4142135623730951},"8":{"tf":3.3166247903554}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":10,"docs":{"114":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"27":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.7320508075688772},"58":{"tf":1.0},"7":{"tf":1.0},"92":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"l":{"d":{"c":{"a":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}},"df":1,"docs":{"8":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":1,"docs":{"95":{"tf":1.0}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"7":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"113":{"tf":1.0},"118":{"tf":1.0},"35":{"tf":1.0},"8":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":8,"docs":{"105":{"tf":1.0},"114":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"58":{"tf":1.4142135623730951},"6":{"tf":1.0},"84":{"tf":1.0},"96":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"<":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"<":{"'":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":4,"docs":{"35":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":2,"docs":{"78":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":21,"docs":{"106":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.4142135623730951},"23":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"43":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"66":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772},"7":{"tf":1.0},"89":{"tf":1.4142135623730951},"95":{"tf":2.6457513110645907}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":3,"docs":{"39":{"tf":1.0},"5":{"tf":2.0},"52":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"d":{"df":2,"docs":{"107":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"43":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"94":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"95":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"114":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":18,"docs":{"102":{"tf":1.7320508075688772},"103":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"118":{"tf":2.23606797749979},"14":{"tf":1.0},"23":{"tf":1.0},"36":{"tf":1.0},"42":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"53":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.4142135623730951},"78":{"tf":2.0},"9":{"tf":1.0},"94":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":12,"docs":{"0":{"tf":1.4142135623730951},"102":{"tf":1.0},"107":{"tf":1.0},"11":{"tf":1.7320508075688772},"113":{"tf":1.4142135623730951},"118":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"34":{"tf":1.0},"52":{"tf":1.0},"67":{"tf":1.0},"8":{"tf":1.7320508075688772}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":4,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"116":{"tf":1.0},"40":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"x":{"'":{"df":1,"docs":{"105":{"tf":1.0}}},".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"74":{"tf":1.0},"75":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{".":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":5,"docs":{"105":{"tf":3.3166247903554},"117":{"tf":1.0},"5":{"tf":1.4142135623730951},"58":{"tf":1.0},"66":{"tf":1.0}},"x":{"df":2,"docs":{"82":{"tf":1.0},"83":{"tf":1.0}}}},"y":{"df":2,"docs":{"105":{"tf":2.23606797749979},"5":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"98":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"'":{"df":0,"docs":{},"r":{"df":10,"docs":{"1":{"tf":1.0},"21":{"tf":1.4142135623730951},"32":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"86":{"tf":1.0}}},"v":{"df":2,"docs":{"25":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}}},"y":{"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"z":{"df":1,"docs":{"105":{"tf":1.0}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"53":{"tf":1.0},"71":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"breadcrumbs":{"root":{"0":{"1":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}},"3":{"df":1,"docs":{"101":{"tf":1.0}}},"7":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}},"8":{"df":1,"docs":{"68":{"tf":1.0}}},"df":3,"docs":{"115":{"tf":3.605551275463989},"5":{"tf":1.0},"66":{"tf":1.0}}},"1":{",":{"0":{"0":{"0":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"5":{",":{"0":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"0":{"df":2,"docs":{"23":{"tf":1.0},"9":{"tf":1.0}}},"2":{"9":{".":{"0":{"df":2,"docs":{"40":{"tf":1.0},"48":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"0":{".":{"0":{"df":1,"docs":{"7":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"4":{"4":{"df":1,"docs":{"45":{"tf":1.0}}},"5":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{},"x":{"df":0,"docs":{},"x":{".":{"0":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":3,"docs":{"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"85":{"tf":1.4142135623730951}}}}},"/":{"df":0,"docs":{},"g":{"df":3,"docs":{"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}},"0":{"0":{"0":{"0":{"0":{"0":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"95":{"tf":1.0}}},"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"1":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}},"2":{"8":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":1,"docs":{"101":{"tf":1.0}}},"6":{"3":{"8":{"4":{"df":1,"docs":{"8":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"2":{"8":{"df":1,"docs":{"98":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":12,"docs":{"102":{"tf":1.4142135623730951},"115":{"tf":2.449489742783178},"117":{"tf":1.7320508075688772},"5":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"8":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.0}}},"2":{".":{"0":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"0":{"0":{"df":1,"docs":{"8":{"tf":2.0}}},"1":{"6":{"df":1,"docs":{"98":{"tf":1.0}}},"8":{"df":1,"docs":{"6":{"tf":1.0}}},"9":{"df":1,"docs":{"101":{"tf":1.0}}},"df":0,"docs":{}},"2":{"0":{"df":2,"docs":{"68":{"tf":1.0},"95":{"tf":1.4142135623730951}}},"1":{"df":12,"docs":{"100":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951},"90":{"tf":1.7320508075688772},"91":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"94":{"tf":1.0},"95":{"tf":1.4142135623730951},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}},"2":{"df":1,"docs":{"100":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":1,"docs":{"85":{"tf":2.0}}}}},"5":{"0":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"6":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":2,"docs":{"8":{"tf":1.4142135623730951},"95":{"tf":1.0}}},"7":{"df":2,"docs":{"57":{"tf":1.0},"68":{"tf":1.0}}},"df":9,"docs":{"105":{"tf":1.0},"117":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"94":{"tf":1.0}}},"3":{".":{"1":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"1":{"6":{"4":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"df":1,"docs":{"95":{"tf":1.0}}},"8":{"7":{"5":{"df":1,"docs":{"101":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"63":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":3.1622776601683795}}},"4":{"0":{"9":{"6":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"1":{"2":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"78":{"tf":1.0},"8":{"tf":1.7320508075688772}}},"5":{"1":{"2":{"0":{"0":{"0":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"9":{"4":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"3":{"7":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"0":{"0":{"0":{"0":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"3":{"6":{"6":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"2":{"9":{"df":2,"docs":{"94":{"tf":1.0},"95":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"9":{"df":3,"docs":{"78":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951}}},"_":{"?":{")":{"#":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}}}}}},")":{"#":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":1,"docs":{"118":{"tf":2.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":12,"docs":{"105":{"tf":4.795831523312719},"112":{"tf":1.4142135623730951},"113":{"tf":1.7320508075688772},"117":{"tf":1.4142135623730951},"118":{"tf":4.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"57":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"65":{"tf":1.0},"8":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"a":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"36":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"/":{"df":0,"docs":{},"w":{"/":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},">":{"#":{"<":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"105":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"{":{"df":0,"docs":{},"n":{",":{"df":0,"docs":{},"m":{"df":1,"docs":{"105":{"tf":1.4142135623730951}}}},"df":1,"docs":{"105":{"tf":2.0}}}}},"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"66":{"tf":1.0}},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"b":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":2,"docs":{"24":{"tf":1.0},"30":{"tf":2.23606797749979}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"94":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"v":{"df":10,"docs":{"102":{"tf":1.7320508075688772},"103":{"tf":1.0},"106":{"tf":2.0},"111":{"tf":1.0},"115":{"tf":1.4142135623730951},"46":{"tf":1.0},"5":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"78":{"tf":1.7320508075688772},"89":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":10,"docs":{"115":{"tf":1.0},"27":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"52":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":4,"docs":{"43":{"tf":1.0},"49":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"42":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"106":{"tf":1.0},"45":{"tf":1.0}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"54":{"tf":1.0},"95":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"19":{"tf":1.7320508075688772},"9":{"tf":1.0}},"s":{"/":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"@":{"df":0,"docs":{},"v":{"3":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"df":2,"docs":{"31":{"tf":1.4142135623730951},"66":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":7,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"109":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"41":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"114":{"tf":1.4142135623730951},"68":{"tf":1.0},"78":{"tf":1.0}}}}},"d":{"df":22,"docs":{"104":{"tf":1.0},"11":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.4142135623730951},"39":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.7320508075688772},"7":{"tf":1.0},"70":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"95":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":9,"docs":{"106":{"tf":1.0},"113":{"tf":1.4142135623730951},"115":{"tf":1.0},"118":{"tf":1.4142135623730951},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"95":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"113":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.0},"37":{"tf":1.0},"92":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":8,"docs":{"100":{"tf":1.0},"58":{"tf":1.0},"70":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}}}}}},"df":30,"docs":{"18":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"32":{"tf":2.449489742783178},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"45":{"tf":2.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.7320508075688772},"52":{"tf":3.0},"53":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.4142135623730951},"89":{"tf":1.0}},"t":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"57":{"tf":1.0},"61":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"57":{"tf":1.0}}}}},"df":1,"docs":{"57":{"tf":1.0}}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"115":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"103":{"tf":1.0},"114":{"tf":1.7320508075688772},"115":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"115":{"tf":1.0},"41":{"tf":1.0},"7":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"115":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":13,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"106":{"tf":1.0},"109":{"tf":1.0},"112":{"tf":2.0},"113":{"tf":1.4142135623730951},"117":{"tf":1.0},"19":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"45":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"5":{"tf":1.0},"75":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":1,"docs":{"113":{"tf":1.0}}}}}}}}},"i":{"a":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{".":{".":{")":{"]":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"40":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"]":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"14":{"tf":1.0}}},"df":25,"docs":{"0":{"tf":1.7320508075688772},"101":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.4142135623730951},"11":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":2.0},"12":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.7320508075688772},"55":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":2.0},"71":{"tf":1.0},"8":{"tf":5.656854249492381},"87":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"106":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"92":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":14,"docs":{"1":{"tf":1.0},"25":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0},"66":{"tf":1.4142135623730951},"78":{"tf":1.7320508075688772},"84":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"110":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"<":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"110":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"110":{"tf":1.0}}}},"df":1,"docs":{"110":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":8,"docs":{"105":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"110":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":2.23606797749979},"116":{"tf":1.0},"118":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"30":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":1,"docs":{"94":{"tf":1.0}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"71":{"tf":1.0},"92":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":2,"docs":{"0":{"tf":1.0},"94":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":8,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"111":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.0},"118":{"tf":1.7320508075688772},"41":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":2.449489742783178}}}}}}}}}},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"y":{"<":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"105":{"tf":1.4142135623730951},"110":{"tf":1.0},"84":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"50":{"tf":1.0}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":3,"docs":{"68":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"113":{"tf":1.0},"53":{"tf":1.0}}},"df":9,"docs":{"103":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"37":{"tf":1.0},"5":{"tf":1.4142135623730951},"66":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"a":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"103":{"tf":1.7320508075688772},"113":{"tf":1.4142135623730951},"114":{"tf":1.0},"115":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"43":{"tf":1.0}}}}},"v":{"df":1,"docs":{"73":{"tf":1.0}}},"x":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{},"e":{"a":{"df":3,"docs":{"103":{"tf":1.0},"118":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"113":{"tf":1.0}}}},"df":0,"docs":{}}},"g":{"df":1,"docs":{"8":{"tf":1.7320508075688772}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"104":{"tf":1.0},"105":{"tf":1.7320508075688772},"6":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":3.0}},"i":{"c":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.7320508075688772}},"s":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"d":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"110":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":6,"docs":{"105":{"tf":3.0},"106":{"tf":2.0},"111":{"tf":1.4142135623730951},"117":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"t":{"df":2,"docs":{"116":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"k":{"df":4,"docs":{"30":{"tf":1.0},"53":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"(":{"c":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"x":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{".":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"106":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"(":{"_":{"#":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":4,"docs":{"106":{"tf":1.4142135623730951},"115":{"tf":1.0},"91":{"tf":1.4142135623730951},"93":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":11,"docs":{"4":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}}}},"t":{"'":{"df":1,"docs":{"115":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"113":{"tf":1.4142135623730951},"115":{"tf":1.0}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"(":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"102":{"tf":1.4142135623730951}}}}}},"df":1,"docs":{"102":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"113":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"102":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.4142135623730951}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"_":{"df":1,"docs":{"102":{"tf":1.0}}},"df":0,"docs":{},"j":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"j":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"j":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"112":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.4142135623730951}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"102":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"102":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":10,"docs":{"102":{"tf":2.0},"105":{"tf":1.0},"109":{"tf":1.4142135623730951},"110":{"tf":1.0},"112":{"tf":1.4142135623730951},"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"118":{"tf":1.7320508075688772},"30":{"tf":1.0},"42":{"tf":1.0}}},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}},"n":{"df":1,"docs":{"105":{"tf":1.0}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":9,"docs":{"106":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.7320508075688772},"7":{"tf":1.0},"78":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"115":{"tf":1.0},"118":{"tf":1.4142135623730951},"32":{"tf":1.0},"46":{"tf":1.7320508075688772},"78":{"tf":1.0}}}}},"o":{"df":1,"docs":{"40":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"t":{"df":8,"docs":{"1":{"tf":1.0},"27":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.4142135623730951},"52":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"df":2,"docs":{"41":{"tf":1.4142135623730951},"42":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":9,"docs":{"27":{"tf":1.0},"41":{"tf":1.0},"45":{"tf":1.0},"54":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"83":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":6,"docs":{"43":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"y":{"df":2,"docs":{"53":{"tf":1.0},"85":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"a":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"18":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":1.0}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"80":{"tf":1.4142135623730951}}}}}}}}},"df":6,"docs":{"73":{"tf":2.8284271247461903},"74":{"tf":3.1622776601683795},"75":{"tf":2.0},"78":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}}}}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}}}},"d":{"df":4,"docs":{"0":{"tf":1.0},"40":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":4,"docs":{"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"8":{"tf":1.0}}},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"107":{"tf":1.0},"16":{"tf":1.0},"63":{"tf":1.0}}},"h":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}},"i":{"c":{"df":16,"docs":{"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":2.23606797749979},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0},"96":{"tf":1.0}}},"df":2,"docs":{"12":{"tf":1.0},"68":{"tf":1.0}}}},"z":{"df":3,"docs":{"105":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}},"df":8,"docs":{"105":{"tf":2.23606797749979},"118":{"tf":1.4142135623730951},"36":{"tf":1.0},"66":{"tf":2.23606797749979},"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"80":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":4,"docs":{"102":{"tf":1.0},"115":{"tf":1.0},"38":{"tf":1.0},"94":{"tf":1.0}}}}},"df":3,"docs":{"113":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":15,"docs":{"18":{"tf":1.0},"27":{"tf":1.0},"36":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.4142135623730951},"87":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"30":{"tf":1.0},"35":{"tf":1.0},"52":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"64":{"tf":1.0}}}},"w":{"df":11,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"27":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"59":{"tf":1.0},"7":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"118":{"tf":1.0}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"24":{"tf":1.0},"55":{"tf":1.0},"89":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":2,"docs":{"35":{"tf":1.0},"94":{"tf":1.0}}}},"t":{"a":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"=":{"$":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"81":{"tf":1.0}}},"df":0,"docs":{}}}},"df":12,"docs":{"20":{"tf":1.0},"68":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":2.23606797749979},"75":{"tf":2.23606797749979},"78":{"tf":2.6457513110645907},"79":{"tf":1.4142135623730951},"80":{"tf":2.0},"81":{"tf":2.449489742783178},"84":{"tf":1.0},"85":{"tf":1.7320508075688772},"94":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"21":{"tf":1.0},"43":{"tf":1.0},"89":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":11,"docs":{"109":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.7320508075688772},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"78":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"106":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"b":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}},"df":2,"docs":{"68":{"tf":1.0},"95":{"tf":1.0}},"g":{"df":4,"docs":{"100":{"tf":1.7320508075688772},"26":{"tf":1.0},"69":{"tf":1.4142135623730951},"95":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"23":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"115":{"tf":1.4142135623730951},"31":{"tf":1.0},"4":{"tf":1.0},"8":{"tf":2.0}}},"y":{"(":{"_":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"d":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}},"df":1,"docs":{"31":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"115":{"tf":2.0}}},"df":0,"docs":{}}}}}}},"t":{"df":3,"docs":{"34":{"tf":1.0},"44":{"tf":1.0},"8":{"tf":1.7320508075688772}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"26":{"tf":1.0},"36":{"tf":1.7320508075688772},"37":{"tf":1.0},"44":{"tf":1.0},"95":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"k":{"(":{"_":{")":{"#":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"118":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"110":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"_":{"(":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"110":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"118":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"118":{"tf":1.7320508075688772}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"113":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":4,"docs":{"102":{"tf":1.0},"105":{"tf":2.6457513110645907},"113":{"tf":1.4142135623730951},"118":{"tf":2.8284271247461903}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"110":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"42":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"88":{"tf":1.0}}},"df":6,"docs":{"23":{"tf":1.4142135623730951},"52":{"tf":1.0},"86":{"tf":2.23606797749979},"87":{"tf":1.7320508075688772},"88":{"tf":2.0},"95":{"tf":1.4142135623730951}}},"l":{"(":{"_":{"#":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"105":{"tf":1.4142135623730951}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"110":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":5,"docs":{"112":{"tf":1.4142135623730951},"44":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"8":{"tf":4.358898943540674}},"e":{"a":{"df":0,"docs":{},"n":{"df":5,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":2.0},"106":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"r":{"df":1,"docs":{"23":{"tf":1.0}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"h":{"df":7,"docs":{"102":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.0},"35":{"tf":1.0},"7":{"tf":1.0},"95":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":2.0}}},"df":0,"docs":{}}},"x":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"110":{"tf":2.0}}}}}}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":2,"docs":{"52":{"tf":1.4142135623730951},"8":{"tf":2.23606797749979}},"e":{"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":2.0}}}},"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":13,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":1.7320508075688772},"75":{"tf":1.7320508075688772},"78":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"80":{"tf":2.6457513110645907},"81":{"tf":2.0},"84":{"tf":2.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":4,"docs":{"102":{"tf":1.0},"114":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"92":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"73":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"18":{"tf":1.0},"69":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"23":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"95":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"l":{"d":{"df":8,"docs":{"20":{"tf":1.0},"24":{"tf":1.4142135623730951},"26":{"tf":2.23606797749979},"28":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"87":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":2,"docs":{"68":{"tf":1.0},"69":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":2.449489742783178}},"s":{":":{":":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"69":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":15,"docs":{"104":{"tf":1.4142135623730951},"109":{"tf":1.0},"111":{"tf":1.0},"27":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":2.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"69":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":1.0},"43":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"7":{"tf":1.0},"77":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}},"g":{"df":0,"docs":{},"o":{"#":{"5":{"0":{"3":{"4":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"36":{"tf":1.0}}}}}}},"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"31":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":30,"docs":{"0":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":2.0},"24":{"tf":1.0},"26":{"tf":2.449489742783178},"27":{"tf":3.1622776601683795},"28":{"tf":1.0},"31":{"tf":2.23606797749979},"32":{"tf":1.0},"35":{"tf":2.0},"36":{"tf":3.1622776601683795},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.7320508075688772},"44":{"tf":2.449489742783178},"49":{"tf":1.0},"5":{"tf":3.1622776601683795},"51":{"tf":1.7320508075688772},"52":{"tf":1.0},"6":{"tf":1.7320508075688772},"7":{"tf":2.8284271247461903},"8":{"tf":1.7320508075688772},"87":{"tf":1.4142135623730951},"94":{"tf":2.449489742783178},"95":{"tf":2.23606797749979}}}}},"s":{"df":0,"docs":{},"e":{"df":24,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"107":{"tf":1.0},"11":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"21":{"tf":1.0},"26":{"tf":1.4142135623730951},"34":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.7320508075688772},"53":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.7320508075688772},"94":{"tf":1.4142135623730951},"95":{"tf":1.0}}},"t":{"_":{"a":{"b":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"0":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"0":{"tf":1.7320508075688772},"10":{"tf":1.0},"23":{"tf":1.4142135623730951},"35":{"tf":1.0},"9":{"tf":2.0}}},"y":{"=":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"u":{"df":0,"docs":{},"s":{"df":6,"docs":{"113":{"tf":1.0},"36":{"tf":1.0},"5":{"tf":1.4142135623730951},"66":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"d":{"df":1,"docs":{"31":{"tf":1.0}}},"df":1,"docs":{"105":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":7,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"112":{"tf":1.0},"16":{"tf":1.0},"45":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":2.0}}}}}}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"92":{"tf":1.4142135623730951}}}}}}},"n":{"df":0,"docs":{},"g":{"df":29,"docs":{"0":{"tf":1.0},"102":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.0},"118":{"tf":1.0},"23":{"tf":1.0},"36":{"tf":1.0},"52":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":2.6457513110645907},"69":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":2.0},"72":{"tf":1.0},"73":{"tf":2.0},"74":{"tf":2.0},"75":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":2.23606797749979},"89":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"m":{"d":{"df":3,"docs":{"78":{"tf":1.0},"79":{"tf":1.0},"85":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":5,"docs":{"67":{"tf":1.4142135623730951},"76":{"tf":2.0},"77":{"tf":2.0},"78":{"tf":3.3166247903554},"85":{"tf":1.4142135623730951}}}}},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":10,"docs":{"1":{"tf":1.4142135623730951},"18":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.7320508075688772},"59":{"tf":1.0},"67":{"tf":1.4142135623730951},"89":{"tf":1.0},"9":{"tf":1.0}}}}}},"r":{"(":{"'":{"df":0,"docs":{},"x":{"df":1,"docs":{"105":{"tf":1.0}}}},"_":{"df":2,"docs":{"105":{"tf":1.0},"118":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"110":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"103":{"tf":1.7320508075688772},"105":{"tf":2.0},"106":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":4,"docs":{"105":{"tf":1.4142135623730951},"106":{"tf":1.0},"56":{"tf":1.7320508075688772},"8":{"tf":2.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.0},"53":{"tf":1.4142135623730951}}}},"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":9,"docs":{"104":{"tf":1.0},"113":{"tf":1.4142135623730951},"45":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"f":{"df":0,"docs":{},"n":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"43":{"tf":1.4142135623730951},"44":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":2,"docs":{"43":{"tf":1.0},"44":{"tf":1.7320508075688772}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"113":{"tf":1.0}}}}}},"df":36,"docs":{"102":{"tf":1.0},"106":{"tf":1.7320508075688772},"113":{"tf":2.23606797749979},"118":{"tf":1.4142135623730951},"15":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"25":{"tf":1.0},"36":{"tf":1.7320508075688772},"40":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.7320508075688772},"55":{"tf":1.4142135623730951},"56":{"tf":2.23606797749979},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":2.23606797749979},"61":{"tf":1.0},"62":{"tf":2.6457513110645907},"63":{"tf":2.6457513110645907},"64":{"tf":1.4142135623730951},"65":{"tf":2.6457513110645907},"66":{"tf":2.0},"7":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"78":{"tf":2.0},"8":{"tf":2.0},"84":{"tf":1.4142135623730951},"94":{"tf":2.0}},"e":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.0},"51":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":10,"docs":{"25":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"74":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"78":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"5":{"tf":1.4142135623730951},"74":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"115":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"0":{"tf":1.0},"43":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"34":{"tf":1.0}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"i":{"/":{"c":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"18":{"tf":2.23606797749979},"19":{"tf":1.0},"20":{"tf":2.0},"49":{"tf":1.0},"5":{"tf":1.0},"67":{"tf":1.0}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"94":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"105":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"78":{"tf":1.0}}}}},"r":{"df":2,"docs":{"92":{"tf":1.0},"95":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"32":{"tf":1.0},"95":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":77,"docs":{"0":{"tf":2.0},"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"100":{"tf":1.0},"102":{"tf":1.0},"107":{"tf":1.4142135623730951},"112":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"18":{"tf":3.0},"19":{"tf":2.449489742783178},"2":{"tf":1.4142135623730951},"20":{"tf":2.23606797749979},"21":{"tf":2.0},"22":{"tf":1.0},"23":{"tf":2.0},"24":{"tf":2.23606797749979},"25":{"tf":2.449489742783178},"26":{"tf":1.7320508075688772},"27":{"tf":2.0},"28":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":4.123105625617661},"32":{"tf":1.4142135623730951},"34":{"tf":1.0},"36":{"tf":1.7320508075688772},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"4":{"tf":2.0},"40":{"tf":1.0},"42":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.7320508075688772},"47":{"tf":1.4142135623730951},"49":{"tf":1.0},"5":{"tf":4.358898943540674},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"57":{"tf":1.0},"6":{"tf":3.1622776601683795},"64":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":2.6457513110645907},"68":{"tf":2.449489742783178},"69":{"tf":1.4142135623730951},"7":{"tf":4.242640687119285},"70":{"tf":2.6457513110645907},"71":{"tf":3.3166247903554},"72":{"tf":2.6457513110645907},"73":{"tf":2.449489742783178},"74":{"tf":2.6457513110645907},"75":{"tf":2.23606797749979},"77":{"tf":1.0},"78":{"tf":2.23606797749979},"79":{"tf":2.449489742783178},"8":{"tf":2.6457513110645907},"80":{"tf":2.0},"81":{"tf":2.0},"82":{"tf":1.7320508075688772},"83":{"tf":2.0},"84":{"tf":1.7320508075688772},"86":{"tf":2.449489742783178},"87":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.7320508075688772},"9":{"tf":2.0},"91":{"tf":1.4142135623730951},"92":{"tf":1.0},"94":{"tf":2.6457513110645907},"95":{"tf":3.605551275463989},"96":{"tf":1.0}}},"y":{"'":{"df":16,"docs":{"10":{"tf":1.0},"102":{"tf":1.0},"11":{"tf":1.0},"113":{"tf":1.4142135623730951},"118":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"26":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"53":{"tf":1.0},"64":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772}}},".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":3,"docs":{"45":{"tf":1.0},"52":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}}}}},":":{":":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"0":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":2,"docs":{"0":{"tf":1.0},"17":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":2,"docs":{"0":{"tf":1.0},"12":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"10":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"47":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":2,"docs":{"45":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}}},"p":{"df":0,"docs":{},"e":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"0":{"tf":1.0},"15":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":2,"docs":{"0":{"tf":1.0},"13":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"16":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":3,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"5":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"11":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":3,"docs":{"40":{"tf":1.4142135623730951},"48":{"tf":1.0},"78":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"40":{"tf":1.0},"52":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"r":{"c":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"35":{"tf":1.0},"40":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"{":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"}":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"65":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"t":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"{":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"63":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"63":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}},"n":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":3,"docs":{"25":{"tf":1.7320508075688772},"52":{"tf":1.7320508075688772},"71":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"o":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"106":{"tf":1.0},"113":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"s":{"df":5,"docs":{"113":{"tf":1.0},"19":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.0},"49":{"tf":1.0}}}},"df":0,"docs":{}},"df":41,"docs":{"0":{"tf":2.449489742783178},"10":{"tf":1.0},"102":{"tf":2.449489742783178},"103":{"tf":1.4142135623730951},"107":{"tf":1.0},"11":{"tf":2.23606797749979},"110":{"tf":1.0},"113":{"tf":1.7320508075688772},"114":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"12":{"tf":2.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.7320508075688772},"15":{"tf":1.4142135623730951},"16":{"tf":1.7320508075688772},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"34":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":2.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951},"5":{"tf":2.8284271247461903},"50":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"66":{"tf":2.449489742783178},"7":{"tf":2.8284271247461903},"78":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}},"r":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":1,"docs":{"118":{"tf":1.0}},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":2,"docs":{"102":{"tf":1.7320508075688772},"107":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"52":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"df":6,"docs":{"0":{"tf":1.0},"103":{"tf":1.0},"30":{"tf":1.0},"77":{"tf":1.0},"94":{"tf":1.0},"98":{"tf":1.0}}},"m":{"a":{"df":1,"docs":{"36":{"tf":1.0}},"n":{"d":{"df":17,"docs":{"18":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"31":{"tf":1.0},"35":{"tf":2.6457513110645907},"46":{"tf":1.0},"5":{"tf":2.0},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"88":{"tf":1.0},"94":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"106":{"tf":1.0},"113":{"tf":1.0},"16":{"tf":1.0},"37":{"tf":1.0},"48":{"tf":1.0},"52":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"t":{"(":{"df":1,"docs":{"74":{"tf":1.0}}},"1":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"78":{"tf":1.0}}},"df":15,"docs":{"26":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":1.0},"36":{"tf":1.7320508075688772},"51":{"tf":1.0},"71":{"tf":2.23606797749979},"74":{"tf":1.4142135623730951},"78":{"tf":3.0},"79":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"81":{"tf":2.0},"82":{"tf":2.449489742783178},"83":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951},"87":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":16,"docs":{"0":{"tf":1.0},"103":{"tf":1.0},"118":{"tf":1.0},"24":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"35":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.4142135623730951},"60":{"tf":2.23606797749979},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"114":{"tf":1.0},"118":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0}}},"t":{"df":2,"docs":{"106":{"tf":1.0},"18":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":16,"docs":{"10":{"tf":1.0},"102":{"tf":1.0},"114":{"tf":2.0},"13":{"tf":1.0},"18":{"tf":1.4142135623730951},"22":{"tf":1.0},"30":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"68":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"102":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"14":{"tf":1.0},"5":{"tf":1.0},"69":{"tf":1.0},"85":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0}}},"x":{"df":7,"docs":{"0":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.0},"115":{"tf":2.449489742783178},"12":{"tf":2.23606797749979},"43":{"tf":1.0},"8":{"tf":2.449489742783178}}}},"i":{"c":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"2":{"tf":1.0},"20":{"tf":1.0},"31":{"tf":1.7320508075688772},"49":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"102":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":4,"docs":{"105":{"tf":1.0},"118":{"tf":1.0},"53":{"tf":1.0},"59":{"tf":1.0}},"u":{"df":1,"docs":{"113":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"42":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":7,"docs":{"102":{"tf":1.0},"105":{"tf":1.4142135623730951},"113":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.0},"44":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{},"f":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"7":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"52":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":8,"docs":{"32":{"tf":1.0},"45":{"tf":1.4142135623730951},"5":{"tf":2.449489742783178},"52":{"tf":4.123105625617661},"7":{"tf":3.1622776601683795},"8":{"tf":3.4641016151377544},"94":{"tf":2.0},"95":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"94":{"tf":1.0}}}}},"i":{"d":{"df":8,"docs":{"0":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"18":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"8":{"tf":2.23606797749979}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"106":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"8":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}},"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":22,"docs":{"0":{"tf":1.0},"102":{"tf":1.0},"105":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"11":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.0},"115":{"tf":1.4142135623730951},"117":{"tf":1.0},"118":{"tf":1.0},"16":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.4142135623730951},"52":{"tf":1.0},"55":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"7":{"tf":2.0},"78":{"tf":1.0},"80":{"tf":1.0},"88":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"102":{"tf":1.4142135623730951},"113":{"tf":1.0},"37":{"tf":1.0},"45":{"tf":1.0},"78":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":5,"docs":{"30":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.4142135623730951},"64":{"tf":1.0},"66":{"tf":3.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":4,"docs":{"18":{"tf":1.7320508075688772},"19":{"tf":1.0},"20":{"tf":1.0},"69":{"tf":1.0}}}}},"r":{"a":{"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"112":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.0},"95":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"91":{"tf":1.4142135623730951},"92":{"tf":1.0},"95":{"tf":2.449489742783178}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"96":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}},"t":{"df":1,"docs":{"51":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"114":{"tf":1.0},"58":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":11,"docs":{"31":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"8":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":2.23606797749979}}}}}},":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"110":{"tf":1.0},"69":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"0":{"tf":1.0},"10":{"tf":1.7320508075688772},"11":{"tf":1.7320508075688772},"116":{"tf":1.0},"78":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":13,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"41":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"114":{"tf":1.0},"118":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"5":{"tf":1.0},"96":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"23":{"tf":1.4142135623730951},"59":{"tf":1.0},"78":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.7320508075688772},"95":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"=":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"69":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":15,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"20":{"tf":1.0},"28":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772},"40":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"64":{"tf":1.0},"66":{"tf":1.7320508075688772},"7":{"tf":1.0},"8":{"tf":2.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":14,"docs":{"106":{"tf":1.4142135623730951},"118":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.0},"32":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":2.0},"36":{"tf":1.4142135623730951},"40":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.0},"84":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":30,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"110":{"tf":1.7320508075688772},"112":{"tf":1.4142135623730951},"113":{"tf":1.7320508075688772},"114":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":2.8284271247461903},"31":{"tf":1.4142135623730951},"36":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"53":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.0},"78":{"tf":2.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.7320508075688772},"94":{"tf":1.0},"95":{"tf":1.7320508075688772}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":3,"docs":{"113":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.4142135623730951}}}}}}},"x":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"104":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"c":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"64":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"(":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":5,"docs":{"56":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":12,"docs":{"104":{"tf":1.0},"113":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0}}},"y":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"69":{"tf":1.0}}}},"t":{"a":{"df":8,"docs":{"102":{"tf":1.7320508075688772},"103":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.4142135623730951},"116":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":7,"docs":{"101":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.7320508075688772},"77":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":1.4142135623730951}}}},"y":{"df":1,"docs":{"68":{"tf":1.0}}}},"b":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":2,"docs":{"50":{"tf":1.0},"8":{"tf":1.7320508075688772}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"d":{"df":2,"docs":{"71":{"tf":1.0},"85":{"tf":2.0}}},"df":2,"docs":{"20":{"tf":1.4142135623730951},"5":{"tf":1.0}},"e":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":3,"docs":{"42":{"tf":1.4142135623730951},"60":{"tf":1.0},"66":{"tf":1.7320508075688772}}}},"b":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"g":{"df":3,"docs":{"32":{"tf":1.0},"50":{"tf":2.0},"52":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"s":{"df":1,"docs":{"42":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":6,"docs":{"103":{"tf":1.7320508075688772},"32":{"tf":1.0},"40":{"tf":2.449489742783178},"41":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.0}},"e":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"40":{"tf":1.4142135623730951},"48":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"!":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"52":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":17,"docs":{"0":{"tf":1.7320508075688772},"10":{"tf":1.0},"117":{"tf":1.0},"14":{"tf":1.0},"20":{"tf":1.0},"31":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"5":{"tf":2.23606797749979},"52":{"tf":1.7320508075688772},"69":{"tf":1.0},"7":{"tf":2.0},"8":{"tf":7.681145747868608},"95":{"tf":1.0},"96":{"tf":1.0}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"52":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.0}}}}},"i":{"d":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":19,"docs":{"104":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"112":{"tf":1.0},"118":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.7320508075688772},"52":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.7320508075688772},"66":{"tf":1.7320508075688772},"7":{"tf":1.0},"70":{"tf":1.7320508075688772},"9":{"tf":1.0},"92":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.4142135623730951},"98":{"tf":1.0}},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":6,"docs":{"111":{"tf":1.0},"35":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.7320508075688772},"55":{"tf":1.0},"61":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"105":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"i":{"df":3,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"7":{"tf":1.0}}},"y":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"p":{"df":1,"docs":{"5":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"d":{"df":12,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.4142135623730951},"64":{"tf":1.0},"78":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"67":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":4,"docs":{"27":{"tf":1.4142135623730951},"7":{"tf":1.0},"78":{"tf":1.4142135623730951},"95":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"15":{"tf":1.0},"24":{"tf":1.0},"58":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"b":{"df":14,"docs":{"101":{"tf":1.0},"103":{"tf":1.7320508075688772},"105":{"tf":1.7320508075688772},"106":{"tf":1.0},"109":{"tf":1.0},"114":{"tf":1.0},"118":{"tf":1.7320508075688772},"23":{"tf":1.0},"4":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"67":{"tf":2.0},"68":{"tf":1.0},"95":{"tf":1.4142135623730951}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":6,"docs":{"0":{"tf":1.0},"24":{"tf":1.0},"32":{"tf":1.0},"40":{"tf":1.4142135623730951},"48":{"tf":1.0},"5":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":4,"docs":{"103":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"6":{"tf":1.0}}}},"r":{"df":3,"docs":{"103":{"tf":1.0},"39":{"tf":1.0},"8":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":6,"docs":{"104":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":1.0},"28":{"tf":1.0},"43":{"tf":1.0},"68":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"103":{"tf":1.0},"32":{"tf":1.0},"46":{"tf":1.0},"66":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"41":{"tf":1.0},"8":{"tf":1.4142135623730951},"81":{"tf":1.0}}}}}}}},"v":{"df":21,"docs":{"24":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":3.3166247903554},"29":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":2.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.4142135623730951},"53":{"tf":1.0},"60":{"tf":1.0},"68":{"tf":1.0},"95":{"tf":2.449489742783178}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":100,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.7320508075688772},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"21":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.4142135623730951},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.4142135623730951},"95":{"tf":2.6457513110645907},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}}}}}},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"53":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.7320508075688772},"64":{"tf":1.7320508075688772}}}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"109":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":3,"docs":{"28":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":14,"docs":{"106":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"13":{"tf":1.0},"18":{"tf":1.0},"26":{"tf":1.0},"36":{"tf":1.0},"44":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"9":{"tf":1.4142135623730951},"95":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"115":{"tf":1.4142135623730951},"66":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"r":{"df":1,"docs":{"31":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":7,"docs":{"106":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0},"32":{"tf":1.0},"39":{"tf":1.4142135623730951},"4":{"tf":1.0},"74":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":16,"docs":{"31":{"tf":1.4142135623730951},"35":{"tf":1.0},"40":{"tf":1.0},"52":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"88":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}},"x":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"5":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"70":{"tf":1.0},"73":{"tf":1.0},"94":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"14":{"tf":1.0},"5":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"7":{"tf":2.0},"8":{"tf":3.4641016151377544}},"e":{"d":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"56":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"105":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"c":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":6,"docs":{"22":{"tf":1.0},"48":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"8":{"tf":2.449489742783178},"95":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":23,"docs":{"100":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"40":{"tf":2.0},"45":{"tf":1.0},"48":{"tf":2.23606797749979},"5":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"57":{"tf":1.0},"67":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.7320508075688772},"8":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.4142135623730951},"93":{"tf":1.0},"95":{"tf":1.7320508075688772},"96":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":6,"docs":{"110":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"101":{"tf":1.0},"103":{"tf":2.0}}}}},"df":0,"docs":{}},"n":{"'":{"df":0,"docs":{},"t":{"df":18,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.4142135623730951},"39":{"tf":1.0},"42":{"tf":1.7320508075688772},"5":{"tf":1.0},"53":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"85":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":17,"docs":{"104":{"tf":1.0},"109":{"tf":1.0},"23":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.4142135623730951},"45":{"tf":1.0},"52":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"71":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"81":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"36":{"tf":1.0},"42":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"63":{"tf":1.0}}}},"w":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"113":{"tf":1.7320508075688772},"99":{"tf":1.4142135623730951}},"s":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"118":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"31":{"tf":2.0},"39":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":2.449489742783178}}}}}},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"64":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"e":{"df":2,"docs":{"92":{"tf":1.0},"94":{"tf":1.0}}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"78":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":7,"docs":{"100":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.0},"30":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0},"77":{"tf":1.0}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"5":{"tf":1.0}}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"39":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":12,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"109":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"18":{"tf":1.0},"36":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951},"71":{"tf":1.0},"8":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":9,"docs":{"0":{"tf":1.0},"112":{"tf":1.0},"115":{"tf":1.0},"27":{"tf":1.0},"36":{"tf":1.4142135623730951},"7":{"tf":1.0},"78":{"tf":1.4142135623730951},"8":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"113":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"18":{"tf":1.0},"34":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"113":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0}}}}},"y":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"<":{"'":{"_":{"df":3,"docs":{"113":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"44":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"104":{"tf":1.0},"40":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":7,"docs":{"104":{"tf":1.0},"114":{"tf":1.0},"40":{"tf":1.4142135623730951},"42":{"tf":2.0},"43":{"tf":2.0},"44":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}}}}},"s":{"df":0,"docs":{},"i":{"df":3,"docs":{"102":{"tf":1.0},"13":{"tf":1.0},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"106":{"tf":1.0},"114":{"tf":1.0},"118":{"tf":1.0},"13":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0},"95":{"tf":2.0}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"5":{"tf":1.0},"74":{"tf":1.0},"87":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"103":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"92":{"tf":1.0}}}}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"6":{"tf":1.0},"69":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"46":{"tf":1.0},"78":{"tf":1.0}}}}}}},"df":4,"docs":{"78":{"tf":1.0},"8":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":3.0}}}},"df":0,"docs":{}}}},"i":{"b":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"105":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"117":{"tf":1.0},"8":{"tf":1.7320508075688772}}}}}},"v":{"df":1,"docs":{"5":{"tf":1.0}}}},"m":{"df":0,"docs":{},"t":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"110":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"43":{"tf":1.0},"44":{"tf":1.0}}}},"t":{"df":4,"docs":{"32":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":2.0},"7":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":5,"docs":{"105":{"tf":2.23606797749979},"110":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"80":{"tf":1.0}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":7,"docs":{"15":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951},"47":{"tf":1.0},"5":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"95":{"tf":1.0}},"e":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{}}}}},"d":{"df":4,"docs":{"100":{"tf":1.0},"110":{"tf":1.0},"117":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":3,"docs":{"18":{"tf":1.0},"8":{"tf":1.7320508075688772},"95":{"tf":1.0}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":4,"docs":{"104":{"tf":1.0},"66":{"tf":1.0},"79":{"tf":1.0},"95":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"44":{"tf":1.0},"45":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"57":{"tf":1.0},"61":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"103":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"52":{"tf":1.0},"67":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"8":{"tf":1.0}}},"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":5,"docs":{"110":{"tf":2.6457513110645907},"111":{"tf":2.0},"112":{"tf":1.4142135623730951},"57":{"tf":1.0},"8":{"tf":2.23606797749979}}}},"v":{"df":2,"docs":{"18":{"tf":1.0},"19":{"tf":1.0}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"39":{"tf":1.0},"7":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"118":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"8":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":7,"docs":{"18":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":3,"docs":{"17":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"96":{"tf":1.0},"98":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"c":{"df":7,"docs":{"115":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"7":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":2,"docs":{"118":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":10,"docs":{"102":{"tf":1.0},"113":{"tf":1.0},"118":{"tf":1.0},"15":{"tf":1.0},"5":{"tf":1.7320508075688772},"65":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"118":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"78":{"tf":1.0},"94":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"56":{"tf":1.4142135623730951},"57":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":31,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":2.23606797749979},"106":{"tf":2.23606797749979},"107":{"tf":1.0},"111":{"tf":1.7320508075688772},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"115":{"tf":2.449489742783178},"117":{"tf":1.0},"118":{"tf":2.23606797749979},"26":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"45":{"tf":1.7320508075688772},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.7320508075688772},"5":{"tf":2.449489742783178},"58":{"tf":1.0},"6":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"7":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":2.6457513110645907},"9":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"82":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"110":{"tf":1.0}}}}}},"df":1,"docs":{"8":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"36":{"tf":1.0},"46":{"tf":1.0},"51":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":8,"docs":{"114":{"tf":1.4142135623730951},"23":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"t":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"104":{"tf":1.0},"44":{"tf":1.0},"66":{"tf":2.23606797749979},"78":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"106":{"tf":1.4142135623730951},"66":{"tf":2.8284271247461903}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":12,"docs":{"104":{"tf":1.0},"106":{"tf":1.0},"113":{"tf":1.0},"15":{"tf":1.0},"26":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.7320508075688772},"95":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"89":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"114":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":9,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"40":{"tf":1.0},"53":{"tf":1.0},"79":{"tf":1.0},"86":{"tf":1.0},"93":{"tf":1.0}}}},"n":{"df":3,"docs":{"104":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"115":{"tf":1.0},"59":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"r":{"(":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"(":{"_":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"110":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"118":{"tf":1.0}}}}}}},".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"102":{"tf":1.7320508075688772},"113":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"104":{"tf":1.0}}}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"'":{"_":{"df":7,"docs":{"45":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"113":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"118":{"tf":1.0}}}}}}},"df":1,"docs":{"118":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"55":{"tf":1.4142135623730951},"61":{"tf":1.0}}},"y":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"55":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":18,"docs":{"104":{"tf":1.7320508075688772},"105":{"tf":3.872983346207417},"106":{"tf":2.0},"110":{"tf":1.0},"111":{"tf":1.4142135623730951},"113":{"tf":2.0},"117":{"tf":1.0},"118":{"tf":3.0},"45":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"60":{"tf":1.0},"61":{"tf":2.0},"62":{"tf":2.23606797749979},"63":{"tf":1.0},"64":{"tf":2.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":22,"docs":{"101":{"tf":1.0},"102":{"tf":1.7320508075688772},"103":{"tf":2.449489742783178},"104":{"tf":1.4142135623730951},"105":{"tf":3.0},"106":{"tf":2.8284271247461903},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"12":{"tf":1.0},"47":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"56":{"tf":2.0},"60":{"tf":1.0},"61":{"tf":2.23606797749979},"63":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"113":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.7320508075688772},"7":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"115":{"tf":1.0},"30":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"!":{"(":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":2,"docs":{"43":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"0":{"df":3,"docs":{"78":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951}}},"3":{"2":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"e":{"df":3,"docs":{"93":{"tf":1.0},"94":{"tf":1.4142135623730951},"96":{"tf":1.7320508075688772}}},"t":{"df":3,"docs":{"114":{"tf":1.0},"43":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":5,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.4142135623730951},"74":{"tf":1.0},"80":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"74":{"tf":1.0}}}}}},"s":{"df":18,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.7320508075688772},"112":{"tf":1.0},"115":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"18":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.4142135623730951},"44":{"tf":1.0},"5":{"tf":2.0},"52":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"8":{"tf":4.242640687119285},"94":{"tf":1.4142135623730951}}}},"r":{"df":1,"docs":{"42":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"42":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":6,"docs":{"101":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"45":{"tf":2.0},"68":{"tf":1.0},"7":{"tf":2.449489742783178}},"e":{"(":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"d":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":3,"docs":{"14":{"tf":1.0},"30":{"tf":1.0},"5":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"25":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":1,"docs":{"71":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"94":{"tf":1.0}}}}}},"f":{"df":1,"docs":{"71":{"tf":1.0}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":3,"docs":{"45":{"tf":1.4142135623730951},"52":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":21,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"26":{"tf":2.0},"35":{"tf":2.0},"36":{"tf":4.0},"37":{"tf":2.0},"38":{"tf":1.0},"40":{"tf":1.7320508075688772},"44":{"tf":1.0},"45":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":2.0},"69":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"71":{"tf":1.0},"78":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"80":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"94":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":5,"docs":{"113":{"tf":1.4142135623730951},"118":{"tf":1.7320508075688772},"78":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"48":{"tf":1.0},"78":{"tf":1.0}}}},"d":{"df":19,"docs":{"102":{"tf":1.0},"117":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":2,"docs":{"100":{"tf":1.0},"114":{"tf":1.0}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"94":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":29,"docs":{"100":{"tf":1.0},"102":{"tf":1.0},"106":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.4142135623730951},"114":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.0},"18":{"tf":1.0},"22":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.4142135623730951},"56":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"74":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}}}},"t":{"df":4,"docs":{"34":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"78":{"tf":1.0}}},"x":{"df":15,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"16":{"tf":1.0},"18":{"tf":1.0},"23":{"tf":1.4142135623730951},"26":{"tf":1.0},"28":{"tf":1.0},"37":{"tf":1.4142135623730951},"5":{"tf":1.0},"69":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"78":{"tf":2.0},"94":{"tf":1.4142135623730951},"95":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"/":{"a":{"d":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"35":{"tf":1.0},"7":{"tf":1.0}}},"t":{"df":2,"docs":{"103":{"tf":1.0},"106":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"102":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"t":{"df":3,"docs":{"27":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0}}}},"n":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"43":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":24,"docs":{"104":{"tf":1.0},"106":{"tf":1.0},"112":{"tf":1.4142135623730951},"113":{"tf":1.4142135623730951},"115":{"tf":1.0},"118":{"tf":1.4142135623730951},"30":{"tf":1.0},"36":{"tf":3.1622776601683795},"43":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772},"45":{"tf":2.0},"5":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{":":{":":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"(":{"_":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}},"<":{"'":{"_":{"df":2,"docs":{"43":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"12":{"tf":1.0},"93":{"tf":1.0}}}}},"df":1,"docs":{"36":{"tf":1.0}},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"52":{"tf":1.0}}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"95":{"tf":1.0}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":33,"docs":{"102":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"106":{"tf":1.7320508075688772},"109":{"tf":1.4142135623730951},"110":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"25":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.7320508075688772},"40":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.4142135623730951},"8":{"tf":1.0},"85":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"95":{"tf":1.7320508075688772}}}}}},"o":{"!":{"(":{"\"":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"x":{"df":1,"docs":{"58":{"tf":1.0}}}},".":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}}},"_":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"34":{"tf":1.0},"40":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0}}}},"df":0,"docs":{}}}}},"d":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"36":{"tf":1.0}}},"df":12,"docs":{"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"32":{"tf":1.0},"36":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"48":{"tf":1.0},"66":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"40":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"c":{"df":3,"docs":{"31":{"tf":1.0},"69":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"g":{"df":2,"docs":{"77":{"tf":1.0},"79":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.0}}}}}}}},"k":{"df":3,"docs":{"25":{"tf":1.4142135623730951},"71":{"tf":1.0},"80":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"27":{"tf":1.4142135623730951},"49":{"tf":1.7320508075688772},"52":{"tf":1.0},"67":{"tf":1.0},"8":{"tf":2.0},"86":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.0}}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"118":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"df":16,"docs":{"107":{"tf":1.0},"110":{"tf":1.4142135623730951},"112":{"tf":1.0},"118":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.4142135623730951},"64":{"tf":1.0},"7":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":4,"docs":{"30":{"tf":1.0},"5":{"tf":1.4142135623730951},"94":{"tf":1.7320508075688772},"96":{"tf":1.0}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"s":{"d":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":4,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"30":{"tf":1.0},"5":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"115":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"53":{"tf":1.0},"66":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"44":{"tf":1.0},"5":{"tf":1.0},"63":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}},"i":{"df":1,"docs":{"8":{"tf":2.0}}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":17,"docs":{"104":{"tf":1.0},"118":{"tf":1.7320508075688772},"32":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":2.0},"44":{"tf":1.4142135623730951},"48":{"tf":1.0},"53":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"64":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":3.0}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"115":{"tf":1.0},"36":{"tf":1.0},"59":{"tf":1.0},"65":{"tf":1.0},"7":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":7,"docs":{"113":{"tf":1.0},"115":{"tf":1.4142135623730951},"118":{"tf":2.0},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.7320508075688772},"94":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":19,"docs":{"115":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"15":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":2.23606797749979},"37":{"tf":1.0},"40":{"tf":1.0},"46":{"tf":1.4142135623730951},"5":{"tf":1.0},"52":{"tf":2.0},"6":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.4142135623730951},"68":{"tf":1.0},"8":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.4142135623730951}}}}},"t":{"df":8,"docs":{"22":{"tf":1.4142135623730951},"32":{"tf":1.0},"34":{"tf":1.4142135623730951},"63":{"tf":1.0},"68":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.4142135623730951},"96":{"tf":1.0}}}},"i":{"b":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{},"t":{"@":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{":":{"<":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"25":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":16,"docs":{"25":{"tf":2.449489742783178},"27":{"tf":1.0},"28":{"tf":1.0},"69":{"tf":2.8284271247461903},"70":{"tf":1.7320508075688772},"71":{"tf":2.23606797749979},"72":{"tf":1.4142135623730951},"74":{"tf":3.3166247903554},"75":{"tf":2.0},"78":{"tf":1.0},"80":{"tf":2.449489742783178},"81":{"tf":2.23606797749979},"82":{"tf":1.4142135623730951},"83":{"tf":1.7320508075688772},"84":{"tf":1.0},"95":{"tf":1.0}},"h":{"df":0,"docs":{},"u":{"b":{"df":3,"docs":{"19":{"tf":2.0},"74":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"l":{"a":{"b":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":14,"docs":{"105":{"tf":2.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"23":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.0}},"n":{"df":8,"docs":{"106":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"5":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"66":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"o":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"102":{"tf":1.4142135623730951}}}},"df":5,"docs":{"1":{"tf":1.0},"106":{"tf":1.0},"53":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0}},"o":{"d":{"df":8,"docs":{"10":{"tf":1.0},"118":{"tf":1.0},"23":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.0},"66":{"tf":1.0},"78":{"tf":1.4142135623730951},"92":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"2":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"3":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"117":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"p":{"df":3,"docs":{"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":14,"docs":{"10":{"tf":1.4142135623730951},"106":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":2.6457513110645907},"16":{"tf":1.7320508075688772},"17":{"tf":1.0},"35":{"tf":1.0},"5":{"tf":4.795831523312719},"7":{"tf":1.7320508075688772},"9":{"tf":1.0},"94":{"tf":1.4142135623730951}}}},"w":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"92":{"tf":1.0}}}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"23":{"tf":1.0},"68":{"tf":1.0},"94":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"df":11,"docs":{"104":{"tf":1.4142135623730951},"3":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"43":{"tf":1.0},"53":{"tf":1.4142135623730951},"60":{"tf":1.0},"68":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"95":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"34":{"tf":1.0},"40":{"tf":1.0},"49":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"h":{"a":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"23":{"tf":1.0},"24":{"tf":2.0},"31":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"113":{"tf":1.0},"41":{"tf":1.0},"95":{"tf":1.0}},"l":{"df":4,"docs":{"117":{"tf":1.0},"34":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"84":{"tf":1.0},"94":{"tf":1.0}}}}}},"r":{"d":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":8,"docs":{"102":{"tf":1.7320508075688772},"106":{"tf":1.0},"115":{"tf":1.0},"31":{"tf":1.0},"81":{"tf":1.0},"92":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":3,"docs":{"74":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0}}},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"106":{"tf":1.0},"42":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":3,"docs":{"100":{"tf":1.0},"103":{"tf":1.0},"87":{"tf":1.0}},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":4,"docs":{"78":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.0}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"116":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"21":{"tf":1.0}}}},"p":{"df":11,"docs":{"0":{"tf":1.0},"18":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"9":{"tf":1.0},"95":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":19,"docs":{"105":{"tf":1.0},"107":{"tf":1.0},"110":{"tf":1.4142135623730951},"112":{"tf":1.0},"21":{"tf":1.0},"32":{"tf":1.0},"40":{"tf":1.4142135623730951},"43":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.4142135623730951},"58":{"tf":1.0},"61":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0},"98":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"106":{"tf":1.0}},"i":{"df":2,"docs":{"115":{"tf":1.0},"35":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"h":{"df":5,"docs":{"23":{"tf":1.0},"30":{"tf":1.0},"47":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}}}}},"r":{"'":{"df":1,"docs":{"115":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"<":{"'":{"_":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"58":{"tf":2.23606797749979}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"58":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":11,"docs":{"102":{"tf":2.0},"109":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.4142135623730951},"114":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"47":{"tf":1.7320508075688772},"55":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"94":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"u":{"df":1,"docs":{"23":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"27":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"3":{"0":{"0":{"0":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"<":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"74":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"25":{"tf":1.0},"70":{"tf":1.0},"75":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"'":{"d":{"df":1,"docs":{"113":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":1,"docs":{"116":{"tf":1.0}}},"v":{"df":1,"docs":{"116":{"tf":1.0}}}},".":{"df":1,"docs":{"8":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"j":{"df":1,"docs":{"112":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"c":{"df":3,"docs":{"30":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.4142135623730951}}},"d":{"df":2,"docs":{"23":{"tf":1.0},"64":{"tf":1.4142135623730951}},"e":{"a":{"df":4,"docs":{"0":{"tf":1.0},"118":{"tf":1.4142135623730951},"23":{"tf":1.0},"78":{"tf":1.4142135623730951}},"l":{"df":2,"docs":{"77":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":3,"docs":{"105":{"tf":1.0},"44":{"tf":1.4142135623730951},"8":{"tf":2.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"43":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"14":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"'":{"df":1,"docs":{"105":{"tf":1.0}}},"(":{"_":{"df":3,"docs":{"105":{"tf":2.8284271247461903},"113":{"tf":1.4142135623730951},"118":{"tf":1.7320508075688772}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"110":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"102":{"tf":1.4142135623730951},"113":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"_":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"118":{"tf":1.0}}}}}}},"df":1,"docs":{"118":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"102":{"tf":1.0},"105":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"_":{"df":1,"docs":{"118":{"tf":2.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"118":{"tf":1.0}}}}}}},"df":2,"docs":{"110":{"tf":1.0},"118":{"tf":1.0}}}}},"s":{"_":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"44":{"tf":1.0},"66":{"tf":1.0},"8":{"tf":2.449489742783178}}}}}},"m":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"103":{"tf":1.0}}}},"l":{"<":{"'":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"x":{"df":3,"docs":{"45":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"65":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"!":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":13,"docs":{"104":{"tf":1.0},"112":{"tf":1.0},"36":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"52":{"tf":2.449489742783178},"56":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":25,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"107":{"tf":1.7320508075688772},"110":{"tf":1.4142135623730951},"112":{"tf":2.8284271247461903},"113":{"tf":1.4142135623730951},"114":{"tf":2.23606797749979},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":3.1622776601683795},"36":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.7320508075688772},"91":{"tf":1.0},"94":{"tf":2.23606797749979},"95":{"tf":1.7320508075688772}},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"64":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"53":{"tf":1.0},"64":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"<":{"'":{"_":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":10,"docs":{"117":{"tf":1.0},"40":{"tf":1.4142135623730951},"42":{"tf":1.0},"5":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":1.0},"8":{"tf":2.449489742783178},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"115":{"tf":1.0},"66":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":13,"docs":{"0":{"tf":1.0},"102":{"tf":1.0},"118":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"78":{"tf":1.4142135623730951},"89":{"tf":1.0},"91":{"tf":1.4142135623730951},"94":{"tf":2.0},"95":{"tf":2.23606797749979}}}}}}},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"(":{"#":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":16,"docs":{"0":{"tf":1.0},"19":{"tf":1.0},"24":{"tf":1.0},"37":{"tf":1.0},"5":{"tf":1.7320508075688772},"50":{"tf":1.0},"51":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.7320508075688772},"8":{"tf":2.0},"82":{"tf":1.0},"94":{"tf":1.0}},"e":{"!":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"a":{"df":0,"docs":{},"t":{"!":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"!":{"(":{"\"":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"113":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"13":{"tf":1.0},"69":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"56":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"102":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"x":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"i":{"c":{"df":2,"docs":{"104":{"tf":1.0},"8":{"tf":1.7320508075688772}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"95":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":18,"docs":{"103":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.0},"17":{"tf":1.0},"27":{"tf":1.0},"34":{"tf":1.0},"42":{"tf":1.7320508075688772},"43":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.4142135623730951},"88":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":22,"docs":{"67":{"tf":2.23606797749979},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"40":{"tf":1.0},"45":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"102":{"tf":1.4142135623730951},"113":{"tf":1.0}}},"df":0,"docs":{}}}},"df":3,"docs":{"113":{"tf":1.4142135623730951},"115":{"tf":1.0},"118":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":1,"docs":{"111":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":5,"docs":{"39":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"103":{"tf":1.0},"116":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":9,"docs":{"1":{"tf":2.6457513110645907},"19":{"tf":1.0},"2":{"tf":1.7320508075688772},"24":{"tf":1.0},"3":{"tf":1.4142135623730951},"31":{"tf":3.0},"4":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"87":{"tf":1.7320508075688772}}},"n":{"c":{"df":3,"docs":{"56":{"tf":1.0},"57":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":10,"docs":{"103":{"tf":1.4142135623730951},"106":{"tf":1.0},"11":{"tf":1.0},"118":{"tf":1.0},"15":{"tf":1.0},"35":{"tf":1.4142135623730951},"48":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"(":{"_":{"df":3,"docs":{"105":{"tf":1.0},"106":{"tf":1.0},"118":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"u":{"1":{"2":{"8":{"df":1,"docs":{"110":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"115":{"tf":1.0},"57":{"tf":1.0}},"e":{"df":0,"docs":{},"g":{"df":2,"docs":{"105":{"tf":1.0},"106":{"tf":1.7320508075688772}},"r":{"df":5,"docs":{"114":{"tf":1.0},"18":{"tf":1.7320508075688772},"19":{"tf":1.0},"20":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"j":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}}}}},"n":{"d":{"df":3,"docs":{"106":{"tf":1.0},"26":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":2,"docs":{"15":{"tf":1.0},"5":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":9,"docs":{"17":{"tf":1.0},"21":{"tf":1.4142135623730951},"23":{"tf":1.0},"36":{"tf":1.0},"56":{"tf":1.0},"7":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}}}},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"30":{"tf":1.4142135623730951},"47":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":9,"docs":{"102":{"tf":1.0},"30":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.4142135623730951},"8":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.4142135623730951},"96":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":5,"docs":{"101":{"tf":1.0},"109":{"tf":1.0},"115":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"94":{"tf":1.0}},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"69":{"tf":1.0},"8":{"tf":1.0}}}}}}},"o":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"v":{"4":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"6":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"94":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}}}}},"s":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"df":1,"docs":{"56":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":1,"docs":{"56":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"112":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"(":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"64":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"(":{"c":{"df":0,"docs":{},"x":{"df":2,"docs":{"63":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"53":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"(":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"63":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"<":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":4,"docs":{"109":{"tf":1.7320508075688772},"112":{"tf":2.449489742783178},"114":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"106":{"tf":1.0},"111":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":9,"docs":{"0":{"tf":1.0},"115":{"tf":1.0},"5":{"tf":1.4142135623730951},"78":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":2.23606797749979},"96":{"tf":2.8284271247461903}},"e":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"t":{"'":{"df":13,"docs":{"102":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"106":{"tf":1.0},"110":{"tf":1.0},"113":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"39":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"95":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":11,"docs":{"100":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":2.23606797749979},"64":{"tf":2.6457513110645907},"65":{"tf":1.0},"8":{"tf":2.0}}},"r":{"df":2,"docs":{"36":{"tf":1.0},"64":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":7,"docs":{"115":{"tf":1.4142135623730951},"118":{"tf":1.0},"15":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0}}}}}}}},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"b":{"df":3,"docs":{"13":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.7320508075688772}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":2,"docs":{"55":{"tf":1.0},"61":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"16":{"tf":1.0},"73":{"tf":1.0}}}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":5,"docs":{"36":{"tf":1.0},"5":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"78":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}}}},"i":{"b":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"102":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.7320508075688772},"61":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":6,"docs":{"104":{"tf":1.0},"115":{"tf":1.7320508075688772},"117":{"tf":1.0},"14":{"tf":1.0},"58":{"tf":1.0},"95":{"tf":1.0}},"n":{"df":3,"docs":{"103":{"tf":1.0},"115":{"tf":1.0},"95":{"tf":1.0}}}}}}},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"43":{"tf":1.0},"78":{"tf":1.7320508075688772}}}}},"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"53":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"73":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"#":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"46":{"tf":1.0}}}}}},"/":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"71":{"tf":1.0},"75":{"tf":1.0}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":14,"docs":{"25":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"68":{"tf":2.449489742783178},"69":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"71":{"tf":2.449489742783178},"72":{"tf":2.449489742783178},"75":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"95":{"tf":1.0}}}}}}},"df":2,"docs":{"63":{"tf":1.4142135623730951},"64":{"tf":2.23606797749979}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{":":{":":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"a":{"df":0,"docs":{},"g":{"df":7,"docs":{"101":{"tf":1.0},"103":{"tf":1.4142135623730951},"118":{"tf":2.23606797749979},"16":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"8":{"tf":2.0}},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"k":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"b":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"105":{"tf":1.4142135623730951},"40":{"tf":1.0},"45":{"tf":1.0},"63":{"tf":1.0},"80":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"/":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"55":{"tf":1.0},"61":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"<":{"'":{"_":{"df":5,"docs":{"56":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0}}},"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"x":{"df":3,"docs":{"45":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":3,"docs":{"54":{"tf":1.0},"55":{"tf":1.7320508075688772},"61":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"<":{"'":{"_":{"df":5,"docs":{"56":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0}}},"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"x":{"df":3,"docs":{"45":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":4,"docs":{"42":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"114":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"r":{"df":6,"docs":{"104":{"tf":1.0},"113":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"93":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"19":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"68":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0}}}},"x":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.0}}}}}},"y":{"df":1,"docs":{"91":{"tf":1.0}}}},"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"d":{"df":3,"docs":{"113":{"tf":1.0},"118":{"tf":1.0},"94":{"tf":1.4142135623730951}}},"df":0,"docs":{},"v":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{".":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":3,"docs":{"115":{"tf":1.0},"18":{"tf":1.0},"67":{"tf":1.0}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"42":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}},"t":{"'":{"df":5,"docs":{"36":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.4142135623730951},"56":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":13,"docs":{"0":{"tf":1.7320508075688772},"104":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"40":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":2.0},"58":{"tf":1.0},"7":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.0}}}}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":1,"docs":{"52":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"103":{"tf":1.0},"113":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":2.0}}}}},"n":{"df":0,"docs":{},"e":{"df":7,"docs":{"40":{"tf":1.0},"5":{"tf":1.4142135623730951},"66":{"tf":1.0},"69":{"tf":1.0},"8":{"tf":1.7320508075688772},"85":{"tf":1.4142135623730951},"94":{"tf":1.0}}},"k":{"df":7,"docs":{"31":{"tf":1.0},"39":{"tf":1.0},"53":{"tf":1.0},"59":{"tf":1.7320508075688772},"60":{"tf":1.0},"7":{"tf":1.0},"78":{"tf":1.7320508075688772}},"e":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"t":{"'":{"df":2,"docs":{"32":{"tf":1.0},"45":{"tf":1.7320508075688772}}},"(":{"df":1,"docs":{"7":{"tf":1.0}}},"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"52":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"24":{"tf":1.0},"28":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"df":66,"docs":{"0":{"tf":3.3166247903554},"10":{"tf":2.449489742783178},"101":{"tf":1.0},"102":{"tf":3.1622776601683795},"103":{"tf":1.0},"104":{"tf":1.0},"106":{"tf":2.449489742783178},"107":{"tf":1.7320508075688772},"11":{"tf":3.1622776601683795},"112":{"tf":1.0},"113":{"tf":2.23606797749979},"114":{"tf":2.449489742783178},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":3.0},"12":{"tf":2.0},"13":{"tf":1.7320508075688772},"14":{"tf":2.23606797749979},"15":{"tf":2.0},"16":{"tf":2.6457513110645907},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"23":{"tf":2.6457513110645907},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"32":{"tf":4.123105625617661},"33":{"tf":1.0},"34":{"tf":2.449489742783178},"35":{"tf":3.4641016151377544},"36":{"tf":3.4641016151377544},"37":{"tf":1.7320508075688772},"38":{"tf":1.7320508075688772},"39":{"tf":1.4142135623730951},"40":{"tf":4.0},"41":{"tf":3.4641016151377544},"42":{"tf":2.8284271247461903},"43":{"tf":3.1622776601683795},"44":{"tf":3.0},"45":{"tf":3.1622776601683795},"46":{"tf":2.6457513110645907},"47":{"tf":2.0},"48":{"tf":3.0},"49":{"tf":1.0},"5":{"tf":5.477225575051661},"50":{"tf":1.4142135623730951},"51":{"tf":1.7320508075688772},"52":{"tf":3.872983346207417},"53":{"tf":2.6457513110645907},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":1.0},"66":{"tf":2.449489742783178},"7":{"tf":4.69041575982343},"73":{"tf":1.0},"78":{"tf":2.23606797749979},"8":{"tf":4.58257569495584},"89":{"tf":1.4142135623730951},"9":{"tf":3.4641016151377544},"94":{"tf":3.605551275463989},"95":{"tf":2.6457513110645907},"96":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"116":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"94":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"39":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":17,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"118":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.4142135623730951},"36":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.4142135623730951},"52":{"tf":1.0},"64":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":3.7416573867739413},"9":{"tf":1.0},"95":{"tf":1.4142135623730951},"96":{"tf":1.0}}}},"t":{"(":{"!":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"_":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"_":{"#":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"106":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},")":{"*":{"#":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"106":{"tf":1.0}}}}}},"df":0,"docs":{}},"+":{"#":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"117":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"{":{"1":{"0":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}},"5":{",":{"1":{"0":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":3,"docs":{"105":{"tf":1.4142135623730951},"111":{"tf":1.0},"117":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"110":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"_":{")":{")":{"df":0,"docs":{},"{":{"1":{"0":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"105":{"tf":1.7320508075688772},"111":{"tf":1.0}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":3,"docs":{"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951}},"e":{")":{")":{"df":0,"docs":{},"{":{"2":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"105":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"(":{"'":{"df":0,"docs":{},"x":{"'":{")":{")":{"df":0,"docs":{},"{":{"2":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"105":{"tf":1.0}}}},"_":{"#":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"105":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{")":{"#":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{")":{"#":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"106":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},")":{"#":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"105":{"tf":1.0}}}}}},")":{"#":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"105":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"_":{"#":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"105":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},")":{")":{"#":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"105":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"102":{"tf":1.0}}},"df":0,"docs":{}}}},":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":6,"docs":{"105":{"tf":2.23606797749979},"106":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":2.0},"112":{"tf":1.4142135623730951},"118":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":4.123105625617661},"106":{"tf":2.6457513110645907},"117":{"tf":1.4142135623730951},"118":{"tf":1.7320508075688772},"8":{"tf":2.23606797749979}}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":12,"docs":{"11":{"tf":1.0},"20":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"80":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.0}}},"t":{"df":2,"docs":{"32":{"tf":1.0},"35":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":4,"docs":{"28":{"tf":1.4142135623730951},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}},"i":{"c":{"df":4,"docs":{"103":{"tf":1.0},"32":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"89":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":18,"docs":{"102":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.4142135623730951},"115":{"tf":1.7320508075688772},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"24":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.7320508075688772},"64":{"tf":1.0},"78":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"96":{"tf":1.0}}},"s":{"df":1,"docs":{"95":{"tf":1.0}}}},"t":{"df":8,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.7320508075688772},"118":{"tf":1.0},"53":{"tf":1.0},"66":{"tf":1.0}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"109":{"tf":1.4142135623730951},"111":{"tf":1.7320508075688772},"45":{"tf":1.0},"8":{"tf":1.0}}}}}}},"m":{"!":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}},"a":{"c":{"df":1,"docs":{"66":{"tf":1.0}},"o":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}}}},"df":13,"docs":{"102":{"tf":1.0},"104":{"tf":1.7320508075688772},"106":{"tf":1.4142135623730951},"111":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":1.0},"66":{"tf":3.7416573867739413},"8":{"tf":3.0}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"e":{"df":6,"docs":{"21":{"tf":1.0},"28":{"tf":1.0},"68":{"tf":1.0},"8":{"tf":1.0},"88":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"109":{"tf":1.0},"36":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"115":{"tf":1.0},"67":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"102":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":34,"docs":{"102":{"tf":1.0},"106":{"tf":1.0},"114":{"tf":1.4142135623730951},"118":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.4142135623730951},"27":{"tf":1.0},"28":{"tf":1.0},"37":{"tf":1.0},"42":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":2.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"78":{"tf":2.0},"80":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.4142135623730951},"88":{"tf":1.7320508075688772},"89":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.7320508075688772}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"1":{"tf":1.0},"94":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":4,"docs":{"5":{"tf":1.0},"56":{"tf":1.0},"8":{"tf":2.0},"94":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"36":{"tf":1.7320508075688772},"8":{"tf":1.0}}}}}}},"u":{"a":{"df":0,"docs":{},"l":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"i":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"45":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"df":10,"docs":{"103":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"32":{"tf":1.0},"38":{"tf":1.7320508075688772},"41":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.4142135623730951},"69":{"tf":1.0},"78":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"45":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"y":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"p":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"64":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"40":{"tf":1.0},"7":{"tf":1.0}}},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":3,"docs":{"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"25":{"tf":2.23606797749979},"72":{"tf":1.7320508075688772},"78":{"tf":1.0},"80":{"tf":2.23606797749979}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"(":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"63":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":20,"docs":{"102":{"tf":2.0},"103":{"tf":2.6457513110645907},"104":{"tf":2.449489742783178},"105":{"tf":5.477225575051661},"106":{"tf":3.4641016151377544},"109":{"tf":1.0},"112":{"tf":2.23606797749979},"113":{"tf":2.6457513110645907},"114":{"tf":1.4142135623730951},"115":{"tf":2.0},"117":{"tf":2.8284271247461903},"118":{"tf":2.6457513110645907},"39":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"57":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"66":{"tf":1.0},"8":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"s":{"!":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"x":{"df":1,"docs":{"8":{"tf":3.1622776601683795}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"18":{"tf":1.0},"8":{"tf":4.123105625617661}}}}}}},"y":{"b":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}},"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":4,"docs":{"86":{"tf":1.4142135623730951},"87":{"tf":2.23606797749979},"88":{"tf":1.7320508075688772},"95":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":3,"docs":{"66":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":12,"docs":{"10":{"tf":1.0},"102":{"tf":1.0},"105":{"tf":1.0},"114":{"tf":1.0},"12":{"tf":1.0},"30":{"tf":1.4142135623730951},"42":{"tf":1.0},"5":{"tf":1.0},"58":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"95":{"tf":2.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"43":{"tf":1.0},"44":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}}},"t":{"df":1,"docs":{"5":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"68":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"95":{"tf":2.0},"96":{"tf":1.0}}}},"m":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"5":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0},"91":{"tf":1.4142135623730951},"92":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":3.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"91":{"tf":1.0}}}}}}}}}},"r":{"df":0,"docs":{},"g":{"df":10,"docs":{"29":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"71":{"tf":2.0},"75":{"tf":1.0},"78":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"84":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"26":{"tf":1.0},"43":{"tf":2.0},"7":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":16,"docs":{"36":{"tf":1.7320508075688772},"41":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":2.0},"62":{"tf":2.23606797749979},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":2.0},"8":{"tf":2.23606797749979}}},"df":0,"docs":{}}}}},"i":{"b":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"w":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"1":{"tf":1.0},"36":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":4,"docs":{"32":{"tf":1.0},"45":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"115":{"tf":1.0},"77":{"tf":1.0}}}}},"r":{"df":1,"docs":{"30":{"tf":1.0}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"0":{"tf":1.0}}},"x":{"df":3,"docs":{"113":{"tf":1.0},"115":{"tf":1.0},"8":{"tf":1.7320508075688772}}}},"m":{"df":2,"docs":{"71":{"tf":1.0},"85":{"tf":2.0}}},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}}},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"38":{"tf":1.0}},"i":{"df":4,"docs":{"114":{"tf":1.0},"26":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":3,"docs":{"59":{"tf":1.0},"60":{"tf":1.0},"7":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"52":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":29,"docs":{"0":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.7320508075688772},"28":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"5":{"tf":1.7320508075688772},"58":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.7320508075688772},"9":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.7320508075688772},"94":{"tf":2.23606797749979},"95":{"tf":3.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"102":{"tf":2.0},"92":{"tf":1.4142135623730951}}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"23":{"tf":1.0},"78":{"tf":1.7320508075688772}}}}},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}}}}},"df":0,"docs":{}},"_":{"1":{"_":{"4":{"4":{"df":1,"docs":{"45":{"tf":1.0}}},"5":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":4,"docs":{"32":{"tf":1.0},"45":{"tf":4.47213595499958},"7":{"tf":2.449489742783178},"8":{"tf":1.4142135623730951}},"s":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"0":{"tf":1.0},"117":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"94":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":9,"docs":{"106":{"tf":1.0},"117":{"tf":1.4142135623730951},"118":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"45":{"tf":1.0}}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.7320508075688772}},"e":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"y":{"_":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"104":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"104":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"106":{"tf":1.0}}}}}}},"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}}}}}}},"df":1,"docs":{"106":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}}}}}}},"df":1,"docs":{"106":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}}}}}}},"df":1,"docs":{"106":{"tf":1.0}}}}}},"df":5,"docs":{"104":{"tf":1.7320508075688772},"105":{"tf":4.0},"106":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"104":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"56":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.0}}}}}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},">":{"(":{"<":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"105":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"74":{"tf":1.0}}}}}}},"df":0,"docs":{}},"d":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"110":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":25,"docs":{"101":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":2.6457513110645907},"106":{"tf":3.3166247903554},"111":{"tf":1.0},"115":{"tf":2.23606797749979},"117":{"tf":1.0},"19":{"tf":1.4142135623730951},"32":{"tf":1.0},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":2.449489742783178},"42":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772},"44":{"tf":2.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"7":{"tf":2.23606797749979},"70":{"tf":1.0},"74":{"tf":1.4142135623730951},"8":{"tf":3.7416573867739413}},"s":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"106":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"n":{"df":1,"docs":{"8":{"tf":2.0}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"103":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"b":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":8,"docs":{"26":{"tf":1.0},"67":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":2.0},"87":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":29,"docs":{"106":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"12":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.4142135623730951},"36":{"tf":2.0},"40":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":1.4142135623730951},"47":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"56":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"7":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.7320508075688772},"8":{"tf":1.0},"94":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"g":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"118":{"tf":1.4142135623730951},"5":{"tf":1.0},"8":{"tf":1.0}}}},"df":3,"docs":{"15":{"tf":1.0},"30":{"tf":1.0},"5":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"102":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"71":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"73":{"tf":1.0}}}}},"w":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"45":{"tf":1.0}}}}}}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"27":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"41":{"tf":1.0}}}}}}},"df":29,"docs":{"0":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0},"18":{"tf":1.0},"23":{"tf":1.4142135623730951},"27":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":2.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"52":{"tf":2.0},"54":{"tf":1.0},"67":{"tf":1.4142135623730951},"71":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.7320508075688772},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.7320508075688772},"94":{"tf":1.4142135623730951},"95":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"t":{"df":8,"docs":{"35":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":8,"docs":{"18":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"40":{"tf":1.0},"49":{"tf":1.4142135623730951},"53":{"tf":1.0},"68":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"94":{"tf":1.4142135623730951}}}}}}}},"o":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"94":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"e":{"df":9,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":3.1622776601683795},"106":{"tf":2.6457513110645907},"112":{"tf":1.7320508075688772},"115":{"tf":2.449489742783178},"117":{"tf":1.0},"118":{"tf":1.0}},"i":{"d":{"df":2,"docs":{"43":{"tf":1.4142135623730951},"44":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":4,"docs":{"102":{"tf":1.0},"117":{"tf":1.0},"20":{"tf":1.0},"32":{"tf":1.0}},"e":{"df":10,"docs":{"102":{"tf":2.0},"104":{"tf":1.0},"105":{"tf":1.0},"110":{"tf":1.4142135623730951},"113":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":2.0}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"b":{"df":0,"docs":{},"r":{"a":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":28,"docs":{"1":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"110":{"tf":1.4142135623730951},"111":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0},"31":{"tf":1.0},"36":{"tf":2.0},"4":{"tf":1.0},"5":{"tf":2.0},"55":{"tf":1.4142135623730951},"6":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":2.23606797749979},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"78":{"tf":2.0},"79":{"tf":1.4142135623730951},"84":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}},"h":{"df":3,"docs":{"21":{"tf":1.0},"41":{"tf":1.0},"94":{"tf":1.0}}},"i":{"c":{"df":2,"docs":{"35":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"a":{"d":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"94":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":15,"docs":{"104":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"31":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"67":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"94":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"105":{"tf":1.0},"106":{"tf":1.0},"114":{"tf":1.0},"8":{"tf":2.8284271247461903},"83":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}}},"o":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}},"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}},"r":{"df":1,"docs":{"118":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":4,"docs":{"112":{"tf":1.4142135623730951},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"11":{"tf":1.0},"46":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":2,"docs":{"12":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{}}}},"k":{"df":1,"docs":{"8":{"tf":1.0}}},"l":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"n":{"c":{"df":5,"docs":{"36":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"69":{"tf":1.0},"78":{"tf":1.0}}},"df":20,"docs":{"103":{"tf":1.0},"106":{"tf":1.7320508075688772},"113":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":2.0},"21":{"tf":1.0},"23":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"5":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.7320508075688772},"91":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"92":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"p":{"df":1,"docs":{"118":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"df":13,"docs":{"100":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.4142135623730951},"69":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"78":{"tf":1.0},"80":{"tf":1.0},"88":{"tf":1.0},"95":{"tf":1.7320508075688772}},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"l":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}}}},"r":{"df":6,"docs":{"115":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951},"53":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"8":{"tf":2.23606797749979}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"11":{"tf":1.0},"44":{"tf":1.4142135623730951}}}}},"t":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"110":{"tf":1.4142135623730951},"118":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"110":{"tf":1.0}}}},"df":1,"docs":{"110":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"113":{"tf":1.0},"13":{"tf":1.4142135623730951},"6":{"tf":1.0}}},"o":{"df":0,"docs":{},"n":{"<":{"&":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"106":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"45":{"tf":1.0},"8":{"tf":1.0}}}}},"u":{"3":{"2":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":1,"docs":{"110":{"tf":1.0}}}}},"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":13,"docs":{"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"106":{"tf":1.0},"110":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.0},"31":{"tf":1.0},"5":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"87":{"tf":1.4142135623730951}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"118":{"tf":1.0},"15":{"tf":1.0},"20":{"tf":1.0},"41":{"tf":1.7320508075688772},"45":{"tf":1.0},"5":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"78":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"74":{"tf":1.4142135623730951},"75":{"tf":1.0},"80":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"113":{"tf":1.0},"24":{"tf":1.0},"7":{"tf":1.0},"78":{"tf":1.4142135623730951}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":3,"docs":{"104":{"tf":1.0},"52":{"tf":1.0},"80":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":14,"docs":{"11":{"tf":1.0},"113":{"tf":1.0},"15":{"tf":1.0},"25":{"tf":1.0},"31":{"tf":1.0},"4":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"78":{"tf":2.0},"80":{"tf":1.0},"84":{"tf":1.4142135623730951},"9":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":10,"docs":{"26":{"tf":1.4142135623730951},"36":{"tf":2.0},"38":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"80":{"tf":1.0},"94":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"10":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"0":{"tf":1.0},"23":{"tf":1.0},"46":{"tf":1.0},"67":{"tf":1.0},"89":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"31":{"tf":1.7320508075688772},"45":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":4,"docs":{"109":{"tf":1.4142135623730951},"18":{"tf":1.0},"23":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}}}}}},"p":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"83":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"111":{"tf":1.4142135623730951},"65":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"s":{"df":4,"docs":{"109":{"tf":1.4142135623730951},"110":{"tf":1.0},"111":{"tf":1.7320508075688772},"115":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"115":{"tf":1.7320508075688772}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"111":{"tf":1.0}}}}}}},"t":{"df":13,"docs":{"102":{"tf":1.4142135623730951},"106":{"tf":1.7320508075688772},"109":{"tf":1.0},"117":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"16":{"tf":1.0},"40":{"tf":1.4142135623730951},"5":{"tf":1.0},"50":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"85":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"35":{"tf":1.0},"42":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":19,"docs":{"107":{"tf":1.0},"113":{"tf":1.0},"18":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.449489742783178},"42":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"7":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":2.6457513110645907}}},"t":{"df":2,"docs":{"25":{"tf":1.0},"78":{"tf":1.0}}}},"t":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":2,"docs":{"113":{"tf":1.0},"118":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"113":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"55":{"tf":1.0},"61":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"69":{"tf":1.7320508075688772},"7":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"d":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":6,"docs":{"31":{"tf":1.0},"39":{"tf":1.7320508075688772},"5":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"8":{"tf":2.6457513110645907}},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"64":{"tf":1.0}}}},":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"114":{"tf":1.0}}},"df":23,"docs":{"101":{"tf":1.7320508075688772},"102":{"tf":1.7320508075688772},"103":{"tf":2.449489742783178},"104":{"tf":3.7416573867739413},"105":{"tf":5.0},"106":{"tf":4.0},"107":{"tf":2.23606797749979},"108":{"tf":1.0},"109":{"tf":2.0},"110":{"tf":1.0},"111":{"tf":2.6457513110645907},"112":{"tf":2.0},"113":{"tf":3.4641016151377544},"114":{"tf":2.449489742783178},"115":{"tf":3.7416573867739413},"116":{"tf":1.7320508075688772},"117":{"tf":2.8284271247461903},"118":{"tf":5.5677643628300215},"46":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"8":{"tf":2.23606797749979}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":6,"docs":{"109":{"tf":2.0},"110":{"tf":2.449489742783178},"111":{"tf":1.7320508075688772},"112":{"tf":2.23606797749979},"115":{"tf":1.4142135623730951},"118":{"tf":1.7320508075688772}},"e":{"'":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"df":5,"docs":{"5":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0}},"e":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"15":{"tf":2.23606797749979},"40":{"tf":1.4142135623730951},"48":{"tf":1.0},"5":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"df":1,"docs":{"57":{"tf":1.0}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"5":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":2.449489742783178}}}}},"r":{"df":0,"docs":{},"f":{"df":2,"docs":{"0":{"tf":1.0},"13":{"tf":1.7320508075688772}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":7,"docs":{"113":{"tf":2.0},"13":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"43":{"tf":1.0},"68":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}}}},"i":{"b":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"c":{"df":0,"docs":{},"k":{"df":5,"docs":{"10":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"5":{"tf":1.4142135623730951},"74":{"tf":1.0}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"23":{"tf":1.0},"89":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"68":{"tf":1.0}},"g":{"df":1,"docs":{"71":{"tf":1.0}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":5,"docs":{"38":{"tf":1.0},"43":{"tf":1.0},"67":{"tf":1.0},"76":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}},"n":{"df":5,"docs":{"91":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.7320508075688772},"95":{"tf":1.0},"98":{"tf":1.0}},"e":{"df":1,"docs":{"95":{"tf":1.0}}}},"y":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"94":{"tf":1.0},"95":{"tf":1.0}}}}},"df":8,"docs":{"0":{"tf":1.0},"116":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.4142135623730951},"78":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"21":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"73":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.4142135623730951},"95":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"53":{"tf":1.0},"8":{"tf":1.7320508075688772}}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":2,"docs":{"92":{"tf":1.0},"94":{"tf":1.0}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":12,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"15":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"5":{"tf":1.7320508075688772},"52":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0},"78":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":12,"docs":{"106":{"tf":1.4142135623730951},"11":{"tf":1.0},"113":{"tf":1.4142135623730951},"115":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.7320508075688772},"5":{"tf":1.0},"63":{"tf":1.4142135623730951},"67":{"tf":1.0},"84":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"113":{"tf":1.0},"118":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":17,"docs":{"101":{"tf":1.0},"24":{"tf":1.0},"29":{"tf":1.7320508075688772},"32":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.7320508075688772},"68":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":2.23606797749979},"78":{"tf":3.3166247903554},"80":{"tf":1.7320508075688772},"81":{"tf":1.0},"95":{"tf":1.7320508075688772}},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"115":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":1,"docs":{"19":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"5":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"40":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"12":{"tf":1.0}}}}},"s":{"df":1,"docs":{"96":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"100":{"tf":1.0},"26":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"15":{"tf":1.0},"18":{"tf":1.0},"5":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"94":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":8,"docs":{"109":{"tf":1.0},"112":{"tf":1.0},"28":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.4142135623730951},"81":{"tf":1.0},"85":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"56":{"tf":1.0},"61":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{")":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":4,"docs":{"32":{"tf":1.0},"39":{"tf":1.4142135623730951},"47":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"56":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"38":{"tf":1.0}}},"df":1,"docs":{"8":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"116":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.4142135623730951}},"i":{"df":1,"docs":{"96":{"tf":1.7320508075688772}}}}}}}},"o":{"b":{"a":{"b":{"df":0,"docs":{},"l":{"df":7,"docs":{"115":{"tf":1.0},"21":{"tf":1.0},"32":{"tf":1.0},"53":{"tf":1.0},"79":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"94":{"tf":1.0},"95":{"tf":1.0}}}},"df":4,"docs":{"113":{"tf":1.0},"115":{"tf":2.0},"117":{"tf":1.0},"18":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":11,"docs":{"36":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"71":{"tf":1.4142135623730951},"91":{"tf":1.0},"92":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"95":{"tf":3.0},"96":{"tf":1.0},"98":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":7,"docs":{"106":{"tf":1.0},"16":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"6":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.4142135623730951}},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"115":{"tf":1.4142135623730951},"118":{"tf":1.0}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}},"df":14,"docs":{"118":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.0},"31":{"tf":2.0},"35":{"tf":1.0},"45":{"tf":1.7320508075688772},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.4142135623730951},"95":{"tf":1.7320508075688772},"96":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"115":{"tf":1.0},"69":{"tf":1.0},"96":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"102":{"tf":1.0},"113":{"tf":1.4142135623730951},"118":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"s":{"df":30,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.4142135623730951},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.4142135623730951},"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":2.0},"89":{"tf":2.449489742783178},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":8,"docs":{"118":{"tf":1.0},"18":{"tf":1.0},"35":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"56":{"tf":1.0},"7":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}}},"x":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"b":{"(":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":9,"docs":{"110":{"tf":3.1622776601683795},"112":{"tf":1.0},"36":{"tf":1.7320508075688772},"40":{"tf":1.0},"45":{"tf":1.4142135623730951},"48":{"tf":1.0},"52":{"tf":1.7320508075688772},"55":{"tf":1.0},"56":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":3,"docs":{"17":{"tf":1.0},"8":{"tf":1.7320508075688772},"98":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"70":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":12,"docs":{"19":{"tf":1.0},"25":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.4142135623730951},"94":{"tf":1.0}}}},"t":{"df":4,"docs":{"115":{"tf":1.0},"46":{"tf":1.0},"69":{"tf":1.0},"95":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":2.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"117":{"tf":1.4142135623730951},"41":{"tf":1.0},"61":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"68":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"23":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"102":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":4,"docs":{"102":{"tf":1.0},"115":{"tf":1.0},"56":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}},"u":{"df":0,"docs":{},"x":{"df":2,"docs":{"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}},"n":{"df":1,"docs":{"39":{"tf":1.0}},"g":{"df":2,"docs":{"63":{"tf":1.0},"78":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"e":{"df":4,"docs":{"7":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.0},"94":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"94":{"tf":1.0},"96":{"tf":1.0}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"114":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"w":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}}},"c":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"d":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"102":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.0}}}},"df":0,"docs":{}},"df":9,"docs":{"102":{"tf":1.4142135623730951},"106":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"86":{"tf":1.0}},"i":{"df":1,"docs":{"5":{"tf":1.0}}},"m":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":4,"docs":{"107":{"tf":1.0},"40":{"tf":1.0},"88":{"tf":1.0},"95":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":6,"docs":{"11":{"tf":1.0},"115":{"tf":1.4142135623730951},"16":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"10":{"tf":1.0},"105":{"tf":1.0},"11":{"tf":1.0},"115":{"tf":1.0},"12":{"tf":1.0},"27":{"tf":1.0},"41":{"tf":1.4142135623730951},"48":{"tf":1.0},"54":{"tf":1.0}}}}}},"b":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"25":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":8,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"118":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"16":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":2,"docs":{"107":{"tf":1.0},"84":{"tf":1.0}},"f":{"df":2,"docs":{"113":{"tf":1.4142135623730951},"57":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":10,"docs":{"106":{"tf":1.7320508075688772},"108":{"tf":1.4142135623730951},"111":{"tf":1.0},"115":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"5":{"tf":1.0},"68":{"tf":1.0},"8":{"tf":1.4142135623730951},"89":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"=":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":4,"docs":{"113":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"'":{"df":1,"docs":{"105":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"27":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"41":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"41":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"41":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"r":{"df":3,"docs":{"32":{"tf":1.0},"41":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"113":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":6,"docs":{"101":{"tf":1.0},"103":{"tf":2.0},"106":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"95":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"95":{"tf":1.0}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"/":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"74":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"115":{"tf":1.0},"118":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":14,"docs":{"31":{"tf":1.0},"40":{"tf":1.0},"67":{"tf":2.449489742783178},"68":{"tf":1.0},"73":{"tf":1.7320508075688772},"77":{"tf":2.23606797749979},"78":{"tf":3.3166247903554},"79":{"tf":3.1622776601683795},"80":{"tf":2.0},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":2.0},"84":{"tf":1.0},"85":{"tf":2.6457513110645907}}}},"df":0,"docs":{},"v":{"df":4,"docs":{"117":{"tf":1.0},"45":{"tf":1.0},"78":{"tf":1.7320508075688772},"79":{"tf":1.0}}}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"91":{"tf":1.0},"92":{"tf":1.0},"94":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"114":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"79":{"tf":1.0},"80":{"tf":2.0}}}}},"o":{"df":0,"docs":{},"t":{"df":6,"docs":{"25":{"tf":1.7320508075688772},"70":{"tf":3.3166247903554},"71":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}},"v":{"df":6,"docs":{"12":{"tf":1.0},"27":{"tf":1.0},"31":{"tf":1.0},"36":{"tf":1.0},"78":{"tf":1.0},"85":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"36":{"tf":1.0},"8":{"tf":2.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"110":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"105":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"110":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"105":{"tf":2.0},"111":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"116":{"tf":1.0},"118":{"tf":1.0}}}}}},"l":{"a":{"c":{"df":4,"docs":{"12":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":6,"docs":{"25":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"95":{"tf":2.0}},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.0},"5":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":14,"docs":{"25":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":2.23606797749979},"71":{"tf":1.4142135623730951},"74":{"tf":3.0},"75":{"tf":2.6457513110645907},"78":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":2.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":5,"docs":{"105":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"58":{"tf":1.0},"66":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"30":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"66":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":9,"docs":{"102":{"tf":1.7320508075688772},"106":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.7320508075688772},"118":{"tf":1.7320508075688772},"45":{"tf":2.0},"51":{"tf":1.0},"52":{"tf":1.0},"73":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}}},"i":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"55":{"tf":1.0},"61":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"18":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"91":{"tf":1.0}}}}}},"t":{"df":2,"docs":{"118":{"tf":1.0},"40":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"0":{"tf":1.0},"16":{"tf":2.23606797749979},"5":{"tf":1.4142135623730951},"8":{"tf":2.0}}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{".":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}}},"z":{"df":1,"docs":{"106":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"106":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"113":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"106":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"106":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"106":{"tf":1.0}}}},"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":7,"docs":{"102":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"106":{"tf":2.449489742783178},"115":{"tf":1.0},"28":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":6,"docs":{"115":{"tf":1.0},"40":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":2.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"(":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":13,"docs":{"104":{"tf":1.0},"106":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"21":{"tf":1.0},"45":{"tf":1.0},"55":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.7320508075688772},"8":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"94":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"78":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"100":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"114":{"tf":1.0}}}}}}},"f":{"c":{"df":8,"docs":{"101":{"tf":1.0},"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"110":{"tf":1.0},"23":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.4142135623730951},"98":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{".":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":5,"docs":{"115":{"tf":1.0},"31":{"tf":1.0},"76":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"94":{"tf":1.0}}}}},"o":{"a":{"d":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":11,"docs":{"100":{"tf":2.449489742783178},"90":{"tf":1.7320508075688772},"91":{"tf":1.4142135623730951},"92":{"tf":1.7320508075688772},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.7320508075688772},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":2.449489742783178},"99":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"95":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":3,"docs":{"31":{"tf":1.4142135623730951},"38":{"tf":1.0},"66":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"78":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":35,"docs":{"0":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":2.23606797749979},"26":{"tf":2.0},"27":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":2.0},"32":{"tf":1.4142135623730951},"36":{"tf":2.8284271247461903},"37":{"tf":1.7320508075688772},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":2.0},"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.4142135623730951},"5":{"tf":2.23606797749979},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772},"7":{"tf":2.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.0},"94":{"tf":1.0}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"'":{"df":3,"docs":{"110":{"tf":1.0},"57":{"tf":1.0},"98":{"tf":1.0}}},",":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}}}}}},"a":{"c":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"'":{"df":1,"docs":{"53":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"109":{"tf":1.0}}}}}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{":":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"40":{"tf":1.0},"53":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"x":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"x":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"63":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"64":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"56":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"66":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"{":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"p":{"a":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":2,"docs":{"63":{"tf":1.0},"64":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":15,"docs":{"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":1.7320508075688772},"4":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.7320508075688772},"53":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"60":{"tf":1.0},"68":{"tf":1.4142135623730951},"94":{"tf":1.0},"95":{"tf":1.4142135623730951}}},"df":47,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"105":{"tf":1.0},"109":{"tf":1.0},"112":{"tf":1.0},"115":{"tf":3.0},"118":{"tf":2.23606797749979},"16":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.7320508075688772},"45":{"tf":2.449489742783178},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"52":{"tf":1.0},"67":{"tf":1.7320508075688772},"68":{"tf":2.8284271247461903},"69":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"70":{"tf":1.4142135623730951},"71":{"tf":3.872983346207417},"72":{"tf":2.8284271247461903},"73":{"tf":1.0},"74":{"tf":2.23606797749979},"75":{"tf":2.6457513110645907},"77":{"tf":1.7320508075688772},"78":{"tf":2.6457513110645907},"79":{"tf":1.7320508075688772},"8":{"tf":1.0},"80":{"tf":2.0},"81":{"tf":1.4142135623730951},"82":{"tf":2.0},"83":{"tf":1.7320508075688772},"84":{"tf":2.0},"85":{"tf":1.4142135623730951},"88":{"tf":1.0},"9":{"tf":1.0},"92":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"95":{"tf":2.449489742783178},"98":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":3,"docs":{"32":{"tf":1.0},"37":{"tf":2.23606797749979},"94":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"18":{"tf":1.0},"19":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"t":{"df":3,"docs":{"32":{"tf":1.0},"49":{"tf":2.6457513110645907},"95":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"p":{"df":8,"docs":{"1":{"tf":1.0},"2":{"tf":1.7320508075688772},"20":{"tf":1.0},"31":{"tf":2.23606797749979},"49":{"tf":1.4142135623730951},"67":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0}}}}}}}},"s":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":3,"docs":{"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}}}}},"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":14,"docs":{"106":{"tf":1.0},"118":{"tf":1.4142135623730951},"18":{"tf":1.0},"20":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":1.4142135623730951},"58":{"tf":1.0},"6":{"tf":1.0},"66":{"tf":2.0},"69":{"tf":1.0},"8":{"tf":1.7320508075688772},"95":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"102":{"tf":1.0},"103":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"95":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"r":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"20":{"tf":1.0},"69":{"tf":1.7320508075688772},"7":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.7320508075688772}}}}}}},"df":1,"docs":{"69":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"103":{"tf":1.7320508075688772},"104":{"tf":1.0},"118":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"102":{"tf":1.4142135623730951},"105":{"tf":1.0},"106":{"tf":1.0},"5":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":18,"docs":{"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"109":{"tf":1.4142135623730951},"112":{"tf":1.0},"113":{"tf":1.0},"118":{"tf":1.0},"23":{"tf":1.0},"40":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"67":{"tf":1.7320508075688772},"68":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.4142135623730951},"93":{"tf":2.0},"94":{"tf":1.0},"95":{"tf":1.0}}}}}}},"d":{"df":3,"docs":{"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":23,"docs":{"10":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"113":{"tf":1.4142135623730951},"12":{"tf":1.0},"14":{"tf":1.0},"21":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"78":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951}},"k":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"m":{"df":3,"docs":{"103":{"tf":1.0},"115":{"tf":1.0},"43":{"tf":1.0}}},"n":{"df":3,"docs":{"112":{"tf":1.0},"116":{"tf":1.0},"52":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"106":{"tf":1.0},"47":{"tf":1.0}}}},"df":0,"docs":{}},"f":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":14,"docs":{"104":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.7320508075688772},"52":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.4142135623730951}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"(":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"(":{"_":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"_":{"df":1,"docs":{"105":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"110":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"118":{"tf":1.0}}}}}}},"df":2,"docs":{"113":{"tf":1.0},"118":{"tf":1.0}}}},"n":{"d":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}},"df":0,"docs":{},"s":{"df":3,"docs":{"35":{"tf":1.0},"66":{"tf":1.0},"95":{"tf":1.0}},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":6,"docs":{"36":{"tf":1.0},"44":{"tf":1.7320508075688772},"52":{"tf":1.0},"63":{"tf":1.0},"8":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"110":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"110":{"tf":1.0}}}},"df":1,"docs":{"110":{"tf":1.0}},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":6,"docs":{"103":{"tf":1.7320508075688772},"105":{"tf":1.7320508075688772},"110":{"tf":1.0},"111":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"v":{"df":3,"docs":{"40":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"t":{"df":11,"docs":{"106":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.4142135623730951},"34":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"5":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":2.0},"8":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":4,"docs":{"23":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"32":{"tf":1.0},"33":{"tf":1.4142135623730951}}}}}},"h":{"a":{"=":{"$":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"74":{"tf":1.4142135623730951},"83":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"118":{"tf":1.0},"95":{"tf":1.0}}}}},"df":1,"docs":{"69":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.0},"53":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"78":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"40":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"5":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"w":{"df":6,"docs":{"102":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"118":{"tf":1.0},"31":{"tf":1.0},"48":{"tf":1.0}},"n":{"df":3,"docs":{"104":{"tf":1.0},"112":{"tf":1.0},"95":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":3,"docs":{"115":{"tf":1.0},"55":{"tf":1.0},"8":{"tf":3.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.0}},"e":{".":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":9,"docs":{"101":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"11":{"tf":1.0},"110":{"tf":1.0},"115":{"tf":1.7320508075688772},"118":{"tf":1.0},"53":{"tf":1.0},"95":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":6,"docs":{"0":{"tf":1.0},"104":{"tf":1.4142135623730951},"114":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.0},"19":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"114":{"tf":1.0},"115":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"105":{"tf":1.0}}}}},"i":{"df":3,"docs":{"117":{"tf":1.0},"52":{"tf":1.0},"87":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":6,"docs":{"102":{"tf":2.0},"110":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"12":{"tf":1.0},"95":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":4,"docs":{"105":{"tf":1.0},"43":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}}}},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"115":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"x":{"df":1,"docs":{"67":{"tf":1.0}}},"z":{"df":0,"docs":{},"e":{"df":2,"docs":{"61":{"tf":1.0},"8":{"tf":4.898979485566356}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"1":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":2.23606797749979}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"115":{"tf":1.0},"13":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"113":{"tf":1.4142135623730951}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"102":{"tf":1.0},"118":{"tf":1.0},"28":{"tf":1.0},"77":{"tf":1.0},"92":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"106":{"tf":1.0},"109":{"tf":1.0},"7":{"tf":1.0}}}},"v":{"df":2,"docs":{"115":{"tf":1.4142135623730951},"117":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"(":{"4":{"2":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"113":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"106":{"tf":2.0},"113":{"tf":1.0}}}}}}}}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"62":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"94":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":8,"docs":{"0":{"tf":1.0},"23":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.4142135623730951},"56":{"tf":1.0},"80":{"tf":1.4142135623730951},"94":{"tf":1.0},"95":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":5,"docs":{"15":{"tf":1.0},"45":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"73":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":3.0}}}}},"w":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"94":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"118":{"tf":1.0},"96":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":7,"docs":{"22":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.7320508075688772},"31":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"56":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}},".":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":2,"docs":{"43":{"tf":1.4142135623730951},"44":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}}}}},"df":6,"docs":{"110":{"tf":1.0},"43":{"tf":2.23606797749979},"44":{"tf":1.7320508075688772},"53":{"tf":1.0},"66":{"tf":2.6457513110645907},"94":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"66":{"tf":1.0}}}},"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"16":{"tf":1.0},"77":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":18,"docs":{"0":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.4142135623730951},"105":{"tf":1.0},"11":{"tf":1.0},"112":{"tf":2.0},"114":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":2.0},"62":{"tf":2.0},"63":{"tf":1.7320508075688772},"64":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"8":{"tf":1.0},"94":{"tf":1.0}},"i":{"df":13,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0},"45":{"tf":1.7320508075688772},"7":{"tf":2.23606797749979},"78":{"tf":1.0},"8":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":2,"docs":{"14":{"tf":1.0},"5":{"tf":1.4142135623730951}}}}}}}},"r":{"c":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"/":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":7,"docs":{"71":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"23":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}},"l":{"df":15,"docs":{"18":{"tf":1.7320508075688772},"19":{"tf":1.0},"20":{"tf":1.0},"68":{"tf":1.0},"73":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":2.0},"79":{"tf":1.7320508075688772},"80":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":2.23606797749979},"85":{"tf":2.23606797749979},"94":{"tf":1.4142135623730951},"95":{"tf":1.0}}}},"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"69":{"tf":1.0},"8":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":7,"docs":{"106":{"tf":1.7320508075688772},"113":{"tf":1.0},"118":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"69":{"tf":1.0}}}},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"32":{"tf":1.0},"35":{"tf":1.4142135623730951}}}}},"r":{"d":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":18,"docs":{"101":{"tf":1.0},"110":{"tf":1.0},"113":{"tf":1.0},"118":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"26":{"tf":1.0},"32":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"78":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"102":{"tf":1.0},"118":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":3,"docs":{"36":{"tf":2.23606797749979},"44":{"tf":1.0},"51":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":17,"docs":{"19":{"tf":1.0},"3":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"45":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"80":{"tf":1.7320508075688772},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"84":{"tf":1.0},"92":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":10,"docs":{"0":{"tf":1.0},"102":{"tf":1.0},"11":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"23":{"tf":1.0},"5":{"tf":1.0},"70":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}},"m":{"df":0,"docs":{},"t":{"df":2,"docs":{"110":{"tf":1.0},"118":{"tf":1.0}}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"94":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"*":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"df":1,"docs":{"52":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"41":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"r":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}}}}},"df":1,"docs":{"7":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"16":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"87":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"65":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"106":{"tf":1.0}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":9,"docs":{"106":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"36":{"tf":1.0},"45":{"tf":1.4142135623730951},"52":{"tf":3.3166247903554},"56":{"tf":2.6457513110645907},"57":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"52":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":11,"docs":{"102":{"tf":1.7320508075688772},"103":{"tf":1.0},"106":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.4142135623730951},"113":{"tf":1.0},"115":{"tf":2.6457513110645907},"116":{"tf":1.0},"37":{"tf":1.0},"55":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"u":{"b":{"df":1,"docs":{"7":{"tf":1.0}}},"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":5,"docs":{"0":{"tf":1.0},"103":{"tf":1.0},"14":{"tf":2.6457513110645907},"40":{"tf":1.0},"49":{"tf":1.0}}}}}},"u":{"b":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"4":{"tf":1.0},"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"106":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"105":{"tf":1.7320508075688772},"106":{"tf":1.0},"115":{"tf":1.4142135623730951},"117":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"51":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"106":{"tf":2.0},"115":{"tf":1.0},"118":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":9,"docs":{"118":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":3.605551275463989},"71":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"95":{"tf":1.4142135623730951}},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"46":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"h":{"df":9,"docs":{"115":{"tf":1.7320508075688772},"45":{"tf":1.0},"55":{"tf":1.7320508075688772},"56":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.4142135623730951},"7":{"tf":1.0},"89":{"tf":1.0},"94":{"tf":1.0}}}},"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"69":{"tf":1.7320508075688772}}}},"df":1,"docs":{"11":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":3,"docs":{"106":{"tf":1.0},"118":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{},"x":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":14,"docs":{"118":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"17":{"tf":1.0},"28":{"tf":1.0},"37":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"8":{"tf":3.0},"94":{"tf":1.0},"95":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"26":{"tf":1.0},"38":{"tf":1.0},"44":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"101":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"115":{"tf":1.0},"91":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"48":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":8,"docs":{"111":{"tf":1.0},"118":{"tf":1.7320508075688772},"32":{"tf":1.0},"45":{"tf":1.7320508075688772},"52":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951},"94":{"tf":1.0}}}},"s":{"df":1,"docs":{"0":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":2.8284271247461903}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":17,"docs":{"17":{"tf":1.0},"19":{"tf":1.0},"25":{"tf":1.4142135623730951},"28":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"78":{"tf":2.449489742783178},"80":{"tf":1.0},"84":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"113":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"11":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"y":{"df":0,"docs":{},"m":{"!":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"62":{"tf":1.0},"65":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"c":{"df":9,"docs":{"67":{"tf":1.4142135623730951},"68":{"tf":2.6457513110645907},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":2.8284271247461903},"72":{"tf":2.23606797749979},"74":{"tf":1.0},"75":{"tf":1.0},"95":{"tf":2.0}},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.0}}}}}}},"df":2,"docs":{"109":{"tf":1.4142135623730951},"112":{"tf":1.0}},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{},"x":{"'":{"df":1,"docs":{"118":{"tf":1.0}}},":":{":":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"104":{"tf":1.0},"106":{"tf":1.4142135623730951}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"106":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":2,"docs":{"109":{"tf":1.0},"112":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":20,"docs":{"101":{"tf":1.7320508075688772},"102":{"tf":1.4142135623730951},"103":{"tf":2.0},"104":{"tf":2.23606797749979},"105":{"tf":3.0},"106":{"tf":2.0},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":2.23606797749979},"110":{"tf":1.0},"111":{"tf":1.4142135623730951},"112":{"tf":2.8284271247461903},"113":{"tf":1.4142135623730951},"114":{"tf":2.23606797749979},"115":{"tf":4.123105625617661},"116":{"tf":2.0},"117":{"tf":1.4142135623730951},"118":{"tf":4.0},"30":{"tf":1.0},"46":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":5,"docs":{"103":{"tf":1.0},"118":{"tf":1.4142135623730951},"42":{"tf":1.0},"57":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"105":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":7,"docs":{"115":{"tf":1.4142135623730951},"75":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":2.0},"84":{"tf":1.4142135623730951}}},"k":{"df":0,"docs":{},"e":{"df":12,"docs":{"115":{"tf":1.0},"118":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":1.0},"78":{"tf":1.0},"89":{"tf":1.0}},"n":{"df":1,"docs":{"77":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"58":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":5,"docs":{"118":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"39":{"tf":1.0},"64":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"k":{"df":4,"docs":{"100":{"tf":1.0},"102":{"tf":1.4142135623730951},"115":{"tf":1.0},"91":{"tf":1.4142135623730951}}}},"t":{"a":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"x":{"df":6,"docs":{"30":{"tf":1.0},"45":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":9,"docs":{"71":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.4142135623730951},"79":{"tf":1.0},"91":{"tf":1.4142135623730951},"92":{"tf":2.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":4.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"95":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}}}}},"s":{"df":0,"docs":{},"t":{"_":{"df":1,"docs":{"26":{"tf":1.0}}},"df":29,"docs":{"0":{"tf":1.0},"102":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"115":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"26":{"tf":3.605551275463989},"27":{"tf":1.4142135623730951},"32":{"tf":2.0},"35":{"tf":1.0},"36":{"tf":3.605551275463989},"37":{"tf":2.449489742783178},"38":{"tf":2.23606797749979},"43":{"tf":1.4142135623730951},"44":{"tf":2.6457513110645907},"45":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":2.0},"66":{"tf":1.0},"7":{"tf":1.0},"74":{"tf":2.0},"75":{"tf":1.7320508075688772},"8":{"tf":3.7416573867739413},"87":{"tf":1.0},"95":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"36":{"tf":1.0}},"e":{"=":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{",":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"2":{",":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"3":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"35":{"tf":1.0},"36":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":3,"docs":{"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"x":{"df":1,"docs":{"8":{"tf":1.4142135623730951}},"t":{"df":3,"docs":{"40":{"tf":1.0},"43":{"tf":1.0},"87":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"32":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"a":{"d":{"d":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"105":{"tf":1.0}}}}}}},"n":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"102":{"tf":1.4142135623730951}}}}}},"[":{"0":{"]":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"102":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"'":{"df":5,"docs":{"106":{"tf":1.0},"21":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"103":{"tf":1.0},"105":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0}}}}}}},"y":{"'":{"df":0,"docs":{},"r":{"df":2,"docs":{"58":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":9,"docs":{"0":{"tf":1.0},"23":{"tf":1.0},"40":{"tf":1.4142135623730951},"48":{"tf":1.0},"53":{"tf":1.4142135623730951},"66":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":2.0}}},"k":{"df":3,"docs":{"115":{"tf":1.0},"58":{"tf":1.0},"95":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":13,"docs":{"10":{"tf":1.0},"106":{"tf":1.0},"118":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0},"36":{"tf":1.0},"5":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.7320508075688772},"84":{"tf":1.0},"89":{"tf":1.0},"96":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":6,"docs":{"113":{"tf":1.0},"36":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"95":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":4,"docs":{"105":{"tf":1.0},"118":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"52":{"tf":1.0},"8":{"tf":5.0990195135927845}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":7,"docs":{"115":{"tf":1.0},"23":{"tf":1.0},"27":{"tf":1.0},"32":{"tf":1.0},"5":{"tf":1.7320508075688772},"64":{"tf":1.0},"69":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"15":{"tf":1.0},"53":{"tf":1.0}}}}}}}}}}},"i":{"b":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":17,"docs":{"114":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"25":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0},"58":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"71":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"92":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"p":{"df":1,"docs":{"31":{"tf":1.0}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}},"l":{"df":1,"docs":{"75":{"tf":1.0}}}}},"l":{";":{"d":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"o":{"df":2,"docs":{"43":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"67":{"tf":1.0},"79":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"52":{"tf":1.0},"7":{"tf":1.0}}}},"o":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"=":{"<":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"49":{"tf":1.0}}}}}}}}}},"df":6,"docs":{"1":{"tf":1.4142135623730951},"18":{"tf":1.7320508075688772},"2":{"tf":1.0},"31":{"tf":2.6457513110645907},"49":{"tf":1.0},"71":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":20,"docs":{"115":{"tf":1.0},"118":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.7320508075688772},"28":{"tf":1.0},"34":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"53":{"tf":1.0},"60":{"tf":2.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0},"78":{"tf":1.0},"95":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"p":{"df":3,"docs":{"37":{"tf":1.0},"78":{"tf":1.0},"88":{"tf":1.0}},"i":{"c":{"df":2,"docs":{"91":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"7":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"92":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"93":{"tf":1.0},"96":{"tf":1.4142135623730951}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"92":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"t":{"df":9,"docs":{"109":{"tf":1.7320508075688772},"112":{"tf":2.449489742783178},"114":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"43":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":2.6457513110645907},"8":{"tf":1.7320508075688772}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"v":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":2.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":20,"docs":{"101":{"tf":1.7320508075688772},"102":{"tf":1.4142135623730951},"103":{"tf":2.0},"104":{"tf":2.23606797749979},"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.7320508075688772},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":2.6457513110645907},"113":{"tf":1.0},"114":{"tf":2.23606797749979},"115":{"tf":1.4142135623730951},"116":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951},"118":{"tf":1.0},"30":{"tf":1.0},"80":{"tf":1.0}}}},"i":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"23":{"tf":1.0},"95":{"tf":2.449489742783178}}}},"df":4,"docs":{"10":{"tf":1.0},"38":{"tf":1.0},"5":{"tf":1.0},"78":{"tf":1.0}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"16":{"tf":1.0},"36":{"tf":1.0},"45":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":2.23606797749979}}}}}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"102":{"tf":1.0},"13":{"tf":1.0},"8":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"y":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"e":{"df":3,"docs":{"105":{"tf":1.0},"66":{"tf":1.4142135623730951},"8":{"tf":2.8284271247461903}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"105":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":5,"docs":{"0":{"tf":1.0},"113":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.0},"95":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":14,"docs":{"106":{"tf":2.0},"113":{"tf":1.0},"118":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.0},"8":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.0}}}},"y":{"'":{"df":1,"docs":{"56":{"tf":1.0}}},".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"57":{"tf":1.7320508075688772},"61":{"tf":1.0}}},"df":0,"docs":{}}}}},":":{":":{"a":{"d":{"df":0,"docs":{},"t":{"(":{"a":{"d":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":2,"docs":{"57":{"tf":1.0},"61":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"58":{"tf":2.449489742783178}}},"y":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"<":{"'":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"x":{">":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"d":{"<":{"'":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":9,"docs":{"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":3.0},"57":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.7320508075688772},"63":{"tf":1.7320508075688772},"64":{"tf":1.7320508075688772}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"56":{"tf":1.0},"57":{"tf":2.23606797749979},"61":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"=":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}}}},"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"55":{"tf":2.449489742783178},"61":{"tf":2.0}}}}}}}}}},"df":27,"docs":{"104":{"tf":1.0},"105":{"tf":1.7320508075688772},"106":{"tf":3.4641016151377544},"111":{"tf":1.4142135623730951},"112":{"tf":1.0},"118":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":2.0},"42":{"tf":2.0},"52":{"tf":2.0},"54":{"tf":2.0},"55":{"tf":2.23606797749979},"56":{"tf":2.8284271247461903},"57":{"tf":2.449489742783178},"58":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"60":{"tf":2.23606797749979},"61":{"tf":3.4641016151377544},"62":{"tf":1.4142135623730951},"63":{"tf":3.1622776601683795},"64":{"tf":2.449489742783178},"65":{"tf":2.0},"7":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":4.47213595499958}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"o":{"df":2,"docs":{"26":{"tf":1.0},"77":{"tf":1.0}}}}}},"u":{"3":{"2":{"df":1,"docs":{"58":{"tf":2.0}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"8":{"tf":4.47213595499958}}},"df":0,"docs":{}},"b":{"df":1,"docs":{"30":{"tf":1.0}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"df":1,"docs":{"74":{"tf":1.0}},"i":{"df":5,"docs":{"26":{"tf":1.7320508075688772},"36":{"tf":1.7320508075688772},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"51":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"26":{"tf":1.4142135623730951},"36":{"tf":2.0},"44":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"94":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":2.0}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"114":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"_":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}},"r":{"df":6,"docs":{"0":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"69":{"tf":1.0},"96":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"55":{"tf":1.0},"61":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"47":{"tf":1.0},"58":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"53":{"tf":1.0},"66":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"92":{"tf":1.0}}}},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.7320508075688772}},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"7":{"tf":1.0}}}},"t":{"df":1,"docs":{"44":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"43":{"tf":1.0},"66":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":2,"docs":{"113":{"tf":1.0},"35":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"z":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"38":{"tf":1.0},"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"117":{"tf":1.4142135623730951}}}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"102":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"116":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":2,"docs":{"5":{"tf":1.0},"8":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"p":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"77":{"tf":1.0},"78":{"tf":1.7320508075688772},"96":{"tf":1.0}}}}},"d":{"a":{"df":0,"docs":{},"t":{"df":20,"docs":{"114":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.7320508075688772},"27":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"36":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"44":{"tf":1.0},"52":{"tf":1.0},"67":{"tf":1.0},"75":{"tf":1.4142135623730951},"76":{"tf":2.0},"77":{"tf":2.449489742783178},"78":{"tf":2.6457513110645907},"79":{"tf":1.4142135623730951},"81":{"tf":1.7320508075688772},"84":{"tf":2.0},"85":{"tf":2.6457513110645907},"88":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"27":{"tf":1.0},"41":{"tf":1.4142135623730951},"51":{"tf":1.0},"95":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":12,"docs":{"30":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"80":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"/":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"80":{"tf":1.4142135623730951},"81":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"25":{"tf":1.0},"71":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":9,"docs":{"25":{"tf":2.23606797749979},"70":{"tf":2.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"l":{"df":1,"docs":{"70":{"tf":1.0}}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"91":{"tf":1.0},"92":{"tf":1.0},"94":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":7,"docs":{"1":{"tf":1.0},"27":{"tf":1.0},"4":{"tf":1.7320508075688772},"5":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.0}}}},"df":63,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.4142135623730951},"101":{"tf":1.0},"103":{"tf":2.23606797749979},"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"106":{"tf":1.7320508075688772},"107":{"tf":1.7320508075688772},"109":{"tf":1.0},"113":{"tf":2.0},"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"118":{"tf":2.6457513110645907},"15":{"tf":1.0},"16":{"tf":1.7320508075688772},"17":{"tf":1.0},"18":{"tf":2.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"20":{"tf":1.7320508075688772},"21":{"tf":1.0},"31":{"tf":1.7320508075688772},"34":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.4142135623730951},"40":{"tf":2.449489742783178},"41":{"tf":1.7320508075688772},"42":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"45":{"tf":2.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"5":{"tf":2.449489742783178},"50":{"tf":1.0},"52":{"tf":1.7320508075688772},"55":{"tf":2.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.7320508075688772},"6":{"tf":2.449489742783178},"60":{"tf":1.0},"61":{"tf":2.23606797749979},"63":{"tf":2.8284271247461903},"64":{"tf":2.8284271247461903},"65":{"tf":1.4142135623730951},"66":{"tf":2.6457513110645907},"69":{"tf":1.0},"7":{"tf":2.449489742783178},"71":{"tf":1.4142135623730951},"78":{"tf":1.0},"8":{"tf":3.0},"80":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.0},"94":{"tf":2.0},"95":{"tf":1.7320508075688772}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}},"df":2,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0}}}}}},"r":{"df":14,"docs":{"106":{"tf":1.7320508075688772},"114":{"tf":1.0},"115":{"tf":1.7320508075688772},"118":{"tf":1.0},"15":{"tf":1.0},"52":{"tf":1.0},"58":{"tf":1.0},"69":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":2.23606797749979},"96":{"tf":2.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{">":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"110":{"tf":1.0}}}},"r":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":2.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"u":{"a":{"df":0,"docs":{},"l":{"df":10,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.4142135623730951},"78":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":3,"docs":{"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"64":{"tf":1.4142135623730951}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":5,"docs":{"109":{"tf":1.0},"111":{"tf":1.7320508075688772},"118":{"tf":1.0},"28":{"tf":1.0},"8":{"tf":2.0}}},"df":0,"docs":{}},"u":{"df":11,"docs":{"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"118":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.4142135623730951},"52":{"tf":3.3166247903554},"55":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":2.449489742783178},"8":{"tf":7.745966692414834}}}},"r":{"df":1,"docs":{"18":{"tf":1.0}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"36":{"tf":1.0},"39":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"105":{"tf":1.4142135623730951},"111":{"tf":1.7320508075688772},"44":{"tf":1.0},"57":{"tf":1.0},"8":{"tf":2.8284271247461903}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"43":{"tf":1.0},"54":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":2,"docs":{"43":{"tf":1.0},"53":{"tf":1.0}}}}}}},"df":1,"docs":{"109":{"tf":2.23606797749979}},"e":{"c":{"<":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{":":{":":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"[":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"b":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{":":{":":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":2.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":2.0}}}}}},"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":1,"docs":{"8":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.7320508075688772}},"e":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":6,"docs":{"0":{"tf":1.0},"103":{"tf":1.4142135623730951},"115":{"tf":1.0},"56":{"tf":1.0},"7":{"tf":1.4142135623730951},"77":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":25,"docs":{"102":{"tf":1.7320508075688772},"107":{"tf":1.0},"110":{"tf":1.0},"19":{"tf":1.0},"25":{"tf":1.4142135623730951},"28":{"tf":1.0},"32":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.7320508075688772},"45":{"tf":2.449489742783178},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":2.0},"71":{"tf":1.7320508075688772},"78":{"tf":1.4142135623730951},"79":{"tf":1.7320508075688772},"8":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":2.0},"95":{"tf":1.0}}}}}}}},"i":{"a":{"df":5,"docs":{"44":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"31":{"tf":1.0},"87":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"118":{"tf":1.0}}}}}}}},"s":{"df":1,"docs":{"95":{"tf":1.0}}},"v":{"df":1,"docs":{"40":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"71":{"tf":1.0},"95":{"tf":1.0}}}},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"23":{"tf":1.0}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}}}}}}}},"n":{"df":0,"docs":{},"t":{"df":25,"docs":{"106":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.4142135623730951},"26":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.7320508075688772},"43":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.7320508075688772},"50":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.4142135623730951},"7":{"tf":1.0},"70":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.4142135623730951},"88":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{":":{":":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"96":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":10,"docs":{"0":{"tf":2.0},"14":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.7320508075688772},"28":{"tf":1.0},"5":{"tf":2.6457513110645907},"7":{"tf":2.449489742783178},"8":{"tf":1.4142135623730951}}}},"y":{"df":22,"docs":{"0":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.0},"106":{"tf":1.0},"114":{"tf":1.0},"117":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":1.0},"35":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":2.0},"55":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.4142135623730951},"74":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{":":{":":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"7":{"tf":2.0}},"e":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"35":{"tf":1.0},"36":{"tf":1.0}}}},"v":{"df":1,"docs":{"58":{"tf":1.0}}}},"b":{"df":1,"docs":{"88":{"tf":1.0}},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"df":4,"docs":{"67":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"77":{"tf":1.0},"94":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"68":{"tf":1.0},"95":{"tf":1.0}}}}}},"l":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"21":{"tf":1.0},"5":{"tf":1.0},"77":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":7,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"95":{"tf":1.0}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}}}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"8":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"104":{"tf":1.0},"106":{"tf":1.4142135623730951},"113":{"tf":1.0},"118":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.4142135623730951},"8":{"tf":3.3166247903554}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":10,"docs":{"114":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"27":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.7320508075688772},"58":{"tf":1.0},"7":{"tf":1.0},"92":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"l":{"d":{"c":{"a":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}},"df":1,"docs":{"8":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":1,"docs":{"95":{"tf":1.0}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"7":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"113":{"tf":1.0},"118":{"tf":1.0},"35":{"tf":1.0},"8":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":8,"docs":{"105":{"tf":1.0},"114":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"58":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"84":{"tf":1.0},"96":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"<":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"<":{"'":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":4,"docs":{"35":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":2,"docs":{"78":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":21,"docs":{"106":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.4142135623730951},"23":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"43":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"66":{"tf":1.4142135623730951},"69":{"tf":2.0},"7":{"tf":1.0},"89":{"tf":1.4142135623730951},"95":{"tf":2.6457513110645907}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":3,"docs":{"39":{"tf":1.0},"5":{"tf":2.0},"52":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"d":{"df":2,"docs":{"107":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"43":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"94":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"95":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"114":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":18,"docs":{"102":{"tf":1.7320508075688772},"103":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"118":{"tf":2.23606797749979},"14":{"tf":1.0},"23":{"tf":1.4142135623730951},"36":{"tf":1.0},"42":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"53":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.7320508075688772},"78":{"tf":2.0},"9":{"tf":1.0},"94":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":12,"docs":{"0":{"tf":1.4142135623730951},"102":{"tf":1.0},"107":{"tf":1.0},"11":{"tf":1.7320508075688772},"113":{"tf":1.4142135623730951},"118":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"34":{"tf":1.0},"52":{"tf":1.0},"67":{"tf":1.0},"8":{"tf":1.7320508075688772}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":4,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"116":{"tf":1.0},"40":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"x":{"'":{"df":1,"docs":{"105":{"tf":1.0}}},".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"74":{"tf":1.0},"75":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{".":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":5,"docs":{"105":{"tf":3.3166247903554},"117":{"tf":1.0},"5":{"tf":1.4142135623730951},"58":{"tf":1.0},"66":{"tf":1.0}},"x":{"df":2,"docs":{"82":{"tf":1.0},"83":{"tf":1.0}}}},"y":{"df":2,"docs":{"105":{"tf":2.23606797749979},"5":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"98":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"'":{"df":0,"docs":{},"r":{"df":10,"docs":{"1":{"tf":1.0},"21":{"tf":1.4142135623730951},"32":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"86":{"tf":1.0}}},"v":{"df":2,"docs":{"25":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}}},"y":{"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"z":{"df":1,"docs":{"105":{"tf":1.0}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"53":{"tf":1.0},"71":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"title":{"root":{"2":{"0":{"2":{"1":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"b":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"d":{"df":3,"docs":{"32":{"tf":1.0},"44":{"tf":1.0},"52":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"114":{"tf":1.0},"115":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"103":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"116":{"tf":1.0},"97":{"tf":1.0}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"73":{"tf":1.0},"74":{"tf":1.0}}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"80":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"68":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"100":{"tf":1.0},"69":{"tf":1.0}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"86":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"80":{"tf":1.0},"81":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"62":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":4,"docs":{"17":{"tf":1.0},"27":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":4,"docs":{"68":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"88":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{}}},"df":2,"docs":{"76":{"tf":1.0},"78":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}},"c":{"df":0,"docs":{},"k":{"df":5,"docs":{"54":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"i":{"df":1,"docs":{"20":{"tf":1.0}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":13,"docs":{"0":{"tf":1.0},"107":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.0},"6":{"tf":1.4142135623730951},"68":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.0},"86":{"tf":1.0}}},"y":{"'":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"23":{"tf":1.0},"25":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"82":{"tf":1.0},"83":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"30":{"tf":1.0},"60":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"52":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"66":{"tf":1.0}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"50":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"35":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.0}}}}},"v":{"df":1,"docs":{"27":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"w":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"113":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"104":{"tf":1.0},"108":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":1,"docs":{"62":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}}},"f":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"94":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"118":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"22":{"tf":1.0},"34":{"tf":1.0}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}},"h":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"104":{"tf":1.0}}},"df":0,"docs":{}}}},"h":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"58":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"47":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"107":{"tf":1.0},"64":{"tf":1.0}}}}}}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"1":{"tf":1.0},"31":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"68":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"104":{"tf":1.0},"108":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"59":{"tf":1.0}}},"t":{"'":{"df":1,"docs":{"45":{"tf":1.0}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":14,"docs":{"107":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"111":{"tf":1.0}}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"66":{"tf":1.0}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"88":{"tf":1.0}}}},"n":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"87":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"62":{"tf":1.0},"65":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"102":{"tf":1.0},"92":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"32":{"tf":1.0},"79":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"109":{"tf":1.0}}}}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"111":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"42":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"105":{"tf":1.0},"107":{"tf":1.0}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"110":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"e":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":1,"docs":{"13":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"71":{"tf":1.0},"72":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"118":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":2,"docs":{"29":{"tf":1.0},"51":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"116":{"tf":1.0},"97":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"89":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"117":{"tf":1.0}}}}}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"114":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"108":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"41":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"80":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"69":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"75":{"tf":1.0}}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"106":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}},"o":{"a":{"d":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":3,"docs":{"100":{"tf":1.0},"90":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"39":{"tf":1.0},"49":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":6,"docs":{"45":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"98":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"37":{"tf":1.0}}}},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"3":{"tf":1.0},"31":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":4,"docs":{"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0}},"i":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"83":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"22":{"tf":1.0},"34":{"tf":1.0}}}}},"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"u":{"b":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"101":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":3,"docs":{"68":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"105":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"26":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"60":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"112":{"tf":1.0},"64":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}},"y":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"58":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"56":{"tf":1.0}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}}}}}}},"df":6,"docs":{"106":{"tf":1.0},"54":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"117":{"tf":1.0}}}}}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":4,"docs":{"107":{"tf":1.0},"2":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"94":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"45":{"tf":1.0},"79":{"tf":1.0}}}}}}}}},"w":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"78":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"69":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"23":{"tf":1.0},"60":{"tf":1.0}}}}}}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":20,"teaser_word_count":30},"search_options":{"bool":"AND","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":2},"title":{"boost":2}}}});