/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.joran.action;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.helpers.Option;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.joran.action.Action;
import org.apache.log4j.joran.spi.ExecutionContext;
import org.apache.log4j.spi.ErrorItem;
import org.xml.sax.Attributes;

public abstract class PropertyAction
extends Action {
    static String INVALID_ATTRIBUTES = "In <property> element, either the \"file\" attribute or both the \"name\" and \"value\" attributes must be set.";

    abstract void setProperties(ExecutionContext var1, Properties var2);

    abstract void setProperty(ExecutionContext var1, String var2, String var3);

    public void begin(ExecutionContext ec, String localName, Attributes attributes) {
        String name = attributes.getValue("name");
        String value = attributes.getValue("name");
        String fileName = attributes.getValue("file");
        if (!Option.isEmpty(fileName) && Option.isEmpty(name) && Option.isEmpty(value)) {
            Properties props = new Properties();
            try {
                FileInputStream istream = new FileInputStream(fileName);
                props.load(istream);
                istream.close();
                this.setProperties(ec, props);
            }
            catch (IOException e) {
                String errMsg = "Could not read properties file [" + fileName + "].";
                this.getLogger().error((Object)errMsg, e);
                ec.addError(new ErrorItem(INVALID_ATTRIBUTES, e));
                this.getLogger().error("Ignoring configuration file [" + fileName + "].");
            }
        } else if (!Option.isEmpty(name) && !Option.isEmpty(value) && Option.isEmpty(fileName)) {
            value = OptionConverter.convertSpecialChars(value);
            value = value.trim();
            this.setProperty(ec, name, value);
        } else {
            this.getLogger().error(INVALID_ATTRIBUTES);
            ec.addError(new ErrorItem(INVALID_ATTRIBUTES));
        }
    }

    public void end(ExecutionContext ec, String name) {
    }

    public void finish(ExecutionContext ec) {
    }
}

