/* this header file is used to create the driver structure */
/* for a dynamically loadable braille display driver. */
/* Routines provided by this braille display driver. */
static struct brlinfo identbrl (const char *, const char *);    /* print
                                                                   start-up
                                                                   messages */
static void brl_debug (unsigned int dbg);
static void initbrl (brldim *, const char *);   /* initialise Braille display 
                                                 */
static void closebrl (brldim *);        /* close braille display */
static void writebrl (brldim *);        /* write to braille display */
static int readbrl (int *);     /* get key press from braille display */
static void setbrlstat (const unsigned char *); /* set status cells */

braille_driver brl_driver = {
  BRLDRIVER,
  identbrl,
  brl_debug,
  initbrl,
  closebrl,
  writebrl,
  readbrl,
  setbrlstat
};
