# Copyright (C) 1995-1997 Robert de Bath <rdebath@cix.compulink.co.uk>
# This file is part of the Linux-8086 C library and is distributed
# under the GNU Library General Public License.
# 
# This file is automatically generated */

# Standard start


#ifndef __MSDOS__
#ifdef __AS386_32__
  .text
  .align 16
# CALL exit                    1   1	*

.ifdef L___exit
.globl __exit
.type __exit,@function
__exit:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $1,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL fork                    2   0

.ifdef L_fork
.globl fork
.type fork,@function
fork:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   $2,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL vfork                   2   0	. fake alias of fork

.ifdef L_vfork
.globl vfork
.type vfork,@function
vfork:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   $2,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL read                    3   3

.ifdef L_read
.globl read
.type read,@function
read:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   16(%ebp),%edx
  mov   $3,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL write                   4   3

.ifdef L_write
.globl write
.type write,@function
write:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   16(%ebp),%edx
  mov   $4,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL open                    5   3

.ifdef L_open
.globl open
.type open,@function
open:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   16(%ebp),%edx
  mov   $5,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL close                   6   1

.ifdef L_close
.globl close
.type close,@function
close:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $6,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL waitpid                 7   3

.ifdef L_waitpid
.globl waitpid
.type waitpid,@function
waitpid:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   16(%ebp),%edx
  mov   $7,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL creat                   8   2

.ifdef L_creat
.globl creat
.type creat,@function
creat:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $8,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL link                    9   2

.ifdef L_link
.globl link
.type link,@function
link:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $9,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL unlink                  10  1

.ifdef L_unlink
.globl unlink
.type unlink,@function
unlink:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $10,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL execve                  11  3

.ifdef L_execve
.globl execve
.type execve,@function
execve:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   16(%ebp),%edx
  mov   $11,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL chdir                   12  1

.ifdef L_chdir
.globl chdir
.type chdir,@function
chdir:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $12,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL time                    13  1

.ifdef L_time
.globl time
.type time,@function
time:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $13,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL dv32_mknod              14  3	* has correct args for 32bit dev_t

.ifdef L___dv32_mknod
.globl __dv32_mknod
.type __dv32_mknod,@function
__dv32_mknod:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   16(%ebp),%edx
  mov   $14,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL chmod                   15  2

.ifdef L_chmod
.globl chmod
.type chmod,@function
chmod:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $15,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL chown                   16  3

.ifdef L_chown
.globl chown
.type chown,@function
chown:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   16(%ebp),%edx
  mov   $16,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL lseek                   19  3

.ifdef L_lseek
.globl lseek
.type lseek,@function
lseek:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   16(%ebp),%edx
  mov   $19,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL getpid                  20  0

.ifdef L_getpid
.globl getpid
.type getpid,@function
getpid:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   $20,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL mount                   21  5

.ifdef L_mount
.globl mount
.type mount,@function
mount:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   16(%ebp),%edx
  push  %esi
  mov   20(%ebp),%esi
  push  %edi
  mov   24(%ebp),%edi
  mov   $21,%eax
  int   $0x80
  pop   %edi
  pop   %esi
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL umount                  22  1

.ifdef L_umount
.globl umount
.type umount,@function
umount:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $22,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL setuid                  23  1

.ifdef L_setuid
.globl setuid
.type setuid,@function
setuid:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $23,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL getuid                  24  0

.ifdef L_getuid
.globl getuid
.type getuid,@function
getuid:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   $24,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL stime                   25  1

.ifdef L_stime
.globl stime
.type stime,@function
stime:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $25,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL ptrace                  26  4

.ifdef L_ptrace
.globl ptrace
.type ptrace,@function
ptrace:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   16(%ebp),%edx
  push  %esi
  mov   20(%ebp),%esi
  mov   $26,%eax
  int   $0x80
  pop   %esi
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL alarm                   27  1

.ifdef L_alarm
.globl alarm
.type alarm,@function
alarm:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $27,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL pause                   29  0

.ifdef L_pause
.globl pause
.type pause,@function
pause:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   $29,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL utime                   30  2

.ifdef L_utime
.globl utime
.type utime,@function
utime:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $30,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL access                  33  2

.ifdef L_access
.globl access
.type access,@function
access:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $33,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL nice                    34  1

.ifdef L_nice
.globl nice
.type nice,@function
nice:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $34,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL ftime                   35  1

.ifdef L_ftime
.globl ftime
.type ftime,@function
ftime:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $35,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL sync                    36  0

.ifdef L_sync
.globl sync
.type sync,@function
sync:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   $36,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL kill                    37  2

.ifdef L_kill
.globl kill
.type kill,@function
kill:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $37,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL rename                  38  2

.ifdef L_rename
.globl rename
.type rename,@function
rename:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $38,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL mkdir                   39  2

.ifdef L_mkdir
.globl mkdir
.type mkdir,@function
mkdir:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $39,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL rmdir                   40  1

.ifdef L_rmdir
.globl rmdir
.type rmdir,@function
rmdir:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $40,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL dup                     41  1

.ifdef L_dup
.globl dup
.type dup,@function
dup:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $41,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL pipe                    42  1

.ifdef L_pipe
.globl pipe
.type pipe,@function
pipe:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $42,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL times                   43  1

.ifdef L_times
.globl times
.type times,@function
times:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $43,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL setgid                  46  1

.ifdef L_setgid
.globl setgid
.type setgid,@function
setgid:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $46,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL getgid                  47  0

.ifdef L_getgid
.globl getgid
.type getgid,@function
getgid:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   $47,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL signal                  48  2

.ifdef L_signal
.globl signal
.type signal,@function
signal:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $48,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL geteuid                 49  0

.ifdef L_geteuid
.globl geteuid
.type geteuid,@function
geteuid:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   $49,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL getegid                 50  0

.ifdef L_getegid
.globl getegid
.type getegid,@function
getegid:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   $50,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL acct                    51  1

.ifdef L_acct
.globl acct
.type acct,@function
acct:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $51,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL ioctl                   54  3

.ifdef L_ioctl
.globl ioctl
.type ioctl,@function
ioctl:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   16(%ebp),%edx
  mov   $54,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL fcntl                   55  3

.ifdef L_fcntl
.globl fcntl
.type fcntl,@function
fcntl:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   16(%ebp),%edx
  mov   $55,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL setpgid                 57  2

.ifdef L_setpgid
.globl setpgid
.type setpgid,@function
setpgid:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $57,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL ulimit                  58  2

.ifdef L_ulimit
.globl ulimit
.type ulimit,@function
ulimit:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $58,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL umask                   60  1

.ifdef L_umask
.globl umask
.type umask,@function
umask:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $60,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL chroot                  61  1

.ifdef L_chroot
.globl chroot
.type chroot,@function
chroot:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $61,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL dv32_ustat              62  2	* has correct args for 32bit dev_t

.ifdef L___dv32_ustat
.globl __dv32_ustat
.type __dv32_ustat,@function
__dv32_ustat:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $62,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL dup2                    63  2

.ifdef L_dup2
.globl dup2
.type dup2,@function
dup2:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $63,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL getppid                 64  0

.ifdef L_getppid
.globl getppid
.type getppid,@function
getppid:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   $64,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL getpgrp                 65  0

.ifdef L_getpgrp
.globl getpgrp
.type getpgrp,@function
getpgrp:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   $65,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL setsid                  66  0

.ifdef L_setsid
.globl setsid
.type setsid,@function
setsid:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   $66,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL sigaction               67  3

.ifdef L_sigaction
.globl sigaction
.type sigaction,@function
sigaction:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   16(%ebp),%edx
  mov   $67,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL siggetmask              68  0

.ifdef L_siggetmask
.globl siggetmask
.type siggetmask,@function
siggetmask:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   $68,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL sigsetmask              69  1

.ifdef L_sigsetmask
.globl sigsetmask
.type sigsetmask,@function
sigsetmask:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $69,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL setreuid                70  2

.ifdef L_setreuid
.globl setreuid
.type setreuid,@function
setreuid:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $70,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL setregid                71  2

.ifdef L_setregid
.globl setregid
.type setregid,@function
setregid:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $71,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL sigsuspend              72  1

.ifdef L_sigsuspend
.globl sigsuspend
.type sigsuspend,@function
sigsuspend:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $72,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL sigpending              73  1

.ifdef L_sigpending
.globl sigpending
.type sigpending,@function
sigpending:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $73,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL sethostname             74  2

.ifdef L_sethostname
.globl sethostname
.type sethostname,@function
sethostname:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $74,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL setrlimit               75  2

.ifdef L_setrlimit
.globl setrlimit
.type setrlimit,@function
setrlimit:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $75,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL getrlimit               76  2

.ifdef L_getrlimit
.globl getrlimit
.type getrlimit,@function
getrlimit:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $76,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL getrusage               77  2

.ifdef L_getrusage
.globl getrusage
.type getrusage,@function
getrusage:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $77,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL gettimeofday            78  2

.ifdef L_gettimeofday
.globl gettimeofday
.type gettimeofday,@function
gettimeofday:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $78,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL settimeofday            79  2

.ifdef L_settimeofday
.globl settimeofday
.type settimeofday,@function
settimeofday:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $79,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL getgroups               80  2

.ifdef L_getgroups
.globl getgroups
.type getgroups,@function
getgroups:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $80,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL setgroups               81  2

.ifdef L_setgroups
.globl setgroups
.type setgroups,@function
setgroups:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $81,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL select                  82  1	* select's arg is &arg1

.ifdef L___select
.globl __select
.type __select,@function
__select:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $82,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL symlink                 83  2

.ifdef L_symlink
.globl symlink
.type symlink,@function
symlink:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $83,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL readlink                85  3

.ifdef L_readlink
.globl readlink
.type readlink,@function
readlink:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   16(%ebp),%edx
  mov   $85,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL uselib                  86  1

.ifdef L_uselib
.globl uselib
.type uselib,@function
uselib:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $86,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL swapon                  87  2

.ifdef L_swapon
.globl swapon
.type swapon,@function
swapon:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $87,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL reboot                  88  3

.ifdef L_reboot
.globl reboot
.type reboot,@function
reboot:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   16(%ebp),%edx
  mov   $88,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL readdir                 89  3	* takes the fd not a ddptr

.ifdef L___readdir
.globl __readdir
.type __readdir,@function
__readdir:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   16(%ebp),%edx
  mov   $89,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL mmap                    90  1	* is a pointer to a buffer with the 6 args.

.ifdef L___mmap
.globl __mmap
.type __mmap,@function
__mmap:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $90,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL munmap                  91  2

.ifdef L_munmap
.globl munmap
.type munmap,@function
munmap:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $91,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL truncate                92  2

.ifdef L_truncate
.globl truncate
.type truncate,@function
truncate:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $92,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL ftruncate               93  2

.ifdef L_ftruncate
.globl ftruncate
.type ftruncate,@function
ftruncate:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $93,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL fchmod                  94  2

.ifdef L_fchmod
.globl fchmod
.type fchmod,@function
fchmod:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $94,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL fchown                  95  2

.ifdef L_fchown
.globl fchown
.type fchown,@function
fchown:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $95,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL getpriority             96  2

.ifdef L_getpriority
.globl getpriority
.type getpriority,@function
getpriority:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $96,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL setpriority             97  3

.ifdef L_setpriority
.globl setpriority
.type setpriority,@function
setpriority:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   16(%ebp),%edx
  mov   $97,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL statfs                  99  2

.ifdef L_statfs
.globl statfs
.type statfs,@function
statfs:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $99,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL fstatfs                 100 2

.ifdef L_fstatfs
.globl fstatfs
.type fstatfs,@function
fstatfs:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $100,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL ioperm                  101 3

.ifdef L_ioperm
.globl ioperm
.type ioperm,@function
ioperm:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   16(%ebp),%edx
  mov   $101,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL socketcall              102 2	* this is a lib internal for socket stuff

.ifdef L___socketcall
.globl __socketcall
.type __socketcall,@function
__socketcall:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $102,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL setitimer               104 3

.ifdef L_setitimer
.globl setitimer
.type setitimer,@function
setitimer:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   16(%ebp),%edx
  mov   $104,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL getitimer               105 2

.ifdef L_getitimer
.globl getitimer
.type getitimer,@function
getitimer:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $105,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL dv32_stat               106 2	* has correct args for 32 bit dev_t

.ifdef L___dv32_stat
.globl __dv32_stat
.type __dv32_stat,@function
__dv32_stat:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $106,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL dv32_lstat              107 2	* has correct args for 32 bit dev_t

.ifdef L___dv32_lstat
.globl __dv32_lstat
.type __dv32_lstat,@function
__dv32_lstat:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $107,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL dv32_fstat              108 2	* has correct args for 32 bit dev_t

.ifdef L___dv32_fstat
.globl __dv32_fstat
.type __dv32_fstat,@function
__dv32_fstat:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $108,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL iopl                    110 1

.ifdef L_iopl
.globl iopl
.type iopl,@function
iopl:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $110,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL vhangup                 111 0

.ifdef L_vhangup
.globl vhangup
.type vhangup,@function
vhangup:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   $111,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL vm86                    113 1

.ifdef L_vm86
.globl vm86
.type vm86,@function
vm86:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $113,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL wait4                   114 4

.ifdef L_wait4
.globl wait4
.type wait4,@function
wait4:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   16(%ebp),%edx
  push  %esi
  mov   20(%ebp),%esi
  mov   $114,%eax
  int   $0x80
  pop   %esi
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL swapoff                 115 1

.ifdef L_swapoff
.globl swapoff
.type swapoff,@function
swapoff:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $115,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL sysinfo                 116 1

.ifdef L_sysinfo
.globl sysinfo
.type sysinfo,@function
sysinfo:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $116,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL ipc                     117 5	* sysv ipc entry point

.ifdef L___ipc
.globl __ipc
.type __ipc,@function
__ipc:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   16(%ebp),%edx
  push  %esi
  mov   20(%ebp),%esi
  push  %edi
  mov   24(%ebp),%edi
  mov   $117,%eax
  int   $0x80
  pop   %edi
  pop   %esi
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL fsync                   118 1

.ifdef L_fsync
.globl fsync
.type fsync,@function
fsync:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $118,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL sigreturn               119 1	* signal internal

.ifdef L___sigreturn
.globl __sigreturn
.type __sigreturn,@function
__sigreturn:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $119,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL clone                   120 2

.ifdef L_clone
.globl clone
.type clone,@function
clone:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $120,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL setdomainname           121 2

.ifdef L_setdomainname
.globl setdomainname
.type setdomainname,@function
setdomainname:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $121,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL uname                   122 1

.ifdef L_uname
.globl uname
.type uname,@function
uname:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $122,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL adjtimex                124 1

.ifdef L_adjtimex
.globl adjtimex
.type adjtimex,@function
adjtimex:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $124,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL mprotect                125 3

.ifdef L_mprotect
.globl mprotect
.type mprotect,@function
mprotect:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   16(%ebp),%edx
  mov   $125,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL sigprocmask             126 3

.ifdef L_sigprocmask
.globl sigprocmask
.type sigprocmask,@function
sigprocmask:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   16(%ebp),%edx
  mov   $126,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL getpgid                 132 1

.ifdef L_getpgid
.globl getpgid
.type getpgid,@function
getpgid:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $132,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL fchdir                  133 1

.ifdef L_fchdir
.globl fchdir
.type fchdir,@function
fchdir:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $133,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL bdflush                 134 2

.ifdef L_bdflush
.globl bdflush
.type bdflush,@function
bdflush:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $134,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL sysfs                   135 3

.ifdef L_sysfs
.globl sysfs
.type sysfs,@function
sysfs:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   16(%ebp),%edx
  mov   $135,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL personality             136 1	* linux specific.

.ifdef L___personality
.globl __personality
.type __personality,@function
__personality:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $136,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL setfsuid                138 1

.ifdef L_setfsuid
.globl setfsuid
.type setfsuid,@function
setfsuid:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $138,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL setfsgid                139 1

.ifdef L_setfsgid
.globl setfsgid
.type setfsgid,@function
setfsgid:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   $139,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL getdents                141 3	* new style readdir ?

.ifdef L___getdents
.globl __getdents
.type __getdents,@function
__getdents:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   16(%ebp),%edx
  mov   $141,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

# CALL flock                   143 2

.ifdef L_flock
.globl flock
.type flock,@function
flock:
  pushl %ebp
  movl  %esp,%ebp
  pushl %ebx
  mov   8(%ebp),%ebx
  mov   12(%ebp),%ecx
  mov   $143,%eax
  int   $0x80
  pop   %ebx
  test  %eax,%eax
  jge   syscall_ok
  neg   %eax
  mov   %eax,errno
  mov   $-1,%eax
syscall_ok:
  movl  %ebp,%esp
  popl  %ebp
  ret
.endif

#endif /* __AS386_32__ */

#endif /* __MSDOS__ */

