/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSettings;
import java.io.IOException;

public class MathFontCommand
extends ControlSequence {
    private int style;

    public MathFontCommand(String string, int n) {
        super(string);
        this.style = n;
    }

    @Override
    public Object clone() {
        return new MathFontCommand(this.getName(), this.style);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXObject teXObject = teXParser.popNextArg();
        TeXSettings teXSettings = teXParser.getSettings();
        int n = teXSettings.getCurrentMathFont();
        teXSettings.setMathFont(this.style);
        teXObject.process(teXParser);
        teXSettings.setMathFont(n);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = teXObjectList.popArg(teXParser);
        TeXSettings teXSettings = teXParser.getSettings();
        int n = teXSettings.getCurrentMathFont();
        teXSettings.setMathFont(this.style);
        teXObject.process(teXParser, teXObjectList);
        teXSettings.setMathFont(n);
    }

    public int getStyle() {
        return this.style;
    }
}

