export type Selector = import('css-selector-parser').Selector
export type Selectors = import('css-selector-parser').Selectors
export type RuleSet = import('css-selector-parser').RuleSet
export type Rule = import('css-selector-parser').Rule
export type RulePseudo = import('css-selector-parser').RulePseudo
export type AttrValueType = import('css-selector-parser').AttrValueType
/**
 * Fix for types.
 */
export type Query = Selector | Rule | RulePseudo
export type RuleAttr = {
  name: string
  operator?: string | undefined
  valueType?: import('css-selector-parser').AttrValueType | undefined
  /**
   * More specific type for registered selector pseudos.
   */
  value?: string | undefined
}
export type RulePseudoSelector = {
  name: string
  valueType: 'selector'
  /**
   * Overwrite to compile nth-checks once.
   */
  value: Selector
}
export type RulePseudoNth = {
  name: string
  valueType: 'function'
  value: (index: number) => boolean
}
export type Node = import('unist').Node
export type Parent = import('unist').Parent
export type SelectState = {
  any: (
    query: Selectors | RuleSet | Rule,
    node: Node | undefined,
    state: SelectState
  ) => Node[]
  scopeNodes?: import('unist').Node<import('unist').Data>[] | undefined
  iterator?: SelectIterator | null | undefined
  one?: boolean | undefined
  shallow?: boolean | undefined
  index?: boolean | undefined
  found?: boolean | undefined
  /**
   * Track siblings
   */
  typeIndex?: number | undefined
  /**
   * Track siblings
   */
  nodeIndex?: number | undefined
  /**
   * Track siblings
   */
  typeCount?: number | undefined
  /**
   * Track siblings
   */
  nodeCount?: number | undefined
}
export type SelectIterator = (
  query: Rule,
  node: Node,
  index: number,
  parent: Parent | null,
  state: SelectState
) => any
export type Handler = (
  query: Rule,
  node: Node,
  index: number | null,
  parent: Parent | null,
  state: SelectState
) => void
