### AFU JSON Files

AFU implementations must indicate which top-level interface they expect.
The afu\_platform\_config script matches a platform to the expected AFU
interface.  AFUs demand a particular top-level interface either by passing
the interface class to afu\_platform\_config's --ifc argument or by encoding
the interface class in the AFU's packager JSON database.  The JSON option
offers more control, since top-level interface parameters can be modified
and automatically inserted clock crossings may be specified.

The interface encoding in JSON is in the afu-image:afu-top-interface:class
field:

```json
{
   "afu-image": {
      "afu-top-interface":
         {
            "class": "ccip_std_afu"
         }
   }
}
```

The interface "class" field was previously called "name".  For compatibility,
the legacy "name" key remains supported.

In addition to the class, some module-ports parameters may be overridden in
the AFU JSON database.  For example, the following makes local memory optional
and adds clock-crossing logic so that local memory's interface runs at the
same frequency as CCI-P.  These transformations are performed in a shim that
is automatically instantiated between the platform and the AFU's top-level
module.

```json
{
   "afu-image": {
      "afu-top-interface":
         {
            "class": "ccip_std_afu_avalon_mm",
            "module-ports" :
               [
                  {
                     "class": "local-memory",
                     "optional": true,
                     "params":
                        {
                           "clock": "pClk"
                        }
                  }
               ]
         }
   }
}
```

Note, also, that this AFU declared local memory optional.
Using preprocessor variables generated by afu\_platform\_config, an AFU
declaring local memory optional must be prepared to compile correctly
whether or not local memory is available.

Other module-ports requirements may also be modified here, including
default-entries, max-entries and min-entries.
