// Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may not
// use this file except in compliance with the License. A copy of the
// License is located at
//
// http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
// either express or implied. See the License for the specific language governing
// permissions and limitations under the License.

// Package vault provide interface for data storage.
package vault

type Vault interface {
	Store(manifestFileNamePrefix string, key string, data []byte) (err error)
	Retrieve(manifestFileNamePrefix string, key string) (data []byte, err error)
	Remove(key string) (err error)
}
