/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles.xmlDefinition;

import org.apache.struts.tiles.DefinitionNameAttribute;
import org.apache.struts.tiles.DirectStringAttribute;
import org.apache.struts.tiles.PathAttribute;
import org.apache.struts.tiles.UntyppedAttribute;

public class XmlAttribute {
    private String name;
    private Object value;
    private String direct = null;
    private String valueType = null;
    private String role = null;
    private Object realValue;

    public XmlAttribute() {
    }

    public XmlAttribute(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getRole() {
        return this.role;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getAttribute() {
        return this.name;
    }

    public void setAttribute(String aName) {
        this.name = aName;
    }

    public Object getValue() {
        if (this.realValue == null) {
            this.realValue = this.computeRealValue();
        }
        return this.realValue;
    }

    public void setValue(Object aValue) {
        this.realValue = null;
        this.value = aValue;
    }

    public void setContent(Object aValue) {
        this.setValue(aValue);
    }

    public void setBody(String body) {
        if (body.length() == 0) {
            return;
        }
        this.setValue(body);
    }

    public void setDirect(String value) {
        this.direct = value;
    }

    public void setType(String value) {
        this.valueType = value;
    }

    protected Object computeRealValue() {
        Object realValue = this.value;
        if (this.direct != null) {
            this.valueType = Boolean.valueOf(this.direct) == true ? "string" : "path";
        }
        if (this.value != null && this.valueType != null) {
            String strValue = this.value.toString();
            if (this.valueType.equalsIgnoreCase("string")) {
                realValue = new DirectStringAttribute(strValue);
            } else if (this.valueType.equalsIgnoreCase("page")) {
                realValue = new PathAttribute(strValue);
            } else if (this.valueType.equalsIgnoreCase("template")) {
                realValue = new PathAttribute(strValue);
            } else if (this.valueType.equalsIgnoreCase("instance")) {
                realValue = new DefinitionNameAttribute(strValue);
            }
            if (this.role != null) {
                ((UntyppedAttribute)realValue).setRole(this.role);
            }
        }
        if (this.role != null && this.value != null && this.valueType == null) {
            realValue = new UntyppedAttribute(this.value.toString(), this.role);
        }
        return realValue;
    }
}

