/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.hql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.hql.FromParser;
import net.sf.hibernate.hql.GroupByParser;
import net.sf.hibernate.hql.HavingParser;
import net.sf.hibernate.hql.OrderByParser;
import net.sf.hibernate.hql.Parser;
import net.sf.hibernate.hql.QueryTranslator;
import net.sf.hibernate.hql.SelectParser;
import net.sf.hibernate.hql.WhereParser;

public class ClauseParser
implements Parser {
    private Parser child;
    private List selectTokens;
    private boolean cacheSelectTokens = false;
    private boolean byExpected = false;
    private boolean enableSubselect = false;

    public void token(String token, QueryTranslator q) throws QueryException {
        String lcToken = token.toLowerCase();
        if (this.byExpected && !lcToken.equals("by")) {
            throw new QueryException("BY expected after GROUP or ORDER: " + token);
        }
        if (!this.enableSubselect && lcToken.equals("select")) {
            this.selectTokens = new ArrayList();
            this.cacheSelectTokens = true;
        } else if (!this.enableSubselect && lcToken.equals("from")) {
            this.child = new FromParser();
            this.child.start(q);
            this.cacheSelectTokens = false;
        } else if (!this.enableSubselect && lcToken.equals("where")) {
            this.enableSubselect = true;
            this.endChild(q);
            this.child = new WhereParser();
            this.child.start(q);
        } else if (lcToken.equals("order")) {
            this.endChild(q);
            this.child = new OrderByParser();
            this.byExpected = true;
        } else if (lcToken.equals("having")) {
            this.endChild(q);
            this.enableSubselect = true;
            this.child = new HavingParser();
            this.child.start(q);
        } else if (lcToken.equals("group")) {
            this.endChild(q);
            this.child = new GroupByParser();
            this.byExpected = true;
        } else if (lcToken.equals("by")) {
            if (!this.byExpected) {
                throw new QueryException("GROUP or ORDER expected before BY");
            }
            this.child.start(q);
            this.byExpected = false;
        } else if (this.cacheSelectTokens) {
            this.selectTokens.add(token);
        } else {
            if (this.child == null) {
                throw new QueryException("query must begin with SELECT or FROM: " + token);
            }
            this.child.token(token, q);
        }
    }

    private void endChild(QueryTranslator q) throws QueryException {
        if (this.child == null) {
            this.cacheSelectTokens = false;
        } else {
            this.child.end(q);
        }
    }

    public void start(QueryTranslator q) {
    }

    public void end(QueryTranslator q) throws QueryException {
        this.endChild(q);
        if (this.selectTokens != null) {
            this.child = new SelectParser();
            this.child.start(q);
            Iterator iter = this.selectTokens.iterator();
            while (iter.hasNext()) {
                this.token((String)iter.next(), q);
            }
            this.child.end(q);
        }
        this.byExpected = false;
        this.enableSubselect = false;
        this.cacheSelectTokens = false;
    }
}

