/*
 * Decompiled with CFR 0.152.
 */
package net.eyde.personalblog.service;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class InitializationManager {
    private static Properties hibernate_properties;
    private static Log log;
    Properties connProperties;

    static {
        log = LogFactory.getLog(InitializationManager.class);
    }

    public InitializationManager() {
    }

    public InitializationManager(Properties connectionProperties) {
        this.connProperties = connectionProperties;
    }

    public void createHibernateConfigFile(String inPath) {
        log.debug((Object)"initializationPersonalBlog - start");
        try {
            File hibernate = new File(inPath);
            log.debug((Object)"writing to hibernate.properties -start");
            log.debug((Object)("filepath: " + inPath));
            BufferedWriter writer = new BufferedWriter(new FileWriter(hibernate));
            writer.write("hibernate.connection.driver_class=" + this.connProperties.getProperty("hibernate.connection.driver_class"));
            writer.newLine();
            writer.write("hibernate.connection.url=" + this.connProperties.getProperty("hibernate.connection.url"));
            writer.newLine();
            writer.write("hibernate.connection.username=" + this.connProperties.getProperty("hibernate.connection.username"));
            writer.newLine();
            writer.write("hibernate.connection.password=" + this.connProperties.getProperty("hibernate.connection.password"));
            writer.close();
            log.debug((Object)"writing to hibernate.properties - stop");
        }
        catch (Exception e) {
            log.error((Object)"Error while writing hibernate properties");
            log.error((Object)e.toString());
        }
        log.debug((Object)"initializationPersonalBlog - end");
    }

    public void createTables(String fileName) {
        log.debug((Object)"createTables - start");
        try {
            Class.forName(hibernate_properties.getProperty("hibernate.connection.driver_class"));
            Connection conn = DriverManager.getConnection(String.valueOf(hibernate_properties.getProperty("hibernate.connection.url")) + "?user=" + hibernate_properties.getProperty("hibernate.connection.username") + "&password=" + hibernate_properties.getProperty("hibernate.connection.password"));
            Statement stmt = conn.createStatement();
            SAXReader xmlReader = new SAXReader();
            InputStream is = this.getClass().getResourceAsStream(fileName);
            Document doc = xmlReader.read(is);
            Element root = doc.getRootElement();
            Iterator elementIterator = root.elementIterator();
            while (elementIterator.hasNext()) {
                Element element = (Element)elementIterator.next();
                log.debug((Object)("NAME: " + element.getName()));
                log.debug((Object)("TEXT: " + element.getText()));
                try {
                    stmt.executeUpdate(element.getText());
                }
                catch (SQLException e) {
                    log.debug((Object)("error code:" + e.getErrorCode()));
                    log.error((Object)"The table already exists", (Throwable)e);
                }
            }
            log.debug((Object)"Closing connections");
            stmt.close();
            conn.close();
        }
        catch (Exception e) {
            log.error((Object)"Error while creating tables", (Throwable)e);
        }
        log.debug((Object)"create tables- end");
    }

    public boolean hibernateFileExists() {
        log.debug((Object)"Checking for existence of hibernate files");
        URL url = this.getClass().getResource("/hibernate.properties");
        hibernate_properties = new Properties();
        try {
            hibernate_properties.load(url.openStream());
        }
        catch (Exception e) {
            log.error((Object)"error while checking for hibernate file", (Throwable)e);
            return false;
        }
        log.debug((Object)"hibernate file exists");
        return true;
    }

    public boolean dataBaseOn() {
        boolean result = true;
        try {
            Class.forName(hibernate_properties.getProperty("hibernate.connection.driver_class"));
            Connection conn = DriverManager.getConnection(String.valueOf(hibernate_properties.getProperty("hibernate.connection.url")) + "?user=" + hibernate_properties.getProperty("hibernate.connection.username") + "&password=" + hibernate_properties.getProperty("hibernate.connection.password"));
            log.debug((Object)"Closing connections");
            conn.close();
        }
        catch (Exception e) {
            log.debug((Object)"error while testing if database is on", (Throwable)e);
            result = false;
        }
        return result;
    }

    public boolean tablesCreated(Vector<String> v) {
        boolean result = true;
        try {
            Class.forName(hibernate_properties.getProperty("hibernate.connection.driver_class"));
            Connection conn = DriverManager.getConnection(String.valueOf(hibernate_properties.getProperty("hibernate.connection.url")) + "?user=" + hibernate_properties.getProperty("hibernate.connection.username") + "&password=" + hibernate_properties.getProperty("hibernate.connection.password"));
            Statement stmt = conn.createStatement();
            try {
                stmt.executeQuery("select * from t_comments");
            }
            catch (SQLException e) {
                v.add("t_comments");
                log.debug((Object)"didn't find t_comments table");
            }
            try {
                stmt.executeQuery("select * from t_posts");
            }
            catch (SQLException e1) {
                v.add("t_posts");
                log.debug((Object)"didn't find t_posts table");
            }
            try {
                stmt.executeQuery("select * from t_referrers");
            }
            catch (SQLException e2) {
                v.add("t_referrers");
                log.debug((Object)"didn't find t_referrers");
            }
            try {
                stmt.executeQuery("select * from t_properties");
            }
            catch (SQLException e3) {
                v.add("t_properties");
                log.debug((Object)"didn't find t_properties");
            }
            log.debug((Object)"Closing connections");
            stmt.close();
            conn.close();
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e);
        }
        catch (SQLException e) {
            log.error((Object)e);
        }
        if (v.size() > 0) {
            result = false;
        }
        return result;
    }

    public boolean propertiesMissing() {
        log.debug((Object)"Checking for missing properties");
        boolean result = true;
        try {
            Class.forName(hibernate_properties.getProperty("hibernate.connection.driver_class"));
            Connection conn = DriverManager.getConnection(String.valueOf(hibernate_properties.getProperty("hibernate.connection.url")) + "?user=" + hibernate_properties.getProperty("hibernate.connection.username") + "&password=" + hibernate_properties.getProperty("hibernate.connection.password"));
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select * from t_properties");
            Properties p = new Properties();
            while (rs.next()) {
                p.put(rs.getString("name"), rs.getString("value"));
            }
            log.debug((Object)"Closing connections");
            stmt.close();
            conn.close();
            result = false;
            result = !p.containsKey("weblog.title") ? true : result;
            result = !p.containsKey("weblog.description") ? true : result;
            result = !p.containsKey("weblog.ownerpicture") ? true : result;
            result = !p.containsKey("weblog.ownernickname") ? true : result;
            result = !p.containsKey("weblog.url") ? true : result;
            result = !p.containsKey("weblog.email") ? true : result;
            result = !p.containsKey("links.post") ? true : result;
            result = !p.containsKey("emoticon.values") ? true : result;
            result = !p.containsKey("emoticon.images") ? true : result;
            result = !p.containsKey("logon.id") ? true : result;
            result = !p.containsKey("logon.password") ? true : result;
            result = !p.containsKey("category.titles") ? true : result;
            result = !p.containsKey("category.values") ? true : result;
            result = !p.containsKey("category.images") ? true : result;
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e);
        }
        catch (SQLException e) {
            log.error((Object)e);
        }
        return result;
    }
}

