/**********************************************************************
 * $test_acc_fetch_value example -- C source code using ACC PLI routines
 *
 * C source to various formats of acc_fetch_value().
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *
 * Usage: $test_acc_fetch_value(<signal>);
 *
 * Routine definitions for a veriusertfs array:
 *  /* routine prototypes -/
 *   extern int PLIbook_ListNets_checktf(),
 *              PLIbook_ListNets_calltf();
 *  /* table entries -/
 *   {usertask,                       /* type of PLI routine -/
 *     0,                             /* user_data value -/
 *     0,                             /* checktf routine -/
 *     0,                             /* sizetf routine -/
 *     PLIbook_TestFetchVal_calltf,   /* calltf routine -/
 *     0,                             /* misctf routine -/
 *     "$test_acc_fetch_value",       /* system task/function name -/
 *     1                              /* forward reference = true -/
 *   },
 *********************************************************************/

#include "veriuser.h"         /* IEEE 1364 PLI TF  routine library */
#include "acc_user.h"         /* IEEE 1364 PLI ACC routine library */
/**********************************************************************
 * calltf routine
 *********************************************************************/
int PLIbook_TestFetchVal_calltf()
{
  handle tfarg_h;
  s_acc_value val_s;

  acc_initialize();
  acc_configure(accDisplayWarnings, "true");
  
  tfarg_h = acc_handle_tfarg(1);

  val_s.format = accBinStrVal; /* */
/*  val_s.format = accIntVal; /* */
/*  val_s.format = accRealVal; /* */

  if (acc_error_flag)
    io_printf("acc_fecth_value() error\n");

  acc_fetch_value(tfarg_h, "%%", &val_s);

  io_printf("%s = %s\n", acc_fetch_name(tfarg_h), val_s.value.str); /* */
/*  io_printf("%s = %d\n", acc_fetch_name(tfarg_h), val_s.value.integer); /* */
/*  io_printf("%s = %f\n", acc_fetch_name(tfarg_h), val_s.value.real); /* */

  acc_close();
  return(0);
}
/*********************************************************************/

