# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import functools


def api_version_validation(**kwargs):
    params_valid_on = kwargs.pop("params_valid_on", {})
    method_valid_on = kwargs.pop("method_valid_on", {})

    def decorator(func):
        @functools.wraps(func)
        def wrapper(*args, **kwargs):
            func_name = func.__name__
            try:
                client = args[0]
                client_api_version = client._get_api_version(func_name)  # pylint: disable=protected-access
            except AttributeError:
                client_api_version = client._api_version  # pylint: disable=protected-access

            if method_valid_on and client_api_version not in method_valid_on:
                raise ValueError(
                    f"'{func_name}' is not available in API version "
                    f"{client_api_version}. All valid API version are {', '.join(method_valid_on)}."
                )

            unsupported = {
                parameter: ", ".join(api_versions)
                for parameter, api_versions in params_valid_on.items()
                if parameter in kwargs and client_api_version not in api_versions
            }
            if unsupported:
                raise ValueError(
                    "".join(
                        [
                            f"'{param}' is not available in API version {client_api_version}. "
                            f"All valid API version are {versions} \n"
                            for param, versions in unsupported.items()
                        ]
                    )
                )
            return func(*args, **kwargs)

        return wrapper

    return decorator
