/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.util.Hashtable;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Structure;

public class GroupNaming {
    private Hashtable _groupNames = new Hashtable();

    public String createClassName(Group group) {
        String name = group.getName();
        if (name != null) {
            return JavaNaming.toJavaClassName(name);
        }
        name = (String)this._groupNames.get(group);
        if (name != null) {
            return name;
        }
        Structure parent = group.getParent();
        if (parent == null) {
            return null;
        }
        boolean addOrder = true;
        switch (parent.getStructureType()) {
            case 10: {
                name = this.createClassName((Group)parent);
                break;
            }
            case 16: {
                name = ((ModelGroup)parent).getName();
                name = JavaNaming.toJavaClassName(name);
                addOrder = false;
                break;
            }
            case 6: {
                name = GroupNaming.getClassName((ComplexType)parent);
                addOrder = false;
                break;
            }
        }
        if (name != null) {
            if (addOrder) {
                String order = group.getOrder().toString();
                name = name + JavaNaming.toJavaClassName(order);
            }
            int count = 2;
            String tmpName = name;
            while (this._groupNames.contains(name)) {
                name = tmpName + count;
                ++count;
            }
            this._groupNames.put(group, name);
        }
        return name;
    }

    private static String getClassName(ComplexType complexType) {
        String name = complexType.getName();
        if (name != null) {
            return JavaNaming.toJavaClassName(name);
        }
        Structure parent = complexType.getParent();
        if (parent != null && parent.getStructureType() == 8) {
            name = ((ElementDecl)parent).getName();
        }
        if (name != null) {
            name = JavaNaming.toJavaClassName(name);
        }
        return name;
    }
}

