/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.HTMLElementScriptable;
import com.meterware.httpunit.HTMLSegment;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.ParsedHTML;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.net.URL;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TableCell
extends ParsedHTML
implements HTMLSegment,
HTMLElement {
    private ScriptableDelegate _scriptable;
    private Element _element;
    private int _colSpan;
    private int _rowSpan;

    public int getColSpan() {
        return this._colSpan;
    }

    public int getRowSpan() {
        return this._rowSpan;
    }

    public String asText() {
        return this.getCellContentsAsText(this._element);
    }

    public Node getDOM() {
        return super.getDOM();
    }

    public String getID() {
        return this.getAttribute("id");
    }

    public String getClassName() {
        return this.getAttribute("class");
    }

    public String getName() {
        return this.getAttribute("name");
    }

    public String getTitle() {
        return this.getAttribute("title");
    }

    public ScriptableDelegate getScriptableDelegate() {
        if (this._scriptable == null) {
            this._scriptable = new HTMLElementScriptable(this);
            this._scriptable.setScriptEngine(this.getResponse().getScriptableObject().getDocument().getScriptEngine(this._scriptable));
        }
        return this._scriptable;
    }

    private String getAttribute(String name) {
        return NodeUtils.getNodeAttribute(this._element, name);
    }

    public boolean equals(Object obj) {
        return obj instanceof TableCell && this.equals((TableCell)obj);
    }

    private boolean equals(TableCell cell) {
        return this._element.equals(cell._element);
    }

    public int hashCode() {
        return this._element.hashCode();
    }

    TableCell(WebResponse response, String frameName, Element cellNode, URL url, String parentTarget, String characterSet) {
        super(response, frameName, url, parentTarget, cellNode, characterSet);
        this._element = cellNode;
        this._colSpan = this.getAttributeValue(cellNode, "colspan", 1);
        this._rowSpan = this.getAttributeValue(cellNode, "rowspan", 1);
    }

    private String getCellContentsAsText(Node node) {
        if (node == null) {
            return "";
        }
        if (!node.hasChildNodes()) {
            return "";
        }
        return NodeUtils.asText(node.getChildNodes());
    }

    private int getAttributeValue(Node node, String attributeName, int defaultValue) {
        return NodeUtils.getAttributeValue(node, attributeName, defaultValue);
    }
}

