/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import net.sourceforge.plantuml.geom.LineSegmentInt;
import net.sourceforge.plantuml.graph.ALink;
import net.sourceforge.plantuml.graph.ANode;
import net.sourceforge.plantuml.graph.Board;
import net.sourceforge.plantuml.graph.CostComputer;

public class KenavoCostComputer
implements CostComputer {
    @Override
    public double getCost(Board board) {
        double result = 0.0;
        for (ALink aLink : board.getLinks()) {
            for (ALink aLink2 : board.getLinks()) {
                result += this.getCost(board, aLink, aLink2);
            }
        }
        return result;
    }

    LineSegmentInt getLineSegment(Board board, ALink link) {
        ANode n1 = link.getNode1();
        ANode n2 = link.getNode2();
        return new LineSegmentInt(board.getCol(n1), n1.getRow(), board.getCol(n2), n2.getRow());
    }

    private double getCost(Board board, ALink link1, ALink link2) {
        LineSegmentInt seg1 = this.getLineSegment(board, link1);
        LineSegmentInt seg2 = this.getLineSegment(board, link2);
        double len1 = this.getLength(link1, seg1, board);
        double len2 = this.getLength(link2, seg2, board);
        return len1 * len2 * Math.exp(-seg1.getDistance(seg2));
    }

    private double getLength(ALink link, LineSegmentInt seg, Board board) {
        double coef = 1.0;
        if (link.getNode1().getRow() == link.getNode2().getRow() && board.getDirection(link) != board.getInitialDirection(link)) {
            coef = 1.1;
        }
        return seg.getLength() * coef;
    }
}

