#!/bin/sh
#
# ssg-apply script.
#
# Copyright (c) 2021 SUSE LINUX Products GmbH, Nuernberg, Germany.
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Author: Ann Davis <andavis@suse.com>
#

PROGNAME=`basename $0`
SBINPATH="/usr/sbin"
BINPATH="/usr/bin"
CONFPATH="/etc/$PROGNAME"
OUTPUTPATH="/var/log/$PROGNAME"

ts=`date +%s`

outFile="$OUTPUTPATH/$PROGNAME-$ts.out"
logFile="$OUTPUTPATH/$PROGNAME-$ts.log"
defConfFile="$CONFPATH/default.conf"
overrideConfFile="$CONFPATH/override.conf"
if [  -r "$overrideConfFile" ]; then
	confFile="$overrideConfFile"
elif [ -r "$defConfFile" ]; then
	confFile="$defConfFile"
else
	echo "*** DEBUG: $0: No conf file, exiting..."
	exit 1
fi
echo "*** DEBUG: $0: confFile: $confFile" >> $logFile
contentFile=`grep -m 1 "^content-file=" $confFile | cut -d'=' -f2`
profile=`grep -m 1 "^profile=" $confFile | cut -d'=' -f2`
remediate=`grep -m 1 "^remediate=" $confFile | cut -d'=' -f2`
if [ "$remediate" = "yes" ]; then
	evalOpts="--remediate"
fi
tFile=`grep -m 1 "^tailoring-file=" $confFile | cut -d'=' -f2`
echo "*** DEBUG: $0: profile: $profile" >> $logFile
echo "*** DEBUG: $0: contentFile: $contentFile" >> $logFile
echo "*** DEBUG: $0: action: $action" >> $logFile
echo "*** DEBUG: $0: tFile: $tFile" >> $logFile
if [ "$tFile" != "none" ]; then
	tFileProfile=`grep "<xccdf:Profile id=" $tFile | cut -d'=' -f2 | cut -d' ' -f1 | tr -d '"'`
	oscapOpts="eval $evalOpts --profile $profile --profile $tFileProfile --tailoring-file $tFile $contentFile"
else
	oscapOpts="eval $evalOpts --profile $profile $contentFile"
fi
echo "*** DEBUG: $0: tFileProfile: $tFileProfile" >> $logFile
echo "*** DEBUG: $0: oscapOpts: $oscapOpts" >> $logFile

echo "*** DEBUG: $0: oscap command: $BINPATH/oscap xccdf $oscapOpts" >> $logFile
$BINPATH/oscap xccdf $oscapOpts > $outFile 2>> $logFile

exit 0
