; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=x86-64 -mattr=+xop | FileCheck %s --check-prefix=GENERIC
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=bdver1 | FileCheck %s --check-prefix=BDVER --check-prefix=BDVER1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=bdver2 | FileCheck %s --check-prefix=BDVER --check-prefix=BDVER2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=bdver3 | FileCheck %s --check-prefix=BDVER --check-prefix=BDVER3
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=bdver4 | FileCheck %s --check-prefix=BDVER --check-prefix=BDVER4

define void @test_vfrczpd(<2 x double> %a0, <4 x double> %a1, <2 x double> *%a2, <4 x double> *%a3) {
; GENERIC-LABEL: test_vfrczpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vfrczpd %xmm0, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    vfrczpd %ymm1, %ymm1 # sched: [3:1.00]
; GENERIC-NEXT:    vfrczpd (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    vfrczpd (%rsi), %ymm1 # sched: [10:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    vzeroupper # sched: [100:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vfrczpd:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vfrczpd %xmm0, %xmm0
; BDVER-NEXT:    vfrczpd %ymm1, %ymm1
; BDVER-NEXT:    vfrczpd (%rdi), %xmm0
; BDVER-NEXT:    vfrczpd (%rsi), %ymm1
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    vzeroupper
; BDVER-NEXT:    retq
  call void asm sideeffect "vfrczpd $0, $0 \0a\09 vfrczpd $1, $1 \0a\09 vfrczpd $2, $0 \0a\09 vfrczpd $3, $1", "x,x,*m,*m"(<2 x double> %a0, <4 x double> %a1, <2 x double> *%a2, <4 x double> *%a3)
  ret void
}

define void @test_vfrczps(<4 x float> %a0, <4 x double> %a1, <4 x float> *%a2, <4 x double> *%a3) {
; GENERIC-LABEL: test_vfrczps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vfrczps %xmm0, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    vfrczps %ymm1, %ymm1 # sched: [3:1.00]
; GENERIC-NEXT:    vfrczps (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    vfrczps (%rsi), %ymm1 # sched: [10:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    vzeroupper # sched: [100:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vfrczps:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vfrczps %xmm0, %xmm0
; BDVER-NEXT:    vfrczps %ymm1, %ymm1
; BDVER-NEXT:    vfrczps (%rdi), %xmm0
; BDVER-NEXT:    vfrczps (%rsi), %ymm1
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    vzeroupper
; BDVER-NEXT:    retq
  call void asm sideeffect "vfrczps $0, $0 \0a\09 vfrczps $1, $1 \0a\09 vfrczps $2, $0 \0a\09 vfrczps $3, $1", "x,x,*m,*m"(<4 x float> %a0, <4 x double> %a1, <4 x float> *%a2, <4 x double> *%a3)
  ret void
}

define void @test_vfrczsd(<2 x double> %a0, <2 x double> *%a1) {
; GENERIC-LABEL: test_vfrczsd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vfrczsd %xmm0, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    vfrczsd (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vfrczsd:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vfrczsd %xmm0, %xmm0
; BDVER-NEXT:    vfrczsd (%rdi), %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vfrczsd $0, $0 \0a\09 vfrczsd $1, $0", "x,*m"(<2 x double> %a0, <2 x double> *%a1)
  ret void
}

define void @test_vfrczss(<4 x float> %a0, <4 x double> *%a1) {
; GENERIC-LABEL: test_vfrczss:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vfrczss %xmm0, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    vfrczss (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vfrczss:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vfrczss %xmm0, %xmm0
; BDVER-NEXT:    vfrczss (%rdi), %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vfrczss $0, $0 \0a\09 vfrczss $1, $0", "x,*m"(<4 x float> %a0, <4 x double> *%a1)
  ret void
}

define void @test_vpcmov_128(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpcmov_128:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpcmov %xmm2, %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    vpcmov (%rdi), %xmm1, %xmm0, %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    vpcmov %xmm2, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vpcmov_128:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vpcmov %xmm2, %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpcmov (%rdi), %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpcmov %xmm2, (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vpcmov $2, $1, $0, $0 \0a\09 vpcmov $3, $1, $0, $0 \0a\09 vpcmov $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vpcmov_256(<4 x i64> %a0, <4 x i64> %a1, <4 x i64> %a2, <4 x i64> *%a3) {
; GENERIC-LABEL: test_vpcmov_256:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpcmov %ymm2, %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpcmov (%rdi), %ymm1, %ymm0, %ymm0 # sched: [8:1.00]
; GENERIC-NEXT:    vpcmov %ymm2, (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    vzeroupper # sched: [100:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vpcmov_256:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vpcmov %ymm2, %ymm1, %ymm0, %ymm0
; BDVER-NEXT:    vpcmov (%rdi), %ymm1, %ymm0, %ymm0
; BDVER-NEXT:    vpcmov %ymm2, (%rdi), %ymm0, %ymm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    vzeroupper
; BDVER-NEXT:    retq
  call void asm sideeffect "vpcmov $2, $1, $0, $0 \0a\09 vpcmov $3, $1, $0, $0 \0a\09 vpcmov $2, $3, $0, $0", "x,x,x,*m"(<4 x i64> %a0, <4 x i64> %a1, <4 x i64> %a2, <4 x i64> *%a3)
  ret void
}

define void @test_vpcom(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> *%a2) {
; GENERIC-LABEL: test_vpcom:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpcomb $3, %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    vpcomd $3, %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    vpcomq $3, %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    vpcomw $3, %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    vpcomb $3, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    vpcomd $3, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    vpcomq $3, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    vpcomw $3, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vpcom:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vpcomb $3, %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpcomd $3, %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpcomq $3, %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpcomw $3, %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpcomb $3, (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    vpcomd $3, (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    vpcomq $3, (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    vpcomw $3, (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vpcomb $3, $1, $0, $0 \0a\09 vpcomd $3, $1, $0, $0 \0a\09 vpcomq $3, $1, $0, $0 \0a\09 vpcomw $3, $1, $0, $0 \0a\09 vpcomb $3, $2, $0, $0 \0a\09 vpcomd $3, $2, $0, $0 \0a\09 vpcomq $3, $2, $0, $0 \0a\09 vpcomw $3, $2, $0, $0", "x,x,*m,i"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> *%a2, i8 3)
  ret void
}

define void @test_vpcomu(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> *%a2) {
; GENERIC-LABEL: test_vpcomu:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpcomub $3, %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    vpcomud $3, %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    vpcomuq $3, %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    vpcomuw $3, %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    vpcomub $3, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    vpcomud $3, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    vpcomuq $3, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    vpcomuw $3, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vpcomu:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vpcomub $3, %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpcomud $3, %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpcomuq $3, %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpcomuw $3, %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpcomub $3, (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    vpcomud $3, (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    vpcomuq $3, (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    vpcomuw $3, (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vpcomub $3, $1, $0, $0 \0a\09 vpcomud $3, $1, $0, $0 \0a\09 vpcomuq $3, $1, $0, $0 \0a\09 vpcomuw $3, $1, $0, $0 \0a\09 vpcomub $3, $2, $0, $0 \0a\09 vpcomud $3, $2, $0, $0 \0a\09 vpcomuq $3, $2, $0, $0 \0a\09 vpcomuw $3, $2, $0, $0", "x,x,*m,i"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> *%a2, i8 3)
  ret void
}

define void @test_vpermil2pd_128(<2 x double> %a0, <2 x double> %a1, <2 x double> %a2, <2 x double> *%a3) {
; GENERIC-LABEL: test_vpermil2pd_128:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpermil2pd $3, %xmm2, %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpermil2pd $3, %xmm2, (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpermil2pd $3, (%rdi), %xmm1, %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vpermil2pd_128:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vpermil2pd $3, %xmm2, %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpermil2pd $3, %xmm2, (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    vpermil2pd $3, (%rdi), %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vpermil2pd $4, $2, $1, $0, $0 \0a\09 vpermil2pd $4, $2, $3, $0, $0 \0a\09 vpermil2pd $4, $3, $1, $0, $0", "x,x,x,*m,i"(<2 x double> %a0, <2 x double> %a1, <2 x double> %a2, <2 x double> *%a3, i8 3)
  ret void
}

define void @test_vpermil2pd_256(<4 x double> %a0, <4 x double> %a1, <4 x double> %a2, <4 x double> *%a3) {
; GENERIC-LABEL: test_vpermil2pd_256:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpermil2pd $3, %ymm2, %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpermil2pd $3, %ymm2, (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; GENERIC-NEXT:    vpermil2pd $3, (%rdi), %ymm1, %ymm0, %ymm0 # sched: [8:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    vzeroupper # sched: [100:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vpermil2pd_256:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vpermil2pd $3, %ymm2, %ymm1, %ymm0, %ymm0
; BDVER-NEXT:    vpermil2pd $3, %ymm2, (%rdi), %ymm0, %ymm0
; BDVER-NEXT:    vpermil2pd $3, (%rdi), %ymm1, %ymm0, %ymm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    vzeroupper
; BDVER-NEXT:    retq
  call void asm sideeffect "vpermil2pd $4, $2, $1, $0, $0 \0a\09 vpermil2pd $4, $2, $3, $0, $0 \0a\09 vpermil2pd $4, $3, $1, $0, $0", "x,x,x,*m,i"(<4 x double> %a0, <4 x double> %a1, <4 x double> %a2, <4 x double> *%a3, i8 3)
  ret void
}

define void @test_vpermil2ps_128(<4 x float> %a0, <4 x float> %a1, <4 x float> %a2, <4 x float> *%a3) {
; GENERIC-LABEL: test_vpermil2ps_128:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpermil2ps $3, %xmm2, %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpermil2ps $3, %xmm2, (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpermil2ps $3, (%rdi), %xmm1, %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vpermil2ps_128:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vpermil2ps $3, %xmm2, %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpermil2ps $3, %xmm2, (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    vpermil2ps $3, (%rdi), %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vpermil2ps $4, $2, $1, $0, $0 \0a\09 vpermil2ps $4, $2, $3, $0, $0 \0a\09 vpermil2ps $4, $3, $1, $0, $0", "x,x,x,*m,i"(<4 x float> %a0, <4 x float> %a1, <4 x float> %a2, <4 x float> *%a3, i8 3)
  ret void
}

define void @test_vpermil2ps_256(<8 x float> %a0, <8 x float> %a1, <8 x float> %a2, <8 x float> *%a3) {
; GENERIC-LABEL: test_vpermil2ps_256:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpermil2ps $3, %ymm2, %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpermil2ps $3, %ymm2, (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; GENERIC-NEXT:    vpermil2ps $3, (%rdi), %ymm1, %ymm0, %ymm0 # sched: [8:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    vzeroupper # sched: [100:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vpermil2ps_256:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vpermil2ps $3, %ymm2, %ymm1, %ymm0, %ymm0
; BDVER-NEXT:    vpermil2ps $3, %ymm2, (%rdi), %ymm0, %ymm0
; BDVER-NEXT:    vpermil2ps $3, (%rdi), %ymm1, %ymm0, %ymm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    vzeroupper
; BDVER-NEXT:    retq
  call void asm sideeffect "vpermil2ps $4, $2, $1, $0, $0 \0a\09 vpermil2ps $4, $2, $3, $0, $0 \0a\09 vpermil2ps $4, $3, $1, $0, $0", "x,x,x,*m,i"(<8 x float> %a0, <8 x float> %a1, <8 x float> %a2, <8 x float> *%a3, i8 3)
  ret void
}

define void @test_vphaddbd(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphaddbd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphaddbd %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphaddbd (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vphaddbd:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vphaddbd %xmm0, %xmm0
; BDVER-NEXT:    vphaddbd (%rdi), %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vphaddbd $0, $0 \0a\09 vphaddbd $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphaddbq(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphaddbq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphaddbq %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphaddbq (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vphaddbq:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vphaddbq %xmm0, %xmm0
; BDVER-NEXT:    vphaddbq (%rdi), %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vphaddbq $0, $0 \0a\09 vphaddbq $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphaddbw(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphaddbw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphaddbw %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphaddbw (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vphaddbw:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vphaddbw %xmm0, %xmm0
; BDVER-NEXT:    vphaddbw (%rdi), %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vphaddbw $0, $0 \0a\09 vphaddbw $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphadddq(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphadddq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphadddq %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphadddq (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vphadddq:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vphadddq %xmm0, %xmm0
; BDVER-NEXT:    vphadddq (%rdi), %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vphadddq $0, $0 \0a\09 vphadddq $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphaddubd(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphaddubd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphaddubd %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphaddubd (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vphaddubd:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vphaddubd %xmm0, %xmm0
; BDVER-NEXT:    vphaddubd (%rdi), %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vphaddubd $0, $0 \0a\09 vphaddubd $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphaddubq(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphaddubq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphaddubq %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphaddubq (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vphaddubq:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vphaddubq %xmm0, %xmm0
; BDVER-NEXT:    vphaddubq (%rdi), %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vphaddubq $0, $0 \0a\09 vphaddubq $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphaddubw(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphaddubw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphaddubw %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphaddubw (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vphaddubw:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vphaddubw %xmm0, %xmm0
; BDVER-NEXT:    vphaddubw (%rdi), %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vphaddubw $0, $0 \0a\09 vphaddubw $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphaddudq(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphaddudq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphaddudq %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphaddudq (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vphaddudq:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vphaddudq %xmm0, %xmm0
; BDVER-NEXT:    vphaddudq (%rdi), %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vphaddudq $0, $0 \0a\09 vphaddudq $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphadduwd(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphadduwd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphadduwd %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphadduwd (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vphadduwd:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vphadduwd %xmm0, %xmm0
; BDVER-NEXT:    vphadduwd (%rdi), %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vphadduwd $0, $0 \0a\09 vphadduwd $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphadduwq(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphadduwq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphadduwq %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphadduwq (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vphadduwq:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vphadduwq %xmm0, %xmm0
; BDVER-NEXT:    vphadduwq (%rdi), %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vphadduwq $0, $0 \0a\09 vphadduwq $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphaddwd(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphaddwd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphaddwd %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphaddwd (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vphaddwd:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vphaddwd %xmm0, %xmm0
; BDVER-NEXT:    vphaddwd (%rdi), %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vphaddwd $0, $0 \0a\09 vphaddwd $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphaddwq(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphaddwq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphaddwq %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphaddwq (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vphaddwq:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vphaddwq %xmm0, %xmm0
; BDVER-NEXT:    vphaddwq (%rdi), %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vphaddwq $0, $0 \0a\09 vphaddwq $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphsubbw(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphsubbw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphsubbw %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphsubbw (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vphsubbw:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vphsubbw %xmm0, %xmm0
; BDVER-NEXT:    vphsubbw (%rdi), %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vphsubbw $0, $0 \0a\09 vphsubbw $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphsubdq(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphsubdq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphsubdq %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphsubdq (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vphsubdq:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vphsubdq %xmm0, %xmm0
; BDVER-NEXT:    vphsubdq (%rdi), %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vphsubdq $0, $0 \0a\09 vphsubdq $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphsubwd(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphsubwd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphsubwd %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphsubwd (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vphsubwd:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vphsubwd %xmm0, %xmm0
; BDVER-NEXT:    vphsubwd (%rdi), %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vphsubwd $0, $0 \0a\09 vphsubwd $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vpmacsdd(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpmacsdd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpmacsdd %xmm2, %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    vpmacsdd %xmm2, (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vpmacsdd:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vpmacsdd %xmm2, %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpmacsdd %xmm2, (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vpmacsdd $2, $1, $0, $0 \0a\09 vpmacsdd $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vpmacsdqh(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpmacsdqh:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpmacsdqh %xmm2, %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    vpmacsdqh %xmm2, (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vpmacsdqh:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vpmacsdqh %xmm2, %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpmacsdqh %xmm2, (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vpmacsdqh $2, $1, $0, $0 \0a\09 vpmacsdqh $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vpmacsdql(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpmacsdql:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpmacsdql %xmm2, %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    vpmacsdql %xmm2, (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vpmacsdql:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vpmacsdql %xmm2, %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpmacsdql %xmm2, (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vpmacsdql $2, $1, $0, $0 \0a\09 vpmacsdql $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vpmacssdd(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpmacssdd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpmacssdd %xmm2, %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    vpmacssdd %xmm2, (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vpmacssdd:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vpmacssdd %xmm2, %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpmacssdd %xmm2, (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vpmacssdd $2, $1, $0, $0 \0a\09 vpmacssdd $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vpmacssdqh(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpmacssdqh:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpmacssdqh %xmm2, %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    vpmacssdqh %xmm2, (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vpmacssdqh:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vpmacssdqh %xmm2, %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpmacssdqh %xmm2, (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vpmacssdqh $2, $1, $0, $0 \0a\09 vpmacssdqh $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vpmacssdql(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpmacssdql:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpmacssdql %xmm2, %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    vpmacssdql %xmm2, (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vpmacssdql:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vpmacssdql %xmm2, %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpmacssdql %xmm2, (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vpmacssdql $2, $1, $0, $0 \0a\09 vpmacssdql $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vpmacsswd(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpmacsswd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpmacsswd %xmm2, %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    vpmacsswd %xmm2, (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vpmacsswd:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vpmacsswd %xmm2, %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpmacsswd %xmm2, (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vpmacsswd $2, $1, $0, $0 \0a\09 vpmacsswd $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vpmacssww(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpmacssww:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpmacssww %xmm2, %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    vpmacssww %xmm2, (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vpmacssww:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vpmacssww %xmm2, %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpmacssww %xmm2, (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vpmacssww $2, $1, $0, $0 \0a\09 vpmacssww $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vpmacswd(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpmacswd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpmacswd %xmm2, %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    vpmacswd %xmm2, (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vpmacswd:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vpmacswd %xmm2, %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpmacswd %xmm2, (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vpmacswd $2, $1, $0, $0 \0a\09 vpmacswd $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vpmacsww(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpmacsww:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpmacsww %xmm2, %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    vpmacsww %xmm2, (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vpmacsww:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vpmacsww %xmm2, %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpmacsww %xmm2, (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vpmacsww $2, $1, $0, $0 \0a\09 vpmacsww $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vpmadcsswd(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpmadcsswd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpmadcsswd %xmm2, %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    vpmadcsswd %xmm2, (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vpmadcsswd:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vpmadcsswd %xmm2, %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpmadcsswd %xmm2, (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vpmadcsswd $2, $1, $0, $0 \0a\09 vpmadcsswd $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vpmadcswd(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpmadcswd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpmadcswd %xmm2, %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    vpmadcswd %xmm2, (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vpmadcswd:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vpmadcswd %xmm2, %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpmadcswd %xmm2, (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vpmadcswd $2, $1, $0, $0 \0a\09 vpmadcswd $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vpperm(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpperm:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpperm %xmm2, %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    vpperm (%rdi), %xmm1, %xmm0, %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    vpperm %xmm2, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vpperm:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vpperm %xmm2, %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpperm (%rdi), %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpperm %xmm2, (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vpperm $2, $1, $0, $0 \0A\09 vpperm $3, $1, $0, $0 \0A\09 vpperm $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vprot(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> *%a2) {
; GENERIC-LABEL: test_vprot:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vprotb %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vprotd %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vprotq %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vprotw %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vprotb (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vprotd (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vprotq (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vprotw (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vprotb %xmm0, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vprotd %xmm0, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vprotq %xmm0, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vprotw %xmm0, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vprotb $7, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vprotd $7, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vprotq $7, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vprotw $7, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vprotb $7, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vprotd $7, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vprotq $7, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vprotw $7, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vprot:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vprotb %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vprotd %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vprotq %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vprotw %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vprotb (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    vprotd (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    vprotq (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    vprotw (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    vprotb %xmm0, (%rdi), %xmm0
; BDVER-NEXT:    vprotd %xmm0, (%rdi), %xmm0
; BDVER-NEXT:    vprotq %xmm0, (%rdi), %xmm0
; BDVER-NEXT:    vprotw %xmm0, (%rdi), %xmm0
; BDVER-NEXT:    vprotb $7, %xmm0, %xmm0
; BDVER-NEXT:    vprotd $7, %xmm0, %xmm0
; BDVER-NEXT:    vprotq $7, %xmm0, %xmm0
; BDVER-NEXT:    vprotw $7, %xmm0, %xmm0
; BDVER-NEXT:    vprotb $7, (%rdi), %xmm0
; BDVER-NEXT:    vprotd $7, (%rdi), %xmm0
; BDVER-NEXT:    vprotq $7, (%rdi), %xmm0
; BDVER-NEXT:    vprotw $7, (%rdi), %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vprotb $1, $0, $0 \0A\09 vprotd $1, $0, $0 \0A\09 vprotq $1, $0, $0 \0A\09 vprotw $1, $0, $0 \0A\09 vprotb $2, $0, $0 \0A\09 vprotd $2, $0, $0 \0A\09 vprotq $2, $0, $0 \0A\09 vprotw $2, $0, $0 \0A\09 vprotb $0, $2, $0 \0A\09 vprotd $0, $2, $0 \0A\09 vprotq $0, $2, $0 \0A\09 vprotw $0, $2, $0 \0A\09 vprotb $3, $0, $0 \0A\09 vprotd $3, $0, $0 \0A\09 vprotq $3, $0, $0 \0A\09 vprotw $3, $0, $0 \0A\09 vprotb $3, $2, $0 \0A\09 vprotd $3, $2, $0 \0A\09 vprotq $3, $2, $0 \0A\09 vprotw $3, $2, $0", "x,x,*m,i"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> *%a2, i8 7)
  ret void
}

define void @test_vpsha(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> *%a2) {
; GENERIC-LABEL: test_vpsha:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpshab %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpshad %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpshaq %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpshaw %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpshab (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshad (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshaq (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshaw (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshab %xmm0, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshad %xmm0, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshaq %xmm0, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshaw %xmm0, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vpsha:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vpshab %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpshad %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpshaq %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpshaw %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpshab (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    vpshad (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    vpshaq (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    vpshaw (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    vpshab %xmm0, (%rdi), %xmm0
; BDVER-NEXT:    vpshad %xmm0, (%rdi), %xmm0
; BDVER-NEXT:    vpshaq %xmm0, (%rdi), %xmm0
; BDVER-NEXT:    vpshaw %xmm0, (%rdi), %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vpshab $1, $0, $0 \0A\09 vpshad $1, $0, $0 \0A\09 vpshaq $1, $0, $0 \0A\09 vpshaw $1, $0, $0 \0A\09 vpshab $2, $0, $0 \0A\09 vpshad $2, $0, $0 \0A\09 vpshaq $2, $0, $0 \0A\09 vpshaw $2, $0, $0 \0A\09 vpshab $0, $2, $0 \0A\09 vpshad $0, $2, $0 \0A\09 vpshaq $0, $2, $0 \0A\09 vpshaw $0, $2, $0", "x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> *%a2)
  ret void
}

define void @test_vpshl(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> *%a2) {
; GENERIC-LABEL: test_vpshl:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpshlb %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpshld %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpshlq %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpshlw %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpshlb (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshld (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshlq (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshlw (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshlb %xmm0, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshld %xmm0, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshlq %xmm0, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshlw %xmm0, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_vpshl:
; BDVER:       # %bb.0:
; BDVER-NEXT:    #APP
; BDVER-NEXT:    vpshlb %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpshld %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpshlq %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpshlw %xmm1, %xmm0, %xmm0
; BDVER-NEXT:    vpshlb (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    vpshld (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    vpshlq (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    vpshlw (%rdi), %xmm0, %xmm0
; BDVER-NEXT:    vpshlb %xmm0, (%rdi), %xmm0
; BDVER-NEXT:    vpshld %xmm0, (%rdi), %xmm0
; BDVER-NEXT:    vpshlq %xmm0, (%rdi), %xmm0
; BDVER-NEXT:    vpshlw %xmm0, (%rdi), %xmm0
; BDVER-NEXT:    #NO_APP
; BDVER-NEXT:    retq
  call void asm sideeffect "vpshlb $1, $0, $0 \0A\09 vpshld $1, $0, $0 \0A\09 vpshlq $1, $0, $0 \0A\09 vpshlw $1, $0, $0 \0A\09 vpshlb $2, $0, $0 \0A\09 vpshld $2, $0, $0 \0A\09 vpshlq $2, $0, $0 \0A\09 vpshlw $2, $0, $0 \0A\09 vpshlb $0, $2, $0 \0A\09 vpshld $0, $2, $0 \0A\09 vpshlq $0, $2, $0 \0A\09 vpshlw $0, $2, $0", "x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> *%a2)
  ret void
}
