// Copyright 2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may not
// use this file except in compliance with the License. A copy of the
// License is located at
//
// http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
// either express or implied. See the License for the specific language governing
// permissions and limitations under the License.

// Code generated by mockery v1.0.0
package mocks

import (
	contracts "github.com/aws/amazon-ssm-agent/agent/contracts"
	iohandler "github.com/aws/amazon-ssm-agent/agent/framework/processor/executer/iohandler"
	log "github.com/aws/amazon-ssm-agent/agent/log"
	sessioncontracts "github.com/aws/amazon-ssm-agent/agent/session/contracts"
	datachannel "github.com/aws/amazon-ssm-agent/agent/session/datachannel"
	task "github.com/aws/amazon-ssm-agent/agent/task"
	mock "github.com/stretchr/testify/mock"
)

// ISessionPlugin is an autogenerated mock type for the ISessionPlugin type
type ISessionPlugin struct {
	mock.Mock
}

// Execute provides a mock function with given fields: _a0, config, cancelFlag, output, dataChannel
func (_m *ISessionPlugin) Execute(config contracts.Configuration, cancelFlag task.CancelFlag, output iohandler.IOHandler, dataChannel datachannel.IDataChannel) {
	_m.Called(config, cancelFlag, output, dataChannel)
}

// InputStreamMessageHandler provides a mock function with given fields: _a0, streamDataMessage
func (_m *ISessionPlugin) InputStreamMessageHandler(_a0 log.T, streamDataMessage sessioncontracts.AgentMessage) error {
	ret := _m.Called(_a0, streamDataMessage)

	var r0 error
	if rf, ok := ret.Get(0).(func(log.T, sessioncontracts.AgentMessage) error); ok {
		r0 = rf(_a0, streamDataMessage)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// RequireHandshake provides a mock function with given fields:
func (_m *ISessionPlugin) RequireHandshake() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// GetPluginParameters provides a mock function with given fields:
func (_m *ISessionPlugin) GetPluginParameters(parameters interface{}) interface{} {
	ret := _m.Called(parameters)

	var r0 interface{}
	if rf, ok := ret.Get(0).(func(interface{}) interface{}); ok {
		r0 = rf(parameters)
	} else {
		r0 = ret.Get(0)
	}

	return r0
}
