package botservice

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/botservice/mgmt/2018-07-12/botservice"

// Bot bot resource definition
type Bot struct {
	autorest.Response `json:"-"`
	// Properties - The set of properties specific to bot resource
	Properties *BotProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Specifies the name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Specifies the type of the resource.
	Type *string `json:"type,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
	// Sku - Gets or sets the SKU of the resource.
	Sku *Sku `json:"sku,omitempty"`
	// Kind - Required. Gets or sets the Kind of the resource. Possible values include: 'KindSdk', 'KindDesigner', 'KindBot', 'KindFunction'
	Kind Kind `json:"kind,omitempty"`
	// Etag - Entity Tag
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for Bot.
func (b Bot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if b.Properties != nil {
		objectMap["properties"] = b.Properties
	}
	if b.Location != nil {
		objectMap["location"] = b.Location
	}
	if b.Tags != nil {
		objectMap["tags"] = b.Tags
	}
	if b.Sku != nil {
		objectMap["sku"] = b.Sku
	}
	if b.Kind != "" {
		objectMap["kind"] = b.Kind
	}
	if b.Etag != nil {
		objectMap["etag"] = b.Etag
	}
	return json.Marshal(objectMap)
}

// BotChannel bot channel resource definition
type BotChannel struct {
	autorest.Response `json:"-"`
	// Properties - The set of properties specific to bot channel resource
	Properties BasicChannel `json:"properties,omitempty"`
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Specifies the name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Specifies the type of the resource.
	Type *string `json:"type,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
	// Sku - Gets or sets the SKU of the resource.
	Sku *Sku `json:"sku,omitempty"`
	// Kind - Required. Gets or sets the Kind of the resource. Possible values include: 'KindSdk', 'KindDesigner', 'KindBot', 'KindFunction'
	Kind Kind `json:"kind,omitempty"`
	// Etag - Entity Tag
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for BotChannel.
func (bc BotChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = bc.Properties
	if bc.Location != nil {
		objectMap["location"] = bc.Location
	}
	if bc.Tags != nil {
		objectMap["tags"] = bc.Tags
	}
	if bc.Sku != nil {
		objectMap["sku"] = bc.Sku
	}
	if bc.Kind != "" {
		objectMap["kind"] = bc.Kind
	}
	if bc.Etag != nil {
		objectMap["etag"] = bc.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BotChannel struct.
func (bc *BotChannel) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicChannel(*v)
				if err != nil {
					return err
				}
				bc.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bc.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				bc.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bc.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				bc.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				bc.Sku = &sku
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				bc.Kind = kind
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				bc.Etag = &etag
			}
		}
	}

	return nil
}

// BotProperties the parameters to provide for the Bot.
type BotProperties struct {
	// DisplayName - The Name of the bot
	DisplayName *string `json:"displayName,omitempty"`
	// Description - The description of the bot
	Description *string `json:"description,omitempty"`
	// IconURL - The Icon Url of the bot
	IconURL *string `json:"iconUrl,omitempty"`
	// Endpoint - The bot's endpoint
	Endpoint *string `json:"endpoint,omitempty"`
	// EndpointVersion - READ-ONLY; The bot's endpoint version
	EndpointVersion *string `json:"endpointVersion,omitempty"`
	// MsaAppID - Microsoft App Id for the bot
	MsaAppID *string `json:"msaAppId,omitempty"`
	// ConfiguredChannels - READ-ONLY; Collection of channels for which the bot is configured
	ConfiguredChannels *[]string `json:"configuredChannels,omitempty"`
	// EnabledChannels - READ-ONLY; Collection of channels for which the bot is enabled
	EnabledChannels *[]string `json:"enabledChannels,omitempty"`
	// DeveloperAppInsightKey - The Application Insights key
	DeveloperAppInsightKey *string `json:"developerAppInsightKey,omitempty"`
	// DeveloperAppInsightsAPIKey - The Application Insights Api Key
	DeveloperAppInsightsAPIKey *string `json:"developerAppInsightsApiKey,omitempty"`
	// DeveloperAppInsightsApplicationID - The Application Insights App Id
	DeveloperAppInsightsApplicationID *string `json:"developerAppInsightsApplicationId,omitempty"`
	// LuisAppIds - Collection of LUIS App Ids
	LuisAppIds *[]string `json:"luisAppIds,omitempty"`
	// LuisKey - The LUIS Key
	LuisKey *string `json:"luisKey,omitempty"`
}

// MarshalJSON is the custom marshaler for BotProperties.
func (bp BotProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bp.DisplayName != nil {
		objectMap["displayName"] = bp.DisplayName
	}
	if bp.Description != nil {
		objectMap["description"] = bp.Description
	}
	if bp.IconURL != nil {
		objectMap["iconUrl"] = bp.IconURL
	}
	if bp.Endpoint != nil {
		objectMap["endpoint"] = bp.Endpoint
	}
	if bp.MsaAppID != nil {
		objectMap["msaAppId"] = bp.MsaAppID
	}
	if bp.DeveloperAppInsightKey != nil {
		objectMap["developerAppInsightKey"] = bp.DeveloperAppInsightKey
	}
	if bp.DeveloperAppInsightsAPIKey != nil {
		objectMap["developerAppInsightsApiKey"] = bp.DeveloperAppInsightsAPIKey
	}
	if bp.DeveloperAppInsightsApplicationID != nil {
		objectMap["developerAppInsightsApplicationId"] = bp.DeveloperAppInsightsApplicationID
	}
	if bp.LuisAppIds != nil {
		objectMap["luisAppIds"] = bp.LuisAppIds
	}
	if bp.LuisKey != nil {
		objectMap["luisKey"] = bp.LuisKey
	}
	return json.Marshal(objectMap)
}

// BotResponseList the list of  bot service operation response.
type BotResponseList struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of bot service resources.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - READ-ONLY; Gets the list of bot service results and their properties.
	Value *[]Bot `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for BotResponseList.
func (brl BotResponseList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if brl.NextLink != nil {
		objectMap["nextLink"] = brl.NextLink
	}
	return json.Marshal(objectMap)
}

// BotResponseListIterator provides access to a complete listing of Bot values.
type BotResponseListIterator struct {
	i    int
	page BotResponseListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BotResponseListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BotResponseListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BotResponseListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BotResponseListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BotResponseListIterator) Response() BotResponseList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BotResponseListIterator) Value() Bot {
	if !iter.page.NotDone() {
		return Bot{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BotResponseListIterator type.
func NewBotResponseListIterator(page BotResponseListPage) BotResponseListIterator {
	return BotResponseListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (brl BotResponseList) IsEmpty() bool {
	return brl.Value == nil || len(*brl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (brl BotResponseList) hasNextLink() bool {
	return brl.NextLink != nil && len(*brl.NextLink) != 0
}

// botResponseListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (brl BotResponseList) botResponseListPreparer(ctx context.Context) (*http.Request, error) {
	if !brl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(brl.NextLink)))
}

// BotResponseListPage contains a page of Bot values.
type BotResponseListPage struct {
	fn  func(context.Context, BotResponseList) (BotResponseList, error)
	brl BotResponseList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BotResponseListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BotResponseListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.brl)
		if err != nil {
			return err
		}
		page.brl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BotResponseListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BotResponseListPage) NotDone() bool {
	return !page.brl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BotResponseListPage) Response() BotResponseList {
	return page.brl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BotResponseListPage) Values() []Bot {
	if page.brl.IsEmpty() {
		return nil
	}
	return *page.brl.Value
}

// Creates a new instance of the BotResponseListPage type.
func NewBotResponseListPage(getNextPage func(context.Context, BotResponseList) (BotResponseList, error)) BotResponseListPage {
	return BotResponseListPage{fn: getNextPage}
}

// BasicChannel channel definition
type BasicChannel interface {
	AsFacebookChannel() (*FacebookChannel, bool)
	AsEmailChannel() (*EmailChannel, bool)
	AsMsTeamsChannel() (*MsTeamsChannel, bool)
	AsSkypeChannel() (*SkypeChannel, bool)
	AsKikChannel() (*KikChannel, bool)
	AsWebChatChannel() (*WebChatChannel, bool)
	AsDirectLineChannel() (*DirectLineChannel, bool)
	AsTelegramChannel() (*TelegramChannel, bool)
	AsSmsChannel() (*SmsChannel, bool)
	AsSlackChannel() (*SlackChannel, bool)
	AsChannel() (*Channel, bool)
}

// Channel channel definition
type Channel struct {
	// ChannelName - Possible values include: 'ChannelNameChannel', 'ChannelNameFacebookChannel1', 'ChannelNameEmailChannel1', 'ChannelNameMsTeamsChannel1', 'ChannelNameSkypeChannel1', 'ChannelNameKikChannel1', 'ChannelNameWebChatChannel1', 'ChannelNameDirectLineChannel1', 'ChannelNameTelegramChannel1', 'ChannelNameSmsChannel1', 'ChannelNameSlackChannel1'
	ChannelName ChannelNameBasicChannel `json:"channelName,omitempty"`
}

func unmarshalBasicChannel(body []byte) (BasicChannel, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["channelName"] {
	case string(ChannelNameFacebookChannel1):
		var fc FacebookChannel
		err := json.Unmarshal(body, &fc)
		return fc, err
	case string(ChannelNameEmailChannel1):
		var ec EmailChannel
		err := json.Unmarshal(body, &ec)
		return ec, err
	case string(ChannelNameMsTeamsChannel1):
		var mtc MsTeamsChannel
		err := json.Unmarshal(body, &mtc)
		return mtc, err
	case string(ChannelNameSkypeChannel1):
		var sc SkypeChannel
		err := json.Unmarshal(body, &sc)
		return sc, err
	case string(ChannelNameKikChannel1):
		var kc KikChannel
		err := json.Unmarshal(body, &kc)
		return kc, err
	case string(ChannelNameWebChatChannel1):
		var wcc WebChatChannel
		err := json.Unmarshal(body, &wcc)
		return wcc, err
	case string(ChannelNameDirectLineChannel1):
		var dlc DirectLineChannel
		err := json.Unmarshal(body, &dlc)
		return dlc, err
	case string(ChannelNameTelegramChannel1):
		var tc TelegramChannel
		err := json.Unmarshal(body, &tc)
		return tc, err
	case string(ChannelNameSmsChannel1):
		var sc SmsChannel
		err := json.Unmarshal(body, &sc)
		return sc, err
	case string(ChannelNameSlackChannel1):
		var sc SlackChannel
		err := json.Unmarshal(body, &sc)
		return sc, err
	default:
		var c Channel
		err := json.Unmarshal(body, &c)
		return c, err
	}
}
func unmarshalBasicChannelArray(body []byte) ([]BasicChannel, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cArray := make([]BasicChannel, len(rawMessages))

	for index, rawMessage := range rawMessages {
		c, err := unmarshalBasicChannel(*rawMessage)
		if err != nil {
			return nil, err
		}
		cArray[index] = c
	}
	return cArray, nil
}

// MarshalJSON is the custom marshaler for Channel.
func (c Channel) MarshalJSON() ([]byte, error) {
	c.ChannelName = ChannelNameChannel
	objectMap := make(map[string]interface{})
	if c.ChannelName != "" {
		objectMap["channelName"] = c.ChannelName
	}
	return json.Marshal(objectMap)
}

// AsFacebookChannel is the BasicChannel implementation for Channel.
func (c Channel) AsFacebookChannel() (*FacebookChannel, bool) {
	return nil, false
}

// AsEmailChannel is the BasicChannel implementation for Channel.
func (c Channel) AsEmailChannel() (*EmailChannel, bool) {
	return nil, false
}

// AsMsTeamsChannel is the BasicChannel implementation for Channel.
func (c Channel) AsMsTeamsChannel() (*MsTeamsChannel, bool) {
	return nil, false
}

// AsSkypeChannel is the BasicChannel implementation for Channel.
func (c Channel) AsSkypeChannel() (*SkypeChannel, bool) {
	return nil, false
}

// AsKikChannel is the BasicChannel implementation for Channel.
func (c Channel) AsKikChannel() (*KikChannel, bool) {
	return nil, false
}

// AsWebChatChannel is the BasicChannel implementation for Channel.
func (c Channel) AsWebChatChannel() (*WebChatChannel, bool) {
	return nil, false
}

// AsDirectLineChannel is the BasicChannel implementation for Channel.
func (c Channel) AsDirectLineChannel() (*DirectLineChannel, bool) {
	return nil, false
}

// AsTelegramChannel is the BasicChannel implementation for Channel.
func (c Channel) AsTelegramChannel() (*TelegramChannel, bool) {
	return nil, false
}

// AsSmsChannel is the BasicChannel implementation for Channel.
func (c Channel) AsSmsChannel() (*SmsChannel, bool) {
	return nil, false
}

// AsSlackChannel is the BasicChannel implementation for Channel.
func (c Channel) AsSlackChannel() (*SlackChannel, bool) {
	return nil, false
}

// AsChannel is the BasicChannel implementation for Channel.
func (c Channel) AsChannel() (*Channel, bool) {
	return &c, true
}

// AsBasicChannel is the BasicChannel implementation for Channel.
func (c Channel) AsBasicChannel() (BasicChannel, bool) {
	return &c, true
}

// ChannelResponseList the list of bot service channel operation response.
type ChannelResponseList struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of bot service channel resources.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - READ-ONLY; Gets the list of bot service channel results and their properties.
	Value *[]BotChannel `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for ChannelResponseList.
func (crl ChannelResponseList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if crl.NextLink != nil {
		objectMap["nextLink"] = crl.NextLink
	}
	return json.Marshal(objectMap)
}

// ChannelResponseListIterator provides access to a complete listing of BotChannel values.
type ChannelResponseListIterator struct {
	i    int
	page ChannelResponseListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ChannelResponseListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ChannelResponseListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ChannelResponseListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ChannelResponseListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ChannelResponseListIterator) Response() ChannelResponseList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ChannelResponseListIterator) Value() BotChannel {
	if !iter.page.NotDone() {
		return BotChannel{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ChannelResponseListIterator type.
func NewChannelResponseListIterator(page ChannelResponseListPage) ChannelResponseListIterator {
	return ChannelResponseListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (crl ChannelResponseList) IsEmpty() bool {
	return crl.Value == nil || len(*crl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (crl ChannelResponseList) hasNextLink() bool {
	return crl.NextLink != nil && len(*crl.NextLink) != 0
}

// channelResponseListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (crl ChannelResponseList) channelResponseListPreparer(ctx context.Context) (*http.Request, error) {
	if !crl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(crl.NextLink)))
}

// ChannelResponseListPage contains a page of BotChannel values.
type ChannelResponseListPage struct {
	fn  func(context.Context, ChannelResponseList) (ChannelResponseList, error)
	crl ChannelResponseList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ChannelResponseListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ChannelResponseListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.crl)
		if err != nil {
			return err
		}
		page.crl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ChannelResponseListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ChannelResponseListPage) NotDone() bool {
	return !page.crl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ChannelResponseListPage) Response() ChannelResponseList {
	return page.crl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ChannelResponseListPage) Values() []BotChannel {
	if page.crl.IsEmpty() {
		return nil
	}
	return *page.crl.Value
}

// Creates a new instance of the ChannelResponseListPage type.
func NewChannelResponseListPage(getNextPage func(context.Context, ChannelResponseList) (ChannelResponseList, error)) ChannelResponseListPage {
	return ChannelResponseListPage{fn: getNextPage}
}

// CheckNameAvailabilityRequestBody the request body for a request to Bot Service Management to check
// availability of a bot name.
type CheckNameAvailabilityRequestBody struct {
	// Name - the name of the bot for which availability needs to be checked.
	Name *string `json:"name,omitempty"`
	// Type - the type of the bot for which availability needs to be checked
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResponseBody the response body returned for a request to Bot Service Management to
// check availability of a bot name.
type CheckNameAvailabilityResponseBody struct {
	autorest.Response `json:"-"`
	// Valid - indicates if the bot name is valid.
	Valid *bool `json:"valid,omitempty"`
	// Message - additional message from the bot management api showing why a bot name is not available
	Message *string `json:"message,omitempty"`
}

// ConnectionItemName the display name of a connection Item Setting registered with the Bot
type ConnectionItemName struct {
	// Name - READ-ONLY; Connection Item name that has been added in the API
	Name *string `json:"name,omitempty"`
}

// ConnectionSetting bot channel resource definition
type ConnectionSetting struct {
	autorest.Response `json:"-"`
	// Properties - The set of properties specific to bot channel resource
	Properties *ConnectionSettingProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Specifies the name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Specifies the type of the resource.
	Type *string `json:"type,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
	// Sku - Gets or sets the SKU of the resource.
	Sku *Sku `json:"sku,omitempty"`
	// Kind - Required. Gets or sets the Kind of the resource. Possible values include: 'KindSdk', 'KindDesigner', 'KindBot', 'KindFunction'
	Kind Kind `json:"kind,omitempty"`
	// Etag - Entity Tag
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectionSetting.
func (cs ConnectionSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cs.Properties != nil {
		objectMap["properties"] = cs.Properties
	}
	if cs.Location != nil {
		objectMap["location"] = cs.Location
	}
	if cs.Tags != nil {
		objectMap["tags"] = cs.Tags
	}
	if cs.Sku != nil {
		objectMap["sku"] = cs.Sku
	}
	if cs.Kind != "" {
		objectMap["kind"] = cs.Kind
	}
	if cs.Etag != nil {
		objectMap["etag"] = cs.Etag
	}
	return json.Marshal(objectMap)
}

// ConnectionSettingParameter extra Parameter in a Connection Setting Properties to indicate service provider
// specific properties
type ConnectionSettingParameter struct {
	// Key - Key for the Connection Setting Parameter.
	Key *string `json:"key,omitempty"`
	// Value - Value associated with the Connection Setting Parameter.
	Value *string `json:"value,omitempty"`
}

// ConnectionSettingProperties properties for a Connection Setting Item
type ConnectionSettingProperties struct {
	// ClientID - Client Id associated with the Connection Setting.
	ClientID *string `json:"clientId,omitempty"`
	// SettingID - READ-ONLY; Setting Id set by the service for the Connection Setting.
	SettingID *string `json:"settingId,omitempty"`
	// ClientSecret - Client Secret associated with the Connection Setting
	ClientSecret *string `json:"clientSecret,omitempty"`
	// Scopes - Scopes associated with the Connection Setting
	Scopes *string `json:"scopes,omitempty"`
	// ServiceProviderID - Service Provider Id associated with the Connection Setting
	ServiceProviderID *string `json:"serviceProviderId,omitempty"`
	// ServiceProviderDisplayName - Service Provider Display Name associated with the Connection Setting
	ServiceProviderDisplayName *string `json:"serviceProviderDisplayName,omitempty"`
	// Parameters - Service Provider Parameters associated with the Connection Setting
	Parameters *[]ConnectionSettingParameter `json:"parameters,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectionSettingProperties.
func (csp ConnectionSettingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if csp.ClientID != nil {
		objectMap["clientId"] = csp.ClientID
	}
	if csp.ClientSecret != nil {
		objectMap["clientSecret"] = csp.ClientSecret
	}
	if csp.Scopes != nil {
		objectMap["scopes"] = csp.Scopes
	}
	if csp.ServiceProviderID != nil {
		objectMap["serviceProviderId"] = csp.ServiceProviderID
	}
	if csp.ServiceProviderDisplayName != nil {
		objectMap["serviceProviderDisplayName"] = csp.ServiceProviderDisplayName
	}
	if csp.Parameters != nil {
		objectMap["parameters"] = csp.Parameters
	}
	return json.Marshal(objectMap)
}

// ConnectionSettingResponseList the list of bot service connection settings response.
type ConnectionSettingResponseList struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of bot service connection setting resources.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - READ-ONLY; Gets the list of bot service connection settings and their properties.
	Value *[]ConnectionSetting `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectionSettingResponseList.
func (csrl ConnectionSettingResponseList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if csrl.NextLink != nil {
		objectMap["nextLink"] = csrl.NextLink
	}
	return json.Marshal(objectMap)
}

// ConnectionSettingResponseListIterator provides access to a complete listing of ConnectionSetting values.
type ConnectionSettingResponseListIterator struct {
	i    int
	page ConnectionSettingResponseListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ConnectionSettingResponseListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectionSettingResponseListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ConnectionSettingResponseListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ConnectionSettingResponseListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ConnectionSettingResponseListIterator) Response() ConnectionSettingResponseList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ConnectionSettingResponseListIterator) Value() ConnectionSetting {
	if !iter.page.NotDone() {
		return ConnectionSetting{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ConnectionSettingResponseListIterator type.
func NewConnectionSettingResponseListIterator(page ConnectionSettingResponseListPage) ConnectionSettingResponseListIterator {
	return ConnectionSettingResponseListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (csrl ConnectionSettingResponseList) IsEmpty() bool {
	return csrl.Value == nil || len(*csrl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (csrl ConnectionSettingResponseList) hasNextLink() bool {
	return csrl.NextLink != nil && len(*csrl.NextLink) != 0
}

// connectionSettingResponseListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (csrl ConnectionSettingResponseList) connectionSettingResponseListPreparer(ctx context.Context) (*http.Request, error) {
	if !csrl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(csrl.NextLink)))
}

// ConnectionSettingResponseListPage contains a page of ConnectionSetting values.
type ConnectionSettingResponseListPage struct {
	fn   func(context.Context, ConnectionSettingResponseList) (ConnectionSettingResponseList, error)
	csrl ConnectionSettingResponseList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ConnectionSettingResponseListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectionSettingResponseListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.csrl)
		if err != nil {
			return err
		}
		page.csrl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ConnectionSettingResponseListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ConnectionSettingResponseListPage) NotDone() bool {
	return !page.csrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ConnectionSettingResponseListPage) Response() ConnectionSettingResponseList {
	return page.csrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ConnectionSettingResponseListPage) Values() []ConnectionSetting {
	if page.csrl.IsEmpty() {
		return nil
	}
	return *page.csrl.Value
}

// Creates a new instance of the ConnectionSettingResponseListPage type.
func NewConnectionSettingResponseListPage(getNextPage func(context.Context, ConnectionSettingResponseList) (ConnectionSettingResponseList, error)) ConnectionSettingResponseListPage {
	return ConnectionSettingResponseListPage{fn: getNextPage}
}

// DirectLineChannel direct Line channel definition
type DirectLineChannel struct {
	// Properties - The set of properties specific to Direct Line channel resource
	Properties *DirectLineChannelProperties `json:"properties,omitempty"`
	// ChannelName - Possible values include: 'ChannelNameChannel', 'ChannelNameFacebookChannel1', 'ChannelNameEmailChannel1', 'ChannelNameMsTeamsChannel1', 'ChannelNameSkypeChannel1', 'ChannelNameKikChannel1', 'ChannelNameWebChatChannel1', 'ChannelNameDirectLineChannel1', 'ChannelNameTelegramChannel1', 'ChannelNameSmsChannel1', 'ChannelNameSlackChannel1'
	ChannelName ChannelNameBasicChannel `json:"channelName,omitempty"`
}

// MarshalJSON is the custom marshaler for DirectLineChannel.
func (dlc DirectLineChannel) MarshalJSON() ([]byte, error) {
	dlc.ChannelName = ChannelNameDirectLineChannel1
	objectMap := make(map[string]interface{})
	if dlc.Properties != nil {
		objectMap["properties"] = dlc.Properties
	}
	if dlc.ChannelName != "" {
		objectMap["channelName"] = dlc.ChannelName
	}
	return json.Marshal(objectMap)
}

// AsFacebookChannel is the BasicChannel implementation for DirectLineChannel.
func (dlc DirectLineChannel) AsFacebookChannel() (*FacebookChannel, bool) {
	return nil, false
}

// AsEmailChannel is the BasicChannel implementation for DirectLineChannel.
func (dlc DirectLineChannel) AsEmailChannel() (*EmailChannel, bool) {
	return nil, false
}

// AsMsTeamsChannel is the BasicChannel implementation for DirectLineChannel.
func (dlc DirectLineChannel) AsMsTeamsChannel() (*MsTeamsChannel, bool) {
	return nil, false
}

// AsSkypeChannel is the BasicChannel implementation for DirectLineChannel.
func (dlc DirectLineChannel) AsSkypeChannel() (*SkypeChannel, bool) {
	return nil, false
}

// AsKikChannel is the BasicChannel implementation for DirectLineChannel.
func (dlc DirectLineChannel) AsKikChannel() (*KikChannel, bool) {
	return nil, false
}

// AsWebChatChannel is the BasicChannel implementation for DirectLineChannel.
func (dlc DirectLineChannel) AsWebChatChannel() (*WebChatChannel, bool) {
	return nil, false
}

// AsDirectLineChannel is the BasicChannel implementation for DirectLineChannel.
func (dlc DirectLineChannel) AsDirectLineChannel() (*DirectLineChannel, bool) {
	return &dlc, true
}

// AsTelegramChannel is the BasicChannel implementation for DirectLineChannel.
func (dlc DirectLineChannel) AsTelegramChannel() (*TelegramChannel, bool) {
	return nil, false
}

// AsSmsChannel is the BasicChannel implementation for DirectLineChannel.
func (dlc DirectLineChannel) AsSmsChannel() (*SmsChannel, bool) {
	return nil, false
}

// AsSlackChannel is the BasicChannel implementation for DirectLineChannel.
func (dlc DirectLineChannel) AsSlackChannel() (*SlackChannel, bool) {
	return nil, false
}

// AsChannel is the BasicChannel implementation for DirectLineChannel.
func (dlc DirectLineChannel) AsChannel() (*Channel, bool) {
	return nil, false
}

// AsBasicChannel is the BasicChannel implementation for DirectLineChannel.
func (dlc DirectLineChannel) AsBasicChannel() (BasicChannel, bool) {
	return &dlc, true
}

// DirectLineChannelProperties the parameters to provide for the Direct Line channel.
type DirectLineChannelProperties struct {
	// Sites - The list of Direct Line sites
	Sites *[]DirectLineSite `json:"sites,omitempty"`
}

// DirectLineSite a site for the Direct Line channel
type DirectLineSite struct {
	// SiteID - READ-ONLY; Site Id
	SiteID *string `json:"siteId,omitempty"`
	// SiteName - Site name
	SiteName *string `json:"siteName,omitempty"`
	// Key - READ-ONLY; Primary key. Value only returned through POST to the action Channel List API, otherwise empty.
	Key *string `json:"key,omitempty"`
	// Key2 - READ-ONLY; Secondary key. Value only returned through POST to the action Channel List API, otherwise empty.
	Key2 *string `json:"key2,omitempty"`
	// IsEnabled - Whether this site is enabled for DirectLine channel.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// IsV1Enabled - Whether this site is enabled for Bot Framework V1 protocol.
	IsV1Enabled *bool `json:"isV1Enabled,omitempty"`
	// IsV3Enabled - Whether this site is enabled for Bot Framework V1 protocol.
	IsV3Enabled *bool `json:"isV3Enabled,omitempty"`
	// IsSecureSiteEnabled - Whether this site is enabled for authentication with Bot Framework.
	IsSecureSiteEnabled *bool `json:"isSecureSiteEnabled,omitempty"`
	// TrustedOrigins - List of Trusted Origin URLs for this site. This field is applicable only if isSecureSiteEnabled is True.
	TrustedOrigins *[]string `json:"trustedOrigins,omitempty"`
}

// MarshalJSON is the custom marshaler for DirectLineSite.
func (dls DirectLineSite) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dls.SiteName != nil {
		objectMap["siteName"] = dls.SiteName
	}
	if dls.IsEnabled != nil {
		objectMap["isEnabled"] = dls.IsEnabled
	}
	if dls.IsV1Enabled != nil {
		objectMap["isV1Enabled"] = dls.IsV1Enabled
	}
	if dls.IsV3Enabled != nil {
		objectMap["isV3Enabled"] = dls.IsV3Enabled
	}
	if dls.IsSecureSiteEnabled != nil {
		objectMap["isSecureSiteEnabled"] = dls.IsSecureSiteEnabled
	}
	if dls.TrustedOrigins != nil {
		objectMap["trustedOrigins"] = dls.TrustedOrigins
	}
	return json.Marshal(objectMap)
}

// EmailChannel email channel definition
type EmailChannel struct {
	// Properties - The set of properties specific to email channel resource
	Properties *EmailChannelProperties `json:"properties,omitempty"`
	// ChannelName - Possible values include: 'ChannelNameChannel', 'ChannelNameFacebookChannel1', 'ChannelNameEmailChannel1', 'ChannelNameMsTeamsChannel1', 'ChannelNameSkypeChannel1', 'ChannelNameKikChannel1', 'ChannelNameWebChatChannel1', 'ChannelNameDirectLineChannel1', 'ChannelNameTelegramChannel1', 'ChannelNameSmsChannel1', 'ChannelNameSlackChannel1'
	ChannelName ChannelNameBasicChannel `json:"channelName,omitempty"`
}

// MarshalJSON is the custom marshaler for EmailChannel.
func (ec EmailChannel) MarshalJSON() ([]byte, error) {
	ec.ChannelName = ChannelNameEmailChannel1
	objectMap := make(map[string]interface{})
	if ec.Properties != nil {
		objectMap["properties"] = ec.Properties
	}
	if ec.ChannelName != "" {
		objectMap["channelName"] = ec.ChannelName
	}
	return json.Marshal(objectMap)
}

// AsFacebookChannel is the BasicChannel implementation for EmailChannel.
func (ec EmailChannel) AsFacebookChannel() (*FacebookChannel, bool) {
	return nil, false
}

// AsEmailChannel is the BasicChannel implementation for EmailChannel.
func (ec EmailChannel) AsEmailChannel() (*EmailChannel, bool) {
	return &ec, true
}

// AsMsTeamsChannel is the BasicChannel implementation for EmailChannel.
func (ec EmailChannel) AsMsTeamsChannel() (*MsTeamsChannel, bool) {
	return nil, false
}

// AsSkypeChannel is the BasicChannel implementation for EmailChannel.
func (ec EmailChannel) AsSkypeChannel() (*SkypeChannel, bool) {
	return nil, false
}

// AsKikChannel is the BasicChannel implementation for EmailChannel.
func (ec EmailChannel) AsKikChannel() (*KikChannel, bool) {
	return nil, false
}

// AsWebChatChannel is the BasicChannel implementation for EmailChannel.
func (ec EmailChannel) AsWebChatChannel() (*WebChatChannel, bool) {
	return nil, false
}

// AsDirectLineChannel is the BasicChannel implementation for EmailChannel.
func (ec EmailChannel) AsDirectLineChannel() (*DirectLineChannel, bool) {
	return nil, false
}

// AsTelegramChannel is the BasicChannel implementation for EmailChannel.
func (ec EmailChannel) AsTelegramChannel() (*TelegramChannel, bool) {
	return nil, false
}

// AsSmsChannel is the BasicChannel implementation for EmailChannel.
func (ec EmailChannel) AsSmsChannel() (*SmsChannel, bool) {
	return nil, false
}

// AsSlackChannel is the BasicChannel implementation for EmailChannel.
func (ec EmailChannel) AsSlackChannel() (*SlackChannel, bool) {
	return nil, false
}

// AsChannel is the BasicChannel implementation for EmailChannel.
func (ec EmailChannel) AsChannel() (*Channel, bool) {
	return nil, false
}

// AsBasicChannel is the BasicChannel implementation for EmailChannel.
func (ec EmailChannel) AsBasicChannel() (BasicChannel, bool) {
	return &ec, true
}

// EmailChannelProperties the parameters to provide for the Email channel.
type EmailChannelProperties struct {
	// EmailAddress - The email address
	EmailAddress *string `json:"emailAddress,omitempty"`
	// Password - The password for the email address. Value only returned through POST to the action Channel List API, otherwise empty.
	Password *string `json:"password,omitempty"`
	// IsEnabled - Whether this channel is enabled for the bot
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// EnterpriseChannel enterprise Channel resource definition
type EnterpriseChannel struct {
	autorest.Response `json:"-"`
	// Properties - The set of properties specific to an Enterprise Channel resource.
	Properties *EnterpriseChannelProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Specifies the name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Specifies the type of the resource.
	Type *string `json:"type,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
	// Sku - Gets or sets the SKU of the resource.
	Sku *Sku `json:"sku,omitempty"`
	// Kind - Required. Gets or sets the Kind of the resource. Possible values include: 'KindSdk', 'KindDesigner', 'KindBot', 'KindFunction'
	Kind Kind `json:"kind,omitempty"`
	// Etag - Entity Tag
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for EnterpriseChannel.
func (ec EnterpriseChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ec.Properties != nil {
		objectMap["properties"] = ec.Properties
	}
	if ec.Location != nil {
		objectMap["location"] = ec.Location
	}
	if ec.Tags != nil {
		objectMap["tags"] = ec.Tags
	}
	if ec.Sku != nil {
		objectMap["sku"] = ec.Sku
	}
	if ec.Kind != "" {
		objectMap["kind"] = ec.Kind
	}
	if ec.Etag != nil {
		objectMap["etag"] = ec.Etag
	}
	return json.Marshal(objectMap)
}

// EnterpriseChannelCheckNameAvailabilityRequest a request to Bot Service Management to check availability of
// an Enterprise Channel name.
type EnterpriseChannelCheckNameAvailabilityRequest struct {
	// Name - The name of the Enterprise Channel for which availability needs to be checked.
	Name *string `json:"name,omitempty"`
}

// EnterpriseChannelCheckNameAvailabilityResponse a request to Bot Service Management to check availability of
// an Enterprise Channel name.
type EnterpriseChannelCheckNameAvailabilityResponse struct {
	autorest.Response `json:"-"`
	// Valid - Indicates if the Enterprise Channel name is valid.
	Valid *bool `json:"valid,omitempty"`
	// Message - Additional information about why a bot name is not available.
	Message *string `json:"message,omitempty"`
}

// EnterpriseChannelNode the properties specific to an Enterprise Channel Node.
type EnterpriseChannelNode struct {
	// ID - READ-ONLY; Id of Enterprise Channel Node. This is generated by the Bot Framework.
	ID *string `json:"id,omitempty"`
	// State - The current state of the Enterprise Channel Node. Possible values include: 'Creating', 'CreateFailed', 'Started', 'Starting', 'StartFailed', 'Stopped', 'Stopping', 'StopFailed', 'Deleting', 'DeleteFailed'
	State EnterpriseChannelNodeState `json:"state,omitempty"`
	// Name - The name of the Enterprise Channel Node.
	Name *string `json:"name,omitempty"`
	// AzureSku - The sku of the Enterprise Channel Node.
	AzureSku *string `json:"azureSku,omitempty"`
	// AzureLocation - The location of the Enterprise Channel Node.
	AzureLocation *string `json:"azureLocation,omitempty"`
}

// MarshalJSON is the custom marshaler for EnterpriseChannelNode.
func (ecn EnterpriseChannelNode) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ecn.State != "" {
		objectMap["state"] = ecn.State
	}
	if ecn.Name != nil {
		objectMap["name"] = ecn.Name
	}
	if ecn.AzureSku != nil {
		objectMap["azureSku"] = ecn.AzureSku
	}
	if ecn.AzureLocation != nil {
		objectMap["azureLocation"] = ecn.AzureLocation
	}
	return json.Marshal(objectMap)
}

// EnterpriseChannelProperties the parameters to provide for the Enterprise Channel.
type EnterpriseChannelProperties struct {
	// State - The current state of the Enterprise Channel. Possible values include: 'EnterpriseChannelStateCreating', 'EnterpriseChannelStateCreateFailed', 'EnterpriseChannelStateStarted', 'EnterpriseChannelStateStarting', 'EnterpriseChannelStateStartFailed', 'EnterpriseChannelStateStopped', 'EnterpriseChannelStateStopping', 'EnterpriseChannelStateStopFailed', 'EnterpriseChannelStateDeleting', 'EnterpriseChannelStateDeleteFailed'
	State EnterpriseChannelState `json:"state,omitempty"`
	// Nodes - The nodes associated with the Enterprise Channel.
	Nodes *[]EnterpriseChannelNode `json:"nodes,omitempty"`
}

// EnterpriseChannelResponseList the list of  bot service operation response.
type EnterpriseChannelResponseList struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of bot service resources.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - READ-ONLY; The list of Enterprise Channels and their properties.
	Value *[]EnterpriseChannel `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for EnterpriseChannelResponseList.
func (ecrl EnterpriseChannelResponseList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ecrl.NextLink != nil {
		objectMap["nextLink"] = ecrl.NextLink
	}
	return json.Marshal(objectMap)
}

// EnterpriseChannelResponseListIterator provides access to a complete listing of EnterpriseChannel values.
type EnterpriseChannelResponseListIterator struct {
	i    int
	page EnterpriseChannelResponseListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EnterpriseChannelResponseListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EnterpriseChannelResponseListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EnterpriseChannelResponseListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EnterpriseChannelResponseListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EnterpriseChannelResponseListIterator) Response() EnterpriseChannelResponseList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EnterpriseChannelResponseListIterator) Value() EnterpriseChannel {
	if !iter.page.NotDone() {
		return EnterpriseChannel{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EnterpriseChannelResponseListIterator type.
func NewEnterpriseChannelResponseListIterator(page EnterpriseChannelResponseListPage) EnterpriseChannelResponseListIterator {
	return EnterpriseChannelResponseListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ecrl EnterpriseChannelResponseList) IsEmpty() bool {
	return ecrl.Value == nil || len(*ecrl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ecrl EnterpriseChannelResponseList) hasNextLink() bool {
	return ecrl.NextLink != nil && len(*ecrl.NextLink) != 0
}

// enterpriseChannelResponseListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ecrl EnterpriseChannelResponseList) enterpriseChannelResponseListPreparer(ctx context.Context) (*http.Request, error) {
	if !ecrl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ecrl.NextLink)))
}

// EnterpriseChannelResponseListPage contains a page of EnterpriseChannel values.
type EnterpriseChannelResponseListPage struct {
	fn   func(context.Context, EnterpriseChannelResponseList) (EnterpriseChannelResponseList, error)
	ecrl EnterpriseChannelResponseList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EnterpriseChannelResponseListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EnterpriseChannelResponseListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ecrl)
		if err != nil {
			return err
		}
		page.ecrl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EnterpriseChannelResponseListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EnterpriseChannelResponseListPage) NotDone() bool {
	return !page.ecrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EnterpriseChannelResponseListPage) Response() EnterpriseChannelResponseList {
	return page.ecrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EnterpriseChannelResponseListPage) Values() []EnterpriseChannel {
	if page.ecrl.IsEmpty() {
		return nil
	}
	return *page.ecrl.Value
}

// Creates a new instance of the EnterpriseChannelResponseListPage type.
func NewEnterpriseChannelResponseListPage(getNextPage func(context.Context, EnterpriseChannelResponseList) (EnterpriseChannelResponseList, error)) EnterpriseChannelResponseListPage {
	return EnterpriseChannelResponseListPage{fn: getNextPage}
}

// EnterpriseChannelsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EnterpriseChannelsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EnterpriseChannelsCreateFuture) Result(client EnterpriseChannelsClient) (ec EnterpriseChannel, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "botservice.EnterpriseChannelsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("botservice.EnterpriseChannelsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ec.Response.Response, err = future.GetResult(sender); err == nil && ec.Response.Response.StatusCode != http.StatusNoContent {
		ec, err = client.CreateResponder(ec.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "botservice.EnterpriseChannelsCreateFuture", "Result", ec.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EnterpriseChannelsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EnterpriseChannelsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EnterpriseChannelsDeleteFuture) Result(client EnterpriseChannelsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "botservice.EnterpriseChannelsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("botservice.EnterpriseChannelsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EnterpriseChannelsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EnterpriseChannelsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EnterpriseChannelsUpdateFuture) Result(client EnterpriseChannelsClient) (ec EnterpriseChannel, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "botservice.EnterpriseChannelsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("botservice.EnterpriseChannelsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ec.Response.Response, err = future.GetResult(sender); err == nil && ec.Response.Response.StatusCode != http.StatusNoContent {
		ec, err = client.UpdateResponder(ec.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "botservice.EnterpriseChannelsUpdateFuture", "Result", ec.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Error bot Service error object.
type Error struct {
	// Error - The error body.
	Error *ErrorBody `json:"error,omitempty"`
}

// ErrorBody bot Service error body.
type ErrorBody struct {
	// Code - error code
	Code *string `json:"code,omitempty"`
	// Message - error message
	Message *string `json:"message,omitempty"`
}

// FacebookChannel facebook channel definition
type FacebookChannel struct {
	// Properties - The set of properties specific to bot facebook channel
	Properties *FacebookChannelProperties `json:"properties,omitempty"`
	// ChannelName - Possible values include: 'ChannelNameChannel', 'ChannelNameFacebookChannel1', 'ChannelNameEmailChannel1', 'ChannelNameMsTeamsChannel1', 'ChannelNameSkypeChannel1', 'ChannelNameKikChannel1', 'ChannelNameWebChatChannel1', 'ChannelNameDirectLineChannel1', 'ChannelNameTelegramChannel1', 'ChannelNameSmsChannel1', 'ChannelNameSlackChannel1'
	ChannelName ChannelNameBasicChannel `json:"channelName,omitempty"`
}

// MarshalJSON is the custom marshaler for FacebookChannel.
func (fc FacebookChannel) MarshalJSON() ([]byte, error) {
	fc.ChannelName = ChannelNameFacebookChannel1
	objectMap := make(map[string]interface{})
	if fc.Properties != nil {
		objectMap["properties"] = fc.Properties
	}
	if fc.ChannelName != "" {
		objectMap["channelName"] = fc.ChannelName
	}
	return json.Marshal(objectMap)
}

// AsFacebookChannel is the BasicChannel implementation for FacebookChannel.
func (fc FacebookChannel) AsFacebookChannel() (*FacebookChannel, bool) {
	return &fc, true
}

// AsEmailChannel is the BasicChannel implementation for FacebookChannel.
func (fc FacebookChannel) AsEmailChannel() (*EmailChannel, bool) {
	return nil, false
}

// AsMsTeamsChannel is the BasicChannel implementation for FacebookChannel.
func (fc FacebookChannel) AsMsTeamsChannel() (*MsTeamsChannel, bool) {
	return nil, false
}

// AsSkypeChannel is the BasicChannel implementation for FacebookChannel.
func (fc FacebookChannel) AsSkypeChannel() (*SkypeChannel, bool) {
	return nil, false
}

// AsKikChannel is the BasicChannel implementation for FacebookChannel.
func (fc FacebookChannel) AsKikChannel() (*KikChannel, bool) {
	return nil, false
}

// AsWebChatChannel is the BasicChannel implementation for FacebookChannel.
func (fc FacebookChannel) AsWebChatChannel() (*WebChatChannel, bool) {
	return nil, false
}

// AsDirectLineChannel is the BasicChannel implementation for FacebookChannel.
func (fc FacebookChannel) AsDirectLineChannel() (*DirectLineChannel, bool) {
	return nil, false
}

// AsTelegramChannel is the BasicChannel implementation for FacebookChannel.
func (fc FacebookChannel) AsTelegramChannel() (*TelegramChannel, bool) {
	return nil, false
}

// AsSmsChannel is the BasicChannel implementation for FacebookChannel.
func (fc FacebookChannel) AsSmsChannel() (*SmsChannel, bool) {
	return nil, false
}

// AsSlackChannel is the BasicChannel implementation for FacebookChannel.
func (fc FacebookChannel) AsSlackChannel() (*SlackChannel, bool) {
	return nil, false
}

// AsChannel is the BasicChannel implementation for FacebookChannel.
func (fc FacebookChannel) AsChannel() (*Channel, bool) {
	return nil, false
}

// AsBasicChannel is the BasicChannel implementation for FacebookChannel.
func (fc FacebookChannel) AsBasicChannel() (BasicChannel, bool) {
	return &fc, true
}

// FacebookChannelProperties the parameters to provide for the Facebook channel.
type FacebookChannelProperties struct {
	// VerifyToken - READ-ONLY; Verify token. Value only returned through POST to the action Channel List API, otherwise empty.
	VerifyToken *string `json:"verifyToken,omitempty"`
	// Pages - The list of Facebook pages
	Pages *[]FacebookPage `json:"pages,omitempty"`
	// AppID - Facebook application id
	AppID *string `json:"appId,omitempty"`
	// AppSecret - Facebook application secret. Value only returned through POST to the action Channel List API, otherwise empty.
	AppSecret *string `json:"appSecret,omitempty"`
	// CallbackURL - READ-ONLY; Callback Url
	CallbackURL *string `json:"callbackUrl,omitempty"`
	// IsEnabled - Whether this channel is enabled for the bot
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// MarshalJSON is the custom marshaler for FacebookChannelProperties.
func (fcp FacebookChannelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fcp.Pages != nil {
		objectMap["pages"] = fcp.Pages
	}
	if fcp.AppID != nil {
		objectMap["appId"] = fcp.AppID
	}
	if fcp.AppSecret != nil {
		objectMap["appSecret"] = fcp.AppSecret
	}
	if fcp.IsEnabled != nil {
		objectMap["isEnabled"] = fcp.IsEnabled
	}
	return json.Marshal(objectMap)
}

// FacebookPage a Facebook page for Facebook channel registration
type FacebookPage struct {
	// ID - Page id
	ID *string `json:"id,omitempty"`
	// AccessToken - Facebook application access token. Value only returned through POST to the action Channel List API, otherwise empty.
	AccessToken *string `json:"accessToken,omitempty"`
}

// KikChannel kik channel definition
type KikChannel struct {
	// Properties - The set of properties specific to Kik channel resource
	Properties *KikChannelProperties `json:"properties,omitempty"`
	// ChannelName - Possible values include: 'ChannelNameChannel', 'ChannelNameFacebookChannel1', 'ChannelNameEmailChannel1', 'ChannelNameMsTeamsChannel1', 'ChannelNameSkypeChannel1', 'ChannelNameKikChannel1', 'ChannelNameWebChatChannel1', 'ChannelNameDirectLineChannel1', 'ChannelNameTelegramChannel1', 'ChannelNameSmsChannel1', 'ChannelNameSlackChannel1'
	ChannelName ChannelNameBasicChannel `json:"channelName,omitempty"`
}

// MarshalJSON is the custom marshaler for KikChannel.
func (kc KikChannel) MarshalJSON() ([]byte, error) {
	kc.ChannelName = ChannelNameKikChannel1
	objectMap := make(map[string]interface{})
	if kc.Properties != nil {
		objectMap["properties"] = kc.Properties
	}
	if kc.ChannelName != "" {
		objectMap["channelName"] = kc.ChannelName
	}
	return json.Marshal(objectMap)
}

// AsFacebookChannel is the BasicChannel implementation for KikChannel.
func (kc KikChannel) AsFacebookChannel() (*FacebookChannel, bool) {
	return nil, false
}

// AsEmailChannel is the BasicChannel implementation for KikChannel.
func (kc KikChannel) AsEmailChannel() (*EmailChannel, bool) {
	return nil, false
}

// AsMsTeamsChannel is the BasicChannel implementation for KikChannel.
func (kc KikChannel) AsMsTeamsChannel() (*MsTeamsChannel, bool) {
	return nil, false
}

// AsSkypeChannel is the BasicChannel implementation for KikChannel.
func (kc KikChannel) AsSkypeChannel() (*SkypeChannel, bool) {
	return nil, false
}

// AsKikChannel is the BasicChannel implementation for KikChannel.
func (kc KikChannel) AsKikChannel() (*KikChannel, bool) {
	return &kc, true
}

// AsWebChatChannel is the BasicChannel implementation for KikChannel.
func (kc KikChannel) AsWebChatChannel() (*WebChatChannel, bool) {
	return nil, false
}

// AsDirectLineChannel is the BasicChannel implementation for KikChannel.
func (kc KikChannel) AsDirectLineChannel() (*DirectLineChannel, bool) {
	return nil, false
}

// AsTelegramChannel is the BasicChannel implementation for KikChannel.
func (kc KikChannel) AsTelegramChannel() (*TelegramChannel, bool) {
	return nil, false
}

// AsSmsChannel is the BasicChannel implementation for KikChannel.
func (kc KikChannel) AsSmsChannel() (*SmsChannel, bool) {
	return nil, false
}

// AsSlackChannel is the BasicChannel implementation for KikChannel.
func (kc KikChannel) AsSlackChannel() (*SlackChannel, bool) {
	return nil, false
}

// AsChannel is the BasicChannel implementation for KikChannel.
func (kc KikChannel) AsChannel() (*Channel, bool) {
	return nil, false
}

// AsBasicChannel is the BasicChannel implementation for KikChannel.
func (kc KikChannel) AsBasicChannel() (BasicChannel, bool) {
	return &kc, true
}

// KikChannelProperties the parameters to provide for the Kik channel.
type KikChannelProperties struct {
	// UserName - The Kik user name
	UserName *string `json:"userName,omitempty"`
	// APIKey - Kik API key. Value only returned through POST to the action Channel List API, otherwise empty.
	APIKey *string `json:"apiKey,omitempty"`
	// IsValidated - Whether this channel is validated for the bot
	IsValidated *bool `json:"isValidated,omitempty"`
	// IsEnabled - Whether this channel is enabled for the bot
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// MsTeamsChannel microsoft Teams channel definition
type MsTeamsChannel struct {
	// Properties - The set of properties specific to Microsoft Teams channel resource
	Properties *MsTeamsChannelProperties `json:"properties,omitempty"`
	// ChannelName - Possible values include: 'ChannelNameChannel', 'ChannelNameFacebookChannel1', 'ChannelNameEmailChannel1', 'ChannelNameMsTeamsChannel1', 'ChannelNameSkypeChannel1', 'ChannelNameKikChannel1', 'ChannelNameWebChatChannel1', 'ChannelNameDirectLineChannel1', 'ChannelNameTelegramChannel1', 'ChannelNameSmsChannel1', 'ChannelNameSlackChannel1'
	ChannelName ChannelNameBasicChannel `json:"channelName,omitempty"`
}

// MarshalJSON is the custom marshaler for MsTeamsChannel.
func (mtc MsTeamsChannel) MarshalJSON() ([]byte, error) {
	mtc.ChannelName = ChannelNameMsTeamsChannel1
	objectMap := make(map[string]interface{})
	if mtc.Properties != nil {
		objectMap["properties"] = mtc.Properties
	}
	if mtc.ChannelName != "" {
		objectMap["channelName"] = mtc.ChannelName
	}
	return json.Marshal(objectMap)
}

// AsFacebookChannel is the BasicChannel implementation for MsTeamsChannel.
func (mtc MsTeamsChannel) AsFacebookChannel() (*FacebookChannel, bool) {
	return nil, false
}

// AsEmailChannel is the BasicChannel implementation for MsTeamsChannel.
func (mtc MsTeamsChannel) AsEmailChannel() (*EmailChannel, bool) {
	return nil, false
}

// AsMsTeamsChannel is the BasicChannel implementation for MsTeamsChannel.
func (mtc MsTeamsChannel) AsMsTeamsChannel() (*MsTeamsChannel, bool) {
	return &mtc, true
}

// AsSkypeChannel is the BasicChannel implementation for MsTeamsChannel.
func (mtc MsTeamsChannel) AsSkypeChannel() (*SkypeChannel, bool) {
	return nil, false
}

// AsKikChannel is the BasicChannel implementation for MsTeamsChannel.
func (mtc MsTeamsChannel) AsKikChannel() (*KikChannel, bool) {
	return nil, false
}

// AsWebChatChannel is the BasicChannel implementation for MsTeamsChannel.
func (mtc MsTeamsChannel) AsWebChatChannel() (*WebChatChannel, bool) {
	return nil, false
}

// AsDirectLineChannel is the BasicChannel implementation for MsTeamsChannel.
func (mtc MsTeamsChannel) AsDirectLineChannel() (*DirectLineChannel, bool) {
	return nil, false
}

// AsTelegramChannel is the BasicChannel implementation for MsTeamsChannel.
func (mtc MsTeamsChannel) AsTelegramChannel() (*TelegramChannel, bool) {
	return nil, false
}

// AsSmsChannel is the BasicChannel implementation for MsTeamsChannel.
func (mtc MsTeamsChannel) AsSmsChannel() (*SmsChannel, bool) {
	return nil, false
}

// AsSlackChannel is the BasicChannel implementation for MsTeamsChannel.
func (mtc MsTeamsChannel) AsSlackChannel() (*SlackChannel, bool) {
	return nil, false
}

// AsChannel is the BasicChannel implementation for MsTeamsChannel.
func (mtc MsTeamsChannel) AsChannel() (*Channel, bool) {
	return nil, false
}

// AsBasicChannel is the BasicChannel implementation for MsTeamsChannel.
func (mtc MsTeamsChannel) AsBasicChannel() (BasicChannel, bool) {
	return &mtc, true
}

// MsTeamsChannelProperties the parameters to provide for the Microsoft Teams channel.
type MsTeamsChannelProperties struct {
	// EnableCalling - Enable calling for Microsoft Teams channel
	EnableCalling *bool `json:"enableCalling,omitempty"`
	// CallingWebHook - Webhook for Microsoft Teams channel calls
	CallingWebHook *string `json:"callingWebHook,omitempty"`
	// IsEnabled - Whether this channel is enabled for the bot
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// OperationDisplayInfo the operation supported by Bot Service Management.
type OperationDisplayInfo struct {
	// Description - The description of the operation.
	Description *string `json:"description,omitempty"`
	// Operation - The action that users can perform, based on their permission level.
	Operation *string `json:"operation,omitempty"`
	// Provider - Service provider: Microsoft Bot Service.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationEntity the operations supported by Bot Service Management.
type OperationEntity struct {
	// Name - Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
	// Display - The operation supported by Bot Service Management.
	Display *OperationDisplayInfo `json:"display,omitempty"`
	// Origin - The origin of the operation.
	Origin *string `json:"origin,omitempty"`
	// Properties - Additional properties.
	Properties interface{} `json:"properties,omitempty"`
}

// OperationEntityListResult the list of bot service operation response.
type OperationEntityListResult struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - The list of operations.
	Value *[]OperationEntity `json:"value,omitempty"`
}

// OperationEntityListResultIterator provides access to a complete listing of OperationEntity values.
type OperationEntityListResultIterator struct {
	i    int
	page OperationEntityListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationEntityListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationEntityListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationEntityListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationEntityListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationEntityListResultIterator) Response() OperationEntityListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationEntityListResultIterator) Value() OperationEntity {
	if !iter.page.NotDone() {
		return OperationEntity{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationEntityListResultIterator type.
func NewOperationEntityListResultIterator(page OperationEntityListResultPage) OperationEntityListResultIterator {
	return OperationEntityListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (oelr OperationEntityListResult) IsEmpty() bool {
	return oelr.Value == nil || len(*oelr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (oelr OperationEntityListResult) hasNextLink() bool {
	return oelr.NextLink != nil && len(*oelr.NextLink) != 0
}

// operationEntityListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (oelr OperationEntityListResult) operationEntityListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !oelr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(oelr.NextLink)))
}

// OperationEntityListResultPage contains a page of OperationEntity values.
type OperationEntityListResultPage struct {
	fn   func(context.Context, OperationEntityListResult) (OperationEntityListResult, error)
	oelr OperationEntityListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationEntityListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationEntityListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.oelr)
		if err != nil {
			return err
		}
		page.oelr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationEntityListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationEntityListResultPage) NotDone() bool {
	return !page.oelr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationEntityListResultPage) Response() OperationEntityListResult {
	return page.oelr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationEntityListResultPage) Values() []OperationEntity {
	if page.oelr.IsEmpty() {
		return nil
	}
	return *page.oelr.Value
}

// Creates a new instance of the OperationEntityListResultPage type.
func NewOperationEntityListResultPage(getNextPage func(context.Context, OperationEntityListResult) (OperationEntityListResult, error)) OperationEntityListResultPage {
	return OperationEntityListResultPage{fn: getNextPage}
}

// Resource azure resource
type Resource struct {
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Specifies the name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Specifies the type of the resource.
	Type *string `json:"type,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
	// Sku - Gets or sets the SKU of the resource.
	Sku *Sku `json:"sku,omitempty"`
	// Kind - Required. Gets or sets the Kind of the resource. Possible values include: 'KindSdk', 'KindDesigner', 'KindBot', 'KindFunction'
	Kind Kind `json:"kind,omitempty"`
	// Etag - Entity Tag
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	if r.Sku != nil {
		objectMap["sku"] = r.Sku
	}
	if r.Kind != "" {
		objectMap["kind"] = r.Kind
	}
	if r.Etag != nil {
		objectMap["etag"] = r.Etag
	}
	return json.Marshal(objectMap)
}

// ServiceProvider service Provider Definition
type ServiceProvider struct {
	// Properties - The Properties of a Service Provider Object
	Properties *ServiceProviderProperties `json:"properties,omitempty"`
}

// ServiceProviderParameter extra Parameters specific to each Service Provider
type ServiceProviderParameter struct {
	// Name - READ-ONLY; Name of the Service Provider
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the Service Provider
	Type *string `json:"type,omitempty"`
	// DisplayName - READ-ONLY; Display Name of the Service Provider
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; Description of the Service Provider
	Description *string `json:"description,omitempty"`
	// HelpURL - READ-ONLY; Help Url for the  Service Provider
	HelpURL *string `json:"helpUrl,omitempty"`
	// Default - READ-ONLY; Default Name for the Service Provider
	Default *string `json:"default,omitempty"`
}

// ServiceProviderProperties the Object used to describe a Service Provider supported by Bot Service
type ServiceProviderProperties struct {
	// ID - READ-ONLY; Id for Service Provider
	ID *string `json:"id,omitempty"`
	// DisplayName - READ-ONLY; Display Name of the Service Provider
	DisplayName *string `json:"displayName,omitempty"`
	// ServiceProviderName - READ-ONLY; Display Name of the Service Provider
	ServiceProviderName *string `json:"serviceProviderName,omitempty"`
	// DevPortalURL - READ-ONLY; Display Name of the Service Provider
	DevPortalURL *string `json:"devPortalUrl,omitempty"`
	// IconURL - READ-ONLY; Display Name of the Service Provider
	IconURL *string `json:"iconUrl,omitempty"`
	// Parameters - The list of parameters for the Service Provider
	Parameters *[]ServiceProviderParameter `json:"parameters,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceProviderProperties.
func (spp ServiceProviderProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spp.Parameters != nil {
		objectMap["parameters"] = spp.Parameters
	}
	return json.Marshal(objectMap)
}

// ServiceProviderResponseList the list of bot service providers response.
type ServiceProviderResponseList struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of bot service providers.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - READ-ONLY; Gets the list of bot service providers and their properties.
	Value *[]ServiceProvider `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceProviderResponseList.
func (sprl ServiceProviderResponseList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sprl.NextLink != nil {
		objectMap["nextLink"] = sprl.NextLink
	}
	return json.Marshal(objectMap)
}

// Sku the SKU of the cognitive services account.
type Sku struct {
	// Name - The sku name. Possible values include: 'F0', 'S1'
	Name SkuName `json:"name,omitempty"`
	// Tier - READ-ONLY; Gets the sku tier. This is based on the SKU name. Possible values include: 'Free', 'Standard'
	Tier SkuTier `json:"tier,omitempty"`
}

// MarshalJSON is the custom marshaler for Sku.
func (s Sku) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Name != "" {
		objectMap["name"] = s.Name
	}
	return json.Marshal(objectMap)
}

// SkypeChannel skype channel definition
type SkypeChannel struct {
	// Properties - The set of properties specific to Skype channel resource
	Properties *SkypeChannelProperties `json:"properties,omitempty"`
	// ChannelName - Possible values include: 'ChannelNameChannel', 'ChannelNameFacebookChannel1', 'ChannelNameEmailChannel1', 'ChannelNameMsTeamsChannel1', 'ChannelNameSkypeChannel1', 'ChannelNameKikChannel1', 'ChannelNameWebChatChannel1', 'ChannelNameDirectLineChannel1', 'ChannelNameTelegramChannel1', 'ChannelNameSmsChannel1', 'ChannelNameSlackChannel1'
	ChannelName ChannelNameBasicChannel `json:"channelName,omitempty"`
}

// MarshalJSON is the custom marshaler for SkypeChannel.
func (sc SkypeChannel) MarshalJSON() ([]byte, error) {
	sc.ChannelName = ChannelNameSkypeChannel1
	objectMap := make(map[string]interface{})
	if sc.Properties != nil {
		objectMap["properties"] = sc.Properties
	}
	if sc.ChannelName != "" {
		objectMap["channelName"] = sc.ChannelName
	}
	return json.Marshal(objectMap)
}

// AsFacebookChannel is the BasicChannel implementation for SkypeChannel.
func (sc SkypeChannel) AsFacebookChannel() (*FacebookChannel, bool) {
	return nil, false
}

// AsEmailChannel is the BasicChannel implementation for SkypeChannel.
func (sc SkypeChannel) AsEmailChannel() (*EmailChannel, bool) {
	return nil, false
}

// AsMsTeamsChannel is the BasicChannel implementation for SkypeChannel.
func (sc SkypeChannel) AsMsTeamsChannel() (*MsTeamsChannel, bool) {
	return nil, false
}

// AsSkypeChannel is the BasicChannel implementation for SkypeChannel.
func (sc SkypeChannel) AsSkypeChannel() (*SkypeChannel, bool) {
	return &sc, true
}

// AsKikChannel is the BasicChannel implementation for SkypeChannel.
func (sc SkypeChannel) AsKikChannel() (*KikChannel, bool) {
	return nil, false
}

// AsWebChatChannel is the BasicChannel implementation for SkypeChannel.
func (sc SkypeChannel) AsWebChatChannel() (*WebChatChannel, bool) {
	return nil, false
}

// AsDirectLineChannel is the BasicChannel implementation for SkypeChannel.
func (sc SkypeChannel) AsDirectLineChannel() (*DirectLineChannel, bool) {
	return nil, false
}

// AsTelegramChannel is the BasicChannel implementation for SkypeChannel.
func (sc SkypeChannel) AsTelegramChannel() (*TelegramChannel, bool) {
	return nil, false
}

// AsSmsChannel is the BasicChannel implementation for SkypeChannel.
func (sc SkypeChannel) AsSmsChannel() (*SmsChannel, bool) {
	return nil, false
}

// AsSlackChannel is the BasicChannel implementation for SkypeChannel.
func (sc SkypeChannel) AsSlackChannel() (*SlackChannel, bool) {
	return nil, false
}

// AsChannel is the BasicChannel implementation for SkypeChannel.
func (sc SkypeChannel) AsChannel() (*Channel, bool) {
	return nil, false
}

// AsBasicChannel is the BasicChannel implementation for SkypeChannel.
func (sc SkypeChannel) AsBasicChannel() (BasicChannel, bool) {
	return &sc, true
}

// SkypeChannelProperties the parameters to provide for the Microsoft Teams channel.
type SkypeChannelProperties struct {
	// EnableMessaging - Enable messaging for Skype channel
	EnableMessaging *bool `json:"enableMessaging,omitempty"`
	// EnableMediaCards - Enable media cards for Skype channel
	EnableMediaCards *bool `json:"enableMediaCards,omitempty"`
	// EnableVideo - Enable video for Skype channel
	EnableVideo *bool `json:"enableVideo,omitempty"`
	// EnableCalling - Enable calling for Skype channel
	EnableCalling *bool `json:"enableCalling,omitempty"`
	// EnableScreenSharing - Enable screen sharing for Skype channel
	EnableScreenSharing *bool `json:"enableScreenSharing,omitempty"`
	// EnableGroups - Enable groups for Skype channel
	EnableGroups *bool `json:"enableGroups,omitempty"`
	// GroupsMode - Group mode for Skype channel
	GroupsMode *string `json:"groupsMode,omitempty"`
	// CallingWebHook - Calling web hook for Skype channel
	CallingWebHook *string `json:"callingWebHook,omitempty"`
	// IsEnabled - Whether this channel is enabled for the bot
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// SlackChannel slack channel definition
type SlackChannel struct {
	// Properties - The set of properties specific to Slack channel resource
	Properties *SlackChannelProperties `json:"properties,omitempty"`
	// ChannelName - Possible values include: 'ChannelNameChannel', 'ChannelNameFacebookChannel1', 'ChannelNameEmailChannel1', 'ChannelNameMsTeamsChannel1', 'ChannelNameSkypeChannel1', 'ChannelNameKikChannel1', 'ChannelNameWebChatChannel1', 'ChannelNameDirectLineChannel1', 'ChannelNameTelegramChannel1', 'ChannelNameSmsChannel1', 'ChannelNameSlackChannel1'
	ChannelName ChannelNameBasicChannel `json:"channelName,omitempty"`
}

// MarshalJSON is the custom marshaler for SlackChannel.
func (sc SlackChannel) MarshalJSON() ([]byte, error) {
	sc.ChannelName = ChannelNameSlackChannel1
	objectMap := make(map[string]interface{})
	if sc.Properties != nil {
		objectMap["properties"] = sc.Properties
	}
	if sc.ChannelName != "" {
		objectMap["channelName"] = sc.ChannelName
	}
	return json.Marshal(objectMap)
}

// AsFacebookChannel is the BasicChannel implementation for SlackChannel.
func (sc SlackChannel) AsFacebookChannel() (*FacebookChannel, bool) {
	return nil, false
}

// AsEmailChannel is the BasicChannel implementation for SlackChannel.
func (sc SlackChannel) AsEmailChannel() (*EmailChannel, bool) {
	return nil, false
}

// AsMsTeamsChannel is the BasicChannel implementation for SlackChannel.
func (sc SlackChannel) AsMsTeamsChannel() (*MsTeamsChannel, bool) {
	return nil, false
}

// AsSkypeChannel is the BasicChannel implementation for SlackChannel.
func (sc SlackChannel) AsSkypeChannel() (*SkypeChannel, bool) {
	return nil, false
}

// AsKikChannel is the BasicChannel implementation for SlackChannel.
func (sc SlackChannel) AsKikChannel() (*KikChannel, bool) {
	return nil, false
}

// AsWebChatChannel is the BasicChannel implementation for SlackChannel.
func (sc SlackChannel) AsWebChatChannel() (*WebChatChannel, bool) {
	return nil, false
}

// AsDirectLineChannel is the BasicChannel implementation for SlackChannel.
func (sc SlackChannel) AsDirectLineChannel() (*DirectLineChannel, bool) {
	return nil, false
}

// AsTelegramChannel is the BasicChannel implementation for SlackChannel.
func (sc SlackChannel) AsTelegramChannel() (*TelegramChannel, bool) {
	return nil, false
}

// AsSmsChannel is the BasicChannel implementation for SlackChannel.
func (sc SlackChannel) AsSmsChannel() (*SmsChannel, bool) {
	return nil, false
}

// AsSlackChannel is the BasicChannel implementation for SlackChannel.
func (sc SlackChannel) AsSlackChannel() (*SlackChannel, bool) {
	return &sc, true
}

// AsChannel is the BasicChannel implementation for SlackChannel.
func (sc SlackChannel) AsChannel() (*Channel, bool) {
	return nil, false
}

// AsBasicChannel is the BasicChannel implementation for SlackChannel.
func (sc SlackChannel) AsBasicChannel() (BasicChannel, bool) {
	return &sc, true
}

// SlackChannelProperties the parameters to provide for the Slack channel.
type SlackChannelProperties struct {
	// ClientID - The Slack client id
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - The Slack client secret. Value only returned through POST to the action Channel List API, otherwise empty.
	ClientSecret *string `json:"clientSecret,omitempty"`
	// VerificationToken - The Slack verification token. Value only returned through POST to the action Channel List API, otherwise empty.
	VerificationToken *string `json:"verificationToken,omitempty"`
	// LandingPageURL - The Slack landing page Url
	LandingPageURL *string `json:"landingPageUrl,omitempty"`
	// RedirectAction - READ-ONLY; The Slack redirect action
	RedirectAction *string `json:"redirectAction,omitempty"`
	// LastSubmissionID - READ-ONLY; The Sms auth token
	LastSubmissionID *string `json:"lastSubmissionId,omitempty"`
	// RegisterBeforeOAuthFlow - READ-ONLY; Whether to register the settings before OAuth validation is performed. Recommended to True.
	RegisterBeforeOAuthFlow *bool `json:"registerBeforeOAuthFlow,omitempty"`
	// IsValidated - READ-ONLY; Whether this channel is validated for the bot
	IsValidated *bool `json:"isValidated,omitempty"`
	// IsEnabled - Whether this channel is enabled for the bot
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// MarshalJSON is the custom marshaler for SlackChannelProperties.
func (scp SlackChannelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scp.ClientID != nil {
		objectMap["clientId"] = scp.ClientID
	}
	if scp.ClientSecret != nil {
		objectMap["clientSecret"] = scp.ClientSecret
	}
	if scp.VerificationToken != nil {
		objectMap["verificationToken"] = scp.VerificationToken
	}
	if scp.LandingPageURL != nil {
		objectMap["landingPageUrl"] = scp.LandingPageURL
	}
	if scp.IsEnabled != nil {
		objectMap["isEnabled"] = scp.IsEnabled
	}
	return json.Marshal(objectMap)
}

// SmsChannel sms channel definition
type SmsChannel struct {
	// Properties - The set of properties specific to Sms channel resource
	Properties *SmsChannelProperties `json:"properties,omitempty"`
	// ChannelName - Possible values include: 'ChannelNameChannel', 'ChannelNameFacebookChannel1', 'ChannelNameEmailChannel1', 'ChannelNameMsTeamsChannel1', 'ChannelNameSkypeChannel1', 'ChannelNameKikChannel1', 'ChannelNameWebChatChannel1', 'ChannelNameDirectLineChannel1', 'ChannelNameTelegramChannel1', 'ChannelNameSmsChannel1', 'ChannelNameSlackChannel1'
	ChannelName ChannelNameBasicChannel `json:"channelName,omitempty"`
}

// MarshalJSON is the custom marshaler for SmsChannel.
func (sc SmsChannel) MarshalJSON() ([]byte, error) {
	sc.ChannelName = ChannelNameSmsChannel1
	objectMap := make(map[string]interface{})
	if sc.Properties != nil {
		objectMap["properties"] = sc.Properties
	}
	if sc.ChannelName != "" {
		objectMap["channelName"] = sc.ChannelName
	}
	return json.Marshal(objectMap)
}

// AsFacebookChannel is the BasicChannel implementation for SmsChannel.
func (sc SmsChannel) AsFacebookChannel() (*FacebookChannel, bool) {
	return nil, false
}

// AsEmailChannel is the BasicChannel implementation for SmsChannel.
func (sc SmsChannel) AsEmailChannel() (*EmailChannel, bool) {
	return nil, false
}

// AsMsTeamsChannel is the BasicChannel implementation for SmsChannel.
func (sc SmsChannel) AsMsTeamsChannel() (*MsTeamsChannel, bool) {
	return nil, false
}

// AsSkypeChannel is the BasicChannel implementation for SmsChannel.
func (sc SmsChannel) AsSkypeChannel() (*SkypeChannel, bool) {
	return nil, false
}

// AsKikChannel is the BasicChannel implementation for SmsChannel.
func (sc SmsChannel) AsKikChannel() (*KikChannel, bool) {
	return nil, false
}

// AsWebChatChannel is the BasicChannel implementation for SmsChannel.
func (sc SmsChannel) AsWebChatChannel() (*WebChatChannel, bool) {
	return nil, false
}

// AsDirectLineChannel is the BasicChannel implementation for SmsChannel.
func (sc SmsChannel) AsDirectLineChannel() (*DirectLineChannel, bool) {
	return nil, false
}

// AsTelegramChannel is the BasicChannel implementation for SmsChannel.
func (sc SmsChannel) AsTelegramChannel() (*TelegramChannel, bool) {
	return nil, false
}

// AsSmsChannel is the BasicChannel implementation for SmsChannel.
func (sc SmsChannel) AsSmsChannel() (*SmsChannel, bool) {
	return &sc, true
}

// AsSlackChannel is the BasicChannel implementation for SmsChannel.
func (sc SmsChannel) AsSlackChannel() (*SlackChannel, bool) {
	return nil, false
}

// AsChannel is the BasicChannel implementation for SmsChannel.
func (sc SmsChannel) AsChannel() (*Channel, bool) {
	return nil, false
}

// AsBasicChannel is the BasicChannel implementation for SmsChannel.
func (sc SmsChannel) AsBasicChannel() (BasicChannel, bool) {
	return &sc, true
}

// SmsChannelProperties the parameters to provide for the Sms channel.
type SmsChannelProperties struct {
	// Phone - The Sms phone
	Phone *string `json:"phone,omitempty"`
	// AccountSID - The Sms account SID. Value only returned through POST to the action Channel List API, otherwise empty.
	AccountSID *string `json:"accountSID,omitempty"`
	// AuthToken - The Sms auth token. Value only returned through POST to the action Channel List API, otherwise empty.
	AuthToken *string `json:"authToken,omitempty"`
	// IsValidated - Whether this channel is validated for the bot
	IsValidated *bool `json:"isValidated,omitempty"`
	// IsEnabled - Whether this channel is enabled for the bot
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// TelegramChannel telegram channel definition
type TelegramChannel struct {
	// Properties - The set of properties specific to Telegram channel resource
	Properties *TelegramChannelProperties `json:"properties,omitempty"`
	// ChannelName - Possible values include: 'ChannelNameChannel', 'ChannelNameFacebookChannel1', 'ChannelNameEmailChannel1', 'ChannelNameMsTeamsChannel1', 'ChannelNameSkypeChannel1', 'ChannelNameKikChannel1', 'ChannelNameWebChatChannel1', 'ChannelNameDirectLineChannel1', 'ChannelNameTelegramChannel1', 'ChannelNameSmsChannel1', 'ChannelNameSlackChannel1'
	ChannelName ChannelNameBasicChannel `json:"channelName,omitempty"`
}

// MarshalJSON is the custom marshaler for TelegramChannel.
func (tc TelegramChannel) MarshalJSON() ([]byte, error) {
	tc.ChannelName = ChannelNameTelegramChannel1
	objectMap := make(map[string]interface{})
	if tc.Properties != nil {
		objectMap["properties"] = tc.Properties
	}
	if tc.ChannelName != "" {
		objectMap["channelName"] = tc.ChannelName
	}
	return json.Marshal(objectMap)
}

// AsFacebookChannel is the BasicChannel implementation for TelegramChannel.
func (tc TelegramChannel) AsFacebookChannel() (*FacebookChannel, bool) {
	return nil, false
}

// AsEmailChannel is the BasicChannel implementation for TelegramChannel.
func (tc TelegramChannel) AsEmailChannel() (*EmailChannel, bool) {
	return nil, false
}

// AsMsTeamsChannel is the BasicChannel implementation for TelegramChannel.
func (tc TelegramChannel) AsMsTeamsChannel() (*MsTeamsChannel, bool) {
	return nil, false
}

// AsSkypeChannel is the BasicChannel implementation for TelegramChannel.
func (tc TelegramChannel) AsSkypeChannel() (*SkypeChannel, bool) {
	return nil, false
}

// AsKikChannel is the BasicChannel implementation for TelegramChannel.
func (tc TelegramChannel) AsKikChannel() (*KikChannel, bool) {
	return nil, false
}

// AsWebChatChannel is the BasicChannel implementation for TelegramChannel.
func (tc TelegramChannel) AsWebChatChannel() (*WebChatChannel, bool) {
	return nil, false
}

// AsDirectLineChannel is the BasicChannel implementation for TelegramChannel.
func (tc TelegramChannel) AsDirectLineChannel() (*DirectLineChannel, bool) {
	return nil, false
}

// AsTelegramChannel is the BasicChannel implementation for TelegramChannel.
func (tc TelegramChannel) AsTelegramChannel() (*TelegramChannel, bool) {
	return &tc, true
}

// AsSmsChannel is the BasicChannel implementation for TelegramChannel.
func (tc TelegramChannel) AsSmsChannel() (*SmsChannel, bool) {
	return nil, false
}

// AsSlackChannel is the BasicChannel implementation for TelegramChannel.
func (tc TelegramChannel) AsSlackChannel() (*SlackChannel, bool) {
	return nil, false
}

// AsChannel is the BasicChannel implementation for TelegramChannel.
func (tc TelegramChannel) AsChannel() (*Channel, bool) {
	return nil, false
}

// AsBasicChannel is the BasicChannel implementation for TelegramChannel.
func (tc TelegramChannel) AsBasicChannel() (BasicChannel, bool) {
	return &tc, true
}

// TelegramChannelProperties the parameters to provide for the Telegram channel.
type TelegramChannelProperties struct {
	// AccessToken - The Telegram access token. Value only returned through POST to the action Channel List API, otherwise empty.
	AccessToken *string `json:"accessToken,omitempty"`
	// IsValidated - Whether this channel is validated for the bot
	IsValidated *bool `json:"isValidated,omitempty"`
	// IsEnabled - Whether this channel is enabled for the bot
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// WebChatChannel web Chat channel definition
type WebChatChannel struct {
	// Properties - The set of properties specific to Web Chat channel resource
	Properties *WebChatChannelProperties `json:"properties,omitempty"`
	// ChannelName - Possible values include: 'ChannelNameChannel', 'ChannelNameFacebookChannel1', 'ChannelNameEmailChannel1', 'ChannelNameMsTeamsChannel1', 'ChannelNameSkypeChannel1', 'ChannelNameKikChannel1', 'ChannelNameWebChatChannel1', 'ChannelNameDirectLineChannel1', 'ChannelNameTelegramChannel1', 'ChannelNameSmsChannel1', 'ChannelNameSlackChannel1'
	ChannelName ChannelNameBasicChannel `json:"channelName,omitempty"`
}

// MarshalJSON is the custom marshaler for WebChatChannel.
func (wcc WebChatChannel) MarshalJSON() ([]byte, error) {
	wcc.ChannelName = ChannelNameWebChatChannel1
	objectMap := make(map[string]interface{})
	if wcc.Properties != nil {
		objectMap["properties"] = wcc.Properties
	}
	if wcc.ChannelName != "" {
		objectMap["channelName"] = wcc.ChannelName
	}
	return json.Marshal(objectMap)
}

// AsFacebookChannel is the BasicChannel implementation for WebChatChannel.
func (wcc WebChatChannel) AsFacebookChannel() (*FacebookChannel, bool) {
	return nil, false
}

// AsEmailChannel is the BasicChannel implementation for WebChatChannel.
func (wcc WebChatChannel) AsEmailChannel() (*EmailChannel, bool) {
	return nil, false
}

// AsMsTeamsChannel is the BasicChannel implementation for WebChatChannel.
func (wcc WebChatChannel) AsMsTeamsChannel() (*MsTeamsChannel, bool) {
	return nil, false
}

// AsSkypeChannel is the BasicChannel implementation for WebChatChannel.
func (wcc WebChatChannel) AsSkypeChannel() (*SkypeChannel, bool) {
	return nil, false
}

// AsKikChannel is the BasicChannel implementation for WebChatChannel.
func (wcc WebChatChannel) AsKikChannel() (*KikChannel, bool) {
	return nil, false
}

// AsWebChatChannel is the BasicChannel implementation for WebChatChannel.
func (wcc WebChatChannel) AsWebChatChannel() (*WebChatChannel, bool) {
	return &wcc, true
}

// AsDirectLineChannel is the BasicChannel implementation for WebChatChannel.
func (wcc WebChatChannel) AsDirectLineChannel() (*DirectLineChannel, bool) {
	return nil, false
}

// AsTelegramChannel is the BasicChannel implementation for WebChatChannel.
func (wcc WebChatChannel) AsTelegramChannel() (*TelegramChannel, bool) {
	return nil, false
}

// AsSmsChannel is the BasicChannel implementation for WebChatChannel.
func (wcc WebChatChannel) AsSmsChannel() (*SmsChannel, bool) {
	return nil, false
}

// AsSlackChannel is the BasicChannel implementation for WebChatChannel.
func (wcc WebChatChannel) AsSlackChannel() (*SlackChannel, bool) {
	return nil, false
}

// AsChannel is the BasicChannel implementation for WebChatChannel.
func (wcc WebChatChannel) AsChannel() (*Channel, bool) {
	return nil, false
}

// AsBasicChannel is the BasicChannel implementation for WebChatChannel.
func (wcc WebChatChannel) AsBasicChannel() (BasicChannel, bool) {
	return &wcc, true
}

// WebChatChannelProperties the parameters to provide for the Web Chat channel.
type WebChatChannelProperties struct {
	// WebChatEmbedCode - READ-ONLY; Web chat control embed code
	WebChatEmbedCode *string `json:"webChatEmbedCode,omitempty"`
	// Sites - The list of Web Chat sites
	Sites *[]WebChatSite `json:"sites,omitempty"`
}

// MarshalJSON is the custom marshaler for WebChatChannelProperties.
func (wccp WebChatChannelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wccp.Sites != nil {
		objectMap["sites"] = wccp.Sites
	}
	return json.Marshal(objectMap)
}

// WebChatSite a site for the Webchat channel
type WebChatSite struct {
	// SiteID - READ-ONLY; Site Id
	SiteID *string `json:"siteId,omitempty"`
	// SiteName - Site name
	SiteName *string `json:"siteName,omitempty"`
	// Key - READ-ONLY; Primary key. Value only returned through POST to the action Channel List API, otherwise empty.
	Key *string `json:"key,omitempty"`
	// Key2 - READ-ONLY; Secondary key. Value only returned through POST to the action Channel List API, otherwise empty.
	Key2 *string `json:"key2,omitempty"`
	// IsEnabled - Whether this site is enabled for DirectLine channel
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// EnablePreview - Whether this site is enabled for preview versions of Webchat
	EnablePreview *bool `json:"enablePreview,omitempty"`
}

// MarshalJSON is the custom marshaler for WebChatSite.
func (wcs WebChatSite) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wcs.SiteName != nil {
		objectMap["siteName"] = wcs.SiteName
	}
	if wcs.IsEnabled != nil {
		objectMap["isEnabled"] = wcs.IsEnabled
	}
	if wcs.EnablePreview != nil {
		objectMap["enablePreview"] = wcs.EnablePreview
	}
	return json.Marshal(objectMap)
}
