// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/videointelligence/v1p1beta1/video_intelligence.proto

/*
Package videointelligence is a generated protocol buffer package.

It is generated from these files:
	google/cloud/videointelligence/v1p1beta1/video_intelligence.proto

It has these top-level messages:
	AnnotateVideoRequest
	VideoContext
	LabelDetectionConfig
	ShotChangeDetectionConfig
	ExplicitContentDetectionConfig
	VideoSegment
	LabelSegment
	LabelFrame
	Entity
	LabelAnnotation
	ExplicitContentFrame
	ExplicitContentAnnotation
	NormalizedBoundingBox
	VideoAnnotationResults
	AnnotateVideoResponse
	VideoAnnotationProgress
	AnnotateVideoProgress
	SpeechTranscriptionConfig
	SpeechContext
	SpeechTranscription
	SpeechRecognitionAlternative
	WordInfo
*/
package videointelligence

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf3 "github.com/golang/protobuf/ptypes/duration"
import google_protobuf4 "github.com/golang/protobuf/ptypes/timestamp"
import google_rpc "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Video annotation feature.
type Feature int32

const (
	// Unspecified.
	Feature_FEATURE_UNSPECIFIED Feature = 0
	// Label detection. Detect objects, such as dog or flower.
	Feature_LABEL_DETECTION Feature = 1
	// Shot change detection.
	Feature_SHOT_CHANGE_DETECTION Feature = 2
	// Explicit content detection.
	Feature_EXPLICIT_CONTENT_DETECTION Feature = 3
	// Speech transcription.
	Feature_SPEECH_TRANSCRIPTION Feature = 6
)

var Feature_name = map[int32]string{
	0: "FEATURE_UNSPECIFIED",
	1: "LABEL_DETECTION",
	2: "SHOT_CHANGE_DETECTION",
	3: "EXPLICIT_CONTENT_DETECTION",
	6: "SPEECH_TRANSCRIPTION",
}
var Feature_value = map[string]int32{
	"FEATURE_UNSPECIFIED":        0,
	"LABEL_DETECTION":            1,
	"SHOT_CHANGE_DETECTION":      2,
	"EXPLICIT_CONTENT_DETECTION": 3,
	"SPEECH_TRANSCRIPTION":       6,
}

func (x Feature) String() string {
	return proto.EnumName(Feature_name, int32(x))
}
func (Feature) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// Label detection mode.
type LabelDetectionMode int32

const (
	// Unspecified.
	LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED LabelDetectionMode = 0
	// Detect shot-level labels.
	LabelDetectionMode_SHOT_MODE LabelDetectionMode = 1
	// Detect frame-level labels.
	LabelDetectionMode_FRAME_MODE LabelDetectionMode = 2
	// Detect both shot-level and frame-level labels.
	LabelDetectionMode_SHOT_AND_FRAME_MODE LabelDetectionMode = 3
)

var LabelDetectionMode_name = map[int32]string{
	0: "LABEL_DETECTION_MODE_UNSPECIFIED",
	1: "SHOT_MODE",
	2: "FRAME_MODE",
	3: "SHOT_AND_FRAME_MODE",
}
var LabelDetectionMode_value = map[string]int32{
	"LABEL_DETECTION_MODE_UNSPECIFIED": 0,
	"SHOT_MODE":                        1,
	"FRAME_MODE":                       2,
	"SHOT_AND_FRAME_MODE":              3,
}

func (x LabelDetectionMode) String() string {
	return proto.EnumName(LabelDetectionMode_name, int32(x))
}
func (LabelDetectionMode) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// Bucketized representation of likelihood.
type Likelihood int32

const (
	// Unspecified likelihood.
	Likelihood_LIKELIHOOD_UNSPECIFIED Likelihood = 0
	// Very unlikely.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	// Unlikely.
	Likelihood_UNLIKELY Likelihood = 2
	// Possible.
	Likelihood_POSSIBLE Likelihood = 3
	// Likely.
	Likelihood_LIKELY Likelihood = 4
	// Very likely.
	Likelihood_VERY_LIKELY Likelihood = 5
)

var Likelihood_name = map[int32]string{
	0: "LIKELIHOOD_UNSPECIFIED",
	1: "VERY_UNLIKELY",
	2: "UNLIKELY",
	3: "POSSIBLE",
	4: "LIKELY",
	5: "VERY_LIKELY",
}
var Likelihood_value = map[string]int32{
	"LIKELIHOOD_UNSPECIFIED": 0,
	"VERY_UNLIKELY":          1,
	"UNLIKELY":               2,
	"POSSIBLE":               3,
	"LIKELY":                 4,
	"VERY_LIKELY":            5,
}

func (x Likelihood) String() string {
	return proto.EnumName(Likelihood_name, int32(x))
}
func (Likelihood) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// Video annotation request.
type AnnotateVideoRequest struct {
	// Input video location. Currently, only
	// [Google Cloud Storage](https://cloud.google.com/storage/) URIs are
	// supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more information, see
	// [Request URIs](/storage/docs/reference-uris).
	// A video URI may include wildcards in `object-id`, and thus identify
	// multiple videos. Supported wildcards: '*' to match 0 or more characters;
	// '?' to match 1 character. If unset, the input video should be embedded
	// in the request as `input_content`. If set, `input_content` should be unset.
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri" json:"input_uri,omitempty"`
	// The video data bytes.
	// If unset, the input video(s) should be specified via `input_uri`.
	// If set, `input_uri` should be unset.
	InputContent []byte `protobuf:"bytes,6,opt,name=input_content,json=inputContent,proto3" json:"input_content,omitempty"`
	// Requested video annotation features.
	Features []Feature `protobuf:"varint,2,rep,packed,name=features,enum=google.cloud.videointelligence.v1p1beta1.Feature" json:"features,omitempty"`
	// Additional video context and/or feature-specific parameters.
	VideoContext *VideoContext `protobuf:"bytes,3,opt,name=video_context,json=videoContext" json:"video_context,omitempty"`
	// Optional location where the output (in JSON format) should be stored.
	// Currently, only [Google Cloud Storage](https://cloud.google.com/storage/)
	// URIs are supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more information, see
	// [Request URIs](/storage/docs/reference-uris).
	OutputUri string `protobuf:"bytes,4,opt,name=output_uri,json=outputUri" json:"output_uri,omitempty"`
	// Optional cloud region where annotation should take place. Supported cloud
	// regions: `us-east1`, `us-west1`, `europe-west1`, `asia-east1`. If no region
	// is specified, a region will be determined based on video file location.
	LocationId string `protobuf:"bytes,5,opt,name=location_id,json=locationId" json:"location_id,omitempty"`
}

func (m *AnnotateVideoRequest) Reset()                    { *m = AnnotateVideoRequest{} }
func (m *AnnotateVideoRequest) String() string            { return proto.CompactTextString(m) }
func (*AnnotateVideoRequest) ProtoMessage()               {}
func (*AnnotateVideoRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *AnnotateVideoRequest) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetInputContent() []byte {
	if m != nil {
		return m.InputContent
	}
	return nil
}

func (m *AnnotateVideoRequest) GetFeatures() []Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *AnnotateVideoRequest) GetVideoContext() *VideoContext {
	if m != nil {
		return m.VideoContext
	}
	return nil
}

func (m *AnnotateVideoRequest) GetOutputUri() string {
	if m != nil {
		return m.OutputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetLocationId() string {
	if m != nil {
		return m.LocationId
	}
	return ""
}

// Video context and/or feature-specific parameters.
type VideoContext struct {
	// Video segments to annotate. The segments may overlap and are not required
	// to be contiguous or span the whole video. If unspecified, each video
	// is treated as a single segment.
	Segments []*VideoSegment `protobuf:"bytes,1,rep,name=segments" json:"segments,omitempty"`
	// Config for LABEL_DETECTION.
	LabelDetectionConfig *LabelDetectionConfig `protobuf:"bytes,2,opt,name=label_detection_config,json=labelDetectionConfig" json:"label_detection_config,omitempty"`
	// Config for SHOT_CHANGE_DETECTION.
	ShotChangeDetectionConfig *ShotChangeDetectionConfig `protobuf:"bytes,3,opt,name=shot_change_detection_config,json=shotChangeDetectionConfig" json:"shot_change_detection_config,omitempty"`
	// Config for EXPLICIT_CONTENT_DETECTION.
	ExplicitContentDetectionConfig *ExplicitContentDetectionConfig `protobuf:"bytes,4,opt,name=explicit_content_detection_config,json=explicitContentDetectionConfig" json:"explicit_content_detection_config,omitempty"`
	// Config for SPEECH_TRANSCRIPTION.
	SpeechTranscriptionConfig *SpeechTranscriptionConfig `protobuf:"bytes,6,opt,name=speech_transcription_config,json=speechTranscriptionConfig" json:"speech_transcription_config,omitempty"`
}

func (m *VideoContext) Reset()                    { *m = VideoContext{} }
func (m *VideoContext) String() string            { return proto.CompactTextString(m) }
func (*VideoContext) ProtoMessage()               {}
func (*VideoContext) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *VideoContext) GetSegments() []*VideoSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *VideoContext) GetLabelDetectionConfig() *LabelDetectionConfig {
	if m != nil {
		return m.LabelDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetShotChangeDetectionConfig() *ShotChangeDetectionConfig {
	if m != nil {
		return m.ShotChangeDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetExplicitContentDetectionConfig() *ExplicitContentDetectionConfig {
	if m != nil {
		return m.ExplicitContentDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetSpeechTranscriptionConfig() *SpeechTranscriptionConfig {
	if m != nil {
		return m.SpeechTranscriptionConfig
	}
	return nil
}

// Config for LABEL_DETECTION.
type LabelDetectionConfig struct {
	// What labels should be detected with LABEL_DETECTION, in addition to
	// video-level labels or segment-level labels.
	// If unspecified, defaults to `SHOT_MODE`.
	LabelDetectionMode LabelDetectionMode `protobuf:"varint,1,opt,name=label_detection_mode,json=labelDetectionMode,enum=google.cloud.videointelligence.v1p1beta1.LabelDetectionMode" json:"label_detection_mode,omitempty"`
	// Whether the video has been shot from a stationary (i.e. non-moving) camera.
	// When set to true, might improve detection accuracy for moving objects.
	// Should be used with `SHOT_AND_FRAME_MODE` enabled.
	StationaryCamera bool `protobuf:"varint,2,opt,name=stationary_camera,json=stationaryCamera" json:"stationary_camera,omitempty"`
	// Model to use for label detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,3,opt,name=model" json:"model,omitempty"`
}

func (m *LabelDetectionConfig) Reset()                    { *m = LabelDetectionConfig{} }
func (m *LabelDetectionConfig) String() string            { return proto.CompactTextString(m) }
func (*LabelDetectionConfig) ProtoMessage()               {}
func (*LabelDetectionConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *LabelDetectionConfig) GetLabelDetectionMode() LabelDetectionMode {
	if m != nil {
		return m.LabelDetectionMode
	}
	return LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED
}

func (m *LabelDetectionConfig) GetStationaryCamera() bool {
	if m != nil {
		return m.StationaryCamera
	}
	return false
}

func (m *LabelDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for SHOT_CHANGE_DETECTION.
type ShotChangeDetectionConfig struct {
	// Model to use for shot change detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,1,opt,name=model" json:"model,omitempty"`
}

func (m *ShotChangeDetectionConfig) Reset()                    { *m = ShotChangeDetectionConfig{} }
func (m *ShotChangeDetectionConfig) String() string            { return proto.CompactTextString(m) }
func (*ShotChangeDetectionConfig) ProtoMessage()               {}
func (*ShotChangeDetectionConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *ShotChangeDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for EXPLICIT_CONTENT_DETECTION.
type ExplicitContentDetectionConfig struct {
	// Model to use for explicit content detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,1,opt,name=model" json:"model,omitempty"`
}

func (m *ExplicitContentDetectionConfig) Reset()                    { *m = ExplicitContentDetectionConfig{} }
func (m *ExplicitContentDetectionConfig) String() string            { return proto.CompactTextString(m) }
func (*ExplicitContentDetectionConfig) ProtoMessage()               {}
func (*ExplicitContentDetectionConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *ExplicitContentDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Video segment.
type VideoSegment struct {
	// Time-offset, relative to the beginning of the video,
	// corresponding to the start of the segment (inclusive).
	StartTimeOffset *google_protobuf3.Duration `protobuf:"bytes,1,opt,name=start_time_offset,json=startTimeOffset" json:"start_time_offset,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the end of the segment (inclusive).
	EndTimeOffset *google_protobuf3.Duration `protobuf:"bytes,2,opt,name=end_time_offset,json=endTimeOffset" json:"end_time_offset,omitempty"`
}

func (m *VideoSegment) Reset()                    { *m = VideoSegment{} }
func (m *VideoSegment) String() string            { return proto.CompactTextString(m) }
func (*VideoSegment) ProtoMessage()               {}
func (*VideoSegment) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *VideoSegment) GetStartTimeOffset() *google_protobuf3.Duration {
	if m != nil {
		return m.StartTimeOffset
	}
	return nil
}

func (m *VideoSegment) GetEndTimeOffset() *google_protobuf3.Duration {
	if m != nil {
		return m.EndTimeOffset
	}
	return nil
}

// Video segment level annotation results for label detection.
type LabelSegment struct {
	// Video segment where a label was detected.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment" json:"segment,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence" json:"confidence,omitempty"`
}

func (m *LabelSegment) Reset()                    { *m = LabelSegment{} }
func (m *LabelSegment) String() string            { return proto.CompactTextString(m) }
func (*LabelSegment) ProtoMessage()               {}
func (*LabelSegment) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *LabelSegment) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *LabelSegment) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Video frame level annotation results for label detection.
type LabelFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *google_protobuf3.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset" json:"time_offset,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence" json:"confidence,omitempty"`
}

func (m *LabelFrame) Reset()                    { *m = LabelFrame{} }
func (m *LabelFrame) String() string            { return proto.CompactTextString(m) }
func (*LabelFrame) ProtoMessage()               {}
func (*LabelFrame) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *LabelFrame) GetTimeOffset() *google_protobuf3.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *LabelFrame) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Detected entity from video analysis.
type Entity struct {
	// Opaque entity ID. Some IDs may be available in
	// [Google Knowledge Graph Search
	// API](https://developers.google.com/knowledge-graph/).
	EntityId string `protobuf:"bytes,1,opt,name=entity_id,json=entityId" json:"entity_id,omitempty"`
	// Textual description, e.g. `Fixed-gear bicycle`.
	Description string `protobuf:"bytes,2,opt,name=description" json:"description,omitempty"`
	// Language code for `description` in BCP-47 format.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode" json:"language_code,omitempty"`
}

func (m *Entity) Reset()                    { *m = Entity{} }
func (m *Entity) String() string            { return proto.CompactTextString(m) }
func (*Entity) ProtoMessage()               {}
func (*Entity) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *Entity) GetEntityId() string {
	if m != nil {
		return m.EntityId
	}
	return ""
}

func (m *Entity) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Entity) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Label annotation.
type LabelAnnotation struct {
	// Detected entity.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity" json:"entity,omitempty"`
	// Common categories for the detected entity.
	// E.g. when the label is `Terrier` the category is likely `dog`. And in some
	// cases there might be more than one categories e.g. `Terrier` could also be
	// a `pet`.
	CategoryEntities []*Entity `protobuf:"bytes,2,rep,name=category_entities,json=categoryEntities" json:"category_entities,omitempty"`
	// All video segments where a label was detected.
	Segments []*LabelSegment `protobuf:"bytes,3,rep,name=segments" json:"segments,omitempty"`
	// All video frames where a label was detected.
	Frames []*LabelFrame `protobuf:"bytes,4,rep,name=frames" json:"frames,omitempty"`
}

func (m *LabelAnnotation) Reset()                    { *m = LabelAnnotation{} }
func (m *LabelAnnotation) String() string            { return proto.CompactTextString(m) }
func (*LabelAnnotation) ProtoMessage()               {}
func (*LabelAnnotation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *LabelAnnotation) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *LabelAnnotation) GetCategoryEntities() []*Entity {
	if m != nil {
		return m.CategoryEntities
	}
	return nil
}

func (m *LabelAnnotation) GetSegments() []*LabelSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *LabelAnnotation) GetFrames() []*LabelFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Video frame level annotation results for explicit content.
type ExplicitContentFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *google_protobuf3.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset" json:"time_offset,omitempty"`
	// Likelihood of the pornography content..
	PornographyLikelihood Likelihood `protobuf:"varint,2,opt,name=pornography_likelihood,json=pornographyLikelihood,enum=google.cloud.videointelligence.v1p1beta1.Likelihood" json:"pornography_likelihood,omitempty"`
}

func (m *ExplicitContentFrame) Reset()                    { *m = ExplicitContentFrame{} }
func (m *ExplicitContentFrame) String() string            { return proto.CompactTextString(m) }
func (*ExplicitContentFrame) ProtoMessage()               {}
func (*ExplicitContentFrame) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *ExplicitContentFrame) GetTimeOffset() *google_protobuf3.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *ExplicitContentFrame) GetPornographyLikelihood() Likelihood {
	if m != nil {
		return m.PornographyLikelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

// Explicit content annotation (based on per-frame visual signals only).
// If no explicit content has been detected in a frame, no annotations are
// present for that frame.
type ExplicitContentAnnotation struct {
	// All video frames where explicit content was detected.
	Frames []*ExplicitContentFrame `protobuf:"bytes,1,rep,name=frames" json:"frames,omitempty"`
}

func (m *ExplicitContentAnnotation) Reset()                    { *m = ExplicitContentAnnotation{} }
func (m *ExplicitContentAnnotation) String() string            { return proto.CompactTextString(m) }
func (*ExplicitContentAnnotation) ProtoMessage()               {}
func (*ExplicitContentAnnotation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *ExplicitContentAnnotation) GetFrames() []*ExplicitContentFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Normalized bounding box.
// The normalized vertex coordinates are relative to the original image.
// Range: [0, 1].
type NormalizedBoundingBox struct {
	// Left X coordinate.
	Left float32 `protobuf:"fixed32,1,opt,name=left" json:"left,omitempty"`
	// Top Y coordinate.
	Top float32 `protobuf:"fixed32,2,opt,name=top" json:"top,omitempty"`
	// Right X coordinate.
	Right float32 `protobuf:"fixed32,3,opt,name=right" json:"right,omitempty"`
	// Bottom Y coordinate.
	Bottom float32 `protobuf:"fixed32,4,opt,name=bottom" json:"bottom,omitempty"`
}

func (m *NormalizedBoundingBox) Reset()                    { *m = NormalizedBoundingBox{} }
func (m *NormalizedBoundingBox) String() string            { return proto.CompactTextString(m) }
func (*NormalizedBoundingBox) ProtoMessage()               {}
func (*NormalizedBoundingBox) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *NormalizedBoundingBox) GetLeft() float32 {
	if m != nil {
		return m.Left
	}
	return 0
}

func (m *NormalizedBoundingBox) GetTop() float32 {
	if m != nil {
		return m.Top
	}
	return 0
}

func (m *NormalizedBoundingBox) GetRight() float32 {
	if m != nil {
		return m.Right
	}
	return 0
}

func (m *NormalizedBoundingBox) GetBottom() float32 {
	if m != nil {
		return m.Bottom
	}
	return 0
}

// Annotation results for a single video.
type VideoAnnotationResults struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri" json:"input_uri,omitempty"`
	// Label annotations on video level or user specified segment level.
	// There is exactly one element for each unique label.
	SegmentLabelAnnotations []*LabelAnnotation `protobuf:"bytes,2,rep,name=segment_label_annotations,json=segmentLabelAnnotations" json:"segment_label_annotations,omitempty"`
	// Label annotations on shot level.
	// There is exactly one element for each unique label.
	ShotLabelAnnotations []*LabelAnnotation `protobuf:"bytes,3,rep,name=shot_label_annotations,json=shotLabelAnnotations" json:"shot_label_annotations,omitempty"`
	// Label annotations on frame level.
	// There is exactly one element for each unique label.
	FrameLabelAnnotations []*LabelAnnotation `protobuf:"bytes,4,rep,name=frame_label_annotations,json=frameLabelAnnotations" json:"frame_label_annotations,omitempty"`
	// Shot annotations. Each shot is represented as a video segment.
	ShotAnnotations []*VideoSegment `protobuf:"bytes,6,rep,name=shot_annotations,json=shotAnnotations" json:"shot_annotations,omitempty"`
	// Explicit content annotation.
	ExplicitAnnotation *ExplicitContentAnnotation `protobuf:"bytes,7,opt,name=explicit_annotation,json=explicitAnnotation" json:"explicit_annotation,omitempty"`
	// Speech transcription.
	SpeechTranscriptions []*SpeechTranscription `protobuf:"bytes,11,rep,name=speech_transcriptions,json=speechTranscriptions" json:"speech_transcriptions,omitempty"`
	// If set, indicates an error. Note that for a single `AnnotateVideoRequest`
	// some videos may succeed and some may fail.
	Error *google_rpc.Status `protobuf:"bytes,9,opt,name=error" json:"error,omitempty"`
}

func (m *VideoAnnotationResults) Reset()                    { *m = VideoAnnotationResults{} }
func (m *VideoAnnotationResults) String() string            { return proto.CompactTextString(m) }
func (*VideoAnnotationResults) ProtoMessage()               {}
func (*VideoAnnotationResults) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *VideoAnnotationResults) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationResults) GetSegmentLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.SegmentLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.ShotLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetFrameLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.FrameLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotAnnotations() []*VideoSegment {
	if m != nil {
		return m.ShotAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetExplicitAnnotation() *ExplicitContentAnnotation {
	if m != nil {
		return m.ExplicitAnnotation
	}
	return nil
}

func (m *VideoAnnotationResults) GetSpeechTranscriptions() []*SpeechTranscription {
	if m != nil {
		return m.SpeechTranscriptions
	}
	return nil
}

func (m *VideoAnnotationResults) GetError() *google_rpc.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

// Video annotation response. Included in the `response`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoResponse struct {
	// Annotation results for all videos specified in `AnnotateVideoRequest`.
	AnnotationResults []*VideoAnnotationResults `protobuf:"bytes,1,rep,name=annotation_results,json=annotationResults" json:"annotation_results,omitempty"`
}

func (m *AnnotateVideoResponse) Reset()                    { *m = AnnotateVideoResponse{} }
func (m *AnnotateVideoResponse) String() string            { return proto.CompactTextString(m) }
func (*AnnotateVideoResponse) ProtoMessage()               {}
func (*AnnotateVideoResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *AnnotateVideoResponse) GetAnnotationResults() []*VideoAnnotationResults {
	if m != nil {
		return m.AnnotationResults
	}
	return nil
}

// Annotation progress for a single video.
type VideoAnnotationProgress struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri" json:"input_uri,omitempty"`
	// Approximate percentage processed thus far.
	// Guaranteed to be 100 when fully processed.
	ProgressPercent int32 `protobuf:"varint,2,opt,name=progress_percent,json=progressPercent" json:"progress_percent,omitempty"`
	// Time when the request was received.
	StartTime *google_protobuf4.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// Time of the most recent update.
	UpdateTime *google_protobuf4.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime" json:"update_time,omitempty"`
}

func (m *VideoAnnotationProgress) Reset()                    { *m = VideoAnnotationProgress{} }
func (m *VideoAnnotationProgress) String() string            { return proto.CompactTextString(m) }
func (*VideoAnnotationProgress) ProtoMessage()               {}
func (*VideoAnnotationProgress) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *VideoAnnotationProgress) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationProgress) GetProgressPercent() int32 {
	if m != nil {
		return m.ProgressPercent
	}
	return 0
}

func (m *VideoAnnotationProgress) GetStartTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *VideoAnnotationProgress) GetUpdateTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// Video annotation progress. Included in the `metadata`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoProgress struct {
	// Progress metadata for all videos specified in `AnnotateVideoRequest`.
	AnnotationProgress []*VideoAnnotationProgress `protobuf:"bytes,1,rep,name=annotation_progress,json=annotationProgress" json:"annotation_progress,omitempty"`
}

func (m *AnnotateVideoProgress) Reset()                    { *m = AnnotateVideoProgress{} }
func (m *AnnotateVideoProgress) String() string            { return proto.CompactTextString(m) }
func (*AnnotateVideoProgress) ProtoMessage()               {}
func (*AnnotateVideoProgress) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *AnnotateVideoProgress) GetAnnotationProgress() []*VideoAnnotationProgress {
	if m != nil {
		return m.AnnotationProgress
	}
	return nil
}

// Config for SPEECH_TRANSCRIPTION.
type SpeechTranscriptionConfig struct {
	// *Required* The language of the supplied audio as a
	// [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
	// Example: "en-US".
	// See [Language Support](https://cloud.google.com/speech/docs/languages)
	// for a list of the currently supported language codes.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode" json:"language_code,omitempty"`
	// *Optional* Maximum number of recognition hypotheses to be returned.
	// Specifically, the maximum number of `SpeechRecognitionAlternative` messages
	// within each `SpeechRecognitionResult`. The server may return fewer than
	// `max_alternatives`. Valid values are `0`-`30`. A value of `0` or `1` will
	// return a maximum of one. If omitted, will return a maximum of one.
	MaxAlternatives int32 `protobuf:"varint,2,opt,name=max_alternatives,json=maxAlternatives" json:"max_alternatives,omitempty"`
	// *Optional* If set to `true`, the server will attempt to filter out
	// profanities, replacing all but the initial character in each filtered word
	// with asterisks, e.g. "f***". If set to `false` or omitted, profanities
	// won't be filtered out.
	FilterProfanity bool `protobuf:"varint,3,opt,name=filter_profanity,json=filterProfanity" json:"filter_profanity,omitempty"`
	// *Optional* A means to provide context to assist the speech recognition.
	SpeechContexts []*SpeechContext `protobuf:"bytes,4,rep,name=speech_contexts,json=speechContexts" json:"speech_contexts,omitempty"`
	// *Optional* For file formats, such as MXF or MKV, supporting multiple audio
	// tracks, specify up to two tracks. Default: track 0.
	AudioTracks []int32 `protobuf:"varint,6,rep,packed,name=audio_tracks,json=audioTracks" json:"audio_tracks,omitempty"`
}

func (m *SpeechTranscriptionConfig) Reset()                    { *m = SpeechTranscriptionConfig{} }
func (m *SpeechTranscriptionConfig) String() string            { return proto.CompactTextString(m) }
func (*SpeechTranscriptionConfig) ProtoMessage()               {}
func (*SpeechTranscriptionConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *SpeechTranscriptionConfig) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *SpeechTranscriptionConfig) GetMaxAlternatives() int32 {
	if m != nil {
		return m.MaxAlternatives
	}
	return 0
}

func (m *SpeechTranscriptionConfig) GetFilterProfanity() bool {
	if m != nil {
		return m.FilterProfanity
	}
	return false
}

func (m *SpeechTranscriptionConfig) GetSpeechContexts() []*SpeechContext {
	if m != nil {
		return m.SpeechContexts
	}
	return nil
}

func (m *SpeechTranscriptionConfig) GetAudioTracks() []int32 {
	if m != nil {
		return m.AudioTracks
	}
	return nil
}

// Provides "hints" to the speech recognizer to favor specific words and phrases
// in the results.
type SpeechContext struct {
	// *Optional* A list of strings containing words and phrases "hints" so that
	// the speech recognition is more likely to recognize them. This can be used
	// to improve the accuracy for specific words and phrases, for example, if
	// specific commands are typically spoken by the user. This can also be used
	// to add additional words to the vocabulary of the recognizer. See
	// [usage limits](https://cloud.google.com/speech/limits#content).
	Phrases []string `protobuf:"bytes,1,rep,name=phrases" json:"phrases,omitempty"`
}

func (m *SpeechContext) Reset()                    { *m = SpeechContext{} }
func (m *SpeechContext) String() string            { return proto.CompactTextString(m) }
func (*SpeechContext) ProtoMessage()               {}
func (*SpeechContext) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *SpeechContext) GetPhrases() []string {
	if m != nil {
		return m.Phrases
	}
	return nil
}

// A speech recognition result corresponding to a portion of the audio.
type SpeechTranscription struct {
	// Output only. May contain one or more recognition hypotheses (up to the
	// maximum specified in `max_alternatives`).
	// These alternatives are ordered in terms of accuracy, with the top (first)
	// alternative being the most probable, as ranked by the recognizer.
	Alternatives []*SpeechRecognitionAlternative `protobuf:"bytes,1,rep,name=alternatives" json:"alternatives,omitempty"`
}

func (m *SpeechTranscription) Reset()                    { *m = SpeechTranscription{} }
func (m *SpeechTranscription) String() string            { return proto.CompactTextString(m) }
func (*SpeechTranscription) ProtoMessage()               {}
func (*SpeechTranscription) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *SpeechTranscription) GetAlternatives() []*SpeechRecognitionAlternative {
	if m != nil {
		return m.Alternatives
	}
	return nil
}

// Alternative hypotheses (a.k.a. n-best list).
type SpeechRecognitionAlternative struct {
	// Output only. Transcript text representing the words that the user spoke.
	Transcript string `protobuf:"bytes,1,opt,name=transcript" json:"transcript,omitempty"`
	// Output only. The confidence estimate between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. This field is typically provided only for the top hypothesis, and
	// only for `is_final=true` results. Clients should not rely on the
	// `confidence` field as it is not guaranteed to be accurate or consistent.
	// The default of 0.0 is a sentinel value indicating `confidence` was not set.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence" json:"confidence,omitempty"`
	// Output only. A list of word-specific information for each recognized word.
	Words []*WordInfo `protobuf:"bytes,3,rep,name=words" json:"words,omitempty"`
}

func (m *SpeechRecognitionAlternative) Reset()                    { *m = SpeechRecognitionAlternative{} }
func (m *SpeechRecognitionAlternative) String() string            { return proto.CompactTextString(m) }
func (*SpeechRecognitionAlternative) ProtoMessage()               {}
func (*SpeechRecognitionAlternative) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *SpeechRecognitionAlternative) GetTranscript() string {
	if m != nil {
		return m.Transcript
	}
	return ""
}

func (m *SpeechRecognitionAlternative) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *SpeechRecognitionAlternative) GetWords() []*WordInfo {
	if m != nil {
		return m.Words
	}
	return nil
}

// Word-specific information for recognized words. Word information is only
// included in the response when certain request parameters are set, such
// as `enable_word_time_offsets`.
type WordInfo struct {
	// Output only. Time offset relative to the beginning of the audio, and
	// corresponding to the start of the spoken word. This field is only set if
	// `enable_word_time_offsets=true` and only in the top hypothesis. This is an
	// experimental feature and the accuracy of the time offset can vary.
	StartTime *google_protobuf3.Duration `protobuf:"bytes,1,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// Output only. Time offset relative to the beginning of the audio, and
	// corresponding to the end of the spoken word. This field is only set if
	// `enable_word_time_offsets=true` and only in the top hypothesis. This is an
	// experimental feature and the accuracy of the time offset can vary.
	EndTime *google_protobuf3.Duration `protobuf:"bytes,2,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
	// Output only. The word corresponding to this set of information.
	Word string `protobuf:"bytes,3,opt,name=word" json:"word,omitempty"`
}

func (m *WordInfo) Reset()                    { *m = WordInfo{} }
func (m *WordInfo) String() string            { return proto.CompactTextString(m) }
func (*WordInfo) ProtoMessage()               {}
func (*WordInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *WordInfo) GetStartTime() *google_protobuf3.Duration {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *WordInfo) GetEndTime() *google_protobuf3.Duration {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *WordInfo) GetWord() string {
	if m != nil {
		return m.Word
	}
	return ""
}

func init() {
	proto.RegisterType((*AnnotateVideoRequest)(nil), "google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest")
	proto.RegisterType((*VideoContext)(nil), "google.cloud.videointelligence.v1p1beta1.VideoContext")
	proto.RegisterType((*LabelDetectionConfig)(nil), "google.cloud.videointelligence.v1p1beta1.LabelDetectionConfig")
	proto.RegisterType((*ShotChangeDetectionConfig)(nil), "google.cloud.videointelligence.v1p1beta1.ShotChangeDetectionConfig")
	proto.RegisterType((*ExplicitContentDetectionConfig)(nil), "google.cloud.videointelligence.v1p1beta1.ExplicitContentDetectionConfig")
	proto.RegisterType((*VideoSegment)(nil), "google.cloud.videointelligence.v1p1beta1.VideoSegment")
	proto.RegisterType((*LabelSegment)(nil), "google.cloud.videointelligence.v1p1beta1.LabelSegment")
	proto.RegisterType((*LabelFrame)(nil), "google.cloud.videointelligence.v1p1beta1.LabelFrame")
	proto.RegisterType((*Entity)(nil), "google.cloud.videointelligence.v1p1beta1.Entity")
	proto.RegisterType((*LabelAnnotation)(nil), "google.cloud.videointelligence.v1p1beta1.LabelAnnotation")
	proto.RegisterType((*ExplicitContentFrame)(nil), "google.cloud.videointelligence.v1p1beta1.ExplicitContentFrame")
	proto.RegisterType((*ExplicitContentAnnotation)(nil), "google.cloud.videointelligence.v1p1beta1.ExplicitContentAnnotation")
	proto.RegisterType((*NormalizedBoundingBox)(nil), "google.cloud.videointelligence.v1p1beta1.NormalizedBoundingBox")
	proto.RegisterType((*VideoAnnotationResults)(nil), "google.cloud.videointelligence.v1p1beta1.VideoAnnotationResults")
	proto.RegisterType((*AnnotateVideoResponse)(nil), "google.cloud.videointelligence.v1p1beta1.AnnotateVideoResponse")
	proto.RegisterType((*VideoAnnotationProgress)(nil), "google.cloud.videointelligence.v1p1beta1.VideoAnnotationProgress")
	proto.RegisterType((*AnnotateVideoProgress)(nil), "google.cloud.videointelligence.v1p1beta1.AnnotateVideoProgress")
	proto.RegisterType((*SpeechTranscriptionConfig)(nil), "google.cloud.videointelligence.v1p1beta1.SpeechTranscriptionConfig")
	proto.RegisterType((*SpeechContext)(nil), "google.cloud.videointelligence.v1p1beta1.SpeechContext")
	proto.RegisterType((*SpeechTranscription)(nil), "google.cloud.videointelligence.v1p1beta1.SpeechTranscription")
	proto.RegisterType((*SpeechRecognitionAlternative)(nil), "google.cloud.videointelligence.v1p1beta1.SpeechRecognitionAlternative")
	proto.RegisterType((*WordInfo)(nil), "google.cloud.videointelligence.v1p1beta1.WordInfo")
	proto.RegisterEnum("google.cloud.videointelligence.v1p1beta1.Feature", Feature_name, Feature_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1p1beta1.LabelDetectionMode", LabelDetectionMode_name, LabelDetectionMode_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1p1beta1.Likelihood", Likelihood_name, Likelihood_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for VideoIntelligenceService service

type VideoIntelligenceServiceClient interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
}

type videoIntelligenceServiceClient struct {
	cc *grpc.ClientConn
}

func NewVideoIntelligenceServiceClient(cc *grpc.ClientConn) VideoIntelligenceServiceClient {
	return &videoIntelligenceServiceClient{cc}
}

func (c *videoIntelligenceServiceClient) AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.videointelligence.v1p1beta1.VideoIntelligenceService/AnnotateVideo", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for VideoIntelligenceService service

type VideoIntelligenceServiceServer interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(context.Context, *AnnotateVideoRequest) (*google_longrunning.Operation, error)
}

func RegisterVideoIntelligenceServiceServer(s *grpc.Server, srv VideoIntelligenceServiceServer) {
	s.RegisterService(&_VideoIntelligenceService_serviceDesc, srv)
}

func _VideoIntelligenceService_AnnotateVideo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.videointelligence.v1p1beta1.VideoIntelligenceService/AnnotateVideo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, req.(*AnnotateVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VideoIntelligenceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.videointelligence.v1p1beta1.VideoIntelligenceService",
	HandlerType: (*VideoIntelligenceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AnnotateVideo",
			Handler:    _VideoIntelligenceService_AnnotateVideo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/videointelligence/v1p1beta1/video_intelligence.proto",
}

func init() {
	proto.RegisterFile("google/cloud/videointelligence/v1p1beta1/video_intelligence.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 1838 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x58, 0x4f, 0x6f, 0x23, 0x49,
	0x15, 0xa7, 0xed, 0xc4, 0x89, 0x9f, 0x9d, 0xd8, 0x53, 0x71, 0x12, 0x27, 0x3b, 0x93, 0xc9, 0xf6,
	0x82, 0x94, 0x1d, 0x90, 0x4d, 0xc2, 0x6a, 0x61, 0x67, 0x61, 0x85, 0xe3, 0x74, 0x36, 0x16, 0x19,
	0xdb, 0x2a, 0x7b, 0x02, 0x03, 0x83, 0x9a, 0x4e, 0x77, 0xb9, 0xdd, 0x4c, 0xbb, 0xab, 0xb7, 0xbb,
	0x1c, 0x32, 0x9c, 0x96, 0x3f, 0x12, 0x48, 0x20, 0x2e, 0x23, 0x24, 0x24, 0xbe, 0x00, 0xe2, 0xc8,
	0x17, 0xe0, 0xc2, 0x05, 0xae, 0x9c, 0x90, 0x38, 0xf2, 0x2d, 0xb8, 0xac, 0xba, 0xaa, 0xda, 0x6e,
	0xdb, 0xc9, 0x24, 0x4e, 0x6e, 0x5d, 0xef, 0xd5, 0xfb, 0xbd, 0x3f, 0xf5, 0xde, 0xab, 0x57, 0x0d,
	0x35, 0x9b, 0x52, 0xdb, 0x25, 0x55, 0xd3, 0xa5, 0x43, 0xab, 0x7a, 0xe1, 0x58, 0x84, 0x3a, 0x1e,
	0x23, 0xae, 0xeb, 0xd8, 0xc4, 0x33, 0x49, 0xf5, 0x62, 0xdf, 0xdf, 0x3f, 0x27, 0xcc, 0xd8, 0x17,
	0x3c, 0x3d, 0xc9, 0xac, 0xf8, 0x01, 0x65, 0x14, 0xed, 0x09, 0x88, 0x0a, 0x87, 0xa8, 0xcc, 0x40,
	0x54, 0x46, 0x10, 0xdb, 0x0f, 0xa5, 0x32, 0xc3, 0x77, 0xaa, 0x86, 0xe7, 0x51, 0x66, 0x30, 0x87,
	0x7a, 0xa1, 0xc0, 0xd9, 0x7e, 0x4f, 0x72, 0x5d, 0xea, 0xd9, 0xc1, 0xd0, 0xf3, 0x1c, 0xcf, 0xae,
	0x52, 0x9f, 0x04, 0x13, 0x9b, 0x76, 0xe4, 0x26, 0xbe, 0x3a, 0x1f, 0xf6, 0xaa, 0xd6, 0x50, 0x6c,
	0x90, 0xfc, 0xc7, 0xd3, 0x7c, 0xe6, 0x0c, 0x48, 0xc8, 0x8c, 0x81, 0x2f, 0x37, 0x6c, 0xca, 0x0d,
	0x81, 0x6f, 0x56, 0x43, 0x66, 0xb0, 0xa1, 0x44, 0x56, 0xff, 0x91, 0x82, 0x52, 0x4d, 0x18, 0x45,
	0xce, 0x22, 0x27, 0x30, 0xf9, 0x6c, 0x48, 0x42, 0x86, 0xde, 0x81, 0xac, 0xe3, 0xf9, 0x43, 0xa6,
	0x0f, 0x03, 0xa7, 0xac, 0xec, 0x2a, 0x7b, 0x59, 0xbc, 0xcc, 0x09, 0xcf, 0x03, 0x07, 0xbd, 0x07,
	0x2b, 0x82, 0x69, 0x52, 0x8f, 0x11, 0x8f, 0x95, 0x33, 0xbb, 0xca, 0x5e, 0x1e, 0xe7, 0x39, 0xb1,
	0x2e, 0x68, 0xe8, 0x19, 0x2c, 0xf7, 0x88, 0xc1, 0x86, 0x01, 0x09, 0xcb, 0xa9, 0xdd, 0xf4, 0xde,
	0xea, 0xc1, 0x7e, 0xe5, 0xb6, 0x41, 0xab, 0x1c, 0x0b, 0x49, 0x3c, 0x82, 0x40, 0x3f, 0x82, 0x15,
	0x71, 0x18, 0x5c, 0xe7, 0x25, 0x2b, 0xa7, 0x77, 0x95, 0xbd, 0xdc, 0xc1, 0x87, 0xb7, 0xc7, 0xe4,
	0xfe, 0xd5, 0x85, 0x34, 0xce, 0x5f, 0x24, 0x56, 0xe8, 0x11, 0x00, 0x1d, 0xb2, 0xd8, 0xdd, 0x05,
	0xee, 0x6e, 0x56, 0x50, 0x22, 0x7f, 0x1f, 0x43, 0xce, 0xa5, 0x26, 0x8f, 0xb8, 0xee, 0x58, 0xe5,
	0x45, 0xce, 0x87, 0x98, 0xd4, 0xb0, 0xd4, 0xff, 0x2f, 0x40, 0x3e, 0x09, 0x8f, 0x30, 0x2c, 0x87,
	0xc4, 0x1e, 0x10, 0x8f, 0x85, 0x65, 0x65, 0x37, 0x7d, 0x07, 0x43, 0x3b, 0x42, 0x1c, 0x8f, 0x70,
	0x10, 0x83, 0x0d, 0xd7, 0x38, 0x27, 0xae, 0x6e, 0x11, 0x46, 0x4c, 0x6e, 0x8c, 0x49, 0xbd, 0x9e,
	0x63, 0x97, 0x53, 0x3c, 0x14, 0x9f, 0xdc, 0x5e, 0xc3, 0x69, 0x84, 0x73, 0x14, 0xc3, 0xd4, 0x39,
	0x0a, 0x2e, 0xb9, 0x57, 0x50, 0xd1, 0xaf, 0x15, 0x78, 0x18, 0xf6, 0x29, 0xd3, 0xcd, 0xbe, 0xe1,
	0xd9, 0x64, 0x56, 0xb9, 0x38, 0x87, 0xfa, 0xed, 0x95, 0x77, 0xfa, 0x94, 0xd5, 0x39, 0xd8, 0xb4,
	0x05, 0x5b, 0xe1, 0x75, 0x2c, 0xf4, 0x46, 0x81, 0x77, 0xc9, 0xa5, 0xef, 0x3a, 0xa6, 0x33, 0x4a,
	0xbb, 0x59, 0x5b, 0x16, 0xb8, 0x2d, 0x27, 0xb7, 0xb7, 0x45, 0x93, 0x90, 0x32, 0x69, 0xa7, 0x0d,
	0xda, 0x21, 0x6f, 0xe5, 0xa3, 0x5f, 0x29, 0xf0, 0x4e, 0xe8, 0x13, 0x62, 0xf6, 0x75, 0x16, 0x18,
	0x5e, 0x68, 0x06, 0x8e, 0x9f, 0xb4, 0x27, 0x33, 0x77, 0x6c, 0x38, 0x58, 0x37, 0x89, 0x35, 0x8a,
	0xcd, 0x75, 0x2c, 0xf5, 0x9f, 0x0a, 0x94, 0xae, 0x3a, 0x51, 0xe4, 0x41, 0x69, 0x3a, 0x63, 0x06,
	0xd4, 0x22, 0xbc, 0x9e, 0x57, 0x0f, 0xbe, 0x7d, 0xd7, 0x7c, 0x79, 0x46, 0x2d, 0x82, 0x91, 0x3b,
	0x43, 0x43, 0x5f, 0x85, 0x07, 0xa1, 0x68, 0x6f, 0x46, 0xf0, 0x5a, 0x37, 0x8d, 0x01, 0x09, 0x0c,
	0x9e, 0x9c, 0xcb, 0xb8, 0x38, 0x66, 0xd4, 0x39, 0x1d, 0x95, 0x60, 0x31, 0x32, 0xc6, 0xe5, 0x09,
	0x94, 0xc5, 0x62, 0xa1, 0xee, 0xc3, 0xd6, 0xb5, 0xf9, 0x31, 0x16, 0x51, 0x92, 0x22, 0x1f, 0xc2,
	0xce, 0xdb, 0x8f, 0xf1, 0x1a, 0xb9, 0x3f, 0x29, 0xb2, 0x68, 0x65, 0xa9, 0x21, 0x8d, 0x9b, 0x1f,
	0x30, 0x3d, 0x6a, 0x9f, 0x3a, 0xed, 0xf5, 0x42, 0xc2, 0xb8, 0x48, 0xee, 0x60, 0x2b, 0x8e, 0x55,
	0xdc, 0x62, 0x2b, 0x47, 0xb2, 0x05, 0xe3, 0x02, 0x97, 0xe9, 0x3a, 0x03, 0xd2, 0xe2, 0x12, 0xa8,
	0x06, 0x05, 0xe2, 0x59, 0x13, 0x20, 0xa9, 0x9b, 0x40, 0x56, 0x88, 0x67, 0x8d, 0x21, 0xd4, 0xcf,
	0x15, 0xc8, 0xf3, 0x98, 0xc7, 0xa6, 0xb5, 0x61, 0x49, 0xf6, 0x01, 0x69, 0xd0, 0x5d, 0xdb, 0x49,
	0x0c, 0x83, 0x76, 0x00, 0x78, 0x92, 0x5a, 0xd1, 0x6e, 0x6e, 0x60, 0x0a, 0x27, 0x28, 0x6a, 0x1f,
	0x80, 0x5b, 0x70, 0x1c, 0x18, 0x03, 0x82, 0x9e, 0x42, 0x6e, 0xae, 0xa0, 0x00, 0x1b, 0xc7, 0xe3,
	0x26, 0x4d, 0x2e, 0x64, 0x34, 0x8f, 0x39, 0xec, 0x75, 0x74, 0xe9, 0x10, 0xfe, 0x15, 0x75, 0x59,
	0x79, 0xe9, 0x08, 0x42, 0xc3, 0x42, 0xbb, 0x90, 0xb3, 0xc8, 0x28, 0xf5, 0x39, 0x4e, 0x16, 0x27,
	0x49, 0xd1, 0xb5, 0xe4, 0x1a, 0x9e, 0x3d, 0x34, 0x6c, 0xa2, 0x9b, 0x51, 0x9e, 0x8b, 0xcc, 0xca,
	0xc7, 0xc4, 0x3a, 0xb5, 0x88, 0xfa, 0xdf, 0x14, 0x14, 0xb8, 0x63, 0xb5, 0xd1, 0x5d, 0x8c, 0x4e,
	0x20, 0x23, 0xd4, 0x48, 0xc7, 0xbe, 0x3e, 0x47, 0x03, 0xe1, 0x72, 0x58, 0xca, 0xa3, 0x1f, 0xc3,
	0x03, 0xd3, 0x60, 0xc4, 0xa6, 0xc1, 0x6b, 0x9d, 0x93, 0x1c, 0x79, 0xfb, 0xdd, 0x05, 0xb4, 0x18,
	0x43, 0x69, 0x12, 0x69, 0xe2, 0x5a, 0x49, 0xcf, 0x7b, 0xad, 0x24, 0x13, 0x2a, 0x71, 0xad, 0x9c,
	0x42, 0xa6, 0x17, 0x9d, 0x71, 0x58, 0x5e, 0xe0, 0x88, 0x1f, 0xcc, 0x89, 0xc8, 0x13, 0x04, 0x4b,
	0x0c, 0xf5, 0xef, 0x0a, 0x94, 0xa6, 0xaa, 0xf1, 0xfe, 0x19, 0xf4, 0x0a, 0x36, 0x7c, 0x1a, 0x78,
	0xd4, 0x0e, 0x0c, 0xbf, 0xff, 0x5a, 0x77, 0x9d, 0x57, 0xc4, 0x75, 0xfa, 0x94, 0x5a, 0x3c, 0x0b,
	0x56, 0xe7, 0x32, 0x79, 0x24, 0x8b, 0xd7, 0x13, 0x98, 0x63, 0xb2, 0x1a, 0xc2, 0xd6, 0x94, 0x03,
	0x89, 0x4c, 0x39, 0x1b, 0x05, 0x4b, 0xdc, 0xea, 0x9f, 0xdc, 0xf9, 0xaa, 0x99, 0x0c, 0xdb, 0x2b,
	0x58, 0x6f, 0xd2, 0x60, 0x60, 0xb8, 0xce, 0xcf, 0x89, 0x75, 0x48, 0x87, 0x9e, 0xe5, 0x78, 0xf6,
	0x21, 0xbd, 0x44, 0x08, 0x16, 0x5c, 0xd2, 0x13, 0xf1, 0x4a, 0x61, 0xfe, 0x8d, 0x8a, 0x90, 0x66,
	0xd4, 0x97, 0x95, 0x14, 0x7d, 0x46, 0x0d, 0x2e, 0x70, 0xec, 0xbe, 0x18, 0x8a, 0x52, 0x58, 0x2c,
	0xd0, 0x06, 0x64, 0xce, 0x29, 0x63, 0x74, 0xc0, 0xef, 0xc5, 0x14, 0x96, 0x2b, 0xf5, 0x37, 0x19,
	0xd8, 0xe0, 0x4d, 0x61, 0xec, 0x18, 0x26, 0xe1, 0xd0, 0x65, 0xe1, 0xdb, 0xc7, 0xbe, 0x21, 0x6c,
	0xc9, 0xac, 0xd1, 0xc5, 0xb5, 0x92, 0x18, 0x67, 0x65, 0x92, 0x7f, 0x34, 0x67, 0xf2, 0x24, 0x2c,
	0xd8, 0x94, 0xd8, 0x53, 0xf4, 0x10, 0x51, 0xd8, 0xe0, 0x03, 0xc8, 0xac, 0xce, 0xf4, 0x7d, 0x75,
	0x96, 0x22, 0xe0, 0x19, 0x85, 0x9f, 0xc1, 0x26, 0x3f, 0x96, 0x2b, 0x34, 0x2e, 0xdc, 0x57, 0xe3,
	0x3a, 0x47, 0x9e, 0x51, 0x69, 0x40, 0x91, 0xfb, 0x98, 0xd4, 0x95, 0xb9, 0xd7, 0xdc, 0x58, 0x88,
	0xf0, 0x92, 0x2a, 0x18, 0xac, 0x8d, 0x06, 0xa8, 0xb1, 0x9a, 0xf2, 0xd2, 0xbc, 0x23, 0xca, 0xb5,
	0xc5, 0x81, 0x51, 0x8c, 0x9f, 0x28, 0x98, 0x00, 0xd6, 0xaf, 0x1a, 0x90, 0xc2, 0x72, 0x8e, 0x7b,
	0xf7, 0x9d, 0x7b, 0x8d, 0x46, 0xb8, 0x74, 0xc5, 0x50, 0x14, 0xa2, 0x3d, 0x58, 0x24, 0x41, 0x40,
	0x83, 0x72, 0x96, 0xfb, 0x86, 0x62, 0x1d, 0x81, 0x6f, 0x56, 0x3a, 0xfc, 0xf5, 0x83, 0xc5, 0x06,
	0xf5, 0xb7, 0x0a, 0xac, 0x4f, 0x3d, 0x7f, 0x42, 0x9f, 0x7a, 0x21, 0x41, 0x14, 0xd0, 0x38, 0x48,
	0x7a, 0x20, 0xca, 0x43, 0x16, 0xfd, 0x77, 0xe7, 0x3c, 0x92, 0x99, 0x32, 0xc3, 0x0f, 0x8c, 0x69,
	0x92, 0xfa, 0x1f, 0x05, 0x36, 0xa7, 0x76, 0xb7, 0x03, 0x6a, 0x07, 0x24, 0xbc, 0xa1, 0x2a, 0xdf,
	0x87, 0xa2, 0x2f, 0x37, 0xea, 0x3e, 0x09, 0xcc, 0x68, 0x46, 0x88, 0x5a, 0xc3, 0x22, 0x2e, 0xc4,
	0xf4, 0xb6, 0x20, 0xa3, 0x8f, 0x00, 0xc6, 0x03, 0x8e, 0x1c, 0xdc, 0xb7, 0x67, 0x5a, 0x70, 0x37,
	0x7e, 0x3c, 0xe2, 0xec, 0x68, 0xb4, 0x41, 0x1f, 0x43, 0x6e, 0xe8, 0x5b, 0x06, 0x23, 0x42, 0x76,
	0xe1, 0x46, 0x59, 0x10, 0xdb, 0x23, 0x82, 0xfa, 0xbb, 0xe9, 0x30, 0x8f, 0x3c, 0x0b, 0x60, 0x2d,
	0x11, 0xe6, 0xd8, 0x5e, 0x19, 0xe7, 0xda, 0x9d, 0xe3, 0x1c, 0xe3, 0xe3, 0xc4, 0x21, 0xc6, 0x34,
	0xf5, 0xcf, 0x29, 0xd8, 0xba, 0x76, 0xce, 0x9e, 0x1d, 0x22, 0x94, 0xd9, 0x21, 0x22, 0x8a, 0xf9,
	0xc0, 0xb8, 0xd4, 0x0d, 0x97, 0x91, 0xc0, 0x33, 0x98, 0x73, 0xc1, 0x6f, 0x79, 0x1e, 0xf3, 0x81,
	0x71, 0x59, 0x4b, 0x90, 0xa3, 0xad, 0x3d, 0x27, 0x22, 0x44, 0xde, 0xf5, 0x0c, 0x2f, 0x9a, 0x32,
	0xd2, 0x7c, 0x24, 0x2e, 0x08, 0x7a, 0x3b, 0x26, 0xa3, 0x9f, 0x40, 0x41, 0xd6, 0x8a, 0x7c, 0xe3,
	0xc6, 0xfd, 0xe6, 0x9b, 0xf3, 0x56, 0x49, 0xfc, 0xca, 0x5d, 0x0d, 0x93, 0xcb, 0x10, 0xbd, 0x0b,
	0x79, 0x63, 0x68, 0x39, 0x34, 0x2a, 0x46, 0xf3, 0x95, 0x68, 0x31, 0x8b, 0x38, 0xc7, 0x69, 0x5d,
	0x4e, 0x52, 0xdf, 0x87, 0x95, 0x09, 0x0c, 0x54, 0x86, 0x25, 0xbf, 0x1f, 0x18, 0xa1, 0xbc, 0xf3,
	0xb2, 0x38, 0x5e, 0xaa, 0xbf, 0x50, 0x60, 0xed, 0x8a, 0x40, 0xa2, 0x9f, 0x42, 0x7e, 0x22, 0x32,
	0xe2, 0x34, 0x8f, 0xe7, 0x75, 0x02, 0x13, 0x93, 0xda, 0x9e, 0x13, 0x41, 0x26, 0x22, 0x8a, 0x27,
	0xb0, 0xd5, 0xbf, 0x28, 0xf0, 0xf0, 0x6d, 0xdb, 0xa3, 0xe9, 0x73, 0xdc, 0x79, 0xe4, 0x61, 0x26,
	0x28, 0x37, 0x4d, 0xa7, 0xe8, 0x04, 0x16, 0x7f, 0x46, 0x03, 0x2b, 0xbe, 0x6c, 0x0e, 0x6e, 0xef,
	0xc5, 0xf7, 0x69, 0x60, 0x35, 0xbc, 0x1e, 0xc5, 0x02, 0x40, 0xfd, 0x83, 0x02, 0xcb, 0x31, 0x0d,
	0x7d, 0x6b, 0xa2, 0x14, 0x6f, 0x9c, 0x86, 0x12, 0x95, 0xf8, 0x01, 0x2c, 0xc7, 0xcf, 0x8b, 0x9b,
	0xdf, 0x15, 0x4b, 0xf2, 0x5d, 0x11, 0xcd, 0x11, 0x91, 0x15, 0x72, 0x24, 0xe6, 0xdf, 0x4f, 0x7e,
	0xaf, 0xc0, 0x92, 0xfc, 0xd1, 0x82, 0x36, 0x61, 0xed, 0x58, 0xab, 0x75, 0x9f, 0x63, 0x4d, 0x7f,
	0xde, 0xec, 0xb4, 0xb5, 0x7a, 0xe3, 0xb8, 0xa1, 0x1d, 0x15, 0xbf, 0x84, 0xd6, 0xa0, 0x70, 0x5a,
	0x3b, 0xd4, 0x4e, 0xf5, 0x23, 0xad, 0xab, 0xd5, 0xbb, 0x8d, 0x56, 0xb3, 0xa8, 0xa0, 0x2d, 0x58,
	0xef, 0x9c, 0xb4, 0xba, 0x7a, 0xfd, 0xa4, 0xd6, 0xfc, 0x54, 0x4b, 0xb0, 0x52, 0x68, 0x07, 0xb6,
	0xb5, 0x1f, 0xb4, 0x4f, 0x1b, 0xf5, 0x46, 0x57, 0xaf, 0xb7, 0x9a, 0x5d, 0xad, 0xd9, 0x4d, 0xf0,
	0xd3, 0xa8, 0x0c, 0xa5, 0x4e, 0x5b, 0xd3, 0xea, 0x27, 0x7a, 0x17, 0xd7, 0x9a, 0x9d, 0x3a, 0x6e,
	0xb4, 0x39, 0x27, 0xf3, 0x24, 0x00, 0x34, 0xfb, 0xce, 0x44, 0x5f, 0x86, 0xdd, 0x29, 0xfd, 0xfa,
	0xb3, 0xd6, 0xd1, 0xb4, 0x95, 0x2b, 0x90, 0xe5, 0x06, 0x45, 0xac, 0xa2, 0x82, 0x56, 0x01, 0x8e,
	0x71, 0xed, 0x99, 0x26, 0xd6, 0xa9, 0xc8, 0x3b, 0xce, 0xae, 0x35, 0x8f, 0xf4, 0x04, 0x23, 0xfd,
	0x84, 0x01, 0x8c, 0x47, 0x3f, 0xb4, 0x0d, 0x1b, 0xa7, 0x8d, 0xef, 0x69, 0xa7, 0x8d, 0x93, 0x56,
	0xeb, 0x68, 0x4a, 0xc3, 0x03, 0x58, 0x39, 0xd3, 0xf0, 0x0b, 0xfd, 0x79, 0x93, 0x6f, 0x79, 0x51,
	0x54, 0x50, 0x1e, 0x96, 0x47, 0xab, 0x54, 0xb4, 0x6a, 0xb7, 0x3a, 0x9d, 0xc6, 0xe1, 0xa9, 0x56,
	0x4c, 0x23, 0x80, 0x8c, 0xe4, 0x2c, 0xa0, 0x02, 0xe4, 0xb8, 0xa8, 0x24, 0x2c, 0x1e, 0xfc, 0x4d,
	0x81, 0x32, 0xef, 0x58, 0x8d, 0x44, 0xe6, 0x74, 0x48, 0x70, 0xe1, 0x98, 0x04, 0xfd, 0x51, 0x81,
	0x95, 0x89, 0x66, 0x89, 0xe6, 0x18, 0x32, 0xaf, 0xfa, 0x97, 0xb7, 0xfd, 0x28, 0x96, 0x4f, 0xfc,
	0x64, 0xac, 0xb4, 0xe2, 0x9f, 0x8c, 0xea, 0x57, 0x7e, 0xf9, 0xef, 0xff, 0xbd, 0x49, 0x3d, 0x56,
	0xb7, 0xa7, 0xff, 0x7b, 0x86, 0x4f, 0x65, 0xf7, 0x24, 0x4f, 0x95, 0x27, 0x87, 0x9f, 0xa7, 0xe0,
	0x6b, 0x26, 0x1d, 0xdc, 0xda, 0x96, 0xc3, 0x47, 0xd7, 0xb9, 0xd8, 0x8e, 0xd2, 0xb4, 0xad, 0xfc,
	0xf0, 0x85, 0x84, 0xb2, 0x69, 0xd4, 0x5c, 0x2b, 0x34, 0xb0, 0xab, 0x36, 0xf1, 0x78, 0x12, 0x57,
	0x05, 0xcb, 0xf0, 0x9d, 0xf0, 0xe6, 0xbf, 0xb4, 0x1f, 0xcf, 0xf0, 0xfe, 0x9a, 0xda, 0xfb, 0x54,
	0x60, 0xd7, 0xb9, 0x99, 0x33, 0x96, 0x54, 0xce, 0xf6, 0xdb, 0xfb, 0x87, 0x91, 0xf0, 0xbf, 0xe2,
	0xad, 0x2f, 0xf9, 0xd6, 0x97, 0x33, 0x5b, 0x5f, 0x9e, 0xc5, 0x7a, 0xce, 0x33, 0xdc, 0xb6, 0x6f,
	0x7c, 0x11, 0x00, 0x00, 0xff, 0xff, 0xf4, 0xad, 0xf2, 0x59, 0x40, 0x16, 0x00, 0x00,
}
